<?php
/*
This script is developed by Arturs Sosins aka ar2rsawseen, http://code-snippets.co.cc
Fee free to distribute and modify code, but keep reference to its creator

This class can create user friendly interface to browse PhonesComplete user generated mobile phone database
and perform searches for different phone models based on parameter values using PhonesComplete API
*/
class mobile_phones
{
	//array for storing some data localy for better performance
	private $all_val = array();
	
	//get all parameter list
	public function get_param_list(){
		if(!empty($this->all_val))
		{
			$vals = $this->all_val;
		}
		else
		{
			$vals = $this->request("http://phonescomplete.com/phones.xml");
			$this->all_val = $vals;
		}
		$params = array();
		foreach($vals as $xml)
		{
			if(isset($xml['level']) && $xml['level'] == 3)
			{
				$xml['tag'] = strtolower(str_replace("-", "_", $xml['tag']));
				if(!in_array($xml['tag'], $params))
				{
					$params[] = $xml['tag'];
				}
			}
		}
		return $params;
	}
	//get all values for specified parameter
	public function get_all_values($param_name){
		if(!empty($this->all_val))
		{
			$vals = $this->all_val;
		}
		else
		{
			$vals = $this->request("http://phonescomplete.com/phones.xml");
			$this->all_val = $vals;
		}
		$params = array();
		foreach($vals as $xml)
		{
			if(isset($xml['value']) && trim($xml['value']) != "")
			{
				$xml['tag'] = strtolower(str_replace("-", "_", $xml['tag']));
				if($xml['tag'] == $param_name && !in_array($xml['value'], $params))
				{
					$params[] = $xml['value'];
				}
			}
		}
		return $params;
	}
	//make request url based on array with values
	//where keys are parameter names and values are values of parameter
	//optionally, you can provide array with parameter names to exclude from searching
	//empty parameters are excluded autmatically
	//if value is array, then it is used as from .. to value
	public function make_url($arr, $ex = array()){
		$url = 'http://phonescomplete.com/phones/search.xml?';
		$query_string = '';
		foreach($arr as $key => $val)
		{
			if(!in_array($key, $ex))
			{
				if(is_array($val))
				{
					if(!empty($val[0]) || !empty($val[1]))
					{
						$query_string .= $this->from_to($val, $key);
					}
				}
				else if(trim($val) != "")
				{
					$query_string .= "&".$key."=".urlencode($val);
				}
			}
		}
		$vals = $url.substr($query_string, 1);
		return $vals;
	}
	//get information about phone, based on it's cached_slug parameter
	public function get_phone($cached_slug, $xml = false){
		$vals = $this->request("http://phonescomplete.com/phones/".$cached_slug.".xml", $xml);
		$arr = array();
		foreach($vals as $param)
		{
			if($param['level'] == 2 && isset($param['value']))
			{
				$arr[strtolower(str_replace("-", "_", $param['tag']))] = $param['value'];
			}
		}
		return $arr;
	}
	//generate from to url part
	public function from_to($arr, $param_name){
		$vals = $this->get_all_values($param_name);
		sort($vals);
		$url = "";
		if(empty($arr[0]))
		{
			$arr[0] = current($vals);
		}
		if(empty($arr[sizeof($arr)-1]))
		{
			$arr[1] = end($vals);
		}
		foreach($vals as $val)
		{
			if($arr[0] <= $val && $arr[1] >= $val)
			{
				$url .= "&".$param_name."[]=".urlencode($val);
			}
		}
		return $url;
	}
	//perform search with specified url
	public function search($url, $xml = false){
		$data = $this->request($url, $xml);
		if($xml)
		{
			return $xml;
		}
		else
		{
			$arr = array();
			$phone = array();
			foreach($data as $info)
			{
				if($info['level'] == 2 && $info['tag'] == "PHONE")
				{
					if($info['type'] == "open")
					{
						$phone = array();
					}
					else if($info['type'] == "close")
					{
						$arr[] = $phone;
					}
				}
				else if($info['level'] == 3 && isset($info['value']))
				{
					$phone[strtolower(str_replace("-", "_", $info['tag']))] = $info['value'];
				}
			}
			return $arr;
		}
	}
	//performing a request
	public function request($url, $xml = false){
		$curl = curl_init();
		curl_setopt($curl, CURLOPT_URL, $url);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
		$data = curl_exec($curl);
		curl_close($curl);
		if($xml)
		{
			return $data;
		}
		else
		{
			$xml_parser = xml_parser_create();
			xml_parse_into_struct($xml_parser, $data, $vals, $index);
			xml_parser_free($xml_parser);
			return $vals;
		}
	}
	
}
?>