<?php
 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */

class CTMobile_WS_Logout extends CTMobile_WS_Controller {
	
	function process(CTMobile_API_Request $request) {
		global $adb, $current_user;
		$current_user = $this->getActiveUser();
		$user_name = $current_user->user_name;
		$userid = $current_user->id;
		// devicetoken will be blank of current user
		$query = "UPDATE ctmobile_userdevicetoken SET devicetoken = '', sessionid = '' WHERE userid = ?";
		$adb->pquery($query,array($userid));
		$response = new CTMobile_API_Response();
		session_regenerate_id(true);
		Vtiger_Session::destroy();
		
		//Track the logout History
		$userIPAddress = $_SERVER['REMOTE_ADDR'];
		$outtime = date("Y-m-d H:i:s");

		$loginIdQuery = "SELECT MAX(login_id) AS login_id FROM ctmobile_loginhistory WHERE user_name=? AND user_ip=?";
		$result = $adb->pquery($loginIdQuery, array($user_name, $userIPAddress));
		$loginid = $adb->query_result($result,0,"login_id");

		if (!empty($loginid)){
			$query = "UPDATE ctmobile_loginhistory SET logout_time =?, status=? WHERE login_id = ?";
			$result = $adb->pquery($query, array($outtime, 'Signed off', $loginid));
		}
		$message =  $this->CTTranslate('Logout Successfully');
		$result =  array('code' => 1,'message' => $message);
		$response->setResult($result);
		return $response;
	}
}
