<?php
/*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */

require_once('data/CRMEntity.php');
require_once('data/Tracker.php');
require_once 'vtlib/Vtiger/Module.php';

class CTMobileSettings extends CRMEntity {
    /**
     * Invoked when special actions are performed on the module.
     * @param String Module name
     * @param String Event Type (module.postinstall, module.disabled, module.enabled, module.preuninstall)
     */
    function vtlib_handler($modulename, $event_type) {
        if($event_type == 'module.postinstall') {
            self::addWidgetTo();
            self::iniData(); 
            self::CTmobileUserAccess();   
            self::languageInit();
            self::sectionInit();     
        } else if($event_type == 'module.disabled') {
            // TODO Handle actions when this module is disabled.
            self::removeWidgetTo();
        } else if($event_type == 'module.enabled') {
            // TODO Handle actions when this module is enabled.
            self::addWidgetTo();
        } else if($event_type == 'module.preuninstall') {
			self::removeWidgetTo();
            // TODO Handle actions when this module is about to be deleted.
        } else if($event_type == 'module.preupdate') {
            // TODO Handle actions before this module is updated.
        } else if($event_type == 'module.postupdate') {
            self::addWidgetTo(); 
			self::CTmobileUserAccess();
            self::languageInit();
            self::sectionInit();
        }
    }
    
    static function sectionInit() {
        global $adb;
        $sectionCheck = $adb->pquery('DELETE FROM ctmobile_language_section',array());
        $adb->pquery("INSERT INTO `ctmobile_language_section` (`section_id`, `section_name`) VALUES
                (1, 'Common Message'),
                (2, 'Login Screen'),
                (3, 'Forgot Password Screen'),
                (4, 'Email Screen'),
                (5, 'Add/Edit Record'),
                (6, 'CoverLead Screen'),
                (7, 'Calender screen'),
                (8, 'Setting Screen'),
                (9, 'Module Setting screen'),
                (10, 'Line item Screen'),
                (11, 'Detail Screen'),
                (12, 'Summary Details screen'),
                (13, 'NearBy screen'),
                (14, 'Email Detail Screen'),
                (15, 'Home Screen'),
                (16, 'FeedBack Screen'),
                (17, 'EmailTemplate Screen'),
                (18, 'UserFilterView Screen'),
                (19, 'Activity Setting'),
                (20, 'SMS Send Screen'),
                (21, 'Global Search screen'),
                (22, 'App Introduction screen'),
                (23, 'Drive Record screen'),
                (24, 'ReportBug screen'),
                (25, 'Shortcut screen'),
                (26, 'Check URL screen'),
                (27, 'List Screen'),
                (28, 'Card Scanner Screen'),
                (29, 'Other Message'),
                (30, 'Route Planning Screen'),
                (31, 'Time Tracking Screen'),
                (32, 'CTMobile Messages');",array());
    }
    
    static function iniData() {
        global $adb;
        $allModules = Vtiger_Module_Model::getSearchableModules();
        $searchModules=array_keys($allModules);
        foreach($searchModules as $module) {
            $adb->pquery("INSERT INTO `ctmobile_address_modules` (`module`, `active`) VALUES (?, ?)",array($module,'1'));
        }
        //Insert Contact Address Fields
        $adb->pquery("INSERT INTO ctmobile_address_fields (module,fieldname) VALUES (?,?)",array("Contacts","vtiger_contactaddress:mailingstreet:mailingstreet:Contacts_Mailing_Street:V"));
		$adb->pquery("INSERT INTO ctmobile_address_fields (module,fieldname) VALUES (?,?)",array("Contacts","vtiger_contactaddress:mailingcity:mailingcity:Contacts_Mailing_City:V"));
		$adb->pquery("INSERT INTO ctmobile_address_fields (module,fieldname) VALUES (?,?)",array("Contacts","vtiger_contactaddress:mailingstate:mailingstate:Contacts_Mailing_State:V"));
		$adb->pquery("INSERT INTO ctmobile_address_fields (module,fieldname) VALUES (?,?)",array("Contacts","vtiger_contactaddress:mailingcountry:mailingcountry:Contacts_Mailing_Country:V"));
		$adb->pquery("INSERT INTO ctmobile_address_fields (module,fieldname) VALUES (?,?)",array("Contacts","vtiger_contactaddress:mailingzip:mailingzip:Contacts_Mailing_Zip:V"));
		//Insert Accounts Address Fields
		$adb->pquery("INSERT INTO ctmobile_address_fields (module,fieldname) VALUES (?,?)",array("Accounts","vtiger_accountshipads:ship_street:ship_street:Accounts_Shipping_Address:V"));
		$adb->pquery("INSERT INTO ctmobile_address_fields (module,fieldname) VALUES (?,?)",array("Accounts","vtiger_accountshipads:ship_city:ship_city:Accounts_Shipping_City:V"));
		$adb->pquery("INSERT INTO ctmobile_address_fields (module,fieldname) VALUES (?,?)",array("Accounts","vtiger_accountshipads:ship_state:ship_state:Accounts_Shipping_State:V"));
		$adb->pquery("INSERT INTO ctmobile_address_fields (module,fieldname) VALUES (?,?)",array("Accounts","vtiger_accountshipads:ship_country:ship_country:Accounts_Shipping_Country:V"));
		$adb->pquery("INSERT INTO ctmobile_address_fields (module,fieldname) VALUES (?,?)",array("Accounts","vtiger_accountshipads:ship_code:ship_code:Accounts_Shipping_Code:V"));
		//Insert Leads Address Fields
		$adb->pquery("INSERT INTO ctmobile_address_fields (module,fieldname) VALUES (?,?)",array("Leads","vtiger_leadaddress:lane:lane:Leads_Street:V"));
		$adb->pquery("INSERT INTO ctmobile_address_fields (module,fieldname) VALUES (?,?)",array("Leads","vtiger_leadaddress:city:city:Leads_City:V"));
		$adb->pquery("INSERT INTO ctmobile_address_fields (module,fieldname) VALUES (?,?)",array("Leads","vtiger_leadaddress:state:state:Leads_State:V"));
		$adb->pquery("INSERT INTO ctmobile_address_fields (module,fieldname) VALUES (?,?)",array("Leads","vtiger_leadaddress:country:country:Leads_Country:V"));
		$adb->pquery("INSERT INTO ctmobile_address_fields (module,fieldname) VALUES (?,?)",array("Leads","vtiger_leadaddress:code:code:Leads_Postal_Code:V"));
		//Insert Calendar Address Fields
		$adb->pquery("INSERT INTO ctmobile_address_fields (module,fieldname) VALUES (?,?)",array("Calendar","vtiger_activity:location:location:Events_Location:V"));
		
    }

    static function languageInit(){
        global $adb;
        $AllLanguage = Vtiger_Language::getAll();
        foreach ($AllLanguage as $language => $langname) {
              if($language == 'es_es'){
                self::es_es();
              }else if($language == 'es_mx'){
                self::es_mx();
              }else if($language == 'he_il'){
                self::he_il();
              }else if($language == 'ar_ae'){
                self::ar_ae();
              }else if($language == 'it_it'){
                self::it_it();
              }else if($language == 'ja_jp'){
                self::ja_jp();
              }else if($language == 'zh_cn'){
                self::zh_cn();
              }else if($language == 'de_de'){
                self::de_de();
              }else if($language == 'nl_nl'){
                self::nl_nl();
              }else if($language == 'ru_ru'){
                self::ru_ru();
              }else if($language == 'th_th'){
                self::th_th();
              }else{
                self::en_us($language);
              }
        }

        $checkBarcode = $adb->pquery("SELECT 1 FROM ctmobile_barcode_fields",array());
        if($adb->num_rows($checkBarcode) == 0){
            $adb->pquery("INSERT INTO `ctmobile_barcode_fields` (`module`, `fieldname`) VALUES ('Products', 'vtiger_products:product_no:product_no:Products_Product_No:V')",array());
        }

        $checkAsset = $adb->pquery("SELECT 1 FROM ctmobile_asset_field",array());
        if($adb->num_rows($checkAsset) == 0){
            $adb->pquery("INSERT INTO `ctmobile_asset_field` (`module`, `fieldname`) VALUES ('Assets', 'vtiger_assets:asset_no:asset_no:Assets_Asset_No:V')",array());
        }

        $checkVcard = $adb->pquery("SELECT 1 FROM ctmobile_vcard_fields",array());
        if($adb->num_rows($checkVcard) == 0){
            $adb->pquery("INSERT INTO `ctmobile_vcard_fields` (`module`, `fieldname`)VALUES ('Vendors','vtiger_vendor:vendorname:vendorname:Vendors_Vendor_Name:V'),
            ('Leads','vtiger_leaddetails:firstname:firstname:Leads_First_Name:V'),
            ('Leads','vtiger_leaddetails:lastname:lastname:Leads_Last_Name:V'),
            ('Contacts', 'vtiger_contactdetails:firstname:firstname:Contacts_First_Name:V'),
            ('Contacts', 'vtiger_contactdetails:lastname:lastname:Contacts_Last_Name:V')
            ",array());  
        }

        $checkRoutestatus = $adb->pquery("SELECT 1 FROM ctmobile_routestatus",array());
        if($adb->num_rows($checkRoutestatus) == 0){
            $adb->pquery("INSERT INTO `ctmobile_routestatus` (`routestatusname`, `routestatuslabel`) VALUES
                    ('In Progress',  'In Progress'),
                    ('On Hold',  'On Hold'),
                    ('Completed',    'Completed'),
                    ('Not Available',    'Not Available');",array());
        }
    }

    static function en_us($language = 'en_us'){
        global $adb;
        $checkQuery = "DELETE FROM ctmobile_language_keyword WHERE keyword_lang = ?";
        $checkResult = $adb->pquery($checkQuery,array($language));

        $adb->pquery("INSERT INTO `ctmobile_language_keyword` (`keyword`, `keyword_name`, `keyword_lang`, `language_keyword`, `sectionid`) VALUES
            ('network_error', 'Network connection error!', '".$language."', 'Network connection error!', 1),
            ('connection_check', 'Could not connect to CRM, Please check your Internet connection.', '".$language."', 'Could not connect to CRM, Please check your Internet connection.', 1),
            ('update', 'Update', '".$language."', 'Update', 1),
            ('cancel', 'Cancel', '".$language."', 'Cancel', 1),
            ('ok', 'Ok', '".$language."', 'Ok', 1),
            ('more_information', 'Click here for more information.', '".$language."', 'Click here for more information.', 1),
            ('yes', 'Yes', '".$language."', 'Yes', 1),
            ('no', 'No', '".$language."', 'No', 1),
            ('click_again_exit', 'Click again to exit', '".$language."', 'Click again to exit', 1),
            ('forpermission', 'You don\'t have permission to view this feature. Please subscribe for Premium version Click here to Subscribe.', '".$language."', 'You don\'t have permission to view this feature. Please subscribe for Premium version Click here to Subscribe.', 1),
            ('clickhere', 'Click here', '".$language."', 'Click here', 1),
            ('clickhere_subscribe', 'Click here to subscribe premium version', '".$language."', 'Click here to subscribe premium version', 1),
            ('clickhere_configure', 'Click here and view how to Configure.', '".$language."', 'Click here and view how to Configure.', 1),
            ('please_wait', 'Please Wait…', '".$language."', 'Please Wait…', 1),
            ('share__msg', 'Share file with', '".$language."', 'Share file with', 1),
            ('dialog_camera', 'Camera', '".$language."', 'Camera', 1),
            ('dialog_add_file_by', 'Take Photo from', '".$language."', 'Take Photo from', 1),
            ('add', 'Add', '".$language."', 'Add', 1),
            ('mail_manager_configured', 'Mail Manager is not configured', '".$language."', 'Mail Manager is not configured', 1),
            ('dialog_add_files_by', 'Add Files by', '".$language."', 'Add Files by', 1),
            ('dialog_drive', 'Drive', '".$language."', 'Drive', 1),
            ('dialog_drop_box', 'Drop Box', '".$language."', 'Drop Box', 1),
            ('dialog_need_signin', 'You need to Sign-in to your Drive account first.', '".$language."', 'You need to Sign-in to your Drive account first.', 1),
            ('dialog_gallery', 'Gallery', '".$language."', 'Gallery', 1),
            ('delete', 'Delete', '".$language."', 'Delete', 1),
            ('timeoutmessage', 'Oops! Request is taking more time than expected.', '".$language."', 'Oops! Request is taking more time than expected.', 1),
            ('gps_location_message', 'GPS is not enabled. Please turn it on to get your near by locations.', '".$language."', 'GPS is not enabled. Please turn it on to get your near by locations.', 1),
            ('sure_want_delete', 'Are you sure want to delete ?', '".$language."', 'Are you sure want to delete ?', 1),
            ('select', 'Select', '".$language."', 'Select', 1),
            ('msgforrecordaudio', 'Minimum record duration one second.', '".$language."', 'Minimum record duration one second.', 1),
            ('permission_storage', 'Permission denied to read your External storage', '".$language."', 'Permission denied to read your External storage', 1),
            ('send_permission_msg', 'Send message permission denied', '".$language."', 'Send message permission denied', 1),
            ('choosefile', 'Choose File', '".$language."', 'Choose File', 1),
            ('enter', 'Enter', '".$language."', 'Enter', 1),
            ('select_an_option', 'Select an Option', '".$language."', 'Select an Option', 1),
            ('email_validation', 'Email is not valid', '".$language."', 'Email is not valid', 1),
            ('please_enter', 'Please Enter', '".$language."', 'Please Enter', 1),
            ('website_validation_text', 'Website URL is not valid', '".$language."', 'Website URL is not valid', 1),
            ('selectvalue', 'Select value first', '".$language."', 'Select value first', 1),
            ('email', 'Email', '".$language."', 'Email', 1),
            ('enter_email_address', 'Enter email address', '".$language."', 'Enter email address', 1),
            ('email_address_not_correct', 'Email address incorrect', '".$language."', 'Email address incorrect', 1),
            ('pls_enter_subject', 'Please Enter Subject', '".$language."', 'Please Enter Subject', 1),
            ('attachFiles', 'Attached File', '".$language."', 'Attached File', 1),
            ('from', 'From', '".$language."', 'From', 1),
            ('to', 'To', '".$language."', 'To', 1),
            ('call_permission_msg', 'Call permission denied', '".$language."', 'Call permission denied', 1),
            ('no_records', 'No records found', '".$language."', 'No records found', 1),
            ('fullform', 'Create New', '".$language."', 'Create New', 1),
            ('save', 'Save', '".$language."', 'Save', 1),
            ('total', 'Total', '".$language."', 'Total', 1),
            ('discount', 'Discount', '".$language."', 'Discount', 1),
            ('price', 'Price', '".$language."', 'Price', 1),
            ('quantity', 'Quantity', '".$language."', 'Quantity', 1),
            ('select_module', 'Select Module', '".$language."', 'Select Module', 1),
            ('item_list', 'Item List', '".$language."', 'Item List', 1),
            ('quickcreate', 'Quick Create', '".$language."', 'Quick Create', 1),
            ('overwrite_msg_part1', 'Overwrite the existing address with the selected', '".$language."', 'Overwrite the existing address with the selected', 1),
            ('once_in_every', 'Once in every', '".$language."', 'Once in every', 1),
            ('overwrite_msg_part2', 'address details?', '".$language."', 'address details?', 1),
            ('add_item', 'Add Item', '".$language."', 'Add Item', 1),
            ('recordsave', 'Record saved successfully', '".$language."', 'Record saved successfully', 1),
            ('recordnotsave', 'Could not save record. Try again later', '".$language."', 'Could not save record. Try again later', 1),
            ('minutes', 'Minutes', '".$language."', 'Minutes', 1),
            ('hours', 'Hours', '".$language."', 'Hours', 1),
            ('days', 'Days', '".$language."', 'Days', 1),
            ('on', 'On', '".$language."', 'On', 1),
            ('day_of_the_month', 'day of the month', '".$language."', 'day of the month', 1),
            ('list_price', 'List Price', '".$language."', 'List Price', 1),
            ('add_record', 'Add Record', '".$language."', 'Add Record', 1),
            ('add_product', 'Add Product', '".$language."', 'Add Product', 1),
            ('add_service', 'Add Service', '".$language."', 'Add Service', 1),
            ('discountin', 'Discount in %', '".$language."', 'Discount in %', 1),
            ('unitprice', 'Unit price', '".$language."', 'Unit price', 1),
            ('netprice', 'Net price', '".$language."', 'Net price', 1),
            ('comments', 'Comments', '".$language."', 'Comments', 1),
            ('add_close', 'Add & Close', '".$language."', 'Add & Close', 1),
            ('fetching_rout_message', 'Fetching route, Please wait…', '".$language."', 'Fetching route, Please wait…', 1),
            ('setting', 'Settings', '".$language."', 'Settings', 1),
            ('utc', 'UTC', '".$language."', 'UTC', 1),
            ('in', 'In', '".$language."', 'In', 1),
            ('days_ago', 'days ago', '".$language."', 'days ago', 1),
            ('mins_ago', 'Minutes ago', '".$language."', 'Minutes ago', 1),
            ('justnow', 'Just now', '".$language."', 'Just now', 1),
            ('hours_ago', 'hours ago', '".$language."', 'hours ago', 1),
            ('in_1_day', 'In 1 day', '".$language."', 'In 1 day', 1),
            ('scanqrcode', 'Asset / Card scanner', '".$language."', 'Asset / Card scanner', 1),
            ('call_log', 'Call Log', '".$language."', 'Call Log', 1),
            ('voice_message', 'Hi', '".$language."', 'Hi', 1),
            ('voice_message1', 'What can I search for you in', '".$language."', 'What can I search for you in', 1),
            ('live_tracking', 'Live Tracking', '".$language."', 'Live Tracking', 1),
            ('mailmanager', 'Mail Manager', '".$language."', 'Mail Manager', 1),
            ('my_location', 'My location', '".$language."', 'My location', 1),
            ('created_on', 'Created On', '".$language."', 'Created On', 1),
            ('modified_on', 'Modified On', '".$language."', 'Modified On', 1),
            ('enter_comments', 'Enter Comments', '".$language."', 'Enter Comments', 1),
            ('viewmore', 'View More', '".$language."', 'View More', 1),
            ('viewless', 'View Less', '".$language."', 'View Less', 1),
            ('gotofullform', 'Go to Full Form', '".$language."', 'Go to Full Form', 1),
            ('post', 'Post', '".$language."', 'Post', 1),
            ('url', 'URL', '".$language."', 'URL', 1),
            ('dialog_title_text_back_color', 'Select a Text Background Color', '".$language."', 'Select a Text Background Color', 1),
            ('event_or_task', 'Add event/task', '".$language."', 'Add event/task', 1),
            ('shortcut', 'Shortcuts', '".$language."', 'Shortcuts', 1),
            ('select_field', 'Select Field', '".$language."', 'Select Field', 1),
            ('share', 'Share', '".$language."', 'Share', 1),
            ('title_insert_link', 'Insert Link', '".$language."', 'Insert Link', 1),
            ('addyourcommentshere', 'Add your comments here', '".$language."', 'Add your comments here', 1),
            ('nocomment', 'No Comments', '".$language."', 'No Comments', 1),
            ('leads', 'Leads', '".$language."', 'Leads', 1),
            ('true_val', 'true', '".$language."', 'true', 1),
            ('noresult', 'No Result', '".$language."', 'No Result', 1),
            ('version', 'Version', '".$language."', 'Version', 1),
            ('convert_lead', 'Convert Lead', '".$language."', 'Convert Lead', 1),
            ('app_name', 'CRMTiger', '".$language."', 'CRMTiger', 1),
            ('enter_url', 'Please Enter url', '".$language."', 'Please Enter url', 1),
            ('help', 'Help', '".$language."', 'Help', 1),
            ('contact_us', 'Contact Us', '".$language."', 'Contact Us', 1),
            ('updates', 'Updates', '".$language."', 'Updates', 1),
            ('logout', 'LogOut', '".$language."', 'LogOut', 1),
            ('busnies_cardscanner', 'Business Card Scanner', '".$language."', 'Business Card Scanner', 1),
            ('sure_want_logout', 'Are you sure want to logout ?', '".$language."', 'Are you sure want to logout ?', 1),
            ('logout_message', 'Logout successfully', '".$language."', 'Logout successfully', 1),
            ('all', 'All', '".$language."', 'All', 1),
            ('add_event', 'Add event', '".$language."', 'Add event', 1),
            ('add_task', 'Add Task', '".$language."', 'Add Task', 1),
            ('next', 'Next', '".$language."', 'Next', 1),
            ('terms_conditions', 'Terms and Conditions', '".$language."', 'Terms and Conditions', 1),
            ('login', 'Login', '".$language."', 'Login', 2),
            ('privacy_policay', 'By logging in, you agree to our Terms and Conditions & Privacy Policy', '".$language."', 'By logging in, you agree to our Terms and Conditions & Privacy Policy', 2),
            ('copyright', 'Copyright © 2020 CRMTiger Version', '".$language."', 'Copyright © 2020 CRMTiger Version', 2),
            ('enter_username', 'Please enter username', '".$language."', 'Please enter username', 2),
            ('enter_password', 'Please enter password', '".$language."', 'Please enter password', 2),
            ('remanberme', 'Remember Me', '".$language."', 'Remember Me', 2),
            ('forgot_password', 'Forgot password?', '".$language."', 'Forgot password?', 2),
            ('privacy_policay1', 'Privacy Policy', '".$language."', 'Privacy Policy', 2),
            ('contactsupportmsg', 'Something went wrong. \\n please Click here to contact support.', '".$language."', 'Something went wrong. \\n please Click here to contact support.', 2),
            ('enter_username_password', 'Entered Username or Password is wrong', '".$language."', 'Entered Username or Password is wrong', 2),
            ('server_issue_occured', 'Server issues occurred', '".$language."', 'Server issues occurred', 2),
            ('password', 'Password', '".$language."', 'Password', 3),
            ('user_name', 'Username', '".$language."', 'Username', 3),
            ('reset_pwd', 'Reset Password', '".$language."', 'Reset Password', 3),
            ('forgot_password_title', 'Forgot password', '".$language."', 'Forgot password', 3),
            ('enter_user_name', 'Enter user name', '".$language."', 'Enter user name', 3),
            ('cc', 'Cc', '".$language."', 'Cc', 4),
            ('body', 'Body', '".$language."', 'Body', 4),
            ('bcc', 'BCC', '".$language."', 'BCC', 4),
            ('dialog_title_text_color', 'Select a Text Color', '".$language."', 'Select a Text Color', 4),
            ('date', 'Date', '".$language."', 'Date', 4),
            ('subject', 'Subject', '".$language."', 'Subject', 4),
            ('composeMail', 'Compose Mail', '".$language."', 'Compose Mail', 4),
            ('send', 'Send', '".$language."', 'Send', 4),
            ('select_message', 'Select message', '".$language."', 'Select message', 4),
            ('title_insert_table', 'Insert Table', '".$language."', 'Insert Table', 4),
            ('log_file_sms', 'I agree to Share API Log to Technical team for further troubleshooting', '".$language."', 'I agree to Share API Log to Technical team for further troubleshooting', 5),
            ('edit_record', 'Edit Records', '".$language."', 'Edit Records', 5),
            ('select_time', 'Select Time', '".$language."', 'Select Time', 5),
            ('edit_item', 'Edit Item', '".$language."', 'Edit Item', 5),
            ('items_total', 'Items Total', '".$language."', 'Items Total', 5),
            ('number_less_then_31', 'Number should be less than 31', '".$language."', 'Number should be less than 31', 5),
            ('users', 'Users', '".$language."', 'Users', 5),
            ('groups', 'Groups', '".$language."', 'Groups', 5),
            ('txt_note_for_file', 'Note : Existing attachments(images/files) will be replaced', '".$language."', 'Note : Existing attachments(images/files) will be replaced', 5),
            ('greaterdatetime', 'End DateTime should be greater than Start DateTime', '".$language."', 'End DateTime should be greater than Start DateTime', 5),
            ('until', 'Until', '".$language."', 'Until', 5),
            ('organizations', 'Organizations', '".$language."', 'Organizations', 6),
            ('contacts', 'Contacts', '".$language."', 'Contacts', 6),
            ('opportunity', 'Opportunity', '".$language."', 'Opportunity', 6),
            ('lbl_sun', 'SUN', '".$language."', 'SUN', 7),
            ('lbl_mon', 'MON', '".$language."', 'MON', 7),
            ('lbl_tue', 'TUE', '".$language."', 'TUE', 7),
            ('lbl_wed', 'WED', '".$language."', 'WED', 7),
            ('lbl_thu', 'THU', '".$language."', 'THU', 7),
            ('lbl_fri', 'FRI', '".$language."', 'FRI', 7),
            ('lbl_sat', 'SAT', '".$language."', 'SAT', 7),
            ('lbl_1', '1', '".$language."', '1', 7),
            ('lbl_2', '2', '".$language."', '2', 7),
            ('lbl_3', '3', '".$language."', '3', 7),
            ('lbl_4', '4', '".$language."', '4', 7),
            ('lbl_5', '5', '".$language."', '5', 7),
            ('lbl_6', '6', '".$language."', '6', 7),
            ('lbl_7', '7', '".$language."', '7', 7),
            ('lbl_8', '8', '".$language."', '8', 7),
            ('lbl_9', '9', '".$language."', '9', 7),
            ('lbl_10', '10', '".$language."', '10', 7),
            ('lbl_11', '11', '".$language."', '11', 7),
            ('lbl_12', '12', '".$language."', '12', 7),
            ('lbl_13', '13', '".$language."', '13', 7),
            ('lbl_14', '14', '".$language."', '14', 7),
            ('lbl_15', '15', '".$language."', '15', 7),
            ('lbl_16', '16', '".$language."', '16', 7),
            ('lbl_17', '17', '".$language."', '17', 7),
            ('lbl_18', '18', '".$language."', '18', 7),
            ('lbl_19', '19', '".$language."', '19', 7),
            ('lbl_20', '20', '".$language."', '20', 7),
            ('lbl_21', '21', '".$language."', '21', 7),
            ('lbl_22', '22', '".$language."', '22', 7),
            ('lbl_23', '23', '".$language."', '23', 7),
            ('lbl_24', '24', '".$language."', '24', 7),
            ('lbl_25', '25', '".$language."', '25', 7),
            ('lbl_26', '26', '".$language."', '26', 7),
            ('lbl_27', '27', '".$language."', '27', 7),
            ('lbl_28', '28', '".$language."', '28', 7),
            ('lbl_29', '29', '".$language."', '29', 7),
            ('lbl_30', '30', '".$language."', '30', 7),
            ('lbl_31', '31', '".$language."', '31', 7),
            ('lbl_32', '32', '".$language."', '32', 7),
            ('lbl_33', '33', '".$language."', '33', 7),
            ('lbl_34', '34', '".$language."', '34', 7),
            ('lbl_35', '35', '".$language."', '35', 7),
            ('lbl_36', '36', '".$language."', '36', 7),
            ('lbl_37', '37', '".$language."', '37', 7),
            ('lbl_38', '38', '".$language."', '38', 7),
            ('lbl_39', '39', '".$language."', '39', 7),
            ('lbl_40', '40', '".$language."', '40', 7),
            ('lbl_41', '41', '".$language."', '41', 7),
            ('lbl_42', '42', '".$language."', '42', 7),
            ('current_date', 'current date', '".$language."', 'current date', 7),
            ('event', 'Events', '".$language."', 'Events', 7),
            ('calendar', 'Calendar', '".$language."', 'Calendar', 7),
            ('latest_version', 'Latest Version :', '".$language."', 'Latest Version :', 8),
            ('expire_on', 'Next renewal date : ', '".$language."', 'Next renewal date : ', 8),
            ('ctmobile_ext_version', 'CTMobile Ext. Version : ', '".$language."', 'CTMobile Ext. Version : ', 8),
            ('you_have_latest_version', 'You already have latest version', '".$language."', 'You already have latest version', 8),
            ('latest_version1', 'You Already have latest version', '".$language."', 'You Already have latest version', 8),
            ('upgreaded', 'Upgrade', '".$language."', 'Upgrade', 8),
            ('downgrade', 'Downgrade', '".$language."', 'Downgrade', 8),
            ('dialog_recent_event_info', 'You can set from here how many number of records you want to show on Home screen for Recent Event.', '".$language."', 'You can set from here how many number of records you want to show on Home screen for Recent Event.', 8),
            ('dialog_feedback_info', 'You can submit your feedback with description , our team will check your feedback and get back to you.', '".$language."', 'You can submit your feedback with description , our team will check your feedback and get back to you.', 8),
            ('dialog_log_info', 'Log functionality is used for customer support / help , If you are facing any issues in app or any module or functionality is not working proper then you can enable share log with our development team.', '".$language."', 'Log functionality is used for customer support / help , If you are facing any issues in app or any module or functionality is not working proper then you can enable share log with our development team.', 8),
            ('info', 'Info', '".$language."', 'Info', 8),
            ('recent_history', 'Recent History', '".$language."', 'Recent History', 8),
            ('recent_feedback', 'Feedback', '".$language."', 'Feedback', 8),
            ('recent_log', 'Log', '".$language."', 'Log', 8),
            ('crmtiger_app_version', 'CRMTiger App Version : ', '".$language."', 'CRMTiger App Version : ', 8),
            ('historylimit', 'Recent History Limit', '".$language."', 'Recent History Limit', 8),
            ('radious_in_miles', 'Radius in miles', '".$language."', 'Radius in miles', 8),
            ('recentlimit', 'Recent Event Limit', '".$language."', 'Recent Event Limit', 8),
            ('upcoming_events', 'Upcoming Events', '".$language."', 'Upcoming Events', 8),
            ('rate_our_app', 'Rate Our App!', '".$language."', 'Rate Our App!', 8),
            ('feedback', 'Submit Feedback', '".$language."', 'Submit Feedback', 8),
            ('sendfeedback', 'Feedback Send', '".$language."', 'Feedback Send', 8),
            ('emaillimit', 'Email limit', '".$language."', 'Email limit', 8),
            ('log', 'Log', '".$language."', 'Log', 8),
            ('logclear', 'Log cleared successfully.', '".$language."', 'Log cleared successfully.', 8),
            ('dialog_recent_history_info', 'You can set from here how many number of records you want to show on Home screen for Recent History.', '".$language."', 'You can set from here how many number of records you want to show on Home screen for Recent History.', 8),
            ('proceed_to_upgrade1', 'Proceed to', '".$language."', 'Proceed to', 8),
            ('upgradation_message', 'will required logout and login again later.', '".$language."', 'will required logout and login again later.', 8),
            ('proceed_to_upgrade', 'Proceed to Upgrade', '".$language."', 'Proceed to Upgrade', 8),
            ('module_setting', 'Module Setting', '".$language."', 'Module Setting', 9),
            ('sortbyfield', 'Sort by field', '".$language."', 'Sort by field', 9),
            ('ascending', 'Ascending  A to Z', '".$language."', 'Ascending  A to Z', 9),
            ('descending', 'Descending  Z to A', '".$language."', 'Descending  Z to A', 9),
            ('first_field', 'First Field', '".$language."', 'First Field', 9),
            ('second_field', 'Second Field', '".$language."', 'Second Field', 9),
            ('third_field', 'Third Field', '".$language."', 'Third Field', 9),
            ('sure_want_restore', 'Are you sure you want to reset to default settings?', '".$language."', 'Are you sure you want to reset to default settings?', 9),
            ('orderlist', 'List Order', '".$language."', 'List Order', 9),
            ('module_reset', 'Restore to Default', '".$language."', 'Restore to Default', 9),
            ('display_fields', 'Display Fields', '".$language."', 'Display Fields', 9),
            ('discount_lessthen_100', 'Discount % should be less than 100', '".$language."', 'Discount % should be less than 100', 10),
            ('select_item', 'Select Item', '".$language."', 'Select Item', 10),
            ('item_comment', 'Item Comment', '".$language."', 'Item Comment', 10),
            ('record_name', 'Record Name is :', '".$language."', 'Record Name is :', 11),
            ('go_back', 'Go Back', '".$language."', 'Go Back', 11),
            ('please_enter_shortcut_name', 'Please Enter Shortcut Name', '".$language."', 'Please Enter Shortcut Name', 11),
            ('number_not_found', 'Contact Number not found', '".$language."', 'Contact Number not found', 11),
            ('mail_not_found', 'Mail Address not found', '".$language."', 'Mail Address not found', 11),
            ('create_shortcut', 'Create Shortcut', '".$language."', 'Create Shortcut', 11),
            ('contact_summary', 'Summary', '".$language."', 'Summary', 11),
            ('activites', 'Activities', '".$language."', 'Activities', 11),
            ('details', 'Details', '".$language."', 'Details', 11),
            ('related', 'Related', '".$language."', 'Related', 11),
            ('share_link', 'Share record with', '".$language."', 'Share record with', 11),
            ('edit', 'Edit', '".$language."', 'Edit', 11),
            ('duplicate', 'Duplicate', '".$language."', 'Duplicate', 11),
            ('whatsapp', 'Whatsapp', '".$language."', 'Whatsapp', 11),
            ('call', 'Call', '".$language."', 'Call', 11),
            ('choose_contact_for_call', 'Choose Contact for Call', '".$language."', 'Choose Contact for Call', 11),
            ('choose_contact_for_sms', 'Choose Contact for SMS', '".$language."', 'Choose Contact for SMS', 11),
            ('choose_contact_for_whatsapp', 'Choose Contact for WhatsApp', '".$language."', 'Choose Contact for WhatsApp', 11),
            ('chosse_contact_for_email', 'Choose Email', '".$language."', 'Choose Email', 11),
            ('attach_file', 'Attach Files', '".$language."', 'Attach Files', 11),
            ('close', 'Close', '".$language."', 'Close', 11),
            ('status', 'Status', '".$language."', 'Status', 11),
            ('stop', 'Stop', '".$language."', 'Stop', 11),
            ('zero', '0', '".$language."', '0', 11),
            ('record', 'Record', '".$language."', 'Record', 11),
            ('voice_note', 'Voice Note', '".$language."', 'Voice Note', 11),
            ('tickets', 'Tickets', '".$language."', 'Tickets', 12),
            ('check_out', 'Check Out', '".$language."', 'Check Out', 12),
            ('check_in', 'Check In', '".$language."', 'Check In', 12),
            ('select_any', 'Select any', '".$language."', 'Select any', 12),
            ('fulldetails', 'Show Full Details', '".$language."', 'Show Full Details', 12),
            ('checkin', 'Check-in', '".$language."', 'Check-in', 12),
            ('navigate', 'Navigate', '".$language."', 'Navigate', 12),
            ('product', 'Products', '".$language."', 'Products', 12),
            ('projectMilestone', 'Project Milestone', '".$language."', 'Project Milestone', 12),
            ('projecttask', 'Project Tasks', '".$language."', 'Project Tasks', 12),
            ('nearby', 'NearBy', '".$language."', 'NearBy', 13),
            ('document', 'Document', '".$language."', 'Document', 14),
            ('reply', 'Reply', '".$language."', 'Reply', 14),
            ('reply_all', 'Reply All', '".$language."', 'Reply All', 14),
            ('forward', 'Forward', '".$language."', 'Forward', 14),
            ('action', 'Action', '".$language."', 'Action', 14),
            ('select_first', 'Select First', '".$language."', 'Select First', 14),
            ('commentaddsuccessful', 'Comment added successfull', '".$language."', 'Comment added successfull', 14),
            ('move_to', 'Move to', '".$language."', 'Move to', 14),
            ('attach', 'Attach', '".$language."', 'Attach', 14),
            ('addcoment', 'Add Comment', '".$language."', 'Add Comment', 14),
            ('adddocument', 'Add Document', '".$language."', 'Add Document', 14),
            ('home', 'Home', '".$language."', 'Home', 15),
            ('checkout', 'Check-out', '".$language."', 'Check-out', 15),
            ('message_search', 'Search by name', '".$language."', 'Search by name', 15),
            ('start_shift', 'Start shift', '".$language."', 'Start shift', 15),
            ('end_shift', 'End shift', '".$language."', 'End shift', 15),
            ('today_meeting', 'Meetings', '".$language."', 'Meetings', 15),
            ('shift_time_track', 'Shift Time Track', '".$language."', 'Shift Time Track', 15),
            ('logout_msg', 'You have to login again , click', '".$language."', 'You have to login again , click', 15),
            ('logout_msg1', 'to continue.', '".$language."', 'to continue.', 15),
            ('permission_denied', 'You don\'t have permission to create', '".$language."', 'You don\'t have permission to create', 15),
            ('history', 'Activity stream', '".$language."', 'Activity stream', 15),
            ('search_value', 'Search value :', '".$language."', 'Search value :', 15),
            ('feed_back_msg', 'Please enter feedback message', '".$language."', 'Please enter feedback message', 16),
            ('feed_back_hint_msg', 'Enter feedback message', '".$language."', 'Enter feedback message', 16),
            ('submit', 'Submit', '".$language."', 'Submit', 16),
            ('check_app_not_installed', 'Application is not currently installed.', '".$language."', 'Application is not currently installed.', 17),
            ('send_sms_fail_message', 'SMS failed, please try again later!', '".$language."', 'SMS failed, please try again later!', 17),
            ('documentaddsuccessfully', 'Document Attach successfully', '".$language."', 'Document Attach successfully', 17),
            ('send_message', 'Send message', '".$language."', 'Send message', 17),
            ('sms_to', 'smsto:', '".$language."', 'smsto:', 17),
            ('add_list_message', 'Add List', '".$language."', 'Add List', 18),
            ('mylist', 'My List', '".$language."', 'My List', 18),
            ('filtername', 'Filter Name', '".$language."', 'Filter Name', 18),
            ('selectlist', 'Select a List', '".$language."', 'Select a List', 18),
            ('assingedto', 'Assigned To', '".$language."', 'Assigned To', 18),
            ('selectmodule', 'Select a module', '".$language."', 'Select a module', 18),
            ('add_list', 'Add Filter', '".$language."', 'Add Filter', 18),
            ('recent_event', 'Recent Event', '".$language."', 'Recent Event', 19),
            ('recent_hostory', 'Recent History', '".$language."', 'Recent History', 19),
            ('module_specific_settings', 'Module-Specific Settings', '".$language."', 'Module-Specific Settings', 19),
            ('talk_to_us', 'Talk to us', '".$language."', 'Talk to us', 19),
            ('report_a_bug', 'Report A Bug', '".$language."', 'Report A Bug', 19),
            ('faq', 'FAQ', '".$language."', 'FAQ', 19),
            ('selectmodules', 'Select Module', '".$language."', 'Select Module', 19),
            ('myplan', 'My Plan', '".$language."', 'My Plan', 19),
            ('message', 'Message', '".$language."', 'Message', 20),
            ('message_validation', 'Please enter Message', '".$language."', 'Please enter Message', 20),
            ('contact_select', 'Please Select contact', '".$language."', 'Please Select contact', 20),
            ('global_search', 'Global Search', '".$language."', 'Global Search', 21),
            ('records', 'Records', '".$language."', 'Records', 21),
            ('dont_show_again', 'Don\'t Show Again', '".$language."', 'Don\'t Show Again', 22),
            ('skip', 'Skip', '".$language."', 'Skip', 22),
            ('file_downloading', 'File Downloading', '".$language."', 'File Downloading', 23),
            ('add_screenshots_optional', 'Add screenshots (optional)', '".$language."', 'Add screenshots (optional)', 24),
            ('describe_your_problem', 'Describe your problem', '".$language."', 'Describe your problem', 24),
            ('default_filter_shortcut', 'Default Filter Shortcut', '".$language."', 'Default Filter Shortcut', 25),
            ('record_shortcut', 'Record Shortcut', '".$language."', 'Record Shortcut', 25),
            ('enter_url', 'Please Enter url', '".$language."', 'Please Enter url', 26),
            ('new_version_is_avaiable', 'You need to update the app to continue using Please update to continue Older versions will no longer work from today', '".$language."', 'You need to update the app to continue using Please update to continue Older versions will no longer work from today', 26),
            ('search_by', 'Search by', '".$language."', 'Search by', 27),
            ('selected_filter', 'Selected filter :', '".$language."', 'Selected filter :', 27),
            ('selected_field', 'Selected field :', '".$language."', 'Selected field :', 27),
            ('choose', 'Choose', '".$language."', 'Choose', 28),
            ('qr_cardscanner', 'QR Code Scanner', '".$language."', 'QR Code Scanner', 28),
            ('error_message_for_scan', 'Could not read the card Try again later.', '".$language."', 'Could not read the card Try again later.', 28),
            ('press_start_scan', 'Press to Start Scan', '".$language."', 'Press to Start Scan', 28),
            ('line_item_quntity_validation_msg', 'Value should be greater than zero', '".$language."', 'Value should be greater than zero', 29),
            ('percentage_msg', 'Percentage should be less than 100', '".$language."', 'Percentage should be less than 100', 29),
            ('MSG_NO_DATA', 'No data found!', '".$language."', 'No data found!', 29),
            ('MSG_SOMETHING_WRONG', 'Something went wrong!', '".$language."', 'Something went wrong!', 29),
            ('MSG_COMING_SOON', 'Coming Soon!', '".$language."', 'Coming Soon!', 29),
            ('MSG_UPLOAD_PROFILE_IMAGE', 'Please upload profile image.', '".$language."', 'Please upload profile image.', 29),
            ('ALERT_TITLE_LOCATION_ACCESS', 'Location Access', '".$language."', 'Location Access', 29),
            ('ALERT_MSG_LOCATION_ACCESS', 'Requires your location to show nearby events.', '".$language."', 'Requires your location to show nearby events.', 29),
            ('ALERT_BTN_ALLOW', 'ALLOW', '".$language."', 'ALLOW', 29),
            ('ALERT_BTN_DENY', 'DENY', '".$language."', 'DENY', 29),
            ('ALERT_MSG_LOCATION_SETTING', 'Not able to fetch your current location. Please check your location settings.', '".$language."', 'Not able to fetch your current location. Please check your location settings.', 29),
            ('DELETE_RECORD', 'Delete Record', '".$language."', 'Delete Record', 29),
            ('ALERT_MSG_DELETE_SHORTCUT', 'Are you sure want to delete this shortcut?', '".$language."', 'Are you sure want to delete this shortcut?', 29),
            ('DELETE_SHORTCUT', 'Delete Shortcut', '".$language."', 'Delete Shortcut', 29),
            ('LBL_TERMS', 'By logging in, you agree to our Terms and', '".$language."', 'By logging in, you agree to our Terms and', 29),
            ('LBL_CONDITIONS', 'Conditions &', '".$language."', 'Conditions &', 29),
            ('ALERT_TITLE', 'Alert', '".$language."', 'Alert', 29),
            ('ALERT_BTN_SUBSCRIBE', 'Subscribe', '".$language."', 'Subscribe', 29),
            ('MSG_SELECT_MODULE', 'Please select any Module', '".$language."', 'Please select any Module', 29),
            ('MSG_SELECT_LIST', 'Please select any List', '".$language."', 'Please select any List', 29),
            ('ALERT_MSG_DONT_HAVE_CAMERA', 'You don\'t have camera', '".$language."', 'You don\'t have camera', 29),
            ('ALERT_MSG_GALLARY_PERMISSION', 'You don\'t have permission to access gallery.', '".$language."', 'You don\'t have permission to access gallery.', 29),
            ('ALERT_MSG_CAMERA_PERMISSION', 'You don\'t have permission to access camera. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Camera on', '".$language."', 'You don\'t have permission to access camera. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Camera on', 29),
            ('ALERT_MSG_SPEECH_PERMISSION', 'You don\'t have permission to access Speech Recognition. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Speech Recognition on', '".$language."', 'You don\'t have permission to access Speech Recognition. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Speech Recognition on', 29),
            ('BTN_DONE', 'Done', '".$language."', 'Done', 29),
            ('COMMENT', 'Comment', '".$language."', 'Comment', 29),
            ('FULL_FORM', 'Full Form', '".$language."', 'Full Form', 29),
            ('QUICK_CREATE', 'Create', '".$language."', 'Create', 29),
            ('LBL_SELECT_FIELDS', 'Select Fields', '".$language."', 'Select Fields', 29),
            ('LBL_SELECT_FIELDS', 'Select Fields', '".$language."', 'Select Fields', 29),
            ('LBL_SELECT_FIRST_FIELDS', 'Select First Field', '".$language."', 'Select First Field', 29),
            ('LBL_SELECT_SECOND_FIELDS', 'Select Second Field', '".$language."', 'Select Second Field', 29),
            ('LBL_SELECT_THIRD_FIELDS', 'Select Third Field', '".$language."', 'Select Third Field', 29),
            ('LBL_SORT_BY_FIELD', 'Select Sort By Field', '".$language."', 'Select Sort By Field', 29),
            ('BTN_RESET_TO_DEFAULT', 'Reset to Default', '".$language."', 'Reset to Default', 29),
            ('MSG_SELECT_SORT_BY_FIELD', 'Select Sort by field', '".$language."', 'Select Sort by field', 29),
            ('kStrClearBtnTitle', 'Clear', '".$language."', 'Clear', 29),
            ('kStrShowMoreBtnTitle', 'Show More', '".$language."', 'Show More', 29),
            ('kStrAddActivitiesBtnTitle', 'Add Activities', '".$language."', 'Add Activities', 29),
            ('kStrAddCommentPlaceHolder', 'Add your comments here', '".$language."', 'Add your comments here', 29),
            ('MSG_ENTER_TO_EMAIL', 'Please enter to field.', '".$language."', 'Please enter to field.', 29),
            ('WARNING_FILE', 'File can\'t open.', '".$language."', 'File can\'t open.', 29),
            ('MSG_FILE_SAVED', 'File saved.', '".$language."', 'File saved.', 29),
            ('WARNING_DOWNLOAD_FAIL', 'Download fail!, please try after sometime.', '".$language."', 'Download fail!, please try after sometime.', 29),
            ('LBL_SHORTCUT', 'Shortcut', '".$language."', 'Shortcut', 29),
            ('TXT_MESSAGE_PLACEHOLDER', 'Type Message', '".$language."', 'Type Message', 29),
            ('ALERT_INSTALL_WHATSAPP', 'Install Whatsapp', '".$language."', 'Install Whatsapp', 29),
            ('MSG_NO_MAIL_BOX', 'No MailBox found. Please Create Mailbox', '".$language."', 'No MailBox found. Please Create Mailbox', 29),
            ('LBL_WROTE', 'Wrote', '".$language."', 'Wrote', 29),
            ('MSG_MAIL_SEND', 'Mail sent', '".$language."', 'Mail sent', 29),
            ('log_file_not_found', 'API Log file not found.', '".$language."', 'API Log file not found.', 29),
            ('unknown_error', 'An unknown error occurred, try again', '".$language."', 'An unknown error occurred, try again', 29),
            ('CTMTigerAppVersion', 'CRMTiger App Version', '".$language."', 'CRMTiger App Version', 29),
            ('CTMMobileUpdateMsg', 'CTMobile Ext. Version Update Successfully', '".$language."', 'CTMobile Ext. Version Update Successfully', 29),
            ('dialog_Premium_downgrade', 'Downgrade will required logout and login again later', '".$language."', 'Downgrade will required logout and login again later', 29),
            ('dialog_Premium', 'Upgrade will required logout and login again later', '".$language."', 'Upgrade will required logout and login again later', 29),
            ('Overwrite', 'Overwrite', '".$language."', 'Overwrite', 29),
            ('MSGAddressOverwrite1', 'Overwrite the existing address with the selected', '".$language."', 'Overwrite the existing address with the selected', 29),
            ('MSGAddressOverwrite2', 'address details?', '".$language."', 'address details?', 29),
            ('UPGRADE_PLAN', 'Upgrade Plan', '".$language."', 'Upgrade Plan', 29),
            ('DOWNGRADE_PLAN', 'Downgrade Plan', '".$language."', 'Downgrade Plan', 29),
            ('UPGRADE_EXTENSION', 'Upgrade Extension', '".$language."', 'Upgrade Extension', 29),
            ('UPGRADE_APP', 'Upgrade App', '".$language."', 'Upgrade App', 29),
            ('SELECT_OPTION', 'Select Option', '".$language."', 'Select Option', 29),
            ('PLEASE_SELECT', 'Please select', '".$language."', 'Please select', 29),
            ('MSG_ACCESS_DENIED', 'You don\'t have permission for this module.', '".$language."', 'You don\'t have permission for this module.', 29),
            ('MSG_SELECT_RECCURING_MONTH_DAY', 'Please select reccuring day of month.', '".$language."', 'Please select reccuring day of month.', 29),
            ('MSG_SELECT_RECCURING_WEEK_DAY', 'Please select reccuring day of week.', '".$language."', 'Please select reccuring day of week.', 29),
            ('MSG_SELECT_RECCURING_DAYS', 'Please select reccuring days.', '".$language."', 'Please select reccuring days.', 29),
            ('Please select reccuring days.', 'Please select reccuring days.', '".$language."', 'Please select reccuring days.', 29),
            ('MSG_SELECT_RECCURING_END_DATE', 'Please select reccuring end date.', '".$language."', 'Please select reccuring end date.', 29),
            ('MSG_SELECT_RECCURING_TYPE', 'Please select reccuring type.', '".$language."', 'Please select reccuring type.', 29),
            ('FREQ_TIME', 'Times', '".$language."', 'Times', 29),
            ('REPEAT_YEARLY', 'Repeat Yearly', '".$language."', 'Repeat Yearly', 29),
            ('REPEAT_MONTHLY', 'Repeat Monthly', '".$language."', 'Repeat Monthly', 29),
            ('REPEAT_WEEKLY', 'Repeat Weekly', '".$language."', 'Repeat Weekly', 29),
            ('REPEAT_DAILY', 'Repeat Daily', '".$language."', 'Repeat Daily', 29),
            ('ACTION_TITLE', 'Action Title', '".$language."', 'Action Title', 29),
            ('MSG_SELECT_VALID_DATE', 'Please select valid day of month.', '".$language."', 'Please select valid day of month.', 29),
            ('MSG_SELECT_VALID_START_DATE', 'Start date should be less than end date.', '".$language."', 'Start date should be less than end date.', 29),
            ('MSG_SELECT_VALID_START_TIME', 'Start time should be less than end time.', '".$language."', 'Start time should be less than end time.', 29),
            ('LBL_LINEITEM_DETAILS', 'Lineitem Details', '".$language."', 'Lineitem Details', 29),
            ('MSG_INVALIDE_DISCOUNT_AMOUNT', 'Discount amount should be less than the total.', '".$language."', 'Discount amount should be less than the total.', 29),
            ('VIEW', 'View', '".$language."', 'View', 29),
            ('MSG_ENTER_VALID', 'Please enter valid', '".$language."', 'Please enter valid', 29),
            ('MSG_ENTER_PERCENTAGE', 'Percentage should be less than 100.', '".$language."', 'Percentage should be less than 100.', 29),
            ('ITEM_TOTAL', 'Item Total', '".$language."', 'Item Total', 29),
            ('ADJUSTMENT', 'Adjustment', '".$language."', 'Adjustment', 29),
            ('TITLE_CHOOSE_IMAGE', 'Choose Image', '".$language."', 'Choose Image', 29),
            ('COMPRESS', 'Compress', '".$language."', 'Compress', 29),
            ('CHOOSE_ANOTHER_IMAGE', 'Your image size is too large, please select another image', '".$language."', 'Your image size is too large, please select another image', 29),
            ('OnDayOfMonth', 'On day of month', '".$language."', 'On day of month', 29),
            ('OnDayOfWeek', 'On day of week', '".$language."', 'On day of week', 29),
            ('AddAndClose', 'Add & Close', '".$language."', 'Add & Close', 29),
            ('Repeat', 'Repeat', '".$language."', 'Repeat', 29),
            ('OnDay', 'On day', '".$language."', 'On day', 29),
            ('View_Line_Item', 'View Line Item', '".$language."', 'View Line Item', 29),
            ('TITLE_IMAGE', 'Image', '".$language."', 'Image', 29),
            ('TITLE_ICLOUD', 'iCloud', '".$language."', 'iCloud', 29),
            ('GOOGLE', 'Google', '".$language."', 'Google', 29),
            ('ALERT_BTN_OKAY', 'Okay', '".$language."', 'Okay', 29),
            ('ALERT_TITLE_ACCESS_DENIED', 'Access Denied', '".$language."', 'Access Denied', 29),
            ('Dont_Show_Again', 'Don\'t show again', '".$language."', 'Don\'t show again', 29),
            ('Skip', 'Skip', '".$language."', 'Skip', 29),
            ('Fillter_Name', 'Fillter Name', '".$language."', 'Fillter Name', 29),
            ('Fillter_Record_Count', 'Fillter Record Count', '".$language."', 'Fillter Record Count', 29),('url_note',  'Note : if your URL of CRM is https://example.com/crm enter that into above box',   '".$language."',    'Note : if your URL of CRM is https://example.com/crm enter that into above box',   31),
            ('vtiger_url',  'Your vTiger CRM URL',  '".$language."',    'Your vTiger CRM URL',  31),
            ('msg_doc_read_permission', 'You don\'t have permission to Add either This is read-only or Private Field.',  '".$language."',    'You don\'t have permission to Add either This is read-only or Private Field.',  31),
            ('CLEAR',   'Clear',    '".$language."',    'Clear',    31),
            ('Files/photos uploaded successfully',  'Files/photos uploaded successfully',   '".$language."',    'Files/photos uploaded successfully',   32),
            ('Digital signature saved', 'Digital signature saved',  '".$language."',    'Digital signature saved',  32),
            ('Please upload Signature or Files/photos', 'Please upload Signature or Files/photos',  '".$language."',    'Please upload Signature or Files/photos',  32),
            ('Files / Photos',  'Files / Photos',   '".$language."',    'Files / Photos',   32),
            ('Signature',   'Signature',    '".$language."',    'Signature',    32),
            ('add_photo_using', 'Add Photo Using',  '".$language."',    'Add Photo Using',  31),
            ('btn_upload_sign', '(+) Add Signature',    '".$language."',    '(+) Add Signature',    31),
            ('btn_upload_photo_doc',    '(+) Upload Files/Photos',  '".$language."',    '(+) Upload Files/Photos',  31),
            ('select_photo_doc_to_upload',  'Please select files/photos to upload', '".$language."',    'Please select files/photos to upload', 31),
            ('related_module_title',    'Search from related module and Add to \"Route\"',  '".$language."',    'Search from related module and Add to \"Route\"',  30),
            ('Route status updated successfully',   'Route status updated successfully',    '".$language."',    'Route status updated successfully',    32),
            ('Session init failed', 'Session init failed',  '".$language."',    'Session init failed',  32),
            ('You don\'t have permission to access this resource',  'You don\'t have permission to access this resource',   '".$language."',    'You don\'t have permission to access this resource',   32),
            ('ctroute_realtedto cannot be empty',   'Could not get the Related To - Try again later',   '".$language."',    'Could not get the Related To - Try again later',   32),
            ('ctroute_planning cannot be empty',    'Could not get the Route Planning Record - Try again later',    '".$language."',    'Could not get the Route Planning Record - Try again later',    32),
            ('Something went wrong - Try again later',  'Something went wrong - Try again later',   '".$language."',    'Something went wrong - Try again later',   32),
            ('sequence updated successfully',   'sequence updated successfully',    '".$language."',    'sequence updated successfully',    32),
            ('sequence cannot be empty',    'sequence cannot be empty', '".$language."',    'sequence cannot be empty', 32),
            ('Shortcut details not saved',  'Shortcut details not saved',   '".$language."',    'Shortcut details not saved',   32),
            ('Shortcut details saved successfully', 'Shortcut details saved successfully',  '".$language."',    'Shortcut details saved successfully',  32),
            ('Route save successfully', 'Route save successfully',  '".$language."',    'Route save successfully',  32),
            ('Record save successfully',    'Record save successfully', '".$language."',    'Record save successfully', 32),
            ('No dependency found for picklist',    'No dependency found for picklist', '".$language."',    'No dependency found for picklist', 32),
            ('No records found',    'No records found', '".$language."',    'No records found', 32),
            ('Outgoing server is not enabled, please configure from CRM',   'Outgoing server is not enabled, please configure from CRM',    '".$language."',    'Outgoing server is not enabled, please configure from CRM',    32),
            ('Removed Successfully',    'Removed Successfully', '".$language."',    'Removed Successfully', 32),
            ('Shortcut has been deleted',   'Shortcut has been deleted',    '".$language."',    'Shortcut has been deleted',    32),
            ('relation of records removed successfully',    'relation of records removed successfully', '".$language."',    'relation of records removed successfully', 32),
            ('relation of records not removed', 'relation of records not removed',  '".$language."',    'relation of records not removed',  32),
            ('Record has been deleted successfully',    'Record has been deleted successfully', '".$language."',    'Record has been deleted successfully', 32),
            ('Time Tracking saved successfully',    'Time Tracking saved successfully', '".$language."',    'Time Tracking saved successfully', 32),
            ('Time Tracking updated successfully',  'Time Tracking updated successfully',   '".$language."',    'Time Tracking updated successfully',   32),
            ('Time Tracking ended successfully',    'Time Tracking ended successfully', '".$language."',    'Time Tracking ended successfully', 32),
            ('Time Tracking started successfully',  'Time Tracking started successfully',   '".$language."',    'Time Tracking started successfully',   32),
            ('record cannot be empty',  'record cannot be empty',   '".$language."',    'record cannot be empty',   32),
            ('Module is disabled',  'Module is disabled',   '".$language."',    'Module is disabled',   32),
            ('Shift ended successfully',    'Shift ended successfully', '".$language."',    'Shift ended successfully', 32),
            ('Shift started successfully',  'Shift started successfully',   '".$language."',    'Shift started successfully',   32),
            ('relation of records added successfully',  'relation of records added successfully',   '".$language."',    'relation of records added successfully',   32),
            ('Comment saved successfully',  'Comment saved successfully',   '".$language."',    'Comment saved successfully',   32),
            ('Comment not saved',   'Comment not saved',    '".$language."',    'Comment not saved',    32),
            ('Comment module is not active',    'Comment module is not active', '".$language."',    'Comment module is not active', 32),
            ('No Upcoming Event',   'No Upcoming Event',    '".$language."',    'No Upcoming Event',    32),
            ('No Templates found - create it from Message Templates module',    'No Templates found - create it from Message Templates module', '".$language."',    'No Templates found - create it from Message Templates module', 32),
            ('No event or task for this date',  'No event or task for this date',   '".$language."',    'No event or task for this date',   32),
            ('No filters created',  'No filters created',   '".$language."',    'No filters created',   32),
            ('Select at least one record to attach',    'Select at least one record to attach', '".$language."',    'Select at least one record to attach', 32),
            ('Please select one or more attachments',   'Please select one or more attachments',    '".$language."',    'Please select one or more attachments',    32),
            ('No event for this month', 'No event for this month',  '".$language."',    'No event for this month',  32),
            ('No Activity found',   'No Activity found',    '".$language."',    'No Activity found',    32),
            ('Your feedback is valuable for us - it cannot be empty',   'Your feedback is valuable for us - it cannot be empty',    '".$language."',    'Your feedback is valuable for us - it cannot be empty',    32),
            ('Could not send mail, Please try later',   'Could not send mail, Please try later',    '".$language."',    'Could not send mail, Please try later',    32),
            ('Latest Version updated successfully', 'Latest Version updated successfully',  '".$language."',    'Latest Version updated successfully',  32),
            ('User Location Updated Successfully',  'User Location Updated Successfully',   '".$language."',    'User Location Updated Successfully',   32),
            ('User Location not Updated Successfully',  'User Location not Updated Successfully',   '".$language."',    'User Location not Updated Successfully',   32),
            ('SMSNotifier is not enable in CRM. Please enable it first',    'SMSNotifier is not enable in CRM. Please enable it first', '".$language."',    'SMSNotifier is not enable in CRM. Please enable it first', 32),
            ('Could not submit your feedback - Please try again later', 'Could not submit your feedback - Please try again later',  '".$language."',    'Could not submit your feedback - Please try again later',  32),
            ('Thank you for submitting your feedback',  'Thank you for submitting your feedback',   '".$language."',    'Thank you for submitting your feedback',   32),
            ('Please upload User Image',    'Please upload User Image', '".$language."',    'Please upload User Image', 32),
            ('Image Not Uploading, please try again',   'Image Not Uploading, please try again',    '".$language."',    'Image Not Uploading, please try again',    32),
            ('User Image Uploaded Successfully',    'User Image Uploaded Successfully', '".$language."',    'User Image Uploaded Successfully', 32),
            ('Invalid Module name', 'Invalid Module name',  '".$language."',    'Invalid Module name',  32),
            ('Records Sync Successfully',   'Records Sync Successfully',    '".$language."',    'Records Sync Successfully',    32),
            ('Values cannot be empty',  'Values cannot be empty',   '".$language."',    'Values cannot be empty',   32),
            ('Record id is empty',  'Record id is empty',   '".$language."',    'Record id is empty',   32),
            ('Logout Successfully', 'Logout Successfully',  '".$language."',    'Logout Successfully',  32),
            ('Please Enable CTMobile Module',   'Please Enable CTMobile Module',    '".$language."',    'Please Enable CTMobile Module',    32),
            ('Authentication Failed',   'Username and Password do not match',   '".$language."',    'Username and Password do not match',   32),
            ('Mismatched module information',   'Something gone wrong, please try again later', '".$language."',    'Something gone wrong, please try again later', 32),
            ('Field does not exists',   'Please set display fields again',  '".$language."',    'Please set display fields again',  32),
            ('Module does not exists',  'Module does not exists or disabled by admin',  '".$language."',    'Module does not exists or disabled by admin',  32),
            ('Month cannot be empty',   'Could not get the Month - Try again later',    '".$language."',    'Could not get the Month - Try again later',    32),
            ('Year cannot be empty',    'Could not get the Year - Try again later', '".$language."',    'Could not get the Year - Try again later', 32),
            ('Date cannot be empty',    'Could not get the Date - Try again later', '".$language."',    'Could not get the Date - Try again later', 32),
            ('Userid cannot be empty',  'Could not get the Userid - Try again later',   '".$language."',    'Could not get the Userid - Try again later',   32),
            ('End Date cannot be empty',    'Could not get the status - Try again later',   '".$language."',    'Could not get the status - Try again later',   32),
            ('Start Date cannot be empty',  'Could not get the Start Date - Try again later',   '".$language."',    'Could not get the Start Date - Try again later',   32),
            ('You do not configure SMS Notifier in CRM. Please configure SMS Notifier in your CRM to use this feature', 'You do not configure SMS Notifier in CRM. Please configure SMS Notifier in your CRM to use this feature',  '".$language."',    'You do not configure SMS Notifier in CRM. Please configure SMS Notifier in your CRM to use this feature',  32),
            ('Longitude cannot be empty',   'Could not get location-Please try again',  '".$language."',    'Could not get location-Please try again',  32),
            ('Latitude cannot be empty',    'Could not get location-Please try again',  '".$language."',    'Could not get location-Please try again',  32),
            ('User cannot be empty',    'Could not get the User - Try again later', '".$language."',    'Could not get the User - Try again later', 32),
            ('Status cannot be empty',  'Could not get the status - Try again later',   '".$language."',    'Could not get the status - Try again later',   32),
            ('Required fields not found',   'Required fields not found',    '".$language."',    'Required fields not found',    32),
            ('Tracking module not active',  'Tracking module not active-Please contact CRM Admin',  '".$language."',    'Tracking module not active-Please contact CRM Admin',  32),
            ('Missing mandatory input values',  'Missing mandatory input values',   '".$language."',    'Missing mandatory input values',   32),
            ('No MailBox found. Please Create Mailbox', 'No MailBox found. Please Create Mailbox',  '".$language."',    'No MailBox found. Please Create Mailbox',  32),
            ('Mail not sent',   'Mail not sent',    '".$language."',    'Mail not sent',    32),
            ('Mail send successfully',  'Mail send successfully',   '".$language."',    'Mail send successfully',   32),
            ('Email Id or username not match with your record', 'Email Id or username not match with your record',  '".$language."',    'Email Id or username not match with your record',  32),
            ('Module not specified',    'Module not specified', '".$language."',    'Module not specified', 32),
            ('No messages found',   'No messages found',    '".$language."',    'No messages found',    32),
            ('No Dependency Found For This Module', 'No Dependency Found For This Module',  '".$language."',    'No Dependency Found For This Module',  32),
            ('Outgoing server is not Enabled',  'Outgoing server is not Enabled',   '".$language."',    'Outgoing server is not Enabled',   32),
            ('Outgoing server is Enabled',  'Outgoing server is Enabled',   '".$language."',    'Outgoing server is Enabled',   32),
            ('Email Attached Successfully', 'Email Attached Successfully',  '".$language."',    'Email Attached Successfully',  32),
            ('Documents Attached Successfully', 'Documents Attached Successfully',  '".$language."',    'Documents Attached Successfully',  32),
            ('Login required - Please login again', 'Login required - Please login again',  '".$language."',    'Login required - Please login again',  32),
            ('time_tracking_module_disable',    'Time tracking module is disable',  '".$language."',    'Time tracking module is disable',  31),
            ('route_planning_module_disable',   'Route planning module is disable', '".$language."',    'Route planning module is disable', 31),
            ('mark_as_held',    'Are you sure you want to mark Event as Held?', '".$language."',    'Are you sure you want to mark Event as Held?', 31),
            ('stop_timer_msg',  'You have already started Time tracking for another record, Do you want to stop it first ?',    '".$language."',    'You have already started Time tracking for another record, Do you want to stop it first ?',    31),
            ('access_denied_routeplanning', 'Access denied for route planning', '".$language."',    'Access denied for route planning', 31),
            ('time_spent',  'Time Spent',   '".$language."',    'Time Spent',   31),
            ('select_user', 'Select User',  '".$language."',    'Select User',  30),
            ('status_cannot_be_held',   'Status cannot be held for future date start',  '".$language."',    'Status cannot be held for future date start',  30),
            ('please_select_end_date',  'Please select end date',   '".$language."',    'Please select end date',   30),
            ('please_select_start_date',    'Please select start date', '".$language."',    'Please select start date', 30),
            ('tap_on_plus_icon_for_select_route',   'Tap on + icon to select record for your route.',   '".$language."',    'Tap on + icon to select record for your route.',   30),
            ('please_enter_notes',  'Please enter notes',   '".$language."',    'Please enter notes',   30),
            ('please_enter_title',  'Please enter title',   '".$language."',    'Please enter title',   30),
            ('please_select_date',  'Please Select Date',   '".$language."',    'Please Select Date',   30),
            ('search_by_date',  'Search by Date',   '".$language."',    'Search by Date',   30),
            ('shortcut_not_setup_yet',  'Opps shortcut not setup yet!!! Please add shortcut by click on [icon] from record search results or view record screen.',  '".$language."',    'Opps shortcut not setup yet!!! Please add shortcut by click on [icon] from record search results or view record screen.',  30),
            ('max_upload_size', 'max file Upload exceeds',  '".$language."',    'max file Upload exceeds',  30),
            ('unselect_all',    'UnSelect All', '".$language."',    'UnSelect All', 30),
            ('select_all',  'Select All',   '".$language."',    'Select All',   30),
            ('please_select_records',   'Please select records',    '".$language."',    'Please select records',    30),
            ('select_date', 'Select Date',  '".$language."',    'Select Date',  30),
            ('quantity_in_stock_is',    'Quantity in stock is', '".$language."',    'Quantity in stock is', 30),
            ('replies', 'Replies',  '".$language."',    'Replies',  30),
            ('conversation_require_selection',  'Conversion requires selection of Contact or Organization', '".$language."',    'Conversion requires selection of Contact or Organization', 30),
            ('please_select_product',   'Please Select Product',    '".$language."',    'Please Select Product',    30),
            ('timer_msg',   'You can start timer for single task only at same time',    '".$language."',    'You can start timer for single task only at same time',    31),
            ('save_start_tracking', 'Save & Start Tracking',    '".$language."',    'Save & Start Tracking',    31),
            ('lbl_notes',   'Notes',    '".$language."',    'Notes',    31),
            ('enter_title', 'Enter Title',  '".$language."',    'Enter Title',  31),
            ('select_module_record',    'Select Module / Record',   '".$language."',    'Select Module / Record',   31),
            ('lbl_tomorrow',    'Tomorrow', '".$language."',    'Tomorrow', 30),
            ('lbl_yesterday',   'Yesterday',    '".$language."',    'Yesterday',    30),
            ('lbl_today',   'Today',    '".$language."',    'Today',    30),
            ('time_tracker',    'Time Tracker', '".$language."',    'Time Tracker', 31),
            ('time_end',    'End Time', '".$language."',    'End Time', 5),
            ('due_date',    'End Date', '".$language."',    'End Date', 5),
            ('time_start',  'Time Start',   '".$language."',    'Time Start',   5),
            ('date_start',  'Start Date',   '".$language."',    'Start Date',   5),
            ('delete_widget_msg',   'Display widget again by using (+) option', '".$language."',    'Display widget again by using (+) option', 15),
            ('no_upcoming_activities',  'No scheduled activities    ',  '".$language."',    'No scheduled activities    ',  15),
            ('check_in_first',  'Please check-in first',    '".$language."',    'Please check-in first',    30),
            ('duration',    'Duration', '".$language."',    'Duration', 30),
            ('distance',    'Distance', '".$language."',    'Distance', 30),
            ('proper_address_message',  'Please enter proper address in record\n',  '".$language."',    'Please enter proper address in record',    30),
            ('select_status',   'Select Status',    '".$language."',    'Select Status',    30),
            ('route_planner',   'Route Planner',    '".$language."',    'Route Planner',    30),
            ('route_planning',  'Route Planning',   '".$language."',    'Route Planning',   30),
            ('add_route',   'Add Route',    '".$language."',    'Add Route',    30),
            ('calender_disabled',   'Calendar Module is disabled',  '".$language."',    'Calendar Module is disabled',  30),
            ('close_dialog',    'Close form',   '".$language."',    'Close form',   30),
            ('cancel_form_message', 'Are You sure want to close ?', '".$language."',    'Are You sure want to close ?', 30),
            ('create_route',    'Create Route', '".$language."',    'Create Route', 30),
            ('select_module_create_route',  'Select Module to create Route',    '".$language."',    'Select Module to create Route',    30),
            ('cancel',  'Cancel',   '".$language."',    'Cancel',   30),
            ('assign_route',    'Assign Route', '".$language."',    'Assign Route', 30),
            ('route_for',   'Route for',    '".$language."',    'Route for',    30),
            ('assigned_to', 'Assigned To',  '".$language."',    'Assigned To',  30),
            ('enter_route_name',    'Enter Route Name', '".$language."',    'Enter Route Name', 30),
            ('list',    'List', '".$language."',    'List', 30),
            ('map', 'Map',  '".$language."',    'Map',  30),
            ('other_modules',   'Other Modules',    '".$language."',    'Other Modules',    15),
            ('shortcut_no_record_msg',  'Opps shortcut not setup\n yet!!! Please add shortcut  by click on + icon from record\n search results or view record screen.', '".$language."',    'Opps shortcut not setup\n yet!!! Please add shortcut  by click on + icon from record\n search results or view record screen.', 25),
            ('clear',   'Clear',    '".$language."',    'Clear',    25),
            ('open',    'Open', '".$language."',    'Open', 11),
            ('max_file_msg',    'Too many files selected (max:6)',  '".$language."',    'Too many files selected (max:6)',  11),
            ('error_voicenote_record',  'Unable to recording voice while another application is recording sound.',  '".$language."',    'Unable to recording voice while another application is recording sound.',  11),
            ('msg_warning', 'Warning!', '".$language."',    'Warning!', 11),
            ('Permision_denied_contact',    'Permission denied to access your contacts',    '".$language."',    'Permission denied to access your contacts',    15),
            ('no_widget_added', 'Please click + icon to add new widget to your dashboard.', '".$language."',    'Please click + icon to add new widget to your dashboard.', 15),
            ('no_data_available',   'Data not available, please check the selected fields', '".$language."',    'Data not available, please check the selected fields', 15),
            ('check_out_successfully',  'Check out successfully',   '".$language."',    'Checked out successfully', 11),
            ('check_in_successfully',   'Check in successfully',    '".$language."',    'Checked in successfully',  11),
            ('check_out',   'Check out',    '".$language."',    'Check out',    11),
            ('check_in',    'Check in', '".$language."',    'Check in', 11),
            ('navigate',    'Navigate', '".$language."',    'Navigate', 11),
            ('save_to_phone_vcard_success', 'VCard Saved to phone successfully',    '".$language."',    'VCard Saved to phone successfully',    15),
            ('download_vcard_success',  'VCard downloaded successfully',    '".$language."',    'VCard downloaded successfully',    15),
            ('card_details',    'Card Details', '".$language."',    'Card Details', 15),
            ('add_widget',  'Add Widget',   '".$language."',    'Add Widget',   15),
            ('delete_widget',   'Are you sure to hide widget?', '".$language."',    'Are you sure to hide widget?', 15),
            ('already_widgets_added',   'All types of Widget & reports are already added',  '".$language."',    'All types of Widget & reports are already added',  15),
            ('retry',   'Retry',    '".$language."',    'Retry',    28),
            ('retake',  'Retake',   '".$language."',    'Retake',   28),
            ('Reports', 'Reports',  '".$language."',    'Reports',  15),
            ('Widgets', 'Widgets',  '".$language."',    'Widgets',  15),
            ('vcard_config',    'Vcard Configuration',  '".$language."',    'Vcard Configuration',  8),
            ('save_to_phone',   'Save to phone',    '".$language."',    'Save to phone',    11),
            ('download_vcard',  'Download Vcard',   '".$language."',    'Download Vcard',   11),
            ('share_vcard', 'Share Vcard',  '".$language."',    'Share Vcard',  11),
            ('share_record',    'Share Record', '".$language."',    'Share Record', 11),
            ('permission_denied_edit',  'You don\'t have permission to edit this record.',  '".$language."',    'You don\'t have permission to edit this record.',  27),
            ('permission_denied_delete',    'You don\'t have permission to delete this record.',    '".$language."',    'You don\'t have permission to delete this record.',    27),
            ('Voice_Recording_Started', 'Recording Started',    '".$language."',    'Recording Started',    12),
            ('Voice_Recording_Stopped', 'Recording Stopped',    '".$language."',    'Recording Stopped',    12),
            ('SEARCH',  'Search',   '".$language."',    'Search',   7),
            ('LAST',    'Last', '".$language."',    'Last', 7),
            ('FIRST',   'First',    '".$language."',    'First',    7),
            ('MONDAY',  'Monday',   '".$language."',    'Monday',   7),
            ('TUESDAY', 'Tuesday',  '".$language."',    'Tuesday',  7),
            ('WEDNESDAY',   'Wednesday',    '".$language."',    'Wednesday',    7),
            ('THURSDAY',    'Thursday', '".$language."',    'Thursday', 7),
            ('FRIDAY',  'Friday',   '".$language."',    'Friday',   7),
            ('SATURDAY',    'Saturday', '".$language."',    'Saturday', 7),
            ('SUNDAY',  'Sunday',   '".$language."',    'Sunday',   7),
            ('DAILY',   'Daily',    '".$language."',    'Daily',    7),
            ('WEEKLY',  'Weekly',   '".$language."',    'Weekly',   7),
            ('MONTHLY', 'Monthly',  '".$language."',    'Monthly',  7),
            ('YEARLY',  'Yearly',   '".$language."',    'Yearly',   7),
            ('asset_tracking',  'Asset tracking',   '".$language."',    'Asset tracking',   15);",array());
    }

    static function ar_ae(){
         global $adb;
        $checkQuery = "DELETE FROM ctmobile_language_keyword WHERE keyword_lang = ?";
        $checkResult = $adb->pquery($checkQuery,array('ar_ae'));

        $adb->pquery("INSERT INTO `ctmobile_language_keyword` (`keyword`, `keyword_name`, `keyword_lang`, `language_keyword`, `sectionid`) VALUES
            ('network_error', 'Network connection error!', 'ar_ae', 'خطأ في الشبكة!', 1),
            ('connection_check', 'Could not connect to CRM, Please check your Internet connection.', 'ar_ae', 'الرجاء التحقق من اتصال الانترنت الخاص بك.', 1),
            ('update', 'Update', 'ar_ae', 'تحديث', 1),
            ('cancel', 'Cancel', 'ar_ae', 'Cancel', 1),
            ('ok', 'Ok', 'ar_ae', 'حسنا', 1),
            ('more_information', 'Click here for more information.', 'ar_ae', 'انقر هنا للمزيد من المعلومات.', 1),
            ('yes', 'Yes', 'ar_ae', 'نعم فعلا', 1),
            ('no', 'No', 'ar_ae', 'لا', 1),
            ('click_again_exit', 'Click again to exit', 'ar_ae', 'انقر مرة أخرى للخروج', 1),
            ('forpermission', 'You don\'t have permission to view this feature. Please subscribe for Premium version Click here to Subscribe.', 'ar_ae', 'ليس لديك إذن لعرض هذه الميزات. يرجى الاشتراك للحصول على نسخة متميزة انقر هنا للاشتراك.', 1),
            ('clickhere', 'Click here', 'ar_ae', 'انقر هنا', 1),
            ('clickhere_subscribe', 'Click here to subscribe premium version', 'ar_ae', 'انقر هنا للاشتراك في الإصدار المميز', 1),
            ('clickhere_configure', 'Click here and view how to Configure.', 'ar_ae', 'انقر هنا وعرض كيفية تكوين.', 1),
            ('please_wait', 'Please Wait…', 'ar_ae', 'ارجوك انتظر…', 1),
            ('share__msg', 'Share file with', 'ar_ae', 'مشاركة الملف مع', 1),
            ('dialog_camera', 'Camera', 'ar_ae', 'الة تصوير', 1),
            ('dialog_add_file_by', 'Take Photo from', 'ar_ae', 'إضافة ملفات', 1),
            ('add', 'Add', 'ar_ae', 'إضافة', 1),
            ('mail_manager_configured', 'Mail Manager is not configured', 'ar_ae', 'لم يتم تكوين مدير البريد', 1),
            ('dialog_add_files_by', 'Add Files by', 'ar_ae', 'إضافة ملفات', 1),
            ('dialog_drive', 'Drive', 'ar_ae', 'قيادة', 1),
            ('dialog_drop_box', 'Drop Box', 'ar_ae', 'بصندوق الإسقاط', 1),
            ('dialog_need_signin', 'You need to Sign-in to your Drive account first.', 'ar_ae', 'يجب تسجيل الدخول إلى حساب Drive أولاً.', 1),
            ('dialog_gallery', 'Gallery', 'ar_ae', 'صالة عرض', 1),
            ('delete', 'Delete', 'ar_ae', 'حذف', 1),
            ('timeoutmessage', 'Oops! Request is taking more time than expected.', 'ar_ae', 'انتبه! الطلب يستغرق وقتًا أكثر مما هو متوقع.', 1),
            ('gps_location_message', 'GPS is not enabled. Please turn it on to get your near by locations.', 'ar_ae', 'لم يتم تمكين GPS. يرجى تشغيلها للحصول على قرب من المواقع.', 1),
            ('sure_want_delete', 'Are you sure want to delete ?', 'ar_ae', 'هل أنت متأكد من حذف؟', 1),
            ('select', 'Select', 'ar_ae', 'تحديد', 1),
            ('msgforrecordaudio', 'Minimum record duration one second.', 'ar_ae', 'اقل وقت للتسجيل ثانيه واحده', 1),
            ('permission_storage', 'Permission denied to read your External storage', 'ar_ae', 'تم رفض الإذن لقراءة وحدة التخزين الخارجية', 1),
            ('send_permission_msg', 'Send message permission denied', 'ar_ae', 'إرسال تم رفض الإذن', 1),
            ('choosefile', 'Choose File', 'ar_ae', 'اختر ملف', 1),
            ('enter', 'Enter', 'ar_ae', 'أدخل', 1),
            ('select_an_option', 'Select an Option', 'ar_ae', 'اختار', 1),
            ('email_validation', 'Email is not valid', 'ar_ae', 'البريد الإلكتروني غير صالح', 1),
            ('please_enter', 'Please Enter', 'ar_ae', 'تفضل ', 1),
            ('website_validation_text', 'Website URL is not valid', 'ar_ae', 'عنوان url للموقع غير صالح', 1),
            ('selectvalue', 'Select value first', 'ar_ae', 'حدد القيمة أولا', 1),
            ('email', 'Email', 'ar_ae', 'البريد الإلكتروني', 1),
            ('enter_email_address', 'Enter email address', 'ar_ae', 'أدخل عنوان البريد الالكتروني', 1),
            ('email_address_not_correct', 'Email address incorrect', 'ar_ae', 'عنوان البريد الالكتروني غير صحيح', 1),
            ('pls_enter_subject', 'Please Enter Subject', 'ar_ae', 'من فضلك أدخل الموضوع', 1),
            ('attachFiles', 'Attached File', 'ar_ae', 'ملف مرفق', 1),
            ('from', 'From', 'ar_ae', 'من عند', 1),
            ('to', 'To', 'ar_ae', 'إلى', 1),
            ('call_permission_msg', 'Call permission denied', 'ar_ae', 'رفض تصريح المكالمة', 1),
            ('no_records', 'No records found', 'ar_ae', 'لا توجد سجلات', 1),
            ('fullform', 'Create New', 'ar_ae', 'خلق جديد إبداع جديد', 1),
            ('save', 'Save', 'ar_ae', 'حفظ', 1),
            ('total', 'Total', 'ar_ae', 'مجموع', 1),
            ('discount', 'Discount', 'ar_ae', 'خصم(٪)', 1),
            ('price', 'Price', 'ar_ae', 'السعر *', 1),
            ('quantity', 'Quantity', 'ar_ae', 'الكمية *', 1),
            ('select_module', 'Select Module', 'ar_ae', 'حدد الوحدة', 1),
            ('item_list', 'Item List', 'ar_ae', 'قائمة البند', 1),
            ('quickcreate', 'Quick Create', 'ar_ae', 'إنشاء سريع', 1),
            ('overwrite_msg_part1', 'Overwrite the existing address with the selected', 'ar_ae', 'الكتابه علي العنوان الحالي بالعنوان المختار', 1),
            ('once_in_every', 'Once in every', 'ar_ae', 'مرة واحدة في كل', 1),
            ('overwrite_msg_part2', 'address details?', 'ar_ae', 'تفاصيل العنوان', 1),
            ('add_item', 'Add Item', 'ar_ae', 'اضافة عنصر', 1),
            ('recordsave', 'Record saved successfully', 'ar_ae', 'حفظ السجل بنجاح', 1),
            ('recordnotsave', 'Could not save record. Try again later', 'ar_ae', 'السجل لا يحفظ', 1),
            ('minutes', 'Minutes', 'ar_ae', 'الدقائق', 1),
            ('hours', 'Hours', 'ar_ae', 'ساعات', 1),
            ('days', 'Days', 'ar_ae', 'أيام', 1),
            ('on', 'On', 'ar_ae', 'على', 1),
            ('day_of_the_month', 'day of the month', 'ar_ae', 'يوم من الشهر', 1),
            ('list_price', 'List Price', 'ar_ae', 'قائمة الأسعار *', 1),
            ('add_record', 'Add Record', 'ar_ae', 'أضف سجل', 1),
            ('add_product', 'Add Product', 'ar_ae', 'أضف منتج', 1),
            ('add_service', 'Add Service', 'ar_ae', 'أضف خدمة', 1),
            ('discountin', 'Discount in %', 'ar_ae', 'الخصم في٪', 1),
            ('unitprice', 'Unit price', 'ar_ae', 'Unit price', 1),
            ('netprice', 'Net price', 'ar_ae', 'السعر الصافي*', 1),
            ('comments', 'Comments', 'ar_ae', 'تعليقات', 1),
            ('add_close', 'Add & Close', 'ar_ae', 'إضافة وإغلاق', 1),
            ('fetching_rout_message', 'Fetching route, Please wait…', 'ar_ae', 'إحضار الطريق ، يرجى الانتظار …', 1),
            ('setting', 'Settings', 'ar_ae', 'الإعدادات', 1),
            ('utc', 'UTC', 'ar_ae', 'التوقيت العالمي', 1),
            ('in', 'In', 'ar_ae', 'في ', 1),
            ('days_ago', 'days ago', 'ar_ae', 'أيام مضت', 1),
            ('mins_ago', 'Minutes ago', 'ar_ae', 'قبل دقيقة', 1),
            ('justnow', 'Just now', 'ar_ae', 'الآن فقط', 1),
            ('hours_ago', 'hours ago', 'ar_ae', 'منذ ساعات', 1),
            ('in_1_day', 'In 1 day', 'ar_ae', 'في يوم واحد', 1),
            ('scanqrcode', 'Asset / Card scanner', 'ar_ae', 'ماسحة بطاقة', 1),
            ('call_log', 'Call Log', 'ar_ae', 'سجل المكالمات', 1),
            ('voice_message', 'Hi', 'ar_ae', 'اهلا', 1),
            ('voice_message1', 'What can I search for you in', 'ar_ae', 'عن ماذا تريد ان ابحث لك', 1),
            ('live_tracking', 'Live Tracking', 'ar_ae', 'تتبع مباشر (فريق)', 1),
            ('mailmanager', 'Mail Manager', 'ar_ae', 'مدير البريد', 1),
            ('my_location', 'My location', 'ar_ae', 'موقعي', 1),
            ('created_on', 'Created On', 'ar_ae', 'تم إنشاؤها على', 1),
            ('modified_on', 'Modified On', 'ar_ae', 'تعديل على', 1),
            ('enter_comments', 'Enter Comments', 'ar_ae', 'أدخل التعليقات', 1),
            ('viewmore', 'View More', 'ar_ae', 'عرض المزيد', 1),
            ('viewless', 'View Less', 'ar_ae', 'عرض أقل', 1),
            ('gotofullform', 'Go to Full Form', 'ar_ae', 'الذهاب إلى النموذج الكامل', 1),
            ('post', 'Post', 'ar_ae', 'بريد', 1),
            ('url', 'URL', 'ar_ae', 'URL', 1),
            ('dialog_title_text_back_color', 'Select a Text Background Color', 'ar_ae', 'Select a Text Background Color', 1),
            ('event_or_task', 'Add event/task', 'ar_ae', 'اضافه حدث/ مهمه', 1),
            ('shortcut', 'Shortcuts', 'ar_ae', 'اختصارات', 1),
            ('select_field', 'Select Field', 'ar_ae', 'اختر المجال', 1),
            ('share', 'Share', 'ar_ae', 'شارك', 1),
            ('title_insert_link', 'Insert Link', 'ar_ae', 'Insert Link', 1),
            ('addyourcommentshere', 'Add your comments here', 'ar_ae', 'أضف تعليقاتك هنا', 1),
            ('nocomment', 'No Comments', 'ar_ae', 'لا تعليقات', 1),
            ('leads', 'Leads', 'ar_ae', 'يؤدي', 1),
            ('true_val', 'true', 'ar_ae', 'true', 1),
            ('noresult', 'No Result', 'ar_ae', 'No Result', 1),
            ('version', 'Version', 'ar_ae', 'الإصدار', 1),
            ('convert_lead', 'Convert Lead', 'ar_ae', 'تحويل العميل المحتمل', 1),
            ('app_name', 'CRMTiger', 'ar_ae', 'SalesHiker', 1),
            ('enter_url', 'Please Enter url', 'ar_ae', 'يرجى إدخال url', 1),
            ('help', 'Help', 'ar_ae', 'مساعدة', 1),
            ('contact_us', 'Contact Us', 'ar_ae', 'اتصل بنا', 1),
            ('updates', 'Updates', 'ar_ae', 'تحديث', 1),
            ('logout', 'LogOut', 'ar_ae', 'الخروج', 1),
            ('busnies_cardscanner', 'Business Card Scanner', 'ar_ae', 'مسح ضوئي للكارت', 1),
            ('sure_want_logout', 'Are you sure want to logout ?', 'ar_ae', 'هل أنت متأكد من تسجيل الخروج؟', 1),
            ('logout_message', 'Logout successfully', 'ar_ae', 'Logout successfully', 1),
            ('all', 'All', 'ar_ae', 'الكل', 1),
            ('add_event', 'Add event', 'ar_ae', 'اضافه حدث', 1),
            ('add_task', 'Add Task', 'ar_ae', 'اضافه مهمه', 1),
            ('next', 'Next', 'ar_ae', 'التالي', 1),
            ('terms_conditions', 'Terms and Conditions', 'ar_ae', 'Terms and Conditions', 1),
            ('login', 'Login', 'ar_ae', 'تسجيل الدخول', 2),
            ('privacy_policay', 'By logging in, you agree to our Terms and Conditions & Privacy Policy', 'ar_ae', 'من خلال تسجيل الدخول ، فإنك توافق على الشروط والأحكام  سياسة خاصة', 2),
            ('copyright', 'Copyright © 2019 CRMTiger Version', 'ar_ae', 'حقوق الطبع والنشر © 2019clickhere_subscribe CRMTiger الإصدار', 2),
            ('enter_username', 'Please enter username', 'ar_ae', 'الرجاء إدخال اسم المستخدم', 2),
            ('enter_password', 'Please enter password', 'ar_ae', 'يرجى إدخال كلمة المرور', 2),
            ('remanberme', 'Remember Me', 'ar_ae', 'تذكرنى', 2),
            ('forgot_password', 'Forgot password?', 'ar_ae', 'هل نسيت كلمة المرور؟', 2),
            ('privacy_policay1', 'Privacy Policy', 'ar_ae', 'سياسة خاصة', 2),
            ('contactsupportmsg', 'Something went wrong. \\n please Click here to contact support.', 'ar_ae', 'هناك خطا ما يرجي الضغط هنا للتواصل مع الدعم الفني', 2),
            ('enter_username_password', 'Entered Username or Password is wrong', 'ar_ae', 'اسم المستخدم أو كلمة المرور المدخلتين غير صحيحين', 2),
            ('server_issue_occured', 'Server issues occurred', 'ar_ae', 'ظهر تعطل بالخادم ', 2),
            ('password', 'Password', 'ar_ae', 'كلمه السر', 3),
            ('user_name', 'Username', 'ar_ae', 'اسم المستخدم', 3),
            ('reset_pwd', 'Reset Password', 'ar_ae', 'إعادة ضبط كلمة المرور', 3),
            ('forgot_password_title', 'Forgot password', 'ar_ae', 'هل نسيت كلمة المرور', 3),
            ('enter_user_name', 'Enter user name', 'ar_ae', 'ادخل اسم المستخدم', 3),
            ('cc', 'Cc', 'ar_ae', 'سم مكعب', 4),
            ('body', 'Body', 'ar_ae', 'الجسم', 4),
            ('bcc', 'BCC', 'ar_ae', 'مخفية', 4),
            ('dialog_title_text_color', 'Select a Text Color', 'ar_ae', 'حدد لون النص', 4),
            ('date', 'Date', 'ar_ae', 'تاريخ', 4),
            ('subject', 'Subject', 'ar_ae', 'موضوع', 4),
            ('composeMail', 'Compose Mail', 'ar_ae', 'كتابة رسالة', 4),
            ('send', 'Send', 'ar_ae', 'إرسال', 4),
            ('select_message', 'Select message', 'ar_ae', 'اختر الرسالة', 4),
            ('title_insert_table', 'Insert Table', 'ar_ae', 'إدراج جدول', 4),
            ('log_file_sms', 'I agree to Share API Log to Technical team for further troubleshooting', 'ar_ae', 'أوافق على مشاركة سجل API إلى الفريق الفني لمزيد من استكشاف الأخطاء وإصلاحها', 5),
            ('edit_record', 'Edit Records', 'ar_ae', 'تحرير السجل', 5),
            ('select_time', 'Select Time', 'ar_ae', 'اختر الوقت', 5),
            ('edit_item', 'Edit Item', 'ar_ae', 'Edit Item', 5),
            ('items_total', 'Items Total', 'ar_ae', 'Items Total', 5),
            ('number_less_then_31', 'Number should be less than 31', 'ar_ae', 'الرقم لابد ان يكون اقل من 31', 5),
            ('users', 'Users', 'ar_ae', 'المستخدمين', 5),
            ('groups', 'Groups', 'ar_ae', 'المجموعات', 5),
            ('txt_note_for_file', 'Note : Existing attachments(images/files) will be replaced', 'ar_ae', 'ملاحظة: سيتم استبدال المرفقات الحالية (الصور / الملفات)', 5),
            ('greaterdatetime', 'End DateTime should be greater than Start DateTime', 'ar_ae', 'يجب أن يكون تاريخ ووقت الانتهاء أكبر من تاريخ ووقت البدء', 5),
            ('until', 'Until', 'ar_ae', 'حتى', 5),
            ('organizations', 'Organizations', 'ar_ae', 'المنظمات', 6),
            ('contacts', 'Contacts', 'ar_ae', 'جهات الاتصال', 6),
            ('opportunity', 'Opportunity', 'ar_ae', 'فرصة', 6),
            ('lbl_sun', 'SUN', 'ar_ae', 'شمس', 7),
            ('lbl_mon', 'MON', 'ar_ae', 'MON', 7),
            ('lbl_tue', 'TUE', 'ar_ae', 'TUE', 7),
            ('lbl_wed', 'WED', 'ar_ae', 'WED', 7),
            ('lbl_thu', 'THU', 'ar_ae', 'THU', 7),
            ('lbl_fri', 'FRI', 'ar_ae', 'جمعة', 7),
            ('lbl_sat', 'SAT', 'ar_ae', 'جلسنا', 7),
            ('lbl_1', '1', 'ar_ae', '1', 7),
            ('lbl_2', '2', 'ar_ae', '2', 7),
            ('lbl_3', '3', 'ar_ae', '3', 7),
            ('lbl_4', '4', 'ar_ae', '4', 7),
            ('lbl_5', '5', 'ar_ae', '5', 7),
            ('lbl_6', '6', 'ar_ae', '6', 7),
            ('lbl_7', '7', 'ar_ae', '7', 7),
            ('lbl_8', '8', 'ar_ae', '8', 7),
            ('lbl_9', '9', 'ar_ae', '9', 7),
            ('lbl_10', '10', 'ar_ae', '10', 7),
            ('lbl_11', '11', 'ar_ae', '11', 7),
            ('lbl_12', '12', 'ar_ae', '12', 7),
            ('lbl_13', '13', 'ar_ae', '13', 7),
            ('lbl_14', '14', 'ar_ae', '14', 7),
            ('lbl_15', '15', 'ar_ae', '15', 7),
            ('lbl_16', '16', 'ar_ae', '16', 7),
            ('lbl_17', '17', 'ar_ae', '17', 7),
            ('lbl_18', '18', 'ar_ae', '18', 7),
            ('lbl_19', '19', 'ar_ae', '19', 7),
            ('lbl_20', '20', 'ar_ae', '20', 7),
            ('lbl_21', '21', 'ar_ae', '21', 7),
            ('lbl_22', '22', 'ar_ae', '22', 7),
            ('lbl_23', '23', 'ar_ae', '23', 7),
            ('lbl_24', '24', 'ar_ae', '24', 7),
            ('lbl_25', '25', 'ar_ae', '25', 7),
            ('lbl_26', '26', 'ar_ae', '26', 7),
            ('lbl_27', '27', 'ar_ae', '27', 7),
            ('lbl_28', '28', 'ar_ae', '28', 7),
            ('lbl_29', '29', 'ar_ae', '29', 7),
            ('lbl_30', '30', 'ar_ae', '30', 7),
            ('lbl_31', '31', 'ar_ae', '31', 7),
            ('lbl_32', '32', 'ar_ae', '32', 7),
            ('lbl_33', '33', 'ar_ae', '33', 7),
            ('lbl_34', '34', 'ar_ae', '34', 7),
            ('lbl_35', '35', 'ar_ae', '35', 7),
            ('lbl_36', '36', 'ar_ae', '36', 7),
            ('lbl_37', '37', 'ar_ae', '37', 7),
            ('lbl_38', '38', 'ar_ae', '38', 7),
            ('lbl_39', '39', 'ar_ae', '39', 7),
            ('lbl_40', '40', 'ar_ae', '40', 7),
            ('lbl_41', '41', 'ar_ae', '41', 7),
            ('lbl_42', '42', 'ar_ae', '42', 7),
            ('current_date', 'current date', 'ar_ae', 'التاريخ الحالي', 7),
            ('event', 'Events', 'ar_ae', 'أحداث', 7),
            ('calendar', 'Calendar', 'ar_ae', 'التقويم', 7),
            ('latest_version', 'Latest Version :', 'ar_ae', 'احدث اصدار : ', 8),
            ('expire_on', 'Expire On :', 'ar_ae', 'تنتهي في:', 8),
            ('ctmobile_ext_version', 'CTMobile Ext. Version :', 'ar_ae', 'CTMobile تحويلة. الإصدار :', 8),
            ('you_have_latest_version', 'You already have latest version', 'ar_ae', 'لديك بالفعل أحدث نسخة', 8),
            ('latest_version1', 'You Already have latest version', 'ar_ae', 'لديك بالفعل أحدث نسخة', 8),
            ('upgreaded', 'Upgrade', 'ar_ae', 'تطوير', 8),
            ('downgrade', 'Downgrade', 'ar_ae', 'تخفيض', 8),
            ('dialog_recent_event_info', 'You can set from here how many number of records you want to show on Home screen for Recent Event.', 'ar_ae', 'يمكنك تعيين عدد السجلات التي تريد إظهارها على الشاشة الرئيسية للحدث الأخير من هنا.', 8),
            ('dialog_feedback_info', 'You can submit your feedback with description , our team will check your feedback and get back to you.', 'ar_ae', 'يمكنك تعيين عدد السجلات التي تريد إظهارها على الشاشة الرئيسية للحدث الأخير من هنا.', 8),
            ('dialog_log_info', 'Log functionality is used for customer support / help , If you are facing any issues in app or any module or functionality is not working proper then you can enable share log with our development team.', 'ar_ae', 'يتم استخدام وظيفة سجل لدعم / مساعدة العملاء ، إذا كنت تواجه أي مشاكل في التطبيق أو أي وحدة نمطية أو وظيفة لا يعمل بشكل صحيح ، يمكنك تمكين سجل المشاركة مع فريق التطوير لدينا.', 8),
            ('info', 'Info', 'ar_ae', 'معلومات', 8),
            ('recent_history', 'Recent History', 'ar_ae', 'التاريخ الحديث', 8),
            ('recent_feedback', 'Feedback', 'ar_ae', 'ردود الفعل', 8),
            ('recent_log', 'Log', 'ar_ae', 'سجل', 8),
            ('crmtiger_app_version', 'CRMTiger App Version :', 'ar_ae', 'إصدار تطبيق CRMTiger:', 8),
            ('historylimit', 'Recent History Limit', 'ar_ae', 'حد التاريخ الحديث', 8),
            ('radious_in_miles', 'Radius in miles', 'ar_ae', 'نصف القطر بالأميال', 8),
            ('recentlimit', 'Recent Event Limit', 'ar_ae', 'حدود الأحداث الأخيرة', 8),
            ('upcoming_events', 'Upcoming Events', 'ar_ae', 'الأحداث القادمة', 8),
            ('rate_our_app', 'Rate Our App!', 'ar_ae', 'قيم التطبيق', 8),
            ('feedback', 'Submit Feedback', 'ar_ae', 'إرسال ملاحظات', 8),
            ('sendfeedback', 'Feedback Send', 'ar_ae', 'Feedback Send', 8),
            ('emaillimit', 'Email limit', 'ar_ae', 'حد البريد الإلكتروني', 8),
            ('log', 'Log', 'ar_ae', 'سجل', 8),
            ('logclear', 'Log cleared successfully.', 'ar_ae', 'تم محو السجل بنجاح', 8),
            ('dialog_recent_history_info', 'You can set from here how many number of records you want to show on Home screen for Recent History.', 'ar_ae', 'يمكنك تعيين عدد السجلات التي تريد إظهارها على الشاشة الرئيسية للسجل الحديث من هنا.', 8),
            ('proceed_to_upgrade1', 'Proceed to', 'ar_ae', 'الشروع في', 8),
            ('upgradation_message', 'will required logout and login again later.', 'ar_ae', 'يتطلب الخروج من البرنامج و الخول مره اخري', 8),
            ('proceed_to_upgrade', 'Proceed to Upgrade', 'ar_ae', 'يجري التحديث الان', 8),
            ('module_setting', 'Module Setting', 'ar_ae', 'إعدادات الوحدة', 9),
            ('sortbyfield', 'Sort by field', 'ar_ae', 'الترتيب حسب المجال', 9),
            ('ascending', 'Ascending  A to Z', 'ar_ae', 'تصاعدي A إلى Z', 9),
            ('descending', 'Descending  Z to A', 'ar_ae', 'تنازلي Z إلى A', 9),
            ('first_field', 'First Field', 'ar_ae', 'الحقل الأول', 9),
            ('second_field', 'Second Field', 'ar_ae', 'الحقل الثاني', 9),
            ('third_field', 'Third Field', 'ar_ae', 'المجال الثالث', 9),
            ('sure_want_restore', 'Are you sure you want to reset to default settings?', 'ar_ae', 'هل تريد بالتأكيد إعادة تعيين الإعدادات الافتراضية؟', 9),
            ('orderlist', 'List Order', 'ar_ae', 'ترتيب القائمة', 9),
            ('module_reset', 'Restore to Default', 'ar_ae', 'إعادة تعيين إلى الافتراضي', 9),
            ('display_fields', 'Display Fields', 'ar_ae', 'حقول العرض', 9),
            ('discount_lessthen_100', 'Discount % should be less than 100', 'ar_ae', 'يجب أن يكون الخصم٪ أقل من 100', 10),
            ('select_item', 'Select Item', 'ar_ae', 'اختر البند', 10),
            ('item_comment', 'Item Comment', 'ar_ae', 'تعليق البند', 10),
            ('record_name', 'Record Name is :', 'ar_ae', 'مسجل باسم', 11),
            ('go_back', 'Go Back', 'ar_ae', 'Go Back', 11),
            ('please_enter_shortcut_name', 'Please Enter Shortcut Name', 'ar_ae', 'الرجاء إدخال اسم الاختصار', 11),
            ('number_not_found', 'Contact Number not found', 'ar_ae', 'رقم الاتصال غير موجود', 11),
            ('mail_not_found', 'Mail Address not found', 'ar_ae', 'عنوان البريد غير موجود ', 11),
            ('create_shortcut', 'Create Shortcut', 'ar_ae', 'انشاء اختصار', 11),
            ('contact_summary', 'Summary', 'ar_ae', 'Summary', 11),
            ('activites', 'Activities', 'ar_ae', 'أنشطة', 11),
            ('details', 'Details', 'ar_ae', 'Details', 11),
            ('related', 'Related', 'ar_ae', 'Related', 11),
            ('share_link', 'Share record with', 'ar_ae', 'مشاركه المجل مع', 11),
            ('edit', 'Edit', 'ar_ae', 'اضافه', 11),
            ('duplicate', 'Duplicate', 'ar_ae', 'مكرر', 11),
            ('whatsapp', 'Whatsapp', 'ar_ae', 'واتس اب', 11),
            ('call', 'Call', 'ar_ae', 'مكالمه', 11),
            ('choose_contact_for_call', 'Choose Contact for Call', 'ar_ae', 'اختار اسم للاتصال', 11),
            ('choose_contact_for_sms', 'Choose Contact for SMS', 'ar_ae', 'اختار اسم لارسال رساله قصيره', 11),
            ('choose_contact_for_whatsapp', 'Choose Contact for WhatsApp', 'ar_ae', 'اختار اسم لارسال واتس اب', 11),
            ('chosse_contact_for_email', 'Choose Email', 'ar_ae', 'اختار بريد الكتروني', 11),
            ('attach_file', 'Attach Files', 'ar_ae', 'اضافه ملحقات', 11),
            ('close', 'Close', 'ar_ae', 'اغلق', 11),
            ('status', 'Status', 'ar_ae', 'الحالة', 11),
            ('stop', 'Stop', 'ar_ae', 'توقف', 11),
            ('zero', '0', 'ar_ae', '0', 11),
            ('record', 'Record', 'ar_ae', 'تسجيل', 11),
            ('voice_note', 'Voice Note', 'ar_ae', 'مفكره صوتيه', 11),
            ('tickets', 'Tickets', 'ar_ae', 'تذاكر', 12),
            ('check_out', 'Check Out', 'ar_ae', 'الدفع', 12),
            ('check_in', 'Check In', 'ar_ae', 'تحقق في', 12),
            ('select_any', 'Select any', 'ar_ae', 'Select any', 12),
            ('fulldetails', 'Show Full Details', 'ar_ae', 'إظهار التفاصيل الكاملة', 12),
            ('checkin', 'Check-in', 'ar_ae', 'تحقق في', 12),
            ('navigate', 'Navigate', 'ar_ae', 'التنقل', 12),
            ('product', 'Products', 'ar_ae', 'منتجات', 12),
            ('projectMilestone', 'Project Milestone', 'ar_ae', 'معلما المشروع', 12),
            ('projecttask', 'Project Tasks', 'ar_ae', 'المشاريع المهمة', 12),
            ('nearby', 'NearBy', 'ar_ae', 'مجاوز', 13),
            ('document', 'Document', 'ar_ae', 'وثيقة', 14),
            ('reply', 'Reply', 'ar_ae', 'الرد', 14),
            ('reply_all', 'Reply All', 'ar_ae', 'الرد على الجميع', 14),
            ('forward', 'Forward', 'ar_ae', 'إلى الأمام', 14),
            ('action', 'Action', 'ar_ae', 'عمل', 14),
            ('select_first', 'Select First', 'ar_ae', 'اختار اولا', 14),
            ('commentaddsuccessful', 'Comment added successfull', 'ar_ae', 'تم إضافة التعليق بنجاح', 14),
            ('move_to', 'Move to', 'ar_ae', 'الانتقال إلى', 14),
            ('attach', 'Attach', 'ar_ae', 'يربط', 14),
            ('addcoment', 'Add Comment', 'ar_ae', 'أضف تعليق', 14),
            ('adddocument', 'Add Document', 'ar_ae', 'إضافة وثيقة', 14),
            ('home', 'Home', 'ar_ae', 'الصفحة الرئيسية', 15),
            ('checkout', 'Check-out', 'ar_ae', 'الدفع', 15),
            ('message_search', 'Search by name', 'ar_ae', 'البحث عن طريق الإسم', 15),
            ('start_shift', 'Start shift', 'ar_ae', 'بدء التحول', 15),
            ('end_shift', 'End shift', 'ar_ae', 'نهاية التحول', 15),
            ('today_meeting', 'Meetings', 'ar_ae', 'اجتماعات', 15),
            ('shift_time_track', 'Shift Time Track', 'ar_ae', 'التحول الزمني المسار', 15),
            ('logout_msg', 'You have to login again , click', 'ar_ae', 'لابد من الدخول مره اخري    اضغط', 15),
            ('logout_msg1', 'to continue.', 'ar_ae', 'يستمر', 15),
            ('permission_denied', 'You don\'t have permission to create', 'ar_ae', 'ليس لديك إذن لإنشاء', 15),
            ('history', 'Activity stream', 'ar_ae', 'تيار النشاط', 15),
            ('search_value', 'Search value :', 'ar_ae', 'قيمه البحث', 15),
            ('feed_back_msg', 'Please enter feedback message', 'ar_ae', 'يرجى إدخال رسالة ملاحظات', 16),
            ('feed_back_hint_msg', 'Enter feedback message', 'ar_ae', 'أدخل رسالة التعليقات', 16),
            ('submit', 'Submit', 'ar_ae', 'خضع', 16),
            ('check_app_not_installed', 'Application is not currently installed.', 'ar_ae', 'التطبيق غير مثبت حاليا.', 17),
            ('send_sms_fail_message', 'SMS failed, please try again later!', 'ar_ae', 'فشلت رسالة SMS ، يرجى المحاولة مرة أخرى في وقت لاحق!', 17),
            ('documentaddsuccessfully', 'Document Attach successfully', 'ar_ae', 'إرفاق المستند بنجاح', 17),
            ('send_message', 'Send message', 'ar_ae', 'ارسل رساله', 17),
            ('sms_to', 'smsto:', 'ar_ae', 'رساله الي ', 17),
            ('add_list_message', 'Add List', 'ar_ae', 'اضف قائمة', 18),
            ('mylist', 'My List', 'ar_ae', 'قوائمي', 18),
            ('filtername', 'Filter Name', 'ar_ae', 'اسم الفلتر', 18),
            ('selectlist', 'Select a List', 'ar_ae', 'حدد وحدة نمطية *', 18),
            ('assingedto', 'Assigned To', 'ar_ae', 'مخصص ل*', 18),
            ('selectmodule', 'Select a module', 'ar_ae', 'حدد وحدة نمطية', 18),
            ('add_list', 'Add Filter', 'ar_ae', 'إضافة مرشح', 18),
            ('recent_event', 'Recent Event', 'ar_ae', 'حدث حديث', 19),
            ('recent_hostory', 'Recent History', 'ar_ae', 'التاريخ الحديث', 19),
            ('module_specific_settings', 'Module-Specific Settings', 'ar_ae', 'إعدادات الوحدة النمطية', 19),
            ('talk_to_us', 'Talk to us', 'ar_ae', 'تكلم معنا', 19),
            ('report_a_bug', 'Report A Bug', 'ar_ae', 'الإبلاغ عن خطأ', 19),
            ('faq', 'FAQ', 'ar_ae', 'التعليمات', 19),
            ('selectmodules', 'Select Module', 'ar_ae', 'اختر الوحدة', 19),
            ('myplan', 'My Plan', 'ar_ae', 'My Plan', 19),
            ('message', 'Message', 'ar_ae', 'رسالة', 20),
            ('message_validation', 'Please enter Message', 'ar_ae', 'يرجى إدخال الرسالة', 20),
            ('contact_select', 'Please Select contact', 'ar_ae', 'يرجى تحديد الاتصال', 20),
            ('global_search', 'Global Search', 'ar_ae', 'بحث عام', 21),
            ('records', 'Records', 'ar_ae', 'تسجيل', 21),
            ('dont_show_again', 'Don\'t Show Again', 'ar_ae', 'لا تراه مره اخري', 22),
            ('skip', 'Skip', 'ar_ae', 'تخطي', 22),
            ('file_downloading', 'File Downloading', 'ar_ae', 'تحميل الملف', 23),
            ('add_screenshots_optional', 'Add screenshots (optional)', 'ar_ae', 'إضافة لقطات شاشة (اختياري)', 24),
            ('describe_your_problem', 'Describe your problem', 'ar_ae', 'صف مشكلتك', 24),
            ('default_filter_shortcut', 'Default Filter Shortcut', 'ar_ae', 'اختصار افتراضي عام ', 25),
            ('record_shortcut', 'Record Shortcut', 'ar_ae', 'Record Shortcut', 25),
            ('enter_url', 'Please Enter url', 'ar_ae', 'يرجي ادخال الموقع الالكتروني ', 26),
            ('new_version_is_avaiable', 'You need to update the app to continue using Please update to continue Older versions will no longer work from today', 'ar_ae', 'لابد من تحديث التطبيق للاستمرا يرجي تحديث التطبيق و معاوده المحاوله', 26),
            ('search_by', 'Search by', 'ar_ae', 'البحث ب', 27),
            ('selected_filter', 'Selected filter :', 'ar_ae', 'مرشح محدد: -', 27),
            ('selected_field', 'Selected field :', 'ar_ae', 'الحقل المحدد: -', 27),
            ('choose', 'Choose', 'ar_ae', 'اختار', 28),
            ('qr_cardscanner', 'QR Code Scanner', 'ar_ae', 'اجراء مسح QR', 28),
            ('error_message_for_scan', 'Could not read the card Try again later.', 'ar_ae', 'لا يمكن قراءة البطاقة حاول مرة أخرى لاحقًا.', 28),
            ('press_start_scan', 'Press to Start Scan', 'ar_ae', 'اضغط بدء المسح', 28),
            ('line_item_quntity_validation_msg', 'Value should be greater than zero', 'ar_ae', 'القيمه لابد انت تكون اكبر من صفر', 29),
            ('percentage_msg', 'Percentage should be less than 100', 'ar_ae', 'النسبه المئويه لابد ان تكون اقل من 100', 29),
            ('MSG_NO_DATA', 'No data found!', 'ar_ae', 'لا توجد بيانات', 29),
            ('MSG_SOMETHING_WRONG', 'Something went wrong!', 'ar_ae', 'هناك خطا ما', 29),
            ('MSG_COMING_SOON', 'Coming Soon!', 'ar_ae', 'قريبا', 29),
            ('MSG_UPLOAD_PROFILE_IMAGE', 'Please upload profile image.', 'ar_ae', 'يرجي رفع صوره البروفايل', 29),
            ('ALERT_TITLE_LOCATION_ACCESS', 'Location Access', 'ar_ae', 'الوصول الي الموقع', 29),
            ('ALERT_MSG_LOCATION_ACCESS', 'Requires your location to show nearby events.', 'ar_ae', 'لابد من الحصول علي موقعك لامكانيه ايضاح المواقع القريبه', 29),
            ('ALERT_BTN_ALLOW', 'ALLOW', 'ar_ae', 'سماح', 29),
            ('ALERT_BTN_DENY', 'DENY', 'ar_ae', 'رفض', 29),
            ('ALERT_MSG_LOCATION_SETTING', 'Not able to fetch your current location. Please check your location settings.', 'ar_ae', 'لا يمكن الوصول الي موقعك يرجي مراجعه اعدادات الموقع', 29),
            ('DELETE_RECORD', 'Delete Record', 'ar_ae', 'الغاء ', 29),
            ('ALERT_MSG_DELETE_SHORTCUT', 'Are you sure want to delete this shortcut?', 'ar_ae', 'هل انت متاكد من الالغاء؟', 29),
            ('DELETE_SHORTCUT', 'Delete Shortcut', 'ar_ae', 'اختصار الالغاء', 29),
            ('LBL_TERMS', 'By logging in, you agree to our Terms and', 'ar_ae', 'بدخولك علي الموقع فقد وافقت علي الشروط و الاحكام', 29),
            ('LBL_CONDITIONS', 'Conditions &', 'ar_ae', 'شرط', 29),
            ('ALERT_TITLE', 'Alert', 'ar_ae', 'تنبيه', 29),
            ('ALERT_BTN_SUBSCRIBE', 'Subscribe', 'ar_ae', 'اشترك', 29),
            ('MSG_SELECT_MODULE', 'Please select any Module', 'ar_ae', 'برجاء اختار الموديول', 29),
            ('MSG_SELECT_LIST', 'Please select any List', 'ar_ae', 'برجاء اختيار القائمه', 29),
            ('ALERT_MSG_DONT_HAVE_CAMERA', 'You don\'t have camera', 'ar_ae', 'لا توجد كاميرا', 29),
            ('ALERT_MSG_GALLARY_PERMISSION', 'You don\'t have permission to access gallery.', 'ar_ae', 'انت لا تملك الصلاحيه للدخول الي معرض الصور', 29),
            ('ALERT_MSG_CAMERA_PERMISSION', 'You don\'t have permission to access camera. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Camera on', 'ar_ae', 'انت لا تملك الصلاحيه للدخول الي معرض الصور برجاء الدخول الي اعدادات و انزل الي نهايه الصفحه و اختار تطبيق ', 29),
            ('ALERT_MSG_SPEECH_PERMISSION', 'You don\'t have permission to access Speech Recognition. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Speech Recognition on', 'ar_ae', 'You don\'t have permission to access Speech Recognition. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Speech Recognition on', 29),
            ('BTN_DONE', 'Done', 'ar_ae', 'انتهي', 29),
            ('COMMENT', 'Comment', 'ar_ae', 'تعليق', 29),
            ('FULL_FORM', 'Full Form', 'ar_ae', 'الاستماره الكامله', 29),
            ('QUICK_CREATE', 'Create', 'ar_ae', 'انشاء', 29),
            ('LBL_SELECT_FIELDS', 'Select Fields', 'ar_ae', 'اختار حقل', 29),
            ('LBL_SELECT_FIELDS', 'Select Fields', 'ar_ae', 'اختار حقل', 29),
            ('LBL_SELECT_FIRST_FIELDS', 'Select First Field', 'ar_ae', 'اختار اول حقل', 29),
            ('LBL_SELECT_SECOND_FIELDS', 'Select Second Field', 'ar_ae', 'اختار ثاني حقل', 29),
            ('LBL_SELECT_THIRD_FIELDS', 'Select Third Field', 'ar_ae', 'اختار ثالث حقل', 29),
            ('LBL_SORT_BY_FIELD', 'Select Sort By Field', 'ar_ae', 'اختيار ب', 29),
            ('BTN_RESET_TO_DEFAULT', 'Reset to Default', 'ar_ae', 'الرجوع الي الافتراضي', 29),
            ('MSG_SELECT_SORT_BY_FIELD', 'Select Sort by field', 'ar_ae', 'اختيار ب', 29),
            ('kStrClearBtnTitle', 'Clear', 'ar_ae', 'امسح', 29),
            ('kStrShowMoreBtnTitle', 'Show More', 'ar_ae', 'ارني اكثر', 29),
            ('kStrAddActivitiesBtnTitle', 'Add Activities', 'ar_ae', 'اضافه نشاطات', 29),
            ('kStrAddCommentPlaceHolder', 'Add your comments here', 'ar_ae', 'ضع تعليقك هنا', 29),
            ('MSG_ENTER_TO_EMAIL', 'Please enter to field.', 'ar_ae', 'يرجي ادخال الحقل', 29),
            ('WARNING_FILE', 'File can\'t open.', 'ar_ae', 'الملف لا يفتح', 29),
            ('MSG_FILE_SAVED', 'File saved.', 'ar_ae', 'تم حفظ الملف', 29),
            ('WARNING_DOWNLOAD_FAIL', 'Download fail!, please try after sometime.', 'ar_ae', 'فشل في التنزيل برجاء المحاوله بعد فتره', 29),
            ('LBL_SHORTCUT', 'Shortcut', 'ar_ae', 'اختصار', 29),
            ('TXT_MESSAGE_PLACEHOLDER', 'Type Message', 'ar_ae', 'اكتب الرساله', 29),
            ('ALERT_INSTALL_WHATSAPP', 'Install Whatsapp', 'ar_ae', 'تنزيل واتس اب', 29),
            ('MSG_NO_MAIL_BOX', 'No MailBox found. Please Create Mailbox', 'ar_ae', 'لا يوجد صندوق بريد برجاء انشاء صندوق بريد', 29),
            ('LBL_WROTE', 'Wrote', 'ar_ae', 'كتب', 29),
            ('MSG_MAIL_SEND', 'Mail sent', 'ar_ae', 'تم ارسال الرساله', 29),
            ('log_file_not_found', 'API Log file not found.', 'ar_ae', 'لم يتم العثور علي API', 29),
            ('unknown_error', 'An unknown error occurred, try again', 'ar_ae', 'خطا غير معروف برجاء المحاوله مره اخري', 29),
            ('CTMTigerAppVersion', 'CRMTiger App Version', 'ar_ae', 'نسخه تطبيق CRM Tiger', 29),
            ('CTMMobileUpdateMsg', 'CTMobile Ext. Version Update Successfully', 'ar_ae', 'امتداد CT Mobile  تم تحديثه', 29),
            ('dialog_Premium_downgrade', 'Downgrade will required logout and login again later', 'ar_ae', 'النزول الي الفئه الادني يتطلب الخروج و الدخول مره اخري', 29),
            ('dialog_Premium', 'Upgrade will required logout and login again later', 'ar_ae', 'التحديث الي الفئه الاعلي يتطلب الخروج و الدخول مره اخري', 29),
            ('Overwrite', 'Overwrite', 'ar_ae', 'الكتابه فوق', 29),
            ('MSGAddressOverwrite1', 'Overwrite the existing address with the selected', 'ar_ae', 'الكتابه فوق العنوان المكتوب سيتم اختياره', 29),
            ('MSGAddressOverwrite2', 'address details?', 'ar_ae', 'تفاصيل العنوان', 29),
            ('UPGRADE_PLAN', 'Upgrade Plan', 'ar_ae', 'خطه التحديث', 29),
            ('DOWNGRADE_PLAN', 'Downgrade Plan', 'ar_ae', 'خطه النزول الي افئه الادني', 29),
            ('UPGRADE_EXTENSION', 'Upgrade Extension', 'ar_ae', 'امتدادات التحديث', 29),
            ('UPGRADE_APP', 'Upgrade App', 'ar_ae', 'تحديث التطبيق', 29),
            ('SELECT_OPTION', 'Select Option', 'ar_ae', 'اختار ', 29),
            ('PLEASE_SELECT', 'Please select', 'ar_ae', 'برجاء الاختيار', 29),
            ('MSG_ACCESS_DENIED', 'You don\'t have permission for this module.', 'ar_ae', 'انت لا تملك الصلاحيه للدخول لهذا القسم', 29),
            ('MSG_SELECT_RECCURING_MONTH_DAY', 'Please select reccuring day of month.', 'ar_ae', 'برجاء اختيار اليوم المكرر في الشهر', 29),
            ('MSG_SELECT_RECCURING_WEEK_DAY', 'Please select reccuring day of week.', 'ar_ae', 'برجاء اختيار اليوم المكرر في الاسبوع', 29),
            ('MSG_SELECT_RECCURING_DAYS', 'Please select reccuring days.', 'ar_ae', 'برجاء اختيار اليوم المكرر', 29),
            ('Please select reccuring days.', 'Please select reccuring days.', 'ar_ae', 'برجاء اختيار اليوم المكرر', 29),
            ('MSG_SELECT_RECCURING_END_DATE', 'Please select reccuring end date.', 'ar_ae', 'برجاء اختيار اليوم النهائي', 29),
            ('MSG_SELECT_RECCURING_TYPE', 'Please select reccuring type.', 'ar_ae', 'برجاء اختيار النوع', 29),
            ('FREQ_TIME', 'Times', 'ar_ae', 'عدد المرات', 29),
            ('REPEAT_YEARLY', 'Repeat Yearly', 'ar_ae', 'الاعاده سنويا', 29),
            ('REPEAT_MONTHLY', 'Repeat Monthly', 'ar_ae', 'الاعاده شهريا', 29),
            ('REPEAT_WEEKLY', 'Repeat Weekly', 'ar_ae', 'الاعاده اسبوعيا', 29),
            ('REPEAT_DAILY', 'Repeat Daily', 'ar_ae', 'الاعاده يوميا', 29),
            ('ACTION_TITLE', 'Action Title', 'ar_ae', 'عنوان الحدث', 29),
            ('MSG_SELECT_VALID_DATE', 'Please select valid day of month.', 'ar_ae', 'برجاء اختيار يوم مناسب في الشهر', 29),
            ('MSG_SELECT_VALID_START_DATE', 'Start date should be less than end date.', 'ar_ae', 'تاريخ البدايه لابد ان يكون اقل من تاريخ الانتهاء', 29),
            ('MSG_SELECT_VALID_START_TIME', 'Start time should be less than end time.', 'ar_ae', 'اختيار بدء الوقت لابد ان يكون قبل وقت الانتهاء', 29),
            ('LBL_LINEITEM_DETAILS', 'Lineitem Details', 'ar_ae', 'Lineitem Details', 29),
            ('MSG_INVALIDE_DISCOUNT_AMOUNT', 'Discount amount should be less than the total.', 'ar_ae', 'الخصم لابد ان يكون اقل من الاجمالي', 29),
            ('VIEW', 'View', 'ar_ae', 'View', 29),
            ('MSG_ENTER_VALID', 'Please enter valid', 'ar_ae', 'برجاء ادخال صحيح', 29),
            ('MSG_ENTER_PERCENTAGE', 'Percentage should be less than 100.', 'ar_ae', 'النسبه المئويه لابد ان تكون اقل من 100', 29),
            ('ITEM_TOTAL', 'Item Total', 'ar_ae', 'الاجمالي', 29),
            ('ADJUSTMENT', 'Adjustment', 'ar_ae', 'تعديل', 29),
            ('TITLE_CHOOSE_IMAGE', 'Choose Image', 'ar_ae', 'اختار صوره', 29),
            ('COMPRESS', 'Compress', 'ar_ae', 'ضغط', 29),
            ('CHOOSE_ANOTHER_IMAGE', 'Your image size is too large, please select another image', 'ar_ae', 'الصوره كبيره جدا برجاء اختيار صوره اخري', 29),
            ('OnDayOfMonth', 'On day of month', 'ar_ae', 'يوم في الشهر', 29),
            ('OnDayOfWeek', 'On day of week', 'ar_ae', 'يوم في الاسبوع', 29),
            ('AddAndClose', 'Add & Close', 'ar_ae', 'اضافه&اغلاق', 29),
            ('Repeat', 'Repeat', 'ar_ae', 'اعاده', 29),
            ('OnDay', 'On day', 'ar_ae', 'في يوم', 29),
            ('View_Line_Item', 'View Line Item', 'ar_ae', 'View Line Item', 29),
            ('TITLE_IMAGE', 'Image', 'ar_ae', 'صوره', 29),
            ('TITLE_ICLOUD', 'iCloud', 'ar_ae', 'اي كلود', 29),
            ('GOOGLE', 'Google', 'ar_ae', 'جوجل', 29),
            ('ALERT_BTN_OKAY', 'Okay', 'ar_ae', 'حسنا', 29),
            ('ALERT_TITLE_ACCESS_DENIED', 'Access Denied', 'ar_ae', 'الدخول مرفوض', 29),
            ('Dont_Show_Again', 'Don\'t show again', 'ar_ae', 'لا تظهرها مره اخري', 29),
            ('Skip', 'Skip', 'ar_ae', 'تخطي', 29),
            ('Fillter_Name', 'Fillter Name', 'ar_ae', 'اسم الفلتر', 29),
            ('Fillter_Record_Count', 'Fillter Record Count', 'ar_ae', 'Fillter Record Count', 29),
            ('url_note',      'Note : if your URL of CRM is https://example.com/crm enter that into above box',   'ar_ae',    'Note : if your URL of CRM is https://example.com/crm enter that into above box',   31),
            ('vtiger_url',    'Your vTiger CRM URL',  'ar_ae',    'Your vTiger CRM URL',  31),
            ('msg_doc_read_permission',   'You don\'t have permission to Add either This is read-only or Private Field.',     'ar_ae',    'You don\'t have permission to Add either This is read-only or Private Field.',     31),
            ('CLEAR',   'Clear',    'ar_ae',    'Clear',    31),
            ('Files/photos uploaded successfully',    'Files/photos uploaded successfully',     'ar_ae',    'Files/photos uploaded successfully',     32),
            ('Digital signature saved',   'Digital signature saved',    'ar_ae',    'Digital signature saved',    32),
            ('Please upload Signature or Files/photos',     'Please upload Signature or Files/photos',      'ar_ae',    'Please upload Signature or Files/photos',      32),
            ('Files / Photos',      'Files / Photos', 'ar_ae',    'Files / Photos', 32),
            ('Signature',     'Signature',      'ar_ae',    'Signature',      32),
            ('add_photo_using',     'Add Photo Using',      'ar_ae',    'Add Photo Using',      31),
            ('btn_upload_sign',     '(+) Add Signature',    'ar_ae',    '(+) Add Signature',    31),
            ('btn_upload_photo_doc',      '(+) Upload Files/Photos',    'ar_ae',    '(+) Upload Files/Photos',    31),
            ('select_photo_doc_to_upload',      'Please select files/photos to upload',   'ar_ae',    'Please select files/photos to upload',   31),
            ('related_module_title',      'Search from related module and Add to \"Route\"',    'ar_ae',    'Search from related module and Add to \"Route\"',    30),
            ('Route status updated successfully',     'Route status updated successfully',      'ar_ae',    'Route status updated successfully',      32),
            ('Session init failed', 'Session init failed',  'ar_ae',    'Session init failed',  32),
            ('You don\'t have permission to access this resource',      'You don\'t have permission to access this resource', 'ar_ae',    'You don\'t have permission to access this resource', 32),
            ('ctroute_realtedto cannot be empty',     'Could not get the Related To - Try again later',     'ar_ae',    'Could not get the Related To - Try again later',     32),
            ('ctroute_planning cannot be empty',      'Could not get the Route Planning Record - Try again later',      'ar_ae',    'Could not get the Route Planning Record - Try again later',      32),
            ('Something went wrong - Try again later',      'Something went wrong - Try again later', 'ar_ae',    'Something went wrong - Try again later', 32),
            ('sequence updated successfully',   'sequence updated successfully',    'ar_ae',    'sequence updated successfully',    32),
            ('sequence cannot be empty',  'sequence cannot be empty',   'ar_ae',    'sequence cannot be empty',   32),
            ('Shortcut details not saved',      'Shortcut details not saved', 'ar_ae',    'Shortcut details not saved', 32),
            ('Shortcut details saved successfully',   'Shortcut details saved successfully',    'ar_ae',    'Shortcut details saved successfully',    32),
            ('Route save successfully',   'Route save successfully',    'ar_ae',    'Route save successfully',    32),
            ('Record save successfully',  'Record save successfully',   'ar_ae',    'Record save successfully',   32),
            ('No dependency found for picklist',      'No dependency found for picklist', 'ar_ae',    'No dependency found for picklist', 32),
            ('No records found',    'No records found',     'ar_ae',    'No records found',     32),
            ('Outgoing server is not enabled, please configure from CRM',     'Outgoing server is not enabled, please configure from CRM',      'ar_ae',    'Outgoing server is not enabled, please configure from CRM',      32),
            ('Removed Successfully',      'Removed Successfully', 'ar_ae',    'Removed Successfully', 32),
            ('Shortcut has been deleted', 'Shortcut has been deleted',  'ar_ae',    'Shortcut has been deleted',  32),
            ('relation of records removed successfully',    'relation of records removed successfully',     'ar_ae',    'relation of records removed successfully',     32),
            ('relation of records not removed', 'relation of records not removed',  'ar_ae',    'relation of records not removed',  32),
            ('Record has been deleted successfully',  'Record has been deleted successfully',   'ar_ae',    'Record has been deleted successfully',   32),
            ('Time Tracking saved successfully',      'Time Tracking saved successfully', 'ar_ae',    'Time Tracking saved successfully', 32),
            ('Time Tracking updated successfully',    'Time Tracking updated successfully',     'ar_ae',    'Time Tracking updated successfully',     32),
            ('Time Tracking ended successfully',      'Time Tracking ended successfully', 'ar_ae',    'Time Tracking ended successfully', 32),
            ('Time Tracking started successfully',    'Time Tracking started successfully',     'ar_ae',    'Time Tracking started successfully',     32),
            ('record cannot be empty',    'record cannot be empty',     'ar_ae',    'record cannot be empty',     32),
            ('Module is disabled',  'Module is disabled',   'ar_ae',    'Module is disabled',   32),
            ('Shift ended successfully',  'Shift ended successfully',   'ar_ae',    'Shift ended successfully',   32),
            ('Shift started successfully',      'Shift started successfully', 'ar_ae',    'Shift started successfully', 32),
            ('relation of records added successfully',      'relation of records added successfully', 'ar_ae',    'relation of records added successfully', 32),
            ('Comment saved successfully',      'Comment saved successfully', 'ar_ae',    'Comment saved successfully', 32),
            ('Comment not saved',   'Comment not saved',    'ar_ae',    'Comment not saved',    32),
            ('Comment module is not active',    'Comment module is not active',     'ar_ae',    'Comment module is not active',     32),
            ('No Upcoming Event',   'No Upcoming Event',    'ar_ae',    'No Upcoming Event',    32),
            ('No Templates found - create it from Message Templates module',  'No Templates found - create it from Message Templates module',   'ar_ae',    'No Templates found - create it from Message Templates module',   32),
            ('No event or task for this date',  'No event or task for this date',   'ar_ae',    'No event or task for this date',   32),
            ('No filters created',  'No filters created',   'ar_ae',    'No filters created',   32),
            ('Select at least one record to attach',  'Select at least one record to attach',   'ar_ae',    'Select at least one record to attach',   32),
            ('Please select one or more attachments', 'Please select one or more attachments',  'ar_ae',    'Please select one or more attachments',  32),
            ('No event for this month',   'No event for this month',    'ar_ae',    'No event for this month',    32),
            ('No Activity found',   'No Activity found',    'ar_ae',    'No Activity found',    32),
            ('Your feedback is valuable for us - it cannot be empty',   'Your feedback is valuable for us - it cannot be empty',    'ar_ae',    'Your feedback is valuable for us - it cannot be empty',    32),
            ('Could not send mail, Please try later', 'Could not send mail, Please try later',  'ar_ae',    'Could not send mail, Please try later',  32),
            ('Latest Version updated successfully',   'Latest Version updated successfully',    'ar_ae',    'Latest Version updated successfully',    32),
            ('User Location Updated Successfully',    'User Location Updated Successfully',     'ar_ae',    'User Location Updated Successfully',     32),
            ('User Location not Updated Successfully',      'User Location not Updated Successfully', 'ar_ae',    'User Location not Updated Successfully', 32),
            ('SMSNotifier is not enable in CRM. Please enable it first',      'SMSNotifier is not enable in CRM. Please enable it first', 'ar_ae',    'SMSNotifier is not enable in CRM. Please enable it first', 32),
            ('Could not submit your feedback - Please try again later', 'Could not submit your feedback - Please try again later',  'ar_ae',    'Could not submit your feedback - Please try again later',  32),
            ('Thank you for submitting your feedback',      'Thank you for submitting your feedback', 'ar_ae',    'Thank you for submitting your feedback', 32),
            ('Please upload User Image',  'Please upload User Image',   'ar_ae',    'Please upload User Image',   32),
            ('Image Not Uploading, please try again', 'Image Not Uploading, please try again',  'ar_ae',    'Image Not Uploading, please try again',  32),
            ('User Image Uploaded Successfully',      'User Image Uploaded Successfully', 'ar_ae',    'User Image Uploaded Successfully', 32),
            ('Invalid Module name', 'Invalid Module name',  'ar_ae',    'Invalid Module name',  32),
            ('Records Sync Successfully', 'Records Sync Successfully',  'ar_ae',    'Records Sync Successfully',  32),
            ('Values cannot be empty',    'Values cannot be empty',     'ar_ae',    'Values cannot be empty',     32),
            ('Record id is empty',  'Record id is empty',   'ar_ae',    'Record id is empty',   32),
            ('Logout Successfully', 'Logout Successfully',  'ar_ae',    'Logout Successfully',  32),
            ('Please Enable CTMobile Module',   'Please Enable CTMobile Module',    'ar_ae',    'Please Enable CTMobile Module',    32),
            ('Authentication Failed',     'Username and Password do not match',     'ar_ae',    'Username and Password do not match',     32),
            ('Mismatched module information',   'Something gone wrong, please try again later', 'ar_ae',    'Something gone wrong, please try again later', 32),
            ('Field does not exists',     'Please set display fields again',  'ar_ae',    'Please set display fields again',  32),
            ('Module does not exists',    'Module does not exists or disabled by admin',  'ar_ae',    'Module does not exists or disabled by admin',  32),
            ('Month cannot be empty',     'Could not get the Month - Try again later',    'ar_ae',    'Could not get the Month - Try again later',    32),
            ('Year cannot be empty',      'Could not get the Year - Try again later',     'ar_ae',    'Could not get the Year - Try again later',     32),
            ('Date cannot be empty',      'Could not get the Date - Try again later',     'ar_ae',    'Could not get the Date - Try again later',     32),
            ('Userid cannot be empty',    'Could not get the Userid - Try again later',   'ar_ae',    'Could not get the Userid - Try again later',   32),
            ('End Date cannot be empty',  'Could not get the status - Try again later',   'ar_ae',    'Could not get the status - Try again later',   32),
            ('Start Date cannot be empty',      'Could not get the Start Date - Try again later',     'ar_ae',    'Could not get the Start Date - Try again later',     32),
            ('You do not configure SMS Notifier in CRM. Please configure SMS Notifier in your CRM to use this feature', 'You do not configure SMS Notifier in CRM. Please configure SMS Notifier in your CRM to use this feature',  'ar_ae',    'You do not configure SMS Notifier in CRM. Please configure SMS Notifier in your CRM to use this feature',  32),
            ('Longitude cannot be empty', 'Could not get location-Please try again',      'ar_ae',    'Could not get location-Please try again',      32),
            ('Latitude cannot be empty',  'Could not get location-Please try again',      'ar_ae',    'Could not get location-Please try again',      32),
            ('User cannot be empty',      'Could not get the User - Try again later',     'ar_ae',    'Could not get the User - Try again later',     32),
            ('Status cannot be empty',    'Could not get the status - Try again later',   'ar_ae',    'Could not get the status - Try again later',   32),
            ('Required fields not found', 'Required fields not found',  'ar_ae',    'Required fields not found',  32),
            ('Tracking module not active',      'Tracking module not active-Please contact CRM Admin',      'ar_ae',    'Tracking module not active-Please contact CRM Admin',      32),
            ('Missing mandatory input values',  'Missing mandatory input values',   'ar_ae',    'Missing mandatory input values',   32),
            ('No MailBox found. Please Create Mailbox',     'No MailBox found. Please Create Mailbox',      'ar_ae',    'No MailBox found. Please Create Mailbox',      32),
            ('Mail not sent', 'Mail not sent',  'ar_ae',    'Mail not sent',  32),
            ('Mail send successfully',    'Mail send successfully',     'ar_ae',    'Mail send successfully',     32),
            ('Email Id or username not match with your record',   'Email Id or username not match with your record',    'ar_ae',    'Email Id or username not match with your record',    32),
            ('Module not specified',      'Module not specified', 'ar_ae',    'Module not specified', 32),
            ('No messages found',   'No messages found',    'ar_ae',    'No messages found',    32),
            ('No Dependency Found For This Module',   'No Dependency Found For This Module',    'ar_ae',    'No Dependency Found For This Module',    32),
            ('Outgoing server is not Enabled',  'Outgoing server is not Enabled',   'ar_ae',    'Outgoing server is not Enabled',   32),
            ('Outgoing server is Enabled',      'Outgoing server is Enabled', 'ar_ae',    'Outgoing server is Enabled', 32),
            ('Email Attached Successfully',     'Email Attached Successfully',      'ar_ae',    'Email Attached Successfully',      32),
            ('Documents Attached Successfully', 'Documents Attached Successfully',  'ar_ae',    'Documents Attached Successfully',  32),
            ('Login required - Please login again',   'Login required - Please login again',    'ar_ae',    'Login required - Please login again',    32),
            ('time_tracking_module_disable',    'Time tracking module is disable',  'ar_ae',    'Time tracking module is disable',  31),
            ('route_planning_module_disable',   'Route planning module is disable', 'ar_ae',    'Route planning module is disable', 31),
            ('mark_as_held',  'Are you sure you want to mark Event as Held?', 'ar_ae',    'Are you sure you want to mark Event as Held?', 31),
            ('stop_timer_msg',      'You have already started Time tracking for another record, Do you want to stop it first ?',    'ar_ae',    'You have already started Time tracking for another record, Do you want to stop it first ?',    31),
            ('access_denied_routeplanning',     'Access denied for route planning', 'ar_ae',    'Access denied for route planning', 31),
            ('time_spent',    'Time Spent',     'ar_ae',    'Time Spent',     31),
            ('select_user',   'Select User',    'ar_ae',    'Select User',    30),
            ('status_cannot_be_held',     'Status cannot be held for future date start',  'ar_ae',    'Status cannot be held for future date start',  30),
            ('please_select_end_date',    'Please select end date',     'ar_ae',    'Please select end date',     30),
            ('please_select_start_date',  'Please select start date',   'ar_ae',    'Please select start date',   30),
            ('tap_on_plus_icon_for_select_route',     'Tap on + icon to select record for your route.',     'ar_ae',    'Tap on + icon to select record for your route.',     30),
            ('please_enter_notes',  'Please enter notes',   'ar_ae',    'Please enter notes',   30),
            ('please_enter_title',  'Please enter title',   'ar_ae',    'Please enter title',   30),
            ('please_select_date',  'Please Select Date',   'ar_ae',    'Please Select Date',   30),
            ('search_by_date',      'Search by Date', 'ar_ae',    'Search by Date', 30),
            ('shortcut_not_setup_yet',    'Opps shortcut not setup yet!!! Please add shortcut by click on [icon] from record search results or view record screen.',    'ar_ae',    'Opps shortcut not setup yet!!! Please add shortcut by click on [icon] from record search results or view record screen.',    30),
            ('max_upload_size',     'max file Upload exceeds',    'ar_ae',    'max file Upload exceeds',    30),
            ('unselect_all',  'UnSelect All',   'ar_ae',    'UnSelect All',   30),
            ('select_all',    'Select All',     'ar_ae',    'Select All',     30),
            ('please_select_records',     'Please select records',      'ar_ae',    'Please select records',      30),
            ('select_date',   'Select Date',    'ar_ae',    'Select Date',    30),
            ('quantity_in_stock_is',      'Quantity in stock is', 'ar_ae',    'Quantity in stock is', 30),
            ('replies', 'Replies',  'ar_ae',    'Replies',  30),
            ('conversation_require_selection',  'Conversion requires selection of Contact or Organization', 'ar_ae',    'Conversion requires selection of Contact or Organization', 30),
            ('please_select_product',     'Please Select Product',      'ar_ae',    'Please Select Product',      30),
            ('timer_msg',     'You can start timer for single task only at same time',    'ar_ae',    'You can start timer for single task only at same time',    31),
            ('save_start_tracking', 'Save & Start Tracking',      'ar_ae',    'Save & Start Tracking',      31),
            ('lbl_notes',     'Notes',    'ar_ae',    'Notes',    31),
            ('enter_title',   'Enter Title',    'ar_ae',    'Enter Title',    31),
            ('select_module_record',      'Select Module / Record',     'ar_ae',    'Select Module / Record',     31),
            ('lbl_tomorrow',  'Tomorrow', 'ar_ae',    'Tomorrow', 30),
            ('lbl_yesterday', 'Yesterday',      'ar_ae',    'Yesterday',      30),
            ('lbl_today',     'Today',    'ar_ae',    'Today',    30),
            ('time_tracker',  'Time Tracker',   'ar_ae',    'Time Tracker',   31),
            ('time_end',      'End Time', 'ar_ae',    'End Time', 5),
            ('due_date',      'End Date', 'ar_ae',    'End Date', 5),
            ('time_start',    'Time Start',     'ar_ae',    'Time Start',     5),
            ('date_start',    'Start Date',     'ar_ae',    'Start Date',     5),
            ('delete_widget_msg',   'Display widget again by using (+) option',     'ar_ae',    'Display widget again by using (+) option',     15),
            ('no_upcoming_activities',    'No scheduled activities      ',    'ar_ae',    'No scheduled activities      ',    15),
            ('check_in_first',      'Please check-in first',      'ar_ae',    'Please check-in first',      30),
            ('duration',      'Duration', 'ar_ae',    'Duration', 30),
            ('distance',      'Distance', 'ar_ae',    'Distance', 30),
            ('proper_address_message',    'Please enter proper address in record\n',      'ar_ae',    'Please enter proper address in record',  30),
            ('select_status', 'Select Status',  'ar_ae',    'Select Status',  30),
            ('route_planner', 'Route Planner',  'ar_ae',    'Route Planner',  30),
            ('route_planning',      'Route Planning', 'ar_ae',    'Route Planning', 30),
            ('add_route',     'Add Route',      'ar_ae',    'Add Route',      30),
            ('calender_disabled',   'Calendar Module is disabled',      'ar_ae',    'Calendar Module is disabled',      30),
            ('close_dialog',  'Close form',     'ar_ae',    'Close form',     30),
            ('cancel_form_message', 'Are You sure want to close ?',     'ar_ae',    'Are You sure want to close ?',     30),
            ('create_route',  'Create Route',   'ar_ae',    'Create Route',   30),
            ('select_module_create_route',      'Select Module to create Route',    'ar_ae',    'Select Module to create Route',    30),
            ('cancel',  'Cancel',   'ar_ae',    'الغاء',   30),
            ('assign_route',  'Assign Route',   'ar_ae',    'Assign Route',   30),
            ('route_for',     'Route for',      'ar_ae',    'Route for',      30),
            ('assigned_to',   'Assigned To',    'ar_ae',    'Assigned To',    30),
            ('enter_route_name',    'Enter Route Name',     'ar_ae',    'Enter Route Name',     30),
            ('list',    'List',     'ar_ae',    'List',     30),
            ('map',     'Map',      'ar_ae',    'Map',      30),
            ('other_modules', 'Other Modules',  'ar_ae',    'Other Modules',  15),
            ('shortcut_no_record_msg',    'Opps shortcut not setup\n yet!!! Please add shortcut  by click on + icon from record\n search results or view record screen.',     'ar_ae',    'Opps shortcut not setup\n yet!!! Please add shortcut  by click on + icon from record\n search results or view record screen.',     25),
            ('clear',   'Clear',    'ar_ae',    'Clear',    25),
            ('open',    'Open',     'ar_ae',    'Open',     11),
            ('max_file_msg',  'Too many files selected (max:6)',  'ar_ae',    'Too many files selected (max:6)',  11),
            ('error_voicenote_record',    'Unable to recording voice while another application is recording sound.',    'ar_ae',    'Unable to recording voice while another application is recording sound.',    11),
            ('msg_warning',   'Warning!', 'ar_ae',    'Warning!', 11),
            ('Permision_denied_contact',  'Permission denied to access your contacts',    'ar_ae',    'Permission denied to access your contacts',    15),
            ('no_widget_added',     'Please click + icon to add new widget to your dashboard.', 'ar_ae',    'Please click + icon to add new widget to your dashboard.', 15),
            ('no_data_available',   'Data not available, please check the selected fields',     'ar_ae',    'Data not available, please check the selected fields',     15),
            ('check_out_successfully',    'Check out successfully',     'ar_ae',    'Checked out successfully',   11),
            ('check_in_successfully',     'Check in successfully',      'ar_ae',    'Checked in successfully',    11),
            ('check_out',     'Check out',      'ar_ae',    'Check out',      11),
            ('check_in',      'Check in', 'ar_ae',    'Check in', 11),
            ('navigate',      'Navigate', 'ar_ae',    'Navigate', 11),
            ('save_to_phone_vcard_success',     'VCard Saved to phone successfully',      'ar_ae',    'VCard Saved to phone successfully',      15),
            ('download_vcard_success',    'VCard downloaded successfully',    'ar_ae',    'VCard downloaded successfully',    15),
            ('card_details',  'Card Details',   'ar_ae',    'Card Details',   15),
            ('add_widget',    'Add Widget',     'ar_ae',    'Add Widget',     15),
            ('delete_widget', 'Are you sure to hide widget?',     'ar_ae',    'Are you sure to hide widget?',     15),
            ('already_widgets_added',     'All types of Widget & reports are already added',    'ar_ae',    'All types of Widget & reports are already added',    15),
            ('retry',   'Retry',    'ar_ae',    'Retry',    28),
            ('retake',  'Retake',   'ar_ae',    'Retake',   28),
            ('Reports', 'Reports',  'ar_ae',    'Reports',  15),
            ('Widgets', 'Widgets',  'ar_ae',    'Widgets',  15),
            ('vcard_config',  'Vcard Configuration',  'ar_ae',    'Vcard Configuration',  8),
            ('save_to_phone', 'Save to phone',  'ar_ae',    'Save to phone',  11),
            ('download_vcard',      'Download Vcard', 'ar_ae',    'Download Vcard', 11),
            ('share_vcard',   'Share Vcard',    'ar_ae',    'Share Vcard',    11),
            ('share_record',  'Share Record',   'ar_ae',    'شارك ',   11),
            ('permission_denied_edit',    'You don\'t have permission to edit this record.',    'ar_ae',    'انت لا تملك صلاحيه الاضافه',    27),
            ('permission_denied_delete',  'You don\'t have permission to delete this record.',  'ar_ae',    'انهت لا تملك صلاحيه الغاء هذا ',  27),
            ('Voice_Recording_Started',   'Recording Started',    'ar_ae',    'بدء التسجيل',    12),
            ('Voice_Recording_Stopped',   'Recording Stopped',    'ar_ae',    'وقف التسجيل',    12),
            ('SEARCH',  'Search',   'ar_ae',    'بحث',   7),
            ('LAST',    'Last',     'ar_ae',    'الاخير',     7),
            ('FIRST',   'First',    'ar_ae',    'الاول',    7),
            ('MONDAY',  'Monday',   'ar_ae',    'الاثنين',   7),
            ('TUESDAY', 'Tuesday',  'ar_ae',    'الثلاثاء',  7),
            ('WEDNESDAY',     'Wednesday',      'ar_ae',    'الاربعاء',      7),
            ('THURSDAY',      'Thursday', 'ar_ae',    'الخميس', 7),
            ('FRIDAY',  'Friday',   'ar_ae',    'الجمعه',   7),
            ('SATURDAY',      'Saturday', 'ar_ae',    'السبت', 7),
            ('SUNDAY',  'Sunday',   'ar_ae',    'الاحد',   7),
            ('DAILY',   'Daily',    'ar_ae',    'يوميا',    7),
            ('WEEKLY',  'Weekly',   'ar_ae',    'اسبوعيا',   7),
            ('MONTHLY', 'Monthly',  'ar_ae',    'شهريا',  7),
            ('YEARLY',  'Yearly',   'ar_ae',    'سنويا',   7),
            ('asset_tracking',      'Asset tracking', 'ar_ae',    'مساعده في البحث', 15);",array());
    }

    static function es_es(){
         global $adb;
        $checkQuery = "DELETE FROM ctmobile_language_keyword WHERE keyword_lang = ?";
        $checkResult = $adb->pquery($checkQuery,array('es_es'));

        $adb->pquery("INSERT INTO `ctmobile_language_keyword` (`keyword`, `keyword_name`, `keyword_lang`, `language_keyword`, `sectionid`) VALUES
            ('network_error', 'Network connection error!', 'es_es', '¡Error de red!', 1),
            ('connection_check', 'Could not connect to CRM, Please check your Internet connection.', 'es_es', 'Por favor revise su conexion a internet.', 1),
            ('update', 'Update', 'es_es', 'Update', 1),
            ('cancel', 'Cancel', 'es_es', 'Cancelar', 1),
            ('ok', 'Ok', 'es_es', 'DE ACUERDO', 1),
            ('more_information', 'Click here for more information.', 'es_es', 'Haga clic aquí para mas información.', 1),
            ('yes', 'Yes', 'es_es', 'Sí', 1),
            ('no', 'No', 'es_es', 'No', 1),
            ('click_again_exit', 'Click again to exit', 'es_es', 'Haga clic de nuevo para salir', 1),
            ('forpermission', 'You don\'t have permission to view this feature. Please subscribe for Premium version Click here to Subscribe.', 'es_es', 'No tiene permiso para ver estas características, para acceder suscribase a la versión premium Clic aqui para suscribirse.', 1),
            ('clickhere', 'Click here', 'es_es', 'Clic Aquí', 1),
            ('clickhere_subscribe', 'Click here to subscribe premium version', 'es_es', 'Clic aqui para suscribirse', 1),
            ('clickhere_configure', 'Click here and view how to Configure.', 'es_es', 'Haga clic aquí y vea cómo configurar.', 1),
            ('please_wait', 'Please Wait…', 'es_es', 'Por favor espera…', 1),
            ('share__msg', 'Share file with', 'es_es', 'compartir archivo con', 1),
            ('dialog_camera', 'Camera', 'es_es', 'Cámara', 1),
            ('dialog_add_file_by', 'Take Photo from', 'es_es', 'Agregar archivos por', 1),
            ('add', 'Add', 'es_es', 'Agregar', 1),
            ('mail_manager_configured', 'Mail Manager is not configured', 'es_es', 'Mail Manager no está configurado', 1),
            ('dialog_add_files_by', 'Add Files by', 'es_es', 'Agregar archivos por', 1),
            ('dialog_drive', 'Drive', 'es_es', 'Controlar', 1),
            ('dialog_drop_box', 'Drop Box', 'es_es', 'Drop Box', 1),
            ('dialog_need_signin', 'You need to Sign-in to your Drive account first.', 'es_es', 'debe iniciar sesión primero', 1),
            ('dialog_gallery', 'Gallery', 'es_es', 'Galería', 1),
            ('delete', 'Delete', 'es_es', 'Borrar', 1),
            ('timeoutmessage', 'Oops! Request is taking more time than expected.', 'es_es', 'Oops solicitud lleva tiempo de lo esperado.', 1),
            ('gps_location_message', 'GPS is not enabled. Please turn it on to get your near by locations.', 'es_es', 'GPS no está habilitado. Por favor, enciéndelo para obtener su ubicación cercana.', 1),
            ('sure_want_delete', 'Are you sure want to delete ?', 'es_es', '¿Seguro que quiere borrar?', 1),
            ('select', 'Select', 'es_es', 'Seleccionar', 1),
            ('msgforrecordaudio', 'Minimum record duration one second.', 'es_es', 'Duración mínima del registro un segundo', 1),
            ('permission_storage', 'Permission denied to read your External storage', 'es_es', 'Permiso denegado para leer el almacenamiento externo', 1),
            ('send_permission_msg', 'Send message permission denied', 'es_es', 'Permiso de llamada denegado', 1),
            ('choosefile', 'Choose File', 'es_es', 'Elija el archivo', 1),
            ('enter', 'Enter', 'es_es', 'Entrar', 1),
            ('select_an_option', 'Select an Option', 'es_es', 'Sleccione una opcion', 1),
            ('email_validation', 'Email is not valid', 'es_es', 'El correo no es válido', 1),
            ('please_enter', 'Please Enter', 'es_es', 'Please Enter ', 1),
            ('website_validation_text', 'Website URL is not valid', 'es_es', 'La URL del sitio web no es válida', 1),
            ('selectvalue', 'Select value first', 'es_es', 'Seleccionar valor', 1),
            ('email', 'Email', 'es_es', 'Email', 1),
            ('enter_email_address', 'Enter email address', 'es_es', 'Introduzca la dirección de correo electrónico', 1),
            ('email_address_not_correct', 'Email address incorrect', 'es_es', 'Dirección de correo electrónico incorrecta', 1),
            ('pls_enter_subject', 'Please Enter Subject', 'es_es', 'Por favor ingrese el asunto', 1),
            ('attachFiles', 'Attached File', 'es_es', 'Adjuntar archivo', 1),
            ('from', 'From', 'es_es', 'Desde', 1),
            ('to', 'To', 'es_es', 'A', 1),
            ('call_permission_msg', 'Call permission denied', 'es_es', 'Permiso de llamada denegado', 1),
            ('no_records', 'No records found', 'es_es', 'No se encontrarón registros', 1),
            ('fullform', 'Create New', 'es_es', 'Forma completa', 1),
            ('save', 'Save', 'es_es', 'Guardarng', 1),
            ('total', 'Total', 'es_es', 'Total', 1),
            ('discount', 'Discount', 'es_es', 'Descuento', 1),
            ('price', 'Price', 'es_es', 'Precio *', 1),
            ('quantity', 'Quantity', 'es_es', 'Cantidad *', 1),
            ('select_module', 'Select Module', 'es_es', 'Seleccionar módulo', 1),
            ('item_list', 'Item List', 'es_es', 'Lista de articulos', 1),
            ('quickcreate', 'Quick Create', 'es_es', 'Creación rápida', 1),
            ('overwrite_msg_part1', 'Overwrite the existing address with the selected', 'es_es', 'Sobrescriba la dirección existente con la seleccionada', 1),
            ('once_in_every', 'Once in every', 'es_es', 'Una vez en cada', 1),
            ('overwrite_msg_part2', 'address details?', 'es_es', '¿detalles de dirección?', 1),
            ('add_item', 'Add Item', 'es_es', 'Agregar artículo', 1),
            ('recordsave', 'Record saved successfully', 'es_es', 'Registro guardado', 1),
            ('recordnotsave', 'Could not save record. Try again later', 'es_es', 'No se guardó el regitro', 1),
            ('minutes', 'Minutes', 'es_es', 'Minutos', 1),
            ('hours', 'Hours', 'es_es', 'horas', 1),
            ('days', 'Days', 'es_es', 'Dias', 1),
            ('on', 'On', 'es_es', 'En', 1),
            ('day_of_the_month', 'day of the month', 'es_es', 'día del mes', 1),
            ('list_price', 'List Price', 'es_es', 'Precio de lista *', 1),
            ('add_record', 'Add Record', 'es_es', 'Agregar registro', 1),
            ('add_product', 'Add Product', 'es_es', 'Agregar Producto', 1),
            ('add_service', 'Add Service', 'es_es', 'Agregar servicio', 1),
            ('discountin', 'Discount in %', 'es_es', 'Descuento en%', 1),
            ('unitprice', 'Unit price', 'es_es', 'Precio unitario *', 1),
            ('netprice', 'Net price', 'es_es', 'Precio neto *', 1),
            ('comments', 'Comments', 'es_es', 'Comentarios', 1),
            ('add_close', 'Add & Close', 'es_es', 'Agregar &amp; amp; Cerrar', 1),
            ('fetching_rout_message', 'Fetching route, Please wait…', 'es_es', 'Recogiendo ruta, por favor espere …', 1),
            ('setting', 'Settings', 'es_es', 'Ajustes', 1),
            ('utc', 'UTC', 'es_es', 'UTC', 1),
            ('in', 'In', 'es_es', 'En ', 1),
            ('days_ago', 'days ago', 'es_es', 'hace días', 1),
            ('mins_ago', 'Minutes ago', 'es_es', 'hace minutos', 1),
            ('justnow', 'Just now', 'es_es', 'Justo ahora', 1),
            ('hours_ago', 'hours ago', 'es_es', 'horas atras', 1),
            ('in_1_day', 'In 1 day', 'es_es', 'En 1 día', 1),
            ('scanqrcode', 'Asset / Card scanner', 'es_es', 'Escáner de tarjetas', 1),
            ('call_log', 'Call Log', 'es_es', 'Registro de llamadas', 1),
            ('voice_message', 'Hi', 'es_es', 'Hola', 1),
            ('voice_message1', 'What can I search for you in', 'es_es', '¿Qué puedo buscarte en?', 1),
            ('live_tracking', 'Live Tracking', 'es_es', 'Seguimiento en vivo', 1),
            ('mailmanager', 'Mail Manager', 'es_es', 'Administrador de correo', 1),
            ('my_location', 'My location', 'es_es', 'Mi ubicación', 1),
            ('created_on', 'Created On', 'es_es', 'Creado en', 1),
            ('modified_on', 'Modified On', 'es_es', 'Modificado en', 1),
            ('enter_comments', 'Enter Comments', 'es_es', 'Agregar comentarios', 1),
            ('viewmore', 'View More', 'es_es', 'Ver más', 1),
            ('viewless', 'View Less', 'es_es', 'Ver menos', 1),
            ('gotofullform', 'Go to Full Form', 'es_es', 'Ir a formulario completo', 1),
            ('post', 'Post', 'es_es', 'Enviar', 1),
            ('url', 'URL', 'es_es', 'URL', 1),
            ('dialog_title_text_back_color', 'Select a Text Background Color', 'es_es', 'Seleccione un color de fondo de texto', 1),
            ('event_or_task', 'Add event/task', 'es_es', 'Agregar evento / tarea', 1),
            ('shortcut', 'Shortcuts', 'es_es', 'Atajos', 1),
            ('select_field', 'Select Field', 'es_es', 'Seleccionar campo', 1),
            ('share', 'Share', 'es_es', 'Compartir', 1),
            ('title_insert_link', 'Insert Link', 'es_es', 'nsertar el link', 1),
            ('addyourcommentshere', 'Add your comments here', 'es_es', 'Agregue sus comentarios aquí', 1),
            ('nocomment', 'No Comments', 'es_es', 'Sin comentarios', 1),
            ('leads', 'Leads', 'es_es', 'Prospectos', 1),
            ('true_val', 'true', 'es_es', 'Verdadero', 1),
            ('noresult', 'No Result', 'es_es', 'Sin resultados', 1),
            ('version', 'Version', 'es_es', 'Versión', 1),
            ('convert_lead', 'Convert Lead', 'es_es', 'Convertir cliente potencial', 1),
            ('app_name', 'CRMTiger', 'es_es', 'SalesHiker', 1),
            ('enter_url', 'Please Enter url', 'es_es', 'Por favor ingrese url', 1),
            ('help', 'Help', 'es_es', 'Ayuda ', 1),
            ('contact_us', 'Contact Us', 'es_es', 'Contáctenos', 1),
            ('updates', 'Updates', 'es_es', 'Actualizar', 1),
            ('logout', 'LogOut', 'es_es', 'Cerrar sesión', 1),
            ('busnies_cardscanner', 'Business Card Scanner', 'es_es', 'Escáner de tarjetas de visita', 1),
            ('sure_want_logout', 'Are you sure want to logout ?', 'es_es', '¿Seguro que quiere cerrar sesión?', 1),
            ('logout_message', 'Logout successfully', 'es_es', '¿Seguro que quiere cerrar sesión?', 1),
            ('all', 'All', 'es_es', 'Todos', 1),
            ('add_event', 'Add event', 'es_es', 'Añadir evento', 1),
            ('add_task', 'Add Task', 'es_es', 'Agregar tarea', 1),
            ('next', 'Next', 'es_es', 'Proximo', 1),
            ('terms_conditions', 'Terms and Conditions', 'es_es', 'Terms and Conditions', 1),
            ('login', 'Login', 'es_es', 'Iniciar sesión', 2),
            ('privacy_policay', 'By logging in, you agree to our Terms and Conditions & Privacy Policy', 'es_es', 'Al iniciar sesión, usted acepta nuestros Términos y condiciones Política de privacidad', 2),
            ('copyright', 'Copyright © 2019 CRMTiger Version', 'es_es', 'Copyright © 2019 CRMTiger Versión ', 2),
            ('enter_username', 'Please enter username', 'es_es', 'Ingrese el usuario', 2),
            ('enter_password', 'Please enter password', 'es_es', 'Ingrese contraseña', 2),
            ('remanberme', 'Remember Me', 'es_es', 'Recordarme', 2),
            ('forgot_password', 'Forgot password?', 'es_es', '¿Olvidó la contraseña?', 2),
            ('privacy_policay1', 'Privacy Policy', 'es_es', 'Política de privacidad', 2),
            ('contactsupportmsg', 'Something went wrong. \\n please Click here to contact support.', 'es_es', 'Algo salió mal.', 2),
            ('enter_username_password', 'Entered Username or Password is wrong', 'es_es', 'El usuario o la contraseña son incorrectos', 2),
            ('server_issue_occured', 'Server issues occurred', 'es_es', 'Ocurrieron problemas con el servidor', 2),
            ('password', 'Password', 'es_es', 'Contraseña', 3),
            ('user_name', 'Username', 'es_es', 'Nombre de usuario', 3),
            ('reset_pwd', 'Reset Password', 'es_es', 'Restablecer la contraseña', 3),
            ('forgot_password_title', 'Forgot password', 'es_es', 'Olvidó la contraseña', 3),
            ('enter_user_name', 'Enter user name', 'es_es', 'Introduzca un nombre de usuario', 3),
            ('cc', 'Cc', 'es_es', 'Cc', 4),
            ('body', 'Body', 'es_es', 'Cuerpo', 4),
            ('bcc', 'BCC', 'es_es', 'BCC', 4),
            ('dialog_title_text_color', 'Select a Text Color', 'es_es', 'Seleccione un color de texto', 4),
            ('date', 'Date', 'es_es', 'Fecha', 4),
            ('subject', 'Subject', 'es_es', 'Tema', 4),
            ('composeMail', 'Compose Mail', 'es_es', 'Redactar correo', 4),
            ('send', 'Send', 'es_es', 'Enviar', 4),
            ('select_message', 'Select message', 'es_es', 'Seleccionar mensaje', 4),
            ('title_insert_table', 'Insert Table', 'es_es', 'Insertar tabla', 4),
            ('log_file_sms', 'I agree to Share API Log to Technical team for further troubleshooting', 'es_es', 'Estoy de acuerdo en compartir el registro de la API con el equipo técnico para solución de problemas ', 5),
            ('edit_record', 'Edit Records', 'es_es', 'Editar registros', 5),
            ('select_time', 'Select Time', 'es_es', 'Seleccione tiempo', 5),
            ('edit_item', 'Edit Item', 'es_es', 'Editar elemento', 5),
            ('items_total', 'Items Total', 'es_es', 'Total de artículos', 5),
            ('number_less_then_31', 'Number should be less than 31', 'es_es', 'El número debe ser menor que 31', 5),
            ('users', 'Users', 'es_es', 'Usuarios', 5),
            ('groups', 'Groups', 'es_es', 'Los grupos', 5),
            ('txt_note_for_file', 'Note : Existing attachments(images/files) will be replaced', 'es_es', 'Nota: los archivos adjuntos existentes (imágenes / archivos) serán reemplazados', 5),
            ('greaterdatetime', 'End DateTime should be greater than Start DateTime', 'es_es', 'La fecha y hora de finalización deben ser mayores que la fecha y hora de inicio', 5),
            ('until', 'Until', 'es_es', 'Hasta', 5),
            ('organizations', 'Organizations', 'es_es', 'Cuentas', 6),
            ('contacts', 'Contacts', 'es_es', 'Contactos', 6),
            ('opportunity', 'Opportunity', 'es_es', 'Oportunidad', 6),
            ('lbl_sun', 'SUN', 'es_es', 'DOM', 7),
            ('lbl_mon', 'MON', 'es_es', 'LUN', 7),
            ('lbl_tue', 'TUE', 'es_es', 'MAR', 7),
            ('lbl_wed', 'WED', 'es_es', 'MIE', 7),
            ('lbl_thu', 'THU', 'es_es', 'JUE', 7),
            ('lbl_fri', 'FRI', 'es_es', 'VIE', 7),
            ('lbl_sat', 'SAT', 'es_es', 'SAB', 7),
            ('lbl_1', '1', 'es_es', '1', 7),
            ('lbl_2', '2', 'es_es', '2', 7),
            ('lbl_3', '3', 'es_es', '3', 7),
            ('lbl_4', '4', 'es_es', '4', 7),
            ('lbl_5', '5', 'es_es', '5', 7),
            ('lbl_6', '6', 'es_es', '6', 7),
            ('lbl_7', '7', 'es_es', '7', 7),
            ('lbl_8', '8', 'es_es', '8', 7),
            ('lbl_9', '9', 'es_es', '9', 7),
            ('lbl_10', '10', 'es_es', '10', 7),
            ('lbl_11', '11', 'es_es', '11', 7),
            ('lbl_12', '12', 'es_es', '12', 7),
            ('lbl_13', '13', 'es_es', '13', 7),
            ('lbl_14', '14', 'es_es', '14', 7),
            ('lbl_15', '15', 'es_es', '15', 7),
            ('lbl_16', '16', 'es_es', '16', 7),
            ('lbl_17', '17', 'es_es', '17', 7),
            ('lbl_18', '18', 'es_es', '18', 7),
            ('lbl_19', '19', 'es_es', '19', 7),
            ('lbl_20', '20', 'es_es', '20', 7),
            ('lbl_21', '21', 'es_es', '21', 7),
            ('lbl_22', '22', 'es_es', '22', 7),
            ('lbl_23', '23', 'es_es', '23', 7),
            ('lbl_24', '24', 'es_es', '24', 7),
            ('lbl_25', '25', 'es_es', '25', 7),
            ('lbl_26', '26', 'es_es', '26', 7),
            ('lbl_27', '27', 'es_es', '27', 7),
            ('lbl_28', '28', 'es_es', '28', 7),
            ('lbl_29', '29', 'es_es', '29', 7),
            ('lbl_30', '30', 'es_es', '30', 7),
            ('lbl_31', '31', 'es_es', '31', 7),
            ('lbl_32', '32', 'es_es', '32', 7),
            ('lbl_33', '33', 'es_es', '33', 7),
            ('lbl_34', '34', 'es_es', '34', 7),
            ('lbl_35', '35', 'es_es', '35', 7),
            ('lbl_36', '36', 'es_es', '36', 7),
            ('lbl_37', '37', 'es_es', '37', 7),
            ('lbl_38', '38', 'es_es', '38', 7),
            ('lbl_39', '39', 'es_es', '39', 7),
            ('lbl_40', '40', 'es_es', '40', 7),
            ('lbl_41', '41', 'es_es', '41', 7),
            ('lbl_42', '42', 'es_es', '42', 7),
            ('current_date', 'current date', 'es_es', 'fecha actual', 7),
            ('event', 'Events', 'es_es', 'أEventos', 7),
            ('calendar', 'Calendar', 'es_es', 'Calendario', 7),
            ('latest_version', 'Latest Version :', 'es_es', 'Ultima versión : ', 8),
            ('expire_on', 'Expire On :', 'es_es', 'Vence en :', 8),
            ('ctmobile_ext_version', 'CTMobile Ext. Version :', 'es_es', 'CTMobile Ext. Versión :', 8),
            ('you_have_latest_version', 'You already have latest version', 'es_es', 'Has actualizado la versión ', 8),
            ('latest_version1', 'You Already have latest version', 'es_es', 'لYa tienes la última versióz', 8),
            ('upgreaded', 'Upgrade', 'es_es', 'Mejorar', 8),
            ('downgrade', 'Downgrade', 'es_es', 'Degradar', 8),
            ('dialog_recent_event_info', 'You can set from here how many number of records you want to show on Home screen for Recent Event.', 'es_es', 'You can set from here how many number of records you want to show on Home screen for Recent Event.', 8),
            ('dialog_feedback_info', 'You can submit your feedback with description , our team will check your feedback and get back to you.', 'es_es', 'Puede enviar sus comentarios con una descripción, nuestro equipo revisará sus comentarios y se comunicará con usted.', 8),
            ('dialog_log_info', 'Log functionality is used for customer support / help , If you are facing any issues in app or any module or functionality is not working proper then you can enable share log with our development team.', 'es_es', 'Puede configurar desde aquí la cantidad de registros que desea mostrar en la pantalla de Inicio para eventos recientes.', 8),
            ('info', 'Info', 'es_es', 'Información', 8),
            ('recent_history', 'Recent History', 'es_es', 'Historia reciente', 8),
            ('recent_feedback', 'Feedback', 'es_es', 'FeedSign In Failed.Trate de nuevo después', 8),
            ('recent_log', 'Log', 'es_es', 'Iniciar sesión', 8),
            ('crmtiger_app_version', 'CRMTiger App Version :', 'es_es', 'Versión de la aplicación CRMTiger:', 8),
            ('historylimit', 'Recent History Limit', 'es_es', 'Límite de historial', 8),
            ('radious_in_miles', 'Radius in miles', 'es_es', 'Radio en millas', 8),
            ('recentlimit', 'Recent Event Limit', 'es_es', 'Límite de eventos recientes', 8),
            ('upcoming_events', 'Upcoming Events', 'es_es', 'Próximos eventos', 8),
            ('rate_our_app', 'Rate Our App!', 'es_es', 'Califica nuestra aplicación!', 8),
            ('feedback', 'Submit Feedback', 'es_es', 'Enviar comentarios', 8),
            ('sendfeedback', 'Feedback Send', 'es_es', 'Enviar comentarios', 8),
            ('emaillimit', 'Email limit', 'es_es', 'Límite de correo electrónico', 8),
            ('log', 'Log', 'es_es', 'Iniciar sesión', 8),
            ('logclear', 'Log cleared successfully.','es_es','Limpieza exitosa', 8),
            ('dialog_recent_history_info', 'You can set from here how many number of records you want to show on Home screen for Recent History.', 'es_es', 'Puede establecer desde aquí la cantidad de registros que desea mostrar en la pantalla de Inicio para Historial reciente.', 8),
            ('proceed_to_upgrade1', 'Proceed to', 'es_es', 'Proceder a', 8),
            ('upgradation_message', 'will required logout and login again later.', 'es_es', 'será necesario cerrar la sesión y volver a iniciar sesión más tarde.', 8),
            ('proceed_to_upgrade', 'Proceed to Upgrade', 'es_es', 'Continuar con la actualización', 8),
            ('module_setting', 'Module Setting', 'es_es', 'Configuración del módulo', 9),
            ('sortbyfield', 'Sort by field', 'es_es', 'Ordenar por campo', 9),
            ('ascending', 'Ascending  A to Z', 'es_es', 'Ascendiendo de la A a la Z', 9),
            ('descending', 'Descending  Z to A', 'es_es', 'Z descendente a A', 9),
            ('first_field', 'First Field', 'es_es', 'Primer campo', 9),
            ('second_field', 'Second Field', 'es_es', 'Segundo campo', 9),
            ('third_field', 'Third Field', 'es_es', 'Tercer campo', 9),
            ('sure_want_restore', 'Are you sure you want to reset to default settings?', 'es_es', '¿Estás seguro de que quieres restaurar el predeterminado', 9),
            ('orderlist', 'List Order', 'es_es', 'Orden de la lista', 9),
            ('module_reset', 'Restore to Default', 'es_es', 'Restablecen a los predeterminados', 9),
            ('display_fields', 'Display Fields', 'es_es', 'Campos de visualización', 9),
            ('discount_lessthen_100', 'Discount % should be less than 100', 'es_es', '% El descuento debeser menor a 100', 10),
            ('select_item', 'Select Item', 'es_es', 'Seleccione un artículo', 10),
            ('item_comment', 'Item Comment', 'es_es', 'Comentario del artículo', 10),
            ('record_name', 'Record Name is :', 'es_es', 'El nombre del registro es:', 11),
            ('go_back', 'Go Back', 'es_es', 'Regresa', 11),
            ('please_enter_shortcut_name', 'Please Enter Shortcut Name', 'es_es', 'Por favor ingrese el nombre del atajo', 11),
            ('number_not_found', 'Contact Number not found', 'es_es', 'Número de contacto no encontrado', 11),
            ('mail_not_found', 'Mail Address not found', 'es_es', 'Dirección de correo no encontrada', 11),
            ('create_shortcut', 'Create Shortcut', 'es_es', 'Crear acceso directo', 11),
            ('contact_summary', 'Summary', 'es_es', 'Resumen', 11),
            ('activites', 'Activities', 'es_es', 'Actividadess', 11),
            ('details', 'Details', 'es_es', 'Detalles', 11),
            ('related', 'Related', 'es_es', 'Relacionado', 11),
            ('share_link', 'Share record with', 'es_es', 'Compartir registro con', 11),
            ('edit', 'Edit', 'es_es', 'Editar', 11),
            ('duplicate', 'Duplicate', 'es_es', 'Duplicar', 11),
            ('whatsapp', 'Whatsapp', 'es_es', 'Whatsapp', 11),
            ('call', 'Call', 'es_es', 'LLamada', 11),
            ('choose_contact_for_call', 'Choose Contact for Call', 'es_es', 'Elija contacto para llamar', 11),
            ('choose_contact_for_sms', 'Choose Contact for SMS', 'es_es', 'Elija Contacto para SMS', 11),
            ('choose_contact_for_whatsapp', 'Choose Contact for WhatsApp', 'es_es', 'Elija Contacto para WhatsApp', 11),
            ('chosse_contact_for_email', 'Choose Email', 'es_es', 'Elija Email', 11),
            ('attach_file', 'Attach Files', 'es_es', 'Adjuntar archivos', 11),
            ('close', 'Close', 'es_es', 'Cerrar', 11),
            ('status', 'Status', 'es_es', 'Estado', 11),
            ('stop', 'Stop', 'es_es', 'Detener', 11),
            ('zero', '0', 'es_es', 'Cero', 11),
            ('record', 'Record', 'es_es', 'Grabar', 11),
            ('voice_note', 'Voice Note', 'es_es', 'Nota de Voz', 11),
            ('tickets', 'Tickets', 'es_es', 'Entradas', 12),
            ('check_out', 'Check Out', 'es_es', 'Revisa', 12),
            ('check_in', 'Check In', 'es_es', 'Registrarse', 12),
            ('select_any', 'Select any', 'es_es', 'Seleccione cualquiera', 12),
            ('fulldetails', 'Show Full Details', 'es_es', 'Mostrar detalles completos', 12),
            ('checkin', 'Check-in', 'es_es', 'Registrarse', 12),
            ('navigate', 'Navigate', 'es_es', 'Navegar', 12),
            ('product', 'Products', 'es_es', 'Productos', 12),
            ('projectMilestone', 'Project Milestone', 'es_es', 'Hito del proyecto', 12),
            ('projecttask', 'Project Tasks', 'es_es', 'Tarea de proyecto', 12),
            ('nearby', 'NearBy', 'es_es', 'Cerca', 13),
            ('document', 'Document', 'es_es', 'Documento', 14),
            ('reply', 'Reply', 'es_es', 'Respuesta', 14),
            ('reply_all', 'Reply All', 'es_es', 'Responder a todos', 14),
            ('forward', 'Forward', 'es_es', 'Adelante', 14),
            ('action', 'Action', 'es_es', 'Action', 14),
            ('select_first', 'Select First', 'es_es', 'Seleccionar primero', 14),
            ('commentaddsuccessful', 'Comment added successfull', 'es_es', 'Comentar agregar con éxito', 14),
            ('move_to', 'Move to', 'es_es', 'Mover a', 14),
            ('attach', 'Attach', 'es_es', 'Adjuntar', 14),
            ('addcoment', 'Add Comment', 'es_es', 'Agregar comentario', 14),
            ('adddocument', 'Add Document', 'es_es', 'Agregar documento', 14),
            ('home', 'Home', 'es_es', 'Inicio', 15),
            ('checkout', 'Check-out', 'es_es', 'Revisar', 15),
            ('message_search', 'Search by name', 'es_es', 'Buscar por nombre', 15),
            ('start_shift', 'Start shift', 'es_es', 'Inicio de turno', 15),
            ('end_shift', 'End shift', 'es_es', 'Fin de turno', 15),
            ('today_meeting', 'Meetings', 'es_es', 'Reuniones', 15),
            ('shift_time_track', 'Shift Time Track', 'es_es', 'Cambiar tiempo', 15),
            ('logout_msg', 'You have to login again , click', 'es_es', 'Tienes que iniciar sesión de nuevo, haz clic', 15),
            ('logout_msg1', 'to continue.', 'es_es', 'Continuar.', 15),
            ('permission_denied', 'You don\'t have permission to create', 'es_es', 'No tienes permiso para crear', 15),
            ('history', 'Activity stream', 'es_es', 'Últimas acciones', 15),
            ('search_value', 'Search value :', 'es_es', 'Enviar mensaje', 15),
            ('feed_back_msg', 'Please enter feedback message', 'es_es', 'Ingrese un mensaje de retroalimentación', 16),
            ('feed_back_hint_msg', 'Enter feedback message', 'es_es', 'Ingresar mensaje de retroalimentación', 16),
            ('submit', 'Submit', 'es_es', 'Enviar', 16),
            ('check_app_not_installed', 'Application is not currently installed.', 'es_es', 'La aplicación no está instalada actualmente.', 17),
            ('send_sms_fail_message', 'SMS failed, please try again later!', 'es_es', 'Error de SMS, por favor intente de nuevo más tarde!', 17),
            ('documentaddsuccessfully', 'Document Attach successfully', 'es_es', 'Documento adjunto exitosamente', 17),
            ('send_message', 'Send message', 'es_es', 'Send message', 17),
            ('sms_to', 'smsto:', 'es_es', 'smsto:', 17),
            ('add_list_message', 'Add List', 'es_es', 'Agregar lista', 18),
            ('mylist', 'My List', 'es_es', 'Mi lista', 18),
            ('filtername', 'Filter Name', 'es_es', 'Nombre del filtro', 18),
            ('selectlist', 'Select a List', 'es_es', 'Seleccione una lista *', 18),
            ('assingedto', 'Assigned To', 'es_es', 'Asignado a *', 18),
            ('selectmodule', 'Select a module', 'es_es', 'Seleccione un modulo', 18),
            ('add_list', 'Add Filter', 'es_es', 'Agregar filtro', 18),
            ('recent_event', 'Recent Event', 'es_es', 'Evento reciente', 19),
            ('recent_hostory', 'Recent History', 'es_es', 'Historial reciente', 19),
            ('module_specific_settings', 'Module-Specific Settings', 'es_es', 'Configuración específica del módulo', 19),
            ('talk_to_us', 'Talk to us', 'es_es', 'Háblanos', 19),
            ('report_a_bug', 'Report A Bug', 'es_es', 'Reportar un error', 19),
            ('faq', 'FAQ', 'es_es', 'Preguntas más frecuentes', 19),
            ('selectmodules', 'Select Module', 'es_es', 'Seleccionar módulo', 19),
            ('myplan', 'My Plan', 'es_es', 'Mi Plan', 19),
            ('message', 'Message', 'es_es', 'Mensaje', 20),
            ('message_validation', 'Please enter Message', 'es_es', 'Por favor ingrese un mensaje', 20),
            ('contact_select', 'Please Select contact', 'es_es', 'Seleccione contacto', 20),
            ('global_search', 'Global Search', 'es_es', 'Búsqueda global', 21),
            ('records', 'Records', 'es_es', 'Grabar', 21),
            ('dont_show_again', 'Don\'t Show Again', 'es_es', 'No volver a mostrar', 22),
            ('skip', 'Skip', 'es_es', 'Omitir', 22),
            ('file_downloading', 'File Downloading', 'es_es', 'Descarga de archivos', 23),
            ('add_screenshots_optional', 'Add screenshots (optional)', 'es_es', 'Añadir capturas de pantalla (opcional)ss', 24),
            ('describe_your_problem', 'Describe your problem', 'es_es', 'Describe tu problema', 24),
            ('default_filter_shortcut', 'Default Filter Shortcut', 'es_es', 'Atajo de filtro predeterminado', 25),
            ('record_shortcut', 'Record Shortcut', 'es_es', 'enter_url', 25),
            ('enter_url', 'Please Enter url', 'es_es', 'Por favor ingrese url', 26),
            ('new_version_is_avaiable', 'You need to update the app to continue using Please update to continue Older versions will no longer work from today', 'es_es', 'Necesita actualizar la aplicación para continuar usando. Actualice a', 26),
            ('search_by', 'Search by', 'es_es', 'Búsqueda por', 27),
            ('selected_filter', 'Selected filter :', 'es_es', 'Filtro seleccionado: -', 27),
            ('selected_field', 'Selected field :', 'es_es', 'Campo seleccionado: -', 27),
            ('choose', 'Choose', 'es_es', 'Escoger', 28),
            ('qr_cardscanner', 'QR Code Scanner', 'es_es', 'Escáner de código QR', 28),
            ('error_message_for_scan', 'Could not read the card Try again later.', 'es_es', 'No se pudo leer la tarjeta vuelva a intentarlo más tarde.', 28),
            ('press_start_scan', 'Press to Start Scan', 'es_es', 'Presione para comenzar a escanear', 28),
            ('line_item_quntity_validation_msg', 'Value should be greater than zero', 'es_es', 'El valor debe ser mayor que cero', 29),
            ('percentage_msg', 'Percentage should be less than 100', 'es_es', 'El porcentaje debe ser inferior a 100', 29),
            ('MSG_NO_DATA', 'No data found!', 'es_es', '¡Datos no encontrados!', 29),
            ('MSG_SOMETHING_WRONG', 'Something went wrong!', 'es_es', '¡Algo salió mal!', 29),
            ('MSG_COMING_SOON', 'Coming Soon!', 'es_es', '¡Próximamente!', 29),
            ('MSG_UPLOAD_PROFILE_IMAGE', 'Please upload profile image.', 'es_es', 'Sube la imagen de perfil.', 29),
            ('ALERT_TITLE_LOCATION_ACCESS', 'Location Access', 'es_es', 'Acceso a la ubicación', 29),
            ('ALERT_MSG_LOCATION_ACCESS', 'Requires your location to show nearby events.', 'es_es', 'Requiere su ubicación para mostrar eventos cercanos.', 29),
            ('ALERT_BTN_ALLOW', 'ALLOW', 'es_es', 'PERMITIR', 29),
            ('ALERT_BTN_DENY', 'DENY', 'es_es', 'NEGAR', 29),
            ('ALERT_MSG_LOCATION_SETTING', 'Not able to fetch your current location. Please check your location settings.', 'es_es', 'No se puede recuperar su ubicación actual. Compruebe la configuración de su ubicación.', 29),
            ('DELETE_RECORD', 'Delete Record', 'es_es', 'Eliminar el registro', 29),
            ('ALERT_MSG_DELETE_SHORTCUT', 'Are you sure want to delete this shortcut?', 'es_es', '¿Estás seguro de que quieres eliminar este acceso directo?', 29),
            ('DELETE_SHORTCUT', 'Delete Shortcut', 'es_es', 'Eliminar acceso directo', 29),
            ('LBL_TERMS', 'By logging in, you agree to our Terms and', 'es_es', 'Al iniciar sesión, acepta nuestros Términos y', 29),
            ('LBL_CONDITIONS', 'Conditions &', 'es_es', 'Condiciones y', 29),
            ('ALERT_TITLE', 'Alert', 'es_es', 'Alerta', 29),
            ('ALERT_BTN_SUBSCRIBE', 'Subscribe', 'es_es', 'Suscribir', 29),
            ('MSG_SELECT_MODULE', 'Please select any Module', 'es_es', 'Seleccione cualquier módulo', 29),
            ('MSG_SELECT_LIST', 'Please select any List', 'es_es', 'Seleccione cualquier listas', 29),
            ('ALERT_MSG_DONT_HAVE_CAMERA', 'You don\'t have camera', 'es_es', 'No tienes camara', 29),
            ('ALERT_MSG_GALLARY_PERMISSION', 'You don\'t have permission to access gallery.', 'es_es', 'No tienes permiso para acceder a la galería.', 29),
            ('ALERT_MSG_CAMERA_PERMISSION', 'You don\'t have permission to access camera. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Camera on', 'es_es', 'No tienes permiso para acceder a la cámara. Ir a configuración ->
            Desplácese hacia abajo y seleccione la aplicación CRMTiger -> Activar cámar', 29),
            ('ALERT_MSG_SPEECH_PERMISSION', 'You don\'t have permission to access Speech Recognition. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Speech Recognition on', 'es_es', 'No tiene permiso para acceder al reconocimiento de voz.
            Vaya a configuración -> Desplácese hacia abajo y seleccione Aplicación CRMTiger ->
            Activar el reconocimiento de voz', 29),
            ('BTN_DONE', 'Done', 'es_es', 'Listo', 29),
            ('COMMENT', 'Comment', 'es_es', 'Comentario', 29),
            ('FULL_FORM', 'Full Form', 'es_es', 'Forma completa', 29),
            ('QUICK_CREATE', 'Create', 'es_es', 'Crear', 29),
            ('LBL_SELECT_FIELDS', 'Select Fields', 'es_es', 'Seleccionar campos', 29),
            ('LBL_SELECT_FIELDS', 'Select Fields', 'es_es', 'Seleccionar campos', 29),
            ('LBL_SELECT_FIRST_FIELDS', 'Select First Field', 'es_es', 'Seleccionar primer campo', 29),
            ('LBL_SELECT_SECOND_FIELDS', 'Select Second Field', 'es_es', 'Seleccionar segundo campo', 29),
            ('LBL_SELECT_THIRD_FIELDS', 'Select Third Field', 'es_es', 'Seleccionar tercer campo', 29),
            ('LBL_SORT_BY_FIELD', 'Select Sort By Field', 'es_es', 'Seleccione Ordenar por campo', 29),
            ('BTN_RESET_TO_DEFAULT', 'Reset to Default', 'es_es', 'restablecen a los predeterminados', 29),
            ('MSG_SELECT_SORT_BY_FIELD', 'Select Sort by field', 'es_es', 'Seleccione Ordenar por campo', 29),
            ('kStrClearBtnTitle', 'Clear', 'es_es', 'Claro', 29),
            ('kStrShowMoreBtnTitle', 'Show More', 'es_es', 'Mostrar más', 29),
            ('kStrAddActivitiesBtnTitle', 'Add Activities', 'es_es', 'Agregar actividades', 29),
            ('kStrAddCommentPlaceHolder', 'Add your comments here', 'es_es', 'Agrega tus comentarios aquí', 29),
            ('MSG_ENTER_TO_EMAIL', 'Please enter to field.', 'es_es', 'Ingrese al campo.', 29),
            ('WARNING_FILE', 'File can\'t open.', 'es_es', 'El archivo no se puede abrir.', 29),
            ('MSG_FILE_SAVED', 'File saved.', 'es_es', 'Archivo guardado.', 29),
            ('WARNING_DOWNLOAD_FAIL', 'Download fail!, please try after sometime.', 'es_es', '¡Error de descarga !, inténtelo más tarde.', 29),
            ('LBL_SHORTCUT', 'Shortcut', 'es_es', 'Atajo', 29),
            ('TXT_MESSAGE_PLACEHOLDER', 'Type Message', 'es_es', 'Escribir mensaje', 29),
            ('ALERT_INSTALL_WHATSAPP', 'Install Whatsapp', 'es_es', 'Instalar whatsapp', 29),
            ('MSG_NO_MAIL_BOX', 'No MailBox found. Please Create Mailbox', 'es_es', 'No se encontró ningún buzón. Crear buzón', 29),
            ('LBL_WROTE', 'Wrote', 'es_es', 'Escribió', 29),
            ('MSG_MAIL_SEND', 'Mail sent', 'es_es', 'Correo enviado', 29),
            ('log_file_not_found', 'API Log file not found.', 'es_es', 'No se encontró el archivo de registro de API.', 29),
            ('unknown_error', 'An unknown error occurred, try again', 'es_es', 'Ocurrió un error desconocido, inténtalo de nuevo', 29),
            ('CTMTigerAppVersion', 'CRMTiger App Version', 'es_es', 'Versión de la aplicación CRMTiger', 29),
            ('CTMMobileUpdateMsg', 'CTMobile Ext. Version Update Successfully', 'es_es', 'CTMobile Ext. Actualización de la versión con éxito', 29),
            ('dialog_Premium_downgrade', 'Downgrade will required logout and login again later', 'es_es', 'La degradación requerirá cerrar sesión y volver a iniciar sesión más tarde', 29),
            ('dialog_Premium', 'Upgrade will required logout and login again later', 'es_es', 'La actualización requerirá cerrar sesión y volver a iniciar sesión más tarde', 29),
            ('Overwrite', 'Overwrite', 'es_es', 'Sobrescribir', 29),
            ('MSGAddressOverwrite1', 'Overwrite the existing address with the selected', 'es_es', 'Sobrescriba la dirección existente con la seleccionada', 29),
            ('MSGAddressOverwrite2', 'address details?', 'es_es', '¿detalles de dirección?', 29),
            ('UPGRADE_PLAN', 'Upgrade Plan', 'es_es', 'Plan de actualización', 29),
            ('DOWNGRADE_PLAN', 'Downgrade Plan', 'es_es', 'Plan de degradación', 29),
            ('UPGRADE_EXTENSION', 'Upgrade Extension', 'es_es', 'Actualizar extensión', 29),
            ('UPGRADE_APP', 'Upgrade App', 'es_es', 'Actualizar aplicación', 29),
            ('SELECT_OPTION', 'Select Option', 'es_es', 'Seleccionar opción', 29),
            ('PLEASE_SELECT', 'Please select', 'es_es', 'Por favor seleccione', 29),
            ('MSG_ACCESS_DENIED', 'You don\'t have permission for this module.', 'es_es', 'No tienes permiso para este módulo', 29),
            ('MSG_SELECT_RECCURING_MONTH_DAY', 'Please select reccuring day of month.', 'es_es', 'Seleccione el día recurrente del mes.', 29),
            ('MSG_SELECT_RECCURING_WEEK_DAY', 'Please select reccuring day of week.', 'es_es', 'Seleccione el día de la semana recurrente.', 29),
            ('MSG_SELECT_RECCURING_DAYS', 'Please select reccuring days.', 'es_es', 'Seleccione días recurrentes.', 29),
            ('Please select reccuring days.', 'Please select reccuring days.', 'es_es', 'Seleccione días recurrentes.', 29),
            ('MSG_SELECT_RECCURING_END_DATE', 'Please select reccuring end date.', 'es_es', 'Seleccione la fecha de finalización recurrente.', 29),
            ('MSG_SELECT_RECCURING_TYPE', 'Please select reccuring type.', 'es_es', 'Seleccione el tipo recurrente.', 29),
            ('FREQ_TIME', 'Times', 'es_es', 'Veces ', 29),
            ('REPEAT_YEARLY', 'Repeat Yearly', 'es_es', 'Repetir anualmente', 29),
            ('REPEAT_MONTHLY', 'Repeat Monthly', 'es_es', 'Repetir mensualmente', 29),
            ('REPEAT_WEEKLY', 'Repeat Weekly', 'es_es', 'Repetir semanalmente', 29),
            ('REPEAT_DAILY', 'Repeat Daily', 'es_es', 'Repetir diariamente', 29),
            ('ACTION_TITLE', 'Action Title', 'es_es', 'Título de la acción', 29),
            ('MSG_SELECT_VALID_DATE', 'Please select valid day of month.', 'es_es', 'Seleccione un día válido del mes.', 29),
            ('MSG_SELECT_VALID_START_DATE', 'Start date should be less than end date.', 'es_es', 'La fecha de inicio debe ser menor que la fecha de finalización.', 29),
            ('MSG_SELECT_VALID_START_TIME', 'Start time should be less than end time.', 'es_es', 'La hora de inicio debe ser menor que la hora de finalización.', 29),
            ('LBL_LINEITEM_DETAILS', 'Lineitem Details', 'es_es', 'Detalles del elemento de línea', 29),
            ('MSG_INVALIDE_DISCOUNT_AMOUNT', 'Discount amount should be less than the total.', 'es_es', 'El monto del descuento debe ser menor que el total.', 29),
            ('VIEW', 'View', 'es_es', 'Ver', 29),
            ('MSG_ENTER_VALID', 'Please enter valid', 'es_es', 'Por favor enter válido', 29),
            ('MSG_ENTER_PERCENTAGE', 'Percentage should be less than 100.', 'es_es', 'El porcentaje debe ser inferior a 100.', 29),
            ('ITEM_TOTAL', 'Item Total', 'es_es', 'Item Total', 29),
            ('ADJUSTMENT', 'Adjustment', 'es_es', 'Ajustamiento', 29),
            ('TITLE_CHOOSE_IMAGE', 'Choose Image', 'es_es', 'Elegir imagen', 29),
            ('COMPRESS', 'Compress', 'es_es', 'Comprimir', 29),
            ('CHOOSE_ANOTHER_IMAGE', 'Your image size is too large, please select another image', 'es_es', 'El tamaño de su imagen es demasiado grande, seleccione otra imagen', 29),
            ('OnDayOfMonth', 'On day of month', 'es_es', 'El día del mes', 29),
            ('OnDayOfWeek', 'On day of week', 'es_es', 'El día de la semana', 29),
            ('AddAndClose', 'Add & Close', 'es_es', 'Agregar y cerrar', 29),
            ('Repeat', 'Repeat', 'es_es', 'Repetir', 29),
            ('OnDay', 'On day', 'es_es', 'En el día', 29),
            ('View_Line_Item', 'View Line Item', 'es_es', 'Ver línea de pedido', 29),
            ('TITLE_IMAGE', 'Image', 'es_es', 'Imagen', 29),
            ('TITLE_ICLOUD', 'iCloud', 'es_es', 'ICloud', 29),
            ('GOOGLE', 'Google', 'es_es', 'Google', 29),
            ('ALERT_BTN_OKAY', 'Okay', 'es_es', 'Bueno', 29),
            ('ALERT_TITLE_ACCESS_DENIED', 'Access Denied', 'es_es', 'Acceso denegado', 29),
            ('Dont_Show_Again', 'Don\'t show again', 'es_es', 'No volver a mostrar', 29),
            ('Skip', 'Skip', 'es_es', 'Omitir', 29),
            ('Fillter_Name', 'Fillter Name', 'es_es', 'Nombre del filtro', 29),
            ('Fillter_Record_Count', 'Fillter Record Count', 'es_es', 'Recuento de registros de filtro', 29),
            ('url_note',      'Note : if your URL of CRM is https://example.com/crm enter that into above box',   'es_es',    'Note : if your URL of CRM is https://example.com/crm enter that into above box',   31),
            ('vtiger_url',    'Your vTiger CRM URL',  'es_es',    'Your vTiger CRM URL',  31),
            ('msg_doc_read_permission',   'You don\'t have permission to Add either This is read-only or Private Field.',     'es_es',    'You don\'t have permission to Add either This is read-only or Private Field.',     31),
            ('CLEAR',   'Clear',    'es_es',    'Claro',    31),
            ('Files/photos uploaded successfully',    'Files/photos uploaded successfully',     'es_es',    'Archivos / fotos subidos con éxito',     32),
            ('Digital signature saved',   'Digital signature saved',    'es_es',    'Firma digital guardada',    32),
            ('Please upload Signature or Files/photos',     'Please upload Signature or Files/photos',      'es_es',    'Cargue la firma o archivos / fotos',      32),
            ('Files / Photos',      'Files / Photos', 'es_es',    'Archivos / Fotos', 32),
            ('Signature',     'Signature',      'es_es',    'Firma',      32),
            ('add_photo_using',     'Add Photo Using',      'es_es',    'Agregar foto usando',      31),
            ('btn_upload_sign',     '(+) Add Signature',    'es_es',    '(+) Agregar firma',    31),
            ('btn_upload_photo_doc',      '(+) Upload Files/Photos',    'es_es',    '(+) Cargar archivos / fotos',    31),
            ('select_photo_doc_to_upload',      'Please select files/photos to upload',   'es_es',    'Seleccione archivos / fotos para cargar',   31),
            ('related_module_title',      'Search from related module and Add to \"Route\"',    'es_es',    'Buscar desde el módulo relacionado y agregar a \"Ruta\"',    30),
            ('Route status updated successfully',     'Route status updated successfully',      'es_es',    'REl estado de la ruta se actualizó correctamente',      32),
            ('Session init failed', 'Session init failed',  'es_es',    'Error al iniciar la sesión',  32),
            ('You don\'t have permission to access this resource',      'You don\'t have permission to access this resource', 'es_es',    'No tienes permiso para acceder a este recurso', 32),
            ('ctroute_realtedto cannot be empty',     'Could not get the Related To - Try again later',     'es_es',    'No se pudo obtener el relacionado con - Inténtelo de nuevo más tarde',     32),
            ('ctroute_planning cannot be empty',      'Could not get the Route Planning Record - Try again later',      'es_es',    'No se pudo obtener el registro de planificación de ruta. Vuelva a intentarlo más tarde.',      32),
            ('Something went wrong - Try again later',      'Something went wrong - Try again later', 'es_es',    'Se produjo un error. Vuelve a intentarlo más tarde.', 32),
            ('sequence updated successfully',   'sequence updated successfully',    'es_es',    'secuencia actualizada con éxito',    32),
            ('sequence cannot be empty',  'sequence cannot be empty',   'es_es',    'la secuencia no puede estar vacía',   32),
            ('Shortcut details not saved',      'Shortcut details not saved', 'es_es',    'No se guardaron los detalles del acceso directo', 32),
            ('Shortcut details saved successfully',   'Shortcut details saved successfully',    'es_es',    'Los detalles del acceso directo se guardaron correctamente',    32),
            ('Route save successfully',   'Route save successfully',    'es_es',    'Ruta guardada correctamente',    32),
            ('Record save successfully',  'Record save successfully',   'es_es',    'Grabar guardar con éxito',   32),
            ('No dependency found for picklist',      'No dependency found for picklist', 'es_es',    'No se encontró ninguna dependencia para la lista de selección', 32),
            ('No records found',    'No records found',     'es_es',    'No se encontraron registros',     32),
            ('Outgoing server is not enabled, please configure from CRM',     'Outgoing server is not enabled, please configure from CRM',      'es_es',    'El servidor saliente no está habilitado, configure desde CRM',      32),
            ('Removed Successfully',      'Removed Successfully', 'es_es',    'Eliminado con éxito', 32),
            ('Shortcut has been deleted', 'Shortcut has been deleted',  'es_es',    'Se ha eliminado el acceso directo',  32),
            ('relation of records removed successfully',    'relation of records removed successfully',     'es_es',    'relación de registros eliminados con éxito',     32),
            ('relation of records not removed', 'relation of records not removed',  'es_es',    'relación de registros no eliminados',  32),
            ('Record has been deleted successfully',  'Record has been deleted successfully',   'es_es',    'El registro se ha eliminado correctamente',   32),
            ('Time Tracking saved successfully',      'Time Tracking saved successfully', 'es_es',    'El seguimiento del tiempo se guardó correctamente', 32),
            ('Time Tracking updated successfully',    'Time Tracking updated successfully',     'es_es',    'Seguimiento de tiempo actualizado correctamente',     32),
            ('Time Tracking ended successfully',      'Time Tracking ended successfully', 'es_es',    'El seguimiento del tiempo finalizó correctamente', 32),
            ('Time Tracking started successfully',    'Time Tracking started successfully',     'es_es',    'El seguimiento del tiempo finalizó correctamente',     32),
            ('record cannot be empty',    'record cannot be empty',     'es_es',    'el registro no puede estar vacío',     32),
            ('Module is disabled',  'Module is disabled',   'es_es',    'El módulo está deshabilitado',   32),
            ('Shift ended successfully',  'Shift ended successfully',   'es_es',    'El turno terminó con éxito',   32),
            ('Shift started successfully',      'Shift started successfully', 'es_es',    'El turno comenzó con éxito', 32),
            ('relation of records added successfully',      'relation of records added successfully', 'es_es',    'relación de registros agregados con éxito', 32),
            ('Comment saved successfully',      'Comment saved successfully', 'es_es',    'Comentario no guardado', 32),
            ('Comment not saved',   'Comment not saved',    'es_es',    'Comentario no guardado',    32),
            ('Comment module is not active',    'Comment module is not active',     'es_es',    'El módulo de comentarios no está activo',     32),
            ('No Upcoming Event',   'No Upcoming Event',    'es_es',    'Ningún evento próximo',    32),
            ('No Templates found - create it from Message Templates module',  'No Templates found - create it from Message Templates module',   'es_es',    'No se encontraron plantillas: créelo desde el módulo Plantillas de mensajes',   32),
            ('No event or task for this date',  'No event or task for this date',   'es_es',    'Ningún evento o tarea para esta fecha',   32),
            ('No filters created',  'No filters created',   'es_es',    'No se crearon filtros',   32),
            ('Select at least one record to attach',  'Select at least one record to attach',   'es_es',    'Seleccione al menos un registro para adjuntar',   32),
            ('Please select one or more attachments', 'Please select one or more attachments',  'es_es',    'Seleccione uno o más archivos adjuntos',  32),
            ('No event for this month',   'No event for this month',    'es_es',    'Ningún evento para este mes',    32),
            ('No Activity found',   'No Activity found',    'es_es',    'No se encontró actividad',    32),
            ('Your feedback is valuable for us - it cannot be empty',   'Your feedback is valuable for us - it cannot be empty',    'es_es',    'Sus comentarios son valiosos para nosotros, no pueden estar vacíos',    32),
            ('Could not send mail, Please try later', 'Could not send mail, Please try later',  'es_es',    'No se pudo enviar el correo. Inténtelo más tarde.',  32),
            ('Latest Version updated successfully',   'Latest Version updated successfully',    'es_es',    'Última versión actualizada correctamente',    32),
            ('User Location Updated Successfully',    'User Location Updated Successfully',     'es_es',    'Ubicación del usuario actualizada correctamente',     32),
            ('User Location not Updated Successfully',      'User Location not Updated Successfully', 'es_es',    'La ubicación del usuario no se actualizó correctamente', 32),
            ('SMSNotifier is not enable in CRM. Please enable it first',      'SMSNotifier is not enable in CRM. Please enable it first', 'es_es',    'SMSNotifier no está habilitado en CRM. Habilítelo primero', 32),
            ('Could not submit your feedback - Please try again later', 'Could not submit your feedback - Please try again later',  'es_es',    'No se pudieron enviar sus comentarios. Vuelva a intentarlo más tarde.',  32),
            ('Thank you for submitting your feedback',      'Thank you for submitting your feedback', 'es_es',    'Gracias por enviar sus comentarios.', 32),
            ('Please upload User Image',  'Please upload User Image',   'es_es',    'Cargue la imagen de usuario',   32),
            ('Image Not Uploading, please try again', 'Image Not Uploading, please try again',  'es_es',    'La imagen no se está cargando, inténtelo de nuevo',  32),
            ('User Image Uploaded Successfully',      'User Image Uploaded Successfully', 'es_es',    'Imagen de usuario cargada correctamente', 32),
            ('Invalid Module name', 'Invalid Module name',  'es_es',    'Nombre de módulo no válido',  32),
            ('Records Sync Successfully', 'Records Sync Successfully',  'es_es',    'Los registros se sincronizan correctamente',  32),
            ('Values cannot be empty',    'Values cannot be empty',     'es_es',    'Los valores no pueden estar vacíos',     32),
            ('Record id is empty',  'Record id is empty',   'es_es',    'El ID de registro está vacío',   32),
            ('Logout Successfully', 'Logout Successfully',  'es_es',    'Cerrar sesión correctamente',  32),
            ('Please Enable CTMobile Module',   'Please Enable CTMobile Module',    'es_es',    'Habilite el módulo CTMobile',    32),
            ('Authentication Failed',     'Username and Password do not match',     'es_es',    'Nombre de usuario y contraseña no coinciden',     32),
            ('Mismatched module information',   'Something gone wrong, please try again later', 'es_es',    'Algo salió mal. Vuelve a intentarlo más tarde.', 32),
            ('Field does not exists',     'Please set display fields again',  'es_es',    'Vuelva a configurar los campos de visualización',  32),
            ('Module does not exists',    'Module does not exists or disabled by admin',  'es_es',    'El módulo no existe o el administrador lo deshabilitó',  32),
            ('Month cannot be empty',     'Could not get the Month - Try again later',    'es_es',    'No se pudo obtener el mes. Vuelve a intentarlo más tarde.',    32),
            ('Year cannot be empty',      'Could not get the Year - Try again later',     'es_es',    'No se pudo obtener el año. Vuelve a intentarlo más tarde.',     32),
            ('Date cannot be empty',      'Could not get the Date - Try again later',     'es_es',    'No se pudo obtener la fecha. Vuelve a intentarlo más tarde.',     32),
            ('Userid cannot be empty',    'Could not get the Userid - Try again later',   'es_es',    'No se pudo obtener el ID de usuario. Vuelve a intentarlo más tarde.',   32),
            ('End Date cannot be empty',  'Could not get the status - Try again later',   'es_es',    'No se pudo obtener el estado. Vuelve a intentarlo más tarde.',   32),
            ('Start Date cannot be empty',      'Could not get the Start Date - Try again later',     'es_es',    'No se pudo obtener la fecha de inicio. Vuelve a intentarlo más tarde.',     32),
            ('You do not configure SMS Notifier in CRM. Please configure SMS Notifier in your CRM to use this feature', 'You do not configure SMS Notifier in CRM. Please configure SMS Notifier in your CRM to use this feature',  'es_es',    'No configura SMS Notifier en CRM. Por favor configure,
            Notificador de SMS en su CRM para utilizar esta función',  32),
            ('Longitude cannot be empty', 'Could not get location-Please try again',      'es_es',    'No se pudo obtener la ubicación. Vuelve a intentarlo.',      32),
            ('Latitude cannot be empty',  'Could not get location-Please try again',      'es_es',    'No se pudo obtener la ubicación. Vuelve a intentarlo.',      32),
            ('User cannot be empty',      'Could not get the User - Try again later',     'es_es',    'No se pudo obtener el usuario. Vuelva a intentarlo más tarde.',     32),
            ('Status cannot be empty',    'Could not get the status - Try again later',   'es_es',    'No se pudo obtener el estado. Vuelve a intentarlo más tarde.',   32),
            ('Required fields not found', 'Required fields not found',  'es_es',    'Campos obligatorios no encontrados',  32),
            ('Tracking module not active',      'Tracking module not active-Please contact CRM Admin',      'es_es',    'El módulo de seguimiento no está activo: póngase en contacto con el administrador de CRM',      32),
            ('Missing mandatory input values',  'Missing mandatory input values',   'es_es',    'Faltan valores de entrada obligatorios',   32),
            ('No MailBox found. Please Create Mailbox',     'No MailBox found. Please Create Mailbox',      'es_es',    'No se encontró ningún buzón. Crear buzón',      32),
            ('Mail not sent', 'Mail not sent',  'es_es',    'Correo no enviado',  32),
            ('Mail send successfully',    'Mail send successfully',     'es_es',    'Correo enviado con éxito',     32),
            ('Email Id or username not match with your record',   'Email Id or username not match with your record',    'es_es',    'La identificación de correo electrónico o el nombre de usuario no coinciden con su registro',    32),
            ('Module not specified',      'Module not specified', 'es_es',    'Módulo no especificado', 32),
            ('No messages found',   'No messages found',    'es_es',    'No se han encontrado mensajes',    32),
            ('No Dependency Found For This Module',   'No Dependency Found For This Module',    'es_es',    'No se encontraron dependencias para este módulo',    32),
            ('Outgoing server is not Enabled',  'Outgoing server is not Enabled',   'es_es',    'El servidor saliente no está habilitado',   32),
            ('Outgoing server is Enabled',      'Outgoing server is Enabled', 'es_es',    'El servidor saliente está habilitado', 32),
            ('Email Attached Successfully',     'Email Attached Successfully',      'es_es',    'Correo electrónico adjunto con éxito',      32),
            ('Documents Attached Successfully', 'Documents Attached Successfully',  'es_es',    'Documentos adjuntos correctamente',  32),
            ('Login required - Please login again',   'Login required - Please login again',    'es_es',    'Se requiere inicio de sesión: inicie sesión nuevamente',    32),
            ('time_tracking_module_disable',    'Time tracking module is disable',  'es_es',    'El módulo de seguimiento de tiempo está desactivado',  31),
            ('route_planning_module_disable',   'Route planning module is disable', 'es_es',    'El módulo de planificación de ruta está desactivado', 31),
            ('mark_as_held',  'Are you sure you want to mark Event as Held?', 'es_es',    '¿Está seguro de que desea marcar el evento como celebrado?', 31),
            ('stop_timer_msg',      'You have already started Time tracking for another record, Do you want to stop it first ?',    'es_es',    '¿Está seguro de que desea marcar el evento como celebrado?',    31),
            ('access_denied_routeplanning',     'Access denied for route planning', 'es_es',    'Acceso denegado para planificación de rutas', 31),
            ('time_spent',    'Time Spent',     'es_es',    'Tiempo usado',     31),
            ('select_user',   'Select User',    'es_es',    'Seleccionar usuario',    30),
            ('status_cannot_be_held',     'Status cannot be held for future date start',  'es_es',    'El estado no se puede retener para una fecha de inicio futura',  30),
            ('please_select_end_date',    'Please select end date',     'es_es',    'Seleccione la fecha de finalización',     30),
            ('please_select_start_date',  'Please select start date',   'es_es',    'Seleccione la fecha de inicio',   30),
            ('tap_on_plus_icon_for_select_route',     'Tap on + icon to select record for your route.',     'es_es',    'Toque el icono + para seleccionar el registro de su ruta.',     30),
            ('please_enter_notes',  'Please enter notes',   'es_es',    'Por favor ingrese notas',   30),
            ('please_enter_title',  'Please enter title',   'es_es',    'Ingrese el título',   30),
            ('please_select_date',  'Please Select Date',   'es_es',    'Seleccione la fecha',   30),
            ('search_by_date',      'Search by Date', 'es_es',    'Buscar por fecha', 30),
            ('shortcut_not_setup_yet',    'Opps shortcut not setup yet!!! Please add shortcut by click on [icon] from record search results or view record screen.',    'es_es',    '¡El acceso directo de Opps aún no está configurado! Agregue un acceso directo haciendo clic en [icono] en los resultados de búsqueda de registros o ver la pantalla de registros.',    30),
            ('max_upload_size',     'max file Upload exceeds',    'es_es',    'La carga máxima de archivos supera',    30),
            ('unselect_all',  'UnSelect All',   'es_es',    'Deselecciona todo',   30),
            ('select_all',    'Select All',     'es_es',    'Seleccionar todo',     30),
            ('please_select_records',     'Please select records',      'es_es',    'Seleccione registros',      30),
            ('select_date',   'Select Date',    'es_es',    'Seleccione fecha',    30),
            ('quantity_in_stock_is',      'Quantity in stock is', 'es_es',    'La cantidad en stock es', 30),
            ('replies', 'Replies',  'es_es',    'Respuestas',  30),
            ('conversation_require_selection',  'Conversion requires selection of Contact or Organization', 'es_es',    'La conversión requiere la selección de Contacto u Organización', 30),
            ('please_select_product',     'Please Select Product',      'es_es',    'Seleccione el producto',      30),
            ('timer_msg',     'You can start timer for single task only at same time',    'es_es',    'Puede iniciar el temporizador para una sola tarea solo al mismo tiempo',    31),
            ('save_start_tracking', 'Save & Start Tracking',      'es_es',    'Guardar e iniciar seguimiento',      31),
            ('lbl_notes',     'Notes',    'es_es',    'Notas',    31),
            ('enter_title',   'Enter Title',    'es_es',    'Ingrese el título',    31),
            ('select_module_record',      'Select Module / Record',     'es_es',    'Seleccionar módulo / registro',     31),
            ('lbl_tomorrow',  'Tomorrow', 'es_es',    'Mañana', 30),
            ('lbl_yesterday', 'Yesterday',      'es_es',    'Ayer',      30),
            ('lbl_today',     'Today',    'es_es',    'Hoy',    30),
            ('time_tracker',  'Time Tracker',   'es_es',    'Rastreador de tiempo',   31),
            ('time_end',      'End Time', 'es_es',    'Fecha final', 5),
            ('due_date',      'End Date', 'es_es',    'Hora final', 5),
            ('time_start',    'Time Start',     'es_es',    'Hora de inicio',     5),
            ('date_start',    'Start Date',     'es_es',    'Fecha de inicio',     5),
            ('delete_widget_msg',   'Display widget again by using (+) option',     'es_es',    'Mostrar el widget nuevamente usando la opción (+)',     15),
            ('no_upcoming_activities',    'No scheduled activities      ',    'es_es',    'No hay actividades programadas',    15),
            ('check_in_first',      'Please check-in first',      'es_es',    'Regístrese primero',      30),
            ('duration',      'Duration', 'es_es',    'Duracion', 30),
            ('distance',      'Distance', 'es_es',    'Distancia', 30),
            ('proper_address_message',    'Please enter proper address in record\n',      'es_es',    'Ingrese la dirección correcta en el registro',  30),
            ('select_status', 'Select Status',  'es_es',    'Seleccionar estado',  30),
            ('route_planner', 'Route Planner',  'es_es',    'Planeador de ruta',  30),
            ('route_planning',      'Route Planning', 'es_es',    'Planificacion de la ruta', 30),
            ('add_route',     'Add Route',      'es_es',    'Agregar ruta',      30),
            ('calender_disabled',   'Calendar Module is disabled',      'es_es',    'El módulo de calendario está desactivado',      30),
            ('close_dialog',  'Close form',     'es_es',    'Cerrar formulario',     30),
            ('cancel_form_message', 'Are You sure want to close ?',     'es_es',    '¿Estás seguro de que quieres cerrar?',     30),
            ('create_route',  'Create Route',   'es_es',    'Crear ruta',   30),
            ('select_module_create_route',      'Select Module to create Route',    'es_es',    'Seleccione el módulo para crear la ruta',    30),
            ('cancel',  'Cancel',   'es_es',    'Cancelar',   30),
            ('assign_route',  'Assign Route',   'es_es',    'Asignar ruta',   30),
            ('route_for',     'Route for',      'es_es',    'Crear ruta',      30),
            ('assigned_to',   'Assigned To',    'es_es',    'Asignado a',    30),
            ('enter_route_name',    'Enter Route Name',     'es_es',    'Ingrese el nombre de la ruta',     30),
            ('list',    'List',     'es_es',    'Lista',     30),
            ('map',     'Map',      'es_es',    'Map',      30),
            ('other_modules', 'Other Modules',  'es_es',    'Otros módulos',  15),
            ('shortcut_no_record_msg',    'Opps shortcut not setup\n yet!!! Please add shortcut  by click on + icon from record\n search results or view record screen.',     'es_es',    'Acceso directo de Opps no configurado¡¡¡todavía!!! Agregue un acceso directo haciendo clic en el icono + del registro resultados de búsqueda o ver la pantalla de registro.', 25),
            ('clear',   'Clear',    'es_es',    'Limpiar',    25),
            ('open',    'Open',     'es_es',    'Abrir',     11),
            ('max_file_msg',  'Too many files selected (max:6)',  'es_es',    'Demasiados archivos seleccionados (máximo: 6)',  11),
            ('error_voicenote_record',    'Unable to recording voice while another application is recording sound.',    'es_es',    'No se puede grabar voz mientras otra aplicación está grabando sonido.',    11),
            ('msg_warning',   'Warning!', 'es_es',    '¡Advertencia!', 11),
            ('Permision_denied_contact',  'Permission denied to access your contacts',    'es_es',    'Permiso denegado para acceder a sus contactos',    15),
            ('no_widget_added',     'Please click + icon to add new widget to your dashboard.', 'es_es',    'Haga clic en el icono + para agregar un nuevo widget a su panel.', 15),
            ('no_data_available',   'Data not available, please check the selected fields',     'es_es',    'Datos no disponibles, consulte los campos seleccionados',     15),
            ('check_out_successfully',    'Check out successfully',     'es_es',    'Echa un vistazo con éxito',   11),
            ('check_in_successfully',     'Check in successfully',      'es_es',    'Registrarse con éxito',    11),
            ('check_out',     'Check out',      'es_es',    'Revisa',      11),
            ('check_in',      'Check in', 'es_es',    'Registrarse', 11),
            ('navigate',      'Navigate', 'es_es',    'Navegar', 11),
            ('save_to_phone_vcard_success',     'VCard Saved to phone successfully',      'es_es',    'VCard guardada en el teléfono correctamente',      15),
            ('download_vcard_success',    'VCard downloaded successfully',    'es_es',    'VCard descargado con éxito',    15),
            ('card_details',  'Card Details',   'es_es',    'Detalles de tarjeta',   15),
            ('add_widget',    'Add Widget',     'es_es',    'Agregar widget',     15),
            ('delete_widget', 'Are you sure to hide widget?',     'es_es',    '¿Estás seguro de ocultar el widget?',     15),
            ('already_widgets_added',     'All types of Widget & reports are already added',    'es_es',    'Todos los tipos de widgets e informes ya están agregados',    15),
            ('retry',   'Retry',    'es_es',    'reintentar',    28),
            ('retake',  'Retake',   'es_es',    'Volver a tomar',   28),
            ('Reports', 'Reports',  'es_es',    'Reportes',  15),
            ('Widgets', 'Widgets',  'es_es',    'Widgets',  15),
            ('vcard_config',  'Vcard Configuration',  'es_es',    'Configuración de Vcard',  8),
            ('save_to_phone', 'Save to phone',  'es_es',    'Guardar en el teléfono',  11),
            ('download_vcard',      'Download Vcard', 'es_es',    'Descarga Vcard', 11),
            ('share_vcard',   'Share Vcard',    'es_es',    'Compartir Vcard',    11),
            ('share_record',  'Share Record',   'es_es',    'Compartir registro',   11),
            ('permission_denied_edit',    'You don\'t have permission to edit this record.',    'es_es',    'No tienes permiso para editar este registro.',    27),
            ('permission_denied_delete',  'You don\'t have permission to delete this record.',  'es_es',    'No tienes permiso para borrar este registro.',  27),
            ('Voice_Recording_Started',   'Recording Started',    'es_es',    'Grabación iniciada',    12),
            ('Voice_Recording_Stopped',   'Recording Stopped',    'es_es',    'Grabación detenida',    12),
            ('SEARCH',  'Search',   'es_es',    'Buscar',   7),
            ('LAST',    'Last',     'es_es',    'Ultimo',     7),
            ('FIRST',   'First',    'es_es',    'Primero',    7),
            ('MONDAY',  'Monday',   'es_es',    'Lunes',   7),
            ('TUESDAY', 'Tuesday',  'es_es',    'Marte',  7),
            ('WEDNESDAY',     'Wednesday',      'es_es',    'Miercoles',      7),
            ('THURSDAY',      'Thursday', 'es_es',    'Jueves', 7),
            ('FRIDAY',  'Friday',   'es_es',    'Vierne',   7),
            ('SATURDAY',      'Saturday', 'es_es',    'Sabado', 7),
            ('SUNDAY',  'Sunday',   'es_es',    'domingo',   7),
            ('DAILY',   'Daily',    'es_es',    'Diario',    7),
            ('WEEKLY',  'Weekly',   'es_es',    'Semanal',   7),
            ('MONTHLY', 'Monthly',  'es_es',    'Mensual',  7),
            ('YEARLY',  'Yearly',   'es_es',    'Anual',   7),
            ('asset_tracking',      'Asset tracking', 'es_es',    'Seguimiento de activos', 15);",array());
        
    }

    static function it_it(){
        global $adb;
        $checkQuery = "DELETE FROM ctmobile_language_keyword WHERE keyword_lang = ?";
        $checkResult = $adb->pquery($checkQuery,array('it_it'));

        $adb->pquery("INSERT INTO `ctmobile_language_keyword` (`keyword`, `keyword_name`, `keyword_lang`, `language_keyword`, `sectionid`) VALUES
                ('network_error', 'Network connection error!', 'it_it', 'Errore di rete!', 1),
                ('connection_check', 'Could not connect to CRM, Please check your Internet connection.', 'it_it', 'Per favore controlla la tua connessione Internet.', 1),
                ('update', 'Update', 'it_it', 'Aggiornare', 1),
                ('cancel', 'Cancel', 'it_it', 'Cancella', 1),
                ('ok', 'Ok', 'it_it', 'ok', 1),
                ('more_information', 'Click here for more information.', 'it_it', 'Clicca qui per maggiori informazioni.', 1),
                ('yes', 'Yes', 'it_it', 'sì', 1),
                ('no', 'No', 'it_it', 'No', 1),
                ('click_again_exit', 'Click again to exit', 'it_it', 'Clicca di nuovo per uscire', 1),
                ('forpermission', 'You don\'t have permission to view this feature. Please subscribe for Premium version Click here to Subscribe.', 'it_it', 'Non hai il permesso di vedere questa funzione. Si prega di iscriversi per la versione Premium Clicca qui per iscriverti.', 1),
                ('clickhere', 'Click here', 'it_it', 'Clicca qui', 1),
                ('clickhere_subscribe', 'Click here to subscribe premium version', 'it_it', 'Clicca qui per iscriverti', 1),
                ('clickhere_configure', 'Click here and view how to Configure.', 'it_it', 'Clicca qui e vedi come configurare.', 1),
                ('please_wait', 'Please Wait…', 'it_it', 'Attendere prego…', 1),
                ('share__msg', 'Share file with', 'it_it', 'condividi file con', 1),
                ('dialog_camera', 'Camera', 'it_it', 'telecamera', 1),
                ('dialog_add_file_by', 'Take Photo from', 'it_it', 'Aggiungi file per', 1),
                ('add', 'Add', 'it_it', 'Inserisci', 1),
                ('mail_manager_configured', 'Mail Manager is not configured', 'it_it', 'Mail Manager non è configurato', 1),
                ('dialog_add_files_by', 'Add Files by', 'it_it', 'Aggiungi file per', 1),
                ('dialog_drive', 'Drive', 'it_it', 'Guidare', 1),
                ('dialog_drop_box', 'Drop Box', 'it_it', 'Drop Box', 1),
                ('dialog_need_signin', 'You need to Sign-in to your Drive account first.', 'it_it', 'Devi prima effettuare l\'accesso', 1),
                ('dialog_gallery', 'Gallery', 'it_it', 'Galleria', 1),
                ('delete', 'Delete', 'it_it', 'Elimina', 1),
                ('timeoutmessage', 'Oops! Request is taking more time than expected.', 'it_it', 'La richiesta richiede più tempo del previsto.', 1),
                ('gps_location_message', 'GPS is not enabled. Please turn it on to get your near by locations.', 'it_it', 'Il GPS non è abilitato. Si prega di accenderlo per ottenere il tuo vicino da posizioni.', 1),
                ('sure_want_delete', 'Are you sure want to delete ?', 'it_it', 'Sei sicuro di voler cancellare?', 1),
                ('select', 'Select', 'it_it', 'Selezionare', 1),
                ('msgforrecordaudio', 'Minimum record duration one second.', 'it_it', 'Durata minima del record un secondo.', 1),
                ('permission_storage', 'Permission denied to read your External storage', 'it_it', 'Autorizzazione negata per leggere la memoria esterna', 1),
                ('send_permission_msg', 'Send message permission denied', 'it_it', 'Permesso negato per invio messaggio', 1),
                ('choosefile', 'Choose File', 'it_it', 'Scegli il file', 1),
                ('enter', 'Enter', 'it_it', 'accedere', 1),
                ('select_an_option', 'Select an Option', 'it_it', 'Seleziona una opzione', 1),
                ('email_validation', 'Email is not valid', 'it_it', 'L\'email non è valida', 1),
                ('please_enter', 'Please Enter', 'it_it', 'Prego entra', 1),
                ('website_validation_text', 'Website URL is not valid', 'it_it', 'L\'URL del sito web non è valido', 1),
                ('selectvalue', 'Select value first', 'it_it', 'Seleziona prima il valore', 1),
                ('email', 'Email', 'it_it', 'E-mail', 1),
                ('enter_email_address', 'Enter email address', 'it_it', 'Inserisci l\'indirizzo email', 1),
                ('email_address_not_correct', 'Email address incorrect', 'it_it', 'Indirizzo email errato', 1),
                ('pls_enter_subject', 'Please Enter Subject', 'it_it', 'Per favore, inserisci l\'oggetto', 1),
                ('attachFiles', 'Attached File', 'it_it', 'File allegato', 1),
                ('from', 'From', 'it_it', 'A partire dal', 1),
                ('to', 'To', 'it_it', 'A', 1),
                ('call_permission_msg', 'Call permission denied', 'it_it', 'Permesso negato per la chiamata', 1),
                ('no_records', 'No records found', 'it_it', 'Nessun record trovato', 1),
                ('fullform', 'Create New', 'it_it', 'Modulo completo', 1),
                ('save', 'Save', 'it_it', 'Salvare', 1),
                ('total', 'Total', 'it_it', 'Totale', 1),
                ('discount', 'Discount', 'it_it', 'Sconto', 1),
                ('price', 'Price', 'it_it', 'Prezzo *', 1),
                ('quantity', 'Quantity', 'it_it', 'Quantità *', 1),
                ('select_module', 'Select Module', 'it_it', 'Seleziona il modulo', 1),
                ('item_list', 'Item List', 'it_it', 'Elenco degli elementi', 1),
                ('quickcreate', 'Quick Create', 'it_it', 'Creazione rapida', 1),
                ('overwrite_msg_part1', 'Overwrite the existing address with the selected', 'it_it', 'Sovrascrivi l\'indirizzo attuale con ', 1),
                ('once_in_every', 'Once in every', 'it_it', 'Una volta in ogni', 1),
                ('overwrite_msg_part2', 'address details?', 'it_it', 'l\'indirizzo selezionato?', 1),
                ('add_item', 'Add Item', 'it_it', 'Aggiungi elemento', 1),
                ('recordsave', 'Record saved successfully', 'it_it', 'Il Record è stato salvato con successo', 1),
                ('recordnotsave', 'Could not save record. Try again later', 'it_it', 'Record non salvato', 1),
                ('minutes', 'Minutes', 'it_it', 'Minuti', 1),
                ('hours', 'Hours', 'it_it', 'Hours', 1),
                ('days', 'Days', 'it_it', 'giorni', 1),
                ('on', 'On', 'it_it', 'Sopra', 1),
                ('day_of_the_month', 'day of the month', 'it_it', 'giorno del mese', 1),
                ('list_price', 'List Price', 'it_it', 'Listino prezzi *', 1),
                ('add_record', 'Add Record', 'it_it', 'Aggiungi record', 1),
                ('add_product', 'Add Product', 'it_it', 'Aggiungi prodotto', 1),
                ('add_service', 'Add Service', 'it_it', 'Aggiungi servizio', 1),
                ('discountin', 'Discount in %', 'it_it', 'Sconto in%', 1),
                ('unitprice', 'Unit price', 'it_it', 'Unit price', 1),
                ('netprice', 'Net price', 'it_it', 'Prezzo netto *', 1),
                ('comments', 'Comments', 'it_it', 'Commenti', 1),
                ('add_close', 'Add & Close', 'it_it', 'Aggiungi e Chiudi', 1),
                ('fetching_rout_message', 'Fetching route, Please wait…', 'it_it', 'Recupero del percorso, attendere prego …', 1),
                ('setting', 'Settings', 'it_it', 'impostazioni', 1),
                ('utc', 'UTC', 'it_it', 'UTC', 1),
                ('in', 'In', 'it_it', 'Nel', 1),
                ('days_ago', 'days ago', 'it_it', 'giorni fa', 1),
                ('mins_ago', 'Minutes ago', 'it_it', 'minuti fa', 1),
                ('justnow', 'Just now', 'it_it', 'Proprio adesso', 1),
                ('hours_ago', 'hours ago', 'it_it', 'ore fa', 1),
                ('in_1_day', 'In 1 day', 'it_it', 'In 1 giorno', 1),
                ('scanqrcode', 'Asset / Card scanner', 'it_it', 'Scanner Asset / Card', 1),
                ('call_log', 'Call Log', 'it_it', 'Registro chiamate', 1),
                ('voice_message', 'Hi', 'it_it', 'Ciao', 1),
                ('voice_message1', 'What can I search for you in', 'it_it', 'Cosa posso cercare per te', 1),
                ('live_tracking', 'Live Tracking', 'it_it', 'Monitoraggio dal vivo', 1),
                ('mailmanager', 'Mail Manager', 'it_it', 'Mail Manager', 1),
                ('my_location', 'My location', 'it_it', 'La mia posizione', 1),
                ('created_on', 'Created On', 'it_it', 'Creato', 1),
                ('modified_on', 'Modified On', 'it_it', 'Modificato', 1),
                ('enter_comments', 'Enter Comments', 'it_it', 'Inserisci commenti', 1),
                ('viewmore', 'View More', 'it_it', 'Visualizza altro', 1),
                ('viewless', 'View Less', 'it_it', 'Visualizza meno', 1),
                ('gotofullform', 'Go to Full Form', 'it_it', 'Vai a modulo completo', 1),
                ('post', 'Post', 'it_it', 'Inviare', 1),
                ('url', 'URL', 'it_it', 'URL', 1),
                ('dialog_title_text_back_color', 'Select a Text Background Color', 'it_it', 'Select a Text Background Color', 1),
                ('event_or_task', 'Add event/task', 'it_it', 'Aggiungi evento / attività', 1),
                ('shortcut', 'Shortcuts', 'it_it', 'Tasti di scelta rapida', 1),
                ('select_field', 'Select Field', 'it_it', 'Seleziona campo', 1),
                ('share', 'Share', 'it_it', 'Condividere', 1),
                ('title_insert_link', 'Insert Link', 'it_it', 'Insert Link', 1),
                ('addyourcommentshere', 'Add your comments here', 'it_it', 'Aggiungi i tuoi commenti qui', 1),
                ('nocomment', 'No Comments', 'it_it', 'Non ci sono commenti', 1),
                ('leads', 'Leads', 'it_it', 'Conduce', 1),
                ('true_val', 'true', 'it_it', 'vero', 1),
                ('noresult', 'No Result', 'it_it', 'No Result', 1),
                ('version', 'Version', 'it_it', 'Versione', 1),
                ('convert_lead', 'Convert Lead', 'it_it', 'Converti Lead', 1),
                ('app_name', 'CRMTiger', 'it_it', 'CRMTiger', 1),
                ('enter_url', 'Please Enter url', 'it_it', 'Si prega di inserire l\'url', 1),
                ('help', 'Help', 'it_it', 'Aiuto', 1),
                ('contact_us', 'Contact Us', 'it_it', 'Contattaci', 1),
                ('updates', 'Updates', 'it_it', 'Updates', 1),
                ('logout', 'LogOut', 'it_it', 'Disconnettersi', 1),
                ('busnies_cardscanner', 'Business Card Scanner', 'it_it', 'Scanner di BdV', 1),
                ('sure_want_logout', 'Are you sure want to logout ?', 'it_it', 'Sei sicuro di voler uscire?', 1),
                ('logout_message', 'Logout successfully', 'it_it', 'Logout successfully', 1),
                ('all', 'All', 'it_it', 'Tutti', 1),
                ('add_event', 'Add event', 'it_it', 'Aggiungi evento', 1),
                ('add_task', 'Add Task', 'it_it', 'Aggiungi attività', 1),
                ('next', 'Next', 'it_it', 'Prossimo', 1),
                ('terms_conditions', 'Terms and Conditions', 'it_it', 'Terms and Conditions', 1),
                ('login', 'Login', 'it_it', 'Accesso', 2),
                ('privacy_policay', 'By logging in, you agree to our Terms and Conditions & Privacy Policy', 'it_it', 'Effettuando il login, accetti i nostri Termini e condizioni nonché la politica sulla riservatezza', 2),
                ('copyright', 'Copyright © 2019 CRMTiger Version', 'it_it', 'Copyright \u00A9 2019 CRMTiger \n Version', 2),
                ('enter_username', 'Please enter username', 'it_it', 'Si prega di inserire il nome utente', 2),
                ('enter_password', 'Please enter password', 'it_it', 'Per favore, inserisci la password', 2),
                ('remanberme', 'Remember Me', 'it_it', 'Ricordati di me', 2),
                ('forgot_password', 'Forgot password?', 'it_it', 'Hai dimenticato la password?', 2),
                ('privacy_policay1', 'Privacy Policy', 'it_it', 'politica sulla riservatezza', 2),
                ('contactsupportmsg', 'Something went wrong. \\n please Click here to contact support.', 'it_it', 'Qualcosa è andato storto.per favore Clicca qui per contattare il supporto', 2),
                ('enter_username_password', 'Entered Username or Password is wrong', 'it_it', 'Il nome utente o la password inseriti sono errati', 2),
                ('server_issue_occured', 'Server issues occurred', 'it_it', 'Problema con il server', 2),
                ('password', 'Password', 'it_it', 'Password', 3),
                ('user_name', 'Username', 'it_it', 'Nome utente', 3),
                ('reset_pwd', 'Reset Password', 'it_it', 'Resetta la password', 3),
                ('forgot_password_title', 'Forgot password', 'it_it', 'Hai dimenticato la password', 3),
                ('enter_user_name', 'Enter user name', 'it_it', 'Inserire username', 3),
                ('cc', 'Cc', 'it_it', 'cc', 4),
                ('body', 'Body', 'it_it', 'Corpo', 4),
                ('bcc', 'BCC', 'it_it', 'CCN', 4),
                ('dialog_title_text_color', 'Select a Text Color', 'it_it', 'Seleziona il colore del testo', 4),
                ('date', 'Date', 'it_it', 'Data', 4),
                ('subject', 'Subject', 'it_it', 'Oggetto', 4),
                ('composeMail', 'Compose Mail', 'it_it', 'Scrivi una mail', 4),
                ('send', 'Send', 'it_it', 'Inviare', 4),
                ('select_message', 'Select message', 'it_it', 'Seleziona messaggio', 4),
                ('title_insert_table', 'Insert Table', 'it_it', 'Inserisci tabella', 4),
                ('log_file_sms', 'I agree to Share API Log to Technical team for further troubleshooting', 'it_it', 'Accetto di condividere il log dell\'API al team tecnico per una ulteriore analisi e risoluzione dei problemi', 5),
                ('edit_record', 'Edit Records', 'it_it', 'Modifica record', 5),
                ('select_time', 'Select Time', 'it_it', 'Seleziona ora', 5),
                ('edit_item', 'Edit Item', 'it_it', 'Edit Item', 5),
                ('items_total', 'Items Total', 'it_it', 'Items Total', 5),
                ('number_less_then_31', 'Number should be less than 31', 'it_it', 'Number should be less than 31', 5),
                ('users', 'Users', 'it_it', 'utenti', 5),
                ('groups', 'Groups', 'it_it', 'gruppi', 5),
                ('txt_note_for_file', 'Note : Existing attachments(images/files) will be replaced', 'it_it', 'Nota: gli allegati esistenti (immagini / file) saranno sostituiti', 5),
                ('greaterdatetime', 'End DateTime should be greater than Start DateTime', 'it_it', 'End DateTime should be greater than Start DateTime', 5),
                ('until', 'Until', 'it_it', 'Fino a', 5),
                ('organizations', 'Organizations', 'it_it', 'organizzazioni', 6),
                ('contacts', 'Contacts', 'it_it', 'Contatti', 6),
                ('opportunity', 'Opportunity', 'it_it', 'Opportunità', 6),
                ('lbl_sun', 'SUN', 'it_it', 'DOM', 7),
                ('lbl_mon', 'MON', 'it_it', 'LUN', 7),
                ('lbl_tue', 'TUE', 'it_it', 'MAR', 7),
                ('lbl_wed', 'WED', 'it_it', 'MER', 7),
                ('lbl_thu', 'THU', 'it_it', 'GIO', 7),
                ('lbl_fri', 'FRI', 'it_it', 'VEN', 7),
                ('lbl_sat', 'SAT', 'it_it', 'SAB', 7),
                ('lbl_1', '1', 'it_it', '1', 7),
                ('lbl_2', '2', 'it_it', '2', 7),
                ('lbl_3', '3', 'it_it', '3', 7),
                ('lbl_4', '4', 'it_it', '4', 7),
                ('lbl_5', '5', 'it_it', '5', 7),
                ('lbl_6', '6', 'it_it', '6', 7),
                ('lbl_7', '7', 'it_it', '7', 7),
                ('lbl_8', '8', 'it_it', '8', 7),
                ('lbl_9', '9', 'it_it', '9', 7),
                ('lbl_10', '10', 'it_it', '10', 7),
                ('lbl_11', '11', 'it_it', '11', 7),
                ('lbl_12', '12', 'it_it', '12', 7),
                ('lbl_13', '13', 'it_it', '13', 7),
                ('lbl_14', '14', 'it_it', '14', 7),
                ('lbl_15', '15', 'it_it', '15', 7),
                ('lbl_16', '16', 'it_it', '16', 7),
                ('lbl_17', '17', 'it_it', '17', 7),
                ('lbl_18', '18', 'it_it', '18', 7),
                ('lbl_19', '19', 'it_it', '19', 7),
                ('lbl_20', '20', 'it_it', '20', 7),
                ('lbl_21', '21', 'it_it', '21', 7),
                ('lbl_22', '22', 'it_it', '22', 7),
                ('lbl_23', '23', 'it_it', '23', 7),
                ('lbl_24', '24', 'it_it', '24', 7),
                ('lbl_25', '25', 'it_it', '25', 7),
                ('lbl_26', '26', 'it_it', '26', 7),
                ('lbl_27', '27', 'it_it', '27', 7),
                ('lbl_28', '28', 'it_it', '28', 7),
                ('lbl_29', '29', 'it_it', '29', 7),
                ('lbl_30', '30', 'it_it', '30', 7),
                ('lbl_31', '31', 'it_it', '31', 7),
                ('lbl_32', '32', 'it_it', '32', 7),
                ('lbl_33', '33', 'it_it', '33', 7),
                ('lbl_34', '34', 'it_it', '34', 7),
                ('lbl_35', '35', 'it_it', '35', 7),
                ('lbl_36', '36', 'it_it', '36', 7),
                ('lbl_37', '37', 'it_it', '37', 7),
                ('lbl_38', '38', 'it_it', '38', 7),
                ('lbl_39', '39', 'it_it', '39', 7),
                ('lbl_40', '40', 'it_it', '40', 7),
                ('lbl_41', '41', 'it_it', '41', 7),
                ('lbl_42', '42', 'it_it', '42', 7),
                ('current_date', 'current date', 'it_it', 'data odierna', 7),
                ('event', 'Events', 'it_it', 'eventi', 7),
                ('calendar', 'Calendar', 'it_it', 'Calendario', 7),
                ('latest_version', 'Latest Version :', 'it_it', 'Ultima versione :', 8),
                ('expire_on', 'Expire On :', 'it_it', 'Scadenza:', 8),
                ('ctmobile_ext_version', 'CTMobile Ext. Version :', 'it_it', 'CTMobile Ext. Versione:', 8),
                ('you_have_latest_version', 'You already have latest version', 'it_it', 'Hai aggiornato la versione', 8),
                ('upgreaded', 'Upgrade', 'it_it', 'aggiornamento', 8),
                ('downgrade', 'Downgrade', 'it_it', 'retrocedere', 8),
                ('dialog_recent_event_info', 'You can set from here how many number of records you want to show on Home screen for Recent Event.', 'it_it', 'Puoi impostare da qui quanti numeri di record vuoi mostrare sulla schermata Home per Eventi recenti.', 8),
                ('dialog_feedback_info', 'You can submit your feedback with description , our team will check your feedback and get back to you.', 'it_it', 'Puoi inviare il tuo feedback con la descrizione, il nostro team controllerà il tuo feedback e ti risponderà.', 8),
                ('dialog_log_info', 'Log functionality is used for customer support / help , If you are facing any issues in app or any module or functionality is not working proper then you can enable share log with our development team.', 'it_it', 'La funzionalità di registro viene utilizzata per l\'assistenza / aiuto clienti, se si riscontrano problemi nell\'app o in qualsiasi modulo o se la funzionalità non funziona correttamente, è possibile abilitare il registro di condivisione con il nostro team di sviluppo.', 8),
                ('info', 'Info', 'it_it', 'Informazioni', 8),
                ('recent_history', 'Recent History', 'it_it', 'Storia recente', 8),
                ('recent_feedback', 'Feedback', 'it_it', 'Risposta', 8),
                ('recent_log', 'Log', 'it_it', 'Log', 8),
                ('crmtiger_app_version', 'CRMTiger App Version :', 'it_it', 'Versione dell\'app CRMTiger:', 8),
                ('historylimit', 'Recent History Limit', 'it_it', 'Limite della cronologia recente', 8),
                ('radious_in_miles', 'Radius in miles', 'it_it', 'Raggio in miglia', 8),
                ('recentlimit', 'Recent Event Limit', 'it_it', 'Limite eventi recenti', 8),
                ('upcoming_events', 'Upcoming Events', 'it_it', 'Prossimi eventi', 8),
                ('rate_our_app', 'Rate Our App!', 'it_it', 'Vota la nostra app!', 8),
                ('feedback', 'Submit Feedback', 'it_it', 'Invia feedback', 8),
                ('sendfeedback', 'Feedback Send', 'it_it', 'Feedback Send', 8),
                ('emaillimit', 'Email limit', 'it_it', 'Limite email', 8),
                ('log', 'Log', 'it_it', 'Log', 8),
                ('logclear', 'Log cleared successfully.', 'it_it', 'Cancellazione eseguita', 8),
                ('dialog_recent_history_info', 'You can set from here how many number of records you want to show on Home screen for Recent History.', 'it_it', 'È possibile impostare da qui quanti numeri di record si desidera mostrare nella schermata Home per la cronologia recente.', 8),
                ('proceed_to_upgrade1', 'Proceed to', 'it_it', 'Procedi a', 8),
                ('upgradation_message', 'will required logout and login again later.', 'it_it', 'Sarà richiesto un logout e un login in seguito.', 8),
                ('proceed_to_upgrade', 'Proceed to Upgrade', 'it_it', 'Procedi con l\'upgrade', 8),
                ('module_setting', 'Module Setting', 'it_it', 'Impostazione del modulo', 9),
                ('sortbyfield', 'Sort by field', 'it_it', 'Ordina per campo', 9),
                ('ascending', 'Ascending  A to Z', 'it_it', 'Ascendente dalla A alla Z.', 9),
                ('descending', 'Descending  Z to A', 'it_it', 'Decrescente dalla Z alla A', 9),
                ('first_field', 'First Field', 'it_it', 'Primo campo', 9),
                ('second_field', 'Second Field', 'it_it', 'Secondo campo', 9),
                ('third_field', 'Third Field', 'it_it', 'Terzo campo', 9),
                ('sure_want_restore', 'Are you sure you want to reset to default settings?', 'it_it', 'Sei sicuro di voler ripristinare il valore predefinito', 9),
                ('orderlist', 'List Order', 'it_it', 'Ordine di lista', 9),
                ('module_reset', 'Restore to Default', 'it_it', 'Ripristina al valore predefinito', 9),
                ('display_fields', 'Display Fields', 'it_it', 'Visualizza campi', 9),
                ('discount_lessthen_100', 'Discount % should be less than 100', 'it_it', 'La percentuale di sconto deve essere inferiore a 100', 10),
                ('select_item', 'Select Item', 'it_it', 'Scegliere elemento', 10),
                ('item_comment', 'Item Comment', 'it_it', 'Commento elemento', 10),
                ('record_name', 'Record Name is :', 'it_it', 'Il nome del record è: -', 11),
                ('go_back', 'Go Back', 'it_it', 'Go Back', 11),
                ('please_enter_shortcut_name', 'Please Enter Shortcut Name', 'it_it', 'Si prega di inserire il nome del collegamento', 11),
                ('number_not_found', 'Contact Number not found', 'it_it', 'Numero di contatto non trovato', 11),
                ('mail_not_found', 'Mail Address not found', 'it_it', 'Indirizzo di posta non trovato', 11),
                ('create_shortcut', 'Create Shortcut', 'it_it', 'Creare una scorciatoia', 11),
                ('contact_summary', 'Summary', 'it_it', 'Summary', 11),
                ('activites', 'Activities', 'it_it', 'attività', 11),
                ('details', 'Details', 'it_it', 'Details', 11),
                ('related', 'Related', 'it_it', 'Related', 11),
                ('share_link', 'Share record with', 'it_it', 'Condividi record con', 11),
                ('edit', 'Edit', 'it_it', 'Modifica', 11),
                ('duplicate', 'Duplicate', 'it_it', 'Duplica', 11),
                ('whatsapp', 'Whatsapp', 'it_it', 'Whatsapp', 11),
                ('call', 'Call', 'it_it', 'Chiama', 11),
                ('choose_contact_for_call', 'Choose Contact for Call', 'it_it', 'Scegli contatto per Chiamata', 11),
                ('choose_contact_for_sms', 'Choose Contact for SMS', 'it_it', 'Scegli contatto per SMS', 11),
                ('choose_contact_for_whatsapp', 'Choose Contact for WhatsApp', 'it_it', 'Scegli contatto per WhatsApp', 11),
                ('chosse_contact_for_email', 'Choose Email', 'it_it', 'Scegli Email', 11),
                ('attach_file', 'Attach Files', 'it_it', 'Allega File', 11),
                ('close', 'Close', 'it_it', 'Chiudi', 11),
                ('status', 'Status', 'it_it', 'Stato', 11),
                ('stop', 'Stop', 'it_it', 'Blocca', 11),
                ('zero', '0', 'it_it', '0', 11),
                ('record', 'Record', 'it_it', 'Registra', 11),
                ('voice_note', 'Voice Note', 'it_it', 'Nota vocale', 11),
                ('tickets', 'Tickets', 'it_it', 'Biglietti', 12),
                ('check_out', 'Check Out', 'it_it', 'Registra Uscita', 12),
                ('check_in', 'Check In', 'it_it', 'Registra Entrata', 12),
                ('select_any', 'Select any', 'it_it', 'Select any', 12),
                ('fulldetails', 'Show Full Details', 'it_it', 'Mostra tutti i dettagli', 12),
                ('checkin', 'Check-in', 'it_it', 'Registrare', 12),
                ('navigate', 'Navigate', 'it_it', 'Navigare', 12),
                ('product', 'Products', 'it_it', 'Prodotti', 12),
                ('projectMilestone', 'Project Milestone', 'it_it', 'Milestone', 12),
                ('projecttask', 'Project Tasks', 'it_it', 'Task', 12),
                ('nearby', 'NearBy', 'it_it', 'Nelle vicinanze', 13),
                ('document', 'Document', 'it_it', 'Documento', 14),
                ('reply', 'Reply', 'it_it', 'rispondere', 14),
                ('reply_all', 'Reply All', 'it_it', 'Rispondi a tutti', 14),
                ('forward', 'Forward', 'it_it', 'Inoltrare', 14),
                ('action', 'Action', 'it_it', 'Azione', 14),
                ('select_first', 'Select First', 'it_it', 'Seleziona Prima', 14),
                ('commentaddsuccessful', 'Comment added successfull', 'it_it', 'Commento aggiungere con successo', 14),
                ('move_to', 'Move to', 'it_it', 'Sposta a', 14),
                ('attach', 'Attach', 'it_it', 'allegare', 14),
                ('addcoment', 'Add Comment', 'it_it', 'Aggiungi un commento', 14),
                ('adddocument', 'Add Document', 'it_it', 'Aggiungi documento', 14),
                ('home', 'Home', 'it_it', 'Casa', 15),
                ('checkout', 'Check-out', 'it_it', 'Registra Uscita', 15),
                ('message_search', 'Search by name', 'it_it', 'Ricerca per nome', 15),
                ('start_shift', 'Start shift', 'it_it', 'Inizia il turno', 15),
                ('end_shift', 'End shift', 'it_it', 'Fine turno', 15),
                ('today_meeting', 'Meetings', 'it_it', 'incontri', 15),
                ('shift_time_track', 'Shift Time Track', 'it_it', 'Traccia dei turni', 15),
                ('logout_msg', 'You have to login again , click', 'it_it', 'Devi fare nuovamente login, clicca', 15),
                ('logout_msg1', 'to continue.', 'it_it', 'per continuare', 15),
                ('permission_denied', 'You don\'t have permission to create', 'it_it', 'Non hai il permesso di creare', 15),
                ('history', 'Activity stream', 'it_it', 'Flusso di attività', 15),
                ('search_value', 'Search value :', 'it_it', 'Cerca il valore :', 15),
                ('feed_back_msg', 'Please enter feedback message', 'it_it', 'Si prega di inserire un messaggio di feedback', 16),
                ('feed_back_hint_msg', 'Enter feedback message', 'it_it', 'Inserisci un messaggio di feedback', 16),
                ('submit', 'Submit', 'it_it', 'Sottoscrivi', 16),
                ('check_app_not_installed', 'Application is not currently installed.', 'it_it', 'L\'applicazione non è attualmente installata.', 17),
                ('send_sms_fail_message', 'SMS failed, please try again later!', 'it_it', 'SMS fallito, per favore riprova più tardi!', 17),
                ('documentaddsuccessfully', 'Document Attach successfully', 'it_it', 'Documento Allega con successo', 17),
                ('send_message', 'Send message', 'it_it', 'Invia messaggio', 17),
                ('sms_to', 'smsto:', 'it_it', 'smsto:', 17),
                ('add_list_message', 'Add List', 'it_it', 'Aggiungi lista', 18),
                ('mylist', 'My List', 'it_it', 'La mia lista', 18),
                ('filtername', 'Filter Name', 'it_it', 'Nome filtro', 18),
                ('selectlist', 'Select a List', 'it_it', 'Seleziona un elenco *', 18),
                ('assingedto', 'Assigned To', 'it_it', 'Assegnato a *', 18),
                ('selectmodule', 'Select a module', 'it_it', 'Seleziona un modulo', 18),
                ('add_list', 'Add Filter', 'it_it', 'Aggiungi filtro', 18),
                ('recent_event', 'Recent Event', 'it_it', 'Evento recente', 19),
                ('recent_hostory', 'Recent History', 'it_it', 'Storia recente', 19),
                ('module_specific_settings', 'Module-Specific Settings', 'it_it', 'Impostazioni specifiche del modulo', 19),
                ('talk_to_us', 'Talk to us', 'it_it', 'Parla con noi', 19),
                ('report_a_bug', 'Report A Bug', 'it_it', 'Segnalare un bug', 19),
                ('faq', 'FAQ', 'it_it', 'FAQ', 19),
                ('selectmodules', 'Select Module', 'it_it', 'Seleziona il modulo', 19),
                ('myplan', 'My Plan', 'it_it', 'Il mio piano', 19),
                ('message', 'Message', 'it_it', 'Messaggio', 20),
                ('message_validation', 'Please enter Message', 'it_it', 'Si prega di inserire il messaggio', 20),
                ('contact_select', 'Please Select contact', 'it_it', 'Si prega di selezionare un contatto', 20),
                ('global_search', 'Global Search', 'it_it', 'Ricerca globale', 21),
                ('records', 'Records', 'it_it', 'Registrazioni', 21),
                ('dont_show_again', 'Don\'t Show Again', 'it_it', 'Non mostrare di nuovo', 22),
                ('skip', 'Skip', 'it_it', 'Salta', 22),
                ('file_downloading', 'File Downloading', 'it_it', 'Download di file', 23),
                ('add_screenshots_optional', 'Add screenshots (optional)', 'it_it', 'Aggiungi screenshot (opzionale)', 24),
                ('describe_your_problem', 'Describe your problem', 'it_it', 'Descrivi il tuo problema', 24),
                ('default_filter_shortcut', 'Default Filter Shortcut', 'it_it', 'Scorciatoia per filtro di default', 25),
                ('record_shortcut', 'Record Shortcut', 'it_it', 'Scorciatoia per registrazione', 25),
                ('enter_url', 'Please Enter url', 'it_it', 'Per favore inserisci url', 26),
                ('new_version_is_avaiable', 'You need to update the app to continue using Please update to continue Older versions will no longer work from today', 'it_it', 'Devi aggiornare l\'app per continuare Per favore aggiorna per continuare Le vecchie versioni non funzioneranno più da oggi', 26),
                ('search_by', 'Search by', 'it_it', 'Cercato da', 27),
                ('selected_filter', 'Selected filter :', 'it_it', 'Filtro selezionato: -', 27),
                ('selected_field', 'Selected field :', 'it_it', 'Campo selezionato: -', 27),
                ('choose', 'Choose', 'it_it', 'Scegli', 28),
                ('qr_cardscanner', 'QR Code Scanner', 'it_it', 'Scanner di QR Code', 28),
                ('error_message_for_scan', 'Could not read the card Try again later.', 'it_it', 'Impossibile leggere il biglietto Prova più tardi.', 28),
                ('press_start_scan', 'Press to Start Scan', 'it_it', 'Premi per avviare la scansione', 28),
                ('line_item_quntity_validation_msg', 'Value should be greater than zero', 'it_it', 'Il valore deve essere maggiore di zero', 29),
                ('percentage_msg', 'Percentage should be less than 100', 'it_it', 'La percentuale deve essere inferiore a 100', 29),
                ('MSG_NO_DATA', 'No data found!', 'it_it', 'Nessun dato trovato!', 29),
                ('MSG_SOMETHING_WRONG', 'Something went wrong!', 'it_it', 'Qualcosa è andato storto!', 29),
                ('MSG_COMING_SOON', 'Coming Soon!', 'it_it', 'Coming Soon!', 29),
                ('MSG_UPLOAD_PROFILE_IMAGE', 'Please upload profile image.', 'it_it', 'Per favore carica la foto profilo.', 29),
                ('ALERT_TITLE_LOCATION_ACCESS', 'Location Access', 'it_it', 'Accesso alla posizione', 29),
                ('ALERT_MSG_LOCATION_ACCESS', 'Requires your location to show nearby events.', 'it_it', 'La tua posizione è richiesta per mostrare eventi nelle vicinanze.', 29),
                ('ALERT_BTN_ALLOW', 'ALLOW', 'it_it', 'PERMETTI', 29),
                ('ALERT_BTN_DENY', 'DENY', 'it_it', 'NEGA', 29),
                ('ALERT_MSG_LOCATION_SETTING', 'Not able to fetch your current location. Please check your location settings.', 'it_it', 'Non è stato possibile individuare la tua posizione corrente. Per favore controlla le impostazioni di localizzazione.', 29),
                ('DELETE_RECORD', 'Delete Record', 'it_it', 'Cancella Record', 29),
                ('ALERT_MSG_DELETE_SHORTCUT', 'Are you sure want to delete this shortcut?', 'it_it', 'Sei sicuro di voler cancellare questa scorciatoia?', 29),
                ('DELETE_SHORTCUT', 'Delete Shortcut', 'it_it', 'Cancella Scorciatoia', 29),
                ('LBL_TERMS', 'By logging in, you agree to our Terms and', 'it_it', 'per continuare devi accettare i nostri Termini', 29),
                ('LBL_CONDITIONS', 'Conditions &', 'it_it', 'Condizioni &', 29),
                ('ALERT_TITLE', 'Alert', 'it_it', 'Attenzione', 29),
                ('ALERT_BTN_SUBSCRIBE', 'Subscribe', 'it_it', 'Sottoscrivi', 29),
                ('MSG_SELECT_MODULE', 'Please select any Module', 'it_it', 'Prego seleziona un modulo', 29),
                ('MSG_SELECT_LIST', 'Please select any List', 'it_it', 'Prego seleziona una lista', 29),
                ('ALERT_MSG_DONT_HAVE_CAMERA', 'You don\'t have camera', 'it_it', 'Non hai una Webcam', 29),
                ('ALERT_MSG_GALLARY_PERMISSION', 'You don\'t have permission to access gallery.', 'it_it', 'Non hai il permesso di accedere alla galleria.', 29),
                ('ALERT_MSG_CAMERA_PERMISSION', 'You don\'t have permission to access camera. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Camera on', 'it_it', 'Non hai il permesso di accedere alla fotocamera. Vai a Impostazioni -> Scorri in fondo e seleziona CRMTiger App -> Attiva fotocamera', 29),
                ('ALERT_MSG_SPEECH_PERMISSION', 'You don\'t have permission to access Speech Recognition. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Speech Recognition on', 'it_it', 'Non hai il permesso di accedere al riconoscimento vocale. Vai a Impostazioni -> Scorri in fondo e seleziona CRMTiger App -> Attiva riconoscimento vocale', 29),
                ('BTN_DONE', 'Done', 'it_it', 'Commento', 29),
                ('COMMENT', 'Comment', 'it_it', 'Comment', 29),
                ('FULL_FORM', 'Full Form', 'it_it', 'Form completo', 29),
                ('QUICK_CREATE', 'Create', 'it_it', 'Crea', 29),
                ('LBL_SELECT_FIELDS', 'Select Fields', 'it_it', 'Seleziona Campi', 29),
                ('LBL_SELECT_FIELDS', 'Select Fields', 'it_it', 'Seleziona Campi', 29),
                ('LBL_SELECT_FIRST_FIELDS', 'Select First Field', 'it_it', 'Selezione Primo Campo', 29),
                ('LBL_SELECT_SECOND_FIELDS', 'Select Second Field', 'it_it', 'Selezione Secondo Campo', 29),
                ('LBL_SELECT_THIRD_FIELDS', 'Select Third Field', 'it_it', 'Selezione Terzo Campo', 29),
                ('LBL_SORT_BY_FIELD', 'Select Sort By Field', 'it_it', 'Selezione Campo Visualizza per', 29),
                ('BTN_RESET_TO_DEFAULT', 'Reset to Default', 'it_it', 'Reimposta a valori di default', 29),
                ('MSG_SELECT_SORT_BY_FIELD', 'Select Sort by field', 'it_it', 'Selezione Campo Visualizza per', 29),
                ('kStrClearBtnTitle', 'Clear', 'it_it', 'Svuota', 29),
                ('kStrShowMoreBtnTitle', 'Show More', 'it_it', 'Mostra di più', 29),
                ('kStrAddActivitiesBtnTitle', 'Add Activities', 'it_it', 'Aggiungi Attività', 29),
                ('kStrAddCommentPlaceHolder', 'Add your comments here', 'it_it', 'Aggiungi qui i tuoi commenti', 29),
                ('MSG_ENTER_TO_EMAIL', 'Please enter to field.', 'it_it', 'Per favore inserisci nel campo.', 29),
                ('WARNING_FILE', 'File can\'t open.', 'it_it', 'Il file non si apre', 29),
                ('MSG_FILE_SAVED', 'File saved.', 'it_it', 'File salvato', 29),
                ('WARNING_DOWNLOAD_FAIL', 'Download fail!, please try after sometime.', 'it_it', 'Download fallito! Per favore riprova più tardi.', 29),
                ('LBL_SHORTCUT', 'Shortcut', 'it_it', 'Scorciatoia', 29),
                ('TXT_MESSAGE_PLACEHOLDER', 'Type Message', 'it_it', 'Scrivi Messaggio', 29),
                ('ALERT_INSTALL_WHATSAPP', 'Install Whatsapp', 'it_it', 'Installa Whatsapp', 29),
                ('MSG_NO_MAIL_BOX', 'No MailBox found. Please Create Mailbox', 'it_it', 'Nessuna casella email trovata. Per favore Crea Casella', 29),
                ('LBL_WROTE', 'Wrote', 'it_it', 'Scritto', 29),
                ('MSG_MAIL_SEND', 'Mail sent', 'it_it', 'Mail inviata', 29),
                ('log_file_not_found', 'API Log file not found.', 'it_it', 'File log API non trovato.', 29),
                ('unknown_error', 'An unknown error occurred, try again', 'it_it', 'Errore sconosciuto, riprova', 29),
                ('CTMTigerAppVersion', 'CRMTiger App Version', 'it_it', 'Versione App CRMTiger', 29),
                ('CTMMobileUpdateMsg', 'CTMobile Ext. Version Update Successfully', 'it_it', 'Estensione CTMobile aggiornata con successo', 29),
                ('dialog_Premium_downgrade', 'Downgrade will required logout and login again later', 'it_it', 'Il downgrade richiederà un logout e successivo login', 29),
                ('dialog_Premium', 'Upgrade will required logout and login again later', 'it_it', 'L\'upgrade richiederà un logout e successivo login', 29),
                ('Overwrite', 'Overwrite', 'it_it', 'Sovrascrivi', 29),
                ('MSGAddressOverwrite1', 'Overwrite the existing address with the selected', 'it_it', 'Sovrascrivi l\'indirizzo attuale con', 29),
                ('MSGAddressOverwrite2', 'address details?', 'it_it', 'i dati selezionati?', 29),
                ('UPGRADE_PLAN', 'Upgrade Plan', 'it_it', 'Upgrade del Piano', 29),
                ('DOWNGRADE_PLAN', 'Downgrade Plan', 'it_it', 'Downgrade del Piano', 29),
                ('UPGRADE_EXTENSION', 'Upgrade Extension', 'it_it', 'Upgrade dell\'estensione', 29),
                ('UPGRADE_APP', 'Upgrade App', 'it_it', 'Upgrade dell\'app', 29),
                ('SELECT_OPTION', 'Select Option', 'it_it', 'Seleziona Opzione', 29),
                ('PLEASE_SELECT', 'Please select', 'it_it', 'Per favore seleziona', 29),
                ('MSG_ACCESS_DENIED', 'You don\'t have permission for this module.', 'it_it', 'Non hai i permessi per questo modulo.', 29),
                ('MSG_SELECT_RECCURING_MONTH_DAY', 'Please select reccuring day of month.', 'it_it', 'Prego seleziona il giorno del mese periodico', 29),
                ('MSG_SELECT_RECCURING_WEEK_DAY', 'Please select reccuring day of week.', 'it_it', 'Prego seleziona il giorno della settimana periodico', 29),
                ('MSG_SELECT_RECCURING_DAYS', 'Please select reccuring days.', 'it_it', 'Prego seleziona i giorni periodici', 29),
                ('Please select reccuring days.', 'Please select reccuring days.', 'it_it', 'Prego seleziona i giorni periodici', 29),
                ('MSG_SELECT_RECCURING_END_DATE', 'Please select reccuring end date.', 'it_it', 'Prego seleziona la data di fine periodica', 29),
                ('MSG_SELECT_RECCURING_TYPE', 'Please select reccuring type.', 'it_it', 'Prego seleziona il tipo di periodicità', 29),
                ('FREQ_TIME', 'Times', 'it_it', 'Volte', 29),
                ('REPEAT_YEARLY', 'Repeat Yearly', 'it_it', 'Ripeti annualmente', 29),
                ('REPEAT_MONTHLY', 'Repeat Monthly', 'it_it', 'Ripeti mensilmente', 29),
                ('REPEAT_WEEKLY', 'Repeat Weekly', 'it_it', 'Ripeti settimanalmente', 29),
                ('REPEAT_DAILY', 'Repeat Daily', 'it_it', 'Ripeti giornalmente', 29),
                ('ACTION_TITLE', 'Action Title', 'it_it', 'Titolo dell\'azione', 29),
                ('MSG_SELECT_VALID_DATE', 'Please select valid day of month.', 'it_it', 'Prego seleziona un giorno del mese valido.', 29),
                ('MSG_SELECT_VALID_START_DATE', 'Start date should be less than end date.', 'it_it', 'La data di inizio deve essere precedente alla data di fine.', 29),
                ('MSG_SELECT_VALID_START_TIME', 'Start time should be less than end time.', 'it_it', 'L\'ora di inizio deve essere precedente all\'ora di fine.', 29),
                ('LBL_LINEITEM_DETAILS', 'Lineitem Details', 'it_it', 'Dettagli elemento', 29),
                ('MSG_INVALIDE_DISCOUNT_AMOUNT', 'Discount amount should be less than the total.', 'it_it', 'L\'importo dello sconto deve essere inferiore al totale.', 29),
                ('VIEW', 'View', 'it_it', 'Vista', 29),
                ('MSG_ENTER_VALID', 'Please enter valid', 'it_it', 'Prego inserisci un valore valido', 29),
                ('MSG_ENTER_PERCENTAGE', 'Percentage should be less than 100.', 'it_it', 'La percentuale deve essere inferiore a 100.', 29),
                ('ITEM_TOTAL', 'Item Total', 'it_it', 'Totale elemento', 29),
                ('ADJUSTMENT', 'Adjustment', 'it_it', 'Regolazione', 29),
                ('TITLE_CHOOSE_IMAGE', 'Choose Image', 'it_it', 'Scegli immagine', 29),
                ('COMPRESS', 'Compress', 'it_it', 'Comprimi', 29),
                ('CHOOSE_ANOTHER_IMAGE', 'Your image size is too large, please select another image', 'it_it', 'La tua immagine è troppo grande, selezionane un\'altra', 29),
                ('OnDayOfMonth', 'On day of month', 'it_it', 'Il giorno del mese', 29),
                ('OnDayOfWeek', 'On day of week', 'it_it', 'Il giorno della settimana', 29),
                ('AddAndClose', 'Add & Close', 'it_it', 'Aggiungi & Chiudi', 29),
                ('Repeat', 'Repeat', 'it_it', 'Ripeti', 29),
                ('OnDay', 'On day', 'it_it', 'Il giorno', 29),
                ('View_Line_Item', 'View Line Item', 'it_it', 'Vedi elemento', 29),
                ('TITLE_IMAGE', 'Image', 'it_it', 'Immagine', 29),
                ('TITLE_ICLOUD', 'iCloud', 'it_it', 'iCloud', 29),
                ('GOOGLE', 'Google', 'it_it', 'Google', 29),
                ('ALERT_BTN_OKAY', 'Okay', 'it_it', 'Okay', 29),
                ('ALERT_TITLE_ACCESS_DENIED', 'Access Denied', 'it_it', 'Accesso negato', 29),
                ('Dont_Show_Again', 'Don\'t show again', 'it_it', 'Non mostrare di nuovo', 29),
                ('Skip', 'Skip', 'it_it', 'Salta', 29),
                ('Fillter_Name', 'Fillter Name', 'it_it', 'Nome filtro', 29),
                ('Fillter_Record_Count', 'Fillter Record Count', 'it_it', 'Conteggio record filtro', 29),
                ('url_note',      'Note : if your URL of CRM is https://example.com/crm enter that into above box',   'it_it',    'Note : if your URL of CRM is https://example.com/crm enter that into above box',   31),
                ('vtiger_url',    'Your vTiger CRM URL',  'it_it',    'Your vTiger CRM URL',  31),
                ('msg_doc_read_permission',   'You don\'t have permission to Add either This is read-only or Private Field.',     'it_it',    'You don\'t have permission to Add either This is read-only or Private Field.',     31),
                ('CLEAR',   'Clear',    'it_it',    'Svuota',    31),
                ('Files/photos uploaded successfully',    'Files/photos uploaded successfully',     'it_it',    'File/foto caricati correttamente',     32),
                ('Digital signature saved',   'Digital signature saved',    'it_it',    'Firma digitale salvata',    32),
                ('Please upload Signature or Files/photos',     'Please upload Signature or Files/photos',      'it_it',    'Prego carica Firma e File/foto',      32),
                ('Files / Photos',      'Files / Photos', 'it_it',    'File / Foto', 32),
                ('Signature',     'Signature',      'it_it',    'Firma',      32),
                ('add_photo_using',     'Add Photo Using',      'it_it',    'Aggiungi foto usando',      31),
                ('btn_upload_sign',     '(+) Add Signature',    'it_it',    '(+) Aggiungi Firma',    31),
                ('btn_upload_photo_doc',      '(+) Upload Files/Photos',    'it_it',    '(+) Carica File / Foto',    31),
                ('select_photo_doc_to_upload',      'Please select files/photos to upload',   'it_it',    'Prego seleziona i file/foto da caricare',   31),
                ('related_module_title',      'Search from related module and Add to \"Route\"',    'it_it',    'Cerca da modulo collegato e Aggiungi a \"Itinerario\"',    30),
                ('Route status updated successfully',     'Route status updated successfully',      'it_it',    'Stato dell\'itinerario aggiornato correttamente',      32),
                ('Session init failed', 'Session init failed',  'it_it',    'Inizializzazione della sessione fallita',  32),
                ('You don\'t have permission to access this resource',      'You don\'t have permission to access this resource', 'it_it',    'Non hai il permesso di accedere a questa risorsa', 32),
                ('ctroute_realtedto cannot be empty',     'Could not get the Related To - Try again later',     'it_it',    'Non è stato possibile ottenere il Collegato a - Riprova più tardi',     32),
                ('ctroute_planning cannot be empty',      'Could not get the Route Planning Record - Try again later',      'it_it',    'Non è stato possibile ottenere il record della Pianificazione Itinerario - Riprova più tardi',      32),
                ('Something went wrong - Try again later',      'Something went wrong - Try again later', 'it_it',    'Qualcosa è andato storto - Riprova più tardi', 32),
                ('sequence updated successfully',   'sequence updated successfully',    'it_it',    'sequenza aggiornata correttamente',    32),
                ('sequence cannot be empty',  'sequence cannot be empty',   'it_it',    'la sequenza non può essere vuota',   32),
                ('Shortcut details not saved',      'Shortcut details not saved', 'it_it',    'Dettagli della scorciatoia non salvati', 32),
                ('Shortcut details saved successfully',   'Shortcut details saved successfully',    'it_it',    'Dettagli della scorciatoia salvati correttamente',    32),
                ('Route save successfully',   'Route save successfully',    'it_it',    'Itinerario salvato correttamente',    32),
                ('Record save successfully',  'Record save successfully',   'it_it',    'Record salvato correttamente',   32),
                ('No dependency found for picklist',      'No dependency found for picklist', 'it_it',    'Dipendenza non trovata per la picklist', 32),
                ('No records found',    'No records found',     'it_it',    'Nessun record trovato',     32),
                ('Outgoing server is not enabled, please configure from CRM',     'Outgoing server is not enabled, please configure from CRM',      'it_it',    'Server di uscita non abilitato, per favore configuralo nel CRM',      32),
                ('Removed Successfully',      'Removed Successfully', 'it_it',    'Eliminato correttamente', 32),
                ('Shortcut has been deleted', 'Shortcut has been deleted',  'it_it',    'La scorciatoia è stata eliminata',  32),
                ('relation of records removed successfully',    'relation of records removed successfully',     'it_it',    'relazioni dei record eliminate correttamente',     32),
                ('relation of records not removed', 'relation of records not removed',  'it_it',    'relazioni dei record non eliminate',  32),
                ('Record has been deleted successfully',  'Record has been deleted successfully',   'it_it',    'Il record è stato eliminato correttamente',   32),
                ('Time Tracking saved successfully',      'Time Tracking saved successfully', 'it_it',    'Tracciamento Orario salvato correttamente', 32),
                ('Time Tracking updated successfully',    'Time Tracking updated successfully',     'it_it',    'Tracciamento Orario aggiornato correttamente',     32),
                ('Time Tracking ended successfully',      'Time Tracking ended successfully', 'it_it',    'Tracciamento Orario concluso correttamente', 32),
                ('Time Tracking started successfully',    'Time Tracking started successfully',     'it_it',    'Tracciamento Orario avviato correttamente',     32),
                ('record cannot be empty',    'record cannot be empty',     'it_it',    'il record non può essere vuoto',     32),
                ('Module is disabled',  'Module is disabled',   'it_it',    'Modulo disabilitato',   32),
                ('Shift ended successfully',  'Shift ended successfully',   'it_it',    'Turno concluso correttamente',   32),
                ('Shift started successfully',      'Shift started successfully', 'it_it',    'Turno avviato correttamente', 32),
                ('relation of records added successfully',      'relation of records added successfully', 'it_it',    'relazione tra record aggiunta correttamente', 32),
                ('Comment saved successfully',      'Comment saved successfully', 'it_it',    'Commento salvato correttamente', 32),
                ('Comment not saved',   'Comment not saved',    'it_it',    'Commento non salvato',    32),
                ('Comment module is not active',    'Comment module is not active',     'it_it',    'Modulo commento non attivo',     32),
                ('No Upcoming Event',   'No Upcoming Event',    'it_it',    'Nessun evento in programma',    32),
                ('No Templates found - create it from Message Templates module',  'No Templates found - create it from Message Templates module',   'it_it',    'Nessun modello trovato - crealo nel modulo Modelli Messaggio',   32),
                ('No event or task for this date',  'No event or task for this date',   'it_it',    'Nessun evento o compito in questa data',   32),
                ('No filters created',  'No filters created',   'it_it',    'Nessun filtro creato',   32),
                ('Select at least one record to attach',  'Select at least one record to attach',   'it_it',    'Selezione almeno un record da allegare',   32),
                ('Please select one or more attachments', 'Please select one or more attachments',  'it_it',    'Per favore seleziona uno o più allegati',  32),
                ('No event for this month',   'No event for this month',    'it_it',    'Nessun evento in questo mese',    32),
                ('No Activity found',   'No Activity found',    'it_it',    'Nessuna Attività trovata',    32),
                ('Your feedback is valuable for us - it cannot be empty',   'Your feedback is valuable for us - it cannot be empty',    'it_it',    'Il tuo feedback è importante - non può essere vuoto',    32),
                ('Could not send mail, Please try later', 'Could not send mail, Please try later',  'it_it',    'Mail non inviata, per favore prova più tardi',  32),
                ('Latest Version updated successfully',   'Latest Version updated successfully',    'it_it',    'Versione più recente aggiornata correttamente',    32),
                ('User Location Updated Successfully',    'User Location Updated Successfully',     'it_it',    'Posizione utente aggiornata correttamente',     32),
                ('User Location not Updated Successfully',      'User Location not Updated Successfully', 'it_it',    'Posizione utente non aggiornata correttamente', 32),
                ('SMSNotifier is not enable in CRM. Please enable it first',      'SMSNotifier is not enable in CRM. Please enable it first', 'it_it',    'SMSNotifier non è abilitato nel CRM. Per favore abilitalo prima', 32),
                ('Could not submit your feedback - Please try again later', 'Could not submit your feedback - Please try again later',  'it_it',    'Non è stato possibile inviare il tuo feedback - Per favore riprova più tardi',  32),
                ('Thank you for submitting your feedback',      'Thank you for submitting your feedback', 'it_it',    'Grazie per aver inviato il tuo feedback', 32),
                ('Please upload User Image',  'Please upload User Image',   'it_it',    'Per favore carica la foto Utente',   32),
                ('Image Not Uploading, please try again', 'Image Not Uploading, please try again',  'it_it',    'Foto non caricata, per favore riprova',  32),
                ('User Image Uploaded Successfully',      'User Image Uploaded Successfully', 'it_it',    'Immagine utente caricata con successo', 32),
                ('Invalid Module name', 'Invalid Module name',  'it_it',    'Nome modulo non valido',  32),
                ('Records Sync Successfully', 'Records Sync Successfully',  'it_it',    'Record sincronizzati con successo',  32),
                ('Values cannot be empty',    'Values cannot be empty',     'it_it',    'I valori non possono essere vuoti',     32),
                ('Record id is empty',  'Record id is empty',   'it_it',    'L\'ID del record è vuoto',   32),
                ('Logout Successfully', 'Logout Successfully',  'it_it',    'Logout eseguito con successo',  32),
                ('Please Enable CTMobile Module',   'Please Enable CTMobile Module',    'it_it',    'Abilita il modulo CTMobile',    32),
                ('Authentication Failed',     'Username and Password do not match',     'it_it',    'Nome utente e password non corrispondono',     32),
                ('Mismatched module information',   'Something gone wrong, please try again later', 'it_it',    'Qualcosa è andato storto, riprova più tardi', 32),
                ('Field does not exists',     'Please set display fields again',  'it_it',    'Si prega di impostare nuovamente i campi visualizzati',  32),
                ('Module does not exists',    'Module does not exists or disabled by admin',  'it_it',    'Il modulo non esiste o è disabilitato dall\'amministratore',  32),
                ('Month cannot be empty',     'Could not get the Month - Try again later',    'it_it',    'Impossibile ottenere il mese. Riprova più tardi',    32),
                ('Year cannot be empty',      'Could not get the Year - Try again later',     'it_it',    'Impossibile ottenere l\'anno. Riprova più tardi',     32),
                ('Date cannot be empty',      'Could not get the Date - Try again later',     'it_it',    'Impossibile ottenere la data. Riprova più tardi',     32),
                ('Userid cannot be empty',    'Could not get the Userid - Try again later',   'it_it',    'Impossibile ottenere l\'ID utente - Riprova più tardi',   32),
                ('End Date cannot be empty',  'Could not get the status - Try again later',   'it_it',    'Impossibile ottenere lo stato - Riprova più tardi',   32),
                ('Start Date cannot be empty',      'Could not get the Start Date - Try again later',     'it_it',    'Impossibile ottenere la data di inizio. Riprova più tardi',     32),
                ('You do not configure SMS Notifier in CRM. Please configure SMS Notifier in your CRM to use this feature', 'You do not configure SMS Notifier in CRM. Please configure SMS Notifier in your CRM to use this feature',  'it_it',    'Non hai configurato l\'SMS Notifier nel CRM. Configura l\'SMS Notifier nel tuo CRM per utilizzare questa funzione',  32),
                ('Longitude cannot be empty', 'Could not get location-Please try again',      'it_it',    'Impossibile ottenere la posizione. Riprova',      32),
                ('Latitude cannot be empty',  'Could not get location-Please try again',      'it_it',    'Impossibile ottenere la posizione. Riprova',      32),
                ('User cannot be empty',      'Could not get the User - Try again later',     'it_it',    'Impossibile ottenere l\'utente - Riprova più tardi',     32),
                ('Status cannot be empty',    'Could not get the status - Try again later',   'it_it',    'Impossibile ottenere lo stato - Riprova più tardi',   32),
                ('Required fields not found', 'Required fields not found',  'it_it',    'Campi obbligatori non trovati',  32),
                ('Tracking module not active',      'Tracking module not active-Please contact CRM Admin',      'it_it',    'Modulo di monitoraggio non attivo - Contatta l\'admin del CRM',      32),
                ('Missing mandatory input values',  'Missing mandatory input values',   'it_it',    'Valori di input obbligatori mancanti',   32),
                ('No MailBox found. Please Create Mailbox',     'No MailBox found. Please Create Mailbox',      'it_it',    'Nessuna Mailbox trovata. Crea una Mailbox',      32),
                ('Mail not sent', 'Mail not sent',  'it_it',    'Mail non inviata',  32),
                ('Mail send successfully',    'Mail send successfully',     'it_it',    'Mail inviata con successo',     32),
                ('Email Id or username not match with your record',   'Email Id or username not match with your record',    'it_it',    'L\'ID e-mail o il nome utente non corrispondono al tuo record',    32),
                ('Module not specified',      'Module not specified', 'it_it',    'Modulo non specificato', 32),
                ('No messages found',   'No messages found',    'it_it',    'Nessun messaggio trovato',    32),
                ('No Dependency Found For This Module',   'No Dependency Found For This Module',    'it_it',    'Nessuna dipendenza trovata per questo modulo',    32),
                ('Outgoing server is not Enabled',  'Outgoing server is not Enabled',   'it_it',    'Il server in uscita non è abilitato',   32),
                ('Outgoing server is Enabled',      'Outgoing server is Enabled', 'it_it',    'Il server in uscita è abilitato', 32),
                ('Email Attached Successfully',     'Email Attached Successfully',      'it_it',    'Email allegata con successo',      32),
                ('Documents Attached Successfully', 'Documents Attached Successfully',  'it_it',    'Documenti allegati correttamente',  32),
                ('Login required - Please login again',   'Login required - Please login again',    'it_it',    'Login richiesto - Effettua nuovamente il login',    32),
                ('time_tracking_module_disable',    'Time tracking module is disable',  'it_it',    'Il modulo di monitoraggio del tempo è disabilitato',  31),
                ('route_planning_module_disable',   'Route planning module is disable', 'it_it',    'Il modulo di pianificazione del percorso è disabilitato', 31),
                ('mark_as_held',  'Are you sure you want to mark Event as Held?', 'it_it',    'Sei sicuro di voler contrassegnare l\'evento come Tenuto?', 31),
                ('stop_timer_msg',      'You have already started Time tracking for another record, Do you want to stop it first ?',    'it_it',    'Hai già avviato il monitoraggio del tempo per un altro record. Vuoi interromperlo prima?',    31),
                ('access_denied_routeplanning',     'Access denied for route planning', 'it_it',    'Accesso negato per la pianificazione del percorso', 31),
                ('time_spent',    'Time Spent',     'it_it',    'Tempo impiegato',     31),
                ('select_user',   'Select User',    'it_it',    'Seleziona Utente',    30),
                ('status_cannot_be_held',     'Status cannot be held for future date start',  'it_it',    'Lo stato non può essere mantenuto per l\'inizio della data futura',  30),
                ('please_select_end_date',    'Please select end date',     'it_it',    'Seleziona la data di fine',     30),
                ('please_select_start_date',  'Please select start date',   'it_it',    'Seleziona la data di inizio',   30),
                ('tap_on_plus_icon_for_select_route',     'Tap on + icon to select record for your route.',     'it_it',    'Toccare l\'icona + per selezionare il record per il percorso.',     30),
                ('please_enter_notes',  'Please enter notes',   'it_it',    'Si prega di inserire note',   30),
                ('please_enter_title',  'Please enter title',   'it_it',    'Si prega di inserire il titolo',   30),
                ('please_select_date',  'Please Select Date',   'it_it',    'Seleziona la data',   30),
                ('search_by_date',      'Search by Date', 'it_it',    'Cerca per data', 30),
                ('shortcut_not_setup_yet',    'Opps shortcut not setup yet!!! Please add shortcut by click on [icon] from record search results or view record screen.',    'it_it',    'Scorciatoia Opps non ancora configurata !!! Aggiungere un collegamento facendo clic su [icona] dai risultati di ricerca dei record o visualizzare la schermata di registrazione.',    30),
                ('max_upload_size',     'max file Upload exceeds',    'it_it',    'il caricamento massimo del file supera',    30),
                ('unselect_all',  'UnSelect All',   'it_it',    'Deseleziona tutto',   30),
                ('select_all',    'Select All',     'it_it',    'Seleziona tutto',     30),
                ('please_select_records',     'Please select records',      'it_it',    'Seleziona i record',      30),
                ('select_date',   'Select Date',    'it_it',    'Seleziona la data',    30),
                ('quantity_in_stock_is',      'Quantity in stock is', 'it_it',    'La quantità in magazzino è', 30),
                ('replies', 'Replies',  'it_it',    'Risposte',  30),
                ('conversation_require_selection',  'Conversion requires selection of Contact or Organization', 'it_it',    'La conversione richiede la selezione del Contatto o dell\'Organizzazione', 30),
                ('please_select_product',     'Please Select Product',      'it_it',    'Seleziona un prodotto',      30),
                ('timer_msg',     'You can start timer for single task only at same time',    'it_it',    'È possibile avviare il timer per una singola attività solo allo stesso tempo',    31),
                ('save_start_tracking', 'Save & Start Tracking',      'it_it',    'Salva e avvia il monitoraggio',      31),
                ('lbl_notes',     'Notes',    'it_it',    'Note',    31),
                ('enter_title',   'Enter Title',    'it_it',    'Inserire il titolo',    31),
                ('select_module_record',      'Select Module / Record',     'it_it',    'Seleziona Modulo / Registra',     31),
                ('lbl_tomorrow',  'Tomorrow', 'it_it',    'Domani', 30),
                ('lbl_yesterday', 'Yesterday',      'it_it',    'Ieri',      30),
                ('lbl_today',     'Today',    'it_it',    'Oggi',    30),
                ('time_tracker',  'Time Tracker',   'it_it',    'Time Tracker',   31),
                ('time_end',      'End Time', 'it_it',    'Ora di fine', 5),
                ('due_date',      'End Date', 'it_it',    'Data di fine', 5),
                ('time_start',    'Time Start',     'it_it',    'Ora inizio',     5),
                ('date_start',    'Start Date',     'it_it',    'Data di inizio',     5),
                ('delete_widget_msg',   'Display widget again by using (+) option',     'it_it',    'Visualizza nuovamente il widget utilizzando l\'opzione (+)',     15),
                ('no_upcoming_activities',    'No scheduled activities ',    'it_it',    'Nessuna attività programmata',    15),
                ('check_in_first',      'Please check-in first',      'it_it',    'Effettua prima il check-in',      30),
                ('duration',      'Duration', 'it_it',    'Durata', 30),
                ('distance',      'Distance', 'it_it',    'Distanza', 30),
                ('proper_address_message',    'Please enter proper address in record\n',      'it_it',    'Immettere l\'indirizzo corretto nel record',  30),
                ('select_status', 'Select Status',  'it_it',    'Seleziona Stato',  30),
                ('route_planner', 'Route Planner',  'it_it',    'Pianificatore dell\'itinerario',  30),
                ('route_planning',      'Route Planning', 'it_it',    'Pianificazione dell\'itinerario', 30),
                ('add_route',     'Add Route',      'it_it',    'Aggiungi itinerario',      30),
                ('calender_disabled',   'Calendar Module is disabled',      'it_it',    'Il modulo calendario è disabilitato',      30),
                ('close_dialog',  'Close form',     'it_it',    'Chiudi modulo',     30),
                ('cancel_form_message', 'Are You sure want to close ?',     'it_it',    'Sei sicuro di voler chiudere?',     30),
                ('create_route',  'Create Route',   'it_it',    'Crea itinerario',   30),
                ('select_module_create_route',      'Select Module to create Route',    'it_it',    'Seleziona Modulo per creare l\'itinerario',    30),
                ('cancel',  'Cancel',   'it_it',    'Annulla',   30),
                ('assign_route',  'Assign Route',   'it_it',    'Assegna itinerario',   30),
                ('route_for',     'Route for',      'it_it',    'Itinerario per',      30),
                ('assigned_to',   'Assigned To',    'it_it',    'Assegnato a',    30),
                ('enter_route_name',    'Enter Route Name',     'it_it',    'Immettere il nome dell\'itinerario',     30),
                ('list',    'List',     'it_it',    'Elenco',     30),
                ('map',     'Map',      'it_it',    'Mappa',      30),
                ('other_modules', 'Other Modules',  'it_it',    'Altri moduli',  15),
                ('shortcut_no_record_msg',    'Opps shortcut not setup\n yet!!! Please add shortcut  by click on + icon from record\n search results or view record screen.',     'it_it',   'Collegamento Opps non configurato ancora!!! Aggiungi un collegamento facendo clic sull\'icona + dal record
                  risultati della ricerca o visualizza la schermata di registrazione. ',     25),
                ('clear',   'Clear',    'it_it',    'Svuota',    25),
                ('open',    'Open',     'it_it',    'Apri',     11),
                ('max_file_msg',  'Too many files selected (max:6)',  'it_it',    'Troppi file selezionati (max: 6)',  11),
                ('error_voicenote_record',    'Unable to recording voice while another application is recording sound.',    'it_it',    'Impossibile registrare la voce mentre un\'altra applicazione sta registrando il suono.',    11),
                ('msg_warning',   'Warning!', 'it_it',    'Attenzione!', 11),
                ('Permision_denied_contact',  'Permission denied to access your contacts',    'it_it',    'Autorizzazione negata per accedere ai tuoi contatti',    15),
                ('no_widget_added',     'Please click + icon to add new widget to your dashboard.', 'it_it',    'Fare clic sull\'icona + per aggiungere un nuovo widget alla dashboard.', 15),
                ('no_data_available',   'Data not available, please check the selected fields',     'it_it',    'Dati non disponibili, verificare i campi selezionati',     15),
                ('check_out_successfully',    'Check out successfully',     'it_it',    'Check out con successo',   11),
                ('check_in_successfully',     'Check in successfully',      'it_it',    'Check in con successo',    11),
                ('check_out',     'Check out',      'it_it',    'Check out',      11),
                ('check_in',      'Check in', 'it_it',    'Check in', 11),
                ('navigate',      'Navigate', 'it_it',    'Naviga', 11),
                ('save_to_phone_vcard_success',     'VCard Saved to phone successfully',      'it_it',    'VCard salvata correttamente nel telefono',      15),
                ('download_vcard_success',    'VCard downloaded successfully',    'it_it',    'VCard scaricata con successo',    15),
                ('card_details',  'Card Details',   'it_it',    'Estremi della carta',   15),
                ('add_widget',    'Add Widget',     'it_it',    'Aggiungi widget',     15),
                ('delete_widget', 'Are you sure to hide widget?',     'it_it',    'Sei sicuro di nascondere il widget?',     15),
                ('already_widgets_added',     'All types of Widget & reports are already added',    'it_it',    'Tutti i tipi di widget e report sono già aggiunti',    15),
                ('retry',   'Retry',    'it_it',    'Riprova',    28),
                ('retake',  'Retake',   'it_it',    'Ripeti',   28),
                ('Reports', 'Reports',  'it_it',    'Rapporti',  15),
                ('Widgets', 'Widgets',  'it_it',    'Widget',  15),
                ('vcard_config',  'Vcard Configuration',  'it_it',    'Configurazione Vcard',  8),
                ('save_to_phone', 'Save to phone',  'it_it',    'Salva sul telefono',  11),
                ('download_vcard',      'Download Vcard', 'it_it',    'Scarica Vcard', 11),
                ('share_vcard',   'Share Vcard',    'it_it',    'Condividi Vcard',    11),
                ('share_record',  'Share Record',   'it_it',    'Condividi record',   11),
                ('permission_denied_edit',    'You don\'t have permission to edit this record.',    'it_it',    'Non hai l\'autorizzazione per modificare questo record.',    27),
                ('permission_denied_delete',  'You don\'t have permission to delete this record.',  'it_it',    'YNon hai l\'autorizzazione per eliminare questo record.',  27),
                ('Voice_Recording_Started',   'Recording Started',    'it_it',    'Registrazione avviata',    12),
                ('Voice_Recording_Stopped',   'Recording Stopped',    'it_it',    'Registrazione interrotta',    12),
                ('SEARCH',  'Search',   'it_it',    'Cerca',   7),
                ('LAST',    'Last',     'it_it',    'Ultimo',     7),
                ('FIRST',   'First',    'it_it',    'Primo',    7),
                ('MONDAY',  'Monday',   'it_it',    'Lunedi',   7),
                ('TUESDAY', 'Tuesday',  'it_it',    'martedì',  7),
                ('WEDNESDAY',     'Wednesday',      'it_it',    'mercoledì',      7),
                ('THURSDAY',      'Thursday', 'it_it',    'giovedi', 7),
                ('FRIDAY',  'Friday',   'it_it',    'Venerdì',   7),
                ('SATURDAY',      'Saturday', 'it_it',    'Sabato', 7),
                ('SUNDAY',  'Sunday',   'it_it',    'Domenica',   7),
                ('DAILY',   'Daily',    'it_it',    'Giornaliero',    7),
                ('WEEKLY',  'Weekly',   'it_it',    'Settimanale',   7),
                ('MONTHLY', 'Monthly',  'it_it',    'Mensile',  7),
                ('YEARLY',  'Yearly',   'it_it',    'Annuale',   7),
                ('asset_tracking',      'Asset tracking', 'it_it',    'Monitoraggio risorse', 15);",array());
    }


    static function he_il(){
        global $adb;
        $checkQuery = "DELETE FROM ctmobile_language_keyword WHERE keyword_lang = ?";
        $checkResult = $adb->pquery($checkQuery,array('he_il'));
        
        $adb->pquery("INSERT INTO `ctmobile_language_keyword` (`keyword`, `keyword_name`, `keyword_lang`, `language_keyword`, `sectionid`) VALUES
            ('network_error', 'Network connection error!', 'he_il', 'בעיה ברשת!', 1),
            ('connection_check', 'Could not connect to CRM, Please check your Internet connection.', 'he_il', 'בדוק את חיבור האינטרנט שלך.', 1),
            ('update', 'Update', 'he_il', 'עדכון', 1),
            ('cancel', 'Cancel', 'he_il', 'בטל', 1),
            ('ok', 'Ok', 'he_il', 'בסדר', 1),
            ('more_information', 'Click here for more information.', 'he_il', 'לחץ כאן למידע נוסף.', 1),
            ('yes', 'Yes', 'he_il', 'כן', 1),
            ('no', 'No', 'he_il', 'לאפס', 1),
            ('click_again_exit', 'Click again to exit', 'he_il', 'לחץ שוב כדי לצאת', 1),
            ('forpermission', 'You don\'t have permission to view this feature. Please subscribe for Premium version Click here to Subscribe.', 'he_il', 'אין לך הרשאה להציג תכונות אלה. נא להירשם לקבלת גירסת Premium לחץ כאן כדי להירשם.', 1),
            ('clickhere', 'Click here', 'he_il', 'לחץ כאן', 1),
            ('clickhere_subscribe', 'Click here to subscribe premium version', 'he_il', 'לחץ כאן כדי להירשם', 1),
            ('clickhere_configure', 'Click here and view how to Configure.', 'he_il', 'לחץ כאן כדי להציג כיצד להגדיר. ל', 1),
            ('please_wait', 'Please Wait…', 'he_il', 'המתן בבקשה…', 1),
            ('share__msg', 'Share file with', 'he_il', 'שיתוף קבצים עם', 1),
            ('dialog_camera', 'Camera', 'he_il', 'מצלמה', 1),
            ('dialog_add_file_by', 'Take Photo from', 'he_il', 'הוסף קבצים לפי', 1),
            ('add', 'Add', 'he_il', 'לְהוֹסִיף', 1),
            ('mail_manager_configured', 'Mail Manager is not configured', 'he_il', 'מנהל הדואר אינו מוגדר', 1),
            ('dialog_add_files_by', 'Add Files by', 'he_il', 'הוסף קבצים לפי', 1),
            ('dialog_drive', 'Drive', 'he_il', 'נהיגה', 1),
            ('dialog_drop_box', 'Drop Box', 'he_il', 'קופסת תיבות', 1),
            ('dialog_need_signin', 'You need to Sign-in to your Drive account first.', 'he_il', 'אתה צריך להיכנס ראשון',1),
            ('dialog_gallery', 'Gallery', 'he_il', 'גלריה', 1),
            ('delete', 'Delete', 'he_il', 'לִמְחוֹק', 1),
            ('timeoutmessage', 'Oops! Request is taking more time than expected.', 'he_il', 'בקשת אופס אורכת זמן רב מהצפוי.', 1),
            ('gps_location_message', 'GPS is not enabled. Please turn it on to get your near by locations.', 'he_il','ה- GPS אינו מופעל. הפעל אותו כדי לקבל את המיקום הקרוב אליך.',1),
            ('sure_want_delete', 'Are you sure want to delete ?', 'he_il', 'האם אתה בטוח שברצונך למחוק?', 1),
            ('select', 'Select', 'he_il', 'בחר', 1),
            ('msgforrecordaudio', 'Minimum record duration one second.', 'he_il', 'משך רשומה מינימלי שנייה אחת', 1),
            ('permission_storage', 'Permission denied to read your External storage', 'he_il', 'הרשאה נדחתה לקרוא את האחסון החיצוני שלך', 1),
            ('send_permission_msg', 'Send message permission denied', 'he_il', 'שלח אישור הודעה שנדחה', 1),
            ('choosefile', 'Choose File', 'he_il', 'בחר קובץ', 1),
            ('enter', 'Enter', 'he_il', 'להיכנס', 1),
            ('select_an_option', 'Select an Option', 'he_il', 'בחר אפשרות', 1),
            ('email_validation', 'Email is not valid', 'he_il', 'האימייל אינו חוקי', 1),
            ('please_enter', 'Please Enter', 'he_il', 'בבקשה היכנס', 1),
            ('website_validation_text', 'Website URL is not valid', 'he_il', 'כתובת האתר של האתר אינה חוקית', 1),
            ('selectvalue', 'Select value first', 'he_il', 'בחר ערך תחילה', 1),
            ('email', 'Email', 'he_il', 'אֶלֶקטרוֹנִי', 1),
            ('enter_email_address', 'Enter email address', 'he_il', 'הזן כתובת דוא\"ל', 1),
            ('email_address_not_correct', 'Email address incorrect', 'he_il', 'כתובת האימייל שגויה', 1),
            ('pls_enter_subject', 'Please Enter Subject', 'he_il', 'הזן נושא', 1),
            ('attachFiles', 'Attached File', 'he_il', 'קובץ מצורף', 1),
            ('from', 'From', 'he_il', 'מ', 1),
            ('to', 'To', 'he_il', 'ל', 1),
            ('call_permission_msg', 'Call permission denied', 'he_il', 'הרשאת קריאה נדחתה', 1),
            ('no_records', 'No records found', 'he_il', 'לא נמצאו שיאים', 1),
            ('fullform', 'Create New', 'he_il', 'טופס מלא', 1),
            ('save', 'Save', 'he_il', 'להציל', 1),
            ('total', 'Total', 'he_il', 'סך הכל', 1),
            ('discount', 'Discount', 'he_il', 'הנחה', 1),
            ('price', 'Price', 'he_il', 'מחיר *', 1),
            ('quantity', 'Quantity', 'he_il', 'כמות *', 1),
            ('select_module', 'Select Module', 'he_il', 'בחר מודול', 1),
            ('item_list', 'Item List', 'he_il', 'רשימת פריטים', 1),
            ('quickcreate', 'Quick Create', 'he_il', 'יצירה מהירה', 1),
            ('overwrite_msg_part1', 'Overwrite the existing address with the selected', 'he_il', 'החלף את הכתובת הקיימת באמצעות הכתובת הנבחרת ', 1),
            ('once_in_every', 'Once in every', 'he_il', 'פעם אחת בכל', 1),
            ('overwrite_msg_part2', 'address details?', 'he_il', 'פרטי כתובת?', 1),
            ('add_item', 'Add Item', 'he_il', 'הוסף פריט', 1),
            ('recordsave', 'Record saved successfully', 'he_il', 'הקלט שמור בהצלחה', 1),
            ('recordnotsave', 'Could not save record. Try again later', 'he_il', 'הרשומה לא תשמור', 1),
            ('minutes', 'Minutes', 'he_il', 'דקות', 1),
            ('hours', 'Hours', 'he_il', 'שעות', 1),
            ('days', 'Days', 'he_il', 'ימים', 1),
            ('on', 'On', 'he_il', 'מופעל', 1),
            ('day_of_the_month', 'day of the month', 'he_il', 'יום החודש', 1),
            ('list_price', 'List Price', 'he_il', 'רשימת מחירים *', 1),
            ('add_record', 'Add Record', 'he_il', 'הוסף רשומה', 1),
            ('add_product', 'Add Product', 'he_il', 'הוסף מוצר', 1),
            ('add_service', 'Add Service', 'he_il', 'הוסף שירות', 1),
            ('discountin', 'Discount in %', 'he_il', 'הנחה ב-%', 1),
            ('unitprice', 'Unit price', 'he_il', 'מחיר ליחידה *', 1),
            ('netprice', 'Net price', 'he_il', 'מחיר נטו *', 1),
            ('comments', 'Comments', 'he_il', 'הערות', 1),
            ('add_close', 'Add & Close', 'he_il', 'הוסף &amp; סגור',1),
            ('fetching_rout_message', 'Fetching route, Please wait…', 'he_il', 'מאחזר נתיב, המתן …', 1),
            ('setting', 'Settings', 'he_il', 'הגדרות', 1),
            ('utc', 'UTC', 'he_il', 'UTC', 1),
            ('in', 'In', 'he_il', 'ב', 1),
            ('days_ago', 'days ago', 'he_il', 'לפני מספר ימים', 1),
            ('mins_ago', 'Minutes ago', 'he_il', 'לפני דקות', 1),
            ('justnow', 'Just now', 'he_il', 'זֶה עַתָה', 1),
            ('hours_ago', 'hours ago', 'he_il', 'לפני שעות', 1),
            ('in_1_day', 'In 1 day', 'he_il', 'ביום אחד', 1),
            ('scanqrcode', 'Asset / Card Scanner', 'he_il', 'כרטיס סורק', 1),
            ('call_log', 'Call Log', 'he_il', 'יומן שיחות', 1),
            ('voice_message', 'Hi', 'he_il', 'שלום', 1),
            ('voice_message1', 'What can I search for you in', 'he_il', 'מה אוכל לחפש עבורך', 1),
            ('live_tracking', 'Live Tracking', 'he_il', 'מעקב חי', 1),
            ('mailmanager', 'Mail Manager', 'he_il', 'מנהל הדואר', 1),
            ('my_location', 'My location', 'he_il', 'המיקום שלי', 1),
            ('created_on', 'Created On', 'he_il', 'נוצר ב', 1),
            ('modified_on', 'Modified On', 'he_il', 'השתנה', 1),
            ('enter_comments', 'Enter Comments', 'he_il', 'הזן הערות', 1),
            ('viewmore', 'View More', 'he_il', 'ראה עוד', 1),
            ('viewless', 'View Less', 'he_il', 'הצג פחות', 1),
            ('gotofullform', 'Go to Full Form', 'he_il', 'עבור אל טופס מלא', 1),
            ('post', 'Post', 'he_il', 'הודעה', 1),
            ('url', 'URL', 'he_il', 'כתובת אתר', 1),
            ('dialog_title_text_back_color', 'Select a Text Background Color', 'he_il', 'בחר צבע רקע טקסט', 1),
            ('event_or_task', 'Add event/task', 'he_il', 'הוסף אירוע / משימה', 1),
            ('shortcut', 'Shortcuts', 'he_il', 'קיצורי דרך', 1),
            ('select_field', 'Select Field', 'he_il', 'בחר שדה', 1),
            ('share', 'Share', 'he_il', 'שתף', 1),
            ('title_insert_link', 'Insert Link', 'he_il', 'הוסף קישור', 1),
            ('addyourcommentshere', 'Add your comments here', 'he_il', 'הוסף את ההערות שלך כאן', 1),
            ('nocomment', 'No Comments', 'he_il', 'אין תגובה', 1),
            ('leads', 'Leads', 'he_il', 'הובלות', 1),
            ('true_val', 'true', 'he_il', 'נָכוֹן', 1),
            ('noresult', 'No Result', 'he_il', 'אין תוצאה', 1),
            ('version', 'Version', 'he_il', 'גרסה', 1),
            ('convert_lead', 'Convert Lead', 'he_il', 'המרת ליד', 1),
            ('app_name', 'CRMTiger', 'he_il', 'SalesHiker', 1),
            ('enter_url', 'Please Enter url', 'he_il', 'אנא הזן כתובת אתר', 1),
            ('help', 'Help', 'he_il', 'עזרה', 1),
            ('contact_us', 'Contact Us', 'he_il', 'תיצור איתנו קשר',1),
            ('updates', 'Updates', 'he_il', 'עדכונים', 1),
            ('logout', 'LogOut', 'he_il', 'להתנתק', 1),
            ('busnies_cardscanner', 'Business Card Scanner', 'he_il', 'סורק כרטיסי ביקור', 1),
            ('sure_want_logout', 'Are you sure want to logout ?', 'he_il', 'האם אתה בטוח שברצונך להתנתק?', 1),
            ('logout_message', 'Logout successfully', 'he_il', 'האם אתה בטוח שברצונך להתנתק?', 1),
            ('all', 'All', 'he_il', 'את כל', 1),
            ('add_event', 'Add event', 'he_il', 'הוסף אירוע', 1),
            ('add_task', 'Add Task', 'he_il', 'הוסף משימה', 1),
            ('next', 'Next', 'he_il', 'הבא', 1),
            ('terms_conditions', 'Terms and Conditions', 'he_il', 'Terms and Conditions', 1),
            ('login', 'Login', 'he_il', 'התחברות',2),
            ('privacy_policay', 'By logging in, you agree to our Terms and Conditions & Privacy Policy', 'he_il', 'על ידי כניסה, אתה מסכים לתנאים וההגבלות שלנו  מדיניות פרטיות',2),
            ('copyright', 'Copyright © 2019 CRMTiger Version', 'he_il', 'זכויות יוצרים © 2019 CRMTiger גירסה',2),
            ('enter_username', 'Please enter username', 'he_il', 'הזן שם משתמש', 2),
            ('enter_password', 'Please enter password', 'he_il', 'הזן סיסמה', 2),
            ('remanberme', 'Remember Me', 'he_il', 'זכור אותי', 2),
            ('forgot_password', 'Forgot password?', 'he_il', 'שכחת את הסיסמא?',2),
            ('privacy_policay1', 'Privacy Policy', 'he_il', 'מדיניות פרטיות', 2),
            ('contactsupportmsg', 'Something went wrong. \\n please Click here to contact support.', 'he_il', 'משהו השתבש אנא לחץ כאן ליצירת קשר עם התמיכה.',2),
            ('enter_username_password', 'Entered Username or Password is wrong', 'he_il', 'הזן שם משתמש או סיסמה שגוי', 2),
            ('server_issue_occured', 'Server issues occurred', 'he_il', 'אירעו בעיות בשרת', 2),
            ('password', 'Password', 'he_il', 'סיסמה', 3),
            ('user_name', 'Username', 'he_il', 'שם משתמש', 3),
            ('reset_pwd', 'Reset Password', 'he_il', 'לאפס את הסיסמה', 3),
            ('forgot_password_title', 'Forgot password', 'he_il', 'שכחת את הסיסמא', 3),
            ('enter_user_name', 'Enter user name', 'he_il', 'הכנס שם משתמש', 3),
            ('cc', 'Cc', 'he_il', 'עותק', 4),
            ('body', 'Body', 'he_il', 'גוף', 4),
            ('bcc', 'BCC', 'he_il', 'עותק מוסתר', 4),
            ('dialog_title_text_color', 'Select a Text Color', 'he_il', 'בחר צבע טקסט', 4),
            ('date', 'Date', 'he_il', 'תאריך', 4),
            ('subject', 'Subject', 'he_il', 'נושא', 4),
            ('composeMail', 'Compose Mail', 'he_il', 'כתוב דואר', 4),
            ('send', 'Send', 'he_il', 'שלח', 4),
            ('select_message', 'Select message', 'he_il', 'בחר הודעה', 4),
            ('title_insert_table', 'Insert Table', 'he_il', 'הכנס טבלה', 4),
            ('log_file_sms', 'I agree to Share API Log to Technical team for further troubleshooting', 'he_il', 'אני מסכים לשתף יומן API לצוות הטכני לפתרון בעיות נוספות',5),
            ('edit_record', 'Edit Records', 'he_il', 'ערוך רשומות', 5),
            ('select_time', 'Select Time', 'he_il', 'בחר שעה', 5),
            ('edit_item', 'Edit Item', 'he_il', 'ערוך פריט', 5),
            ('items_total', 'Items Total', 'he_il', 'פריטים סך הכל', 5),
            ('number_less_then_31', 'Number should be less than 31', 'he_il', 'המספר צריך להיות פחות מ -31', 5),
            ('users', 'Users', 'he_il', 'משתמשים', 5),
            ('groups', 'Groups', 'he_il', 'קבוצות', 5),
            ('txt_note_for_file', 'Note : Existing attachments(images/files) will be replaced', 'he_il','הערה: הקבצים המצורפים הקיימים (תמונות / קבצים) יוחלפו',5),
            ('greaterdatetime', 'End DateTime should be greater than Start DateTime', 'he_il', 'תאריך הסיום והשעה צריכים להיות גדולים מתאריך ההתחלה והשעה',5),
            ('until', 'Until', 'he_il', 'עד', 5),
            ('organizations', 'Organizations', 'he_il', 'ארגונים', 6),
            ('contacts', 'Contacts', 'he_il', 'אנשי קשר', 6),
            ('opportunity', 'Opportunity', 'he_il', 'הזדמנות', 6),
            ('lbl_sun', 'SUN', 'he_il', 'שמש', 7),
            ('lbl_mon', 'MON', 'he_il', 'MON', 7),
            ('lbl_tue', 'TUE', 'he_il', 'TUE', 7),
            ('lbl_wed', 'WED', 'he_il', 'להתחתן', 7),
            ('lbl_thu', 'THU', 'he_il', 'הו', 7),
            ('lbl_fri', 'FRI', 'he_il', 'FRI', 7),
            ('lbl_sat', 'SAT', 'he_il', 'ישבה', 7),
            ('lbl_1', '1', 'he_il', '1', 7),
            ('lbl_2', '2', 'he_il', '2', 7),
            ('lbl_3', '3', 'he_il', '3', 7),
            ('lbl_4', '4', 'he_il', '4', 7),
            ('lbl_5', '5', 'he_il', '5', 7),
            ('lbl_6', '6', 'he_il', '6', 7),
            ('lbl_7', '7', 'he_il', '7', 7),
            ('lbl_8', '8', 'he_il', '8', 7),
            ('lbl_9', '9', 'he_il', '9', 7),
            ('lbl_10', '10', 'he_il', '10', 7),
            ('lbl_11', '11', 'he_il', '11', 7),
            ('lbl_12', '12', 'he_il', '12', 7),
            ('lbl_13', '13', 'he_il', '13', 7),
            ('lbl_14', '14', 'he_il', '14', 7),
            ('lbl_15', '15', 'he_il', '15', 7),
            ('lbl_16', '16', 'he_il', '16', 7),
            ('lbl_17', '17', 'he_il', '17', 7),
            ('lbl_18', '18', 'he_il', '18', 7),
            ('lbl_19', '19', 'he_il', '19', 7),
            ('lbl_20', '20', 'he_il', '20', 7),
            ('lbl_21', '21', 'he_il', '21', 7),
            ('lbl_22', '22', 'he_il', '22', 7),
            ('lbl_23', '23', 'he_il', '23', 7),
            ('lbl_24', '24', 'he_il', '24', 7),
            ('lbl_25', '25', 'he_il', '25', 7),
            ('lbl_26', '26', 'he_il', '26', 7),
            ('lbl_27', '27', 'he_il', '27', 7),
            ('lbl_28', '28', 'he_il', '28', 7),
            ('lbl_29', '29', 'he_il', '29', 7),
            ('lbl_30', '30', 'he_il', '30', 7),
            ('lbl_31', '31', 'he_il', '31', 7),
            ('lbl_32', '32', 'he_il', '32', 7),
            ('lbl_33', '33', 'he_il', '33', 7),
            ('lbl_34', '34', 'he_il', '34', 7),
            ('lbl_35', '35', 'he_il', '35', 7),
            ('lbl_36', '36', 'he_il', '36', 7),
            ('lbl_37', '37', 'he_il', '37', 7),
            ('lbl_38', '38', 'he_il', '38', 7),
            ('lbl_39', '39', 'he_il', '39', 7),
            ('lbl_40', '40', 'he_il', '40', 7),
            ('lbl_41', '41', 'he_il', '41', 7),
            ('lbl_42', '42', 'he_il', '42', 7),
            ('current_date', 'current date', 'he_il', 'דייט נוכחי', 7),
            ('event', 'Events', 'he_il', 'אירועים', 7),
            ('calendar', 'Calendar', 'he_il', 'לוּחַ שָׁנָה', 7),
            ('latest_version', 'Latest Version :', 'he_il', 'הגרסה העדכנית ביותר :', 8),
            ('expire_on', 'Expire On :', 'he_il', 'תוקף בתאריך:', 8),
            ('ctmobile_ext_version', 'CTMobile Ext. Version :', 'he_il', 'CTMobile Ext. גרסה:', 8),
            ('you_have_latest_version', 'You already have latest version', 'he_il', 'יש לך גירסה מעודכנת', 8),
            ('latest_version1', 'You Already have latest version', 'he_il', 'כבר יש לך גרסה חדשה', 8),
            ('upgreaded', 'Upgrade', 'he_il', 'שדרג', 8),
            ('downgrade', 'Downgrade', 'he_il', 'שדרג לאחור', 8),
            ('dialog_recent_event_info', 'You can set from here how many number of records you want to show on Home screen for Recent Event.', 'he_il', 'תוכל להגדיר מכאן כמה מספר רשומות ברצונך להציג במסך דף הבית של אירוע עדכני .', 8),
            ('dialog_feedback_info', 'You can submit your feedback with description , our team will check your feedback and get back to you.', 'he_il', 'תוכל לשלוח את המשוב שלך בתיאור, הצוות שלנו יבדוק את המשוב שלך ויחזור אליך.', 8),
            ('dialog_log_info', 'Log functionality is used for customer support / help , If you are facing any issues in app or any module or functionality is not working proper then you can enable share log with our development team.', 'he_il','לוג פעילויות יעזור לאבחון תקלות ותמיכה טכנית, במידה ואתה ניתקל בתקלות אנא אפשר שמירת לוגים ושיתוף עם התמיכה .',8),
            ('info', 'Info', 'he_il', 'מידע', 8),
            ('recent_history', 'Recent History', 'he_il', 'היסטוריה אחרונה', 8),
            ('recent_feedback', 'Feedback', 'he_il', 'משוב אחרון', 8),
            ('recent_log', 'Log', 'he_il', 'התחבר', 8),
            ('crmtiger_app_version', 'CRMTiger App Version :', 'he_il', 'CRMTiger App גרסה:',8),
            ('historylimit', 'Recent History Limit', 'he_il', 'מגבלת ההיסטוריה האחרונה', 8),
            ('radious_in_miles', 'Radius in miles', 'he_il', 'רדיוס בקילומטרים', 8),
            ('recentlimit', 'Recent Event Limit', 'he_il', 'מגבלת אירועים אחרונים', 8),
            ('upcoming_events', 'Upcoming Events', 'he_il', 'אירועים קרובים', 8),
            ('rate_our_app', 'Rate Our App!', 'he_il', 'דרג את האפליקציה שלנו', 8),
            ('feedback', 'Submit Feedback', 'he_il', 'שלח משוב', 8),
            ('sendfeedback', 'Feedback Send', 'he_il', 'שלח משוב', 8),
            ('emaillimit', 'Email limit', 'he_il', 'גבלת דוא\"ל', 8),
            ('log', 'Log', 'he_il', 'התחבר', 8),
            ('logclear', 'Log cleared successfully.', 'he_il', 'נקה בהצלחה', 8),
            ('dialog_recent_history_info', 'You can set from here how many number of records you want to show on Home screen for Recent History.', 'he_il', 'תוכל להגדיר מכאן כמה מספר רשומות ברצונך להציג במסך דף הבית של היסטוריה עדכנית.', 8),
            ('proceed_to_upgrade1', 'Proceed to', 'he_il', 'המשך_לשדרוג 1', 8),
            ('upgradation_message', 'will required logout and login again later.', 'he_il', 'ידרש להתנתק ולהיכנס שוב מאוחר יותר.',8),
            ('proceed_to_upgrade', 'Proceed to Upgrade', 'he_il', 'המשך_אל_שדרוג', 8),
            ('module_setting', 'Module Setting', 'he_il', 'הגדרות מודול', 9),
            ('sortbyfield', 'Sort by field', 'he_il', 'מיין לפי שדה', 9),
            ('ascending', 'Ascending  A to Z', 'he_il', 'עולה א עד ת', 9),
            ('descending', 'Descending  Z to A', 'he_il', 'יורד ל - A', 9),
            ('first_field', 'First Field', 'he_il', 'שדה ראשון', 9),
            ('second_field', 'Second Field', 'he_il', 'שדה שני', 9),
            ('third_field', 'Third Field', 'he_il', 'שדה שלישי', 9),
            ('sure_want_restore', 'Are you sure you want to reset to default settings?', 'he_il', 'האם אתה בטוח שברצונך לשחזר את ברירת המחדל',9),
            ('orderlist', 'List Order', 'he_il', 'סדר רשימה', 9),
            ('module_reset', 'Restore to Default', 'he_il', 'אפס את ברירת המחדל', 9),
            ('display_fields', 'Display Fields', 'he_il', 'שדות תצוגה', 9),
            ('discount_lessthen_100', 'Discount % should be less than 100', 'he_il','הנחה של% צריכה להיות פחות מ -100', 10),
            ('select_item', 'Select Item', 'he_il', 'בחר פריט', 10),
            ('item_comment', 'Item Comment', 'he_il', 'הערה פריט', 10),
            ('record_name', 'Record Name is :', 'he_il', 'שם רשומה', 11),
            ('go_back', 'Go Back', 'he_il', 'תחזור', 11),
            ('please_enter_shortcut_name', 'Please Enter Shortcut Name', 'he_il', 'הזן שם קיצור', 11),
            ('number_not_found', 'Contact Number not found', 'he_il', 'מספר איש הקשר לא נמצא', 11),
            ('mail_not_found', 'Mail Address not found', 'he_il', 'כתובת הדואר לא נמצאה ', 11),
            ('create_shortcut', 'Create Shortcut', 'he_il', 'צור קיצור דרך', 11),
            ('contact_summary', 'Summary', 'he_il', 'סיכום', 11),
            ('activites', 'Activities', 'he_il', 'פעילויות', 11),
            ('details', 'Details', 'he_il', 'פרטים', 11),
            ('related', 'Related', 'he_il', 'קָשׁוּר', 11),
            ('share_link', 'Share record with', 'he_il', 'שתף קישור', 11),
            ('edit', 'Edit', 'he_il', 'ערוך', 11),
            ('duplicate', 'Duplicate', 'he_il', 'שכפל', 11),
            ('whatsapp', 'Whatsapp', 'he_il', 'וואצאפ', 11),
            ('call', 'Call', 'he_il', 'צלצל ', 11),
            ('choose_contact_for_call', 'Choose Contact for Call', 'he_il', 'בחר איש קשר לשיחה', 11),
            ('choose_contact_for_sms', 'Choose Contact for SMS', 'he_il', 'בחר איש קשר לסמס', 11),
            ('choose_contact_for_whatsapp', 'Choose Contact for WhatsApp', 'he_il', 'בחר איש קשר לוואצאפ', 11),
            ('chosse_contact_for_email', 'Choose Email', 'he_il', 'בחר איש קשר לדוא\"ל', 11),
            ('attach_file', 'Attach Files', 'he_il', 'צרף קובץ', 11),
            ('close', 'Close', 'he_il', 'סגור', 11),
            ('status', 'Status', 'he_il', 'סטטוס', 11),
            ('stop', 'Stop', 'he_il', 'עצור', 11),
            ('zero', '0', 'he_il', 'אפס', 11),
            ('record', 'Record', 'he_il', 'רשומה', 11),
            ('voice_note', 'Voice Note', 'he_il', 'הערה קולית', 11),
            ('tickets', 'Tickets', 'he_il', 'כרטיסים', 12),
            ('check_out', 'Check Out', 'he_il', 'לבדוק', 12),
            ('check_in', 'Check In', 'he_il', 'קבלה', 12),
            ('select_any', 'Select any', 'he_il', 'בחר בכל', 12),
            ('fulldetails', 'Show Full Details', 'he_il', 'הצג פרטים מלאים', 12),
            ('checkin', 'Check-in', 'he_il', 'קבלה', 12),
            ('navigate', 'Navigate', 'he_il', 'נווט', 12),
            ('product', 'Products', 'he_il', 'מוצרים', 12),
            ('projectMilestone', 'Project Milestone', 'he_il', 'אבן דרך בפרויקט', 12),
            ('projecttask', 'Project Tasks', 'he_il', 'משימה פרויקט', 12),
            ('nearby', 'NearBy', 'he_il', 'קרוב', 13),
            ('document', 'Document', 'he_il', 'מסמך', 14),
            ('reply', 'Reply', 'he_il', 'תשובה', 14),
            ('reply_all', 'Reply All', 'he_il', 'השב לכולם', 14),
            ('forward', 'Forward', 'he_il', 'קדימה', 14),
            ('action', 'Action', 'he_il', 'פעולה', 14),
            ('select_first', 'Select First', 'he_il', 'בחר ראשון', 14),
            ('commentaddsuccessful', 'Comment added successfull', 'he_il', 'הערה הוסף בהצלחה', 14),
            ('move_to', 'Move to', 'he_il', 'לעבור ל', 14),
            ('attach', 'Attach', 'he_il', 'צרף', 14),
            ('addcoment', 'Add Comment', 'he_il', 'הוסף תגובה', 14),
            ('adddocument', 'Add Document', 'he_il', 'הוסף מסמך', 14),
            ('home', 'Home', 'he_il', 'בית', 15),
            ('checkout', 'Check-out', 'he_il', 'לבדוק', 15),
            ('message_search', 'Search by name', 'he_il', 'חפש לפי שם', 15),
            ('start_shift', 'Start shift', 'he_il', 'התחל התחל', 15),
            ('end_shift', 'End shift', 'he_il', 'סוף משמרת', 15),
            ('today_meeting', 'Meetings', 'he_il', 'מפגשים', 15),
            ('shift_time_track', 'Shift Time Track', 'he_il', 'זמן Shift מסלול', 15),
            ('logout_msg', 'You have to login again , click', 'he_il', 'עליך להתחבר שוב, לחץ', 15),
            ('logout_msg1', 'to continue.', 'he_il', 'להמשיך.', 15),
            ('permission_denied', 'You don\'t have permission to create', 'he_il', 'אין לך הרשאה ליצור', 15),
            ('history', 'Activity stream', 'he_il', 'זרם פעילות', 15),
            ('search_value', 'Search value :', 'he_il', 'ערך לחיפוש', 15),
            ('feed_back_msg', 'Please enter feedback message', 'he_il', 'הזן הודעת משוב', 16),
            ('feed_back_hint_msg', 'Enter feedback message', 'he_il', 'הזן הודעת משוב', 16),
            ('submit', 'Submit', 'he_il', 'שלח', 16),
            ('check_app_not_installed', 'Application is not currently installed.', 'he_il', 'היישום אינו מותקן כרגע.', 17),
            ('send_sms_fail_message', 'SMS failed, please try again later!', 'he_il', 'נכשל ב- SMS, נסה שוב מאוחר יותר!',17),
            ('documentaddsuccessfully', 'Document Attach successfully', 'he_il', 'המסמך מצורף בהצלחה', 17),
            ('send_message', 'Send message', 'he_il', 'שלח הודעה', 17),
            ('sms_to', 'smsto:', 'he_il', 'סמס אל', 17),
            ('add_list_message', 'Add List', 'he_il', 'הוסף רשימה', 18),
            ('mylist', 'My List', 'he_il', 'הרשימה שלי', 18),
            ('filtername', 'Filter Name', 'he_il', 'שם סינון', 18),
            ('selectlist', 'Select a List', 'he_il', 'בחר רשימה *', 18),
            ('assingedto', 'Assigned To', 'he_il', 'שהוקצה ל *', 18),
            ('selectmodule', 'Select a module', 'he_il', 'בחר מודול', 18),
            ('add_list', 'Add Filter', 'he_il', 'הוסף רשימה', 18),
            ('recent_event', 'Recent Event', 'he_il', 'מגבלת אירועים אחרונים', 19),
            ('recent_hostory', 'Recent History', 'he_il', 'היסטוריה אחרונה', 19),
            ('module_specific_settings', 'Module-Specific Settings', 'he_il', 'הגדרות ספציפיות למודול', 19),
            ('talk_to_us', 'Talk to us', 'he_il', 'דבר איתנו', 19),
            ('report_a_bug', 'Report A Bug', 'he_il', 'דווח על באג', 19),
            ('faq', 'FAQ', 'he_il', 'שאלות נפוצות', 19),
            ('selectmodules', 'Select Module', 'he_il', 'בחר מודול', 19),
            ('myplan', 'My Plan', 'he_il', 'התוכנית שלי', 19),
            ('message', 'Message', 'he_il', 'הודעה', 20),
            ('message_validation', 'Please enter Message', 'he_il', 'הזן הודעה', 20),
            ('contact_select', 'Please Select contact', 'he_il', 'אנא בחר איש קשר', 20),
            ('global_search', 'Global Search', 'he_il', 'חיפוש גלובלי', 21),
            ('records', 'Records', 'he_il', 'רשומות', 21),
            ('dont_show_again', 'Don\'t Show Again', 'he_il', 'אל תציג שוב', 22),
            ('skip', 'Skip', 'he_il', 'דלג', 22),
            ('file_downloading', 'File Downloading', 'he_il', 'הורדת קובץ', 23),
            ('add_screenshots_optional', 'Add screenshots (optional)', 'he_il', 'הוספת צילומי מסך (אופציונלי)', 24),
            ('describe_your_problem', 'Describe your problem', 'he_il', 'תאר את הבעיה שלך', 24),
            ('default_filter_shortcut', 'Default Filter Shortcut', 'he_il', 'קיצור לברירת מחדל למסנן', 25),
            ('record_shortcut', 'Record Shortcut', 'he_il', 'קיצור לרשומה', 25),
            ('enter_url', 'Please Enter url', 'he_il', 'הזן כתובת אתר', 26),
            ('new_version_is_avaiable', 'You need to update the app to continue using Please update to continue Older versions will no longer work from today', 'he_il', 'עליך לעדכן את האפליקציה כדי להמשיך להשתמש אנא עדכן כדי להמשיך גרסאות ישנות יותר לא יעבדו עוד מהיום', 26),
            ('search_by', 'Search by', 'he_il', 'חפש לפי', 27),
            ('selected_filter', 'Selected filter :', 'he_il', 'מסנן נבחר: -', 27),
            ('selected_field', 'Selected field :', 'he_il', 'שדה נבחר: -', 27),
            ('choose', 'Choose', 'he_il', 'בחר', 28),
            ('qr_cardscanner', 'QR Code Scanner', 'he_il', 'סורק קוד QR', 28),
            ('error_message_for_scan', 'Could not read the card Try again later.', 'he_il', 'לא ניתן היה לקרוא את הכרטיס נסה שוב מאוחר יותר', 28),
            ('press_start_scan', 'Press to Start Scan', 'he_il', 'לחץ כדי להתחיל בסריקה', 28),
            ('line_item_quntity_validation_msg', 'Value should be greater than zero', 'he_il', 'הערך צריך להיות גדול מאפס', 29),
            ('percentage_msg', 'Percentage should be less than 100', 'he_il', 'האחוז צריך להיות פחות מ 100', 29),
            ('MSG_NO_DATA', 'No data found!', 'he_il', 'לא נמצאו נתונים!', 29),
            ('MSG_SOMETHING_WRONG', 'Something went wrong!', 'he_il', 'משהו השתבש', 29),
            ('MSG_COMING_SOON', 'Coming Soon!', 'he_il', 'בקרוב!', 29),
            ('MSG_UPLOAD_PROFILE_IMAGE', 'Please upload profile image.', 'he_il', 'אנא העלה תמונת פרופיל.', 29),
            ('ALERT_TITLE_LOCATION_ACCESS', 'Location Access', 'he_il', 'גישה למיקום', 29),
            ('ALERT_MSG_LOCATION_ACCESS', 'Requires your location to show nearby events.', 'he_il', 'מחייב את המיקום שלך כדי להציג אירועים בקרבת מקום.', 29),
            ('ALERT_BTN_ALLOW', 'ALLOW', 'he_il', 'התר', 29),
            ('ALERT_BTN_DENY', 'DENY', 'he_il', 'דחה', 29),
            ('ALERT_MSG_LOCATION_SETTING', 'Not able to fetch your current location. Please check your location settings.', 'he_il', 'לא מצליח לאחזר את המיקום הנוכחי שלך. אנא בדוק את הגדרות המיקום שלך.', 29),
            ('DELETE_RECORD', 'Delete Record', 'he_il', 'מחק רשומה', 29),
            ('ALERT_MSG_DELETE_SHORTCUT', 'Are you sure want to delete this shortcut?', 'he_il', 'האם אתה בטוח שברצונך למחוק קיצור דרך זה?', 29),
            ('DELETE_SHORTCUT', 'Delete Shortcut', 'he_il', 'מחק קיצור דרך', 29),
            ('LBL_TERMS', 'By logging in, you agree to our Terms and', 'he_il', 'על ידי התחברות, אתה מסכים לתנאים שלנו', 29),
            ('LBL_CONDITIONS', 'Conditions &', 'he_il', 'והתנאים', 29),
            ('ALERT_TITLE', 'Alert', 'he_il', 'אַזעָקָה', 29),
            ('ALERT_BTN_SUBSCRIBE', 'Subscribe', 'he_il', 'הירשם כמנוי', 29),
            ('MSG_SELECT_MODULE', 'Please select any Module', 'he_il', 'אנא בחר כל מודול', 29),
            ('MSG_SELECT_LIST', 'Please select any List', 'he_il', 'אנא בחר רשימה כלשהי', 29),
            ('ALERT_MSG_DONT_HAVE_CAMERA', 'You don\'t have camera', 'he_il', 'אין לך מצלמה', 29),
            ('ALERT_MSG_GALLARY_PERMISSION', 'You don\'t have permission to access gallery.', 'he_il', 'אין לך הרשאה לגשת לגלריה.', 29),
            ('ALERT_MSG_CAMERA_PERMISSION', 'You don\'t have permission to access camera. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Camera on', 'he_il', 'אין לך הרשאה לגשת למצלמה. עבור להגדרה -> גלול לתחתית ובחר יישום CRMTiger -> הפעל מצלמה', 29),
            ('ALERT_MSG_SPEECH_PERMISSION', 'You don\'t have permission to access Speech Recognition. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Speech Recognition on', 'he_il', 'אין לך הרשאה לגשת לזיהוי דיבור. עבור להגדרה -> גלול לתחתית ובחר יישום CRMTiger -> הפעל זיהוי דיבור', 29),
            ('BTN_DONE', 'Done', 'he_il', 'בוצע', 29),
            ('COMMENT', 'Comment', 'he_il', 'הערה', 29),
            ('FULL_FORM', 'Full Form', 'he_il', 'טופס מלא', 29),
            ('QUICK_CREATE', 'Create', 'he_il', 'צור', 29),
            ('LBL_SELECT_FIELDS', 'Select Fields', 'he_il', 'בחר שדות', 29),
            ('LBL_SELECT_FIELDS', 'Select Fields', 'he_il', 'בחר שדות', 29),
            ('LBL_SELECT_FIRST_FIELDS', 'Select First Field', 'he_il', 'בחר שדה ראשון', 29),
            ('LBL_SELECT_SECOND_FIELDS', 'Select Second Field', 'he_il', 'בחר שדה שני', 29),
            ('LBL_SELECT_THIRD_FIELDS', 'Select Third Field', 'he_il', 'בחר שדה שלישי', 29),
            ('LBL_SORT_BY_FIELD', 'Select Sort By Field', 'he_il', 'בחר מיון לפי שדה', 29),
            ('BTN_RESET_TO_DEFAULT', 'Reset to Default', 'he_il', 'אפס לברירת מחדל', 29),
            ('MSG_SELECT_SORT_BY_FIELD', 'Select Sort by field', 'he_il', 'בחר מיון לפי שדה', 29),
            ('kStrClearBtnTitle', 'Clear', 'he_il', 'נקה', 29),
            ('kStrShowMoreBtnTitle', 'Show More', 'he_il', 'להראות יותר', 29),
            ('kStrAddActivitiesBtnTitle', 'Add Activities', 'he_il', 'הוסף פעילויות', 29),
            ('kStrAddCommentPlaceHolder', 'Add your comments here', 'he_il', 'הוסף את הערותיך כאן', 29),
            ('MSG_ENTER_TO_EMAIL', 'Please enter to field.', 'he_il', 'אנא הכנס לשדה.', 29),
            ('WARNING_FILE', 'File can\'t open.', 'he_il', 'הקובץ לא יכול להיפתח.', 29),
            ('MSG_FILE_SAVED', 'File saved.', 'he_il', 'הקובץ נשמר.', 29),
            ('WARNING_DOWNLOAD_FAIL', 'Download fail!, please try after sometime.', 'he_il', 'ההורדה נכשלה!, אנא נסה לאחר זמן מה.', 29),
            ('LBL_SHORTCUT', 'Shortcut', 'he_il', 'קיצור דרך', 29),
            ('TXT_MESSAGE_PLACEHOLDER', 'Type Message', 'he_il', 'הקלד הודעה', 29),
            ('ALERT_INSTALL_WHATSAPP', 'Install Whatsapp', 'he_il', 'התקן את Whatsapp', 29),
            ('MSG_NO_MAIL_BOX', 'No MailBox found. Please Create Mailbox', 'he_il', 'No MailBox found. Please Create Mailbox', 29),
            ('LBL_WROTE', 'Wrote', 'he_il', 'כתב', 29),
            ('MSG_MAIL_SEND', 'Mail sent', 'he_il', 'דואר נשלח', 29),
            ('log_file_not_found', 'API Log file not found.', 'he_il', 'קובץ יומן API לא נמצא.', 29),
            ('unknown_error', 'An unknown error occurred, try again', 'he_il', 'אירעה שגיאה לא ידועה, נסה שוב', 29),
            ('CTMTigerAppVersion', 'CRMTiger App Version', 'he_il', 'גרסת יישום CRMTiger', 29),
            ('CTMMobileUpdateMsg', 'CTMobile Ext. Version Update Successfully', 'he_il', 'CTMobile Ext. עדכון הגרסה בוצע  בהצלחה', 29),
            ('dialog_Premium_downgrade', 'Downgrade will required logout and login again later', 'he_il', 'שנמוך  ידרוש להתנתק ולהיכנס שוב מאוחר יותר', 29),
            ('dialog_Premium', 'Upgrade will required logout and login again later', 'he_il', 'שדרוג יידרש להתנתק ולהיכנס שוב מאוחר יותר', 29),
            ('Overwrite', 'Overwrite', 'he_il', 'שכתוב', 29),
            ('MSGAddressOverwrite1', 'Overwrite the existing address with the selected', 'he_il', 'החלף את הכתובת הקיימת באמצעות הנבחר', 29),
            ('MSGAddressOverwrite2', 'address details?', 'he_il', 'פרטי כתובת?', 29),
            ('UPGRADE_PLAN', 'Upgrade Plan', 'he_il', 'תוכנית שדרוג', 29),
            ('DOWNGRADE_PLAN', 'Downgrade Plan', 'he_il', 'תוכנית שנמוך', 29),
            ('UPGRADE_EXTENSION', 'Upgrade Extension', 'he_il', 'שדרוג סיומת', 29),
            ('UPGRADE_APP', 'Upgrade App', 'he_il', 'שדרג את האפליקציה', 29),
            ('SELECT_OPTION', 'Select Option', 'he_il', 'בחר אפשרות', 29),
            ('PLEASE_SELECT', 'Please select', 'he_il', 'בבקשה תבחר', 29),
            ('MSG_ACCESS_DENIED', 'You don\'t have permission for this module.', 'he_il', 'אין לך הרשאה למודול זה.', 29),
            ('MSG_SELECT_RECCURING_MONTH_DAY', 'Please select reccuring day of month.', 'he_il', 'בחר יום חוזר בחודש.', 29),
            ('MSG_SELECT_RECCURING_WEEK_DAY', 'Please select reccuring day of week.', 'he_il', 'אנא בחר ביום בשבוע החוזר.', 29),
            ('MSG_SELECT_RECCURING_DAYS', 'Please select reccuring days.', 'he_il', 'אנא בחר ימים חוזרים.', 29),
            ('Please select reccuring days.', 'Please select reccuring days.', 'he_il', 'אנא בחר ימים חוזרים.', 29),
            ('MSG_SELECT_RECCURING_END_DATE', 'Please select reccuring end date.', 'he_il', 'אנא בחר תאריך סיום חוזר.', 29),
            ('MSG_SELECT_RECCURING_TYPE', 'Please select reccuring type.', 'he_il', 'אנא בחר סוג חוזר.', 29),
            ('FREQ_TIME', 'Times', 'he_il', 'זמנים', 29),
            ('REPEAT_YEARLY', 'Repeat Yearly', 'he_il', 'חזור על פעולה שנתית', 29),
            ('REPEAT_MONTHLY', 'Repeat Monthly', 'he_il', 'חזור על חודשי', 29),
            ('REPEAT_WEEKLY', 'Repeat Weekly', 'he_il', 'חזור על שבועי', 29),
            ('REPEAT_DAILY', 'Repeat Daily', 'he_il', 'חזור על כך מדי יום', 29),
            ('ACTION_TITLE', 'Action Title', 'he_il', 'כותרת פעולה', 29),
            ('MSG_SELECT_VALID_DATE', 'Please select valid day of month.', 'he_il', 'בחר יום חוקי תקף.', 29),
            ('MSG_SELECT_VALID_START_DATE', 'Start date should be less than end date.', 'he_il', 'תאריך ההתחלה צריך להיות פחות מתאריך הסיום.', 29),
            ('MSG_SELECT_VALID_START_TIME', 'Start time should be less than end time.', 'he_il', 'זמן ההתחלה צריך להיות פחות משעת הסיום.', 29),
            ('LBL_LINEITEM_DETAILS', 'Lineitem Details', 'he_il', 'Lineitem Details', 29),
            ('MSG_INVALIDE_DISCOUNT_AMOUNT', 'Discount amount should be less than the total.', 'he_il', 'סכום ההנחה צריך להיות פחות מהסך הכל.', 29),
            ('VIEW', 'View', 'he_il', 'צפה', 29),
            ('MSG_ENTER_VALID', 'Please enter valid', 'he_il', 'אנא הכנס חוקי', 29),
            ('MSG_ENTER_PERCENTAGE', 'Percentage should be less than 100.', 'he_il', 'האחוז צריך להיות פחות מ 100.', 29),
            ('ITEM_TOTAL', 'Item Total', 'he_il', 'פריט כולל', 29),
            ('ADJUSTMENT', 'Adjustment', 'he_il', 'התאמה', 29),
            ('TITLE_CHOOSE_IMAGE', 'Choose Image', 'he_il', 'בחר תמונה', 29),
            ('COMPRESS', 'Compress', 'he_il', 'דחוס', 29),
            ('CHOOSE_ANOTHER_IMAGE', 'Your image size is too large, please select another image', 'he_il', 'גודל התמונה שלך גדול מדי, בחר תמונה אחרת', 29),
            ('OnDayOfMonth', 'On day of month', 'he_il', 'ביום בחודש', 29),
            ('OnDayOfWeek', 'On day of week', 'he_il', 'ביום בשבוע', 29),
            ('AddAndClose', 'Add & Close', 'he_il', 'הוסף וסגור', 29),
            ('Repeat', 'Repeat', 'he_il', 'חזור', 29),
            ('OnDay', 'On day', 'he_il', 'ביום', 29),
            ('View_Line_Item', 'View Line Item', 'he_il', 'הצג פריט שורה', 29),
            ('TITLE_IMAGE', 'Image', 'he_il', 'תמונה', 29),
            ('TITLE_ICLOUD', 'iCloud', 'he_il', 'iCloud', 29),
            ('GOOGLE', 'Google', 'he_il', 'Google', 29),
            ('ALERT_BTN_OKAY', 'Okay', 'he_il', 'בסדר', 29),
            ('ALERT_TITLE_ACCESS_DENIED', 'Access Denied', 'he_il', 'גישה נדחתה', 29),
            ('Dont_Show_Again', 'Don\'t show again', 'he_il', 'אל תראה שוב', 29),
            ('Skip', 'Skip', 'he_il', 'דלג', 29),
            ('Fillter_Name', 'Fillter Name', 'he_il', 'שם המסנן', 29),
            ('Fillter_Record_Count', 'Fillter Record Count', 'he_il', 'סינון ספירת רשומות', 29),
            ('url_note',      'Note : if your URL of CRM is https://example.com/crm enter that into above box',   'he_il',    'Note : if your URL of CRM is https://example.com/crm enter that into above box',   31),
            ('vtiger_url',    'Your vTiger CRM URL',  'he_il',    'Your vTiger CRM URL',  31),
            ('msg_doc_read_permission',   'You don\'t have permission to Add either This is read-only or Private Field.',     'he_il',    'You don\'t have permission to Add either This is read-only or Private Field.',     31),
            ('CLEAR',   'Clear',    'he_il',    'נקה',    31),
            ('Files/photos uploaded successfully',    'Files/photos uploaded successfully',     'he_il',    'קבצים / תמונות הועלו בהצלחה',     32),
            ('Digital signature saved',   'Digital signature saved',    'he_il',    'חתימה דיגיטלית נשמרה',    32),
            ('Please upload Signature or Files/photos',     'Please upload Signature or Files/photos',      'he_il',    'אנא העלה חתימה או קבצים / תמונות',      32),
            ('Files / Photos',      'Files / Photos', 'he_il',    'קבצים \ תמונות', 32),
            ('Signature',     'Signature',      'he_il',    'חתימה',      32),
            ('add_photo_using',     'Add Photo Using',      'he_il',    'הוסף תמונה באמצעות',      31),
            ('btn_upload_sign',     '(+) Add Signature',    'he_il',    '(+) הוסף חתימה',    31),
            ('btn_upload_photo_doc',      '(+) Upload Files/Photos',    'he_il',    '(+) העלה קבצים / תמונות',    31),
            ('select_photo_doc_to_upload',      'Please select files/photos to upload',   'he_il',    'אנא בחר קבצים / תמונות להעלאה',   31),
            ('related_module_title',      'Search from related module and Add to \"Route\"',    'he_il',    'חפש ממודול קשור והוסף ל\"נתיב \"',    30),
            ('Route status updated successfully',     'Route status updated successfully',      'he_il',    'סטטוס המסלול עודכן בהצלחה',      32),
            ('Session init failed', 'Session init failed',  'he_il',    'ההפעלה של Session  נכשלה',  32),
            ('You don\'t have permission to access this resource',      'You don\'t have permission to access this resource', 'he_il',    'אין לך הרשאה לגשת למשאב זה', 32),
            ('ctroute_realtedto cannot be empty',     'Could not get the Related To - Try again later',     'he_il',    'לא הצלחנו להשיג את הקשור ל - נסה שוב מאוחר יותר',     32),
            ('ctroute_planning cannot be empty',      'Could not get the Route Planning Record - Try again later',      'he_il',    'לא ניתן היה להשיג את רשומת תכנון המסלול - נסה שוב מאוחר יותר',      32),
            ('Something went wrong - Try again later',      'Something went wrong - Try again later', 'he_il',    'משהו השתבש - נסה שוב מאוחר יותר', 32),
            ('sequence updated successfully',   'sequence updated successfully',    'he_il',    'הרצף עודכן בהצלחה',    32),
            ('sequence cannot be empty',  'sequence cannot be empty',   'he_il',    'רצף לא יכול להיות ריק',   32),
            ('Shortcut details not saved',      'Shortcut details not saved', 'he_il',    'פרטי קיצור הדרך לא נשמרו בהצלחה', 32),
            ('Shortcut details saved successfully',   'Shortcut details saved successfully',    'he_il',    'פרטי קיצור הדרך נשמרו בהצלחה',    32),
            ('Route save successfully',   'Route save successfully',    'he_il',    'שמירת מסלול בהצלחה',    32),
            ('Record save successfully',  'Record save successfully',   'he_il',    'הרשומה נשמרה בהצלחה',   32),
            ('No dependency found for picklist',      'No dependency found for picklist', 'he_il',    'לא נמצאה תלות ברשימת הבחירה', 32),
            ('No records found',    'No records found',     'he_il',    'לא נמצאה רשומה',     32),
            ('Outgoing server is not enabled, please configure from CRM',     'Outgoing server is not enabled, please configure from CRM',      'he_il',    'השרת היוצא אינו מופעל, אנא הגדר מתוך CRM',      32),
            ('Removed Successfully',      'Removed Successfully', 'he_il',    'הוסר בהצלחה', 32),
            ('Shortcut has been deleted', 'Shortcut has been deleted',  'he_il',    'קיצור דרך נמחק',  32),
            ('relation of records removed successfully',    'relation of records removed successfully',     'he_il',    'יחס הרשומות הוסר בהצלחה',     32),
            ('relation of records not removed', 'relation of records not removed',  'he_il',    'יחס הרשומות לא הוסר',  32),
            ('Record has been deleted successfully',  'Record has been deleted successfully',   'he_il',    'רשומה נמחקה בהצלחה',   32),
            ('Time Tracking saved successfully',      'Time Tracking saved successfully', 'he_il',    'מעקב הזמן נשמר בהצלחה', 32),
            ('Time Tracking updated successfully',    'Time Tracking updated successfully',     'he_il',    'מעקב אחר הזמן עודכן בהצלחה',     32),
            ('Time Tracking ended successfully',      'Time Tracking ended successfully', 'he_il',    'מעקב אחר זמן הסתיים בהצלחה', 32),
            ('Time Tracking started successfully',    'Time Tracking started successfully',     'he_il',    'מעקב אחר זמן התחיל בהצלחה',     32),
            ('record cannot be empty',    'record cannot be empty',     'he_il',    'רשומה לא יכולה להיות ריקה',     32),
            ('Module is disabled',  'Module is disabled',   'he_il',    'המודול מושבת',   32),
            ('Shift ended successfully',  'Shift ended successfully',   'he_il',    'משמרת הסתיימה בהצלחה',   32),
            ('Shift started successfully',      'Shift started successfully', 'he_il',    'משמרת התחילה בהצלחה', 32),
            ('relation of records added successfully',      'relation of records added successfully', 'he_il',    'יחס הרשומות נוסף בהצלחה', 32),
            ('Comment saved successfully',      'Comment saved successfully', 'he_il',    'הערה נשמרה בהצלחה', 32),
            ('Comment not saved',   'Comment not saved',    'he_il',    'הערה לא נשמרה',    32),
            ('Comment module is not active',    'Comment module is not active',     'he_il',    'מודול ההערות אינו פעיל',     32),
            ('No Upcoming Event',   'No Upcoming Event',    'he_il',    'אין אירוע קרוב',    32),
            ('No Templates found - create it from Message Templates module',  'No Templates found - create it from Message Templates module',   'he_il',    'לא נמצאו תבניות - צור אותן ממודול תבניות ההודעות',   32),
            ('No event or task for this date',  'No event or task for this date',   'he_il',    'אין אירוע או משימה לתאריך זה',   32),
            ('No filters created',  'No filters created',   'he_il',    'לא נוצרו פילטרים',   32),
            ('Select at least one record to attach',  'Select at least one record to attach',   'he_il',    'בחר רשומה אחת לפחות לצרף',   32),
            ('Please select one or more attachments', 'Please select one or more attachments',  'he_il',    'בחר קובץ מצורף אחד או יותר',  32),
            ('No event for this month',   'No event for this month',    'he_il',    'אין אירוע לחודש זה',    32),
            ('No Activity found',   'No Activity found',    'he_il',    'לא נמצאה פעילות',    32),
            ('Your feedback is valuable for us - it cannot be empty',   'Your feedback is valuable for us - it cannot be empty',    'he_il',    'המשוב שלך הוא בעל ערך רב עבורנו - הוא לא יכול להיות ריק',    32),
            ('Could not send mail, Please try later', 'Could not send mail, Please try later',  'he_il',    'לא ניתן היה לשלוח דואר. אנא נסה מאוחר יותר',  32),
            ('Latest Version updated successfully',   'Latest Version updated successfully',    'he_il',    'הגרסה האחרונה עודכנה בהצלחה',    32),
            ('User Location Updated Successfully',    'User Location Updated Successfully',     'he_il',    'מיקום המשתמש עודכן בהצלחה',     32),
            ('User Location not Updated Successfully',      'User Location not Updated Successfully', 'he_il',    'מיקום המשתמש לא עודכן בהצלחה', 32),
            ('SMSNotifier is not enable in CRM. Please enable it first',      'SMSNotifier is not enable in CRM. Please enable it first', 'he_il',    'SMSNotifier אינו מופעל ב- CRM. אנא הפעל אותו תחילה', 32),
            ('Could not submit your feedback - Please try again later', 'Could not submit your feedback - Please try again later',  'he_il',    'לא ניתן היה להגיש את המשוב שלך - נסה שוב מאוחר יותר',  32),
            ('Thank you for submitting your feedback',      'Thank you for submitting your feedback', 'he_il',    'תודה שהגשת את המשוב שלך', 32),
            ('Please upload User Image',  'Please upload User Image',   'he_il',    'אנא העלה תמונת משתמש',   32),
            ('Image Not Uploading, please try again', 'Image Not Uploading, please try again',  'he_il',    'התמונה לא הועלתה, נסה שוב',  32),
            ('User Image Uploaded Successfully',      'User Image Uploaded Successfully', 'he_il',    'תמונת משתמש הועלתה בהצלחה', 32),
            ('Invalid Module name', 'Invalid Module name',  'he_il',    'שם מודול לא חוקי',  32),
            ('Records Sync Successfully', 'Records Sync Successfully',  'he_il',    'סינכרון רשומות בוצע בהצלחה',  32),
            ('Values cannot be empty',    'Values cannot be empty',     'he_il',    'הערכים לא יכולים להיות ריקים',     32),
            ('Record id is empty',  'Record id is empty',   'he_il',    'הרשומה ריקה',   32),
            ('Logout Successfully', 'Logout Successfully',  'he_il',    'התנתק בהצלחה',  32),
            ('Please Enable CTMobile Module',   'Please Enable CTMobile Module',    'he_il',    'אנא הפעל את מודול CTMobile',    32),
            ('Authentication Failed',     'Username and Password do not match',     'he_il',    'שם המשתמש והסיסמא לא תואמים',     32),
            ('Mismatched module information',   'Something gone wrong, please try again later', 'he_il',    'משהו השתבש, נסה שוב מאוחר יותר', 32),
            ('Field does not exists',     'Please set display fields again',  'he_il',    'אנא הגדר שוב שדות תצוגה',  32),
            ('Module does not exists',    'Module does not exists or disabled by admin',  'he_il',    'המודול אינו קיים או מושבת על ידי מנהל המערכת',  32),
            ('Month cannot be empty',     'Could not get the Month - Try again later',    'he_il',    'לא ניתן היה לקבל את החודש - נסה שוב מאוחר יותר',    32),
            ('Year cannot be empty',      'Could not get the Year - Try again later',     'he_il',    'לא הצלחנו להשיג את השנה - נסה שוב מאוחר יותר',     32),
            ('Date cannot be empty',      'Could not get the Date - Try again later',     'he_il',    'לא ניתן היה להשיג את התאריך - נסה שוב מאוחר יותר',     32),
            ('Userid cannot be empty',    'Could not get the Userid - Try again later',   'he_il',    'לא ניתן היה להשיג את User id - נסה שוב מאוחר יותר',   32),
            ('End Date cannot be empty',  'Could not get the status - Try again later',   'he_il',    'לא ניתן היה לקבל את הסטטוס - נסה שוב מאוחר יותר',   32),
            ('Start Date cannot be empty',      'Could not get the Start Date - Try again later',     'he_il',    'לא ניתן היה לקבל את תאריך ההתחלה - נסה שוב מאוחר יותר',     32),
            ('You do not configure SMS Notifier in CRM. Please configure SMS Notifier in your CRM to use this feature', 'You do not configure SMS Notifier in CRM. Please configure SMS Notifier in your CRM to use this feature',  'he_il',    'אינך מגדיר את התראה SMS ב- CRM. אנא הגדר את התראה SMS ב- CRM שלך לשימוש בתכונה זו',  32),
            ('Longitude cannot be empty', 'Could not get location-Please try again',      'he_il',    'לא ניתן היה לקבל מיקום - אנא נסה שוב',      32),
            ('Latitude cannot be empty',  'Could not get location-Please try again',      'he_il',    'לא ניתן היה לקבל מיקום - אנא נסה שוב',      32),
            ('User cannot be empty',      'Could not get the User - Try again later',     'he_il',    'לא ניתן היה להשיג את המשתמש - נסה שוב מאוחר יותר',     32),
            ('Status cannot be empty',    'Could not get the status - Try again later',   'he_il',    'לא ניתן היה לקבל את הסטטוס - נסה שוב מאוחר יותר',   32),
            ('Required fields not found', 'Required fields not found',  'he_il',    'לא נמצאו שדות חובה',  32),
            ('Tracking module not active',      'Tracking module not active-Please contact CRM Admin',      'he_il',    'מודול המעקב אינו פעיל - אנא צרו קשר עם מנהל המערכת של CRM',      32),
            ('Missing mandatory input values',  'Missing mandatory input values',   'he_il',    'חסר ערך חובה',   32),
            ('No MailBox found. Please Create Mailbox',     'No MailBox found. Please Create Mailbox',      'he_il',    'לא נמצא תיבת דוא\"ל. אנא צור תיבה',      32),
            ('Mail not sent', 'Mail not sent',  'he_il',    'הדוא\"ל לא נשלח',  32),
            ('Mail send successfully',    'Mail send successfully',     'he_il',    'הדוא\"ל נשלח בהצלחה',     32),
            ('Email Id or username not match with your record',   'Email Id or username not match with your record',    'he_il',    'מזהה האימייל או שם המשתמש לא תואמים את הרשומה שלך',    32),
            ('Module not specified',      'Module not specified', 'he_il',    'המודול לא צוין', 32),
            ('No messages found',   'No messages found',    'he_il',    'לא נמצאו הודעות',    32),
            ('No Dependency Found For This Module',   'No Dependency Found For This Module',    'he_il',    'לא נמצאה תלות במודול זה',    32),
            ('Outgoing server is not Enabled',  'Outgoing server is not Enabled',   'he_il',    'השרת היוצא  אינו מופעל',   32),
            ('Outgoing server is Enabled',      'Outgoing server is Enabled', 'he_il',    'השרת היוצא מופעל', 32),
            ('Email Attached Successfully',     'Email Attached Successfully',      'he_il',    'הדוא\"ל צורף בהצלחה',      32),
            ('Documents Attached Successfully', 'Documents Attached Successfully',  'he_il',    'המסמכים צורפו בהצלחה',  32),
            ('Login required - Please login again',   'Login required - Please login again',    'he_il',    'חובה להתחבר - אנא התחבר שוב',    32),
            ('time_tracking_module_disable',    'Time tracking module is disable',  'he_il',    'מודול מעקב אחר זמן מושבת',  31),
            ('route_planning_module_disable',   'Route planning module is disable', 'he_il',    'מודול תכנון מסלול מושבת', 31),
            ('mark_as_held',  'Are you sure you want to mark Event as Held?', 'he_il',    'האם אתה בטוח שברצונך לסמן את האירוע כמוחזק?', 31),
            ('stop_timer_msg',      'You have already started Time tracking for another record, Do you want to stop it first ?',    'he_il',    'כבר התחלת במעקב אחר זמן עבור רשומה אחרת, האם ברצונך לעצור אותה תחילה?',    31),
            ('access_denied_routeplanning',     'Access denied for route planning', 'he_il',    'הגישה נדחתה לצורך תכנון המסלול', 31),
            ('time_spent',    'Time Spent',     'he_il',    'זמן ששומש',     31),
            ('select_user',   'Select User',    'he_il',    'בחר משתמש',    30),
            ('status_cannot_be_held',     'Status cannot be held for future date start',  'he_il',    'לא ניתן להחזיק סטטוס לתחילת תאריך עתידי',  30),
            ('please_select_end_date',    'Please select end date',     'he_il',    'אנא בחר תאריך סיום',     30),
            ('please_select_start_date',  'Please select start date',   'he_il',    'אנא בחר תאריך התחלה',   30),
            ('tap_on_plus_icon_for_select_route',     'Tap on + icon to select record for your route.',     'he_il',    'הקש על סמל + כדי לבחור רשומה לנתיב  שלך.',     30),
            ('please_enter_notes',  'Please enter notes',   'he_il',    'אנא הכנס הערות',   30),
            ('please_enter_title',  'Please enter title',   'he_il',    'אנא הכנס כותרת',   30),
            ('please_select_date',  'Please Select Date',   'he_il',    'אנא בחר תאריך',   30),
            ('search_by_date',      'Search by Date', 'he_il',    'חפש לפי תאריך', 30),
            ('shortcut_not_setup_yet',    'Opps shortcut not setup yet!!! Please add shortcut by click on [icon] from record search results or view record screen.',    'he_il',    'אופס,קיצור הדרך עדיין לא הוגדר !!! אנא הוסף קיצור דרך על ידי לחיצה על [סמל] מתוצאות החיפוש הרשומות או הצגת מסך ההקלטה.',    30),
            ('max_upload_size',     'max file Upload exceeds',    'he_il',    'חרגת מכמות העלאה מותרת',    30),
            ('unselect_all',  'UnSelect All',   'he_il',    'בטל את הבחירה בכולם',   30),
            ('select_all',    'Select All',     'he_il',    'בחר הכל',     30),
            ('please_select_records',     'Please select records',      'he_il',    'אנא בחר רשומות',      30),
            ('select_date',   'Select Date',    'he_il',    'בחר תאריך',    30),
            ('quantity_in_stock_is',      'Quantity in stock is', 'he_il',    'הכמות במלאי היא', 30),
            ('replies', 'Replies',  'he_il',    'תגובות',  30),
            ('conversation_require_selection',  'Conversion requires selection of Contact or Organization', 'he_il',    'המרה מחייבת בחירת איש קשר או ארגון', 30),
            ('please_select_product',     'Please Select Product',      'he_il',    'אנא בחר מוצר',      30),
            ('timer_msg',     'You can start timer for single task only at same time',    'he_il',    'אתה יכול להתחיל טיימר למשימה יחידה רק באותו זמן',    31),
            ('save_start_tracking', 'Save & Start Tracking',      'he_il',    'שמור והתחל במעקב',      31),
            ('lbl_notes',     'Notes',    'he_il',    'הערות',    31),
            ('enter_title',   'Enter Title',    'he_il',    'הזן כותרת',    31),
            ('select_module_record',      'Select Module / Record',     'he_il',    'בחר מודול / רשומה',     31),
            ('lbl_tomorrow',  'Tomorrow', 'he_il',    'מחר', 30),
            ('lbl_yesterday', 'Yesterday',      'he_il',    'אתמול',      30),
            ('lbl_today',     'Today',    'he_il',    'היום',    30),
            ('time_tracker',  'Time Tracker',   'he_il',    'גשש זמן',   31),
            ('time_end',      'End Time', 'he_il',    'זמן סיום', 5),
            ('due_date',      'End Date', 'he_il',    'תאריך סיום', 5),
            ('time_start',    'Time Start',     'he_il',    'זמן התחלה',     5),
            ('date_start',    'Start Date',     'he_il',    'תאריך התחלה',     5),
            ('delete_widget_msg',   'Display widget again by using (+) option',     'he_il',    'הצג יישומון שוב באמצעות אפשרות (+)',     15),
            ('no_upcoming_activities',    'No scheduled activities      ',    'he_il',    'אין פעילויות מתוזמנות',    15),
            ('check_in_first',      'Please check-in first',      'he_il',    'Please check-in first',      30),
            ('duration',      'Duration', 'he_il',    'משך', 30),
            ('distance',      'Distance', 'he_il',    'מרחק', 30),
            ('proper_address_message',    'Please enter proper address in record\n',      'he_il',    'אנא הזן את הכתובת הנכונה ברשומה',  30),
            ('select_status', 'Select Status',  'he_il',    'בחר סטטוס',  30),
            ('route_planner', 'Route Planner',  'he_il',    'מתכנן נתיב',  30),
            ('route_planning',      'Route Planning', 'he_il',    'תכנון נתיב', 30),
            ('add_route',     'Add Route',      'he_il',    'הוסף נתיב',      30),
            ('calender_disabled',   'Calendar Module is disabled',      'he_il',    'מודול היומן מושבת',      30),
            ('close_dialog',  'Close form',     'he_il',    'סגור טופס',     30),
            ('cancel_form_message', 'Are You sure want to close ?',     'he_il',    'האם אתה בטוח שברצונך לסגור?',     30),
            ('create_route',  'Create Route',   'he_il',    'צור נתיב',   30),
            ('select_module_create_route',      'Select Module to create Route',    'he_il',    'בחר מודול ליצירת נתיב',    30),
            ('cancel',  'Cancel',   'he_il',    'בטל',   30),
            ('assign_route',  'Assign Route',   'he_il',    'הקצה נתיב',   30),
            ('route_for',     'Route for',      'he_il',    'נתיב ל',      30),
            ('assigned_to',   'Assigned To',    'he_il',    'מוקצה אל ',    30),
            ('enter_route_name',    'Enter Route Name',     'he_il',    'הזן את שם נתיב',     30),
            ('list',    'List',     'he_il',    'רשימה',     30),
            ('map',     'Map',      'he_il',    'מפה',      30),
            ('other_modules', 'Other Modules',  'he_il',    'מודולים אחרים',  15),
            ('shortcut_no_record_msg',    'Opps shortcut not setup\n yet!!! Please add shortcut  by click on + icon from record\n search results or view record screen.',     'he_il', 'אופס קיצור הדרך  לא הוגדר   עדיין!!! אנא הוסף קיצור דרך על ידי לחיצה על סמל + מתוך הרשומה  תוצאות חיפוש או הצג מסך רשומה.',25),
            ('clear',   'Clear',    'he_il',    'נקה',    25),
            ('open',    'Open',     'he_il',    'פתח',     11),
            ('max_file_msg',  'Too many files selected (max:6)',  'he_il',    'נבחרו יותר מדי קבצים (מקסימום: 6)',  11),
            ('error_voicenote_record',    'Unable to recording voice while another application is recording sound.',    'he_il',    'לא ניתן להקליט קול בזמן שיישום אחר מקליט צליל.',    11),
            ('msg_warning',   'Warning!', 'he_il',    'אַזהָרָה!', 11),
            ('Permision_denied_contact',  'Permission denied to access your contacts',    'he_il',    'הרשאה נדחתה לגשת לאנשי הקשר שלך',    15),
            ('no_widget_added',     'Please click + icon to add new widget to your dashboard.', 'he_il',    'לחץ על סמל + כדי להוסיף יישומון חדש למרכז השליטה שלך.', 15),
            ('no_data_available',   'Data not available, please check the selected fields',     'he_il',    'נתונים אינם זמינים, אנא בדוק את השדות שנבחרו',     15),
            ('check_out_successfully',    'Check out successfully',     'he_il',    'Checked out successfully',   11),
            ('check_in_successfully',     'Check in successfully',      'he_il',    'Checked in successfully',    11),
            ('check_out',     'Check out',      'he_il',    'Check out',      11),
            ('check_in',      'Check in', 'he_il',    'Check in', 11),
            ('navigate',      'Navigate', 'he_il',    'נווט', 11),
            ('save_to_phone_vcard_success',     'VCard Saved to phone successfully',      'he_il',    'VCard נשמר בטלפון בהצלחה',      15),
            ('download_vcard_success',    'VCard downloaded successfully',    'he_il',    'הורדת ה- VCard הושלמה בהצלחה',    15),
            ('card_details',  'Card Details',   'he_il',    'פרטי כרטיס',   15),
            ('add_widget',    'Add Widget',     'he_il',    'הוסף יישומון',     15),
            ('delete_widget', 'Are you sure to hide widget?',     'he_il',    'האם אתה בטוח רוצה להסתיר יישומון?',     15),
            ('already_widgets_added',     'All types of Widget & reports are already added',    'he_il',    'כל סוגי היישומונים והדוחות כבר נוספו',    15),
            ('retry',   'Retry',    'he_il',    'נסה שוב',    28),
            ('retake',  'Retake',   'he_il',    'צלם שוב',   28),
            ('Reports', 'Reports',  'he_il',    'דוחות',  15),
            ('Widgets', 'Widgets',  'he_il',    'יישומונים',  15),
            ('vcard_config',  'Vcard Configuration',  'he_il',    'תצורת Vcard',  8),
            ('save_to_phone', 'Save to phone',  'he_il',    'שמור בטלפון',  11),
            ('download_vcard',      'Download Vcard', 'he_il',    'הורד את ה Vcard', 11),
            ('share_vcard',   'Share Vcard',    'he_il',    'שתף את ה Vcard',    11),
            ('share_record',  'Share Record',   'he_il',    'שתף רשומה',   11),
            ('permission_denied_edit',    'You don\'t have permission to edit this record.',    'he_il',    'אין לך הרשאה לערוך רשומה זו.',    27),
            ('permission_denied_delete',  'You don\'t have permission to delete this record.',  'he_il',    'אין לך הרשאה למחוק רשומה זו.',  27),
            ('Voice_Recording_Started',   'Recording Started',    'he_il',    'ההקלטה התחילה',    12),
            ('Voice_Recording_Stopped',   'Recording Stopped',    'he_il',    'ההקלטה הופסקה',    12),
            ('SEARCH',  'Search',   'he_il',    'חיפוש',   7),
            ('LAST',    'Last',     'he_il',    'אחרון',     7),
            ('FIRST',   'First',    'he_il',    'ראשון',    7),
            ('MONDAY',  'Monday',   'he_il',    'יום שני',   7),
            ('TUESDAY', 'Tuesday',  'he_il',    'יום שלישי',  7),
            ('WEDNESDAY',     'Wednesday',      'he_il',    'יום רביעי',      7),
            ('THURSDAY',      'Thursday', 'he_il',    'יום חמישי', 7),
            ('FRIDAY',  'Friday',   'he_il',    'יום שישי',   7),
            ('SATURDAY',      'Saturday', 'he_il',    'שבת', 7),
            ('SUNDAY',  'Sunday',   'he_il',    'יום ראשון',   7),
            ('DAILY',   'Daily',    'he_il',    'Daily',    7),
            ('WEEKLY',  'Weekly',   'he_il',    'יומי',   7),
            ('MONTHLY', 'Monthly',  'he_il',    'שבועי',  7),
            ('YEARLY',  'Yearly',   'he_il',    'שנתי',   7),
            ('asset_tracking',      'Asset tracking', 'he_il',    'איתור נכסים', 15);",array());
    }

    static function es_mx(){
        global $adb;
        $checkQuery = "DELETE FROM ctmobile_language_keyword WHERE keyword_lang = ?";
        $checkResult = $adb->pquery($checkQuery,array('es_mx'));

        $adb->pquery("INSERT INTO `ctmobile_language_keyword` (`keyword`, `keyword_name`, `keyword_lang`, `language_keyword`, `sectionid`) VALUES
            ('network_error', 'Network connection error!', 'es_mx', 'Error en la red', 1),
            ('connection_check', 'Could not connect to CRM, Please check your Internet connection.', 'es_mx','Por favor verifica tu conexión a internet.',1),
            ('update', 'Update', 'es_mx', 'Actualizar', 1),
            ('cancel', 'Cancel', 'es_mx', 'Cancelar', 1),
            ('ok', 'Ok', 'es_mx', 'OK', 1),
            ('more_information', 'Click here for more information.', 'es_mx', 'Haz clic aquí para más información.', 1),
            ('yes', 'Yes', 'es_mx', 'Sí', 1),
            ('no', 'No', 'es_mx', 'No', 1),
            ('click_again_exit', 'Click again to exit', 'es_mx', 'Haz clic nuevamente para salir', 1),
            ('forpermission', 'You don\'t have permission to view this feature. Please subscribe for Premium version Click here to Subscribe.', 'es_mx', 'No tienes permiso para ver esta característica. Por favor suscríbete a la versión Premium. Haz clic aquí para suscribirte.', 1),
            ('clickhere', 'Click here', 'es_mx', 'Haz clic aquí', 1),
            ('clickhere_subscribe', 'Click here to subscribe premium version', 'es_mx', 'Haz clic aquí para suscribirte', 1),
            ('clickhere_configure', 'Click here and view how to Configure.', 'es_mx', 'Haz clic aquí para ver cómo configurar.', 1),
            ('please_wait', 'Please Wait…', 'es_mx', 'Por favor espere...', 1),
            ('share__msg', 'Share file with', 'es_mx', 'compartir archivo con', 1),
            ('dialog_camera', 'Camera', 'es_mx', 'Cámara', 1),
            ('dialog_add_file_by', 'Take Photo from', 'es_mx', 'Añadir archivos por', 1),
            ('add', 'Add', 'es_mx', 'Añadir', 1),
            ('mail_manager_configured', 'Mail Manager is not configured', 'es_mx', 'El administrador de correos no está configurado', 1),
            ('dialog_add_files_by', 'Add Files by', 'es_mx', 'Añadir archivos por', 1),
            ('dialog_drive', 'Drive', 'es_mx', 'Drive', 1),
            ('dialog_drop_box', 'Drop Box', 'es_mx', 'Drop Box', 1),
            ('dialog_need_signin', 'You need to Sign-in to your Drive account first.', 'es_mx','Necesitas registrarte primero', 1),
            ('dialog_gallery', 'Gallery', 'es_mx', 'Galería', 1),
            ('delete', 'Delete', 'es_mx', 'Borrar', 1),
            ('timeoutmessage', 'Oops! Request is taking more time than expected.', 'es_mx', 'Ups! la solicitud está tardando más de lo esperado.', 1),
            ('gps_location_message', 'GPS is not enabled. Please turn it on to get your near by locations.', 'es_mx','El GPS no está habilitado. Por favor enciéndelo para obtener tus ubicaciones cercanas.',1),
            ('sure_want_delete', 'Are you sure want to delete ?', 'es_mx', '¿Estás seguro que quieres borrar?', 1),
            ('select', 'Select', 'es_mx', 'Seleccionar', 1),
            ('msgforrecordaudio', 'Minimum record duration one second.', 'es_mx', 'Duración mínima de grabación: un minuto', 1),
            ('permission_storage', 'Permission denied to read your External storage', 'es_mx', 'Permiso denegado para leer tu almacenamiento externo',1),
            ('send_permission_msg', 'Send message permission denied', 'es_mx', 'Permiso para enviar mensaje denegado', 1),
            ('choosefile', 'Choose File', 'es_mx', 'Seleccione un archivo', 1),
            ('enter', 'Enter', 'es_mx', 'Enter', 1),
            ('select_an_option', 'Select an Option', 'es_mx', 'Elija una opción', 1),
            ('email_validation', 'Email is not valid', 'es_mx', 'El email no es válido', 1),
            ('please_enter', 'Please Enter', 'es_mx', 'Por favor ingresa', 1),
            ('website_validation_text', 'Website URL is not valid', 'es_mx', 'La url del sitio web no es válida',1),
            ('selectvalue', 'Select value first', 'es_mx', 'Selecciona el valor primero', 1),
            ('email', 'Email', 'es_mx', 'Email', 1),
            ('enter_email_address', 'Enter email address', 'es_mx', 'Ingresa email', 1),
            ('email_address_not_correct', 'Email address incorrect', 'es_mx', 'Email incorrecto', 1),
            ('pls_enter_subject', 'Please Enter Subject', 'es_mx', 'Por favor ingresa el asunto', 1),
            ('attachFiles', 'Attached File', 'es_mx', 'Archivo adjunto', 1),
            ('from', 'From', 'es_mx', 'De', 1),
            ('to', 'To', 'es_mx', 'Para', 1),
            ('call_permission_msg', 'Call permission denied', 'es_mx', 'Permiso de llamada denegado', 1),
            ('no_records', 'No records found', 'es_mx', 'No se encontraron registros', 1),
            ('fullform', 'Create New', 'es_mx', 'Forma completa', 1),
            ('save', 'Save', 'es_mx', 'Guardar', 1),
            ('total', 'Total', 'es_mx', 'Total', 1),
            ('discount', 'Discount', 'es_mx', 'Descuento', 1),
            ('price', 'Price', 'es_mx', 'Precio *', 1),
            ('quantity', 'Quantity', 'es_mx', 'Cantidad *', 1),
            ('select_module', 'Select Module', 'es_mx', 'Seleccionar módulo', 1),
            ('item_list', 'Item List', 'es_mx', 'Lista de Items', 1),
            ('quickcreate', 'Quick Create', 'es_mx', 'Creación rápida', 1),
            ('overwrite_msg_part1', 'Overwrite the existing address with the selected', 'es_mx', 'Sobre escribir la direcccion actual con los detalles ', 1),
            ('once_in_every', 'Once in every', 'es_mx', 'Una vez cada', 1),
            ('overwrite_msg_part2', 'address details?', 'es_mx', 'de la dirección elegida?', 1),
            ('add_item', 'Add Item', 'es_mx', 'Añadir Item', 1),
            ('recordsave', 'Record saved successfully', 'es_mx', 'Registro guardado exitosamente', 1),
            ('recordnotsave', 'Could not save record. Try again later', 'es_mx', 'Registro no guardado', 1),
            ('minutes', 'Minutes', 'es_mx', 'Minutos', 1),
            ('hours', 'Hours', 'es_mx', 'horas', 1),
            ('days', 'Days', 'es_mx', 'Días', 1),
            ('on', 'On', 'es_mx', 'El', 1),
            ('day_of_the_month', 'day of the month', 'es_mx', 'día del mes', 1),
            ('list_price', 'List Price', 'es_mx', 'Precio de lista *', 1),
            ('add_record', 'Add Record', 'es_mx', 'Añadir registro', 1),
            ('add_product', 'Add Product', 'es_mx', 'Añadir Producto', 1),
            ('add_service', 'Add Service', 'es_mx', 'Añadir Servicio', 1),
            ('discountin', 'Discount in %', 'es_mx', 'Descuento en %', 1),
            ('unitprice', 'Unit price', 'es_mx', 'Precio unitario *', 1),
            ('netprice', 'Net price', 'es_mx', 'Precio neto *', 1),
            ('comments', 'Comments', 'es_mx', 'Comentarios', 1),
            ('add_close', 'Add & Close', 'es_mx', 'Añadir &amp; Cerrar', 1),
            ('fetching_rout_message', 'Fetching route, Please wait…', 'es_mx', 'Buscando la ruta, espere por favor…', 1),
            ('setting', 'Settings', 'es_mx', 'Configuración', 1),
            ('utc', 'UTC', 'es_mx', 'UTC', 1),
            ('in', 'In', 'es_mx', 'En', 1),
            ('days_ago', 'days ago', 'es_mx', 'días', 1),
            ('mins_ago', 'Minutes ago', 'es_mx', 'minutos', 1),
            ('justnow', 'Just now', 'es_mx', 'Ahora mismo', 1),
            ('hours_ago', 'hours ago', 'es_mx', 'horas', 1),
            ('in_1_day', 'In 1 day', 'es_mx', 'Dentro de 1 día', 1),
            ('scanqrcode', 'Asset / Card Scanner', 'es_mx', 'QR Card Scanner', 1),
            ('call_log', 'Call Log', 'es_mx', 'Bitácora de llamada', 1),
            ('voice_message', 'Hi', 'es_mx', 'Hola', 1),
            ('voice_message1', 'What can I search for you in', 'es_mx', 'Que quieres que busque', 1),
            ('live_tracking', 'Live Tracking', 'es_mx', 'Rastreo en vivo', 1),
            ('mailmanager', 'Mail Manager', 'es_mx', 'Administrador de correo', 1),
            ('my_location', 'My location', 'es_mx', 'Mi ubicación', 1),
            ('created_on', 'Created On', 'es_mx', 'Creado en', 1),
            ('modified_on', 'Modified On', 'es_mx', 'Modificado en', 1),
            ('enter_comments', 'Enter Comments', 'es_mx', 'Introducir comentarios', 1),
            ('viewmore', 'View More', 'es_mx', 'Ver más', 1),
            ('viewless', 'View Less', 'es_mx', 'Ver menos', 1),
            ('gotofullform', 'Go to Full Form', 'es_mx', 'Ir a la forma completa', 1),
            ('post', 'Post', 'es_mx', 'Postear', 1),
            ('url', 'URL', 'es_mx', 'URL', 1),
            ('dialog_title_text_back_color', 'Select a Text Background Color', 'es_mx', 'Selecciona un color para fondo de texto', 1),
            ('event_or_task', 'Add event/task', 'es_mx', 'Añadir evento/tarea', 1),
            ('shortcut', 'Shortcuts', 'es_mx', 'Accesos directos', 1),
            ('select_field', 'Select Field', 'es_mx', 'Selecciona el campo', 1),
            ('share', 'Share', 'es_mx', 'Compartir', 1),
            ('title_insert_link', 'Insert Link', 'es_mx', 'Insertar Link', 1),
            ('addyourcommentshere', 'Add your comments here', 'es_mx', 'Añade tus comentarios aquí', 1),
            ('nocomment', 'No Comments', 'es_mx', 'Sin comentarios', 1),
            ('leads', 'Leads', 'es_mx', 'Prospectos', 1),
            ('true_val', 'true', 'es_mx', 'verdadero', 1),
            ('noresult', 'No Result', 'es_mx', 'Sin resultados', 1),
            ('version', 'Version', 'es_mx', 'Versión', 1),
            ('convert_lead', 'Convert Lead', 'es_mx', ' Convertir Prospecto', 1),
            ('app_name', 'CRMTiger', 'es_mx', 'SalesHiker', 1),
            ('enter_url', 'Please Enter url', 'es_mx', 'Por favor ingresa la url', 1),
            ('help', 'Help', 'es_mx', 'Ayuda', 1),
            ('contact_us', 'Contact Us', 'es_mx', 'Contáctanos', 1),
            ('updates', 'Updates', 'es_mx', 'Actualizaciones', 1),
            ('logout', 'LogOut', 'es_mx', 'LogOut', 1),
            ('busnies_cardscanner', 'Business Card Scanner', 'es_mx', 'Escáner de Tarjeta de Presentación', 1),
            ('sure_want_logout', 'Are you sure want to logout ?', 'es_mx', '¿Estás seguro que quieres salir?', 1),
            ('logout_message', 'Logout successfully', 'es_mx', '¿Estás seguro que quieres salir?', 1),
            ('all', 'All', 'es_mx', 'Todo', 1),
            ('add_event', 'Add event', 'es_mx', 'Añadir evento', 1),
            ('add_task', 'Add Task', 'es_mx', 'Añadir tarea', 1),
            ('next', 'Next', 'es_mx', 'Siguiente', 1),
            ('terms_conditions', 'Terms and Conditions', 'es_mx', 'Terms and Conditions', 1),
            ('login', 'Login', 'es_mx', 'Login', 2),
            ('privacy_policay', 'By logging in, you agree to our Terms and Conditions & Privacy Policy', 'es_mx', 'Al ingresar, aceptas nuestros términos y condiciones &amp; Política de privacidad', 2),
            ('copyright', 'Copyright © 2019 CRMTiger Version', 'es_mx','Copyright \u00A9 2019 CRMTiger \n Versión', 2),
            ('enter_username', 'Please enter username', 'es_mx', 'Por favor ingresa tu usuario', 2),
            ('enter_password', 'Please enter password', 'es_mx', 'Por favor ingresa tu contraseña', 2),
            ('remanberme', 'Remember Me', 'es_mx', 'Recordarme', 2),
            ('forgot_password', 'Forgot password?', 'es_mx', '¿Olvidaste tu contraseña?', 2),
            ('privacy_policay1', 'Privacy Policy', 'es_mx', 'Política de privacidad', 2),
            ('contactsupportmsg', 'Something went wrong. \\n please Click here to contact support.', 'es_mx', 'Algo salió mal. Por favor haga clic aqui para contactat a soporte', 2),
            ('enter_username_password', 'Entered Username or Password is wrong', 'es_mx', 'El Usuario o la Contraseña ingresada es incorrecta', 2),
            ('server_issue_occured', 'Server issues occurred', 'es_mx', 'Ocurrieron problemas con el servidor', 2),
            ('password', 'Password', 'es_mx', 'Contraseña', 3),
            ('user_name', 'Username', 'es_mx', 'Usuario', 3),
            ('reset_pwd', 'Reset Password', 'es_mx', 'Reestablecer contraseña', 3),
            ('forgot_password_title', 'Forgot password', 'es_mx', 'Olvidé mi contraseña', 3),
            ('enter_user_name', 'Enter user name', 'es_mx', 'Ingresa nombre de usuario', 3),
            ('cc', 'Cc', 'es_mx', 'Cc', 4),
            ('body', 'Body', 'es_mx', 'Cuerpo', 4),
            ('bcc', 'BCC', 'es_mx', 'BCC', 4),
            ('dialog_title_text_color', 'Select a Text Color', 'es_mx', 'Selecciona un color de texto', 4),
            ('date', 'Date', 'es_mx', 'Fecha', 4),
            ('subject', 'Subject', 'es_mx', 'Asunto', 4),
            ('composeMail', 'Compose Mail', 'es_mx', 'Redactar correo', 4),
            ('send', 'Send', 'es_mx', 'Enviar', 4),
            ('select_message', 'Select message', 'es_mx', 'Seleccionar mensaje', 4),
            ('title_insert_table', 'Insert Table', 'es_mx', 'Insertar tabla', 4),
            ('log_file_sms', 'I agree to Share API Log to Technical team for further troubleshooting', 'es_mx','Estoy de acuerdo con compartir la Bitácora API con el equipo técnico para seguir solucionando el problema',5),
            ('edit_record', 'Edit Records', 'es_mx', 'Editar registros', 5),
            ('select_time', 'Select Time', 'es_mx', 'Seleccionar hora', 5),
            ('edit_item', 'Edit Item', 'es_mx', 'Editar Item', 5),
            ('items_total', 'Items Total', 'es_mx', 'Total de items', 5),
            ('number_less_then_31', 'Number should be less than 31', 'es_mx', 'El número deber ser menor a 31', 5),
            ('users', 'Users', 'es_mx', 'Usuarios', 5),
            ('groups', 'Groups', 'es_mx', 'Grupos', 5),
            ('txt_note_for_file', 'Note : Existing attachments(images/files) will be replaced', 'es_mx','Nota : Los adjuntos existentes (imágenes/archivos) serán reemplazados',5),
            ('greaterdatetime', 'End DateTime should be greater than Start DateTime', 'es_mx', 'La fecha y hora final deben ser mayores que la fecha y hora de inicio',5),
            ('until', 'Until', 'es_mx', 'Hasta', 5),
            ('organizations', 'Organizations', 'es_mx', 'Organizaciones', 6),
            ('contacts', 'Contacts', 'es_mx', 'Contactos', 6),
            ('opportunity', 'Opportunity', 'es_mx', 'Oportunidad', 6),
            ('lbl_sun', 'SUN', 'es_mx', 'DOM', 7),
            ('lbl_mon', 'MON', 'es_mx', 'LUN', 7),
            ('lbl_tue', 'TUE', 'es_mx', 'MAR', 7),
            ('lbl_wed', 'WED', 'es_mx', 'MIE', 7),
            ('lbl_thu', 'THU', 'es_mx', 'JUE', 7),
            ('lbl_fri', 'FRI', 'es_mx', 'VIE', 7),
            ('lbl_sat', 'SAT', 'es_mx', 'SAB', 7),
            ('lbl_1', '1', 'es_mx', '1', 7),
            ('lbl_2', '2', 'es_mx', '2', 7),
            ('lbl_3', '3', 'es_mx', '3', 7),
            ('lbl_4', '4', 'es_mx', '4', 7),
            ('lbl_5', '5', 'es_mx', '5', 7),
            ('lbl_6', '6', 'es_mx', '6', 7),
            ('lbl_7', '7', 'es_mx', '7', 7),
            ('lbl_8', '8', 'es_mx', '8', 7),
            ('lbl_9', '9', 'es_mx', '9', 7),
            ('lbl_10', '10', 'es_mx', '10', 7),
            ('lbl_11', '11', 'es_mx', '11', 7),
            ('lbl_12', '12', 'es_mx', '12', 7),
            ('lbl_13', '13', 'es_mx', '13', 7),
            ('lbl_14', '14', 'es_mx', '14', 7),
            ('lbl_15', '15', 'es_mx', '15', 7),
            ('lbl_16', '16', 'es_mx', '16', 7),
            ('lbl_17', '17', 'es_mx', '17', 7),
            ('lbl_18', '18', 'es_mx', '18', 7),
            ('lbl_19', '19', 'es_mx', '19', 7),
            ('lbl_20', '20', 'es_mx', '20', 7),
            ('lbl_21', '21', 'es_mx', '21', 7),
            ('lbl_22', '22', 'es_mx', '22', 7),
            ('lbl_23', '23', 'es_mx', '23', 7),
            ('lbl_24', '24', 'es_mx', '24', 7),
            ('lbl_25', '25', 'es_mx', '25', 7),
            ('lbl_26', '26', 'es_mx', '26', 7),
            ('lbl_27', '27', 'es_mx', '27', 7),
            ('lbl_28', '28', 'es_mx', '28', 7),
            ('lbl_29', '29', 'es_mx', '29', 7),
            ('lbl_30', '30', 'es_mx', '30', 7),
            ('lbl_31', '31', 'es_mx', '31', 7),
            ('lbl_32', '32', 'es_mx', '32', 7),
            ('lbl_33', '33', 'es_mx', '33', 7),
            ('lbl_34', '34', 'es_mx', '34', 7),
            ('lbl_35', '35', 'es_mx', '35', 7),
            ('lbl_36', '36', 'es_mx', '36', 7),
            ('lbl_37', '37', 'es_mx', '37', 7),
            ('lbl_38', '38', 'es_mx', '38', 7),
            ('lbl_39', '39', 'es_mx', '39', 7),
            ('lbl_40', '40', 'es_mx', '40', 7),
            ('lbl_41', '41', 'es_mx', '41', 7),
            ('lbl_42', '42', 'es_mx', '42', 7),
            ('current_date', 'current date', 'es_mx', 'fecha actual', 7),
            ('event', 'Events', 'es_mx', 'Eventos', 7),
            ('calendar', 'Calendar', 'es_mx', 'Calendario', 7),
            ('latest_version', 'Latest Version :', 'es_mx', 'Última versión :', 8),
            ('expire_on', 'Expire On :', 'es_mx', 'Expira el :', 8),
            ('ctmobile_ext_version', 'CTMobile Ext. Version :', 'es_mx', 'Versión de la Ext. CRMobile  :', 8),
            ('you_have_latest_version', 'You already have latest version', 'es_mx', 'Tienes la versión actualizada', 8),
            ('latest_version1', 'You Already have latest version', 'es_mx', 'Ya tienes la última versión', 8),
            ('upgreaded', 'Upgrade', 'es_mx', 'Upgrade', 8),
            ('downgrade', 'Downgrade', 'es_mx', 'Downgrade', 8),
            ('dialog_recent_event_info', 'You can set from here how many number of records you want to show on Home screen for Recent Event.', 'es_mx', 'Puedes definir aquí cuántos registros quieres mostrar en la pantalla de inicio para el evento reciente.',8),
            ('dialog_feedback_info', 'You can submit your feedback with description , our team will check your feedback and get back to you.', 'es_mx', 'Puedes enviar tu retroalimentación con la descripción, nuestro equipo revisará tu retroalimentación y se pondrá en contacto contigo.', 8),
            ('dialog_log_info', 'Log functionality is used for customer support / help , If you are facing any issues in app or any module or functionality is not working proper then you can enable share log with our development team.', 'es_mx','La función de la bitácora es dar soporte / ayuda al cliente, si tienes algún problema con la app o algún módulo o funcionalidad no está funcionando adecuadamente, puedes habilitar la función de compartir la bitácora con nuestro equipo de desarrollo.', 8),
            ('info', 'Info', 'es_mx', 'Info', 8),
            ('recent_history', 'Recent History', 'es_mx', 'Historial reciente', 8),
            ('recent_feedback', 'Feedback', 'es_mx', 'Retroalimentación', 8),
            ('recent_log', 'Log', 'es_mx', 'Bitácora', 8),
            ('crmtiger_app_version', 'CRMTiger App Version :', 'es_mx', 'Versión de la App CRMTiger  :',8),
            ('historylimit', 'Recent History Limit', 'es_mx', 'Límite historial reciente', 8),
            ('radious_in_miles', 'Radius in miles', 'es_mx', 'Radio en millas', 8),
            ('recentlimit', 'Recent Event Limit', 'es_mx', 'Límite de evento reciente', 8),
            ('upcoming_events', 'Upcoming Events', 'es_mx', 'Eventos próximos', 8),
            ('rate_our_app', 'Rate Our App!', 'es_mx', '¡Califica nuestra App!', 8),
            ('feedback', 'Submit Feedback', 'es_mx', 'Enviar retroalimentación', 8),
            ('sendfeedback', 'Feedback Send', 'es_mx', 'Retroalimentación enviada', 8),
            ('emaillimit', 'Email limit', 'es_mx', 'Límite de email', 8),
            ('log', 'Log', 'es_mx', 'Bitácora', 8),
            ('logclear', 'Log cleared successfully.', 'es_mx', 'Clear successful', 8),
            ('dialog_recent_history_info', 'You can set from here how many number of records you want to show on Home screen for Recent History.', 'es_mx', 'Puedes definir aquí cuántos registros quieres mostrar en la pantalla de inicio para el historial reciente.', 8),
            ('proceed_to_upgrade1', 'Proceed to', 'es_mx', 'Proceder a', 8),
            ('upgradation_message', 'will required logout and login again later.', 'es_mx','se requerirá que salga del sistema y vuelva a entrar luego',8),
            ('proceed_to_upgrade', 'Proceed to Upgrade', 'es_mx', 'Proceder a actualizar', 8),
            ('module_setting', 'Module Setting', 'es_mx', 'Configuración de módulo', 9),
            ('sortbyfield', 'Sort by field', 'es_mx', 'Ordenar por campo', 9),
            ('ascending', 'Ascending  A to Z', 'es_mx', 'Ascendiente  A a Z',9),
            ('descending', 'Descending  Z to A', 'es_mx', 'Descendiente  Z a A',9),
            ('first_field', 'First Field', 'es_mx', 'Primer campo', 9),
            ('second_field', 'Second Field', 'es_mx', 'Segundo campo', 9),
            ('third_field', 'Third Field', 'es_mx', 'Tercer campo', 9),
            ('sure_want_restore', 'Are you sure you want to reset to default settings?', 'es_mx', '¿Estás seguro que quieres regresar a los valores predeterminados?',9),
            ('orderlist', 'List Order', 'es_mx', 'Orden de lista', 9),
            ('module_reset', 'Restore to Default', 'es_mx', 'Regresar a los valores predeterminados', 9),
            ('display_fields', 'Display Fields', 'es_mx', 'Desplegar campos', 9),
            ('discount_lessthen_100', 'Discount % should be less than 100', 'es_mx', 'El % de descuento debe ser menor a 100', 10),
            ('select_item', 'Select Item', 'es_mx', 'Seleccionar Item', 10),
            ('item_comment', 'Item Comment', 'es_mx', 'Comentario sobre Item', 10),
            ('record_name', 'Record Name is :', 'es_mx', 'El nombre el registro es :-', 11),
            ('go_back', 'Go Back', 'es_mx', 'Regresar', 11),
            ('please_enter_shortcut_name', 'Please Enter Shortcut Name', 'es_mx', 'Por favor ingresa el nombre del acceso directo', 11),
            ('number_not_found', 'Contact Number not found', 'es_mx', 'Número de contacto no encontrado', 11),
            ('mail_not_found', 'Mail Address not found', 'es_mx', 'Dirección de correo no encontrada', 11),
            ('create_shortcut', 'Create Shortcut', 'es_mx', 'Crear acceso directo', 11),
            ('contact_summary', 'Summary', 'es_mx', 'Resumen', 11),
            ('activites', 'Activities', 'es_mx', 'Actividades', 11),
            ('details', 'Details', 'es_mx', 'Detalles', 11),
            ('related', 'Related', 'es_mx', 'Relacionado', 11),
            ('share_link', 'Share record with', 'es_mx', 'Compartir el registro con', 11),
            ('edit', 'Edit', 'es_mx', 'Editar', 11),
            ('duplicate', 'Duplicate', 'es_mx', 'Duplicar', 11),
            ('whatsapp', 'Whatsapp', 'es_mx', 'Whatsapp', 11),
            ('call', 'Call', 'es_mx', 'Llamar', 11),
            ('choose_contact_for_call', 'Choose Contact for Call', 'es_mx', 'Elegir un Contacto para Llamar', 11),
            ('choose_contact_for_sms', 'Choose Contact for SMS', 'es_mx', 'Elegir un Contacto para enviar SMS', 11),
            ('choose_contact_for_whatsapp', 'Choose Contact for WhatsApp', 'es_mx', 'Elegir un Contacto para enviar mensaje WhatsApp', 11),
            ('chosse_contact_for_email', 'Choose Email', 'es_mx', 'Elegir una direccion de correo', 11),
            ('attach_file', 'Attach Files', 'es_mx', 'Adjuntar Archivos', 11),
            ('close', 'Close', 'es_mx', 'Cerrar', 11),
            ('status', 'Status', 'es_mx', 'Estatus', 11),
            ('stop', 'Stop', 'es_mx', 'Detener', 11),
            ('zero', '0', 'es_mx', '0', 11),
            ('record', 'Record', 'es_mx', 'Grabar', 11),
            ('voice_note', 'Voice Note', 'es_mx', 'Nota de Voz', 11),
            ('tickets', 'Tickets', 'es_mx', 'Tickets', 12),
            ('check_out', 'Check Out', 'es_mx', 'Check Out', 12),
            ('check_in', 'Check In', 'es_mx', 'Check In', 12),
            ('select_any', 'Select any', 'es_mx', 'Seleccionar cualquier', 12),
            ('fulldetails', 'Show Full Details', 'es_mx', 'Mostrar todos los detalles', 12),
            ('checkin', 'Check-in', 'es_mx', 'Check-in', 12),
            ('navigate', 'Navigate', 'es_mx', 'Navegar', 12),
            ('product', 'Products', 'es_mx', 'Productos', 12),
            ('projectMilestone', 'Project Milestone', 'es_mx', 'Hitodelproyecto', 12),
            ('projecttask', 'Project Tasks', 'es_mx', 'Tareadelproyecto', 12),
            ('nearby', 'NearBy', 'es_mx', 'Cerca', 13),
            ('document', 'Document', 'es_mx', 'Documento', 14),
            ('reply', 'Reply', 'es_mx', 'Responder', 14),
            ('reply_all', 'Reply All', 'es_mx', 'Responder a todos', 14),
            ('forward', 'Forward', 'es_mx', 'Reenviar', 14),
            ('action', 'Action', 'es_mx', 'Acción', 14),
            ('select_first', 'Select First', 'es_mx', 'Elegir Primero', 14),
            ('commentaddsuccessful', 'Comment added successfull', 'es_mx', 'El comentario se añadió con éxito', 14),
            ('move_to', 'Move to', 'es_mx', 'Mover a', 14),
            ('attach', 'Attach', 'es_mx', 'Adjuntar', 14),
            ('addcoment', 'Add Comment', 'es_mx', 'Añadir comentario', 14),
            ('adddocument', 'Add Document', 'es_mx', 'Añadir documento', 14),
            ('home', 'Home', 'es_mx', 'Home', 15),
            ('checkout', 'Check-out', 'es_mx', 'Check-out', 15),
            ('message_search', 'Search by name', 'es_mx', 'Buscar por nombre', 15),
            ('start_shift', 'Start shift', 'es_mx', 'Empezar turno', 15),
            ('end_shift', 'End shift', 'es_mx', 'Terminar turno', 15),
            ('today_meeting', 'Meetings', 'es_mx', 'Reuniones', 15),
            ('shift_time_track', 'Shift Time Track', 'es_mx', 'Rastrear cambio de turno', 15),
            ('logout_msg', 'You have to login again , click', 'es_mx', 'Tiene que ingresar de nuevo , clic', 15),
            ('logout_msg1', 'to continue.', 'es_mx', 'para continuar', 15),
            ('permission_denied', 'You don\'t have permission to create', 'es_mx', 'No tienes permiso para crear', 15),
            ('history', 'Activity stream', 'es_mx', 'Flujo de actividad', 15),
            ('search_value', 'Search value :', 'es_mx', 'Buscar el valor', 15),
            ('feed_back_msg', 'Please enter feedback message', 'es_mx', 'Por favor ingresa mensaje de retroalimentación', 16),
            ('feed_back_hint_msg', 'Enter feedback message', 'es_mx', 'Ingresa mensaje de retroalimentación', 16),
            ('submit', 'Submit', 'es_mx', 'Enviar', 16),
            ('check_app_not_installed', 'Application is not currently installed.', 'es_mx', 'La aplicación no está instalada actualmente.', 17),
            ('send_sms_fail_message', 'SMS failed, please try again later!', 'es_mx','El SMS falló, por favor intenta más tarde',17),
            ('documentaddsuccessfully', 'Document Attach successfully', 'es_mx', 'El documento se adjuntó con éxito', 17),
            ('send_message', 'Send message', 'es_mx', 'Enviar mensaje', 17),
            ('sms_to', 'smsto:', 'es_mx', 'smspara:', 17),
            ('add_list_message', 'Add List', 'es_mx', 'Añadir lista', 18),
            ('mylist', 'My List', 'es_mx', 'Mi lista', 18),
            ('filtername', 'Filter Name', 'es_mx', 'Nombre del filtro', 18),
            ('selectlist', 'Select a List', 'es_mx', 'Seleccionar una lista *', 18),
            ('assingedto', 'Assigned To', 'es_mx', 'Asignado a *', 18),
            ('selectmodule', 'Select a module', 'es_mx', 'Seleccionar un módulo', 18),
            ('add_list', 'Add Filter', 'es_mx', 'Añadir filtro', 18),
            ('recent_event', 'Recent Event', 'es_mx', 'Evento reciente', 19),
            ('recent_hostory', 'Recent History', 'es_mx', 'Historial reciente', 19),
            ('module_specific_settings', 'Module-Specific Settings', 'es_mx', 'Configuración específica del módulo', 19),
            ('talk_to_us', 'Talk to us', 'es_mx', 'Habla con nosotros', 19),
            ('report_a_bug', 'Report A Bug', 'es_mx', 'Reporta un bug', 19),
            ('faq', 'FAQ', 'es_mx', 'FAQ', 19),
            ('selectmodules', 'Select Module', 'es_mx', 'Selecciona el módulo', 19),
            ('myplan', 'My Plan', 'es_mx', 'Mi plan', 19),
            ('message', 'Message', 'es_mx', 'Mensaje', 20),
            ('message_validation', 'Please enter Message', 'es_mx', 'Please enter Message', 20),
            ('contact_select', 'Please Select contact', 'es_mx', 'Por favor selecciona el contacto', 20),
            ('global_search', 'Global Search', 'es_mx', 'Búsqueda Global', 21),
            ('records', 'Records', 'es_mx', 'Records', 21),
            ('dont_show_again', 'Don\'t Show Again', 'es_mx', 'No mostrar denuevo', 22),
            ('skip', 'Skip', 'es_mx', 'Saltear', 22),
            ('file_downloading', 'File Downloading', 'es_mx', 'Archivo descargándose', 23),
            ('add_screenshots_optional', 'Add screenshots (optional)', 'es_mx', 'Añadir capturas de pantalla (opcional)', 24),
            ('describe_your_problem', 'Describe your problem', 'es_mx', 'Describe tu problema', 24),
            ('default_filter_shortcut', 'Default Filter Shortcut', 'es_mx', 'Atajo de Filtro Predeterminado', 25),
            ('record_shortcut', 'Record Shortcut', 'es_mx', 'Atajo al Registro', 25),
            ('enter_url', 'Please Enter url', 'es_mx', 'Por favor ingrese URL', 26),
            ('new_version_is_avaiable', 'You need to update the app to continue using Please update to continue Older versions will no longer work from today', 'es_mx', 'Necesita actualizar la app para continuar usándola. Por favor actualice para continuar. Las versiones antiguas ya no están funcionando.', 26),
            ('search_by', 'Search by', 'es_mx', 'Buscar por', 27),
            ('selected_filter', 'Selected filter :', 'es_mx', 'Filtro seleccionado :-', 27),
            ('selected_field', 'Selected field :', 'es_mx', 'Campo seleccionado :-', 27),
            ('choose', 'Choose', 'es_mx', 'Elija', 28),
            ('qr_cardscanner', 'QR Code Scanner', 'es_mx', 'Escaner de Código QR', 28),
            ('error_message_for_scan', 'Could not read the card Try again later.', 'es_mx', 'La tarjeta no pudo ser leída. Trate nuevamente más tarde.', 28),
            ('press_start_scan', 'Press to Start Scan', 'es_mx', 'Presione para iniciar el escaner', 28),
            ('line_item_quntity_validation_msg', 'Value should be greater than zero', 'es_mx', 'El valor debe ser mayor a cero', 29),
            ('percentage_msg', 'Percentage should be less than 100', 'es_mx', 'El porcentaje debe ser menor a cero', 29),
            ('MSG_NO_DATA', 'No data found!', 'es_mx', 'No se encontró información', 29),
            ('MSG_SOMETHING_WRONG', 'Something went wrong!', 'es_mx', 'Algo salió mal', 29),
            ('MSG_COMING_SOON', 'Coming Soon!', 'es_mx', 'Llegará pronto', 29),
            ('MSG_UPLOAD_PROFILE_IMAGE', 'Please upload profile image.', 'es_mx', 'Por favor cargue una imagen de perfil', 29),
            ('ALERT_TITLE_LOCATION_ACCESS', 'Location Access', 'es_mx', 'Acceso a ubicación', 29),
            ('ALERT_MSG_LOCATION_ACCESS', 'Requires your location to show nearby events.', 'es_mx', 'Su ubicación es necesaria para mostrar eventos cercanos', 29),
            ('ALERT_BTN_ALLOW', 'ALLOW', 'es_mx', 'PERMITIR', 29),
            ('ALERT_BTN_DENY', 'DENY', 'es_mx', 'DENEGAR', 29),
            ('ALERT_MSG_LOCATION_SETTING', 'Not able to fetch your current location. Please check your location settings.', 'es_mx', 'No es posible encontrar su ubicación actual. Por favor verifique su configuración de ubicación.', 29),
            ('DELETE_RECORD', 'Delete Record', 'es_mx', 'Borrar registro', 29),
            ('ALERT_MSG_DELETE_SHORTCUT', 'Are you sure want to delete this shortcut?', 'es_mx', '¿Está seguro de que quiere borrar este acceso directo?', 29),
            ('DELETE_SHORTCUT', 'Delete Shortcut', 'es_mx', 'Borrar acceso directo', 29),
            ('LBL_TERMS', 'By logging in, you agree to our Terms and', 'es_mx', 'Al iniciar sesión, acepta nuestros Términos', 29),
            ('LBL_CONDITIONS', 'Conditions &', 'es_mx', '& Condiciones', 29),
            ('ALERT_TITLE', 'Alert', 'es_mx', 'Alerta', 29),
            ('ALERT_BTN_SUBSCRIBE', 'Subscribe', 'es_mx', 'Suscribirse', 29),
            ('MSG_SELECT_MODULE', 'Please select any Module', 'es_mx', 'Por favor seleccione cualquier Módulo', 29),
            ('MSG_SELECT_LIST', 'Please select any List', 'es_mx', 'Por favor selecciona cualquier Lista', 29),
            ('ALERT_MSG_DONT_HAVE_CAMERA', 'You don\'t have camera', 'es_mx', 'No tiene cámara', 29),
            ('ALERT_MSG_GALLARY_PERMISSION', 'You don\'t have permission to access gallery.', 'es_mx', 'No tiene permiso para accesar la galería', 29),
            ('ALERT_MSG_CAMERA_PERMISSION', 'You don\'t have permission to access camera. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Camera on', 'es_mx', 'No tiene permiso para accesar a la cámara. Ir a configuración -> Desplazar hacia abajo y seleccionar CRMTiger App -> Encender la cámara', 29),
            ('ALERT_MSG_SPEECH_PERMISSION', 'You don\'t have permission to access Speech Recognition. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Speech Recognition on', 'es_mx', 'No tiene permiso para accesar el Reconocimiento de voz. Ir a configuración -> Desplazar y seleccionar CRMTiger App -> Encender Reconocimiento de voz', 29),
            ('BTN_DONE', 'Done', 'es_mx', 'Terminado', 29),
            ('COMMENT', 'Comment', 'es_mx', 'Comentar', 29),
            ('FULL_FORM', 'Full Form', 'es_mx', 'Registro completo', 29),
            ('QUICK_CREATE', 'Create', 'es_mx', 'Crear', 29),
            ('LBL_SELECT_FIELDS', 'Select Fields', 'es_mx', 'Seleccionar campos', 29),
            ('LBL_SELECT_FIRST_FIELDS', 'Select First Field', 'es_mx', 'Seleccionar primer campo', 29),
            ('LBL_SELECT_SECOND_FIELDS', 'Select Second Field', 'es_mx', 'Seleccionar segundo campo', 29),
            ('LBL_SELECT_THIRD_FIELDS', 'Select Third Field', 'es_mx', 'Seleccionar tercer campo', 29),
            ('LBL_SORT_BY_FIELD', 'Select Sort By Field', 'es_mx', 'Seleccionar Ordenar por campo', 29),
            ('BTN_RESET_TO_DEFAULT', 'Reset to Default', 'es_mx', 'Resetear a valor predeterminado', 29),
            ('MSG_SELECT_SORT_BY_FIELD', 'Select Sort by field', 'es_mx', 'Seleccionar Ordenar por campo', 29),
            ('kStrClearBtnTitle', 'Clear', 'es_mx', 'Limpiar', 29),
            ('kStrShowMoreBtnTitle', 'Show More', 'es_mx', 'Mostrar más', 29),
            ('kStrAddActivitiesBtnTitle', 'Add Activities', 'es_mx', 'Añadir actividades', 29),
            ('kStrAddCommentPlaceHolder', 'Add your comments here', 'es_mx', 'Añadir sus comentarios aquí', 29),
            ('MSG_ENTER_TO_EMAIL', 'Please enter to field.', 'es_mx', 'Por favor ingrese al campo', 29),
            ('WARNING_FILE', 'File can\'t open.', 'es_mx', 'El archivo no se puede abrir', 29),
            ('MSG_FILE_SAVED', 'File saved.', 'es_mx', 'Archivo guardado.', 29),
            ('WARNING_DOWNLOAD_FAIL', 'Download fail!, please try after sometime.', 'es_mx', 'La descarga no pudo completarse, favor de intentar más tarde', 29),
            ('LBL_SHORTCUT', 'Shortcut', 'es_mx', 'Acceso directo', 29),
            ('TXT_MESSAGE_PLACEHOLDER', 'Type Message', 'es_mx', 'Escribir mensaje', 29),
            ('ALERT_INSTALL_WHATSAPP', 'Install Whatsapp', 'es_mx', 'Instalar Whatsapp', 29),
            ('MSG_NO_MAIL_BOX', 'No MailBox found. Please Create Mailbox', 'es_mx', 'No se encontró el Buzón de correo. Por favor crear Buzón de correo', 29),
            ('LBL_WROTE', 'Wrote', 'es_mx', 'Escrito', 29),
            ('MSG_MAIL_SEND', 'Mail sent', 'es_mx', 'Correo enviado', 29),
            ('log_file_not_found', 'API Log file not found.', 'es_mx', 'No se encontró el archivo API Log', 29),
            ('unknown_error', 'An unknown error occurred, try again', 'es_mx', 'Ocurrió un error desconocido, trate nuevamente', 29),
            ('CTMTigerAppVersion', 'CRMTiger App Version', 'es_mx', 'Versión de App CRMTiger', 29),
            ('CTMMobileUpdateMsg', 'CTMobile Ext. Version Update Successfully', 'es_mx', 'Versión CTMMobile Ext. actualizada exitosamente', 29),
            ('dialog_Premium_downgrade', 'Downgrade will required logout and login again later', 'es_mx', 'Necesitará cerrar e iniciar sesión más tarde para hacer el downgrade', 29),
            ('dialog_Premium', 'Upgrade will required logout and login again later', 'es_mx', 'Necesitará cerrar e iniciar sesión más tarde para hacer el upgrade', 29),
            ('Overwrite', 'Overwrite', 'es_mx', 'Sobreescribir', 29),
            ('MSGAddressOverwrite1', 'Overwrite the existing address with the selected', 'es_mx', 'Sobreescribir la dirección existente con la que está seleccionada', 29),
            ('MSGAddressOverwrite2', 'address details?', 'es_mx', '¿Detalles de la dirección?', 29),
            ('UPGRADE_PLAN', 'Upgrade Plan', 'es_mx', 'Plan de upgrade', 29),
            ('DOWNGRADE_PLAN', 'Downgrade Plan', 'es_mx', 'Plan de downgrade', 29),
            ('UPGRADE_EXTENSION', 'Upgrade Extension', 'es_mx', 'Extensión de upgrade', 29),
            ('UPGRADE_APP', 'Upgrade App', 'es_mx', 'App de upgrade', 29),
            ('SELECT_OPTION', 'Select Option', 'es_mx', 'Seleccionar opción', 29),
            ('PLEASE_SELECT', 'Please select', 'es_mx', 'Por favor seleccione ', 29),
            ('MSG_ACCESS_DENIED', 'You don\'t have permission for this module.', 'es_mx', 'No tiene permiso para este módulo.', 29),
            ('MSG_SELECT_RECCURING_MONTH_DAY', 'Please select reccuring day of month.', 'es_mx', 'Por favor seleccione día del mes recurrente.', 29),
            ('MSG_SELECT_RECCURING_WEEK_DAY', 'Please select reccuring day of week.', 'es_mx', 'Por favor seleccione un día de la semana recurrente.', 29),
            ('MSG_SELECT_RECCURING_DAYS', 'Please select reccuring days.', 'es_mx', 'Por favor seleccione días recurrentes.', 29),
            ('Please select reccuring days.', 'Please select reccuring days.', 'es_mx', 'Por favor seleccione días recurrentes.', 29),
            ('MSG_SELECT_RECCURING_END_DATE', 'Please select reccuring end date.', 'es_mx', 'Por favor seleccione fecha de término recurrente.', 29),
            ('MSG_SELECT_RECCURING_TYPE', 'Please select reccuring type.', 'es_mx', 'Por favor seleccione tipo recurrente', 29),
            ('FREQ_TIME', 'Times', 'es_mx', 'Horarios', 29),
            ('REPEAT_YEARLY', 'Repeat Yearly', 'es_mx', 'Repetir anualmente', 29),
            ('REPEAT_MONTHLY', 'Repeat Monthly', 'es_mx', 'Repetir mensualmente', 29),
            ('REPEAT_WEEKLY', 'Repeat Weekly', 'es_mx', 'Repetir semanalmente', 29),
            ('REPEAT_DAILY', 'Repeat Daily', 'es_mx', 'Repetir diariamente', 29),
            ('ACTION_TITLE', 'Action Title', 'es_mx', 'Título de la acción', 29),
            ('MSG_SELECT_VALID_DATE', 'Please select valid day of month.', 'es_mx', 'Por favor seleccione un día del mes válido', 29),
            ('MSG_SELECT_VALID_START_DATE', 'Start date should be less than end date.', 'es_mx', 'La fecha de inicio debe ser menor que la fecha de término', 29),
            ('MSG_SELECT_VALID_START_TIME', 'Start time should be less than end time.', 'es_mx', 'La hora de inicio debe ser menor que la fecha de término', 29),
            ('LBL_LINEITEM_DETAILS', 'Lineitem Details', 'es_mx', 'Detalles de objetos de línea', 29),
            ('MSG_INVALIDE_DISCOUNT_AMOUNT', 'Discount amount should be less than the total.', 'es_mx', 'El monto del descuento debe ser menor al total.', 29),
            ('VIEW', 'View', 'es_mx', 'Ver', 29),
            ('MSG_ENTER_VALID', 'Please enter valid', 'es_mx', 'Por favor ingrese un valor válido', 29),
            ('MSG_ENTER_PERCENTAGE', 'Percentage should be less than 100.', 'es_mx', 'El porcentaje debe ser menor a 100.', 29),
            ('ITEM_TOTAL', 'Item Total', 'es_mx', 'Total de objetos', 29),
            ('ADJUSTMENT', 'Adjustment', 'es_mx', 'Ajuste', 29),
            ('TITLE_CHOOSE_IMAGE', 'Choose Image', 'es_mx', 'Seleccionar imagen', 29),
            ('COMPRESS', 'Compress', 'es_mx', 'Comprimir', 29),
            ('CHOOSE_ANOTHER_IMAGE', 'Your image size is too large, please select another image', 'es_mx', 'El tamaño de la imagen es muy grande, por favor seleccione otra imagen', 29),
            ('OnDayOfMonth', 'On day of month', 'es_mx', 'El día del mes', 29),
            ('OnDayOfWeek', 'On day of week', 'es_mx', 'El día de la semana', 29),
            ('AddAndClose', 'Add & Close', 'es_mx', 'Añadir & Cerrar', 29),
            ('Repeat', 'Repeat', 'es_mx', 'Repetir', 29),
            ('OnDay', 'On day', 'es_mx', 'El día', 29),
            ('View_Line_Item', 'View Line Item', 'es_mx', 'Ver objeto de línea', 29),
            ('TITLE_IMAGE', 'Image', 'es_mx', 'Imagen', 29),
            ('TITLE_ICLOUD', 'iCloud', 'es_mx', 'iCloud', 29),
            ('GOOGLE', 'Google', 'es_mx', 'Google', 29),
            ('ALERT_BTN_OKAY', 'Okay', 'es_mx', 'Ok', 29),
            ('ALERT_TITLE_ACCESS_DENIED', 'Access Denied', 'es_mx', 'Acceso denegado', 29),
            ('Dont_Show_Again', 'Don\'t show again', 'es_mx', 'No mostrar de nuevo', 29),
            ('Skip', 'Skip', 'es_mx', 'Saltar', 29),
            ('Fillter_Name', 'Fillter Name', 'es_mx', 'Nombre del filtro', 29),
            ('Fillter_Record_Count', 'Fillter Record Count', 'es_mx', 'Count del registro del filtro', 29),
            ('url_note',      'Note : if your URL of CRM is https://example.com/crm enter that into above box',   'es_mx',    'Note : if your URL of CRM is https://example.com/crm enter that into above box',   31),
            ('vtiger_url',    'Your vTiger CRM URL',  'es_mx',    'Your vTiger CRM URL',  31),
            ('msg_doc_read_permission',   'You don\'t have permission to Add either This is read-only or Private Field.',     'es_mx',    'You don\'t have permission to Add either This is read-only or Private Field.',     31),
            ('CLEAR',   'Clear',    'es_mx',    'Clear',    31),
            ('Files/photos uploaded successfully',    'Files/photos uploaded successfully',     'es_mx',    'Files/photos uploaded successfully',     32),
            ('Digital signature saved',   'Digital signature saved',    'es_mx',    'Digital signature saved',    32),
            ('Please upload Signature or Files/photos',     'Please upload Signature or Files/photos',      'es_mx',    'Please upload Signature or Files/photos',      32),
            ('Files / Photos',      'Files / Photos', 'es_mx',    'Files / Photos', 32),
            ('Signature',     'Signature',      'es_mx',    'Signature',      32),
            ('add_photo_using',     'Add Photo Using',      'es_mx',    'Add Photo Using',      31),
            ('btn_upload_sign',     '(+) Add Signature',    'es_mx',    '(+) Add Signature',    31),
            ('btn_upload_photo_doc',      '(+) Upload Files/Photos',    'es_mx',    '(+) Upload Files/Photos',    31),
            ('select_photo_doc_to_upload',      'Please select files/photos to upload',   'es_mx',    'Please select files/photos to upload',   31),
            ('related_module_title',      'Search from related module and Add to \"Route\"',    'es_mx',    'Search from related module and Add to \"Route\"',    30),
            ('Route status updated successfully',     'Route status updated successfully',      'es_mx',    'Route status updated successfully',      32),
            ('Session init failed', 'Session init failed',  'es_mx',    'Session init failed',  32),
            ('You don\'t have permission to access this resource',      'You don\'t have permission to access this resource', 'es_mx',    'You don\'t have permission to access this resource', 32),
            ('ctroute_realtedto cannot be empty',     'Could not get the Related To - Try again later',     'es_mx',    'Could not get the Related To - Try again later',     32),
            ('ctroute_planning cannot be empty',      'Could not get the Route Planning Record - Try again later',      'es_mx',    'Could not get the Route Planning Record - Try again later',      32),
            ('Something went wrong - Try again later',      'Something went wrong - Try again later', 'es_mx',    'Something went wrong - Try again later', 32),
            ('sequence updated successfully',   'sequence updated successfully',    'es_mx',    'sequence updated successfully',    32),
            ('sequence cannot be empty',  'sequence cannot be empty',   'es_mx',    'sequence cannot be empty',   32),
            ('Shortcut details not saved',      'Shortcut details not saved', 'es_mx',    'Shortcut details not saved', 32),
            ('Shortcut details saved successfully',   'Shortcut details saved successfully',    'es_mx',    'Shortcut details saved successfully',    32),
            ('Route save successfully',   'Route save successfully',    'es_mx',    'Route save successfully',    32),
            ('Record save successfully',  'Record save successfully',   'es_mx',    'Record save successfully',   32),
            ('No dependency found for picklist',      'No dependency found for picklist', 'es_mx',    'No dependency found for picklist', 32),
            ('No records found',    'No records found',     'es_mx',    'No records found',     32),
            ('Outgoing server is not enabled, please configure from CRM',     'Outgoing server is not enabled, please configure from CRM',      'es_mx',    'Outgoing server is not enabled, please configure from CRM',      32),
            ('Removed Successfully',      'Removed Successfully', 'es_mx',    'Removed Successfully', 32),
            ('Shortcut has been deleted', 'Shortcut has been deleted',  'es_mx',    'Shortcut has been deleted',  32),
            ('relation of records removed successfully',    'relation of records removed successfully',     'es_mx',    'relation of records removed successfully',     32),
            ('relation of records not removed', 'relation of records not removed',  'es_mx',    'relation of records not removed',  32),
            ('Record has been deleted successfully',  'Record has been deleted successfully',   'es_mx',    'Record has been deleted successfully',   32),
            ('Time Tracking saved successfully',      'Time Tracking saved successfully', 'es_mx',    'Time Tracking saved successfully', 32),
            ('Time Tracking updated successfully',    'Time Tracking updated successfully',     'es_mx',    'Time Tracking updated successfully',     32),
            ('Time Tracking ended successfully',      'Time Tracking ended successfully', 'es_mx',    'Time Tracking ended successfully', 32),
            ('Time Tracking started successfully',    'Time Tracking started successfully',     'es_mx',    'Time Tracking started successfully',     32),
            ('record cannot be empty',    'record cannot be empty',     'es_mx',    'record cannot be empty',     32),
            ('Module is disabled',  'Module is disabled',   'es_mx',    'Module is disabled',   32),
            ('Shift ended successfully',  'Shift ended successfully',   'es_mx',    'Shift ended successfully',   32),
            ('Shift started successfully',      'Shift started successfully', 'es_mx',    'Shift started successfully', 32),
            ('relation of records added successfully',      'relation of records added successfully', 'es_mx',    'relation of records added successfully', 32),
            ('Comment saved successfully',      'Comment saved successfully', 'es_mx',    'Comment saved successfully', 32),
            ('Comment not saved',   'Comment not saved',    'es_mx',    'Comment not saved',    32),
            ('Comment module is not active',    'Comment module is not active',     'es_mx',    'Comment module is not active',     32),
            ('No Upcoming Event',   'No Upcoming Event',    'es_mx',    'No Upcoming Event',    32),
            ('No Templates found - create it from Message Templates module',  'No Templates found - create it from Message Templates module',   'es_mx',    'No Templates found - create it from Message Templates module',   32),
            ('No event or task for this date',  'No event or task for this date',   'es_mx',    'No event or task for this date',   32),
            ('No filters created',  'No filters created',   'es_mx',    'No filters created',   32),
            ('Select at least one record to attach',  'Select at least one record to attach',   'es_mx',    'Select at least one record to attach',   32),
            ('Please select one or more attachments', 'Please select one or more attachments',  'es_mx',    'Please select one or more attachments',  32),
            ('No event for this month',   'No event for this month',    'es_mx',    'No event for this month',    32),
            ('No Activity found',   'No Activity found',    'es_mx',    'No Activity found',    32),
            ('Your feedback is valuable for us - it cannot be empty',   'Your feedback is valuable for us - it cannot be empty',    'es_mx',    'Your feedback is valuable for us - it cannot be empty',    32),
            ('Could not send mail, Please try later', 'Could not send mail, Please try later',  'es_mx',    'Could not send mail, Please try later',  32),
            ('Latest Version updated successfully',   'Latest Version updated successfully',    'es_mx',    'Latest Version updated successfully',    32),
            ('User Location Updated Successfully',    'User Location Updated Successfully',     'es_mx',    'User Location Updated Successfully',     32),
            ('User Location not Updated Successfully',      'User Location not Updated Successfully', 'es_mx',    'User Location not Updated Successfully', 32),
            ('SMSNotifier is not enable in CRM. Please enable it first',      'SMSNotifier is not enable in CRM. Please enable it first', 'es_mx',    'SMSNotifier is not enable in CRM. Please enable it first', 32),
            ('Could not submit your feedback - Please try again later', 'Could not submit your feedback - Please try again later',  'es_mx',    'Could not submit your feedback - Please try again later',  32),
            ('Thank you for submitting your feedback',      'Thank you for submitting your feedback', 'es_mx',    'Thank you for submitting your feedback', 32),
            ('Please upload User Image',  'Please upload User Image',   'es_mx',    'Please upload User Image',   32),
            ('Image Not Uploading, please try again', 'Image Not Uploading, please try again',  'es_mx',    'Image Not Uploading, please try again',  32),
            ('User Image Uploaded Successfully',      'User Image Uploaded Successfully', 'es_mx',    'User Image Uploaded Successfully', 32),
            ('Invalid Module name', 'Invalid Module name',  'es_mx',    'Invalid Module name',  32),
            ('Records Sync Successfully', 'Records Sync Successfully',  'es_mx',    'Records Sync Successfully',  32),
            ('Values cannot be empty',    'Values cannot be empty',     'es_mx',    'Values cannot be empty',     32),
            ('Record id is empty',  'Record id is empty',   'es_mx',    'Record id is empty',   32),
            ('Logout Successfully', 'Logout Successfully',  'es_mx',    'Logout Successfully',  32),
            ('Please Enable CTMobile Module',   'Please Enable CTMobile Module',    'es_mx',    'Please Enable CTMobile Module',    32),
            ('Authentication Failed',     'Username and Password do not match',     'es_mx',    'Username and Password do not match',     32),
            ('Mismatched module information',   'Something gone wrong, please try again later', 'es_mx',    'Something gone wrong, please try again later', 32),
            ('Field does not exists',     'Please set display fields again',  'es_mx',    'Please set display fields again',  32),
            ('Module does not exists',    'Module does not exists or disabled by admin',  'es_mx',    'Module does not exists or disabled by admin',  32),
            ('Month cannot be empty',     'Could not get the Month - Try again later',    'es_mx',    'Could not get the Month - Try again later',    32),
            ('Year cannot be empty',      'Could not get the Year - Try again later',     'es_mx',    'Could not get the Year - Try again later',     32),
            ('Date cannot be empty',      'Could not get the Date - Try again later',     'es_mx',    'Could not get the Date - Try again later',     32),
            ('Userid cannot be empty',    'Could not get the Userid - Try again later',   'es_mx',    'Could not get the Userid - Try again later',   32),
            ('End Date cannot be empty',  'Could not get the status - Try again later',   'es_mx',    'Could not get the status - Try again later',   32),
            ('Start Date cannot be empty',      'Could not get the Start Date - Try again later',     'es_mx',    'Could not get the Start Date - Try again later',     32),
            ('You do not configure SMS Notifier in CRM. Please configure SMS Notifier in your CRM to use this feature', 'You do not configure SMS Notifier in CRM. Please configure SMS Notifier in your CRM to use this feature',  'es_mx',    'You do not configure SMS Notifier in CRM. Please configure SMS Notifier in your CRM to use this feature',  32),
            ('Longitude cannot be empty', 'Could not get location-Please try again',      'es_mx',    'Could not get location-Please try again',      32),
            ('Latitude cannot be empty',  'Could not get location-Please try again',      'es_mx',    'Could not get location-Please try again',      32),
            ('User cannot be empty',      'Could not get the User - Try again later',     'es_mx',    'Could not get the User - Try again later',     32),
            ('Status cannot be empty',    'Could not get the status - Try again later',   'es_mx',    'Could not get the status - Try again later',   32),
            ('Required fields not found', 'Required fields not found',  'es_mx',    'Required fields not found',  32),
            ('Tracking module not active',      'Tracking module not active-Please contact CRM Admin',      'es_mx',    'Tracking module not active-Please contact CRM Admin',      32),
            ('Missing mandatory input values',  'Missing mandatory input values',   'es_mx',    'Missing mandatory input values',   32),
            ('No MailBox found. Please Create Mailbox',     'No MailBox found. Please Create Mailbox',      'es_mx',    'No MailBox found. Please Create Mailbox',      32),
            ('Mail not sent', 'Mail not sent',  'es_mx',    'Mail not sent',  32),
            ('Mail send successfully',    'Mail send successfully',     'es_mx',    'Mail send successfully',     32),
            ('Email Id or username not match with your record',   'Email Id or username not match with your record',    'es_mx',    'Email Id or username not match with your record',    32),
            ('Module not specified',      'Module not specified', 'es_mx',    'Módulo no especificado', 32),
            ('No messages found',   'No messages found',    'es_mx',    'Mensajes no encontrados',    32),
            ('No Dependency Found For This Module',   'No Dependency Found For This Module',    'es_mx',    'No se ha encontrado dependencia para este módulo',    32),
            ('Outgoing server is not Enabled',  'Outgoing server is not Enabled',   'es_mx',    'El servidor de salida no está habilitado',   32),
            ('Outgoing server is Enabled',      'Outgoing server is Enabled', 'es_mx',    'El servidor de salida está habilitado', 32),
            ('Email Attached Successfully',     'Email Attached Successfully',      'es_mx',    'Email adjuntado exitosamente',      32),
            ('Documents Attached Successfully', 'Documents Attached Successfully',  'es_mx',    'Documentos adjuntados exitosamente',  32),
            ('Login required - Please login again',   'Login required - Please login again',    'es_mx',    'Inicio de sesión requerido - Favor de iniciar sesión nuevamente',    32),
            ('time_tracking_module_disable',    'Time tracking module is disable',  'es_mx',    'El módulo de rastreo de tiempo está deshabilitado',  31),
            ('route_planning_module_disable',   'Route planning module is disable', 'es_mx',    'El módulo de planeación de ruta está deshabilitado', 31),
            ('mark_as_held',  'Are you sure you want to mark Event as Held?', 'es_mx',    '¿Está seguro de que desea marcar el Evento como realizado?', 31),
            ('stop_timer_msg',      'You have already started Time tracking for another record, Do you want to stop it first ?',    'es_mx',    'Ya ha iniciado el rastreo de tiempo para otro registro. ¿Desea detenerlo primero?',    31),
            ('access_denied_routeplanning',     'Access denied for route planning', 'es_mx',    'Acceso denegado para plan de ruta', 31),
            ('time_spent',    'Time Spent',     'es_mx',    'Tiempo transcurrido',     31),
            ('select_user',   'Select User',    'es_mx',    'Seleccionar usuario',    30),
            ('status_cannot_be_held',     'Status cannot be held for future date start',  'es_mx',    'El estatus no puede realizarse para una fecha de inicio en el futuro',  30),
            ('please_select_end_date',    'Please select end date',     'es_mx',    'Favor de seleccionar fecha de término',     30),
            ('please_select_start_date',  'Please select start date',   'es_mx',    'Favor de seleccionar fecha de inicio',   30),
            ('tap_on_plus_icon_for_select_route',     'Tap on + icon to select record for your route.',     'es_mx',    'Toque el ícono de + para seleccionar el registro para su ruta.',     30),
            ('please_enter_notes',  'Please enter notes',   'es_mx',    'Favor de ingresar notas',   30),
            ('please_enter_title',  'Please enter title',   'es_mx',    'Favor de ingresar título',   30),
            ('please_select_date',  'Please Select Date',   'es_mx',    'Favor de seleccionar fecha',   30),
            ('search_by_date',      'Search by Date', 'es_mx',    'Search by Date', 30),
            ('shortcut_not_setup_yet',    'Opps shortcut not setup yet!!! Please add shortcut by click on [icon] from record search results or view record screen.',    'es_mx',    '¡Ups, el acceso directo no se ha creado todavía! Por favor añada un acceso directo al hacer clic + ícono desde los resultados de la búsqueda del registro o de la pantalla.',    30),
            ('max_upload_size',     'max file Upload exceeds',    'es_mx',    'El tamaño de carga máximo se ha exedido',    30),
            ('unselect_all',  'UnSelect All',   'es_mx',    'Des-seleccionar todo',   30),
            ('select_all',    'Select All',     'es_mx',    'Seleccionar todo',     30),
            ('please_select_records',     'Please select records',      'es_mx',    'Favor de seleccionar registros',      30),
            ('select_date',   'Select Date',    'es_mx',    'Seleccionar fecha',    30),
            ('quantity_in_stock_is',      'Quantity in stock is', 'es_mx',    'La cantidad en stock es', 30),
            ('replies', 'Replies',  'es_mx',    'Responde',  30),
            ('conversation_require_selection',  'Conversion requires selection of Contact or Organization', 'es_mx',    'La conversión requiere seleccionar un Contacto o una Cuenta', 30),
            ('please_select_product',     'Please Select Product',      'es_mx',    'Favor de seleccionar el Producto',      30),
            ('timer_msg',     'You can start timer for single task only at same time',    'es_mx',    'Puede iniciar el timer solo para una tarea específica al mismo tiempo',    31),
            ('save_start_tracking', 'Save & Start Tracking',      'es_mx',    'Guardar & Iniciar el rastreo',      31),
            ('lbl_notes',     'Notes',    'es_mx',    'Notas',    31),
            ('enter_title',   'Enter Title',    'es_mx',    'Ingresar título',    31),
            ('select_module_record',      'Select Module / Record',     'es_mx',    'Seleccionar módulo / registro',     31),
            ('lbl_tomorrow',  'Tomorrow', 'es_mx',    'Mañana', 30),
            ('lbl_yesterday', 'Yesterday',      'es_mx',    'Ayer',      30),
            ('lbl_today',     'Today',    'es_mx',    'Hoy',    30),
            ('time_tracker',  'Time Tracker',   'es_mx',    'Rastreo de tiempo',   31),
            ('time_end',      'End Time', 'es_mx',    'Hora de término', 5),
            ('due_date',      'End Date', 'es_mx',    'Fecha de término', 5),
            ('time_start',    'Time Start',     'es_mx',    'Hora de inicio',     5),
            ('date_start',    'Start Date',     'es_mx',    'Fecha de inicio',     5),
            ('delete_widget_msg',   'Display widget again by using (+) option',     'es_mx',    'Desplegar widget nuevamente usando opción (+)',     15),
            ('no_upcoming_activities',    'No scheduled activities      ',    'es_mx',    'No hay actividades programadas',    15),
            ('check_in_first',      'Please check-in first',      'es_mx',    'Please check-in first',      30),
            ('duration',      'Duration', 'es_mx',    'Duración', 30),
            ('distance',      'Distance', 'es_mx',    'Distancia', 30),
            ('proper_address_message',    'Please enter proper address in record\n',      'es_mx',    'Por favor ingrese una dirección correcta en el registro',  30),
            ('select_status', 'Select Status',  'es_mx',    'Seleccionar estatus',  30),
            ('route_planner', 'Route Planner',  'es_mx',    'Planeador de ruta',  30),
            ('route_planning',      'Route Planning', 'es_mx',    'Plan de ruta', 30),
            ('add_route',     'Add Route',      'es_mx',    'Añadir ruta',      30),
            ('calender_disabled',   'Calendar Module is disabled',      'es_mx',    'Módulo de calendario deshabilitado',      30),
            ('close_dialog',  'Close form',     'es_mx',    'Cerrar desde',     30),
            ('cancel_form_message', 'Are You sure want to close ?',     'es_mx',    '¿Está seguro de que quiere cerrar?',     30),
            ('create_route',  'Create Route',   'es_mx',    'Crear ruta',   30),
            ('select_module_create_route',      'Select Module to create Route',    'es_mx',    'Seleccionar módulo para crear ruta',    30),
            ('cancel',  'Cancel',   'es_mx',    'Cancelar',   30),
            ('assign_route',  'Assign Route',   'es_mx',    'Asignar ruta',   30),
            ('route_for',     'Route for',      'es_mx',    'Ruta para',      30),
            ('assigned_to',   'Assigned To',    'es_mx',    'Asignado a',    30),
            ('enter_route_name',    'Enter Route Name',     'es_mx',    'Ingrese nombre de ruta',     30),
            ('list',    'List',     'es_mx',    'Lista',     30),
            ('map',     'Map',      'es_mx',    'Mapa',      30),
            ('other_modules', 'Other Modules',  'es_mx',    'Otros módulos',  15),
            ('shortcut_no_record_msg',    'Opps shortcut not setup\n yet!!! Please add shortcut  by click on + icon from record\n search results or view record screen.',     'es_mx',    '¡Ups, el acceso directo no se ha creado todavía! Por favor añada un acceso directo al hacer clic + ícono desde los resultados de la búsqueda del registro o de la pantalla de vista de registros.',     25),
            ('clear',   'Clear',    'es_mx',    'Limpiar',    25),
            ('open',    'Open',     'es_mx',    'Abrir',     11),
            ('max_file_msg',  'Too many files selected (max:6)',  'es_mx',    'Se han seleccionado demasiados archivos (max: 6)',  11),
            ('error_voicenote_record',    'Unable to recording voice while another application is recording sound.',    'es_mx',    'No se puede grabar mietnras otrs aplicación está grabando sonido.',    11),
            ('msg_warning',   'Warning!', 'es_mx',    '¡Advertencia!', 11),
            ('Permision_denied_contact',  'Permission denied to access your contacts',    'es_mx',    'Permiso denegado para accesar sus contactos',    15),
            ('no_widget_added',     'Please click + icon to add new widget to your dashboard.', 'es_mx',    'Favor de hacer clic + ícono para añadir en nuevo widget a su tablero.', 15),
            ('no_data_available',   'Data not available, please check the selected fields',     'es_mx',    'Información no disponible, favor de verificar los campos seleccionados',     15),
            ('check_out_successfully',    'Check out successfully',     'es_mx',    'Checked out successfully',   11),
            ('check_in_successfully',     'Check in successfully',      'es_mx',    'Checked in successfully',    11),
            ('check_out',     'Check out',      'es_mx',    'Check out',      11),
            ('check_in',      'Check in', 'es_mx',    'Check in', 11),
            ('navigate',      'Navigate', 'es_mx',    'Navegar', 11),
            ('save_to_phone_vcard_success',     'VCard Saved to phone successfully',      'es_mx',    'La VCard se guardó en el teléfono exitosamente',      15),
            ('download_vcard_success',    'VCard downloaded successfully',    'es_mx',    'La VCard se descargó exitosamente',    15),
            ('card_details',  'Card Details',   'es_mx',    'Detalles de la tarjeta',   15),
            ('add_widget',    'Add Widget',     'es_mx',    'Añadir widget',     15),
            ('delete_widget', 'Are you sure to hide widget?',     'es_mx',    'Está seguro de que quiere esconder el widget?',     15),
            ('already_widgets_added',     'All types of Widget & reports are already added',    'es_mx',    'Todos los tipos de widget & reportes ya están añadidos',    15),
            ('retry',   'Retry',    'es_mx',    'Volver a intentar',    28),
            ('retake',  'Retake',   'es_mx',    'Retake',   28),
            ('Reports', 'Reports',  'es_mx',    'Reportes',  15),
            ('Widgets', 'Widgets',  'es_mx',    'Widgets',  15),
            ('vcard_config',  'Vcard Configuration',  'es_mx',    'Configuración Vcard',  8),
            ('save_to_phone', 'Save to phone',  'es_mx',    'Guardar en teléfono',  11),
            ('download_vcard',      'Download Vcard', 'es_mx',    'Descargar Vcard', 11),
            ('share_vcard',   'Share Vcard',    'es_mx',    'Compartir Vcard',    11),
            ('share_record',  'Share Record',   'es_mx',    'Compartir registro',   11),
            ('permission_denied_edit',    'You don\'t have permission to edit this record.',    'es_mx',    'No tiene permiso para editar este registro.',    27),
            ('permission_denied_delete',  'You don\'t have permission to delete this record.',  'es_mx',    'No tiene permiso para borrar este registro.',  27),
            ('Voice_Recording_Started',   'Recording Started',    'es_mx',    'El registro inició',    12),
            ('Voice_Recording_Stopped',   'Recording Stopped',    'es_mx',    'El registro se detuvo',    12),
            ('SEARCH',  'Search',   'es_mx',    'Búsqueda',   7),
            ('LAST',    'Last',     'es_mx',    'Último',     7),
            ('FIRST',   'First',    'es_mx',    'Primero',    7),
            ('MONDAY',  'Monday',   'es_mx',    'Lunes',   7),
            ('TUESDAY', 'Tuesday',  'es_mx',    'Martes',  7),
            ('WEDNESDAY',     'Wednesday',      'es_mx',    'Miércoles',      7),
            ('THURSDAY',      'Thursday', 'es_mx',    'Jueves', 7),
            ('FRIDAY',  'Friday',   'es_mx',    'Viernes',   7),
            ('SATURDAY',      'Saturday', 'es_mx',    'Sábado', 7),
            ('SUNDAY',  'Sunday',   'es_mx',    'Domingo',   7),
            ('DAILY',   'Daily',    'es_mx',    'Diariamente',    7),
            ('WEEKLY',  'Weekly',   'es_mx',    'Semanalmente',   7),
            ('MONTHLY', 'Monthly',  'es_mx',    'Mensualmente',  7),
            ('YEARLY',  'Yearly',   'es_mx',    'Anualmente',   7),
            ('asset_tracking',      'Asset tracking', 'es_mx',    'Rastreo de activos', 15);",array());
    }

    static function ja_jp(){
        global $adb;
        $checkQuery = "DELETE FROM ctmobile_language_keyword WHERE keyword_lang = ?";
        $checkResult = $adb->pquery($checkQuery,array('ja_jp'));

        $adb->pquery("INSERT INTO `ctmobile_language_keyword` (`keyword`, `keyword_name`, `keyword_lang`, `language_keyword`, `sectionid`) VALUES
            ('network_error', 'Network connection error!', 'ja_jp', 'ネットワークエラー！', 1),
            ('connection_check', 'Could not connect to CRM, Please check your Internet connection.', 'ja_jp', 'インターネット接続を確認してください。', 1),
            ('update', 'Update', 'ja_jp', 'Update', 1),
            ('cancel', 'Cancel', 'ja_jp', 'キャンセル', 1),
            ('ok', 'Ok', 'ja_jp', 'OK', 1),
            ('more_information', 'Click here for more information.', 'ja_jp', '詳細についてはここをクリックしてください。', 1),
            ('yes', 'Yes', 'ja_jp', 'はい', 1),
            ('no', 'No', 'ja_jp', 'いいえ', 1),
            ('click_again_exit', 'Click again to exit', 'ja_jp', 'もう一度クリックして終了', 1),
            ('forpermission', 'You don\'t have permission to view this feature. Please subscribe for Premium version Click here to Subscribe.', 'ja_jp', 'この機能を表示する権限がありません。プレミアムバージョンを購読する購読するにはここをクリックしてください。', 1),
            ('clickhere', 'Click here', 'ja_jp', 'ここをクリック', 1),
            ('clickhere_subscribe', 'Click here to subscribe premium version', 'ja_jp', '購読するにはここをクリック', 1),
            ('clickhere_configure', 'Click here and view how to Configure.', 'ja_jp', 'こちらをクリックして設定方法をご覧ください。', 1),
            ('please_wait', 'Please Wait…', 'ja_jp', 'お待ちください…', 1),
            ('share__msg', 'Share file with', 'ja_jp', 'ファイルを共有', 1),
            ('dialog_camera', 'Camera', 'ja_jp', 'カメラで撮影', 1),
            ('dialog_add_file_by', 'Take Photo from', 'ja_jp', 'ファイルを追加：', 1),
            ('add', 'Add', 'ja_jp', '追加', 1),
            ('mail_manager_configured', 'Mail Manager is not configured', 'ja_jp', 'メールマネージャが設定されていません', 1),
            ('dialog_add_files_by', 'Add Files by', 'ja_jp', 'ファイルを追加', 1),
            ('dialog_drive', 'Drive', 'ja_jp', 'Google Drive', 1),
            ('dialog_drop_box', 'Drop Box', 'ja_jp', 'Dropbox', 1),
            ('dialog_need_signin', 'You need to Sign-in to your Drive account first.', 'ja_jp', '最初にサインインする必要があります', 1),
            ('dialog_gallery', 'Gallery', 'ja_jp', 'ファイルを選択', 1),
            ('delete', 'Delete', 'ja_jp', '削除', 1),
            ('timeoutmessage', 'Oops! Request is taking more time than expected.', 'ja_jp', 'おっとリクエストに予想より時間がかかります。', 1),
            ('gps_location_message', 'GPS is not enabled. Please turn it on to get your near by locations.', 'ja_jp', 'GPSが有効になっていません。場所によってあなたの近くを得るためにそれをつけてください。', 1),
            ('sure_want_delete', 'Are you sure want to delete ?', 'ja_jp', '削除しますか？', 1),
            ('select', 'Select', 'ja_jp', '選択', 1),
            ('msgforrecordaudio', 'Minimum record duration one second.', 'ja_jp', '最小レコード期間1/2',1),
            ('permission_storage', 'Permission denied to read your External storage', 'ja_jp', '外部ストレージのアクセスが拒否されました', 1),
            ('send_permission_msg', 'Send message permission denied', 'ja_jp', 'メッセージ送信が拒否されました', 1),
            ('choosefile', 'Choose File', 'ja_jp', 'ファイルを選択', 1),
            ('enter', 'Enter', 'ja_jp', '入力：', 1),
            ('select_an_option', 'Select an Option', 'ja_jp', 'オプションの選択', 1),
            ('email_validation', 'Email is not valid', 'ja_jp', 'メールアドレスが無効です', 1),
            ('please_enter', 'Please Enter', 'ja_jp', '入力してください ', 1),
            ('website_validation_text', 'Website URL is not valid', 'ja_jp', 'ウェブサイトのURLが無効です', 1),
            ('selectvalue', 'Select value first', 'ja_jp', '最初に値を選択', 1),
            ('email', 'Email', 'ja_jp', 'メール', 1),
            ('enter_email_address', 'Enter email address', 'ja_jp', 'メールアドレスを入力してください', 1),
            ('email_address_not_correct', 'Email address incorrect', 'ja_jp', 'メールアドレスが正しくありません', 1),
            ('pls_enter_subject', 'Please Enter Subject', 'ja_jp', '件名を入力してください', 1),
            ('attachFiles', 'Attached File', 'ja_jp', '添付ファイル', 1),
            ('from', 'From', 'ja_jp', 'FROM', 1),
            ('to', 'To', 'ja_jp', 'TO', 1),
            ('call_permission_msg', 'Call permission denied', 'ja_jp', '通話が拒否されました', 1),
            ('no_records', 'No records found', 'ja_jp', 'レコードが見つかりません', 1),
            ('fullform', 'Create New', 'ja_jp', '詳細画面', 1),
            ('save', 'Save', 'ja_jp', '保存', 1),
            ('total', 'Total', 'ja_jp', '合計', 1),
            ('discount', 'Discount', 'ja_jp', '割引', 1),
            ('price', 'Price', 'ja_jp', '価格', 1),
            ('quantity', 'Quantity', 'ja_jp', '数量', 1),
            ('select_module', 'Select Module', 'ja_jp', 'モジュールを選択', 1),
            ('item_list', 'Item List', 'ja_jp', 'アイテムリスト', 1),
            ('quickcreate', 'Quick Create', 'ja_jp', 'クイック作成', 1),
            ('overwrite_msg_part1', 'Overwrite the existing address with the selected', 'ja_jp', '既存の選択したアドレスを上書きする', 1),
            ('once_in_every', 'Once in every', 'ja_jp', '一度に一回', 1),
            ('overwrite_msg_part2', 'address details?', 'ja_jp', '住所の詳細', 1),
            ('add_item', 'Add Item', 'ja_jp', 'アイテムを追加', 1),
            ('recordsave', 'Record saved successfully', 'ja_jp', '保存しました', 1),
            ('recordnotsave', 'Could not save record. Try again later', 'ja_jp', '保存されませんでした', 1),
            ('minutes', 'Minutes', 'ja_jp', '議事録', 1),
            ('hours', 'Hours', 'ja_jp', '時間', 1),
            ('days', 'Days', 'ja_jp', '日々', 1),
            ('on', 'On', 'ja_jp', 'に', 1),
            ('day_of_the_month', 'day of the month', 'ja_jp', '月の日', 1),
            ('list_price', 'List Price', 'ja_jp', '定価', 1),
            ('add_record', 'Add Record', 'ja_jp', 'レコードを追加', 1),
            ('add_product', 'Add Product', 'ja_jp', '商品を追加', 1),
            ('add_service', 'Add Service', 'ja_jp', 'サービスを追加', 1),
            ('discountin', 'Discount in %', 'ja_jp', '％での割引', 1),
            ('unitprice', 'Unit price', 'ja_jp', '単価', 1),
            ('netprice', 'Net price', 'ja_jp', '正価', 1),
            ('comments', 'Comments', 'ja_jp', 'コメント', 1),
            ('add_close', 'Add & Close', 'ja_jp', '追加＆閉じる', 1),
            ('fetching_rout_message', 'Fetching route, Please wait…', 'ja_jp', 'ルートを取得しています、お待ちください…', 1),
            ('setting', 'Settings', 'ja_jp', '設定', 1),
            ('utc', 'UTC', 'ja_jp', 'UTC', 1),
            ('in', 'In', 'ja_jp', 'in ', 1),
            ('days_ago', 'days ago', 'ja_jp', '日前', 1),
            ('mins_ago', 'Minutes ago', 'ja_jp', '分前', 1),
            ('justnow', 'Just now', 'ja_jp', 'NOW', 1),
            ('hours_ago', 'hours ago', 'ja_jp', '時間前', 1),
            ('in_1_day', 'In 1 day', 'ja_jp', '1日', 1),
            ('scanqrcode', 'Card Scanner', 'ja_jp', '名刺スキャナ', 1),
            ('call_log', 'Call Log', 'ja_jp', '通話記録', 1),
            ('voice_message', 'Hi', 'ja_jp', 'こんにちは', 1),
            ('voice_message1', 'What can I search for you in', 'ja_jp', '何が検索できますか', 1),
            ('live_tracking', 'Live Tracking', 'ja_jp', 'ライブトラッキング', 1),
            ('mailmanager', 'Mail Manager', 'ja_jp', 'メールマネージャ', 1),
            ('my_location', 'My location', 'ja_jp', '私の場所', 1),
            ('created_on', 'Created On', 'ja_jp', '作成日', 1),
            ('modified_on', 'Modified On', 'ja_jp', '修正日', 1),
            ('enter_comments', 'Enter Comments', 'ja_jp', 'コメントを入力', 1),
            ('viewmore', 'View More', 'ja_jp', 'もっと見る', 1),
            ('viewless', 'View Less', 'ja_jp', '表示を減らす', 1),
            ('gotofullform', 'Go to Full Form', 'ja_jp', '詳細画面に移動', 1),
            ('post', 'Post', 'ja_jp', '投稿', 1),
            ('url', 'URL', 'ja_jp', 'URL', 1),
            ('dialog_title_text_back_color', 'Select a Text Background Color', 'ja_jp', 'テキストの背景色を選択', 1),
            ('event_or_task', 'Add event/task', 'ja_jp', '予定とタスクの追加', 1),
            ('shortcut', 'Shortcuts', 'ja_jp', 'ショートカット', 1),
            ('select_field', 'Select Field', 'ja_jp', '項目を選択', 1),
            ('share', 'Share', 'ja_jp', '共有', 1),
            ('title_insert_link', 'Insert Link', 'ja_jp', 'リンクを挿入', 1),
            ('addyourcommentshere', 'Add your comments here', 'ja_jp', 'ここにコメントを追加', 1),
            ('nocomment', 'No Comments', 'ja_jp', 'コメントはありません', 1),
            ('leads', 'Leads', 'ja_jp', 'リード', 1),
            ('true_val', 'true', 'ja_jp', '値', 1),
            ('noresult', 'No Result', 'ja_jp', '検索結果はありません', 1),
            ('version', 'Version', 'ja_jp', 'バージョン', 1),
            ('convert_lead', 'Convert Lead', 'ja_jp', ' リードの変換', 1),
            ('app_name', 'CRMTiger', 'ja_jp', 'CRMTiger', 1),
            ('enter_url', 'Please Enter url', 'ja_jp', 'URLを入力してください', 1),
            ('help', 'Help', 'ja_jp', '助けて', 1),
            ('contact_us', 'Contact Us', 'ja_jp', 'お問い合わせ', 1),
            ('updates', 'Updates', 'ja_jp', '更新情報', 1),
            ('logout', 'LogOut', 'ja_jp', 'ログアウト', 1),
            ('busnies_cardscanner', 'Business Card Scanner', 'ja_jp', '名刺スキャナ（利用不可）', 1),
            ('sure_want_logout', 'Are you sure want to logout ?', 'ja_jp', 'ログアウトしますか？', 1),
            ('logout_message', 'Logout successfully', 'ja_jp', 'ログアウトしますか？', 1),
            ('all', 'All', 'ja_jp', 'すべて', 1),
            ('add_event', 'Add event', 'ja_jp', '予定の追加', 1),
            ('add_task', 'Add Task', 'ja_jp', 'ToDoの追加', 1),
            ('next', 'Next', 'ja_jp', '次へ', 1),
            ('terms_conditions', 'Terms and Conditions', 'ja_jp', 'Terms and Conditions', 1),
            ('login', 'Login', 'ja_jp', 'ログイン', 2),
            ('privacy_policay', 'By logging in, you agree to our Terms and Conditions & Privacy Policy', 'ja_jp', 'ログインすることで、お客様は弊社の利用規約とプライバシーポリシーに同意したことになります。',2),
            ('copyright', 'Copyright © 2019 CRMTiger Version', 'ja_jp', 'Copyright © 2019 CRMTiger Version', 2),
            ('enter_username', 'Please enter username', 'ja_jp', 'ユーザー名を入力してください', 2),
            ('enter_password', 'Please enter password', 'ja_jp', 'パスワードを入力してください', 2),
            ('remanberme', 'Remember Me', 'ja_jp', '記憶する', 2),
            ('forgot_password', 'Forgot password?', 'ja_jp', 'パスワードをお忘れですか？', 2),
            ('privacy_policay1', 'Privacy Policy', 'ja_jp', 'プライバシーポリシー', 2),
            ('contactsupportmsg', 'Something went wrong. \\n please Click here to contact support.', 'ja_jp','何か問題が発生しました。
サポートに連絡するには、ここをクリックしてください', 2),
            ('enter_username_password', 'Entered Username or Password is wrong', 'ja_jp', '入力したユーザー名またはパスワードが間違っています', 2),
            ('server_issue_occured', 'Server issues occurred', 'ja_jp', 'サーバの問題が発生しました', 2),
            ('password', 'Password', 'ja_jp', 'パスワード', 3),
            ('user_name', 'Username', 'ja_jp', 'ユーザー名', 3),
            ('reset_pwd', 'Reset Password', 'ja_jp', 'パスワードを再設定', 3),
            ('forgot_password_title', 'Forgot password', 'ja_jp', 'パスワードをお忘れですか', 3),
            ('enter_user_name', 'Enter user name', 'ja_jp', 'ユーザー名を入力してください', 3),
            ('cc', 'Cc', 'ja_jp', 'CC', 4),
            ('body', 'Body', 'ja_jp', '本文', 4),
            ('bcc', 'BCC', 'ja_jp', 'BCC', 4),
            ('dialog_title_text_color', 'Select a Text Color', 'ja_jp', '文字色を選択', 4),
            ('date', 'Date', 'ja_jp', '日付', 4),
            ('subject', 'Subject', 'ja_jp', '件名', 4),
            ('composeMail', 'Compose Mail', 'ja_jp', 'メールを作成', 4),
            ('send', 'Send', 'ja_jp', '送信', 4),
            ('select_message', 'Select message', 'ja_jp', 'メッセージを選択', 4),
            ('title_insert_table', 'Insert Table', 'ja_jp', '表を挿入', 4),
            ('log_file_sms', 'I agree to Share API Log to Technical team for further troubleshooting', 'ja_jp', 'トラブルシューティングのために技術チームにAPIログを共有することに同意します', 5),
            ('edit_record', 'Edit Records', 'ja_jp', '編集', 5),
            ('select_time', 'Select Time', 'ja_jp', '時間を選択', 5),
            ('edit_item', 'Edit Item', 'ja_jp', 'アイテムを編集', 5),
            ('items_total', 'Items Total', 'ja_jp', 'アイテム合計', 5),
            ('number_less_then_31', 'Number should be less than 31', 'ja_jp', '数値は31より小さくなければなりません', 5),
            ('users', 'Users', 'ja_jp', 'ユーザー', 5),
            ('groups', 'Groups', 'ja_jp', 'グループ', 5),
            ('txt_note_for_file', 'Note : Existing attachments(images/files) will be replaced', 'ja_jp', '注：既存の添付ファイル（画像/ファイル）は置き換えられます', 5),
            ('greaterdatetime', 'End DateTime should be greater than Start DateTime', 'ja_jp', '終了日時は開始日時より大きくなければなりません', 5),
            ('until', 'Until', 'ja_jp', 'まで', 5),
            ('organizations', 'Organizations', 'ja_jp', '顧客', 6),
            ('contacts', 'Contacts', 'ja_jp', '顧客担当者', 6),
            ('opportunity', 'Opportunity', 'ja_jp', '商談', 6),
            ('lbl_sun', 'SUN', 'ja_jp', '日', 7),
            ('lbl_mon', 'MON', 'ja_jp', '月', 7),
            ('lbl_tue', 'TUE', 'ja_jp', '火', 7),
            ('lbl_wed', 'WED', 'ja_jp', '水', 7),
            ('lbl_thu', 'THU', 'ja_jp', '木', 7),
            ('lbl_fri', 'FRI', 'ja_jp', '金', 7),
            ('lbl_sat', 'SAT', 'ja_jp', '土', 7),
            ('lbl_1', '1', 'ja_jp', '1', 7),
            ('lbl_2', '2', 'ja_jp', '2', 7),
            ('lbl_3', '3', 'ja_jp', '3', 7),
            ('lbl_4', '4', 'ja_jp', '4', 7),
            ('lbl_5', '5', 'ja_jp', '5', 7),
            ('lbl_6', '6', 'ja_jp', '6', 7),
            ('lbl_7', '7', 'ja_jp', '7', 7),
            ('lbl_8', '8', 'ja_jp', '8', 7),
            ('lbl_9', '9', 'ja_jp', '9', 7),
            ('lbl_10', '10', 'ja_jp', '10', 7),
            ('lbl_11', '11', 'ja_jp', '11', 7),
            ('lbl_12', '12', 'ja_jp', '12', 7),
            ('lbl_13', '13', 'ja_jp', '13', 7),
            ('lbl_14', '14', 'ja_jp', '14', 7),
            ('lbl_15', '15', 'ja_jp', '15', 7),
            ('lbl_16', '16', 'ja_jp', '16', 7),
            ('lbl_17', '17', 'ja_jp', '17', 7),
            ('lbl_18', '18', 'ja_jp', '18', 7),
            ('lbl_19', '19', 'ja_jp', '19', 7),
            ('lbl_20', '20', 'ja_jp', '20', 7),
            ('lbl_21', '21', 'ja_jp', '21', 7),
            ('lbl_22', '22', 'ja_jp', '22', 7),
            ('lbl_23', '23', 'ja_jp', '23', 7),
            ('lbl_24', '24', 'ja_jp', '24', 7),
            ('lbl_25', '25', 'ja_jp', '25', 7),
            ('lbl_26', '26', 'ja_jp', '26', 7),
            ('lbl_27', '27', 'ja_jp', '27', 7),
            ('lbl_28', '28', 'ja_jp', '28', 7),
            ('lbl_29', '29', 'ja_jp', '29', 7),
            ('lbl_30', '30', 'ja_jp', '30', 7),
            ('lbl_31', '31', 'ja_jp', '31', 7),
            ('lbl_32', '32', 'ja_jp', '32', 7),
            ('lbl_33', '33', 'ja_jp', '33', 7),
            ('lbl_34', '34', 'ja_jp', '34', 7),
            ('lbl_35', '35', 'ja_jp', '35', 7),
            ('lbl_36', '36', 'ja_jp', '36', 7),
            ('lbl_37', '37', 'ja_jp', '37', 7),
            ('lbl_38', '38', 'ja_jp', '38', 7),
            ('lbl_39', '39', 'ja_jp', '39', 7),
            ('lbl_40', '40', 'ja_jp', '40', 7),
            ('lbl_41', '41', 'ja_jp', '41', 7),
            ('lbl_42', '42', 'ja_jp', '42', 7),
            ('current_date', 'current date', 'ja_jp', '現在の日付', 7),
            ('event', 'Events', 'ja_jp', '予定', 7),
            ('calendar', 'Calendar', 'ja_jp', 'カレンダー', 7),
            ('latest_version', 'Latest Version :', 'ja_jp', '最新バージョン ： ', 8),
            ('expire_on', 'Expire On :', 'ja_jp', '有効期限：', 8),
            ('ctmobile_ext_version', 'CTMobile Ext. Version :', 'ja_jp', 'CTM Mobile Ext。バージョン ：', 8),
            ('you_have_latest_version', 'You already have latest version', 'ja_jp', 'バージョンを更新しました', 8),
            ('latest_version1', 'You Already have latest version', 'ja_jp', 'あなたはすでに最新版を持っています', 8),
            ('upgreaded', 'Upgrade', 'ja_jp', 'アップグレード', 8),
            ('downgrade', 'Downgrade', 'ja_jp', 'ダウングレード', 8),
            ('dialog_recent_event_info', 'You can set from here how many number of records you want to show on Home screen for Recent Event.', 'ja_jp', '「最近のイベント」のホーム画面に表示するレコード数をここから設定できます。', 8),
            ('dialog_feedback_info', 'You can submit your feedback with description , our team will check your feedback and get back to you.', 'ja_jp', '説明を追記してあなたのフィードバックを提出することができます。私たちのチームはあなたのフィードバックをチェックしてあなたに戻ります.', 8),
            ('dialog_log_info', 'Log functionality is used for customer support / help , If you are facing any issues in app or any module or functionality is not working proper then you can enable share log with our development team.', 'ja_jp', 'ログ機能はカスタマーサポート/ヘルプに使用されます。アプリの問題に直面している場合、またはモジュールや機能が適切に機能していない場合は、開発チームと共有ログを有効にできます。.', 8),
            ('info', 'Info', 'ja_jp', '情報', 8),
            ('recent_history', 'Recent History', 'ja_jp', '直近の履歴', 8),
            ('recent_feedback', 'Feedback', 'ja_jp', 'サインインに失敗しました。もう一度試してください。', 8),
            ('recent_log', 'Log', 'ja_jp', 'ログ', 8),
            ('crmtiger_app_version', 'CRMTiger App Version :', 'ja_jp', 'CRMTigerアプリのバージョン：', 8),
            ('historylimit', 'Recent History Limit', 'ja_jp', '履歴の表示数', 8),
            ('radious_in_miles', 'radious_in_miles', 'ja_jp', '距離(1マイル=1.6キロ)', 8),
            ('recentlimit', 'Recent Event Limit', 'ja_jp', '最近のイベントの表示数', 8),
            ('upcoming_events', 'Upcoming Events', 'ja_jp', '今後のイベント', 8),
            ('rate_our_app', 'Rate Our App!', 'ja_jp', 'アプリを評価する！', 8),
            ('feedback', 'Submit Feedback', 'ja_jp', 'フィードバック', 8),
            ('sendfeedback', 'Feedback Send', 'ja_jp', 'フィードバック送信', 8),
            ('emaillimit', 'Email limit', 'ja_jp', 'メール制限', 8),
            ('log', 'Log', 'ja_jp', 'ログ', 8),
            ('logclear', 'Log cleared successfully.', 'ja_jp', 'クリア成功', 8),
            ('dialog_recent_history_info', 'You can set from here how many number of records you want to show on Home screen for Recent History.', 'ja_jp', '「最近の履歴」のホーム画面に表示するレコード数をここから設定できます。', 8),
            ('proceed_to_upgrade1', 'Proceed to', 'ja_jp', '続行', 8),
            ('upgradation_message', 'will required logout and login again later.', 'ja_jp', '一度ログアウトして再度ログインする必要があります', 8),
            ('proceed_to_upgrade', 'Proceed to Upgrade', 'ja_jp', 'アップグレードに進む', 8),
            ('module_setting', 'Module Setting', 'ja_jp', 'モジュール設定', 9),
            ('sortbyfield', 'Sort by field', 'ja_jp', '項目順で並び替え', 9),
            ('ascending', 'Ascending  A to Z', 'ja_jp', 'AからZに昇順', 9),
            ('descending', 'Descending  Z to A', 'ja_jp', 'ZからAへの降順', 9),
            ('first_field', 'First Field', 'ja_jp', '最初の項目', 9),
            ('second_field', 'Second Field', 'ja_jp', '次の項目', 9),
            ('third_field', 'Third Field', 'ja_jp', '三番目の項目', 9),
            ('sure_want_restore', 'Are you sure you want to reset to default settings?', 'ja_jp', 'デフォルトに戻しますか？', 9),
            ('orderlist', 'List Order', 'ja_jp', 'リスト順', 9),
            ('module_reset', 'Restore to Default', 'ja_jp', 'デフォルトに戻す', 9),
            ('display_fields', 'Display Fields', 'ja_jp', '表示項目', 9),
            ('discount_lessthen_100', 'Discount % should be less than 100', 'ja_jp', '割引率は100未満でなければなりません', 10),
            ('select_item', 'Select Item', 'ja_jp', 'アイテムを選択', 10),
            ('item_comment', 'Item Comment', 'ja_jp', 'アイテムコメント', 10),
            ('record_name', 'Record Name is :', 'ja_jp', 'レコード名:', 11),
            ('go_back', 'Go Back', 'ja_jp', '戻る', 11),
            ('please_enter_shortcut_name', 'Please Enter Shortcut Name', 'ja_jp', 'ショートカット名を入力してください', 11),
            ('number_not_found', 'Contact Number not found', 'ja_jp', '番号が見つかりません', 11),
            ('mail_not_found', 'Mail Address not found', 'ja_jp', 'メールアドレスが見つかりません ', 11),
            ('create_shortcut', 'Create Shortcut', 'ja_jp', 'ショートカットを作成', 11),
            ('contact_summary', 'Summary', 'ja_jp', '概要', 11),
            ('activites', 'Activities', 'ja_jp', '活動', 11),
            ('details', 'Details', 'ja_jp', '詳細', 11),
            ('related', 'Related', 'ja_jp', '関連', 11),
            ('share_link', 'Share record with', 'ja_jp', 'レコードを共有', 11),
            ('edit', 'Edit', 'ja_jp', '編集', 11),
            ('duplicate', 'Duplicate', 'ja_jp', '複製', 11),
            ('whatsapp', 'Whatsapp', 'ja_jp', 'WhatsApp', 11),
            ('call', 'Call', 'ja_jp', '電話', 11),
            ('choose_contact_for_call', 'Choose Contact for Call', 'ja_jp', '通話先を選択', 11),
            ('choose_contact_for_sms', 'Choose Contact for SMS', 'ja_jp', 'SMS送信先を選択', 11),
            ('choose_contact_for_whatsapp', 'Choose Contact for WhatsApp', 'ja_jp', 'WhatsApp送信先を選択', 11),
            ('chosse_contact_for_email', 'Choose Email', 'ja_jp', '電子メールの選択', 11),
            ('attach_file', 'Attach Files', 'ja_jp', '添付ファイル', 11),
            ('close', 'Close', 'ja_jp', '閉じる', 11),
            ('status', 'Status', 'ja_jp', 'ステータス', 11),
            ('stop', 'Stop', 'ja_jp', '中止', 11),
            ('zero', '0', 'ja_jp', '0', 11),
            ('record', 'Record', 'ja_jp', 'レコード', 11),
            ('voice_note', 'Voice Note', 'ja_jp', ' 録音メモ', 11),
            ('tickets', 'Tickets', 'ja_jp', 'チケット', 12),
            ('check_out', 'Check Out', 'ja_jp', 'チェックアウト', 12),
            ('check_in', 'Check In', 'ja_jp', 'チェックイン', 12),
            ('select_any', 'Select any', 'ja_jp', '任意を選択', 12),
            ('fulldetails', 'Show Full Details', 'ja_jp', '詳細をすべて表示', 12),
            ('checkin', 'Check-in', 'ja_jp', 'チェックイン', 12),
            ('navigate', 'Navigate', 'ja_jp', 'ガイド', 12),
            ('product', 'Products', 'ja_jp', '製品', 12),
            ('projectMilestone', 'Project Milestone', 'ja_jp', 'プロジェクトマイルストーン', 12),
            ('projecttask', 'Project Tasks', 'ja_jp', 'プロジェクトタスク', 12),
            ('nearby', 'NearBy', 'ja_jp', '近くの場所', 13),
            ('document', 'Document', 'ja_jp', 'ドキュメント', 14),
            ('reply', 'Reply', 'ja_jp', '返信', 14),
            ('reply_all', 'Reply All', 'ja_jp', '全返信', 14),
            ('forward', 'Forward', 'ja_jp', '転送', 14),
            ('action', 'Action', 'ja_jp', '操作', 14),
            ('select_first', 'Select First', 'ja_jp', '1番目を選択', 14),
            ('commentaddsuccessful', 'Comment added successfull', 'ja_jp', 'コメントを追加しました', 14),
            ('move_to', 'Move to', 'ja_jp', '移動', 14),
            ('attach', 'Attach', 'ja_jp', '添付', 14),
            ('addcoment', 'Add Comment', 'ja_jp', 'コメントを追加', 14),
            ('adddocument', 'Add Document', 'ja_jp', '文書を追加', 14),
            ('home', 'Home', 'ja_jp', 'ホーム', 15),
            ('checkout', 'Check-out', 'ja_jp', 'チェックアウト', 15),
            ('message_search', 'Search by name', 'ja_jp', '名前で検索', 15),
            ('start_shift', 'Start shift', 'ja_jp', 'シフト開始', 15),
            ('end_shift', 'End shift', 'ja_jp', 'シフト終了', 15),
            ('today_meeting', 'Meetings', 'ja_jp', '今日の会議', 15),
            ('shift_time_track', 'Shift Time Track', 'ja_jp', '時間トラックのシフト', 15),
            ('logout_msg', 'You have to login again , click', 'ja_jp', '再度ログインする必要があります。', 15),
            ('logout_msg1', 'to continue.', 'ja_jp', '続く', 15),
            ('permission_denied', 'You don\'t have permission to create', 'ja_jp', '作成する権限がありません', 15),
            ('history', 'Activity stream', 'ja_jp', '履歴', 15),
            ('search_value', 'Search value :', 'ja_jp', '検索文字:', 15),
            ('feed_back_msg', 'Please enter feedback message', 'ja_jp', 'フィードバックメッセージを入力してください', 16),
            ('feed_back_hint_msg', 'Enter feedback message', 'ja_jp', 'フィードバックメッセージを入力', 16),
            ('submit', 'Submit', 'ja_jp', '投稿', 16),
            ('check_app_not_installed', 'Application is not currently installed.', 'ja_jp', 'アプリケーションは現在インストールされていません。', 17),
            ('send_sms_fail_message', 'SMS failed, please try again later!', 'ja_jp', 'SMSが失敗しました。しばらくしてからもう一度お試しください。', 17),
            ('documentaddsuccessfully', 'Document Attach successfully', 'ja_jp', 'ドキュメントを追加しました', 17),
            ('send_message', 'Send message', 'ja_jp', 'メッセージを送信', 17),
            ('sms_to', 'smsto:', 'ja_jp', 'smsto:', 17),
            ('add_list_message', 'Add List', 'ja_jp', 'リストを追加', 18),
            ('mylist', 'My List', 'ja_jp', '私のリスト', 18),
            ('filtername', 'Filter Name', 'ja_jp', 'フィルタ名', 18),
            ('selectlist', 'Select a List', 'ja_jp', 'リストを選択', 18),
            ('assingedto', 'Assigned To', 'ja_jp', 'アサイン：', 18),
            ('selectmodule', 'Select a module', 'ja_jp', 'モジュールを選択', 18),
            ('add_list', 'Add Filter', 'ja_jp', 'リストを追加', 18),
            ('recent_event', 'Recent Event', 'ja_jp', '最近のイベント', 19),
            ('recent_hostory', 'Recent History', 'ja_jp', '履歴', 19),
            ('module_specific_settings', 'Module-Specific Settings', 'ja_jp', 'モジュール固有の設定', 19),
            ('talk_to_us', 'Talk to us', 'ja_jp', '私たちに話してください', 19),
            ('report_a_bug', 'Report A Bug', 'ja_jp', 'バグを報告', 19),
            ('faq', 'FAQ', 'ja_jp', 'よくある質問', 19),
            ('selectmodules', 'Select Module', 'ja_jp', 'モジュールを選択', 19),
            ('myplan', 'My Plan', 'ja_jp', '私の計画', 19),
            ('message', 'Message', 'ja_jp', 'メッセージ', 20),
            ('message_validation', 'Please enter Message', 'ja_jp', 'メッセージを入力してください', 20),
            ('contact_select', 'Please Select contact', 'ja_jp', '顧客担当者を選択してください', 20),
            ('global_search', 'Global Search', 'ja_jp', 'グローバル検索', 21),
            ('records', 'Records', 'ja_jp', 'レコード', 21),
            ('dont_show_again', 'Don\'t Show Again', 'ja_jp', '次回から表示しない', 22),
            ('skip', 'Skip', 'ja_jp', 'スキップ', 22),
            ('file_downloading', 'File Downloading', 'ja_jp', 'ファイルのダウンロード', 23),
            ('add_screenshots_optional', 'Add screenshots (optional)', 'ja_jp', 'スクリーンショットを追加する（オプション）', 24),
            ('describe_your_problem', 'Describe your problem', 'ja_jp', 'あなたの問題を説明してください', 24),
            ('default_filter_shortcut', 'Default Filter Shortcut', 'ja_jp', '既定のフィルタのショートカット', 25),
            ('record_shortcut', 'Record Shortcut', 'ja_jp', 'レコードショートカット', 25),
            ('enter_url', 'Please Enter url', 'ja_jp', 'URLを入力してください', 26),
            ('new_version_is_avaiable', 'You need to update the app to continue using Please update to continue Older versions will no longer work from today', 'ja_jp', '「更新して続行してください」を使用するには、アプリケーションを更新する必要があります。古いバージョンは今日から使用できなくなります。', 26),
            ('search_by', 'Search by', 'ja_jp', '検索条件', 27),
            ('selected_filter', 'Selected filter :', 'ja_jp', '選択したフィルタ： -', 27),
            ('selected_field', 'Selected field :', 'ja_jp', '選択フィールド： -', 27),
            ('choose', 'Choose', 'ja_jp', '選択', 28),
            ('qr_cardscanner', 'QR Code Scanner', 'ja_jp', 'QRコードスキャナ', 28),
            ('error_message_for_scan', 'Could not read the card Try again later.', 'ja_jp', '名刺を読み取れませんでした。後で再試行してください', 28),
            ('press_start_scan', 'Press to Start Scan', 'ja_jp', 'キーを押してスキャンを開始します', 28),
            ('line_item_quntity_validation_msg', 'Value should be greater than zero', 'ja_jp', '値は0より大きくなければなりません', 29),
            ('percentage_msg', 'Percentage should be less than 100', 'ja_jp', 'パーセンテージは100未満である必要があります', 29),
            ('MSG_NO_DATA', 'No data found!', 'ja_jp', 'データが見つかりません！', 29),
            ('MSG_SOMETHING_WRONG', 'Something went wrong!', 'ja_jp', '何か問題があります', 29),
            ('MSG_COMING_SOON', 'Coming Soon!', 'ja_jp', '近日提供予定', 29),
            ('MSG_UPLOAD_PROFILE_IMAGE', 'Please upload profile image.', 'ja_jp', 'プロファイル画像をアップロードしてください', 29),
            ('ALERT_TITLE_LOCATION_ACCESS', 'Location Access', 'ja_jp', 'ロケーションアクセス', 29),
            ('ALERT_MSG_LOCATION_ACCESS', 'Requires your location to show nearby events.', 'ja_jp', '近くの予定を表示する場所が必要です', 29),
            ('ALERT_BTN_ALLOW', 'ALLOW', 'ja_jp', '許可', 29),
            ('ALERT_BTN_DENY', 'DENY', 'ja_jp', '拒否', 29),
            ('ALERT_MSG_LOCATION_SETTING', 'Not able to fetch your current location. Please check your location settings.', 'ja_jp', '現在の場所を取得できません。位置情報設定を確認してください', 29),
            ('DELETE_RECORD', 'Delete Record', 'ja_jp', 'レコードの削除', 29),
            ('ALERT_MSG_DELETE_SHORTCUT', 'Are you sure want to delete this shortcut?', 'ja_jp', 'このショートカットを削除してもよろしいですか?', 29),
            ('DELETE_SHORTCUT', 'Delete Shortcut', 'ja_jp', 'ショートカットの削除', 29),
            ('LBL_TERMS', 'By logging in, you agree to our Terms and', 'ja_jp', 'ログインすることにより、お客様は本規約に同意したものとみなされます', 29),
            ('LBL_CONDITIONS', 'Conditions &', 'ja_jp', '同意', 29),
            ('ALERT_TITLE', 'Alert', 'ja_jp', 'アラート', 29),
            ('ALERT_BTN_SUBSCRIBE', 'Subscribe', 'ja_jp', '購読', 29),
            ('MSG_SELECT_MODULE', 'Please select any Module', 'ja_jp', 'モジュールを選択してください', 29),
            ('MSG_SELECT_LIST', 'Please select any List', 'ja_jp', 'リストを選択してください', 29),
            ('ALERT_MSG_DONT_HAVE_CAMERA', 'You don\'t have camera', 'ja_jp', 'カメラがありません', 29),
            ('ALERT_MSG_GALLARY_PERMISSION', 'You don\'t have permission to access gallery.', 'ja_jp', 'ギャラリーにアクセスする権限がありません。', 29),
            ('ALERT_MSG_CAMERA_PERMISSION', 'You don\'t have permission to access camera. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Camera on', 'ja_jp', 'カメラにアクセスする権限がありません。設定->スクロール最下部に移動し、CRMTiger App->Turn Camera onを選択します。', 29),
            ('ALERT_MSG_SPEECH_PERMISSION', 'You don\'t have permission to access Speech Recognition. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Speech Recognition on', 'ja_jp', '音声認識にアクセスするためのアクセス許可がありません。設定->スクロール下部に移動へ移動→CRMTiger Appを選択→音声認識をオンにします', 29),
            ('BTN_DONE', 'Done', 'ja_jp', '完了', 29),
            ('COMMENT', 'Comment', 'ja_jp', 'コメント', 29),
            ('FULL_FORM', 'Full Form', 'ja_jp', '詳細', 29),
            ('QUICK_CREATE', 'Create', 'ja_jp', '作成', 29),
            ('LBL_SELECT_FIELDS', 'Select Fields', 'ja_jp', '項目の選択', 29),
            ('LBL_SELECT_FIRST_FIELDS', 'Select First Field', 'ja_jp', '最初の項目を選択', 29),
            ('LBL_SELECT_SECOND_FIELDS', 'Select Second Field', 'ja_jp', '2番目の項目を選択', 29),
            ('LBL_SELECT_THIRD_FIELDS', 'Select Third Field', 'ja_jp', '3番目の項目を選択', 29),
            ('LBL_SORT_BY_FIELD', 'Select Sort By Field', 'ja_jp', '項目名でソート', 29),
            ('BTN_RESET_TO_DEFAULT', 'Reset to Default', 'ja_jp', 'デフォルトに戻す', 29),
            ('MSG_SELECT_SORT_BY_FIELD', 'Select Sort by field', 'ja_jp', '項目名でソート', 29),
            ('kStrClearBtnTitle', 'Clear', 'ja_jp', 'クリア', 29),
            ('kStrShowMoreBtnTitle', 'Show More', 'ja_jp', 'もっと見る', 29),
            ('kStrAddActivitiesBtnTitle', 'Add Activities', 'ja_jp', 'アーカイブに追加', 29),
            ('kStrAddCommentPlaceHolder', 'Add your comments here', 'ja_jp', 'あなたのコメントをここに追加', 29),
            ('MSG_ENTER_TO_EMAIL', 'Please enter to field.', 'ja_jp', '項目に値を入力してください', 29),
            ('WARNING_FILE', 'File can\'t open.', 'ja_jp', 'ファイルが開きません', 29),
            ('MSG_FILE_SAVED', 'File saved.', 'ja_jp', 'ファイルの保存', 29),
            ('WARNING_DOWNLOAD_FAIL', 'Download fail!, please try after sometime.', 'ja_jp', 'ダウンロードに失敗しました。後ほど再度実行してください', 29),
            ('LBL_SHORTCUT', 'Shortcut', 'ja_jp', 'ショートカット', 29),
            ('TXT_MESSAGE_PLACEHOLDER', 'Type Message', 'ja_jp', 'メッセージを入力', 29),
            ('ALERT_INSTALL_WHATSAPP', 'Install Whatsapp', 'ja_jp', 'WhatsAppのインストール', 29),
            ('MSG_NO_MAIL_BOX', 'No MailBox found. Please Create Mailbox', 'ja_jp', 'メールボックスがありません。作成してください。', 29),
            ('LBL_WROTE', 'Wrote', 'ja_jp', '記入', 29),
            ('MSG_MAIL_SEND', 'Mail sent', 'ja_jp', 'メールが送信されました', 29),
            ('log_file_not_found', 'API Log file not found.', 'ja_jp', 'APIログファイルがありません', 29),
            ('unknown_error', 'An unknown error occurred, try again', 'ja_jp', '不明なエラーが発生しました。もう一度お試しください', 29),
            ('CTMTigerAppVersion', 'CRMTiger App Version', 'ja_jp', 'CRMTiger App バージョン', 29),
            ('CTMMobileUpdateMsg', 'CTMobile Ext. Version Update Successfully', 'ja_jp', 'CRMTiger Ext. バージョンアップしました', 29),
            ('dialog_Premium_downgrade', 'Downgrade will required logout and login again later', 'ja_jp', 'ダウングレードにはログアウト後に再ログインが必要', 29),
            ('dialog_Premium', 'Upgrade will required logout and login again later', 'ja_jp', 'アップグレードにはログアウト後に再ログインが必要です', 29),
            ('Overwrite', 'Overwrite', 'ja_jp', '上書き', 29),
            ('MSGAddressOverwrite1', 'Overwrite the existing address with the selected', 'ja_jp', '選択された既存のアドレスを上書き', 29),
            ('MSGAddressOverwrite2', 'address details?', 'ja_jp', 'アドレスの詳細？', 29),
            ('UPGRADE_PLAN', 'Upgrade Plan', 'ja_jp', 'アップグレードプライン', 29),
            ('DOWNGRADE_PLAN', 'Downgrade Plan', 'ja_jp', 'ダウングレードプラン', 29),
            ('UPGRADE_EXTENSION', 'Upgrade Extension', 'ja_jp', 'アップグレード Extension', 29),
            ('UPGRADE_APP', 'Upgrade App', 'ja_jp', 'アップグレード App', 29),
            ('SELECT_OPTION', 'Select Option', 'ja_jp', 'オプションの選択', 29),
            ('PLEASE_SELECT', 'Please select', 'ja_jp', '選択してください', 29),
            ('MSG_ACCESS_DENIED', 'You don\'t have permission for this module.', 'ja_jp', 'あなたはモバイルのアクセス権がありません', 29),
            ('MSG_SELECT_RECCURING_MONTH_DAY', 'Please select reccuring day of month.', 'ja_jp', '月の繰り返し日を選択してください', 29),
            ('MSG_SELECT_RECCURING_WEEK_DAY', 'Please select reccuring day of week.', 'ja_jp', '週の繰り返し日を選択してください', 29),
            ('MSG_SELECT_RECCURING_DAYS', 'Please select reccuring days.', 'ja_jp', '繰り返し日を選択してください', 29),
            ('Please select reccuring days.', 'Please select reccuring days.', 'ja_jp', '繰り返し日を選択してください', 29),
            ('MSG_SELECT_RECCURING_END_DATE', 'Please select reccuring end date.', 'ja_jp', '繰り返しの終了日を選択してください', 29),
            ('MSG_SELECT_RECCURING_TYPE', 'Please select reccuring type.', 'ja_jp', '繰り返しタイプを選択してください   ', 29),
            ('FREQ_TIME', 'Times', 'ja_jp', '頻度', 29),
            ('REPEAT_YEARLY', 'Repeat Yearly', 'ja_jp', '年単位の繰り返し', 29),
            ('REPEAT_MONTHLY', 'Repeat Monthly', 'ja_jp', '月単位の繰り返し', 29),
            ('REPEAT_WEEKLY', 'Repeat Weekly', 'ja_jp', '週単位の繰り返し', 29),
            ('REPEAT_DAILY', 'Repeat Daily', 'ja_jp', '日単位の繰り返し', 29),
            ('ACTION_TITLE', 'Action Title', 'ja_jp', 'アクションタイトル', 29),
            ('MSG_SELECT_VALID_DATE', 'Please select valid day of month.', 'ja_jp', '有効な日付を選択してください', 29),
            ('MSG_SELECT_VALID_START_DATE', 'Start date should be less than end date.', 'ja_jp', '開始日は終了日より前である必要があります', 29),
            ('MSG_SELECT_VALID_START_TIME', 'Start time should be less than end time.', 'ja_jp', '開始時間は終了時間より前である必要があります', 29),
            ('LBL_LINEITEM_DETAILS', 'Lineitem Details', 'ja_jp', '明細行の詳細', 29),
            ('MSG_INVALIDE_DISCOUNT_AMOUNT', 'Discount amount should be less than the total.', 'ja_jp', '割引額は合計より少なくなければなりません', 29),
            ('VIEW', 'View', 'ja_jp', '表示', 29),
            ('MSG_ENTER_VALID', 'Please enter valid', 'ja_jp', '有効な値を入力してください', 29),
            ('MSG_ENTER_PERCENTAGE', 'Percentage should be less than 100.', 'ja_jp', 'パーセンテージは100以下である必要があります', 29),
            ('ITEM_TOTAL', 'Item Total', 'ja_jp', 'アイテム合計', 29),
            ('ADJUSTMENT', 'Adjustment', 'ja_jp', '調整', 29),
            ('TITLE_CHOOSE_IMAGE', 'Choose Image', 'ja_jp', '画像の選択', 29),
            ('COMPRESS', 'Compress', 'ja_jp', '圧縮', 29),
            ('CHOOSE_ANOTHER_IMAGE', 'Your image size is too large, please select another image', 'ja_jp', '画像サイズが大きすぎます。別の画像を選択してください', 29),
            ('OnDayOfMonth', 'On day of month', 'ja_jp', '月の日', 29),
            ('OnDayOfWeek', 'On day of week', 'ja_jp', '週の日', 29),
            ('AddAndClose', 'Add & Close', 'ja_jp', '追加＆クローズ', 29),
            ('Repeat', 'Repeat', 'ja_jp', '繰り返し', 29),
            ('OnDay', 'On day', 'ja_jp', '日', 29),
            ('View_Line_Item', 'View Line Item', 'ja_jp', '明細行の表示', 29),
            ('TITLE_IMAGE', 'Image', 'ja_jp', '画像', 29),
            ('TITLE_ICLOUD', 'iCloud', 'ja_jp', 'iCloud', 29),
            ('GOOGLE', 'Google', 'ja_jp', 'Google', 29),
            ('ALERT_BTN_OKAY', 'Okay', 'ja_jp', 'OK', 29),
            ('ALERT_TITLE_ACCESS_DENIED', 'Access Denied', 'ja_jp', 'アクセス拒否', 29),
            ('Dont_Show_Again', 'Don\'t show again', 'ja_jp', '再表示出来ません', 29),
            ('Skip', 'Skip', 'ja_jp', 'スキップ', 29),
            ('Fillter_Name', 'Fillter Name', 'ja_jp', 'ファイル名', 29),
            ('Fillter_Record_Count', 'Fillter Record Count', 'ja_jp', 'フィルタ結果のレコード数', 29),
            ('url_note',      'Note : if your URL of CRM is https://example.com/crm enter that into above box',   'ja_jp',    'Note : if your URL of CRM is https://example.com/crm enter that into above box',   31),
            ('vtiger_url',    'Your vTiger CRM URL',  'ja_jp',    'Your vTiger CRM URL',  31),
            ('msg_doc_read_permission',   'You don\'t have permission to Add either This is read-only or Private Field.',     'ja_jp',    'You don\'t have permission to Add either This is read-only or Private Field.',     31),
            ('CLEAR',   'Clear',    'ja_jp',    'クリア',    31),
            ('Files/photos uploaded successfully',    'Files/photos uploaded successfully',     'ja_jp',    'ファイル／写真が正常にアップロードされました',     32),
            ('Digital signature saved',   'Digital signature saved',    'ja_jp',    'デジタル署名が保存されました',    32),
            ('Please upload Signature or Files/photos',     'Please upload Signature or Files/photos',      'ja_jp',    '署名またはファイル／写真をアップロードしてください',      32),
            ('Files / Photos',      'Files / Photos', 'ja_jp',    'ファイル／写真', 32),
            ('Signature',     'Signature',      'ja_jp',    '署名',      32),
            ('add_photo_using',     'Add Photo Using',      'ja_jp',    '写真を追加',      31),
            ('btn_upload_sign',     '(+) Add Signature',    'ja_jp',    '（+ ）署名の追加',    31),
            ('btn_upload_photo_doc',      '(+) Upload Files/Photos',    'ja_jp',    '（+ ）ファイル／写真のアップロード',    31),
            ('select_photo_doc_to_upload',      'Please select files/photos to upload',   'ja_jp',    'アップロードするファイル／写真を選択してください',   31),
            ('related_module_title',      'Search from related module and Add to \"Route\"',    'ja_jp',    '関連モジュールから検索して「ルート」に追加',    30),
            ('Route status updated successfully',     'Route status updated successfully',      'ja_jp',    'ルートステータスが正常に更新されました',      32),
            ('Session init failed', 'Session init failed',  'ja_jp',    'セッションの初期化に失敗しました',  32),
            ('You don\'t have permission to access this resource',      'You don\'t have permission to access this resource', 'ja_jp',    'このリソースにアクセスする権限がありません', 32),
            ('ctroute_realtedto cannot be empty',     'Could not get the Related To - Try again later',     'ja_jp',    '関連するレコードを取得できませんでした。後で再試行してください',     32),
            ('ctroute_planning cannot be empty',      'Could not get the Route Planning Record - Try again later',      'ja_jp',    'ルート計画レコードを取得できませんでした。後で再試行してください',      32),
            ('Something went wrong - Try again later',      'Something went wrong - Try again later', 'ja_jp',    '問題が発生しました。後で再試行してください', 32),
            ('sequence updated successfully',   'sequence updated successfully',    'ja_jp',    'シーケンスが正常に更新されました',    32),
            ('sequence cannot be empty',  'sequence cannot be empty',   'ja_jp',    'シーケンスは空にできません',   32),
            ('Shortcut details not saved',      'Shortcut details not saved', 'ja_jp',    'ショートカットの詳細を保存出来ませんでした    ', 32),
            ('Shortcut details saved successfully',   'Shortcut details saved successfully',    'ja_jp',    'ショートカットの詳細を保存しました',    32),
            ('Route save successfully',   'Route save successfully',    'ja_jp',    'ルートの保存に成功しました',    32),
            ('Record save successfully',  'Record save successfully',   'ja_jp',    'レコードは正常に保存されました',   32),
            ('No dependency found for picklist',      'No dependency found for picklist', 'ja_jp',    '定義リストの依存関係が見つかりません', 32),
            ('No records found',    'No records found',     'ja_jp',    'レコードが見つかりません',     32),
            ('Outgoing server is not enabled, please configure from CRM',     'Outgoing server is not enabled, please configure from CRM',      'ja_jp',    '送信サーバーが有効になっていません。CRMから設定してください',      32),
            ('Removed Successfully',      'Removed Successfully', 'ja_jp',    '正常に削除されました', 32),
            ('Shortcut has been deleted', 'Shortcut has been deleted',  'ja_jp',    'ショートカットが削除されました',  32),
            ('relation of records removed successfully',    'relation of records removed successfully',     'ja_jp',    'レコードのリレーションが正常に削除されました',     32),
            ('relation of records not removed', 'relation of records not removed',  'ja_jp',    'レコードのリレーションが削除されていません',  32),
            ('Record has been deleted successfully',  'Record has been deleted successfully',   'ja_jp',    'レコードは正常に削除されました',   32),
            ('Time Tracking saved successfully',      'Time Tracking saved successfully', 'ja_jp',    'タイムトラッキングが正常に保存されました', 32),
            ('Time Tracking updated successfully',    'Time Tracking updated successfully',     'ja_jp',    'タイムトラッキングが正常に更新されました',     32),
            ('Time Tracking ended successfully',      'Time Tracking ended successfully', 'ja_jp',    'タイムトラッキングが正常に終了しました', 32),
            ('Time Tracking started successfully',    'Time Tracking started successfully',     'ja_jp',    'タイムトラッキングが正常に開始しました',     32),
            ('record cannot be empty',    'record cannot be empty',     'ja_jp',    'レコードは空にできません',     32),
            ('Module is disabled',  'Module is disabled',   'ja_jp',    'モジュールは無効です',   32),
            ('Shift ended successfully',  'Shift ended successfully',   'ja_jp',    'シフトは正常に終了しました',   32),
            ('Shift started successfully',      'Shift started successfully', 'ja_jp',    'シフトが正常に開始されました', 32),
            ('relation of records added successfully', 'relation of records added successfully', 'ja_jp','レコードのリレーションが正常に追加されました', 32),
            ('Comment saved successfully',      'Comment saved successfully', 'ja_jp',    'コメントは正常に保存されました', 32),
            ('Comment not saved',   'Comment not saved',    'ja_jp',    'コメントが保存されていません',    32),
            ('Comment module is not active',    'Comment module is not active',     'ja_jp',    'コメントモジュールがアクティブではありません',     32),
            ('No Upcoming Event',   'No Upcoming Event',    'ja_jp',    '今後の予定なし',    32),
            ('No Templates found - create it from Message Templates module',  'No Templates found - create it from Message Templates module',   'ja_jp',    'テンプレートが見つかりません.メッセージテンプレートモジュールから作成してください',   32),
            ('No event or task for this date',  'No event or task for this date',   'ja_jp',    'この日付の予定またはToDoはありません',   32),
            ('No filters created',  'No filters created',   'ja_jp',    'フィルタが作成されていません',   32),
            ('Select at least one record to attach',  'Select at least one record to attach',   'ja_jp',    '添付するレコードを少なくとも1つ選択してください',   32),
            ('Please select one or more attachments', 'Please select one or more attachments',  'ja_jp',    '1つ以上の添付ファイルを選択してください',  32),
            ('No event for this month',   'No event for this month',    'ja_jp',    '今月の予定はありません',    32),
            ('No Activity found',   'No Activity found',    'ja_jp',    '活動が見つかりません',    32),
            ('Your feedback is valuable for us - it cannot be empty',   'Your feedback is valuable for us - it cannot be empty',    'ja_jp',    'フィードバックは私たちにとってとても有用です。空にすることはできません',    32),
            ('Could not send mail, Please try later', 'Could not send mail, Please try later',  'ja_jp',    'メールを送信できませんでした。後で試してください',  32),
            ('Latest Version updated successfully',   'Latest Version updated successfully',    'ja_jp',    '最新バージョンが正常に更新されました',    32),
            ('User Location Updated Successfully',    'User Location Updated Successfully',     'ja_jp',    'ユーザー位置情報が正常に更新されました',     32),
            ('User Location not Updated Successfully',      'User Location not Updated Successfully', 'ja_jp',    'ユーザー位置情報が正常に更新されませんでした', 32),
            ('SMSNotifier is not enable in CRM. Please enable it first',      'SMSNotifier is not enable in CRM. Please enable it first', 'ja_jp',    'CRMでSMSNotifierが有効になっていません。最初に有効にしてください', 32),
            ('Could not submit your feedback - Please try again later', 'Could not submit your feedback - Please try again later',  'ja_jp',    'フィードバックを送信できませんでした。後でやり直してください',  32),
            ('Thank you for submitting your feedback',      'Thank you for submitting your feedback', 'ja_jp',    'フィードバックをお送りいただきありがとうございます。', 32),
            ('Please upload User Image',  'Please upload User Image',   'ja_jp',    'ユーザー画像をアップロードしてください',   32),
            ('Image Not Uploading, please try again', 'Image Not Uploading, please try again',  'ja_jp',    '画像がアップロードされていません。再試行してください',  32),
            ('User Image Uploaded Successfully',      'User Image Uploaded Successfully', 'ja_jp',    'ユーザーイメージは正常にアップロードされました', 32),
            ('Invalid Module name', 'Invalid Module name',  'ja_jp',    '無効なモジュール名',  32),
            ('Records Sync Successfully', 'Records Sync Successfully',  'ja_jp',    'レコードの同期に成功しました',  32),
            ('Values cannot be empty',    'Values cannot be empty',     'ja_jp',    '値は空にできません',     32),
            ('Record id is empty',  'Record id is empty',   'ja_jp',    'レコードIDが空です',   32),
            ('Logout Successfully', 'Logout Successfully',  'ja_jp',    'ログアウトしました',  32),
            ('Please Enable CTMobile Module',   'Please Enable CTMobile Module',    'ja_jp',    'CTMobileモジュールを有効にしてください',    32),
            ('Authentication Failed',     'Username and Password do not match',     'ja_jp',    'ユーザ名とパスワードが違います',     32),
            ('Mismatched module information',   'Something gone wrong, please try again later', 'ja_jp',    'S問題が発生しました。後でもう一度試してください', 32),
            ('Field does not exists',     'Please set display fields again',  'ja_jp',    '表示フィールドを再度設定してください',  32),
            ('Module does not exists',    'Module does not exists or disabled by admin',  'ja_jp',    'モジュールが存在しないか、管理者によって無効にされています',  32),
            ('Month cannot be empty',     'Could not get the Month - Try again later',    'ja_jp',    '月情報を取得できませんでした。後で再試行してください',    32),
            ('Year cannot be empty',      'Could not get the Year - Try again later',     'ja_jp',    '年情報を取得できませんでした。後で再試行してください',     32),
            ('Date cannot be empty',      'Could not get the Date - Try again later',     'ja_jp',    '日情報を取得できませんでした。後で再試行してください',     32),
            ('Userid cannot be empty',    'Could not get the Userid - Try again later',   'ja_jp',    'ユーザー情報を取得できませんでした。後で再試行してください',   32),
            ('End Date cannot be empty',  'Could not get the status - Try again later',   'ja_jp',    'ステータスを取得できませんでした。後で再試行してください',   32),
            ('Start Date cannot be empty',      'Could not get the Start Date - Try again later',     'ja_jp',    '開始日を取得できませんでした。後で再試行してください',     32),
            ('You do not configure SMS Notifier in CRM. Please configure SMS Notifier in your CRM to use this feature', 'You do not configure SMS Notifier in CRM. Please configure SMS Notifier in your CRM to use this feature',  'ja_jp',    'CRMでSMS Notifierを設定していません。この機能を使用するには、CRMでSMS Notifierを設定してください',  32),
            ('Longitude cannot be empty', 'Could not get location-Please try again',      'ja_jp',    '位置情報を取得できませんでした。再試行してください',      32),
            ('Latitude cannot be empty',  'Could not get location-Please try again',      'ja_jp',    '位置情報を取得できませんでした。後で再試行してください',      32),
            ('User cannot be empty',      'Could not get the User - Try again later',     'ja_jp',    'ユーザー情報を取得できませんでした。後で再試行してください',     32),
            ('Status cannot be empty',    'Could not get the status - Try again later',   'ja_jp',    'ステータスを取得できませんでした。後で再試行してください',   32),
            ('Required fields not found', 'Required fields not found',  'ja_jp',    '必須フィールドが見つかりません',  32),
            ('Tracking module not active',      'Tracking module not active-Please contact CRM Admin',      'ja_jp',    'トラッキングモジュールがアクティブではありません。CRM管理者に連絡してください',      32),
            ('Missing mandatory input values',  'Missing mandatory input values',   'ja_jp',    '必須入力値がありません',   32),
            ('No MailBox found. Please Create Mailbox',     'No MailBox found. Please Create Mailbox',      'ja_jp',    'メールボックスが見つかりません。メールボックスを作成してください',      32),
            ('Mail not sent', 'Mail not sent',  'ja_jp',    'メールは送信されませんでした',  32),
            ('Mail send successfully',    'Mail send successfully',     'ja_jp',    'メールは正常に送信されました',     32),
            ('Email Id or username not match with your record',   'Email Id or username not match with your record',    'ja_jp',    '電子メールIDまたはユーザー名がレコードと一致しません',    32),
            ('Module not specified',      'Module not specified', 'ja_jp',    'モジュールが指定されていません', 32),
            ('No messages found',   'No messages found',    'ja_jp',    'メッセージが見つかりません',    32),
            ('No Dependency Found For This Module',   'No Dependency Found For This Module',    'ja_jp',    'このモジュールの依存関係が見つかりません',    32),
            ('Outgoing server is not Enabled',  'Outgoing server is not Enabled',   'ja_jp',    '送信メールサーバが無効です',   32),
            ('Outgoing server is Enabled',      'Outgoing server is Enabled', 'ja_jp',    '送信メールサーバが有効です', 32),
            ('Email Attached Successfully',     'Email Attached Successfully',      'ja_jp',    'Eメールが添付されました',      32),
            ('Documents Attached Successfully', 'Documents Attached Successfully',  'ja_jp',    'ドキュメントが添付されました',  32),
            ('Login required - Please login again',   'Login required - Please login again',    'ja_jp',    'ログインが必要です。再度ログインしてください',    32),
            ('time_tracking_module_disable',    'Time tracking module is disable',  'ja_jp',    'タイムトラッキングモジュールが無効になっています',  31),
            ('route_planning_module_disable',   'Route planning module is disable', 'ja_jp',    'ルート計画モジュールが無効になっています', 31),
            ('mark_as_held',  'Are you sure you want to mark Event as Held?', 'ja_jp',    '予定を完了にしてもよろしいですか?', 31),
            ('stop_timer_msg',      'You have already started Time tracking for another record, Do you want to stop it first ?',    'ja_jp',    '別のレコードのタイムトラッキングは既に開始されています。開始済みのトラッキングを停止しますか?',    31),
            ('access_denied_routeplanning',     'Access denied for route planning', 'ja_jp',    'ルート計画のアクセスが拒否されました', 31),
            ('time_spent',    'Time Spent',     'ja_jp',    '所要時間',     31),
            ('select_user',   'Select User',    'ja_jp',    'ユーザの選択',    30),
            ('status_cannot_be_held',     'Status cannot be held for future date start',  'ja_jp',    '将来の開始日に対してステータスを完了に出来ません',  30),
            ('please_select_end_date',    'Please select end date',     'ja_jp',    '終了日を選択してください',     30),
            ('please_select_start_date',  'Please select start date',   'ja_jp',    '開始日を選択してください',   30),
            ('tap_on_plus_icon_for_select_route',     'Tap on + icon to select record for your route.',     'ja_jp',    'アイコンをタップしてルートのレコードを選択',     30),
            ('please_enter_notes',  'Please enter notes',   'ja_jp',    'メモを入力してください',   30),
            ('please_enter_title',  'Please enter title',   'ja_jp',    'タイトルを入力してください',   30),
            ('please_select_date',  'Please Select Date',   'ja_jp',    '日付を選択してください',   30),
            ('search_by_date',      'Search by Date', 'ja_jp',    '日付による検索', 30),
            ('shortcut_not_setup_yet',    'Opps shortcut not setup yet!!! Please add shortcut by click on [icon] from record search results or view record screen.',    'ja_jp',    'ショートカットがまだ設定されていません。レコード検索結果またはレコード表示画面から [アイコン] をクリックしてショートカットを追加してください',    30),
            ('max_upload_size',     'max file Upload exceeds',    'ja_jp',    '最大ファイルアップロードを超えました',    30),
            ('unselect_all',  'UnSelect All',   'ja_jp',    '全ての選択を解除',   30),
            ('select_all',    'Select All',     'ja_jp',    '全てを選択',     30),
            ('please_select_records',     'Please select records',      'ja_jp',    'レコードを選択してください',      30),
            ('select_date',   'Select Date',    'ja_jp',    '日付の選択',    30),
            ('quantity_in_stock_is',      'Quantity in stock is', 'ja_jp',    '在庫数：', 30),
            ('replies', 'Replies',  'ja_jp',    '返信',  30),
            ('conversation_require_selection',  'Conversion requires selection of Contact or Organization', 'ja_jp',    '変換には連絡先または会社の選択が必要です', 30),
            ('please_select_product',     'Please Select Product',      'ja_jp',    '製品を選択してください',      30),
            ('timer_msg',     'You can start timer for single task only at same time',    'ja_jp',    '1つのタスクのタイマを同時に開始することはできません',    31),
            ('save_start_tracking', 'Save & Start Tracking',      'ja_jp',    '保存＆トラッキングの開始',      31),
            ('lbl_notes',     'Notes',    'ja_jp',    'メモ',    31),
            ('enter_title',   'Enter Title',    'ja_jp',    'タイトルの入力',    31),
            ('select_module_record',      'Select Module / Record',     'ja_jp',    'モジュール／レコードの選択',     31),
            ('lbl_tomorrow',  'Tomorrow', 'ja_jp',    '明日', 30),
            ('lbl_yesterday', 'Yesterday',      'ja_jp',    '昨日',      30),
            ('lbl_today',     'Today',    'ja_jp',    '今日',    30),
            ('time_tracker',  'Time Tracker',   'ja_jp',    '時間トラッカー',   31),
            ('time_end',      'End Time', 'ja_jp',    '終了時間', 5),
            ('due_date',      'End Date', 'ja_jp',    '終了日', 5),
            ('time_start',    'Time Start',     'ja_jp',    '開始時間',     5),
            ('date_start',    'Start Date',     'ja_jp',    '開始日',     5),
            ('delete_widget_msg',   'Display widget again by using (+) option',     'ja_jp',    '（＋）オプションを使用してウィジェットを再表示',     15),
            ('no_upcoming_activities',    'No scheduled activities      ',    'ja_jp',    'スケジュールされた活動なし',    15),
            ('check_in_first',      'Please check-in first',      'ja_jp',    'まずチェックインしてください',      30),
            ('duration',      'Duration', 'ja_jp',    '期間', 30),
            ('distance',      'Distance', 'ja_jp',    '距離', 30),
            ('proper_address_message',    'Please enter proper address in record\n',      'ja_jp',    'レコードに正しい住所を入力してください',  30),
            ('select_status', 'Select Status',  'ja_jp',    'ステータスを選択',  30),
            ('route_planner', 'Route Planner',  'ja_jp',    'ルートプランナー',  30),
            ('route_planning',      'Route Planning', 'ja_jp',    'ルート計画', 30),
            ('add_route',     'Add Route',      'ja_jp',    'ルートを追加',      30),
            ('calender_disabled',   'Calendar Module is disabled',      'ja_jp',    'カレンダーモジュールが無効です',      30),
            ('close_dialog',  'Close form',     'ja_jp',    '閉じる',     30),
            ('cancel_form_message', 'Are You sure want to close ?',     'ja_jp',    '閉じて良いですか',     30),
            ('create_route',  'Create Route',   'ja_jp',    'ルートを作成',   30),
            ('select_module_create_route',      'Select Module to create Route',    'ja_jp',    'ルートを作成するためのモジュールを選択',    30),
            ('cancel',  'Cancel',   'ja_jp',    'キャンセル',   30),
            ('assign_route',  'Assign Route',   'ja_jp',    'ルートのアサイン',   30),
            ('route_for',     'Route for',      'ja_jp',    'ルート',      30),
            ('assigned_to',   'Assigned To',    'ja_jp',    '担当',    30),
            ('enter_route_name',    'Enter Route Name',     'ja_jp',    'ルート名を入力',     30),
            ('list',    'List',     'ja_jp',    'リスト',     30),
            ('map',     'Map',      'ja_jp',    '地図',      30),
            ('other_modules', 'Other Modules',  'ja_jp',    '他のモジュール',  15),
            ('shortcut_no_record_msg',    'Opps shortcut not setup\n yet!!! Please add shortcut  by click on + icon from record\n search results or view record screen.',     'ja_jp',    'ショートカットが設定されていませんレコードの＋アイコンをクリックしてショートカットを追加してください検索結果画面またはレコード表示画面。',     25),
            ('clear',   'Clear',    'ja_jp',    'クリア',    25),
            ('open',    'Open',     'ja_jp',    '開く',     11),
            ('max_file_msg',  'Too many files selected (max:6)',  'ja_jp',    '選択されているファイルが多すぎます (最大:6)',  11),
            ('error_voicenote_record',    'Unable to recording voice while another application is recording sound.',    'ja_jp',    '他のアプリケーションで録音中は音声を録音できません',    11),
            ('msg_warning',   'Warning!', 'ja_jp',    '警告', 11),
            ('Permision_denied_contact',  'Permission denied to access your contacts',    'ja_jp',    '連絡先へのアクセスが拒否されました',    15),
            ('no_widget_added',     'Please click + icon to add new widget to your dashboard.', 'ja_jp',    '＋アイコンをクリックしてダッシュボードに新しいウィジェットを追加してください', 15),
            ('no_data_available',   'Data not available, please check the selected fields',     'ja_jp',    'データが使用できません。選択したフィールドを確認してください',     15),
            ('check_out_successfully',    'Check out successfully',     'ja_jp',    'チェックアウトしました',   11),
            ('check_in_successfully',     'Check in successfully',      'ja_jp',    'チェックインしました',    11),
            ('check_out',     'Check out',      'ja_jp',    'チェックアウト',      11),
            ('check_in',      'Check in', 'ja_jp',    'チェックイン', 11),
            ('navigate',      'Navigate', 'ja_jp',    '経路', 11),
            ('save_to_phone_vcard_success',     'VCard Saved to phone successfully',      'ja_jp',    'VCardの電話番号を保存しました',      15),
            ('download_vcard_success',    'VCard downloaded successfully',    'ja_jp',    'VCardをダウンロードしました',    15),
            ('card_details',  'Card Details',   'ja_jp',    '名刺詳細',   15),
            ('add_widget',    'Add Widget',     'ja_jp',    'ウィジットの追加',     15),
            ('delete_widget', 'Are you sure to hide widget?',     'ja_jp',    'ウィジェットを非表示にしますか?',     15),
            ('already_widgets_added',     'All types of Widget & reports are already added',    'ja_jp',    'すべての種類のウィジェットとレポートが既に追加されています',    15),
            ('retry',   'Retry',    'ja_jp',    '再実行',    28),
            ('retake',  'Retake',   'ja_jp',    '撮り直し',   28),
            ('Reports', 'Reports',  'ja_jp',    'レポート',  15),
            ('Widgets', 'Widgets',  'ja_jp',    'ウィジット',  15),
            ('vcard_config',  'Vcard Configuration',  'ja_jp',    'vCard 設定',  8),
            ('save_to_phone', 'Save to phone',  'ja_jp',    '通話を保存',  11),
            ('download_vcard',      'Download Vcard', 'ja_jp',    'vCard ダウンロード', 11),
            ('share_vcard',   'Share Vcard',    'ja_jp',    'vCard 共有',    11),
            ('share_record',  'Share Record',   'ja_jp',    'レコード共有',   11),
            ('permission_denied_edit',    'You don\'t have permission to edit this record.',    'ja_jp',    'このレコードを編集する権限がありません',    27),
            ('permission_denied_delete',  'You don\'t have permission to delete this record.',  'ja_jp',    'このレコードを削除する権限がありません',  27),
            ('Voice_Recording_Started',   'Recording Started',    'ja_jp',    '録音開始',    12),
            ('Voice_Recording_Stopped',   'Recording Stopped',    'ja_jp',    '録音中止',    12),
            ('SEARCH',  'Search',   'ja_jp',    '検索',   7),
            ('LAST',    'Last',     'ja_jp',    '姓',     7),
            ('FIRST',   'First',    'ja_jp',    '名',    7),
            ('MONDAY',  'Monday',   'ja_jp',    '月',   7),
            ('TUESDAY', 'Tuesday',  'ja_jp',    '火',  7),
            ('WEDNESDAY',     'Wednesday',      'ja_jp',    '水',      7),
            ('THURSDAY',      'Thursday', 'ja_jp',    '木', 7),
            ('FRIDAY',  'Friday',   'ja_jp',    '金',   7),
            ('SATURDAY',      'Saturday', 'ja_jp',    '土', 7),
            ('SUNDAY',  'Sunday',   'ja_jp',    '日',   7),
            ('DAILY',   'Daily',    'ja_jp',    '日',    7),
            ('WEEKLY',  'Weekly',   'ja_jp',    '週',   7),
            ('MONTHLY', 'Monthly',  'ja_jp',    '月',  7),
            ('YEARLY',  'Yearly',   'ja_jp',    '年',   7),
            ('asset_tracking',      'Asset tracking', 'ja_jp',    '納入後商品のトラッキング', 15);",array());
    }

    static function nl_nl(){
        global $adb;
        $checkQuery = "DELETE FROM ctmobile_language_keyword WHERE keyword_lang = ?";
        $checkResult = $adb->pquery($checkQuery,array('nl_nl'));

        $adb->pquery("INSERT INTO `ctmobile_language_keyword` (`keyword`, `keyword_name`, `keyword_lang`, `language_keyword`, `sectionid`) VALUES
            ('network_error', 'Network connection error!', 'nl_nl', 'Netwerkverbindingsfout', 1),
            ('connection_check', 'Could not connect to CRM, Please check your Internet connection.', 'nl_nl', 'Kan geen verbinding maken met CRM. Controleer uw internetverbinding.', 1),
            ('update', 'Update', 'nl_nl', 'Update', 1),
            ('cancel', 'Cancel', 'nl_nl', 'Annuleren', 1),
            ('ok', 'Ok', 'nl_nl', 'Ok', 1),
            ('more_information', 'Click here for more information.', 'nl_nl', 'Klik hier voor meer informatie.', 1),
            ('yes', 'Yes', 'nl_nl', 'Ja', 1),
            ('no', 'No', 'nl_nl', 'Nee', 1),
            ('click_again_exit', 'Click again to exit', 'nl_nl', 'Klik nogmaals om af te sluiten.', 1),
            ('forpermission', 'You don\'t have permission to view this feature. Please subscribe for Premium version Click here to Subscribe.', 'nl_nl', 'U heeft geen toestemming om deze functie te bekijken. Abonneer u op de Premium-versie. Klik hier om u in te schrijven.', 1),
            ('clickhere', 'Click here', 'nl_nl', 'Klik hier', 1),
            ('clickhere_subscribe', 'Click here to subscribe premium version', 'nl_nl', 'Klik hier om u op de premium-versie te abonneren.', 1),
            ('clickhere_configure', 'Click here and view how to Configure.', 'nl_nl', 'Klik hier en bekijk hoe u uw instellingen kunt aanpassen.', 1),
            ('please_wait', 'Please Wait…', 'nl_nl', 'Een ogenblik geduld ...', 1),
            ('share__msg', 'Share file with', 'nl_nl', 'Bestand delen met', 1),
            ('dialog_camera', 'Camera', 'nl_nl', 'camera', 1),
            ('dialog_add_file_by', 'Take Photo from', 'nl_nl', 'Foto nemen van', 1),
            ('add', 'Add', 'nl_nl', 'Toevoegen', 1),
            ('mail_manager_configured', 'Mail Manager is not configured', 'nl_nl', 'Mail Manager is niet geconfigureerd', 1),
            ('dialog_add_files_by', 'Add Files by', 'nl_nl', 'Bestanden toevoegen via', 1),
            ('dialog_drive', 'Drive', 'nl_nl', 'Drive', 1),
            ('dialog_drop_box', 'Drop Box', 'nl_nl', 'Drop Box', 1),
            ('dialog_need_signin', 'You need to Sign-in to your Drive account first.', 'nl_nl', 'U moet eerst inloggen op uw Drive-account.', 1),
            ('dialog_gallery', 'Gallery', 'nl_nl', 'Galerij', 1),
            ('delete', 'Delete', 'nl_nl', 'Verwijderen', 1),
            ('timeoutmessage', 'Oops! Request is taking more time than expected.', 'nl_nl', 'Oeps! Het verzoek neemt meer tijd in beslag dan verwacht.', 1),
            ('gps_location_message', 'GPS is not enabled. Please turn it on to get your near by locations.', 'nl_nl', 'GPS is niet ingeschakeld. Schakel het in om uw dichtstbijzijnde locaties te krijgen.', 1),
            ('sure_want_delete', 'Are you sure want to delete ?', 'nl_nl', 'Weet u zeker dat u wilt verwijderen?', 1),
            ('select', 'Select', 'nl_nl', 'Selecteer', 1),
            ('msgforrecordaudio', 'Minimum record duration one second.', 'nl_nl', 'Minimale opnameduur één seconde.', 1),
            ('permission_storage', 'Permission denied to read your External storage', 'nl_nl', 'Toestemming geweigerd om uw externe opslag te lezen.', 1),
            ('send_permission_msg', 'Send message permission denied', 'nl_nl', 'Bericht verzenden – toestemming geweigerd', 1),
            ('choosefile', 'Choose File', 'nl_nl', 'Kies bestand', 1),
            ('enter', 'Enter', 'nl_nl', 'Enter', 1),
            ('select_an_option', 'Select an Option', 'nl_nl', 'Selecteer een optie', 1),
            ('email_validation', 'Email is not valid', 'nl_nl', 'E-mail is niet geldig', 1),
            ('please_enter', 'Please Enter', 'nl_nl', 'Voer in a.u.b.', 1),
            ('website_validation_text', 'Website URL is not valid', 'nl_nl', 'URL van de website in is niet geldig', 1),
            ('selectvalue', 'Select value first', 'nl_nl', 'Selecteer eerst een waarde', 1),
            ('email', 'Email', 'nl_nl', 'E-mail', 1),
            ('enter_email_address', 'Enter email address', 'nl_nl', 'Voer het e-mailadres in', 1),
            ('email_address_not_correct', 'Email address incorrect', 'nl_nl', 'E-mailadres onjuist', 1),
            ('pls_enter_subject', 'Please Enter Subject', 'nl_nl', 'Voer het onderwerp in', 1),
            ('attachFiles', 'Attached File', 'nl_nl', 'Bijgevoegd bestand', 1),
            ('from', 'From', 'nl_nl', 'Van', 1),
            ('to', 'To', 'nl_nl', 'Aan', 1),
            ('call_permission_msg', 'Call permission denied', 'nl_nl', 'Toestemming bellen geweigerd', 1),
            ('no_records', 'No records found', 'nl_nl', 'Geen records gevonden', 1),
            ('fullform', 'Create New', 'nl_nl', 'Maak nieuw', 1),
            ('save', 'Save', 'nl_nl', 'Opslaan', 1),
            ('total', 'Total', 'nl_nl', 'Totaal', 1),
            ('discount', 'Discount', 'nl_nl', 'Korting', 1),
            ('price', 'Price', 'nl_nl', 'Prijs', 1),
            ('quantity', 'Quantity', 'nl_nl', 'Hoeveelheid', 1),
            ('select_module', 'Select Module', 'nl_nl', 'Selecteer module', 1),
            ('item_list', 'Item List', 'nl_nl', 'Itemlijst', 1),
            ('quickcreate', 'Quick Create', 'nl_nl', 'Snel start', 1),
            ('overwrite_msg_part1', 'Overwrite the existing address with the selected', 'nl_nl', 'Overschrijf bestaande adres met', 1),
            ('once_in_every', 'Once in every', 'nl_nl', 'Eens in de', 1),
            ('overwrite_msg_part2', 'address details?', 'nl_nl', 'adresgegevens?', 1),
            ('add_item', 'Add Item', 'nl_nl', 'Item toevoegen', 1),
            ('recordsave', 'Record saved successfully', 'nl_nl', 'Record succesvol opgeslagen', 1),
            ('recordnotsave', 'Could not save record. Try again later', 'nl_nl', 'Kon record niet opslaan. Probeer het later opnieuw', 1),
            ('minutes', 'Minutes', 'nl_nl', 'Minuten', 1),
            ('hours', 'Hours', 'nl_nl', 'Uren', 1),
            ('days', 'Days', 'nl_nl', 'Dagen', 1),
            ('on', 'On', 'nl_nl', 'op', 1),
            ('day_of_the_month', 'day of the month', 'nl_nl', 'dag van de maand', 1),
            ('list_price', 'List Price', 'nl_nl', 'prijs', 1),
            ('add_record', 'Add Record', 'nl_nl', 'voeg record toe', 1),
            ('add_product', 'Add Product', 'nl_nl', 'voeg product toe', 1),
            ('add_service', 'Add Service', 'nl_nl', 'voeg service toe', 1),
            ('discountin', 'Discount in %', 'nl_nl', 'Korting in %', 1),
            ('unitprice', 'Unit price', 'nl_nl', 'Prijs per stuk    ', 1),
            ('netprice', 'Net price', 'nl_nl', 'Nettoprijs', 1),
            ('comments', 'Comments', 'nl_nl', 'Opmerkingen', 1),
            ('add_close', 'Add & Close', 'nl_nl', 'Toevoegen en sluiten', 1),
            ('fetching_rout_message', 'Fetching route, Please wait…', 'nl_nl', 'Route ophalen, een ogenblik geduld ...', 1),
            ('setting', 'Settings', 'nl_nl', 'Instellingen', 1),
            ('utc', 'UTC', 'nl_nl', 'UTC', 1),
            ('in', 'In', 'nl_nl', 'In', 1),
            ('days_ago', 'days ago', 'nl_nl', 'dagen geleden', 1),
            ('mins_ago', 'Minutes ago', 'nl_nl', 'minuten geleden', 1),
            ('justnow', 'Just now', 'nl_nl', 'zojuist', 1),
            ('hours_ago', 'hours ago', 'nl_nl', 'uren geleden', 1),
            ('in_1_day', 'In 1 day', 'nl_nl', 'over 1 dag', 1),
            ('scanqrcode', 'Asset / Card scanner', 'nl_nl', 'Card Scanner', 1),
            ('call_log', 'Call Log', 'nl_nl', 'Call Log', 1),
            ('voice_message', 'Hi', 'nl_nl', 'Hi', 1),
            ('voice_message1', 'What can I search for you in', 'nl_nl', 'Wat kan ik voor u zoeken?', 1),
            ('live_tracking', 'Live Tracking', 'nl_nl', 'Live-Tracking', 1),
            ('mailmanager', 'Mail Manager', 'nl_nl', 'Mail Manager', 1),
            ('my_location', 'My location', 'nl_nl', 'Mijn locatie', 1),
            ('created_on', 'Created On', 'nl_nl', 'Gemaakt op', 1),
            ('modified_on', 'Modified On', 'nl_nl', 'Gewijzigd op', 1),
            ('enter_comments', 'Enter Comments', 'nl_nl', 'Voeg opmerking toe', 1),
            ('viewmore', 'View More', 'nl_nl', 'Bekijk meer', 1),
            ('viewless', 'View Less', 'nl_nl', 'Bekijk minder', 1),
            ('gotofullform', 'Go to Full Form', 'nl_nl', 'Ga naar volledig formulier', 1),
            ('post', 'Post', 'nl_nl', 'bericht', 1),
            ('url', 'URL', 'nl_nl', 'URL', 1),
            ('dialog_title_text_back_color', 'Select a Text Background Color', 'nl_nl', 'Kies een achtergrondkleur voor de tekst', 1),
            ('event_or_task', 'Add event/task', 'nl_nl', 'Voeg afspraak/taak toe', 1),
            ('shortcut', 'Shortcuts', 'nl_nl', 'Snelkoppelingen', 1),
            ('select_field', 'Select Field', 'nl_nl', 'Veld selecteren', 1),
            ('share', 'Share', 'nl_nl', 'Delen', 1),
            ('title_insert_link', 'Insert Link', 'nl_nl', 'Link invoegen', 1),
            ('addyourcommentshere', 'Add your comments here', 'nl_nl', 'Voeg hier uw commentaar toe', 1),
            ('nocomment', 'No Comments', 'nl_nl', 'Geen commentaar', 1),
            ('leads', 'Leads', 'nl_nl', 'Leads', 1),
            ('true_val', 'true', 'nl_nl', 'Aan', 1),
            ('noresult', 'No Result', 'nl_nl', 'Geen resultaat', 1),
            ('version', 'Version', 'nl_nl', 'Versie', 1),
            ('convert_lead', 'Convert Lead', 'nl_nl', 'Converteer lead', 1),
            ('app_name', 'CRMTiger', 'nl_nl', 'CRMTiger', 1),
            ('enter_url', 'Please Enter url', 'nl_nl', 'Voer url in', 1),
            ('help', 'Help', 'nl_nl', 'Help', 1),
            ('contact_us', 'Contact Us', 'nl_nl', 'Contact', 1),
            ('updates', 'Updates', 'nl_nl', 'Updates', 1),
            ('logout', 'LogOut', 'nl_nl', 'Afmelden', 1),
            ('busnies_cardscanner', 'Business Card Scanner', 'nl_nl', 'Visitekaartenscanner', 1),
            ('sure_want_logout', 'Are you sure want to logout ?', 'nl_nl', 'Weet u zeker dat u wilt uitloggen?', 1),
            ('logout_message', 'Logout successfully', 'nl_nl', 'Succesvol uitgelogd', 1),
            ('all', 'All', 'nl_nl', 'Alle', 1),
            ('add_event', 'Add event', 'nl_nl', 'Voeg afspraak toe', 1),
            ('add_task', 'Add Task', 'nl_nl', 'Voeg taak toe', 1),
            ('next', 'Next', 'nl_nl', 'Volgende', 1),
            ('terms_conditions', 'Terms and Conditions', 'nl_nl', 'Terms and Conditions', 1),
            ('login', 'Login', 'nl_nl', 'Log in', 2),
            ('privacy_policay', 'By logging in, you agree to our Terms and Conditions & Privacy Policy', 'nl_nl', 'Door in te loggen gaat u akkoord met onze Algemene Voorwaarden & ons Privacybeleid', 2),
            ('copyright', 'Copyright © 2020 CRMTiger Version', 'nl_nl', 'Copyright © 2019 CRMTiger Versie', 2),
            ('enter_username', 'Please enter username', 'nl_nl', 'Voer gebruikersnaam in', 2),
            ('enter_password', 'Please enter password', 'nl_nl', 'Voer wachtwoord in', 2),
            ('remanberme', 'Remember Me', 'nl_nl', 'Onthoud mij', 2),
            ('forgot_password', 'Forgot password?', 'nl_nl', 'Wachtwoord vergeten?', 2),
            ('privacy_policay1', 'Privacy Policy', 'nl_nl', 'Privacybeleid', 2),
            ('contactsupportmsg', 'Something went wrong. \\n please Click here to contact support.', 'nl_nl', 'Er is iets misgegaan. 
Klik hier om contact op te nemen voor ondersteuning.', 2),
            ('enter_username_password', 'Entered Username or Password is wrong', 'nl_nl', 'Ingevoerde gebruikersnaam of wachtwoord is verkeerd Er zijn', 2),
            ('server_issue_occured', 'Server issues occurred', 'nl_nl', 'serverprobleem opgetreden', 2),
            ('password', 'Password', 'nl_nl', 'Wachtwoord', 3),
            ('user_name', 'Username', 'nl_nl', 'Gebruikersnaam', 3),
            ('reset_pwd', 'Reset Password', 'nl_nl', 'Wachtwoord opnieuw instellen', 3),
            ('forgot_password_title', 'Forgot password', 'nl_nl', 'Wachtwoord vergeten', 3),
            ('enter_user_name', 'Enter user name', 'nl_nl', 'Voer gebruikersnaam in', 3),
            ('cc', 'Cc', 'nl_nl', 'Cc', 4),
            ('body', 'Body', 'nl_nl', 'Body', 4),
            ('bcc', 'BCC', 'nl_nl', 'BCC', 4),
            ('dialog_title_text_color', 'Select a Text Color', 'nl_nl', 'Kies een tekstkleur', 4),
            ('date', 'Date', 'nl_nl', 'Datum', 4),
            ('subject', 'Subject', 'nl_nl', 'Onderwerp', 4),
            ('composeMail', 'Compose Mail', 'nl_nl', 'Nieuw bericht', 4),
            ('send', 'Send', 'nl_nl', 'verzenden', 4),
            ('select_message', 'Select message', 'nl_nl', 'Selecteer bericht', 4),
            ('title_insert_table', 'Insert Table', 'nl_nl', 'Voeg tabel in', 4),
            ('log_file_sms', 'I agree to Share API Log to Technical team for further troubleshooting', 'nl_nl', 'Ik ga akkoord met inloggen door het technische team voor verder oplossen van het probleem.', 5),
            ('edit_record', 'Edit Records', 'nl_nl', 'bewerk records', 5),
            ('select_time', 'Select Time', 'nl_nl', 'Selecteer tijd', 5),
            ('edit_item', 'Edit Item', 'nl_nl', 'Item bewerken', 5),
            ('items_total', 'Items Total', 'nl_nl', 'Items totaal', 5),
            ('number_less_then_31', 'Number should be less than 31', 'nl_nl', 'aantal moet kleiner zijn dan 31', 5),
            ('users', 'Users', 'nl_nl', 'Gebruikers', 5),
            ('groups', 'Groups', 'nl_nl', 'Groepen', 5),
            ('txt_note_for_file', 'Note : Existing attachments(images/files) will be replaced', 'nl_nl', 'Opmerking: Bestaande bijlagen (afbeeldingen / bestanden) worden vervangen', 5),
            ('greaterdatetime', 'End DateTime should be greater than Start DateTime', 'nl_nl', 'Einddatum en -tijd moet groter zijn dan startdatum en -tijd.', 5),
            ('until', 'Until', 'nl_nl', 'tot', 5),
            ('organizations', 'Organizations', 'nl_nl', 'Organisaties', 6),
            ('contacts', 'Contacts', 'nl_nl', 'Contactpersonen', 6),
            ('opportunity', 'Opportunity', 'nl_nl', 'Verkoopkans', 6),
            ('lbl_sun', 'SUN', 'nl_nl', 'ZO', 7),
            ('lbl_mon', 'MON', 'nl_nl', 'MA', 7),
            ('lbl_tue', 'TUE', 'nl_nl', 'DI', 7),
            ('lbl_wed', 'WED', 'nl_nl', 'WO', 7),
            ('lbl_thu', 'THU', 'nl_nl', 'DO', 7),
            ('lbl_fri', 'FRI', 'nl_nl', 'VR', 7),
            ('lbl_sat', 'SAT', 'nl_nl', 'ZA', 7),
            ('lbl_1', '1', 'nl_nl', '1', 7),
            ('lbl_2', '2', 'nl_nl', '2', 7),
            ('lbl_3', '3', 'nl_nl', '3', 7),
            ('lbl_4', '4', 'nl_nl', '4', 7),
            ('lbl_5', '5', 'nl_nl', '5', 7),
            ('lbl_6', '6', 'nl_nl', '6', 7),
            ('lbl_7', '7', 'nl_nl', '7', 7),
            ('lbl_8', '8', 'nl_nl', '8', 7),
            ('lbl_9', '9', 'nl_nl', '9', 7),
            ('lbl_10', '10', 'nl_nl', '10', 7),
            ('lbl_11', '11', 'nl_nl', '11', 7),
            ('lbl_12', '12', 'nl_nl', '12', 7),
            ('lbl_13', '13', 'nl_nl', '13', 7),
            ('lbl_14', '14', 'nl_nl', '14', 7),
            ('lbl_15', '15', 'nl_nl', '15', 7),
            ('lbl_16', '16', 'nl_nl', '16', 7),
            ('lbl_17', '17', 'nl_nl', '17', 7),
            ('lbl_18', '18', 'nl_nl', '18', 7),
            ('lbl_19', '19', 'nl_nl', '19', 7),
            ('lbl_20', '20', 'nl_nl', '20', 7),
            ('lbl_21', '21', 'nl_nl', '21', 7),
            ('lbl_22', '22', 'nl_nl', '22', 7),
            ('lbl_23', '23', 'nl_nl', '23', 7),
            ('lbl_24', '24', 'nl_nl', '24', 7),
            ('lbl_25', '25', 'nl_nl', '25', 7),
            ('lbl_26', '26', 'nl_nl', '26', 7),
            ('lbl_27', '27', 'nl_nl', '27', 7),
            ('lbl_28', '28', 'nl_nl', '28', 7),
            ('lbl_29', '29', 'nl_nl', '29', 7),
            ('lbl_30', '30', 'nl_nl', '30', 7),
            ('lbl_31', '31', 'nl_nl', '31', 7),
            ('lbl_32', '32', 'nl_nl', '32', 7),
            ('lbl_33', '33', 'nl_nl', '33', 7),
            ('lbl_34', '34', 'nl_nl', '34', 7),
            ('lbl_35', '35', 'nl_nl', '35', 7),
            ('lbl_36', '36', 'nl_nl', '36', 7),
            ('lbl_37', '37', 'nl_nl', '37', 7),
            ('lbl_38', '38', 'nl_nl', '38', 7),
            ('lbl_39', '39', 'nl_nl', '39', 7),
            ('lbl_40', '40', 'nl_nl', '40', 7),
            ('lbl_41', '41', 'nl_nl', '41', 7),
            ('lbl_42', '42', 'nl_nl', '42', 7),
            ('current_date', 'current date', 'nl_nl', 'huidige datum', 7),
            ('event', 'Events', 'nl_nl', 'Afspraken', 7),
            ('calendar', 'Calendar', 'nl_nl', 'Agenda', 7),
            ('latest_version', 'Latest Version :', 'nl_nl', 'Nieuwste versie:', 8),
            ('expire_on', 'Next renewal date : ', 'nl_nl', 'Volgende vervaldag:', 8),
            ('ctmobile_ext_version', 'CTMobile Ext. Version : ', 'nl_nl', 'CTMobile Ext. Versie: je', 8),
            ('you_have_latest_version', 'You already have latest version', 'nl_nl', 'U hebt al de nieuwste versie.', 8),
            ('latest_version1', 'You Already have latest version', 'nl_nl', 'U hebt al de nieuwste versie.', 8),
            ('upgreaded', 'Upgrade', 'nl_nl', 'Upgraden', 8),
            ('downgrade', 'Downgrade', 'nl_nl', 'Downgraden', 8),
            ('dialog_recent_event_info', 'You can set from here how many number of records you want to show on Home screen for Recent Event.', 'nl_nl', 'U kunt vanaf hier instellen hoeveel records u wilt weergeven op het startscherm bij \'recente afspraken\'.', 8),
            ('dialog_feedback_info', 'You can submit your feedback with description , our team will check your feedback and get back to you.', 'nl_nl', 'U kunt uw feedback indienen, ons team zal uw feedback controleren en contact met u opnemen.', 8),
            ('dialog_log_info', 'Log functionality is used for customer support / help , If you are facing any issues in app or any module or functionality is not working proper then you can enable share log with our development team.', 'nl_nl', 'De log-functionaliteit wordt gebruikt voor klantenondersteuning. Als u problemen ondervindt in de app of als een module of functionaliteit niet goed werkt, kunt u het logboek delen met ons ontwikkelingsteam.', 8),
            ('info', 'Info', 'nl_nl', 'Info', 8),
            ('recent_history', 'Recent History', 'nl_nl', 'Recente geschiedenis', 8),
            ('recent_feedback', 'Feedback', 'nl_nl', 'Feedback', 8),
            ('recent_log', 'Log', 'nl_nl', 'Log', 8),
            ('crmtiger_app_version', 'CRMTiger App Version : ', 'nl_nl', 'CRMTiger App-versie:', 8),
            ('historylimit', 'Recent History Limit', 'nl_nl', 'Recente geschiedenis Beperk', 8),
            ('radious_in_miles', 'Radius in miles', 'nl_nl', 'radious_in_miles', 8),
            ('recentlimit', 'Recent Event Limit', 'nl_nl', 'Recente afspraken Beperk', 8),
            ('upcoming_events', 'Upcoming Events', 'nl_nl', 'aankomende afspraken', 8),
            ('rate_our_app', 'Rate Our App!', 'nl_nl', 'Beoordeel onze app!', 8),
            ('feedback', 'Submit Feedback', 'nl_nl', 'Feedback geven', 8),
            ('sendfeedback', 'Feedback Send', 'nl_nl', 'Feedback verstuurd', 8),
            ('emaillimit', 'Email limit', 'nl_nl', 'e-mail limiet', 8),
            ('log', 'Log', 'nl_nl', 'Log', 8),
            ('logclear', 'Log cleared successfully.', 'nl_nl', 'Log gewist', 8),
            ('dialog_recent_history_info', 'You can set from here how many number of records you want to show on Home screen for Recent History.', 'nl_nl', 'U kunt vanaf hier instellen hoeveel records u wilt weergeven op het startscherm bij ‘recente geschiedenis’.', 8),
            ('proceed_to_upgrade1', 'Proceed to', 'nl_nl', 'Doorgaan naar', 8),
            ('upgradation_message', 'will required logout and login again later.', 'nl_nl', 'vereist uitloggen en later opnieuw inloggen.', 8),
            ('proceed_to_upgrade', 'Proceed to Upgrade', 'nl_nl', 'Ga verder naar', 8),
            ('module_setting', 'Module Setting', 'nl_nl', 'Module-instelling upgraden', 9),
            ('sortbyfield', 'Sort by field', 'nl_nl', 'Sorteer op veld', 9),
            ('ascending', 'Ascending  A to Z', 'nl_nl', 'Oplopend van A tot Z', 9),
            ('descending', 'Descending  Z to A', 'nl_nl', 'Aflopend van Z tot A', 9),
            ('first_field', 'First Field', 'nl_nl', 'Eerste veld', 9),
            ('second_field', 'Second Field', 'nl_nl', 'Tweede veld', 9),
            ('third_field', 'Third Field', 'nl_nl', 'Derde veld', 9),
            ('sure_want_restore', 'Are you sure you want to reset to default settings?', 'nl_nl', 'Weet u zeker dat u de standaardinstellingen wilt terugzetten?', 9),
            ('orderlist', 'List Order', 'nl_nl', 'Lijstvolgorde', 9),
            ('module_reset', 'Restore to Default', 'nl_nl', 'Herstel naar standaard', 9),
            ('display_fields', 'Display Fields', 'nl_nl', 'Toon velden', 9),
            ('discount_lessthen_100', 'Discount % should be less than 100', 'nl_nl', 'Kortingspercentage moet minder zijn dan 100.', 10),
            ('select_item', 'Select Item', 'nl_nl', 'Selecteer item', 10),
            ('item_comment', 'Item Comment', 'nl_nl', 'Opmerkingen bij item', 10),
            ('record_name', 'Record Name is :', 'nl_nl', 'Naam record:', 11),
            ('go_back', 'Go Back', 'nl_nl', 'Ga terug', 11),
            ('please_enter_shortcut_name', 'Please Enter Shortcut Name', 'nl_nl', 'Voer naam in voor snelkoppeling', 11),
            ('number_not_found', 'Contact Number not found', 'nl_nl', 'Nummer niet gevonden', 11),
            ('mail_not_found', 'Mail Address not found', 'nl_nl', 'E-mailadres niet gevonden', 11),
            ('create_shortcut', 'Create Shortcut', 'nl_nl', 'Snelkoppeling maken', 11),
            ('contact_summary', 'Summary', 'nl_nl', 'Samenvatting', 11),
            ('activites', 'Activities', 'nl_nl', 'Activiteiten', 11),
            ('details', 'Details', 'nl_nl', 'Details', 11),
            ('related', 'Related', 'nl_nl', 'Gerelateerd', 11),
            ('share_link', 'Share record with', 'nl_nl', 'Record delen met', 11),
            ('edit', 'Edit', 'nl_nl', 'Bewerk', 11),
            ('duplicate', 'Duplicate', 'nl_nl', 'Dupliceer', 11),
            ('whatsapp', 'Whatsapp', 'nl_nl', 'Whatsapp', 11),
            ('call', 'Call', 'nl_nl', 'Bel', 11),
            ('choose_contact_for_call', 'Choose Contact for Call', 'nl_nl', 'Kies contactpersoon om te bellen', 11),
            ('choose_contact_for_sms', 'Choose Contact for SMS', 'nl_nl', 'Kies contactpersoon om te sms-en', 11),
            ('choose_contact_for_whatsapp', 'Choose Contact for WhatsApp', 'nl_nl', 'Kies contactpersoon om een WhatsApp te sturen', 11),
            ('chosse_contact_for_email', 'Choose Email', 'nl_nl', 'Selecteer e-mail-adres', 11),
            ('attach_file', 'Attach Files', 'nl_nl', 'Voeg bestand toe', 11),
            ('close', 'Close', 'nl_nl', 'Sluit', 11),
            ('status', 'Status', 'nl_nl', 'Status', 11),
            ('stop', 'Stop', 'nl_nl', 'Stop', 11),
            ('zero', '0', 'nl_nl', 'Nul', 11),
            ('record', 'Record', 'nl_nl', 'Record', 11),
            ('voice_note', 'Voice Note', 'nl_nl', 'Voice Note', 11),
            ('tickets', 'Tickets', 'nl_nl', 'Tickets', 12),
            ('check_out', 'Check Out', 'nl_nl', 'Check Out', 12),
            ('check_in', 'Check In', 'nl_nl', 'Check In', 12),
            ('select_any', 'Select any', 'nl_nl', 'Select elke', 12),
            ('fulldetails', 'Show Full Details', 'nl_nl', 'Details', 12),
            ('checkin', 'Check-in', 'nl_nl', 'Check-in', 12),
            ('navigate', 'Navigate', 'nl_nl', 'Navigeren', 12),
            ('product', 'Products', 'nl_nl', 'Producten', 12),
            ('projectMilestone', 'Project Milestone', 'nl_nl', 'Project Mijlpalen', 12),
            ('projecttask', 'Project Tasks', 'nl_nl', 'Projettaken', 12),
            ('nearby', 'NearBy', 'nl_nl', 'nabijgelegen', 13),
            ('document', 'Document', 'nl_nl', 'Document', 14),
            ('reply', 'Reply', 'nl_nl', 'Beantwoorden', 14),
            ('reply_all', 'Reply All', 'nl_nl', 'Allen beantwoorden', 14),
            ('forward', 'Forward', 'nl_nl', 'Doorsturen', 14),
            ('action', 'Action', 'nl_nl', 'Action', 14),
            ('select_first', 'Select First', 'nl_nl', 'Selecteer eerste', 14),
            ('commentaddsuccessful', 'Comment added successfull', 'nl_nl', 'Opmerking toegevoegd', 14),
            ('move_to', 'Move to', 'nl_nl', 'Verplaats naar', 14),
            ('attach', 'Attach', 'nl_nl', 'Voeg bij', 14),
            ('addcoment', 'Add Comment', 'nl_nl', 'Voeg opmerking bij', 14),
            ('adddocument', 'Add Document', 'nl_nl', 'Voeg document toe', 14),
            ('home', 'Home', 'nl_nl', 'Home', 15),
            ('checkout', 'Check-out', 'nl_nl', 'Afrekenen', 15),
            ('message_search', 'Search by name', 'nl_nl', 'Zoeken op naam', 15),
            ('start_shift', 'Start shift', 'nl_nl', 'Dienst starten', 15),
            ('end_shift', 'End shift', 'nl_nl', 'Einde dienst', 15),
            ('today_meeting', 'Meetings', 'nl_nl', 'Afspraken', 15),
            ('shift_time_track', 'Shift Time Track', 'nl_nl', 'Shift Time Track', 15),
            ('logout_msg', 'You have to login again , click', 'nl_nl', 'U moet opnieuw inloggen, klik', 15),
            ('logout_msg1', 'to continue.', 'nl_nl', 'om door te gaan.', 15),
            ('permission_denied', 'You don\'t have permission to create', 'nl_nl', 'Je hebt geen toestemming om aan te maken', 15),
            ('history', 'History', 'nl_nl', 'Geschiedenis', 15),
            ('search_value', 'Search value :', 'nl_nl', 'Zoekwaarde:', 15),
            ('feed_back_msg', 'Please enter feedback message', 'nl_nl', 'Vul feedback in', 16),
            ('feed_back_hint_msg', 'Enter feedback message', 'nl_nl', 'Feedback:', 16),
            ('submit', 'Submit', 'nl_nl', 'Verstuur', 16),
            ('check_app_not_installed', 'Application is not currently installed.', 'nl_nl', 'Application is momenteel niet geïnstalleerd.', 17),
            ('send_sms_fail_message', 'SMS failed, please try again later!', 'nl_nl', 'Sms mislukt, probeer het later opnieuw!', 17),
            ('documentaddsuccessfully', 'Document Attach successfully', 'nl_nl', 'Document succesvol toegevoegd', 17),
            ('send_message', 'Send message', 'nl_nl', 'Stuur bericht', 17),
            ('sms_to', 'smsto:', 'nl_nl', 'SMS naar', 17),
            ('add_list_message', 'Add List', 'nl_nl', 'Voeg lijst toe', 18),
            ('mylist', 'My List', 'nl_nl', 'Mijn lijst', 18),
            ('filtername', 'Filter Name', 'nl_nl', 'Filternaam', 18),
            ('selectlist', 'Select a List', 'nl_nl', 'Selecteer een lijst', 18),
            ('assingedto', 'Assigned To', 'nl_nl', 'Toegewezen aan', 18),
            ('selectmodule', 'Select a module', 'nl_nl', 'Selecteer een module', 18),
            ('add_list', 'Add Filter', 'nl_nl', 'Voeg filter toe', 18),
            ('recent_event', 'Recent Event', 'nl_nl', 'Recente gebeurtenis', 19),
            ('recent_hostory', 'Recent History', 'nl_nl', 'Recente geschiedenis', 19),
            ('module_specific_settings', 'Module-Specific Settings', 'nl_nl', 'Modulespecifieke instellingen', 19),
            ('talk_to_us', 'Talk to us', 'nl_nl', 'Praat met ons', 19),
            ('report_a_bug', 'Report A Bug', 'nl_nl', 'Meld een bug', 19),
            ('faq', 'FAQ', 'nl_nl', 'FAQ', 19),
            ('selectmodules', 'Select Module', 'nl_nl', 'Selecteer module', 19),
            ('myplan', 'My Plan', 'nl_nl', 'Mijn plan', 19),
            ('message', 'Message', 'nl_nl', 'Bericht', 20),
            ('message_validation', 'Please enter Message', 'nl_nl', 'Voer een bericht in', 20),
            ('contact_select', 'Please Select contact', 'nl_nl', 'Selecteer een contactpersoon', 20),
            ('global_search', 'Global Search', 'nl_nl', 'Global Search', 21),
            ('records', 'Records', 'nl_nl', 'Records', 21),
            ('dont_show_again', 'Don\'t Show Again', 'nl_nl', 'Toon dit niet opnieuw', 22),
            ('skip', 'Skip', 'nl_nl', 'Sla over', 22),
            ('file_downloading', 'File Downloading', 'nl_nl', 'Bestand downloaden', 23),
            ('add_screenshots_optional', 'Add screenshots (optional)', 'nl_nl', 'overslaan', 24),
            ('describe_your_problem', 'Describe your problem', 'nl_nl', 'Schermafbeeldingen toevoegen (optioneel)', 24),
            ('default_filter_shortcut', 'Default Filter Shortcut', 'nl_nl', 'Beschrijf uw probleem', 25),
            ('record_shortcut', 'Record Shortcut', 'nl_nl', 'Record snelkoppeling', 25),
            ('enter_url', 'Please Enter url', 'nl_nl', 'Voer URL in', 26),
            ('new_version_is_avaiable', 'You need to update the app to continue using Please update to continue Older versions will no longer work from today', 'nl_nl', 'U moet de app bijwerken om door te gaan. Oudere versies werken niet meer.', 26),
            ('search_by', 'Search by', 'nl_nl', 'Zoek op', 27),
            ('selected_filter', 'Selected filter :', 'nl_nl', 'geselecteerd filter:', 27),
            ('selected_field', 'Selected field :', 'nl_nl', 'geselecteerd veld:', 27),
            ('choose', 'Choose', 'nl_nl', 'Kies', 28),
            ('qr_cardscanner', 'QR Code Scanner', 'nl_nl', 'QR Code Scanner', 28),
            ('error_message_for_scan', 'Could not read the card Try again later.', 'nl_nl', 'Kan de kaart niet lezen. Probeer het later opnieuw.', 28),
            ('press_start_scan', 'Press to Start Scan', 'nl_nl', 'Druk om te starten met scannen', 28),
            ('line_item_quntity_validation_msg', 'Value should be greater than zero', 'nl_nl', 'Waarde moet groter zijn dan nul', 29),
            ('percentage_msg', 'Percentage should be less than 100', 'nl_nl', 'Percentage moet kleiner zijn dan 100', 29),
            ('MSG_NO_DATA', 'No data found!', 'nl_nl', 'Geen gegevens gevonden!', 29),
            ('MSG_SOMETHING_WRONG', 'Something went wrong!', 'nl_nl', 'Er is iets fout gegaan!', 29),
            ('MSG_COMING_SOON', 'Coming Soon!', 'nl_nl', 'Komt binnenkort!', 29),
            ('MSG_UPLOAD_PROFILE_IMAGE', 'Please upload profile image.', 'nl_nl', 'Upload een profielafbeelding.', 29),
            ('ALERT_TITLE_LOCATION_ACCESS', 'Location Access', 'nl_nl', 'Toegang tot locatie', 29),
            ('ALERT_MSG_LOCATION_ACCESS', 'Requires your location to show nearby events.', 'nl_nl', 'Vereist uw locatie om afspraken in de buurt weer te geven.', 29),
            ('ALERT_BTN_ALLOW', 'ALLOW', 'nl_nl', 'TOESTAAN', 29),
            ('ALERT_BTN_DENY', 'DENY', 'nl_nl', 'WEIGEREN', 29),
            ('ALERT_MSG_LOCATION_SETTING', 'Not able to fetch your current location. Please check your location settings.', 'nl_nl', 'Kan uw huidige locatie niet ophalen. Controleer uw locatie-instellingen.', 29),
            ('DELETE_RECORD', 'Delete Record', 'nl_nl', 'Record verwijderen', 29),
            ('ALERT_MSG_DELETE_SHORTCUT', 'Are you sure want to delete this shortcut?', 'nl_nl', 'Weet u zeker dat u deze snelkoppeling wilt verwijderen?', 29),
            ('DELETE_SHORTCUT', 'Delete Shortcut', 'nl_nl', 'Snelkoppeling verwijderen', 29),
            ('LBL_TERMS', 'By logging in, you agree to our Terms and', 'nl_nl', 'Door in te loggen, gaat u akkoord met onze Algemene Voorwaarden en', 29),
            ('LBL_CONDITIONS', 'Conditions &', 'nl_nl', 'Privacybeleid', 29),
            ('ALERT_TITLE', 'Alert', 'nl_nl', 'Alert', 29),
            ('ALERT_BTN_SUBSCRIBE', 'Subscribe', 'nl_nl', 'Abonneren', 29),
            ('MSG_SELECT_MODULE', 'Please select any Module', 'nl_nl', 'Selecteer een module', 29),
            ('MSG_SELECT_LIST', 'Please select any List', 'nl_nl', 'Selecteer een lijst', 29),
            ('ALERT_MSG_DONT_HAVE_CAMERA', 'You don\'t have camera', 'nl_nl', 'U hebt geen camera', 29),
            ('ALERT_MSG_GALLARY_PERMISSION', 'You don\'t have permission to access gallery.', 'nl_nl', 'U hebt geen toestemming om de galerij te openen.', 29),
            ('ALERT_MSG_CAMERA_PERMISSION', 'You don\'t have permission to access camera. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Camera on', 'nl_nl', 'U heeft geen toestemming om toegang te krijgen tot de camera. Ga naar setting -> Scroll naar beneden en selecteer CRMTiger App -> Turn Camera on', 29),
            ('ALERT_MSG_SPEECH_PERMISSION', 'You don\'t have permission to access Speech Recognition. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Speech Recognition on', 'nl_nl', 'U bent niet gemachtigd om toegang te krijgen tot spraakherkenning. Ga naar instelling -> Scroll naar beneden en selecteer CRMTiger-app -> Zet spraakherkenning aan', 29),
            ('BTN_DONE', 'Done', 'nl_nl', 'Klaar', 29),
            ('COMMENT', 'Comment', 'nl_nl', 'Opmerking', 29),
            ('FULL_FORM', 'Full Form', 'nl_nl', 'Volledig formulier', 29),
            ('QUICK_CREATE', 'Create', 'nl_nl', 'Maak', 29),
            ('LBL_SELECT_FIELDS', 'Select Fields', 'nl_nl', 'Selecteer velden', 29),
            ('LBL_SELECT_FIRST_FIELDS', 'Select First Field', 'nl_nl', 'Selecteer eerste veld', 29),
            ('LBL_SELECT_SECOND_FIELDS', 'Select Second Field', 'nl_nl', 'Selecteer tweede veld', 29),
            ('LBL_SELECT_THIRD_FIELDS', 'Select Third Field', 'nl_nl', 'Selecteer derde veld', 29),
            ('LBL_SORT_BY_FIELD', 'Select Sort By Field', 'nl_nl', 'Selecteer Sorteer op veld', 29),
            ('BTN_RESET_TO_DEFAULT', 'Reset to Default', 'nl_nl', 'Reset naar standaard', 29),
            ('MSG_SELECT_SORT_BY_FIELD', 'Select Sort by field', 'nl_nl', 'Selecteer Sorteer op veld', 29),
            ('kStrClearBtnTitle', 'Clear', 'nl_nl', 'Wissen', 29),
            ('kStrShowMoreBtnTitle', 'Show More', 'nl_nl', 'Toon meer', 29),
            ('kStrAddActivitiesBtnTitle', 'Add Activities', 'nl_nl', 'Voeg activiteiten toe', 29),
            ('kStrAddCommentPlaceHolder', 'Add your comments here', 'nl_nl', 'Voeg uw opmerkingen toe', 29),
            ('MSG_ENTER_TO_EMAIL', 'Please enter to field.', 'nl_nl', 'Vul dit veld in.', 29),
            ('WARNING_FILE', 'File can\'t open.', 'nl_nl', 'Bestand kan niet worden geopend.', 29),
            ('MSG_FILE_SAVED', 'File saved.', 'nl_nl', 'Bestand opgeslagen.', 29),
            ('WARNING_DOWNLOAD_FAIL', 'Download fail!, please try after sometime.', 'nl_nl', 'Download mislukt! Probeer later opnieuw.', 29),
            ('LBL_SHORTCUT', 'Shortcut', 'nl_nl', 'Snelkoppeling', 29),
            ('TXT_MESSAGE_PLACEHOLDER', 'Type Message', 'nl_nl', 'Typ bericht', 29),
            ('ALERT_INSTALL_WHATSAPP', 'Install Whatsapp', 'nl_nl', 'Installeer Whatsapp', 29),
            ('MSG_NO_MAIL_BOX', 'No MailBox found. Please Create Mailbox', 'nl_nl', 'Geen mailbox gevonden. Maak Mailbox', 29),
            ('LBL_WROTE', 'Wrote', 'nl_nl', 'schreef', 29),
            ('MSG_MAIL_SEND', 'Mail sent', 'nl_nl', 'Mail', 29),
            ('log_file_not_found', 'API Log file not found.', 'nl_nl', 'API logbestand niet gevonden.', 29),
            ('unknown_error', 'An unknown error occurred, try again', 'nl_nl', 'Er is een onbekende fout opgetreden, probeer het opnieuw.', 29),
            ('CTMTigerAppVersion', 'CRMTiger App Version', 'nl_nl', 'CRMTiger- appversie', 29),
            ('CTMMobileUpdateMsg', 'CTMobile Ext. Version Update Successfully', 'nl_nl', 'CTMobile Ext. Versie-update succesvol', 29),
            ('dialog_Premium_downgrade', 'Downgrade will required logout and login again later', 'nl_nl', 'Downgrade vereist uitloggen en later opnieuw inloggen', 29),
            ('dialog_Premium', 'Upgrade will required logout and login again later', 'nl_nl', 'Upgrade vereist uitloggen en later opnieuw inloggen', 29),
            ('Overwrite', 'Overwrite', 'nl_nl', 'Overschrijven', 29),
            ('MSGAddressOverwrite1', 'Overwrite the existing address with the selected', 'nl_nl', 'Overschrijft het adres met de -', 29),
            ('MSGAddressOverwrite2', 'address details?', 'nl_nl', 'adresgegevens?', 29),
            ('UPGRADE_PLAN', 'Upgrade Plan', 'nl_nl', 'Upgradeplan', 29),
            ('DOWNGRADE_PLAN', 'Downgrade Plan', 'nl_nl', 'Downgradeplan', 29),
            ('UPGRADE_EXTENSION', 'Upgrade Extension', 'nl_nl', 'Upgrade extensie', 29),
            ('UPGRADE_APP', 'Upgrade App', 'nl_nl', 'Upgrade app', 29),
            ('SELECT_OPTION', 'Select Option', 'nl_nl', 'Maak uw keuze', 29),
            ('PLEASE_SELECT', 'Please select', 'nl_nl', 'Selecteer', 29),
            ('MSG_ACCESS_DENIED', 'You don\'t have permission for this module.', 'nl_nl', 'U hebt geen toestemming voor deze module.', 29),
            ('MSG_SELECT_RECCURING_MONTH_DAY', 'Please select reccuring day of month.', 'nl_nl', 'Selecteer dag van de maand.', 29),
            ('MSG_SELECT_RECCURING_WEEK_DAY', 'Please select reccuring day of week.', 'nl_nl', 'Selecteer dag van de week.', 29),
            ('MSG_SELECT_RECCURING_DAYS', 'Please select reccuring days.', 'nl_nl', 'Selecteer dagen.', 29),
            ('Please select reccuring days.', 'Please select reccuring days.', 'nl_nl', 'Selecteer dagen.', 29),
            ('MSG_SELECT_RECCURING_END_DATE', 'Please select reccuring end date.', 'nl_nl', 'Selecteer een einddatum', 29),
            ('MSG_SELECT_RECCURING_TYPE', 'Please select reccuring type.', 'nl_nl', 'Selecteer alstublieft het herhaalpatroon.', 29),
            ('FREQ_TIME', 'Times', 'nl_nl', 'Tijd', 29),
            ('REPEAT_YEARLY', 'Repeat Yearly', 'nl_nl', 'Herhaal Jaarlijks', 29),
            ('REPEAT_MONTHLY', 'Repeat Monthly', 'nl_nl', 'Herhaal Maandelijks', 29),
            ('REPEAT_WEEKLY', 'Repeat Weekly', 'nl_nl', 'Herhaal Wekelijks', 29),
            ('REPEAT_DAILY', 'Repeat Daily', 'nl_nl', 'Herhaal Dagelijkse', 29),
            ('ACTION_TITLE', 'Action Title', 'nl_nl', 'Actie titel', 29),
            ('MSG_SELECT_VALID_DATE', 'Please select valid day of month.', 'nl_nl', 'Selecteer een geldige dag van de maand.', 29),
            ('MSG_SELECT_VALID_START_DATE', 'Start date should be less than end date.', 'nl_nl', 'De startdatum moet eerder zijn dan de einddatum.', 29),
            ('MSG_SELECT_VALID_START_TIME', 'Start time should be less than end time.', 'nl_nl', 'De begintijd moet eerder zijn dan de eindtijd.', 29),
            ('LBL_LINEITEM_DETAILS', 'Lineitem Details', 'nl_nl', 'Item details', 29),
            ('MSG_INVALIDE_DISCOUNT_AMOUNT', 'Discount amount should be less than the total.', 'nl_nl', 'kortingsbedrag moet lager zijn dan het totaal.', 29),
            ('VIEW', 'View', 'nl_nl', 'Weergeven', 29),
            ('MSG_ENTER_VALID', 'Please enter valid', 'nl_nl', 'Voer geldige waarde in', 29),
            ('MSG_ENTER_PERCENTAGE', 'Percentage should be less than 100.', 'nl_nl', 'Percentage moet kleiner zijn dan 100', 29),
            ('ITEM_TOTAL', 'Item Total', 'nl_nl', 'Totaal', 29),
            ('ADJUSTMENT', 'Adjustment', 'nl_nl', 'Bijstelling', 29),
            ('TITLE_CHOOSE_IMAGE', 'Choose Image', 'nl_nl', 'Kies afbeelding', 29),
            ('COMPRESS', 'Compress', 'nl_nl', 'comprimeer', 29),
            ('CHOOSE_ANOTHER_IMAGE', 'Your image size is too large, please select another image', 'nl_nl', 'YUw afbeelding is te groot, selecteer een andere afbeelding', 29),
            ('OnDayOfMonth', 'On day of month', 'nl_nl', 'Op dag van de maand', 29),
            ('OnDayOfWeek', 'On day of week', 'nl_nl', 'Op dag van de week', 29),
            ('AddAndClose', 'Add & Close', 'nl_nl', 'Toevoegen en sluiten', 29),
            ('Repeat', 'Repeat', 'nl_nl', 'Herhalen', 29),
            ('OnDay', 'On day', 'nl_nl', 'Op dag', 29),
            ('View_Line_Item', 'View Line Item', 'nl_nl', 'Regelitem bekijken', 29),
            ('TITLE_IMAGE', 'Image', 'nl_nl', 'Afbeelding', 29),
            ('TITLE_ICLOUD', 'iCloud', 'nl_nl', 'iCloud', 29),
            ('GOOGLE', 'Google', 'nl_nl', 'Google', 29),
            ('ALERT_BTN_OKAY', 'Okay', 'nl_nl', 'Oké', 29),
            ('ALERT_TITLE_ACCESS_DENIED', 'Access Denied', 'nl_nl', 'Toegang geweigerd', 29),
            ('Dont_Show_Again', 'Don\'t show again', 'nl_nl', 'Niet meer weergeven', 29),
            ('Skip', 'Skip', 'nl_nl', 'Overslaan', 29),
            ('Fillter_Name', 'Fillter Name', 'nl_nl', 'Filter naam', 29),
            ('Fillter_Record_Count', 'Fillter Record Count', 'nl_nl', 'Filter aantal', 29),('url_note',  'Note : if your URL of CRM is https://example.com/crm enter that into above box',   'nl_nl',    'Note : if your URL of CRM is https://example.com/crm enter that into above box',   31),
            ('vtiger_url',  'Your vTiger CRM URL',  'nl_nl',    'Your vTiger CRM URL',  31),
            ('msg_doc_read_permission', 'You don\'t have permission to Add either This is read-only or Private Field.',  'nl_nl',    'You don\'t have permission to Add either This is read-only or Private Field.',  31),
            ('CLEAR',   'Clear',    'nl_nl',    'Wis',    31),
            ('Files/photos uploaded successfully',  'Files/photos uploaded successfully',   'nl_nl',    'Bestanden / foto\'s succesvol geüpload',   32),
            ('Digital signature saved', 'Digital signature saved',  'nl_nl',    'Digitale handtekening opgeslagen',  32),
            ('Please upload Signature or Files/photos', 'Please upload Signature or Files/photos',  'nl_nl',    'Upload handtekening of bestanden / foto\'s',  32),
            ('Files / Photos',  'Files / Photos',   'nl_nl',    'bestanden / foto\'s',   32),
            ('Signature',   'Signature',    'nl_nl',    'Handtekening',    32),
            ('add_photo_using', 'Add Photo Using',  'nl_nl',    'Voeg foto toe met behulp van',  31),
            ('btn_upload_sign', '(+) Add Signature',    'nl_nl',    '(+) Voeg handtekening toe',    31),
            ('btn_upload_photo_doc',    '(+) Upload Files/Photos',  'nl_nl',    '(+) Upload bestanden / foto\'s',  31),
            ('select_photo_doc_to_upload',  'Please select files/photos to upload', 'nl_nl',    'Selecteer bestanden / foto\'s om te uploaden', 31),
            ('related_module_title',    'Search from related module and Add to \"Route\"',  'nl_nl',    'Zoeken vanuit gerelateerde module en toevoegen aan \"Route\"',  30),
            ('Route status updated successfully',   'Route status updated successfully',    'nl_nl',    'Routestatus succesvol bijgewerkt',    32),
            ('Session init failed', 'Session init failed',  'nl_nl',    'Initialiseren van de sessie is mislukt.',  32),
            ('You don\'t have permission to access this resource',  'You don\'t have permission to access this resource',   'nl_nl',    'U hebt geen toestemming om toegang te krijgen tot deze bron.',   32),
            ('ctroute_realtedto cannot be empty',   'Could not get the Related To - Try again later',   'nl_nl',    'Kan de gerelateerde module niet ophalen – Probeer het later opnieuw',   32),
            ('ctroute_planning cannot be empty',    'Could not get the Route Planning Record - Try again later',    'nl_nl',    'Kon het routeplanningsrecord niet ophalen - Probeer het later opnieuw',    32),
            ('Something went wrong - Try again later',  'Something went wrong - Try again later',   'nl_nl',    'Er is iets misgegaan - Probeer het later opnieuw',   32),
            ('sequence updated successfully',   'sequence updated successfully',    'nl_nl',    'Volgorde succesvol opgeslagen',    32),
            ('sequence cannot be empty',    'sequence cannot be empty', 'nl_nl',    'Volgorde mag niet leeg zijn', 32),
            ('Shortcut details not saved',  'Shortcut details not saved',   'nl_nl',    'Details van snelkoppeling niet succesvol opgeslagen',   32),
            ('Shortcut details saved successfully', 'Shortcut details saved successfully',  'nl_nl',    'Details van snelkoppeling succesvol opgeslagen',  32),
            ('Route save successfully', 'Route save successfully',  'nl_nl',    'Route succesvol opgeslagen',  32),
            ('Record save successfully',    'Record save successfully', 'nl_nl',    'Record succesvol opgeslagen', 32),
            ('No dependency found for picklist',    'No dependency found for picklist', 'nl_nl',    'Geen afhankelijkheid gevonden voor selectielijst.', 32),
            ('No records found',    'No records found', 'nl_nl',    'Geen records gevonden', 32),
            ('Outgoing server is not enabled, please configure from CRM',   'Outgoing server is not enabled, please configure from CRM',    'nl_nl',    'Uitgaande server is niet ingeschakeld, configureer a.u.b. vanuit CRM',    32),
            ('Removed Successfully',    'Removed Successfully', 'nl_nl',    'Verwijderd Succesvol', 32),
            ('Shortcut has been deleted',   'Shortcut has been deleted',    'nl_nl',    'Snelkoppeling is verwijderd',    32),
            ('relation of records removed successfully',    'relation of records removed successfully', 'nl_nl',    'relatie tussen records succesvol verwijderd', 32),
            ('relation of records not removed', 'relation of records not removed',  'nl_nl',    'relatie tussen records niet verwijderd',  32),
            ('Record has been deleted successfully',    'Record has been deleted successfully', 'nl_nl',    'Record is succesvol verwijderd', 32),
            ('Time Tracking saved successfully',    'Time Tracking saved successfully', 'nl_nl',    'Tijdregistratie succesvol opgeslagen', 32),
            ('Time Tracking updated successfully',  'Time Tracking updated successfully',   'nl_nl',    'Tijdregistratie succesvol bijgewerkt',   32),
            ('Time Tracking ended successfully',    'Time Tracking ended successfully', 'nl_nl',    'Tijdregistratie succesvol beëindigd', 32),
            ('Time Tracking started successfully',  'Time Tracking started successfully',   'nl_nl',    'Tijdregistratie succesvol gestart',   32),
            ('record cannot be empty',  'record cannot be empty',   'nl_nl',    'record kan niet leeg zijn Tijdregistratie succesvol gestart Time Tracki',   32),
            ('Module is disabled',  'Module is disabled',   'nl_nl',    'Module uitgezet',   32),
            ('Shift ended successfully',    'Shift ended successfully', 'nl_nl',    'Dienst beëindigd', 32),
            ('Shift started successfully',  'Shift started successfully',   'nl_nl',    'Dienst begonnen',   32),
            ('relation of records added successfully',  'relation of records added successfully',   'nl_nl',    'Relatie succesvol gelegd',   32),
            ('Comment saved successfully',  'Comment saved successfully',   'nl_nl',    'Opmerking opgeslagen',   32),
            ('Comment not saved',   'Comment not saved',    'nl_nl',    'Opmerking niet opgeslagen',    32),
            ('Comment module is not active',    'Comment module is not active', 'nl_nl',    'Module Opmerkingen niet actief', 32),
            ('No Upcoming Event',   'No Upcoming Event',    'nl_nl',    'Geen aanstaande afspraken',    32),
            ('No Templates found - create it from Message Templates module',    'No Templates found - create it from Message Templates module', 'nl_nl',    'Geen sjablonen gevonden - maak deze aan vanuit de module Berichtsjablonen', 32),
            ('No event or task for this date',  'No event or task for this date',   'nl_nl',    'Geen afspraak of taak voor deze datum',   32),
            ('No filters created',  'No filters created',   'nl_nl',    'Geen filters gemaakt',   32),
            ('Select at least one record to attach',    'Select at least one record to attach', 'nl_nl',    'Selecteer ten minste één record om toe te voegen', 32),
            ('Please select one or more attachments',   'Please select one or more attachments',    'nl_nl',    'Selecteer een of meer bijlagen',    32),
            ('No event for this month', 'No event for this month',  'nl_nl',    'Geen afspraak voor deze maand',  32),
            ('No Activity found',   'No Activity found',    'nl_nl',    'Geen activiteit gevonden',    32),
            ('Your feedback is valuable for us - it cannot be empty',   'Your feedback is valuable for us - it cannot be empty',    'nl_nl',    'Uw feedback is waardevol voor ons - het kan niet leeg zijn',    32),
            ('Could not send mail, Please try later',   'Could not send mail, Please try later',    'nl_nl',    'Kon geen e-mail verzenden, probeer het later',    32),
            ('Latest Version updated successfully', 'Latest Version updated successfully',  'nl_nl',    'Laatste versie succesvol bijgewerkt',  32),
            ('User Location Updated Successfully',  'User Location Updated Successfully',   'nl_nl',    'Gebruikerslocatie succesvol bijgewerkt',   32),
            ('User Location not Updated Successfully',  'User Location not Updated Successfully',   'nl_nl',    'Gebruikerslocatie niet succesvol bijgewerkt',   32),
            ('SMSNotifier is not enable in CRM. Please enable it first',    'SMSNotifier is not enable in CRM. Please enable it first', 'nl_nl',    'SMSNotifier is niet ingeschakeld in CRM. Schakel het eerst in.', 32),
            ('Could not submit your feedback - Please try again later', 'Could not submit your feedback - Please try again later',  'nl_nl',    'Kon uw feedback niet verzenden - Probeer het later opnieuw.',  32),
            ('Thank you for submitting your feedback',  'Thank you for submitting your feedback',   'nl_nl',    'Bedankt voor het indienen van uw feedback.',   32),
            ('Please upload User Image',    'Please upload User Image', 'nl_nl',    'Upload een gebruikersafbeelding.', 32),
            ('Image Not Uploading, please try again',   'Image Not Uploading, please try again',    'nl_nl',    'Afbeelding niet geüpload, probeer het opnieuw',    32),
            ('User Image Uploaded Successfully',    'User Image Uploaded Successfully', 'nl_nl',    'Gebruikersafbeelding geüpload', 32),
            ('Invalid Module name', 'Invalid Module name',  'nl_nl',    'Modulenaam ongeldig',  32),
            ('Records Sync Successfully',   'Records Sync Successfully',    'nl_nl',    'Records succesvol gesynchroniseerd',    32),
            ('Values cannot be empty',  'Values cannot be empty',   'nl_nl',    'Waarden kunnen niet leeg zijn',   32),
            ('Record id is empty',  'Record id is empty',   'nl_nl',    'Record-id is leeg',   32),
            ('Logout Successfully', 'Logout Successfully',  'nl_nl',    'Succesvol uitgelogd',  32),
            ('Please Enable CTMobile Module',   'Please Enable CTMobile Module',    'nl_nl',    'Schakel CTMobile Module in',    32),
            ('Authentication Failed',   'Username and Password do not match',   'nl_nl',    'Gebruikersnaam en wachtwoord komen niet overeen',   32),
            ('Mismatched module information',   'Something gone wrong, please try again later', 'nl_nl',    'Er is iets misgegaan, probeer het later opnieuw', 32),
            ('Field does not exists',   'Please set display fields again',  'nl_nl',    'Veld bestaat niet – stel weer te geven velden opnieuw in',  32),
            ('Module does not exists',  'Module does not exists or disabled by admin',  'nl_nl',    'Module bestaat niet of is uitgeschakeld.',  32),
            ('Month cannot be empty',   'Could not get the Month - Try again later',    'nl_nl',    'Kan maand niet ophalen - Probeer het later opnieuw',    32),
            ('Year cannot be empty',    'Could not get the Year - Try again later', 'nl_nl',    'Kan jaar niet ophalen - Probeer het later opnieuw', 32),
            ('Date cannot be empty',    'Could not get the Date - Try again later', 'nl_nl',    'Kan datum niet ophalen - Probeer het later opnieuw', 32),
            ('Userid cannot be empty',  'Could not get the Userid - Try again later',   'nl_nl',    'Kan de gebruikers-ID niet ophalen - Probeer het later opnieuw Kan de datum niet ophalen - Probeer het later opnieuw Kan het jaar niet ophalen - Probeer het later opnieuw',   32),
            ('End Date cannot be empty',    'Could not get the status - Try again later',   'nl_nl',    'Kan de status niet ophalen - Probeer het later opnieuw',   32),
            ('Start Date cannot be empty',  'Could not get the Start Date - Try again later',   'nl_nl',    'Kan de begindatum niet ophalen - Probeer het later opnieuw',   32),
            ('You do not configure SMS Notifier in CRM. Please configure SMS Notifier in your CRM to use this feature', 'You do not configure SMS Notifier in CRM. Please configure SMS Notifier in your CRM to use this feature',  'nl_nl',    'Configureer SMS Notifier in uw CRM om dit te gebruiken',  32),
            ('Longitude cannot be empty',   'Could not get location-Please try again',  'nl_nl',    'Kan locatie niet ophalen - Probeer het opnieuw',  32),
            ('Latitude cannot be empty',    'Could not get location-Please try again',  'nl_nl',    'Kan locatie niet ophalen - Probeer het opnieuw',  32),
            ('User cannot be empty',    'Could not get the User - Try again later', 'nl_nl',    'Kan de gebruiker niet ophalen - Probeer het later opnieuw', 32),
            ('Status cannot be empty',  'Could not get the status - Try again later',   'nl_nl',    'Kan de status niet ophalen - Probeer het later opnieuw',   32),
            ('Required fields not found',   'Required fields not found',    'nl_nl',    'Verplichte velden niet gevonden',    32),
            ('Tracking module not active',  'Tracking module not active-Please contact CRM Admin',  'nl_nl',    'Tracking-module niet actief - Neem contact op met CRM-beheerder.',  32),
            ('Missing mandatory input values',  'Missing mandatory input values',   'nl_nl',    'Verplichte gegevens ontbreken',   32),
            ('No MailBox found. Please Create Mailbox', 'No MailBox found. Please Create Mailbox',  'nl_nl',    'Geen mailbox gevonden. Maak een mailbox aan.',  32),
            ('Mail not sent',   'Mail not sent',    'nl_nl',    'Mail niet verzonden',    32),
            ('Mail send successfully',  'Mail send successfully',   'nl_nl',    'Mail succesvol verzonden',   32),
            ('Email Id or username not match with your record', 'Email Id or username not match with your record',  'nl_nl',    'E-mail-id of gebruikersnaam komt niet overeen met uw record',  32),
            ('Module not specified',    'Module not specified', 'nl_nl',    'Module niet opgegeven', 32),
            ('No messages found',   'No messages found',    'nl_nl',    'Geen berichten gevonden',    32),
            ('No Dependency Found For This Module', 'No Dependency Found For This Module',  'nl_nl',    'Geen afhankelijkheid gevonden voor deze module',  32),
            ('Outgoing server is not Enabled',  'Outgoing server is not Enabled',   'nl_nl',    'Uitgaande server is niet ingeschakeld',   32),
            ('Outgoing server is Enabled',  'Outgoing server is Enabled',   'nl_nl',    'Uitgaande server is ingeschakeld',   32),
            ('Email Attached Successfully', 'Email Attached Successfully',  'nl_nl',    'E-mail succesvol bevestigd',  32),
            ('Documents Attached Successfully', 'Documents Attached Successfully',  'nl_nl',    'Documenten bijgevoegd',  32),
            ('Login required - Please login again', 'Login required - Please login again',  'nl_nl',    'Inloggen vereist - Gelieve opnieuw in te loggen',  32),
            ('time_tracking_module_disable',    'Time tracking module is disable',  'nl_nl',    'Tijdregistratiemodule is uitgeschakeld',  31),
            ('route_planning_module_disable',   'Route planning module is disable', 'nl_nl',    'Routeplanningsmodule is uitgeschakeld', 31),
            ('mark_as_held',    'Are you sure you want to mark Event as Held?', 'nl_nl',    'Weet u zeker dat u deze afspraken als Gehouden wilt markeren?', 31),
            ('stop_timer_msg',  'You have already started Time tracking for another record, Do you want to stop it first ?',    'nl_nl',    'U bent al begonnen met Tijdregistratie voor een ander record. Wilt u dit eerst stoppen?',    31),
            ('access_denied_routeplanning', 'Access denied for route planning', 'nl_nl',    'Toegang geweigerd voor routeplanning', 31),
            ('time_spent',  'Time Spent',   'nl_nl',    'Tijd besteed',   31),
            ('select_user', 'Select User',  'nl_nl',    'Selecteer gebruiker',  30),
            ('status_cannot_be_held',   'Status cannot be held for future date start',  'nl_nl',    'Deze status kan niet bij een toekomstige startdatum',  30),
            ('please_select_end_date',  'Please select end date',   'nl_nl',    'Selecteer een einddatum.',   30),
            ('please_select_start_date',    'Please select start date', 'nl_nl',    'Selecteer een startdatum', 30),
            ('tap_on_plus_icon_for_select_route',   'Tap on + icon to select record for your route.',   'nl_nl',    'Tik op het pictogram + om een record voor uw route te selecteren.',   30),
            ('please_enter_notes',  'Please enter notes',   'nl_nl',    'Voer notities in',   30),
            ('please_enter_title',  'Please enter title',   'nl_nl',    'Voer titel in',   30),
            ('please_select_date',  'Please Select Date',   'nl_nl',    'Selecteer datum',   30),
            ('search_by_date',  'Search by Date',   'nl_nl',    'Zoek op datum',   30),
            ('shortcut_not_setup_yet',  'Opps shortcut not setup yet!!! Please add shortcut by click on [icon] from record search results or view record screen.',  'nl_nl',    'Snelkoppeling nog niet ingesteld! Voeg een snelkoppeling toe door op [icon] te klikken in de zoekresultaten van records of door het recordscherm te bekijken.',  30),
            ('max_upload_size', 'max file Upload exceeds',  'nl_nl',    'max. Bestand upload overschreden',  30),
            ('unselect_all',    'UnSelect All', 'nl_nl',    'Deselecteer alles', 30),
            ('select_all',  'Select All',   'nl_nl',    'Selecteer alles',   30),
            ('please_select_records',   'Please select records',    'nl_nl',    'Selecteer records',    30),
            ('select_date', 'Select Date',  'nl_nl',    'Selecteer datum',  30),
            ('quantity_in_stock_is',    'Quantity in stock is', 'nl_nl',    'Hoeveelheid in voorraad is', 30),
            ('replies', 'Replies',  'nl_nl',    'Antwoorden',  30),
            ('conversation_require_selection',  'Conversion requires selection of Contact or Organization', 'nl_nl',    'vereist selectie van Contactpersoon of Organisatie', 30),
            ('please_select_product',   'Please Select Product',    'nl_nl',    'Selecteer product',    30),
            ('timer_msg',   'You can start timer for single task only at same time',    'nl_nl',    'U kunt de timer slechts voor een enkele taak tegelijkertijd starten',    31),
            ('save_start_tracking', 'Save & Start Tracking',    'nl_nl',    'Opslaan en starten met volgen',    31),
            ('lbl_notes',   'Notes',    'nl_nl',    'Notities',    31),
            ('enter_title', 'Enter Title',  'nl_nl',    'Voer titel in',  31),
            ('select_module_record',    'Select Module / Record',   'nl_nl',    'Selecteer module / record',   31),
            ('lbl_tomorrow',    'Tomorrow', 'nl_nl',    'Morgen', 30),
            ('lbl_yesterday',   'Yesterday',    'nl_nl',    'Gisteren',    30),
            ('lbl_today',   'Today',    'nl_nl',    'Vandaag',    30),
            ('time_tracker',    'Time Tracker', 'nl_nl',    'Time Tracker', 31),
            ('time_end',    'End Time', 'nl_nl',    'Eindtijd', 5),
            ('due_date',    'End Date', 'nl_nl',    'Einddatum', 5),
            ('time_start',  'Time Start',   'nl_nl',    'Tijd Start',   5),
            ('date_start',  'Start Date',   'nl_nl',    'Start Datum',   5),
            ('delete_widget_msg',   'Display widget again by using (+) option', 'nl_nl',    'Widget opnieuw tonen: gebruik (+)', 15),
            ('no_upcoming_activities',  'No scheduled activities    ',  'nl_nl',    'Geen geplande activiteiten',  15),
            ('check_in_first',  'Please check-in first',    'nl_nl',    'Gelieve eerst in te checken',    30),
            ('duration',    'Duration', 'nl_nl',    'Duur', 30),
            ('distance',    'Distance', 'nl_nl',    'Afstand', 30),
            ('proper_address_message',  'Please enter proper address in record\n',  'nl_nl',    'Vul adres in',    30),
            ('select_status',   'Select Status',    'nl_nl',    'Selecteer Status',    30),
            ('route_planner',   'Route Planner',    'nl_nl',    'Route Planner',    30),
            ('route_planning',  'Route Planning',   'nl_nl',    'Route Planning',   30),
            ('add_route',   'Add Route',    'nl_nl',    'Voeg route toe',    30),
            ('calender_disabled',   'Calendar Module is disabled',  'nl_nl',    'Agenda-module staat uit.',  30),
            ('close_dialog',    'Close form',   'nl_nl',    'Sluit formulier',   30),
            ('cancel_form_message', 'Are You sure want to close ?', 'nl_nl',    'Weet u zeker dat u wilt sluiten?', 30),
            ('create_route',    'Create Route', 'nl_nl',    'Maak route', 30),
            ('select_module_create_route',  'Select Module to create Route',    'nl_nl',    'Selecteer Module voor het maken van een route.',    30),
            ('cancel',  'Cancel',   'nl_nl',    'Annuleren',   30),
            ('assign_route',    'Assign Route', 'nl_nl',    'toewijzen Route', 30),
            ('route_for',   'Route for',    'nl_nl',    'Route voor',    30),
            ('assigned_to', 'Assigned To',  'nl_nl',    'Toegewezen aan',  30),
            ('enter_route_name',    'Enter Route Name', 'nl_nl',    'Enter Route Name', 30),
            ('list',    'List', 'nl_nl',    'Lijst', 30),
            ('map', 'Map',  'nl_nl',    'Map',  30),
            ('other_modules',   'Other Modules',    'nl_nl',    'Andere modules',    15),
            ('shortcut_no_record_msg',  'Opps shortcut not setup\n yet!!! Please add shortcut  by click on + icon from record\n search results or view record screen.', 'nl_nl',    'Snelkoppeling nog niet ingesteld. Voeg een snelkoppeling toe door op het pictogram + te klikken in de 
 zoekresultaten van records of bekijk het recordscherm.', 25),
            ('clear',   'Clear',    'nl_nl',    'Wissen',    25),
            ('open',    'Open', 'nl_nl',    'Openen', 11),
            ('max_file_msg',    'Too many files selected (max:6)',  'nl_nl',    'Te veel bestanden geselecteerd (max: 6)',  11),
            ('error_voicenote_record',  'Unable to recording voice while another application is recording sound.',  'nl_nl',    'Kan niet opnemen terwijl een andere toepassing geluid opneemt.',  11),
            ('msg_warning', 'Warning!', 'nl_nl',    'Waarschuwing!', 11),
            ('Permision_denied_contact',    'Permission denied to access your contacts',    'nl_nl',    'Toestemming geweigerd om toegang te krijgen tot uw contactpersonen.',    15),
            ('no_widget_added', 'Please click + icon to add new widget to your dashboard.', 'nl_nl',    'Klik op het + pictogram om een ​​nieuw widget aan uw dashboard toe te voegen.', 15),
            ('no_data_available',   'Data not available, please check the selected fields', 'nl_nl',    'Gegevens niet beschikbaar, controleer de geselecteerde velden.', 15),
            ('check_out_successfully',  'Check out successfully',   'nl_nl',    'Succesvol uitchecken', 11),
            ('check_in_successfully',   'Check in successfully',    'nl_nl',    'Check in succes',  11),
            ('check_out',   'Check out',    'nl_nl',    'Check out',    11),
            ('check_in',    'Check in', 'nl_nl',    'Check in', 11),
            ('navigate',    'Navigate', 'nl_nl',    'Navigeren', 11),
            ('save_to_phone_vcard_success', 'VCard Saved to phone successfully',    'nl_nl',    'VCard opgeslagen op de telefoon met succes',    15),
            ('download_vcard_success',  'VCard downloaded successfully',    'nl_nl',    'VCard gedownload',    15),
            ('card_details',    'Card Details', 'nl_nl',    'Kaart details', 15),
            ('add_widget',  'Add Widget',   'nl_nl',    'Voeg widget toe',   15),
            ('delete_widget',   'Are you sure to hide widget?', 'nl_nl',    'Weet u zeker dat u dit widget wilt verbergen?', 15),
            ('already_widgets_added',   'All types of Widget & reports are already added',  'nl_nl',    'Alle soorten Widget & rapporten zijn al toegevoegd',  15),
            ('retry',   'Retry',    'nl_nl',    'Retry',    28),
            ('retake',  'Retake',   'nl_nl',    'Retake',   28),
            ('Reports', 'Reports',  'nl_nl',    'Reports',  15),
            ('Widgets', 'Widgets',  'nl_nl',    'Widgets',  15),
            ('vcard_config',    'Vcard Configuration',  'nl_nl',    'Vcard Configuration',  8),
            ('save_to_phone',   'Save to phone',    'nl_nl',    'Opslaan in telefoon',    11),
            ('download_vcard',  'Download Vcard',   'nl_nl',    'Download vCard',   11),
            ('share_vcard', 'Share Vcard',  'nl_nl',    'Delen Vcard',  11),
            ('share_record',    'Share Record', 'nl_nl',    'Delen Record', 11),
            ('permission_denied_edit',  'You don\'t have permission to edit this record.',  'nl_nl',    'U bent niet gemachtigd om dit record te bewerken.',  27),
            ('permission_denied_delete',    'You don\'t have permission to delete this record.',    'nl_nl',    'U bent niet gemachtigd om dit record te verwijderen.',    27),
            ('Voice_Recording_Started', 'Recording Started',    'nl_nl',    'Opname gestart',    12),
            ('Voice_Recording_Stopped', 'Recording Stopped',    'nl_nl',    'Opname gestopt',    12),
            ('SEARCH',  'Search',   'nl_nl',    'zoekopdracht',   7),
            ('LAST',    'Last', 'nl_nl',    'laatste', 7),
            ('FIRST',   'First',    'nl_nl',    'Eerste',    7),
            ('MONDAY',  'Monday',   'nl_nl',    'Maandag',   7),
            ('TUESDAY', 'Tuesday',  'nl_nl',    'Dinsdag',  7),
            ('WEDNESDAY',   'Wednesday',    'nl_nl',    'woensdag',    7),
            ('THURSDAY',    'Thursday', 'nl_nl',    'donderdag', 7),
            ('FRIDAY',  'Friday',   'nl_nl',    'vrijdag',   7),
            ('SATURDAY',    'Saturday', 'nl_nl',    'zaterdag', 7),
            ('SUNDAY',  'Sunday',   'nl_nl',    'zondag',   7),
            ('DAILY',   'Daily',    'nl_nl',    'Dagelijks',    7),
            ('WEEKLY',  'Weekly',   'nl_nl',    'Wekelijks',   7),
            ('MONTHLY', 'Monthly',  'nl_nl',    'Maandelijks',  7),
            ('YEARLY',  'Yearly',   'nl_nl',    'Jaarlijks',   7),
            ('asset_tracking',  'Asset tracking',   'nl_nl',    'Activa bijhouden',   15);",array());
    }

    static function ru_ru(){
        global $adb;
        $checkQuery = "DELETE FROM ctmobile_language_keyword WHERE keyword_lang = ?";
        $checkResult = $adb->pquery($checkQuery,array('ru_ru'));
        
        $adb->pquery("INSERT INTO `ctmobile_language_keyword` (`keyword`, `keyword_name`, `keyword_lang`, `language_keyword`, `sectionid`) VALUES
            ('network_error', 'Network connection error!', 'ru_ru', 'Ошибка сети!', 1),
            ('connection_check', 'Could not connect to CRM, Please check your Internet connection.', 'ru_ru', 'Пожалуйста, проверьте подключение к интернету.', 1),
            ('update', 'Update', 'ru_ru', 'Update', 1),
            ('cancel', 'Cancel', 'ru_ru', 'Cancel', 1),
            ('ok', 'Ok', 'ru_ru', 'OK', 1),
            ('more_information', 'Click here for more information.', 'ru_ru', 'Для получения дополнительной информации нажмите здесь.', 1),
            ('yes', 'Yes', 'ru_ru', 'Да', 1),
            ('no', 'No', 'ru_ru', 'Нет', 1),
            ('click_again_exit', 'Click again to exit', 'ru_ru', 'Нажмите еще раз, чтобы выйти', 1),
            ('forpermission', 'You don\'t have permission to view this feature. Please subscribe for Premium version Click here to Subscribe.', 'ru_ru', 'Вы не можете воспользоваться этим функционалом. Пожалуйста, подпишитесь на Премиум версию. Нажмите сюда, чтобы подписаться.', 1),
            ('clickhere', 'Click here', 'ru_ru', 'Нажмите сюда', 1),
            ('clickhere_subscribe', 'Click here to subscribe premium version', 'ru_ru', 'Нажмите, чтобы подписаться', 1),
            ('clickhere_configure', 'Click here and view how to Configure.', 'ru_ru', 'Нажмите здесь и посмотрите, как настроить.', 1),
            ('please_wait', 'Please Wait…', 'ru_ru', 'Подождите пожалуйста…', 1),
            ('share__msg', 'Share file with', 'ru_ru', 'Поделиться файлом через', 1),
            ('dialog_camera', 'Camera', 'ru_ru', 'Камера', 1),
            ('dialog_add_file_by', 'Take Photo from', 'ru_ru', 'Добавить файлы по', 1),
            ('add', 'Add', 'ru_ru', 'добавить', 1),
            ('mail_manager_configured', 'Mail Manager is not configured', 'ru_ru', 'Почтовый менеджер не настроен', 1),
            ('dialog_add_files_by', 'Add Files by', 'ru_ru', 'Добавить файлы по', 1),
            ('dialog_drive', 'Drive', 'ru_ru', 'Google Drive', 1),
            ('dialog_drop_box', 'Drop Box', 'ru_ru', 'DropBox', 1),
            ('dialog_need_signin', 'You need to Sign-in to your Drive account first.', 'ru_ru', 'Сначала нужно авторизироваться', 1),
            ('dialog_gallery', 'Gallery', 'ru_ru', 'Галерея', 1),
            ('delete', 'Delete', 'ru_ru', 'Удалить', 1),
            ('timeoutmessage', 'Oops! Request is taking more time than expected.', 'ru_ru', 'К сожалению, запрос занимает больше времени, чем ожидалось.', 1),
            ('gps_location_message', 'GPS is not enabled. Please turn it on to get your near by locations.', 'ru_ru', 'GPS не включен. Пожалуйста, включите его, чтобы получить маршрут.', 1),
            ('sure_want_delete', 'Are you sure want to delete ?', 'ru_ru', 'Вы действительно хотите удалить?', 1),
            ('select', 'Select', 'ru_ru', 'Выбрать', 1),
            ('msgforrecordaudio', 'Minimum record duration one second.', 'ru_ru', 'Minimum record duration one second.', 1),
            ('permission_storage', 'Permission denied to read your External storage', 'ru_ru', 'Чтение внешнего хранилища запрещено', 1),
            ('send_permission_msg', 'Send message permission denied', 'ru_ru', 'Отказаться от разрешения на передачу сообщений', 1),
            ('choosefile', 'Choose File', 'ru_ru', 'Выберите файл', 1),
            ('enter', 'Enter', 'ru_ru', 'Введите', 1),
            ('select_an_option', 'Select an Option', 'ru_ru', 'Select an Option', 1),
            ('email_validation', 'Email is not valid', 'ru_ru', 'Email не является допустимым', 1),
            ('please_enter', 'Please Enter', 'ru_ru', 'Пожалуйста, введите', 1),
            ('website_validation_text', 'Website URL is not valid', 'ru_ru', 'URL сайта недействителен', 1),
            ('selectvalue', 'Select value first', 'ru_ru', 'Выберите значение', 1),
            ('email', 'Email', 'ru_ru', 'Эл. адрес', 1),
            ('enter_email_address', 'Enter email address', 'ru_ru', 'Введите адрес электронной почты', 1),
            ('email_address_not_correct', 'Email address incorrect', 'ru_ru', 'Неправильный адрес электронной почты', 1),
            ('pls_enter_subject', 'Please Enter Subject', 'ru_ru', 'Пожалуйста, введите тему', 1),
            ('attachFiles', 'Attached File', 'ru_ru', 'Прикрепить файл', 1),
            ('from', 'From', 'ru_ru', 'От', 1),
            ('to', 'To', 'ru_ru', 'Кому', 1),
            ('call_permission_msg', 'Call permission denied', 'ru_ru', 'Установлен запрет на совершение звонков', 1),
            ('no_records', 'No records found', 'ru_ru', 'Записей не найдено', 1),
            ('fullform', 'Create New', 'ru_ru', 'Полная форма', 1),
            ('save', 'Save', 'ru_ru', 'Сохранить', 1),
            ('total', 'Total', 'ru_ru', 'Всего', 1),
            ('discount', 'Discount', 'ru_ru', 'Скидка', 1),
            ('price', 'Price', 'ru_ru', 'Цена *', 1),
            ('quantity', 'Quantity', 'ru_ru', 'Количество *', 1),
            ('select_module', 'Select Module', 'ru_ru', 'Выберите модуль', 1),
            ('item_list', 'Item List', 'ru_ru', 'Список товаров', 1),
            ('quickcreate', 'Quick Create', 'ru_ru', 'Быстрое создание', 1),
            ('overwrite_msg_part1', 'Overwrite the existing address with the selected', 'ru_ru', 'Overwrite the existing address with the selected', 1),
            ('once_in_every', 'Once in every', 'ru_ru', 'Один раз в каждом', 1),
            ('overwrite_msg_part2', 'address details?', 'ru_ru', 'address details?', 1),
            ('add_item', 'Add Item', 'ru_ru', 'Добавить запись', 1),
            ('recordsave', 'Record saved successfully', 'ru_ru', 'Запись успешно сохранена', 1),
            ('recordnotsave', 'Could not save record. Try again later', 'ru_ru', 'Ошибка сохранения записи', 1),
            ('minutes', 'Minutes', 'ru_ru', 'минут', 1),
            ('hours', 'Hours', 'ru_ru', 'часов', 1),
            ('days', 'Days', 'ru_ru', 'дней', 1),
            ('on', 'On', 'ru_ru', 'На', 1),
            ('day_of_the_month', 'day of the month', 'ru_ru', 'день месяца', 1),
            ('list_price', 'List Price', 'ru_ru', 'Цена за единицу *', 1),
            ('add_record', 'Add Record', 'ru_ru', 'Добавить запись', 1),
            ('add_product', 'Add Product', 'ru_ru', 'Добавить товар', 1),
            ('add_service', 'Add Service', 'ru_ru', 'Добавить услугу', 1),
            ('discountin', 'Discount in %', 'ru_ru', 'Скидка в%', 1),
            ('unitprice', 'Unit price', 'ru_ru', 'Цена за единицу *', 1),
            ('netprice', 'Net price', 'ru_ru', 'Цена нетто *', 1),
            ('comments', 'Comments', 'ru_ru', 'Комментарии', 1),
            ('add_close', 'Add & Close', 'ru_ru', 'Добавить', 1),
            ('fetching_rout_message', 'Fetching route, Please wait…', 'ru_ru', 'Получение маршрута, пожалуйста, подождите …', 1),
            ('setting', 'Settings', 'ru_ru', 'Настройки', 1),
            ('utc', 'UTC', 'ru_ru', 'UTC', 1),
            ('in', 'In', 'ru_ru', 'В', 1),
            ('days_ago', 'days ago', 'ru_ru', 'дней назад', 1),
            ('mins_ago', 'Minutes ago', 'ru_ru', 'мин назад', 1),
            ('justnow', 'Just now', 'ru_ru', 'Прямо сейчас', 1),
            ('hours_ago', 'hours ago', 'ru_ru', 'несколько часов назад', 1),
            ('in_1_day', 'In 1 day', 'ru_ru', 'Через 1 день', 1),
            ('scanqrcode', 'Asset / Card scanner', 'ru_ru', 'Сканер QR-кода', 1),
            ('call_log', 'Call Log', 'ru_ru', 'История звонков', 1),
            ('voice_message', 'Hi', 'ru_ru', 'Hi', 1),
            ('voice_message1', 'What can I search for you in', 'ru_ru', 'What can I search for you in', 1),
            ('live_tracking', 'Live Tracking', 'ru_ru', 'Открыть карту', 1),
            ('mailmanager', 'Mail Manager', 'ru_ru', 'Менеджер почты', 1),
            ('my_location', 'My location', 'ru_ru', 'Мое местонахождение', 1),
            ('created_on', 'Created On', 'ru_ru', 'Дата создания', 1),
            ('modified_on', 'Modified On', 'ru_ru', 'Дата изменения', 1),
            ('enter_comments', 'Enter Comments', 'ru_ru', 'Введите комментарии', 1),
            ('viewmore', 'View More', 'ru_ru', 'Подробнее', 1),
            ('viewless', 'View Less', 'ru_ru', 'Смотреть меньше', 1),
            ('gotofullform', 'Go to Full Form', 'ru_ru', 'Перейти к полной форме', 1),
            ('post', 'Post', 'ru_ru', 'Опубликовать', 1),
            ('url', 'URL', 'ru_ru', 'URL', 1),
            ('dialog_title_text_back_color', 'Select a Text Background Color', 'ru_ru', 'Выберите цвет фона текста', 1),
            ('event_or_task', 'Add event/task', 'ru_ru', 'Add event/task', 1),
            ('shortcut', 'Shortcuts', 'ru_ru', 'Ярлыки', 1),
            ('select_field', 'Select Field', 'ru_ru', 'Выберите поле', 1),
            ('share', 'Share', 'ru_ru', 'Поделиться', 1),
            ('title_insert_link', 'Insert Link', 'ru_ru', 'Вставить ссылку', 1),
            ('addyourcommentshere', 'Add your comments here', 'ru_ru', 'Введите свой комментарий', 1),
            ('nocomment', 'No Comments', 'ru_ru', 'Комментарии отсутствуют', 1),
            ('leads', 'Leads', 'ru_ru', 'Обращения', 1),
            ('true_val', 'true', 'ru_ru', 'True', 1),
            ('noresult', 'No Result', 'ru_ru', 'Результатов не найдено', 1),
            ('version', 'Version', 'ru_ru', 'Версия', 1),
            ('convert_lead', 'Convert Lead', 'ru_ru', 'Convert Lead', 1),
            ('app_name', 'CRMTiger', 'ru_ru', 'CRMTiger', 1),
            ('enter_url', 'Please Enter url', 'ru_ru', 'Введите URL-адрес', 1),
            ('help', 'Help', 'ru_ru', 'Помогите', 1),
            ('contact_us', 'Contact Us', 'ru_ru', 'Связаться с нами', 1),
            ('updates', 'Updates', 'ru_ru', 'История', 1),
            ('logout', 'LogOut', 'ru_ru', 'Выйти', 1),
            ('busnies_cardscanner', 'Business Card Scanner', 'ru_ru', 'Business Card Scanner', 1),
            ('sure_want_logout', 'Are you sure want to logout ?', 'ru_ru', 'Вы действительно хотите выйти из системы?', 1),
            ('logout_message', 'Logout successfully', 'ru_ru', 'Вы действительно хотите выйти из системы?', 1),
            ('all', 'All', 'ru_ru', 'Все', 1),
            ('add_event', 'Add event', 'ru_ru', 'Add event', 1),
            ('add_task', 'Add Task', 'ru_ru', 'Add Task', 1),
            ('next', 'Next', 'ru_ru', 'Next', 1),
            ('terms_conditions', 'Terms and Conditions', 'ru_ru', 'Terms and Conditions', 1),
            ('login', 'Login', 'ru_ru', 'Авторизация', 2),
            ('privacy_policay', 'By logging in, you agree to our Terms and Conditions & Privacy Policy', 'ru_ru', 'Регистрируясь, вы соглашаетесь с нашими Условиями  политика конфиденциальности', 2),
            ('copyright', 'Copyright © 2020 CRMTiger Version', 'ru_ru', 'Copyright © 2019 CRMTiger Версия', 2),
            ('enter_username', 'Please enter username', 'ru_ru', 'Введите имя пользователя', 2),
            ('enter_password', 'Please enter password', 'ru_ru', 'Пожалуйста введите пароль', 2),
            ('remanberme', 'Remember Me', 'ru_ru', 'Запомнить меня', 2),
            ('forgot_password', 'Forgot password?', 'ru_ru', 'Забыли пароль?', 2),
            ('privacy_policay1', 'Privacy Policy', 'ru_ru', 'политика конфиденциальности', 2),
            ('contactsupportmsg', 'Something went wrong. \\n please Click here to contact support.', 'ru_ru', 'Something went wrong. \\n please Click here to contact support.', 2),
            ('enter_username_password', 'Entered Username or Password is wrong', 'ru_ru', 'Введенные имя пользователя или пароль неверны', 2),
            ('server_issue_occured', 'Server issues occurred', 'ru_ru', 'Server issues occurred', 2),
            ('password', 'Password', 'ru_ru', 'Пароль', 3),
            ('user_name', 'Username', 'ru_ru', 'Имя пользователя', 3),
            ('reset_pwd', 'Reset Password', 'ru_ru', 'Сбросить пароль', 3),
            ('forgot_password_title', 'Forgot password', 'ru_ru', 'Восстановить пароль', 3),
            ('enter_user_name', 'Enter user name', 'ru_ru', 'Введите имя пользователя', 3),
            ('cc', 'Cc', 'ru_ru', 'Скрытая копия', 4),
            ('body', 'Body', 'ru_ru', 'Тело сообщения', 4),
            ('bcc', 'BCC', 'ru_ru', 'Скрытая копия', 4),
            ('dialog_title_text_color', 'Select a Text Color', 'ru_ru', 'Выберите цвет текста', 4),
            ('date', 'Date', 'ru_ru', 'Дата', 4),
            ('subject', 'Subject', 'ru_ru', 'Тема сообщения', 4),
            ('composeMail', 'Compose Mail', 'ru_ru', 'Написать письмо', 4),
            ('send', 'Send', 'ru_ru', 'Отправить', 4),
            ('select_message', 'Select message', 'ru_ru', 'Выберите сообщение', 4),
            ('title_insert_table', 'Insert Table', 'ru_ru', 'Вставить таблицу', 4),
            ('log_file_sms', 'I agree to Share API Log to Technical team for further troubleshooting', 'ru_ru', 'Я согласен поделиться логами API с технической поддержкой для устранения неполадок', 5),
            ('edit_record', 'Edit Records', 'ru_ru', 'Редактировать запись', 5),
            ('select_time', 'Select Time', 'ru_ru', 'Выберите время', 5),
            ('edit_item', 'Edit Item', 'ru_ru', 'Изменить запись', 5),
            ('items_total', 'Items Total', 'ru_ru', 'Всего товаров', 5),
            ('number_less_then_31', 'Number should be less than 31', 'ru_ru', 'Number should be less than 31', 5),
            ('users', 'Users', 'ru_ru', 'пользователей', 5),
            ('groups', 'Groups', 'ru_ru', 'группы', 5),
            ('txt_note_for_file', 'Note : Existing attachments(images/files) will be replaced', 'ru_ru', 'Примечание: существующие вложения (изображения / файлы) будут заменены', 5),
            ('greaterdatetime', 'End DateTime should be greater than Start DateTime', 'ru_ru', 'Дата и время окончания должны быть больше даты и времени начала', 5),
            ('until', 'Until', 'ru_ru', 'До тех пор', 5),
            ('organizations', 'Organizations', 'ru_ru', 'Контрагенты', 6),
            ('contacts', 'Contacts', 'ru_ru', 'Контакты', 6),
            ('opportunity', 'Opportunity', 'ru_ru', 'Возможность', 6),
            ('lbl_sun', 'SUN', 'ru_ru', 'вс', 7),
            ('lbl_mon', 'MON', 'ru_ru', 'пн', 7),
            ('lbl_tue', 'TUE', 'ru_ru', 'вт', 7),
            ('lbl_wed', 'WED', 'ru_ru', 'ср', 7),
            ('lbl_thu', 'THU', 'ru_ru', 'чт', 7),
            ('lbl_fri', 'FRI', 'ru_ru', 'пт', 7),
            ('lbl_sat', 'SAT', 'ru_ru', 'сб', 7),
            ('lbl_1', '1', 'ru_ru', '1', 7),
            ('lbl_2', '2', 'ru_ru', '2', 7),
            ('lbl_3', '3', 'ru_ru', '3', 7),
            ('lbl_4', '4', 'ru_ru', '4', 7),
            ('lbl_5', '5', 'ru_ru', '5', 7),
            ('lbl_6', '6', 'ru_ru', '6', 7),
            ('lbl_7', '7', 'ru_ru', '7', 7),
            ('lbl_8', '8', 'ru_ru', '8', 7),
            ('lbl_9', '9', 'ru_ru', '9', 7),
            ('lbl_10', '10', 'ru_ru', '10', 7),
            ('lbl_11', '11', 'ru_ru', '11', 7),
            ('lbl_12', '12', 'ru_ru', '12', 7),
            ('lbl_13', '13', 'ru_ru', '13', 7),
            ('lbl_14', '14', 'ru_ru', '14', 7),
            ('lbl_15', '15', 'ru_ru', '15', 7),
            ('lbl_16', '16', 'ru_ru', '16', 7),
            ('lbl_17', '17', 'ru_ru', '17', 7),
            ('lbl_18', '18', 'ru_ru', '18', 7),
            ('lbl_19', '19', 'ru_ru', '19', 7),
            ('lbl_20', '20', 'ru_ru', '20', 7),
            ('lbl_21', '21', 'ru_ru', '21', 7),
            ('lbl_22', '22', 'ru_ru', '22', 7),
            ('lbl_23', '23', 'ru_ru', '23', 7),
            ('lbl_24', '24', 'ru_ru', '24', 7),
            ('lbl_25', '25', 'ru_ru', '25', 7),
            ('lbl_26', '26', 'ru_ru', '26', 7),
            ('lbl_27', '27', 'ru_ru', '27', 7),
            ('lbl_28', '28', 'ru_ru', '28', 7),
            ('lbl_29', '29', 'ru_ru', '29', 7),
            ('lbl_30', '30', 'ru_ru', '30', 7),
            ('lbl_31', '31', 'ru_ru', '31', 7),
            ('lbl_32', '32', 'ru_ru', '32', 7),
            ('lbl_33', '33', 'ru_ru', '33', 7),
            ('lbl_34', '34', 'ru_ru', '34', 7),
            ('lbl_35', '35', 'ru_ru', '35', 7),
            ('lbl_36', '36', 'ru_ru', '36', 7),
            ('lbl_37', '37', 'ru_ru', '37', 7),
            ('lbl_38', '38', 'ru_ru', '38', 7),
            ('lbl_39', '39', 'ru_ru', '39', 7),
            ('lbl_40', '40', 'ru_ru', '40', 7),
            ('lbl_41', '41', 'ru_ru', '41', 7),
            ('lbl_42', '42', 'ru_ru', '42', 7),
            ('current_date', 'current date', 'ru_ru', 'Текущая дата', 7),
            ('event', 'Events', 'ru_ru', 'События', 7),
            ('calendar', 'Calendar', 'ru_ru', 'Календарь', 7),
            ('latest_version', 'Latest Version :', 'ru_ru', 'Последняя версия :', 8),
            ('expire_on', 'Next renewal date : ', 'ru_ru', 'Срок действия:', 8),
            ('ctmobile_ext_version', 'CTMobile Ext. Version : ', 'ru_ru', 'CTMobile Ext. Версия: ', 8),
            ('you_have_latest_version', 'You already have latest version', 'ru_ru', 'Вы обновили версию ', 8),
            ('latest_version1', 'You Already have latest version', 'ru_ru', 'У вас уже есть последняя версия', 8),
            ('upgreaded', 'Upgrade', 'ru_ru', 'Обновить', 8),
            ('downgrade', 'Downgrade', 'ru_ru', 'упадок', 8),
            ('dialog_recent_event_info', 'You can set from here how many number of records you want to show on Home screen for Recent Event.', 'ru_ru', 'Здесь вы можете указать, сколько записей вы хотите показать на главном экране недавнего события.', 8),
            ('dialog_feedback_info', 'You can submit your feedback with description , our team will check your feedback and get back to you.', 'ru_ru', 'Вы можете оставить свой отзыв с описанием, наша команда проверит ваш отзыв и свяжется с вами.', 8),
            ('dialog_log_info', 'Log functionality is used for customer support / help , If you are facing any issues in app or any module or functionality is not working proper then you can enable share log with our development team.', 'ru_ru', 'Функция поддержки журналов используется для поддержки / помощи клиентов. Если у вас возникли какие-либо проблемы в приложении или какой-либо модуль или функция не работает должным образом, вы можете включить общий доступ к журналу с нашей командой разработчиков.', 8),
            ('info', 'Info', 'ru_ru', 'Информация', 8),
            ('recent_history', 'Recent History', 'ru_ru', 'Последние события', 8),
            ('recent_feedback', 'Feedback', 'ru_ru', 'Ошибка! Попробуйте еще раз', 8),
            ('recent_log', 'Log', 'ru_ru', 'Журнал', 8),
            ('crmtiger_app_version', 'CRMTiger App Version : ', 'ru_ru', 'Версия приложения CRMTiger:', 8),
            ('historylimit', 'Recent History Limit', 'ru_ru', 'Ограничение по количеству записей', 8),
            ('radious_in_miles', 'Radius in miles', 'ru_ru', 'Радиус в милях', 8),
            ('recentlimit', 'Recent Event Limit', 'ru_ru', 'Ограничение по количеству записей', 8),
            ('upcoming_events', 'Upcoming Events', 'ru_ru', 'Предстоящие События', 8),
            ('rate_our_app', 'Rate Our App!', 'ru_ru', 'Оцените наше приложение!', 8),
            ('feedback', 'Submit Feedback', 'ru_ru', 'Отправить отзыв', 8),
            ('sendfeedback', 'Feedback Send', 'ru_ru', 'Обратная связь', 8),
            ('emaillimit', 'Email limit', 'ru_ru', 'Ограничение электронной почты', 8),
            ('log', 'Log', 'ru_ru', 'Журнал', 8),
            ('logclear', 'Log cleared successfully.', 'ru_ru', 'Ясно, успешно', 8),
            ('dialog_recent_history_info', 'You can set from here how many number of records you want to show on Home screen for Recent History.', 'ru_ru', 'Здесь вы можете указать, сколько записей вы хотите показать на главном экране для недавней истории.', 8),
            ('proceed_to_upgrade1', 'Proceed to', 'ru_ru', 'Proceed to', 8),
            ('upgradation_message', 'will required logout and login again later.', 'ru_ru', 'will required logout and login again later.', 8),
            ('proceed_to_upgrade', 'Proceed to Upgrade', 'ru_ru', 'Proceed to Upgrade', 8),
            ('module_setting', 'Module Setting', 'ru_ru', 'Настройка модуля', 9),
            ('sortbyfield', 'Sort by field', 'ru_ru', 'Сортировать по полю', 9),
            ('ascending', 'Ascending  A to Z', 'ru_ru', 'По возрастанию от А до Я', 9),
            ('descending', 'Descending  Z to A', 'ru_ru', 'По убыванию от Z до As', 9),
            ('first_field', 'First Field', 'ru_ru', 'Первое поле', 9),
            ('second_field', 'Second Field', 'ru_ru', 'Второе поле', 9),
            ('third_field', 'Third Field', 'ru_ru', 'Третье поле', 9),
            ('sure_want_restore', 'Are you sure you want to reset to default settings?', 'ru_ru', 'Вы уверены, что хотите восстановить настройки по умолчанию?', 9),
            ('orderlist', 'List Order', 'ru_ru', 'Список заказов', 9),
            ('module_reset', 'Restore to Default', 'ru_ru', 'Восстановить значения по умолчанию', 9),
            ('display_fields', 'Display Fields', 'ru_ru', 'Отобразить поля', 9),
            ('discount_lessthen_100', 'Discount % should be less than 100', 'ru_ru', 'Скидка должна быть меньше 100%', 10),
            ('select_item', 'Select Item', 'ru_ru', 'Выберите запись', 10),
            ('item_comment', 'Item Comment', 'ru_ru', 'Пункт Комментарий', 10),
            ('record_name', 'Record Name is :', 'ru_ru', 'Record Name is :', 11),
            ('go_back', 'Go Back', 'ru_ru', 'Вернитесь', 11),
            ('please_enter_shortcut_name', 'Please Enter Shortcut Name', 'ru_ru', 'Пожалуйста, введите имя ярлыка', 11),
            ('number_not_found', 'Contact Number not found', 'ru_ru', 'Номер не найден', 11),
            ('mail_not_found', 'Mail Address not found', 'ru_ru', 'Почтовый адрес не найден', 11),
            ('create_shortcut', 'Create Shortcut', 'ru_ru', 'Создать ярлык', 11),
            ('contact_summary', 'Summary', 'ru_ru', 'Краткая информация', 11),
            ('activites', 'Activities', 'ru_ru', 'События', 11),
            ('details', 'Details', 'ru_ru', 'Подробная информация', 11),
            ('related', 'Related', 'ru_ru', 'Связан', 11),
            ('share_link', 'Share record with', 'ru_ru', 'Share record with', 11),
            ('edit', 'Edit', 'ru_ru', 'Edit', 11),
            ('duplicate', 'Duplicate', 'ru_ru', 'Duplicate', 11),
            ('whatsapp', 'Whatsapp', 'ru_ru', 'Whatsapp', 11),
            ('call', 'Call', 'ru_ru', 'Call', 11),
            ('choose_contact_for_call', 'Choose Contact for Call', 'ru_ru', 'Choose Contact for Call', 11),
            ('choose_contact_for_sms', 'Choose Contact for SMS', 'ru_ru', 'Choose Contact for SMS', 11),
            ('choose_contact_for_whatsapp', 'Choose Contact for WhatsApp', 'ru_ru', 'Choose Contact for WhatsApp', 11),
            ('chosse_contact_for_email', 'Choose Email', 'ru_ru', 'Choose Email', 11),
            ('attach_file', 'Attach Files', 'ru_ru', 'Attach Files', 11),
            ('close', 'Close', 'ru_ru', 'Close', 11),
            ('status', 'Status', 'ru_ru', 'Статус', 11),
            ('stop', 'Stop', 'ru_ru', 'Stop', 11),
            ('zero', '0', 'ru_ru', '0', 11),
            ('record', 'Record', 'ru_ru', 'Record', 11),
            ('voice_note', 'Voice Note', 'ru_ru', 'Voice Note', 11),
            ('tickets', 'Tickets', 'ru_ru', 'Заявки', 12),
            ('check_out', 'Check Out', 'ru_ru', 'Проверять, выписываться', 12),
            ('check_in', 'Check In', 'ru_ru', 'Регистрироваться', 12),
            ('select_any', 'Select any', 'ru_ru', 'Выберите любой', 12),
            ('fulldetails', 'Show Full Details', 'ru_ru', 'Показать подробную информацию', 12),
            ('checkin', 'Check-in', 'ru_ru', 'Регистрироваться', 12),
            ('navigate', 'Navigate', 'ru_ru', 'проводить', 12),
            ('product', 'Products', 'ru_ru', 'Товары', 12),
            ('projectMilestone', 'Project Milestone', 'ru_ru', 'Контрольные точки', 12),
            ('projecttask', 'Project Tasks', 'ru_ru', 'Проектные задачи', 12),
            ('nearby', 'NearBy', 'ru_ru', 'Рядом', 13),
            ('document', 'Document', 'ru_ru', 'Документ', 14),
            ('reply', 'Reply', 'ru_ru', 'Ответить', 14),
            ('reply_all', 'Reply All', 'ru_ru', 'Ответить всем', 14),
            ('forward', 'Forward', 'ru_ru', 'Переслать', 14),
            ('action', 'Action', 'ru_ru', 'действие', 14),
            ('select_first', 'Select First', 'ru_ru', 'Select First', 14),
            ('commentaddsuccessful', 'Comment added successfull', 'ru_ru', 'Комментарий добавлен Успешно', 14),
            ('move_to', 'Move to', 'ru_ru', 'Переместить', 14),
            ('attach', 'Attach', 'ru_ru', 'Прикрепить', 14),
            ('addcoment', 'Add Comment', 'ru_ru', 'Добавить комментарий', 14),
            ('adddocument', 'Add Document', 'ru_ru', 'Добавить документ', 14),
            ('home', 'Home', 'ru_ru', 'Главная', 15),
            ('checkout', 'Check-out', 'ru_ru', 'Проверять, выписываться', 15),
            ('message_search', 'Search by name', 'ru_ru', 'Поиск по названию', 15),
            ('start_shift', 'Start shift', 'ru_ru', 'Сдвиг начала', 15),
            ('end_shift', 'End shift', 'ru_ru', 'Конец сдвига', 15),
            ('today_meeting', 'Meetings', 'ru_ru', 'Встречи', 15),
            ('shift_time_track', 'Shift Time Track', 'ru_ru', 'Перемещение по времени', 15),
            ('logout_msg', 'You have to login again , click', 'ru_ru', 'You have to login again , click', 15),
            ('logout_msg1', 'to continue.', 'ru_ru', 'to continue.', 15),
            ('permission_denied', 'You don\'t have permission to create', 'ru_ru', 'У вас нет разрешения на создание', 15),
            ('history', 'Activity stream', 'ru_ru', 'История', 15),
            ('search_value', 'Search value :', 'ru_ru', 'Search value :', 15),
            ('feed_back_msg', 'Please enter feedback message', 'ru_ru', 'Пожалуйста, введите сообщение в форму обратной связи', 16),
            ('feed_back_hint_msg', 'Enter feedback message', 'ru_ru', 'Введите сообщение в форму обратной связи', 16),
            ('submit', 'Submit', 'ru_ru', 'Отправить', 16),
            ('check_app_not_installed', 'Application is not currently installed.', 'ru_ru', 'Приложение в настоящее время не установлено.', 17),
            ('send_sms_fail_message', 'SMS failed, please try again later!', 'ru_ru', 'Не удалось отправить SMS, повторите попытку позже!', 17),
            ('documentaddsuccessfully', 'Document Attach successfully', 'ru_ru', 'Документ успешно прикреплен', 17),
            ('send_message', 'Send message', 'ru_ru', 'Send message', 17),
            ('sms_to', 'smsto:', 'ru_ru', 'smsto:', 17),
            ('add_list_message', 'Add List', 'ru_ru', 'Добавить список', 18),
            ('mylist', 'My List', 'ru_ru', 'Мой список', 18),
            ('filtername', 'Filter Name', 'ru_ru', 'Название фильтра', 18),
            ('selectlist', 'Select a List', 'ru_ru', 'Выберите список *', 18),
            ('assingedto', 'Assigned To', 'ru_ru', 'Ответственный *', 18),
            ('selectmodule', 'Select a module', 'ru_ru', 'Выберите модуль', 18),
            ('add_list', 'Add Filter', 'ru_ru', 'Добавить фильтр', 18),
            ('recent_event', 'Recent Event', 'ru_ru', 'Недавние событие', 19),
            ('recent_hostory', 'Recent History', 'ru_ru', 'Недавняя история', 19),
            ('module_specific_settings', 'Module-Specific Settings', 'ru_ru', 'Настройки модуля', 19),
            ('talk_to_us', 'Talk to us', 'ru_ru', 'Поговори с нами', 19),
            ('report_a_bug', 'Report A Bug', 'ru_ru', 'Сообщить об ошибке', 19),
            ('faq', 'FAQ', 'ru_ru', 'Часто задаваемые вопросы', 19),
            ('selectmodules', 'Select Module', 'ru_ru', 'Выберите модуль', 19),
            ('myplan', 'My Plan', 'ru_ru', 'My Plan', 19),
            ('message', 'Message', 'ru_ru', 'Сообщение', 20),
            ('message_validation', 'Please enter Message', 'ru_ru', 'Пожалуйста, введите сообщение', 20),
            ('contact_select', 'Please Select contact', 'ru_ru', 'Пожалуйста, выберите контакт', 20),
            ('global_search', 'Global Search', 'ru_ru', 'Global Search', 21),
            ('records', 'Records', 'ru_ru', 'Records', 21),
            ('dont_show_again', 'Don\'t Show Again', 'ru_ru', 'Don\'t Show Again', 22),
            ('skip', 'Skip', 'ru_ru', 'Skip', 22),
            ('file_downloading', 'File Downloading', 'ru_ru', 'Загрузка файла', 23),
            ('add_screenshots_optional', 'Add screenshots (optional)', 'ru_ru', 'Добавить скриншоты (необязательно)', 24),
            ('describe_your_problem', 'Describe your problem', 'ru_ru', 'Опишите свою проблему', 24),
            ('default_filter_shortcut', 'Default Filter Shortcut', 'ru_ru', 'Default Filter Shortcut', 25),
            ('record_shortcut', 'Record Shortcut', 'ru_ru', 'Record Shortcut', 25),
            ('enter_url', 'Please Enter url', 'ru_ru', 'Please Enter url', 26),
            ('new_version_is_avaiable', 'You need to update the app to continue using Please update to continue Older versions will no longer work from today', 'ru_ru', 'You need to update the app to continue using Please update to continue Older versions will no longer work from today', 26),
            ('search_by', 'Search by', 'ru_ru', 'Search by', 27),
            ('selected_filter', 'Selected filter :', 'ru_ru', 'Выбранный фильтр :-', 27),
            ('selected_field', 'Selected field :', 'ru_ru', 'Выбранное поле :-', 27),
            ('choose', 'Choose', 'ru_ru', 'Choose', 28),
            ('qr_cardscanner', 'QR Code Scanner', 'ru_ru', 'QR Code Scanner', 28),
            ('error_message_for_scan', 'Could not read the card Try again later.', 'ru_ru', 'Could not read the card Try again later.', 28),
            ('press_start_scan', 'Press to Start Scan', 'ru_ru', 'Press to Start Scan', 28),
            ('line_item_quntity_validation_msg', 'Value should be greater than zero', 'ru_ru', 'Value should be greater than zero', 29),
            ('percentage_msg', 'Percentage should be less than 100', 'ru_ru', 'Percentage should be less than 100', 29),
            ('MSG_NO_DATA', 'No data found!', 'ru_ru', 'No data found!', 29),
            ('MSG_SOMETHING_WRONG', 'Something went wrong!', 'ru_ru', 'Something went wrong!', 29),
            ('MSG_COMING_SOON', 'Coming Soon!', 'ru_ru', 'Coming Soon!', 29),
            ('MSG_UPLOAD_PROFILE_IMAGE', 'Please upload profile image.', 'ru_ru', 'Please upload profile image.', 29),
            ('ALERT_TITLE_LOCATION_ACCESS', 'Location Access', 'ru_ru', 'Location Access', 29),
            ('ALERT_MSG_LOCATION_ACCESS', 'Requires your location to show nearby events.', 'ru_ru', 'Requires your location to show nearby events.', 29),
            ('ALERT_BTN_ALLOW', 'ALLOW', 'ru_ru', 'ALLOW', 29),
            ('ALERT_BTN_DENY', 'DENY', 'ru_ru', 'DENY', 29),
            ('ALERT_MSG_LOCATION_SETTING', 'Not able to fetch your current location. Please check your location settings.', 'ru_ru', 'Not able to fetch your current location. Please check your location settings.', 29),
            ('DELETE_RECORD', 'Delete Record', 'ru_ru', 'Delete Record', 29),
            ('ALERT_MSG_DELETE_SHORTCUT', 'Are you sure want to delete this shortcut?', 'ru_ru', 'Are you sure want to delete this shortcut?', 29),
            ('DELETE_SHORTCUT', 'Delete Shortcut', 'ru_ru', 'Delete Shortcut', 29),
            ('LBL_TERMS', 'By logging in, you agree to our Terms and', 'ru_ru', 'By logging in, you agree to our Terms and', 29),
            ('LBL_CONDITIONS', 'Conditions &', 'ru_ru', 'Conditions &', 29),
            ('ALERT_TITLE', 'Alert', 'ru_ru', 'Alert', 29),
            ('ALERT_BTN_SUBSCRIBE', 'Subscribe', 'ru_ru', 'Subscribe', 29),
            ('MSG_SELECT_MODULE', 'Please select any Module', 'ru_ru', 'Please select any Module', 29),
            ('MSG_SELECT_LIST', 'Please select any List', 'ru_ru', 'Please select any List', 29),
            ('ALERT_MSG_DONT_HAVE_CAMERA', 'You don\'t have camera', 'ru_ru', 'You don\'t have camera', 29),
            ('ALERT_MSG_GALLARY_PERMISSION', 'You don\'t have permission to access gallery.', 'ru_ru', 'You don\'t have permission to access gallery.', 29),
            ('ALERT_MSG_CAMERA_PERMISSION', 'You don\'t have permission to access camera. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Camera on', 'ru_ru', 'You don\'t have permission to access camera. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Camera on', 29),
            ('ALERT_MSG_SPEECH_PERMISSION', 'You don\'t have permission to access Speech Recognition. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Speech Recognition on', 'ru_ru', 'You don\'t have permission to access Speech Recognition. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Speech Recognition on', 29),
            ('BTN_DONE', 'Done', 'ru_ru', 'Done', 29),
            ('COMMENT', 'Comment', 'ru_ru', 'Comment', 29),
            ('FULL_FORM', 'Full Form', 'ru_ru', 'Full Form', 29),
            ('QUICK_CREATE', 'Create', 'ru_ru', 'Create', 29),
            ('LBL_SELECT_FIELDS', 'Select Fields', 'ru_ru', 'Select Fields', 29),
            ('LBL_SELECT_FIELDS', 'Select Fields', 'ru_ru', 'Select Fields', 29),
            ('LBL_SELECT_FIRST_FIELDS', 'Select First Field', 'ru_ru', 'Select First Field', 29),
            ('LBL_SELECT_SECOND_FIELDS', 'Select Second Field', 'ru_ru', 'Select Second Field', 29),
            ('LBL_SELECT_THIRD_FIELDS', 'Select Third Field', 'ru_ru', 'Select Third Field', 29),
            ('LBL_SORT_BY_FIELD', 'Select Sort By Field', 'ru_ru', 'Select Sort By Field', 29),
            ('BTN_RESET_TO_DEFAULT', 'Reset to Default', 'ru_ru', 'Reset to Default', 29),
            ('MSG_SELECT_SORT_BY_FIELD', 'Select Sort by field', 'ru_ru', 'Select Sort by field', 29),
            ('kStrClearBtnTitle', 'Clear', 'ru_ru', 'Clear', 29),
            ('kStrShowMoreBtnTitle', 'Show More', 'ru_ru', 'Show More', 29),
            ('kStrAddActivitiesBtnTitle', 'Add Activities', 'ru_ru', 'Add Activities', 29),
            ('kStrAddCommentPlaceHolder', 'Add your comments here', 'ru_ru', 'Add your comments here', 29),
            ('MSG_ENTER_TO_EMAIL', 'Please enter to field.', 'ru_ru', 'Please enter to field.', 29),
            ('WARNING_FILE', 'File can\'t open.', 'ru_ru', 'File can\'t open.', 29),
            ('MSG_FILE_SAVED', 'File saved.', 'ru_ru', 'File saved.', 29),
            ('WARNING_DOWNLOAD_FAIL', 'Download fail!, please try after sometime.', 'ru_ru', 'Download fail!, please try after sometime.', 29),
            ('LBL_SHORTCUT', 'Shortcut', 'ru_ru', 'Shortcut', 29),
            ('TXT_MESSAGE_PLACEHOLDER', 'Type Message', 'ru_ru', 'Type Message', 29),
            ('ALERT_INSTALL_WHATSAPP', 'Install Whatsapp', 'ru_ru', 'Install Whatsapp', 29),
            ('MSG_NO_MAIL_BOX', 'No MailBox found. Please Create Mailbox', 'ru_ru', 'No MailBox found. Please Create Mailbox', 29),
            ('LBL_WROTE', 'Wrote', 'ru_ru', 'Wrote', 29),
            ('MSG_MAIL_SEND', 'Mail sent', 'ru_ru', 'Mail sent', 29),
            ('log_file_not_found', 'API Log file not found.', 'ru_ru', 'API Log file not found.', 29),
            ('unknown_error', 'An unknown error occurred, try again', 'ru_ru', 'An unknown error occurred, try again', 29),
            ('CTMTigerAppVersion', 'CRMTiger App Version', 'ru_ru', 'CRMTiger App Version', 29),
            ('CTMMobileUpdateMsg', 'CTMobile Ext. Version Update Successfully', 'ru_ru', 'CTMobile Ext. Version Update Successfully', 29),
            ('dialog_Premium_downgrade', 'Downgrade will required logout and login again later', 'ru_ru', 'Downgrade will required logout and login again later', 29),
            ('dialog_Premium', 'Upgrade will required logout and login again later', 'ru_ru', 'Upgrade will required logout and login again later', 29),
            ('Overwrite', 'Overwrite', 'ru_ru', 'Overwrite', 29),
            ('MSGAddressOverwrite1', 'Overwrite the existing address with the selected', 'ru_ru', 'Overwrite the existing address with the selected', 29),
            ('MSGAddressOverwrite2', 'address details?', 'ru_ru', 'address details?', 29),
            ('UPGRADE_PLAN', 'Upgrade Plan', 'ru_ru', 'Upgrade Plan', 29),
            ('DOWNGRADE_PLAN', 'Downgrade Plan', 'ru_ru', 'Downgrade Plan', 29),
            ('UPGRADE_EXTENSION', 'Upgrade Extension', 'ru_ru', 'Upgrade Extension', 29),
            ('UPGRADE_APP', 'Upgrade App', 'ru_ru', 'Upgrade App', 29),
            ('SELECT_OPTION', 'Select Option', 'ru_ru', 'Select Option', 29),
            ('PLEASE_SELECT', 'Please select', 'ru_ru', 'Please select', 29),
            ('MSG_ACCESS_DENIED', 'You don\'t have permission for this module.', 'ru_ru', 'You don\'t have permission for this module.', 29),
            ('MSG_SELECT_RECCURING_MONTH_DAY', 'Please select reccuring day of month.', 'ru_ru', 'Please select reccuring day of month.', 29),
            ('MSG_SELECT_RECCURING_WEEK_DAY', 'Please select reccuring day of week.', 'ru_ru', 'Please select reccuring day of week.', 29),
            ('MSG_SELECT_RECCURING_DAYS', 'Please select reccuring days.', 'ru_ru', 'Please select reccuring days.', 29),
            ('Please select reccuring days.', 'Please select reccuring days.', 'ru_ru', 'Please select reccuring days.', 29),
            ('MSG_SELECT_RECCURING_END_DATE', 'Please select reccuring end date.', 'ru_ru', 'Please select reccuring end date.', 29),
            ('MSG_SELECT_RECCURING_TYPE', 'Please select reccuring type.', 'ru_ru', 'Please select reccuring type.', 29),
            ('FREQ_TIME', 'Times', 'ru_ru', 'Times', 29),
            ('REPEAT_YEARLY', 'Repeat Yearly', 'ru_ru', 'Repeat Yearly', 29),
            ('REPEAT_MONTHLY', 'Repeat Monthly', 'ru_ru', 'Repeat Monthly', 29),
            ('REPEAT_WEEKLY', 'Repeat Weekly', 'ru_ru', 'Repeat Weekly', 29),
            ('REPEAT_DAILY', 'Repeat Daily', 'ru_ru', 'Repeat Daily', 29),
            ('ACTION_TITLE', 'Action Title', 'ru_ru', 'Action Title', 29),
            ('MSG_SELECT_VALID_DATE', 'Please select valid day of month.', 'ru_ru', 'Please select valid day of month.', 29),
            ('MSG_SELECT_VALID_START_DATE', 'Start date should be less than end date.', 'ru_ru', 'Start date should be less than end date.', 29),
            ('MSG_SELECT_VALID_START_TIME', 'Start time should be less than end time.', 'ru_ru', 'Start time should be less than end time.', 29),
            ('LBL_LINEITEM_DETAILS', 'Lineitem Details', 'ru_ru', 'Lineitem Details', 29),
            ('MSG_INVALIDE_DISCOUNT_AMOUNT', 'Discount amount should be less than the total.', 'ru_ru', 'Discount amount should be less than the total.', 29),
            ('VIEW', 'View', 'ru_ru', 'View', 29),
            ('MSG_ENTER_VALID', 'Please enter valid', 'ru_ru', 'Please enter valid', 29),
            ('MSG_ENTER_PERCENTAGE', 'Percentage should be less than 100.', 'ru_ru', 'Percentage should be less than 100.', 29),
            ('ITEM_TOTAL', 'Item Total', 'ru_ru', 'Item Total', 29),
            ('ADJUSTMENT', 'Adjustment', 'ru_ru', 'Adjustment', 29),
            ('TITLE_CHOOSE_IMAGE', 'Choose Image', 'ru_ru', 'Choose Image', 29),
            ('COMPRESS', 'Compress', 'ru_ru', 'Compress', 29),
            ('CHOOSE_ANOTHER_IMAGE', 'Your image size is too large, please select another image', 'ru_ru', 'Your image size is too large, please select another image', 29),
            ('OnDayOfMonth', 'On day of month', 'ru_ru', 'On day of month', 29),
            ('OnDayOfWeek', 'On day of week', 'ru_ru', 'On day of week', 29),
            ('AddAndClose', 'Add & Close', 'ru_ru', 'Add & Close', 29),
            ('Repeat', 'Repeat', 'ru_ru', 'Repeat', 29),
            ('OnDay', 'On day', 'ru_ru', 'On day', 29),
            ('View_Line_Item', 'View Line Item', 'ru_ru', 'View Line Item', 29),
            ('TITLE_IMAGE', 'Image', 'ru_ru', 'Image', 29),
            ('TITLE_ICLOUD', 'iCloud', 'ru_ru', 'iCloud', 29),
            ('GOOGLE', 'Google', 'ru_ru', 'Google', 29),
            ('ALERT_BTN_OKAY', 'Okay', 'ru_ru', 'Okay', 29),
            ('ALERT_TITLE_ACCESS_DENIED', 'Access Denied', 'ru_ru', 'Access Denied', 29),
            ('Dont_Show_Again', 'Don\'t show again', 'ru_ru', 'Don\'t show again', 29),
            ('Skip', 'Skip', 'ru_ru', 'Skip', 29),
            ('Fillter_Name', 'Fillter Name', 'ru_ru', 'Fillter Name', 29),
            ('Fillter_Record_Count', 'Fillter Record Count', 'ru_ru', 'Fillter Record Count', 29),('url_note',  'Note : if your URL of CRM is https://example.com/crm enter that into above box',   'ru_ru',    'Note : if your URL of CRM is https://example.com/crm enter that into above box',   31),
            ('vtiger_url',  'Your vTiger CRM URL',  'ru_ru',    'Your vTiger CRM URL',  31),
            ('msg_doc_read_permission', 'You don\'t have permission to Add either This is read-only or Private Field.',  'ru_ru',    'You don\'t have permission to Add either This is read-only or Private Field.',  31),
            ('CLEAR',   'Clear',    'ru_ru',    'Clear',    31),
            ('Files/photos uploaded successfully',  'Files/photos uploaded successfully',   'ru_ru',    'Files/photos uploaded successfully',   32),
            ('Digital signature saved', 'Digital signature saved',  'ru_ru',    'Digital signature saved',  32),
            ('Please upload Signature or Files/photos', 'Please upload Signature or Files/photos',  'ru_ru',    'Please upload Signature or Files/photos',  32),
            ('Files / Photos',  'Files / Photos',   'ru_ru',    'Files / Photos',   32),
            ('Signature',   'Signature',    'ru_ru',    'Signature',    32),
            ('add_photo_using', 'Add Photo Using',  'ru_ru',    'Add Photo Using',  31),
            ('btn_upload_sign', '(+) Add Signature',    'ru_ru',    '(+) Add Signature',    31),
            ('btn_upload_photo_doc',    '(+) Upload Files/Photos',  'ru_ru',    '(+) Upload Files/Photos',  31),
            ('select_photo_doc_to_upload',  'Please select files/photos to upload', 'ru_ru',    'Please select files/photos to upload', 31),
            ('related_module_title',    'Search from related module and Add to \"Route\"',  'ru_ru',    'Search from related module and Add to \"Route\"',  30),
            ('Route status updated successfully',   'Route status updated successfully',    'ru_ru',    'Route status updated successfully',    32),
            ('Session init failed', 'Session init failed',  'ru_ru',    'Session init failed',  32),
            ('You don\'t have permission to access this resource',  'You don\'t have permission to access this resource',   'ru_ru',    'You don\'t have permission to access this resource',   32),
            ('ctroute_realtedto cannot be empty',   'Could not get the Related To - Try again later',   'ru_ru',    'Could not get the Related To - Try again later',   32),
            ('ctroute_planning cannot be empty',    'Could not get the Route Planning Record - Try again later',    'ru_ru',    'Could not get the Route Planning Record - Try again later',    32),
            ('Something went wrong - Try again later',  'Something went wrong - Try again later',   'ru_ru',    'Something went wrong - Try again later',   32),
            ('sequence updated successfully',   'sequence updated successfully',    'ru_ru',    'sequence updated successfully',    32),
            ('sequence cannot be empty',    'sequence cannot be empty', 'ru_ru',    'sequence cannot be empty', 32),
            ('Shortcut details not saved',  'Shortcut details not saved',   'ru_ru',    'Shortcut details not saved',   32),
            ('Shortcut details saved successfully', 'Shortcut details saved successfully',  'ru_ru',    'Shortcut details saved successfully',  32),
            ('Route save successfully', 'Route save successfully',  'ru_ru',    'Route save successfully',  32),
            ('Record save successfully',    'Record save successfully', 'ru_ru',    'Record save successfully', 32),
            ('No dependency found for picklist',    'No dependency found for picklist', 'ru_ru',    'No dependency found for picklist', 32),
            ('No records found',    'No records found', 'ru_ru',    'No records found', 32),
            ('Outgoing server is not enabled, please configure from CRM',   'Outgoing server is not enabled, please configure from CRM',    'ru_ru',    'Outgoing server is not enabled, please configure from CRM',    32),
            ('Removed Successfully',    'Removed Successfully', 'ru_ru',    'Removed Successfully', 32),
            ('Shortcut has been deleted',   'Shortcut has been deleted',    'ru_ru',    'Shortcut has been deleted',    32),
            ('relation of records removed successfully',    'relation of records removed successfully', 'ru_ru',    'relation of records removed successfully', 32),
            ('relation of records not removed', 'relation of records not removed',  'ru_ru',    'relation of records not removed',  32),
            ('Record has been deleted successfully',    'Record has been deleted successfully', 'ru_ru',    'Record has been deleted successfully', 32),
            ('Time Tracking saved successfully',    'Time Tracking saved successfully', 'ru_ru',    'Time Tracking saved successfully', 32),
            ('Time Tracking updated successfully',  'Time Tracking updated successfully',   'ru_ru',    'Time Tracking updated successfully',   32),
            ('Time Tracking ended successfully',    'Time Tracking ended successfully', 'ru_ru',    'Time Tracking ended successfully', 32),
            ('Time Tracking started successfully',  'Time Tracking started successfully',   'ru_ru',    'Time Tracking started successfully',   32),
            ('record cannot be empty',  'record cannot be empty',   'ru_ru',    'record cannot be empty',   32),
            ('Module is disabled',  'Module is disabled',   'ru_ru',    'Module is disabled',   32),
            ('Shift ended successfully',    'Shift ended successfully', 'ru_ru',    'Shift ended successfully', 32),
            ('Shift started successfully',  'Shift started successfully',   'ru_ru',    'Shift started successfully',   32),
            ('relation of records added successfully',  'relation of records added successfully',   'ru_ru',    'relation of records added successfully',   32),
            ('Comment saved successfully',  'Comment saved successfully',   'ru_ru',    'Comment saved successfully',   32),
            ('Comment not saved',   'Comment not saved',    'ru_ru',    'Comment not saved',    32),
            ('Comment module is not active',    'Comment module is not active', 'ru_ru',    'Comment module is not active', 32),
            ('No Upcoming Event',   'No Upcoming Event',    'ru_ru',    'No Upcoming Event',    32),
            ('No Templates found - create it from Message Templates module',    'No Templates found - create it from Message Templates module', 'ru_ru',    'No Templates found - create it from Message Templates module', 32),
            ('No event or task for this date',  'No event or task for this date',   'ru_ru',    'No event or task for this date',   32),
            ('No filters created',  'No filters created',   'ru_ru',    'No filters created',   32),
            ('Select at least one record to attach',    'Select at least one record to attach', 'ru_ru',    'Select at least one record to attach', 32),
            ('Please select one or more attachments',   'Please select one or more attachments',    'ru_ru',    'Please select one or more attachments',    32),
            ('No event for this month', 'No event for this month',  'ru_ru',    'No event for this month',  32),
            ('No Activity found',   'No Activity found',    'ru_ru',    'No Activity found',    32),
            ('Your feedback is valuable for us - it cannot be empty',   'Your feedback is valuable for us - it cannot be empty',    'ru_ru',    'Your feedback is valuable for us - it cannot be empty',    32),
            ('Could not send mail, Please try later',   'Could not send mail, Please try later',    'ru_ru',    'Could not send mail, Please try later',    32),
            ('Latest Version updated successfully', 'Latest Version updated successfully',  'ru_ru',    'Latest Version updated successfully',  32),
            ('User Location Updated Successfully',  'User Location Updated Successfully',   'ru_ru',    'User Location Updated Successfully',   32),
            ('User Location not Updated Successfully',  'User Location not Updated Successfully',   'ru_ru',    'User Location not Updated Successfully',   32),
            ('SMSNotifier is not enable in CRM. Please enable it first',    'SMSNotifier is not enable in CRM. Please enable it first', 'ru_ru',    'SMSNotifier is not enable in CRM. Please enable it first', 32),
            ('Could not submit your feedback - Please try again later', 'Could not submit your feedback - Please try again later',  'ru_ru',    'Could not submit your feedback - Please try again later',  32),
            ('Thank you for submitting your feedback',  'Thank you for submitting your feedback',   'ru_ru',    'Thank you for submitting your feedback',   32),
            ('Please upload User Image',    'Please upload User Image', 'ru_ru',    'Please upload User Image', 32),
            ('Image Not Uploading, please try again',   'Image Not Uploading, please try again',    'ru_ru',    'Image Not Uploading, please try again',    32),
            ('User Image Uploaded Successfully',    'User Image Uploaded Successfully', 'ru_ru',    'User Image Uploaded Successfully', 32),
            ('Invalid Module name', 'Invalid Module name',  'ru_ru',    'Invalid Module name',  32),
            ('Records Sync Successfully',   'Records Sync Successfully',    'ru_ru',    'Records Sync Successfully',    32),
            ('Values cannot be empty',  'Values cannot be empty',   'ru_ru',    'Values cannot be empty',   32),
            ('Record id is empty',  'Record id is empty',   'ru_ru',    'Record id is empty',   32),
            ('Logout Successfully', 'Logout Successfully',  'ru_ru',    'Logout Successfully',  32),
            ('Please Enable CTMobile Module',   'Please Enable CTMobile Module',    'ru_ru',    'Please Enable CTMobile Module',    32),
            ('Authentication Failed',   'Username and Password do not match',   'ru_ru',    'Username and Password do not match',   32),
            ('Mismatched module information',   'Something gone wrong, please try again later', 'ru_ru',    'Something gone wrong, please try again later', 32),
            ('Field does not exists',   'Please set display fields again',  'ru_ru',    'Please set display fields again',  32),
            ('Module does not exists',  'Module does not exists or disabled by admin',  'ru_ru',    'Module does not exists or disabled by admin',  32),
            ('Month cannot be empty',   'Could not get the Month - Try again later',    'ru_ru',    'Could not get the Month - Try again later',    32),
            ('Year cannot be empty',    'Could not get the Year - Try again later', 'ru_ru',    'Could not get the Year - Try again later', 32),
            ('Date cannot be empty',    'Could not get the Date - Try again later', 'ru_ru',    'Could not get the Date - Try again later', 32),
            ('Userid cannot be empty',  'Could not get the Userid - Try again later',   'ru_ru',    'Could not get the Userid - Try again later',   32),
            ('End Date cannot be empty',    'Could not get the status - Try again later',   'ru_ru',    'Could not get the status - Try again later',   32),
            ('Start Date cannot be empty',  'Could not get the Start Date - Try again later',   'ru_ru',    'Could not get the Start Date - Try again later',   32),
            ('You do not configure SMS Notifier in CRM. Please configure SMS Notifier in your CRM to use this feature', 'You do not configure SMS Notifier in CRM. Please configure SMS Notifier in your CRM to use this feature',  'ru_ru',    'You do not configure SMS Notifier in CRM. Please configure SMS Notifier in your CRM to use this feature',  32),
            ('Longitude cannot be empty',   'Could not get location-Please try again',  'ru_ru',    'Could not get location-Please try again',  32),
            ('Latitude cannot be empty',    'Could not get location-Please try again',  'ru_ru',    'Could not get location-Please try again',  32),
            ('User cannot be empty',    'Could not get the User - Try again later', 'ru_ru',    'Could not get the User - Try again later', 32),
            ('Status cannot be empty',  'Could not get the status - Try again later',   'ru_ru',    'Could not get the status - Try again later',   32),
            ('Required fields not found',   'Required fields not found',    'ru_ru',    'Required fields not found',    32),
            ('Tracking module not active',  'Tracking module not active-Please contact CRM Admin',  'ru_ru',    'Tracking module not active-Please contact CRM Admin',  32),
            ('Missing mandatory input values',  'Missing mandatory input values',   'ru_ru',    'Missing mandatory input values',   32),
            ('No MailBox found. Please Create Mailbox', 'No MailBox found. Please Create Mailbox',  'ru_ru',    'No MailBox found. Please Create Mailbox',  32),
            ('Mail not sent',   'Mail not sent',    'ru_ru',    'Mail not sent',    32),
            ('Mail send successfully',  'Mail send successfully',   'ru_ru',    'Mail send successfully',   32),
            ('Email Id or username not match with your record', 'Email Id or username not match with your record',  'ru_ru',    'Email Id or username not match with your record',  32),
            ('Module not specified',    'Module not specified', 'ru_ru',    'Module not specified', 32),
            ('No messages found',   'No messages found',    'ru_ru',    'No messages found',    32),
            ('No Dependency Found For This Module', 'No Dependency Found For This Module',  'ru_ru',    'No Dependency Found For This Module',  32),
            ('Outgoing server is not Enabled',  'Outgoing server is not Enabled',   'ru_ru',    'Outgoing server is not Enabled',   32),
            ('Outgoing server is Enabled',  'Outgoing server is Enabled',   'ru_ru',    'Outgoing server is Enabled',   32),
            ('Email Attached Successfully', 'Email Attached Successfully',  'ru_ru',    'Email Attached Successfully',  32),
            ('Documents Attached Successfully', 'Documents Attached Successfully',  'ru_ru',    'Documents Attached Successfully',  32),
            ('Login required - Please login again', 'Login required - Please login again',  'ru_ru',    'Login required - Please login again',  32),
            ('time_tracking_module_disable',    'Time tracking module is disable',  'ru_ru',    'Time tracking module is disable',  31),
            ('route_planning_module_disable',   'Route planning module is disable', 'ru_ru',    'Route planning module is disable', 31),
            ('mark_as_held',    'Are you sure you want to mark Event as Held?', 'ru_ru',    'Are you sure you want to mark Event as Held?', 31),
            ('stop_timer_msg',  'You have already started Time tracking for another record, Do you want to stop it first ?',    'ru_ru',    'You have already started Time tracking for another record, Do you want to stop it first ?',    31),
            ('access_denied_routeplanning', 'Access denied for route planning', 'ru_ru',    'Access denied for route planning', 31),
            ('time_spent',  'Time Spent',   'ru_ru',    'Time Spent',   31),
            ('select_user', 'Select User',  'ru_ru',    'Select User',  30),
            ('status_cannot_be_held',   'Status cannot be held for future date start',  'ru_ru',    'Status cannot be held for future date start',  30),
            ('please_select_end_date',  'Please select end date',   'ru_ru',    'Please select end date',   30),
            ('please_select_start_date',    'Please select start date', 'ru_ru',    'Please select start date', 30),
            ('tap_on_plus_icon_for_select_route',   'Tap on + icon to select record for your route.',   'ru_ru',    'Tap on + icon to select record for your route.',   30),
            ('please_enter_notes',  'Please enter notes',   'ru_ru',    'Please enter notes',   30),
            ('please_enter_title',  'Please enter title',   'ru_ru',    'Please enter title',   30),
            ('please_select_date',  'Please Select Date',   'ru_ru',    'Please Select Date',   30),
            ('search_by_date',  'Search by Date',   'ru_ru',    'Search by Date',   30),
            ('shortcut_not_setup_yet',  'Opps shortcut not setup yet!!! Please add shortcut by click on [icon] from record search results or view record screen.',  'ru_ru',    'Opps shortcut not setup yet!!! Please add shortcut by click on [icon] from record search results or view record screen.',  30),
            ('max_upload_size', 'max file Upload exceeds',  'ru_ru',    'max file Upload exceeds',  30),
            ('unselect_all',    'UnSelect All', 'ru_ru',    'UnSelect All', 30),
            ('select_all',  'Select All',   'ru_ru',    'Select All',   30),
            ('please_select_records',   'Please select records',    'ru_ru',    'Please select records',    30),
            ('select_date', 'Select Date',  'ru_ru',    'Select Date',  30),
            ('quantity_in_stock_is',    'Quantity in stock is', 'ru_ru',    'Quantity in stock is', 30),
            ('replies', 'Replies',  'ru_ru',    'Replies',  30),
            ('conversation_require_selection',  'Conversion requires selection of Contact or Organization', 'ru_ru',    'Conversion requires selection of Contact or Organization', 30),
            ('please_select_product',   'Please Select Product',    'ru_ru',    'Please Select Product',    30),
            ('timer_msg',   'You can start timer for single task only at same time',    'ru_ru',    'You can start timer for single task only at same time',    31),
            ('save_start_tracking', 'Save & Start Tracking',    'ru_ru',    'Save & Start Tracking',    31),
            ('lbl_notes',   'Notes',    'ru_ru',    'Notes',    31),
            ('enter_title', 'Enter Title',  'ru_ru',    'Enter Title',  31),
            ('select_module_record',    'Select Module / Record',   'ru_ru',    'Select Module / Record',   31),
            ('lbl_tomorrow',    'Tomorrow', 'ru_ru',    'Tomorrow', 30),
            ('lbl_yesterday',   'Yesterday',    'ru_ru',    'Yesterday',    30),
            ('lbl_today',   'Today',    'ru_ru',    'Today',    30),
            ('time_tracker',    'Time Tracker', 'ru_ru',    'Time Tracker', 31),
            ('time_end',    'End Time', 'ru_ru',    'End Time', 5),
            ('due_date',    'End Date', 'ru_ru',    'End Date', 5),
            ('time_start',  'Time Start',   'ru_ru',    'Time Start',   5),
            ('date_start',  'Start Date',   'ru_ru',    'Start Date',   5),
            ('delete_widget_msg',   'Display widget again by using (+) option', 'ru_ru',    'Display widget again by using (+) option', 15),
            ('no_upcoming_activities',  'No scheduled activities    ',  'ru_ru',    'No scheduled activities    ',  15),
            ('check_in_first',  'Please check-in first',    'ru_ru',    'Please check-in first',    30),
            ('duration',    'Duration', 'ru_ru',    'Duration', 30),
            ('distance',    'Distance', 'ru_ru',    'Distance', 30),
            ('proper_address_message',  'Please enter proper address in record\n',  'ru_ru',    'Please enter proper address in record',    30),
            ('select_status',   'Select Status',    'ru_ru',    'Select Status',    30),
            ('route_planner',   'Route Planner',    'ru_ru',    'Route Planner',    30),
            ('route_planning',  'Route Planning',   'ru_ru',    'Route Planning',   30),
            ('add_route',   'Add Route',    'ru_ru',    'Add Route',    30),
            ('calender_disabled',   'Calendar Module is disabled',  'ru_ru',    'Calendar Module is disabled',  30),
            ('close_dialog',    'Close form',   'ru_ru',    'Close form',   30),
            ('cancel_form_message', 'Are You sure want to close ?', 'ru_ru',    'Are You sure want to close ?', 30),
            ('create_route',    'Create Route', 'ru_ru',    'Create Route', 30),
            ('select_module_create_route',  'Select Module to create Route',    'ru_ru',    'Select Module to create Route',    30),
            ('cancel',  'Cancel',   'ru_ru',    'Отменить',   30),
            ('assign_route',    'Assign Route', 'ru_ru',    'Assign Route', 30),
            ('route_for',   'Route for',    'ru_ru',    'Route for',    30),
            ('assigned_to', 'Assigned To',  'ru_ru',    'Assigned To',  30),
            ('enter_route_name',    'Enter Route Name', 'ru_ru',    'Enter Route Name', 30),
            ('list',    'List', 'ru_ru',    'List', 30),
            ('map', 'Map',  'ru_ru',    'Map',  30),
            ('other_modules',   'Other Modules',    'ru_ru',    'Other Modules',    15),
            ('shortcut_no_record_msg',  'Opps shortcut not setup\n yet!!! Please add shortcut  by click on + icon from record\n search results or view record screen.', 'ru_ru',    'Opps shortcut not setup\n yet!!! Please add shortcut  by click on + icon from record\n search results or view record screen.', 25),
            ('clear',   'Clear',    'ru_ru',    'Clear',    25),
            ('open',    'Open', 'ru_ru',    'Open', 11),
            ('max_file_msg',    'Too many files selected (max:6)',  'ru_ru',    'Too many files selected (max:6)',  11),
            ('error_voicenote_record',  'Unable to recording voice while another application is recording sound.',  'ru_ru',    'Unable to recording voice while another application is recording sound.',  11),
            ('msg_warning', 'Warning!', 'ru_ru',    'Warning!', 11),
            ('Permision_denied_contact',    'Permission denied to access your contacts',    'ru_ru',    'Permission denied to access your contacts',    15),
            ('no_widget_added', 'Please click + icon to add new widget to your dashboard.', 'ru_ru',    'Please click + icon to add new widget to your dashboard.', 15),
            ('no_data_available',   'Data not available, please check the selected fields', 'ru_ru',    'Data not available, please check the selected fields', 15),
            ('check_out_successfully',  'Check out successfully',   'ru_ru',    'Checked out successfully', 11),
            ('check_in_successfully',   'Check in successfully',    'ru_ru',    'Checked in successfully',  11),
            ('check_out',   'Check out',    'ru_ru',    'Check out',    11),
            ('check_in',    'Check in', 'ru_ru',    'Check in', 11),
            ('navigate',    'Navigate', 'ru_ru',    'Navigate', 11),
            ('save_to_phone_vcard_success', 'VCard Saved to phone successfully',    'ru_ru',    'VCard Saved to phone successfully',    15),
            ('download_vcard_success',  'VCard downloaded successfully',    'ru_ru',    'VCard downloaded successfully',    15),
            ('card_details',    'Card Details', 'ru_ru',    'Card Details', 15),
            ('add_widget',  'Add Widget',   'ru_ru',    'Add Widget',   15),
            ('delete_widget',   'Are you sure to hide widget?', 'ru_ru',    'Are you sure to hide widget?', 15),
            ('already_widgets_added',   'All types of Widget & reports are already added',  'ru_ru',    'All types of Widget & reports are already added',  15),
            ('retry',   'Retry',    'ru_ru',    'Retry',    28),
            ('retake',  'Retake',   'ru_ru',    'Retake',   28),
            ('Reports', 'Reports',  'ru_ru',    'Reports',  15),
            ('Widgets', 'Widgets',  'ru_ru',    'Widgets',  15),
            ('vcard_config',    'Vcard Configuration',  'ru_ru',    'Vcard Configuration',  8),
            ('save_to_phone',   'Save to phone',    'ru_ru',    'Save to phone',    11),
            ('download_vcard',  'Download Vcard',   'ru_ru',    'Download Vcard',   11),
            ('share_vcard', 'Share Vcard',  'ru_ru',    'Share Vcard',  11),
            ('share_record',    'Share Record', 'ru_ru',    'Share Record', 11),
            ('permission_denied_edit',  'You don\'t have permission to edit this record.',  'ru_ru',    'You don\'t have permission to edit this record.',  27),
            ('permission_denied_delete',    'You don\'t have permission to delete this record.',    'ru_ru',    'You don\'t have permission to delete this record.',    27),
            ('Voice_Recording_Started', 'Recording Started',    'ru_ru',    'Recording Started',    12),
            ('Voice_Recording_Stopped', 'Recording Stopped',    'ru_ru',    'Recording Stopped',    12),
            ('SEARCH',  'Search',   'ru_ru',    'Search',   7),
            ('LAST',    'Last', 'ru_ru',    'Last', 7),
            ('FIRST',   'First',    'ru_ru',    'First',    7),
            ('MONDAY',  'Monday',   'ru_ru',    'Monday',   7),
            ('TUESDAY', 'Tuesday',  'ru_ru',    'Tuesday',  7),
            ('WEDNESDAY',   'Wednesday',    'ru_ru',    'Wednesday',    7),
            ('THURSDAY',    'Thursday', 'ru_ru',    'Thursday', 7),
            ('FRIDAY',  'Friday',   'ru_ru',    'Friday',   7),
            ('SATURDAY',    'Saturday', 'ru_ru',    'Saturday', 7),
            ('SUNDAY',  'Sunday',   'ru_ru',    'Sunday',   7),
            ('DAILY',   'Daily',    'ru_ru',    'Daily',    7),
            ('WEEKLY',  'Weekly',   'ru_ru',    'Weekly',   7),
            ('MONTHLY', 'Monthly',  'ru_ru',    'Monthly',  7),
            ('YEARLY',  'Yearly',   'ru_ru',    'Yearly',   7),
            ('asset_tracking',  'Asset tracking',   'ru_ru',    'Asset tracking',   15);",array());
    }

    static function de_de(){
        global $adb;
        $checkQuery = "DELETE FROM ctmobile_language_keyword WHERE keyword_lang = ?";
        $checkResult = $adb->pquery($checkQuery,array('de_de'));
        
        $adb->pquery("INSERT INTO `ctmobile_language_keyword` (`keyword`, `keyword_name`, `keyword_lang`, `language_keyword`, `sectionid`) VALUES
            ('network_error', 'Network connection error!', 'de_de', 'Netzwerkfehler!', 1),
            ('connection_check', 'Could not connect to CRM, Please check your Internet connection.', 'de_de', 'Bitte überprüfe deine Internetverbindung.', 1),
            ('update', 'Update', 'de_de', 'Update', 1),
            ('cancel', 'Cancel', 'de_de', 'Cancel', 1),
            ('ok', 'Ok', 'de_de', 'Ok', 1),
            ('more_information', 'Click here for more information.', 'de_de', 'Klicken Sie hier für weitere Informationen.', 1),
            ('yes', 'Yes', 'de_de', 'Ja', 1),
            ('no', 'No', 'de_de', 'Nein', 1),
            ('click_again_exit', 'Click again to exit', 'de_de', 'Klicken Sie erneut, um den Vorgang zu beenden', 1),
            ('forpermission', 'You don\'t have permission to view this feature. Please subscribe for Premium version Click here to Subscribe.', 'de_de', 'Sie haben keine Berechtigung, diese Funktion anzuzeigen. Bitte abonnieren Sie die Premium-Version. Klicken Sie hier, um sich anzumelden.', 1),
            ('clickhere', 'Click here', 'de_de', 'Klick hier', 1),
            ('clickhere_subscribe', 'Click here to subscribe premium version', 'de_de', 'Klicken Sie hier, um sich anzumelden', 1),
            ('clickhere_configure', 'Click here and view how to Configure.', 'de_de', 'Klicken Sie hier und sehen Sie, wie Sie konfigurieren.', 1),
            ('please_wait', 'Please Wait…', 'de_de', 'Warten Sie mal…', 1),
            ('share__msg', 'Share file with', 'de_de', 'Datei teilen mit', 1),
            ('dialog_camera', 'Camera', 'de_de', 'Kamera', 1),
            ('dialog_add_file_by', 'Take Photo from', 'de_de', 'Dateien hinzufügen von', 1),
            ('add', 'Add', 'de_de', 'Hinzufügen', 1),
            ('mail_manager_configured', 'Mail Manager is not configured', 'de_de', 'Mail Manager ist nicht konfiguriert', 1),
            ('dialog_add_files_by', 'Add Files by', 'de_de', 'Dateien hinzufügen von', 1),
            ('dialog_drive', 'Drive', 'de_de', 'Fahrt', 1),
            ('dialog_drop_box', 'Drop Box', 'de_de', 'Drop Box', 1),
            ('dialog_need_signin', 'You need to Sign-in to your Drive account first.', 'de_de', 'Sie müssen sich zuerst anmelden', 1),
            ('dialog_gallery', 'Gallery', 'de_de', 'Galerie', 1),
            ('delete', 'Delete', 'de_de', 'Löschen', 1),
            ('timeoutmessage', 'Oops! Request is taking more time than expected.', 'de_de', 'Hoppla, die Anfrage dauert länger als erwartet.', 1),
            ('gps_location_message', 'GPS is not enabled. Please turn it on to get your near by locations.', 'de_de', 'GPS ist nicht aktiviert. Bitte schalten Sie es ein, um in Ihre Nähe zu gelangen.', 1),
            ('sure_want_delete', 'Are you sure want to delete ?', 'de_de', 'Möchten Sie wirklich löschen?', 1),
            ('select', 'Select', 'de_de', 'Wählen', 1),
            ('msgforrecordaudio', 'Minimum record duration one second.', 'de_de', 'Minimum record duration one second.', 1),
            ('permission_storage', 'Permission denied to read your External storage', 'de_de', 'Die Berechtigung zum Lesen Ihres externen Speichers wurde verweigert', 1),
            ('send_permission_msg', 'Send message permission denied', 'de_de', 'Berechtigung zum Senden von Nachrichten verweigert', 1),
            ('choosefile', 'Choose File', 'de_de', 'Datei wählen', 1),
            ('enter', 'Enter', 'de_de', 'Eingeben', 1),
            ('select_an_option', 'Select an Option', 'de_de', 'Select an Option', 1),
            ('email_validation', 'Email is not valid', 'de_de', 'Email ist ungültig', 1),
            ('please_enter', 'Please Enter', 'de_de', 'Bitte eintreten', 1),
            ('website_validation_text', 'Website URL is not valid', 'de_de', 'Die URL der Website ist ungültig', 1),
            ('selectvalue', 'Select value first', 'de_de', 'Wählen Sie zuerst einen Wert aus', 1),
            ('email', 'Email', 'de_de', 'Email', 1),
            ('enter_email_address', 'Enter email address', 'de_de', 'E-Mail Adresse eingeben', 1),
            ('email_address_not_correct', 'Email address incorrect', 'de_de', 'E-Mail-Adresse falsch', 1),
            ('pls_enter_subject', 'Please Enter Subject', 'de_de', 'Bitte geben Sie einen Betreff ein', 1),
            ('attachFiles', 'Attached File', 'de_de', 'Angehängte Datei', 1),
            ('from', 'From', 'de_de', 'Von', 1),
            ('to', 'To', 'de_de', 'Zu', 1),
            ('call_permission_msg', 'Call permission denied', 'de_de', 'Anruferlaubnis verweigert', 1),
            ('no_records', 'No records found', 'de_de', 'Keine Aufzeichnungen gefunden', 1),
            ('fullform', 'Create New', 'de_de', 'Vollständige Form', 1),
            ('save', 'Save', 'de_de', 'sparen', 1),
            ('total', 'Total', 'de_de', 'Gesamt', 1),
            ('discount', 'Discount', 'de_de', 'Rabatt', 1),
            ('price', 'Price', 'de_de', 'Preis *', 1),
            ('quantity', 'Quantity', 'de_de', 'Menge *', 1),
            ('select_module', 'Select Module', 'de_de', 'Modul auswählen', 1),
            ('item_list', 'Item List', 'de_de', 'Artikelliste', 1),
            ('quickcreate', 'Quick Create', 'de_de', 'Schnell erstellen', 1),
            ('overwrite_msg_part1', 'Overwrite the existing address with the selected', 'de_de', 'Overwrite the existing address with the selected', 1),
            ('once_in_every', 'Once in every', 'de_de', 'Einmal in jedem', 1),
            ('overwrite_msg_part2', 'address details?', 'de_de', 'address details?', 1),
            ('add_item', 'Add Item', 'de_de', 'Artikel hinzufügen', 1),
            ('recordsave', 'Record saved successfully', 'de_de', 'Aufzeichnung erfolgreich gespeichert', 1),
            ('recordnotsave', 'Could not save record. Try again later', 'de_de', 'Aufzeichnung nicht speichern', 1),
            ('minutes', 'Minutes', 'de_de', 'Protokoll', 1),
            ('hours', 'Hours', 'de_de', 'Std', 1),
            ('days', 'Days', 'de_de', 'Tage', 1),
            ('on', 'On', 'de_de', 'Auf', 1),
            ('day_of_the_month', 'day of the month', 'de_de', 'Tag des Monats', 1),
            ('list_price', 'List Price', 'de_de', 'Listenpreis *', 1),
            ('add_record', 'Add Record', 'de_de', 'Datensatz hinzufügen', 1),
            ('add_product', 'Add Product', 'de_de', 'Produkt hinzufügen', 1),
            ('add_service', 'Add Service', 'de_de', 'Dienst hinzufügen', 1),
            ('discountin', 'Discount in %', 'de_de', 'Rabatt in%', 1),
            ('unitprice', 'Unit price', 'de_de', 'Stückpreis *', 1),
            ('netprice', 'Net price', 'de_de', 'Nettopreis *', 1),
            ('comments', 'Comments', 'de_de', 'Bemerkungen', 1),
            ('add_close', 'Add & Close', 'de_de', 'Hinzufügen &amp; Schließen', 1),
            ('fetching_rout_message', 'Fetching route, Please wait…', 'de_de', 'Route wird abgerufen, bitte warten ...', 1),
            ('setting', 'Settings', 'de_de', 'die Einstellungen', 1),
            ('utc', 'UTC', 'de_de', 'koordinierte Weltzeit', 1),
            ('in', 'In', 'de_de', 'Im', 1),
            ('days_ago', 'days ago', 'de_de', 'Vor Tagen', 1),
            ('mins_ago', 'Minutes ago', 'de_de', 'vor Minuten', 1),
            ('justnow', 'Just now', 'de_de', 'Gerade jetzt', 1),
            ('hours_ago', 'hours ago', 'de_de', 'Vor Stunden', 1),
            ('in_1_day', 'In 1 day', 'de_de', 'In 1 Tag', 1),
            ('scanqrcode', 'Asset / Card scanner', 'de_de', 'QR-Kartenscanner', 1),
            ('call_log', 'Call Log', 'de_de', 'Anrufliste', 1),
            ('voice_message', 'Hi', 'de_de', 'Hi', 1),
            ('voice_message1', 'What can I search for you in', 'de_de', 'What can I search for you in', 1),
            ('live_tracking', 'Live Tracking', 'de_de', 'Live-Tracking', 1),
            ('mailmanager', 'Mail Manager', 'de_de', 'Mail-Manager', 1),
            ('my_location', 'My location', 'de_de', 'Mein Standort', 1),
            ('created_on', 'Created On', 'de_de', 'Erstellt am', 1),
            ('modified_on', 'Modified On', 'de_de', 'Geändert am', 1),
            ('enter_comments', 'Enter Comments', 'de_de', 'Geben Sie Kommentare ein', 1),
            ('viewmore', 'View More', 'de_de', 'Mehr sehen', 1),
            ('viewless', 'View Less', 'de_de', 'Weniger anzeigen', 1),
            ('gotofullform', 'Go to Full Form', 'de_de', 'Gehe zum vollständigen Formular', 1),
            ('post', 'Post', 'de_de', 'Post', 1),
            ('url', 'URL', 'de_de', 'URL', 1),
            ('dialog_title_text_back_color', 'Select a Text Background Color', 'de_de', 'Wählen Sie eine Texthintergrundfarbe', 1),
            ('event_or_task', 'Add event/task', 'de_de', 'Ereignis / Aufgabe hinzufügen', 1),
            ('shortcut', 'Shortcuts', 'de_de', 'Verknüpfungen', 1),
            ('select_field', 'Select Field', 'de_de', 'Feld auswählen', 1),
            ('share', 'Share', 'de_de', 'Aktie', 1),
            ('title_insert_link', 'Insert Link', 'de_de', 'Link einfügen', 1),
            ('addyourcommentshere', 'Add your comments here', 'de_de', 'Fügen Sie hier Ihre Kommentare hinzu', 1),
            ('nocomment', 'No Comments', 'de_de', 'Keine Kommentare', 1),
            ('leads', 'Leads', 'de_de', 'Führt', 1),
            ('true_val', 'true', 'de_de', 'wahr', 1),
            ('noresult', 'No Result', 'de_de', 'Kein Ergebnis', 1),
            ('version', 'Version', 'de_de', 'Ausführung', 1),
            ('convert_lead', 'Convert Lead', 'de_de', 'Convert Lead', 1),
            ('app_name', 'CRMTiger', 'de_de', 'CRMTiger', 1),
            ('enter_url', 'Please Enter url', 'de_de', 'Bitte geben Sie die URL ein', 1),
            ('help', 'Help', 'de_de', 'Hilfe', 1),
            ('contact_us', 'Contact Us', 'de_de', 'Kontaktiere uns', 1),
            ('updates', 'Updates', 'de_de', 'Aktualisierung', 1),
            ('logout', 'LogOut', 'de_de', 'Ausloggen', 1),
            ('busnies_cardscanner', 'Business Card Scanner', 'de_de', 'Business Card Scanner', 1),
            ('sure_want_logout', 'Are you sure want to logout ?', 'de_de', 'Möchten Sie sich wirklich abmelden?', 1),
            ('logout_message', 'Logout successfully', 'de_de', 'Möchten Sie sich wirklich abmelden?', 1),
            ('all', 'All', 'de_de', 'Alles', 1),
            ('add_event', 'Add event', 'de_de', 'Ereignis hinzufügen', 1),
            ('add_task', 'Add Task', 'de_de', 'Aufgabe hinzufügen', 1),
            ('next', 'Next', 'de_de', 'Next', 1),
            ('terms_conditions', 'Terms and Conditions', 'de_de', 'Terms and Conditions', 1),
            ('login', 'Login', 'de_de', 'Anmeldung', 2),
            ('privacy_policay', 'By logging in, you agree to our Terms and Conditions & Privacy Policy', 'de_de', 'Mit Ihrer Anmeldung stimmen Sie unseren Allgemeinen Geschäftsbedingungen zu &amp; Datenschutz-Bestimmungen', 2),
            ('copyright', 'Copyright © 2020 CRMTiger Version', 'de_de', 'Urheberrechte © \u00A9 2019 CRMTiger \n Ausführung', 2),
            ('enter_username', 'Please enter username', 'de_de', 'Bitte geben sie einen Benutzernamen ein', 2),
            ('enter_password', 'Please enter password', 'de_de', 'Bitte Passwort eingeben', 2),
            ('remanberme', 'Remember Me', 'de_de', 'Erinnere dich an mich', 2),
            ('forgot_password', 'Forgot password?', 'de_de', 'Passwort vergessen?', 2),
            ('privacy_policay1', 'Privacy Policy', 'de_de', 'Datenschutz-Bestimmungen', 2),
            ('contactsupportmsg', 'Something went wrong. \\n please Click here to contact support.', 'de_de', 'Something went wrong. \\n please Click here to contact support.', 2),
            ('enter_username_password', 'Entered Username or Password is wrong', 'de_de', 'Eingegebener Benutzername oder Passwort ist falsch', 2),
            ('server_issue_occured', 'Server issues occurred', 'de_de', 'Server issues occurred', 2),
            ('password', 'Password', 'de_de', 'Passwort', 3),
            ('user_name', 'Username', 'de_de', 'Nutzername', 3),
            ('reset_pwd', 'Reset Password', 'de_de', 'Passwort zurücksetzen', 3),
            ('forgot_password_title', 'Forgot password', 'de_de', 'Passwort vergessen', 3),
            ('enter_user_name', 'Enter user name', 'de_de', 'Benutzernamen eingeben', 3),
            ('cc', 'Cc', 'de_de', 'Cc', 4),
            ('body', 'Body', 'de_de', 'Karosserie', 4),
            ('bcc', 'BCC', 'de_de', 'BCC', 4),
            ('dialog_title_text_color', 'Select a Text Color', 'de_de', 'Wählen Sie eine Textfarbe', 4),
            ('date', 'Date', 'de_de', 'Datum', 4),
            ('subject', 'Subject', 'de_de', 'Gegenstand', 4),
            ('composeMail', 'Compose Mail', 'de_de', 'Mail schreiben', 4),
            ('send', 'Send', 'de_de', 'Senden', 4),
            ('select_message', 'Select message', 'de_de', 'Nachricht auswählen', 4),
            ('title_insert_table', 'Insert Table', 'de_de', 'Tabelle einfügen', 4),
            ('log_file_sms', 'I agree to Share API Log to Technical team for further troubleshooting', 'de_de', 'Ich bin damit einverstanden, das API-Protokoll an das technische Team zur weiteren Fehlerbehebung weiterzuleiten', 5),
            ('edit_record', 'Edit Records', 'de_de', 'Datensätze bearbeiten', 5),
            ('select_time', 'Select Time', 'de_de', 'Zeit auswählen', 5),
            ('edit_item', 'Edit Item', 'de_de', 'Element bearbeiten', 5),
            ('items_total', 'Items Total', 'de_de', 'Artikel insgesamt', 5),
            ('number_less_then_31', 'Number should be less than 31', 'de_de', 'Die Anzahl sollte kleiner als 31 sein', 5),
            ('users', 'Users', 'de_de', 'Benutzer', 5),
            ('groups', 'Groups', 'de_de', 'Gruppen', 5),
            ('txt_note_for_file', 'Note : Existing attachments(images/files) will be replaced', 'de_de', 'Hinweis: Vorhandene Anhänge (Bilder / Dateien) werden ersetzt', 5),
            ('greaterdatetime', 'End DateTime should be greater than Start DateTime', 'de_de', 'End DateTime should be greater than Start DateTime', 5),
            ('until', 'Until', 'de_de', 'Bis um', 5),
            ('organizations', 'Organizations', 'de_de', 'Organisationen', 6),
            ('contacts', 'Contacts', 'de_de', 'Kontakte', 6),
            ('opportunity', 'Opportunity', 'de_de', 'Gelegenheit', 6),
            ('lbl_sun', 'SUN', 'de_de', 'SONNE', 7),
            ('lbl_mon', 'MON', 'de_de', 'MON', 7),
            ('lbl_tue', 'TUE', 'de_de', 'DI', 7),
            ('lbl_wed', 'WED', 'de_de', 'HEIRATEN', 7),
            ('lbl_thu', 'THU', 'de_de', 'DO', 7),
            ('lbl_fri', 'FRI', 'de_de', 'FRI', 7),
            ('lbl_sat', 'SAT', 'de_de', 'SAT', 7),
            ('lbl_1', '1', 'de_de', '1', 7),
            ('lbl_2', '2', 'de_de', '2', 7),
            ('lbl_3', '3', 'de_de', '3', 7),
            ('lbl_4', '4', 'de_de', '4', 7),
            ('lbl_5', '5', 'de_de', '5', 7),
            ('lbl_6', '6', 'de_de', '6', 7),
            ('lbl_7', '7', 'de_de', '7', 7),
            ('lbl_8', '8', 'de_de', '8', 7),
            ('lbl_9', '9', 'de_de', '9', 7),
            ('lbl_10', '10', 'de_de', '10', 7),
            ('lbl_11', '11', 'de_de', '11', 7),
            ('lbl_12', '12', 'de_de', '12', 7),
            ('lbl_13', '13', 'de_de', '13', 7),
            ('lbl_14', '14', 'de_de', '14', 7),
            ('lbl_15', '15', 'de_de', '15', 7),
            ('lbl_16', '16', 'de_de', '16', 7),
            ('lbl_17', '17', 'de_de', '17', 7),
            ('lbl_18', '18', 'de_de', '18', 7),
            ('lbl_19', '19', 'de_de', '19', 7),
            ('lbl_20', '20', 'de_de', '20', 7),
            ('lbl_21', '21', 'de_de', '21', 7),
            ('lbl_22', '22', 'de_de', '22', 7),
            ('lbl_23', '23', 'de_de', '23', 7),
            ('lbl_24', '24', 'de_de', '24', 7),
            ('lbl_25', '25', 'de_de', '25', 7),
            ('lbl_26', '26', 'de_de', '26', 7),
            ('lbl_27', '27', 'de_de', '27', 7),
            ('lbl_28', '28', 'de_de', '28', 7),
            ('lbl_29', '29', 'de_de', '29', 7),
            ('lbl_30', '30', 'de_de', '30', 7),
            ('lbl_31', '31', 'de_de', '31', 7),
            ('lbl_32', '32', 'de_de', '32', 7),
            ('lbl_33', '33', 'de_de', '33', 7),
            ('lbl_34', '34', 'de_de', '34', 7),
            ('lbl_35', '35', 'de_de', '35', 7),
            ('lbl_36', '36', 'de_de', '36', 7),
            ('lbl_37', '37', 'de_de', '37', 7),
            ('lbl_38', '38', 'de_de', '38', 7),
            ('lbl_39', '39', 'de_de', '39', 7),
            ('lbl_40', '40', 'de_de', '40', 7),
            ('lbl_41', '41', 'de_de', '41', 7),
            ('lbl_42', '42', 'de_de', '42', 7),
            ('current_date', 'current date', 'de_de', 'aktuelles Datum', 7),
            ('event', 'Events', 'de_de', 'Veranstaltungen', 7),
            ('calendar', 'Calendar', 'de_de', 'Kalender', 7),
            ('latest_version', 'Latest Version :', 'de_de', 'Letzte Version : ', 8),
            ('expire_on', 'Next renewal date : ', 'de_de', 'Verfällt am :', 8),
            ('ctmobile_ext_version', 'CTMobile Ext. Version : ', 'de_de', 'CTMobile ext. Ausführung :', 8),
            ('you_have_latest_version', 'You already have latest version', 'de_de', 'Sie haben die Version aktualisiert ', 8),
            ('latest_version1', 'You Already have latest version', 'de_de', 'Sie haben bereits die neueste Version', 8),
            ('upgreaded', 'Upgrade', 'de_de', 'Aktualisierung', 8),
            ('downgrade', 'Downgrade', 'de_de', 'Downgrade', 8),
            ('dialog_recent_event_info', 'You can set from here how many number of records you want to show on Home screen for Recent Event.', 'de_de', 'Hier können Sie festlegen, wie viele Datensätze auf dem Startbildschirm für das letzte Ereignis angezeigt werden sollen.', 8),
            ('dialog_feedback_info', 'You can submit your feedback with description , our team will check your feedback and get back to you.', 'de_de', 'Sie können Ihr Feedback mit einer Beschreibung einreichen. Unser Team prüft Ihr Feedback und meldet sich bei Ihnen.', 8),
            ('dialog_log_info', 'Log functionality is used for customer support / help , If you are facing any issues in app or any module or functionality is not working proper then you can enable share log with our development team.', 'de_de', 'Die Protokollfunktion wird für die Kundenunterstützung / -hilfe verwendet. Wenn Probleme in der App auftreten oder ein Modul oder eine Funktion nicht ordnungsgemäß funktioniert, können Sie die Freigabe des Protokolls für unser Entwicklungsteam aktivieren.', 8),
            ('info', 'Info', 'de_de', 'Info', 8),
            ('recent_history', 'Recent History', 'de_de', 'Jüngste Geschichte', 8),
            ('recent_feedback', 'Feedback', 'de_de', 'Feedback', 8),
            ('recent_log', 'Log', 'de_de', 'Log', 8),
            ('crmtiger_app_version', 'CRMTiger App Version : ', 'de_de', 'CRMTiger App Version: ', 8),
            ('historylimit', 'Recent History Limit', 'de_de', 'Jüngste Historienbegrenzung', 8),
            ('radious_in_miles', 'Radius in miles', 'de_de', 'Radius in Meilen', 8),
            ('recentlimit', 'Recent Event Limit', 'de_de', 'Letzte Ereignisbegrenzung', 8),
            ('upcoming_events', 'Upcoming Events', 'de_de', 'Kommende Veranstaltungen', 8),
            ('rate_our_app', 'Rate Our App!', 'de_de', 'Bewerten Sie unsere App!', 8),
            ('feedback', 'Submit Feedback', 'de_de', 'Feedback senden', 8),
            ('sendfeedback', 'Feedback Send', 'de_de', 'Feedback senden', 8),
            ('emaillimit', 'Email limit', 'de_de', 'E-Mail-Limit', 8),
            ('log', 'Log', 'de_de', 'Log', 8),
            ('logclear', 'Log cleared successfully.', 'de_de', 'Klar erfolgreich', 8),
            ('dialog_recent_history_info', 'You can set from here how many number of records you want to show on Home screen for Recent History.', 'de_de', 'Hier können Sie festlegen, wie viele Datensätze im Startbildschirm für den Verlauf der letzten Zeit angezeigt werden sollen.', 8),
            ('proceed_to_upgrade1', 'Proceed to', 'de_de', 'Proceed to', 8),
            ('upgradation_message', 'will required logout and login again later.', 'de_de', 'will required logout and login again later.', 8),
            ('proceed_to_upgrade', 'Proceed to Upgrade', 'de_de', 'Proceed to Upgrade', 8),
            ('module_setting', 'Module Setting', 'de_de', 'Moduleinstellung ', 9),
            ('sortbyfield', 'Sort by field', 'de_de', 'Nach Feld sortieren', 9),
            ('ascending', 'Ascending  A to Z', 'de_de', 'Aufsteigend von A bis Z.', 9),
            ('descending', 'Descending  Z to A', 'de_de', 'Absteigend von Z nach A', 9),
            ('first_field', 'First Field', 'de_de', 'Erstes Feld', 9),
            ('second_field', 'Second Field', 'de_de', 'Zweites Feld', 9),
            ('third_field', 'Third Field', 'de_de', 'Drittes Feld', 9),
            ('sure_want_restore', 'Are you sure you want to reset to default settings?', 'de_de', 'Möchten Sie die Standardeinstellungen wirklich wiederherstellen?', 9),
            ('orderlist', 'List Order', 'de_de', 'Liste bestellen', 9),
            ('module_reset', 'Restore to Default', 'de_de', 'Zurück zu Werkeinstellungen', 9),
            ('display_fields', 'Display Fields', 'de_de', 'Anzeigefelder', 9),
            ('discount_lessthen_100', 'Discount % should be less than 100', 'de_de', 'Rabatt% sollte weniger als 100 sein', 10),
            ('select_item', 'Select Item', 'de_de', 'Menüpunkt wählen', 10),
            ('item_comment', 'Item Comment', 'de_de', 'Artikelkommentar', 10),
            ('record_name', 'Record Name is :', 'de_de', 'Der Name des Datensatzes lautet:', 11),
            ('go_back', 'Go Back', 'de_de', 'Geh zurück', 11),
            ('please_enter_shortcut_name', 'Please Enter Shortcut Name', 'de_de', 'Bitte geben Sie den Namen der Verknüpfung ein', 11),
            ('number_not_found', 'Contact Number not found', 'de_de', 'Kontaktnummer nicht gefunden', 11),
            ('mail_not_found', 'Mail Address not found', 'de_de', 'Mail-Adresse nicht gefunden', 11),
            ('create_shortcut', 'Create Shortcut', 'de_de', 'Verknüpfung erstellen', 11),
            ('contact_summary', 'Summary', 'de_de', 'Zusammenfassung', 11),
            ('activites', 'Activities', 'de_de', 'Aktivitäten', 11),
            ('details', 'Details', 'de_de', 'Einzelheiten', 11),
            ('related', 'Related', 'de_de', 'verbunden', 11),
            ('share_link', 'Share record with', 'de_de', 'Share record with', 11),
            ('edit', 'Edit', 'de_de', 'Edit', 11),
            ('duplicate', 'Duplicate', 'de_de', 'Duplicate', 11),
            ('whatsapp', 'Whatsapp', 'de_de', 'Whatsapp', 11),
            ('call', 'Call', 'de_de', 'Call', 11),
            ('choose_contact_for_call', 'Choose Contact for Call', 'de_de', 'Choose Contact for Call', 11),
            ('choose_contact_for_sms', 'Choose Contact for SMS', 'de_de', 'Choose Contact for SMS', 11),
            ('choose_contact_for_whatsapp', 'Choose Contact for WhatsApp', 'de_de', 'Choose Contact for WhatsApp', 11),
            ('chosse_contact_for_email', 'Choose Email', 'de_de', 'Choose Email', 11),
            ('attach_file', 'Attach Files', 'de_de', 'Attach Files', 11),
            ('close', 'Close', 'de_de', 'Close', 11),
            ('status', 'Status', 'de_de', 'Status', 11),
            ('stop', 'Stop', 'de_de', 'Stop', 11),
            ('zero', '0', 'de_de', '0', 11),
            ('record', 'Record', 'de_de', 'Record', 11),
            ('voice_note', 'Voice Note', 'de_de', 'Voice Note', 11),
            ('tickets', 'Tickets', 'de_de', 'Tickets', 12),
            ('check_out', 'Check Out', 'de_de', 'Auschecken', 12),
            ('check_in', 'Check In', 'de_de', 'Check-In', 12),
            ('select_any', 'Select any', 'de_de', 'Wählen Sie eine', 12),
            ('fulldetails', 'Show Full Details', 'de_de', 'Vollständige Details anzeigen', 12),
            ('checkin', 'Check-in', 'de_de', 'Check-In', 12),
            ('navigate', 'Navigate', 'de_de', 'Navigieren', 12),
            ('product', 'Products', 'de_de', 'Produkte', 12),
            ('projectMilestone', 'Project Milestone', 'de_de', 'Meilenstein des Projekts', 12),
            ('projecttask', 'Project Tasks', 'de_de', 'Projektaufgabe', 12),
            ('nearby', 'NearBy', 'de_de', 'In der Nähe', 13),
            ('document', 'Document', 'de_de', 'Dokumentieren', 14),
            ('reply', 'Reply', 'de_de', 'Antworten', 14),
            ('reply_all', 'Reply All', 'de_de', 'Allen antworten', 14),
            ('forward', 'Forward', 'de_de', 'Nach vorne', 14),
            ('action', 'Action', 'de_de', 'Aktion', 14),
            ('select_first', 'Select First', 'de_de', 'Select First', 14),
            ('commentaddsuccessful', 'Comment added successfull', 'de_de', 'Kommentar hinzufügen Erfolgreich', 14),
            ('move_to', 'Move to', 'de_de', 'Ziehen nach', 14),
            ('attach', 'Attach', 'de_de', 'Anfügen', 14),
            ('addcoment', 'Add Comment', 'de_de', 'Einen Kommentar hinzufügen', 14),
            ('adddocument', 'Add Document', 'de_de', 'Dokument hinzufügen', 14),
            ('home', 'Home', 'de_de', 'Zuhause', 15),
            ('checkout', 'Check-out', 'de_de', 'Auschecken', 15),
            ('message_search', 'Search by name', 'de_de', 'Suche mit Name', 15),
            ('start_shift', 'Start shift', 'de_de', 'Schicht starten', 15),
            ('end_shift', 'End shift', 'de_de', 'Schicht beenden', 15),
            ('today_meeting', 'Meetings', 'de_de', 'Besprechungen', 15),
            ('shift_time_track', 'Shift Time Track', 'de_de', 'Zeitspur verschieben', 15),
            ('logout_msg', 'You have to login again , click', 'de_de', 'You have to login again , click', 15),
            ('logout_msg1', 'to continue.', 'de_de', 'to continue.', 15),
            ('permission_denied', 'You don\'t have permission to create', 'de_de', 'Sie haben keine Berechtigung zum Erstellen', 15),
            ('history', 'Activity stream', 'de_de', 'Aktivitätsanzeige', 15),
            ('search_value', 'Search value :', 'de_de', 'Search value :', 15),
            ('feed_back_msg', 'Please enter feedback message', 'de_de', 'Bitte geben Sie eine Rückmeldung ein', 16),
            ('feed_back_hint_msg', 'Enter feedback message', 'de_de', 'Geben Sie eine Rückmeldung ein', 16),
            ('submit', 'Submit', 'de_de', 'einreichen', 16),
            ('check_app_not_installed', 'Application is not currently installed.', 'de_de', 'Die Anwendung ist derzeit nicht installiert.', 17),
            ('send_sms_fail_message', 'SMS failed, please try again later!', 'de_de', 'SMS fehlgeschlagen, bitte versuchen Sie es später noch einmal!', 17),
            ('documentaddsuccessfully', 'Document Attach successfully', 'de_de', 'Dokument erfolgreich anhängen', 17),
            ('send_message', 'Send message', 'de_de', 'Nachricht senden', 17),
            ('sms_to', 'smsto:', 'de_de', 'smsto:', 17),
            ('add_list_message', 'Add List', 'de_de', 'Liste hinzufügen', 18),
            ('mylist', 'My List', 'de_de', 'Meine Liste', 18),
            ('filtername', 'Filter Name', 'de_de', 'Filtername', 18),
            ('selectlist', 'Select a List', 'de_de', 'Wählen Sie eine Liste *', 18),
            ('assingedto', 'Assigned To', 'de_de', 'Zugewiesen an *', 18),
            ('selectmodule', 'Select a module', 'de_de', 'Wählen Sie ein Modul aus', 18),
            ('add_list', 'Add Filter', 'de_de', 'Filter hinzufügen', 18),
            ('recent_event', 'Recent Event', 'de_de', 'Aktuelles Ereignis', 19),
            ('recent_hostory', 'Recent History', 'de_de', 'Jüngste Geschichte', 19),
            ('module_specific_settings', 'Module-Specific Settings', 'de_de', 'Modulspezifische Einstellungen', 19),
            ('talk_to_us', 'Talk to us', 'de_de', 'Rede mit uns', 19),
            ('report_a_bug', 'Report A Bug', 'de_de', 'Melde einen technischen Fehler', 19),
            ('faq', 'FAQ', 'de_de', 'FAQ', 19),
            ('selectmodules', 'Select Module', 'de_de', 'Modul auswählen', 19),
            ('myplan', 'My Plan', 'de_de', 'Mein Plan', 19),
            ('message', 'Message', 'de_de', 'Botschaft', 20),
            ('message_validation', 'Please enter Message', 'de_de', 'Bitte geben Sie eine Nachricht ein', 20),
            ('contact_select', 'Please Select contact', 'de_de', 'Bitte Kontakt auswählen', 20),
            ('global_search', 'Global Search', 'de_de', 'Global Search', 21),
            ('records', 'Records', 'de_de', 'Records', 21),
            ('dont_show_again', 'Don\'t Show Again', 'de_de', 'Don\'t Show Again', 22),
            ('skip', 'Skip', 'de_de', 'Skip', 22),
            ('file_downloading', 'File Downloading', 'de_de', 'Herunterladen von Dateien', 23),
            ('add_screenshots_optional', 'Add screenshots (optional)', 'de_de', 'Screenshots hinzufügen (optional)', 24),
            ('describe_your_problem', 'Describe your problem', 'de_de', 'Beschreiben Sie Ihr Problem', 24),
            ('default_filter_shortcut', 'Default Filter Shortcut', 'de_de', 'Default Filter Shortcut', 25),
            ('record_shortcut', 'Record Shortcut', 'de_de', 'Record Shortcut', 25),
            ('enter_url', 'Please Enter url', 'de_de', 'Please Enter url', 26),
            ('new_version_is_avaiable', 'You need to update the app to continue using Please update to continue Older versions will no longer work from today', 'de_de', 'You need to update the app to continue using Please update to continue Older versions will no longer work from today', 26),
            ('search_by', 'Search by', 'de_de', 'Suche nach', 27),
            ('selected_filter', 'Selected filter :', 'de_de', 'Ausgewählter Filter:', 27),
            ('selected_field', 'Selected field :', 'de_de', 'Ausgewähltes Feld:', 27),
            ('choose', 'Choose', 'de_de', 'Choose', 28),
            ('qr_cardscanner', 'QR Code Scanner', 'de_de', 'QR Code Scanner', 28),
            ('error_message_for_scan', 'Could not read the card Try again later.', 'de_de', 'Could not read the card Try again later.', 28),
            ('press_start_scan', 'Press to Start Scan', 'de_de', 'Press to Start Scan', 28),
            ('line_item_quntity_validation_msg', 'Value should be greater than zero', 'de_de', 'Value should be greater than zero', 29),
            ('percentage_msg', 'Percentage should be less than 100', 'de_de', 'Percentage should be less than 100', 29),
            ('MSG_NO_DATA', 'No data found!', 'de_de', 'No data found!', 29),
            ('MSG_SOMETHING_WRONG', 'Something went wrong!', 'de_de', 'Something went wrong!', 29),
            ('MSG_COMING_SOON', 'Coming Soon!', 'de_de', 'Coming Soon!', 29),
            ('MSG_UPLOAD_PROFILE_IMAGE', 'Please upload profile image.', 'de_de', 'Please upload profile image.', 29),
            ('ALERT_TITLE_LOCATION_ACCESS', 'Location Access', 'de_de', 'Location Access', 29),
            ('ALERT_MSG_LOCATION_ACCESS', 'Requires your location to show nearby events.', 'de_de', 'Requires your location to show nearby events.', 29),
            ('ALERT_BTN_ALLOW', 'ALLOW', 'de_de', 'ALLOW', 29),
            ('ALERT_BTN_DENY', 'DENY', 'de_de', 'DENY', 29),
            ('ALERT_MSG_LOCATION_SETTING', 'Not able to fetch your current location. Please check your location settings.', 'de_de', 'Not able to fetch your current location. Please check your location settings.', 29),
            ('DELETE_RECORD', 'Delete Record', 'de_de', 'Delete Record', 29),
            ('ALERT_MSG_DELETE_SHORTCUT', 'Are you sure want to delete this shortcut?', 'de_de', 'Are you sure want to delete this shortcut?', 29),
            ('DELETE_SHORTCUT', 'Delete Shortcut', 'de_de', 'Delete Shortcut', 29),
            ('LBL_TERMS', 'By logging in, you agree to our Terms and', 'de_de', 'By logging in, you agree to our Terms and', 29),
            ('LBL_CONDITIONS', 'Conditions &', 'de_de', 'Conditions &', 29),
            ('ALERT_TITLE', 'Alert', 'de_de', 'Alert', 29),
            ('ALERT_BTN_SUBSCRIBE', 'Subscribe', 'de_de', 'Subscribe', 29),
            ('MSG_SELECT_MODULE', 'Please select any Module', 'de_de', 'Please select any Module', 29),
            ('MSG_SELECT_LIST', 'Please select any List', 'de_de', 'Please select any List', 29),
            ('ALERT_MSG_DONT_HAVE_CAMERA', 'You don\'t have camera', 'de_de', 'You don\'t have camera', 29),
            ('ALERT_MSG_GALLARY_PERMISSION', 'You don\'t have permission to access gallery.', 'de_de', 'You don\'t have permission to access gallery.', 29),
            ('ALERT_MSG_CAMERA_PERMISSION', 'You don\'t have permission to access camera. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Camera on', 'de_de', 'You don\'t have permission to access camera. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Camera on', 29),
            ('ALERT_MSG_SPEECH_PERMISSION', 'You don\'t have permission to access Speech Recognition. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Speech Recognition on', 'de_de', 'You don\'t have permission to access Speech Recognition. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Speech Recognition on', 29),
            ('BTN_DONE', 'Done', 'de_de', 'Done', 29),
            ('COMMENT', 'Comment', 'de_de', 'Comment', 29),
            ('FULL_FORM', 'Full Form', 'de_de', 'Full Form', 29),
            ('QUICK_CREATE', 'Create', 'de_de', 'Create', 29),
            ('LBL_SELECT_FIELDS', 'Select Fields', 'de_de', 'Select Fields', 29),
            ('LBL_SELECT_FIELDS', 'Select Fields', 'de_de', 'Select Fields', 29),
            ('LBL_SELECT_FIRST_FIELDS', 'Select First Field', 'de_de', 'Select First Field', 29),
            ('LBL_SELECT_SECOND_FIELDS', 'Select Second Field', 'de_de', 'Select Second Field', 29),
            ('LBL_SELECT_THIRD_FIELDS', 'Select Third Field', 'de_de', 'Select Third Field', 29),
            ('LBL_SORT_BY_FIELD', 'Select Sort By Field', 'de_de', 'Select Sort By Field', 29),
            ('BTN_RESET_TO_DEFAULT', 'Reset to Default', 'de_de', 'Reset to Default', 29),
            ('MSG_SELECT_SORT_BY_FIELD', 'Select Sort by field', 'de_de', 'Select Sort by field', 29),
            ('kStrClearBtnTitle', 'Clear', 'de_de', 'Clear', 29),
            ('kStrShowMoreBtnTitle', 'Show More', 'de_de', 'Show More', 29),
            ('kStrAddActivitiesBtnTitle', 'Add Activities', 'de_de', 'Add Activities', 29),
            ('kStrAddCommentPlaceHolder', 'Add your comments here', 'de_de', 'Add your comments here', 29),
            ('MSG_ENTER_TO_EMAIL', 'Please enter to field.', 'de_de', 'Please enter to field.', 29),
            ('WARNING_FILE', 'File can\'t open.', 'de_de', 'File can\'t open.', 29),
            ('MSG_FILE_SAVED', 'File saved.', 'de_de', 'File saved.', 29),
            ('WARNING_DOWNLOAD_FAIL', 'Download fail!, please try after sometime.', 'de_de', 'Download fail!, please try after sometime.', 29),
            ('LBL_SHORTCUT', 'Shortcut', 'de_de', 'Shortcut', 29),
            ('TXT_MESSAGE_PLACEHOLDER', 'Type Message', 'de_de', 'Type Message', 29),
            ('ALERT_INSTALL_WHATSAPP', 'Install Whatsapp', 'de_de', 'Install Whatsapp', 29),
            ('MSG_NO_MAIL_BOX', 'No MailBox found. Please Create Mailbox', 'de_de', 'No MailBox found. Please Create Mailbox', 29),
            ('LBL_WROTE', 'Wrote', 'de_de', 'Wrote', 29),
            ('MSG_MAIL_SEND', 'Mail sent', 'de_de', 'Mail sent', 29),
            ('log_file_not_found', 'API Log file not found.', 'de_de', 'API Log file not found.', 29),
            ('unknown_error', 'An unknown error occurred, try again', 'de_de', 'An unknown error occurred, try again', 29),
            ('CTMTigerAppVersion', 'CRMTiger App Version', 'de_de', 'CRMTiger App Version', 29),
            ('CTMMobileUpdateMsg', 'CTMobile Ext. Version Update Successfully', 'de_de', 'CTMobile Ext. Version Update Successfully', 29),
            ('dialog_Premium_downgrade', 'Downgrade will required logout and login again later', 'de_de', 'Downgrade will required logout and login again later', 29),
            ('dialog_Premium', 'Upgrade will required logout and login again later', 'de_de', 'Upgrade will required logout and login again later', 29),
            ('Overwrite', 'Overwrite', 'de_de', 'Overwrite', 29),
            ('MSGAddressOverwrite1', 'Overwrite the existing address with the selected', 'de_de', 'Overwrite the existing address with the selected', 29),
            ('MSGAddressOverwrite2', 'address details?', 'de_de', 'address details?', 29),
            ('UPGRADE_PLAN', 'Upgrade Plan', 'de_de', 'Upgrade Plan', 29),
            ('DOWNGRADE_PLAN', 'Downgrade Plan', 'de_de', 'Downgrade Plan', 29),
            ('UPGRADE_EXTENSION', 'Upgrade Extension', 'de_de', 'Upgrade Extension', 29),
            ('UPGRADE_APP', 'Upgrade App', 'de_de', 'Upgrade App', 29),
            ('SELECT_OPTION', 'Select Option', 'de_de', 'Select Option', 29),
            ('PLEASE_SELECT', 'Please select', 'de_de', 'Please select', 29),
            ('MSG_ACCESS_DENIED', 'You don\'t have permission for this module.', 'de_de', 'You don\'t have permission for this module.', 29),
            ('MSG_SELECT_RECCURING_MONTH_DAY', 'Please select reccuring day of month.', 'de_de', 'Please select reccuring day of month.', 29),
            ('MSG_SELECT_RECCURING_WEEK_DAY', 'Please select reccuring day of week.', 'de_de', 'Please select reccuring day of week.', 29),
            ('MSG_SELECT_RECCURING_DAYS', 'Please select reccuring days.', 'de_de', 'Please select reccuring days.', 29),
            ('Please select reccuring days.', 'Please select reccuring days.', 'de_de', 'Please select reccuring days.', 29),
            ('MSG_SELECT_RECCURING_END_DATE', 'Please select reccuring end date.', 'de_de', 'Please select reccuring end date.', 29),
            ('MSG_SELECT_RECCURING_TYPE', 'Please select reccuring type.', 'de_de', 'Please select reccuring type.', 29),
            ('FREQ_TIME', 'Times', 'de_de', 'Times', 29),
            ('REPEAT_YEARLY', 'Repeat Yearly', 'de_de', 'Repeat Yearly', 29),
            ('REPEAT_MONTHLY', 'Repeat Monthly', 'de_de', 'Repeat Monthly', 29),
            ('REPEAT_WEEKLY', 'Repeat Weekly', 'de_de', 'Repeat Weekly', 29),
            ('REPEAT_DAILY', 'Repeat Daily', 'de_de', 'Repeat Daily', 29),
            ('ACTION_TITLE', 'Action Title', 'de_de', 'Action Title', 29),
            ('MSG_SELECT_VALID_DATE', 'Please select valid day of month.', 'de_de', 'Please select valid day of month.', 29),
            ('MSG_SELECT_VALID_START_DATE', 'Start date should be less than end date.', 'de_de', 'Start date should be less than end date.', 29),
            ('MSG_SELECT_VALID_START_TIME', 'Start time should be less than end time.', 'de_de', 'Start time should be less than end time.', 29),
            ('LBL_LINEITEM_DETAILS', 'Lineitem Details', 'de_de', 'Lineitem Details', 29),
            ('MSG_INVALIDE_DISCOUNT_AMOUNT', 'Discount amount should be less than the total.', 'de_de', 'Discount amount should be less than the total.', 29),
            ('VIEW', 'View', 'de_de', 'View', 29),
            ('MSG_ENTER_VALID', 'Please enter valid', 'de_de', 'Please enter valid', 29),
            ('MSG_ENTER_PERCENTAGE', 'Percentage should be less than 100.', 'de_de', 'Percentage should be less than 100.', 29),
            ('ITEM_TOTAL', 'Item Total', 'de_de', 'Item Total', 29),
            ('ADJUSTMENT', 'Adjustment', 'de_de', 'Adjustment', 29),
            ('TITLE_CHOOSE_IMAGE', 'Choose Image', 'de_de', 'Choose Image', 29),
            ('COMPRESS', 'Compress', 'de_de', 'Compress', 29),
            ('CHOOSE_ANOTHER_IMAGE', 'Your image size is too large, please select another image', 'de_de', 'Your image size is too large, please select another image', 29),
            ('OnDayOfMonth', 'On day of month', 'de_de', 'On day of month', 29),
            ('OnDayOfWeek', 'On day of week', 'de_de', 'On day of week', 29),
            ('AddAndClose', 'Add & Close', 'de_de', 'Add & Close', 29),
            ('Repeat', 'Repeat', 'de_de', 'Repeat', 29),
            ('OnDay', 'On day', 'de_de', 'On day', 29),
            ('View_Line_Item', 'View Line Item', 'de_de', 'View Line Item', 29),
            ('TITLE_IMAGE', 'Image', 'de_de', 'Image', 29),
            ('TITLE_ICLOUD', 'iCloud', 'de_de', 'iCloud', 29),
            ('GOOGLE', 'Google', 'de_de', 'Google', 29),
            ('ALERT_BTN_OKAY', 'Okay', 'de_de', 'Okay', 29),
            ('ALERT_TITLE_ACCESS_DENIED', 'Access Denied', 'de_de', 'Access Denied', 29),
            ('Dont_Show_Again', 'Don\'t show again', 'de_de', 'Don\'t show again', 29),
            ('Skip', 'Skip', 'de_de', 'Skip', 29),
            ('Fillter_Name', 'Fillter Name', 'de_de', 'Fillter Name', 29),
            ('Fillter_Record_Count', 'Fillter Record Count', 'de_de', 'Fillter Record Count', 29),('url_note',  'Note : if your URL of CRM is https://example.com/crm enter that into above box',   'de_de',    'Note : if your URL of CRM is https://example.com/crm enter that into above box',   31),
            ('vtiger_url',  'Your vTiger CRM URL',  'de_de',    'Your vTiger CRM URL',  31),
            ('msg_doc_read_permission', 'You don\'t have permission to Add either This is read-only or Private Field.',  'de_de',    'You don\'t have permission to Add either This is read-only or Private Field.',  31),
            ('CLEAR',   'Clear',    'de_de',    'Clear',    31),
            ('Files/photos uploaded successfully',  'Files/photos uploaded successfully',   'de_de',    'Files/photos uploaded successfully',   32),
            ('Digital signature saved', 'Digital signature saved',  'de_de',    'Digital signature saved',  32),
            ('Please upload Signature or Files/photos', 'Please upload Signature or Files/photos',  'de_de',    'Please upload Signature or Files/photos',  32),
            ('Files / Photos',  'Files / Photos',   'de_de',    'Files / Photos',   32),
            ('Signature',   'Signature',    'de_de',    'Signature',    32),
            ('add_photo_using', 'Add Photo Using',  'de_de',    'Add Photo Using',  31),
            ('btn_upload_sign', '(+) Add Signature',    'de_de',    '(+) Add Signature',    31),
            ('btn_upload_photo_doc',    '(+) Upload Files/Photos',  'de_de',    '(+) Upload Files/Photos',  31),
            ('select_photo_doc_to_upload',  'Please select files/photos to upload', 'de_de',    'Please select files/photos to upload', 31),
            ('related_module_title',    'Search from related module and Add to \"Route\"',  'de_de',    'Search from related module and Add to \"Route\"',  30),
            ('Route status updated successfully',   'Route status updated successfully',    'de_de',    'Route status updated successfully',    32),
            ('Session init failed', 'Session init failed',  'de_de',    'Session init failed',  32),
            ('You don\'t have permission to access this resource',  'You don\'t have permission to access this resource',   'de_de',    'You don\'t have permission to access this resource',   32),
            ('ctroute_realtedto cannot be empty',   'Could not get the Related To - Try again later',   'de_de',    'Could not get the Related To - Try again later',   32),
            ('ctroute_planning cannot be empty',    'Could not get the Route Planning Record - Try again later',    'de_de',    'Could not get the Route Planning Record - Try again later',    32),
            ('Something went wrong - Try again later',  'Something went wrong - Try again later',   'de_de',    'Something went wrong - Try again later',   32),
            ('sequence updated successfully',   'sequence updated successfully',    'de_de',    'sequence updated successfully',    32),
            ('sequence cannot be empty',    'sequence cannot be empty', 'de_de',    'sequence cannot be empty', 32),
            ('Shortcut details not saved',  'Shortcut details not saved',   'de_de',    'Shortcut details not saved',   32),
            ('Shortcut details saved successfully', 'Shortcut details saved successfully',  'de_de',    'Shortcut details saved successfully',  32),
            ('Route save successfully', 'Route save successfully',  'de_de',    'Route save successfully',  32),
            ('Record save successfully',    'Record save successfully', 'de_de',    'Record save successfully', 32),
            ('No dependency found for picklist',    'No dependency found for picklist', 'de_de',    'No dependency found for picklist', 32),
            ('No records found',    'No records found', 'de_de',    'No records found', 32),
            ('Outgoing server is not enabled, please configure from CRM',   'Outgoing server is not enabled, please configure from CRM',    'de_de',    'Outgoing server is not enabled, please configure from CRM',    32),
            ('Removed Successfully',    'Removed Successfully', 'de_de',    'Removed Successfully', 32),
            ('Shortcut has been deleted',   'Shortcut has been deleted',    'de_de',    'Shortcut has been deleted',    32),
            ('relation of records removed successfully',    'relation of records removed successfully', 'de_de',    'relation of records removed successfully', 32),
            ('relation of records not removed', 'relation of records not removed',  'de_de',    'relation of records not removed',  32),
            ('Record has been deleted successfully',    'Record has been deleted successfully', 'de_de',    'Record has been deleted successfully', 32),
            ('Time Tracking saved successfully',    'Time Tracking saved successfully', 'de_de',    'Time Tracking saved successfully', 32),
            ('Time Tracking updated successfully',  'Time Tracking updated successfully',   'de_de',    'Time Tracking updated successfully',   32),
            ('Time Tracking ended successfully',    'Time Tracking ended successfully', 'de_de',    'Time Tracking ended successfully', 32),
            ('Time Tracking started successfully',  'Time Tracking started successfully',   'de_de',    'Time Tracking started successfully',   32),
            ('record cannot be empty',  'record cannot be empty',   'de_de',    'record cannot be empty',   32),
            ('Module is disabled',  'Module is disabled',   'de_de',    'Module is disabled',   32),
            ('Shift ended successfully',    'Shift ended successfully', 'de_de',    'Shift ended successfully', 32),
            ('Shift started successfully',  'Shift started successfully',   'de_de',    'Shift started successfully',   32),
            ('relation of records added successfully',  'relation of records added successfully',   'de_de',    'relation of records added successfully',   32),
            ('Comment saved successfully',  'Comment saved successfully',   'de_de',    'Comment saved successfully',   32),
            ('Comment not saved',   'Comment not saved',    'de_de',    'Comment not saved',    32),
            ('Comment module is not active',    'Comment module is not active', 'de_de',    'Comment module is not active', 32),
            ('No Upcoming Event',   'No Upcoming Event',    'de_de',    'No Upcoming Event',    32),
            ('No Templates found - create it from Message Templates module',    'No Templates found - create it from Message Templates module', 'de_de',    'No Templates found - create it from Message Templates module', 32),
            ('No event or task for this date',  'No event or task for this date',   'de_de',    'No event or task for this date',   32),
            ('No filters created',  'No filters created',   'de_de',    'No filters created',   32),
            ('Select at least one record to attach',    'Select at least one record to attach', 'de_de',    'Select at least one record to attach', 32),
            ('Please select one or more attachments',   'Please select one or more attachments',    'de_de',    'Please select one or more attachments',    32),
            ('No event for this month', 'No event for this month',  'de_de',    'No event for this month',  32),
            ('No Activity found',   'No Activity found',    'de_de',    'No Activity found',    32),
            ('Your feedback is valuable for us - it cannot be empty',   'Your feedback is valuable for us - it cannot be empty',    'de_de',    'Your feedback is valuable for us - it cannot be empty',    32),
            ('Could not send mail, Please try later',   'Could not send mail, Please try later',    'de_de',    'Could not send mail, Please try later',    32),
            ('Latest Version updated successfully', 'Latest Version updated successfully',  'de_de',    'Latest Version updated successfully',  32),
            ('User Location Updated Successfully',  'User Location Updated Successfully',   'de_de',    'User Location Updated Successfully',   32),
            ('User Location not Updated Successfully',  'User Location not Updated Successfully',   'de_de',    'User Location not Updated Successfully',   32),
            ('SMSNotifier is not enable in CRM. Please enable it first',    'SMSNotifier is not enable in CRM. Please enable it first', 'de_de',    'SMSNotifier is not enable in CRM. Please enable it first', 32),
            ('Could not submit your feedback - Please try again later', 'Could not submit your feedback - Please try again later',  'de_de',    'Could not submit your feedback - Please try again later',  32),
            ('Thank you for submitting your feedback',  'Thank you for submitting your feedback',   'de_de',    'Thank you for submitting your feedback',   32),
            ('Please upload User Image',    'Please upload User Image', 'de_de',    'Please upload User Image', 32),
            ('Image Not Uploading, please try again',   'Image Not Uploading, please try again',    'de_de',    'Image Not Uploading, please try again',    32),
            ('User Image Uploaded Successfully',    'User Image Uploaded Successfully', 'de_de',    'User Image Uploaded Successfully', 32),
            ('Invalid Module name', 'Invalid Module name',  'de_de',    'Invalid Module name',  32),
            ('Records Sync Successfully',   'Records Sync Successfully',    'de_de',    'Records Sync Successfully',    32),
            ('Values cannot be empty',  'Values cannot be empty',   'de_de',    'Values cannot be empty',   32),
            ('Record id is empty',  'Record id is empty',   'de_de',    'Record id is empty',   32),
            ('Logout Successfully', 'Logout Successfully',  'de_de',    'Logout Successfully',  32),
            ('Please Enable CTMobile Module',   'Please Enable CTMobile Module',    'de_de',    'Please Enable CTMobile Module',    32),
            ('Authentication Failed',   'Username and Password do not match',   'de_de',    'Username and Password do not match',   32),
            ('Mismatched module information',   'Something gone wrong, please try again later', 'de_de',    'Something gone wrong, please try again later', 32),
            ('Field does not exists',   'Please set display fields again',  'de_de',    'Please set display fields again',  32),
            ('Module does not exists',  'Module does not exists or disabled by admin',  'de_de',    'Module does not exists or disabled by admin',  32),
            ('Month cannot be empty',   'Could not get the Month - Try again later',    'de_de',    'Could not get the Month - Try again later',    32),
            ('Year cannot be empty',    'Could not get the Year - Try again later', 'de_de',    'Could not get the Year - Try again later', 32),
            ('Date cannot be empty',    'Could not get the Date - Try again later', 'de_de',    'Could not get the Date - Try again later', 32),
            ('Userid cannot be empty',  'Could not get the Userid - Try again later',   'de_de',    'Could not get the Userid - Try again later',   32),
            ('End Date cannot be empty',    'Could not get the status - Try again later',   'de_de',    'Could not get the status - Try again later',   32),
            ('Start Date cannot be empty',  'Could not get the Start Date - Try again later',   'de_de',    'Could not get the Start Date - Try again later',   32),
            ('You do not configure SMS Notifier in CRM. Please configure SMS Notifier in your CRM to use this feature', 'You do not configure SMS Notifier in CRM. Please configure SMS Notifier in your CRM to use this feature',  'de_de',    'You do not configure SMS Notifier in CRM. Please configure SMS Notifier in your CRM to use this feature',  32),
            ('Longitude cannot be empty',   'Could not get location-Please try again',  'de_de',    'Could not get location-Please try again',  32),
            ('Latitude cannot be empty',    'Could not get location-Please try again',  'de_de',    'Could not get location-Please try again',  32),
            ('User cannot be empty',    'Could not get the User - Try again later', 'de_de',    'Could not get the User - Try again later', 32),
            ('Status cannot be empty',  'Could not get the status - Try again later',   'de_de',    'Could not get the status - Try again later',   32),
            ('Required fields not found',   'Required fields not found',    'de_de',    'Required fields not found',    32),
            ('Tracking module not active',  'Tracking module not active-Please contact CRM Admin',  'de_de',    'Tracking module not active-Please contact CRM Admin',  32),
            ('Missing mandatory input values',  'Missing mandatory input values',   'de_de',    'Missing mandatory input values',   32),
            ('No MailBox found. Please Create Mailbox', 'No MailBox found. Please Create Mailbox',  'de_de',    'No MailBox found. Please Create Mailbox',  32),
            ('Mail not sent',   'Mail not sent',    'de_de',    'Mail not sent',    32),
            ('Mail send successfully',  'Mail send successfully',   'de_de',    'Mail send successfully',   32),
            ('Email Id or username not match with your record', 'Email Id or username not match with your record',  'de_de',    'Email Id or username not match with your record',  32),
            ('Module not specified',    'Module not specified', 'de_de',    'Module not specified', 32),
            ('No messages found',   'No messages found',    'de_de',    'No messages found',    32),
            ('No Dependency Found For This Module', 'No Dependency Found For This Module',  'de_de',    'No Dependency Found For This Module',  32),
            ('Outgoing server is not Enabled',  'Outgoing server is not Enabled',   'de_de',    'Outgoing server is not Enabled',   32),
            ('Outgoing server is Enabled',  'Outgoing server is Enabled',   'de_de',    'Outgoing server is Enabled',   32),
            ('Email Attached Successfully', 'Email Attached Successfully',  'de_de',    'Email Attached Successfully',  32),
            ('Documents Attached Successfully', 'Documents Attached Successfully',  'de_de',    'Documents Attached Successfully',  32),
            ('Login required - Please login again', 'Login required - Please login again',  'de_de',    'Login required - Please login again',  32),
            ('time_tracking_module_disable',    'Time tracking module is disable',  'de_de',    'Time tracking module is disable',  31),
            ('route_planning_module_disable',   'Route planning module is disable', 'de_de',    'Route planning module is disable', 31),
            ('mark_as_held',    'Are you sure you want to mark Event as Held?', 'de_de',    'Are you sure you want to mark Event as Held?', 31),
            ('stop_timer_msg',  'You have already started Time tracking for another record, Do you want to stop it first ?',    'de_de',    'You have already started Time tracking for another record, Do you want to stop it first ?',    31),
            ('access_denied_routeplanning', 'Access denied for route planning', 'de_de',    'Access denied for route planning', 31),
            ('time_spent',  'Time Spent',   'de_de',    'Time Spent',   31),
            ('select_user', 'Select User',  'de_de',    'Select User',  30),
            ('status_cannot_be_held',   'Status cannot be held for future date start',  'de_de',    'Status cannot be held for future date start',  30),
            ('please_select_end_date',  'Please select end date',   'de_de',    'Please select end date',   30),
            ('please_select_start_date',    'Please select start date', 'de_de',    'Please select start date', 30),
            ('tap_on_plus_icon_for_select_route',   'Tap on + icon to select record for your route.',   'de_de',    'Tap on + icon to select record for your route.',   30),
            ('please_enter_notes',  'Please enter notes',   'de_de',    'Please enter notes',   30),
            ('please_enter_title',  'Please enter title',   'de_de',    'Please enter title',   30),
            ('please_select_date',  'Please Select Date',   'de_de',    'Please Select Date',   30),
            ('search_by_date',  'Search by Date',   'de_de',    'Search by Date',   30),
            ('shortcut_not_setup_yet',  'Opps shortcut not setup yet!!! Please add shortcut by click on [icon] from record search results or view record screen.',  'de_de',    'Opps shortcut not setup yet!!! Please add shortcut by click on [icon] from record search results or view record screen.',  30),
            ('max_upload_size', 'max file Upload exceeds',  'de_de',    'max file Upload exceeds',  30),
            ('unselect_all',    'UnSelect All', 'de_de',    'UnSelect All', 30),
            ('select_all',  'Select All',   'de_de',    'Select All',   30),
            ('please_select_records',   'Please select records',    'de_de',    'Please select records',    30),
            ('select_date', 'Select Date',  'de_de',    'Select Date',  30),
            ('quantity_in_stock_is',    'Quantity in stock is', 'de_de',    'Quantity in stock is', 30),
            ('replies', 'Replies',  'de_de',    'Replies',  30),
            ('conversation_require_selection',  'Conversion requires selection of Contact or Organization', 'de_de',    'Conversion requires selection of Contact or Organization', 30),
            ('please_select_product',   'Please Select Product',    'de_de',    'Please Select Product',    30),
            ('timer_msg',   'You can start timer for single task only at same time',    'de_de',    'You can start timer for single task only at same time',    31),
            ('save_start_tracking', 'Save & Start Tracking',    'de_de',    'Save & Start Tracking',    31),
            ('lbl_notes',   'Notes',    'de_de',    'Notes',    31),
            ('enter_title', 'Enter Title',  'de_de',    'Enter Title',  31),
            ('select_module_record',    'Select Module / Record',   'de_de',    'Select Module / Record',   31),
            ('lbl_tomorrow',    'Tomorrow', 'de_de',    'Tomorrow', 30),
            ('lbl_yesterday',   'Yesterday',    'de_de',    'Yesterday',    30),
            ('lbl_today',   'Today',    'de_de',    'Today',    30),
            ('time_tracker',    'Time Tracker', 'de_de',    'Time Tracker', 31),
            ('time_end',    'End Time', 'de_de',    'End Time', 5),
            ('due_date',    'End Date', 'de_de',    'End Date', 5),
            ('time_start',  'Time Start',   'de_de',    'Time Start',   5),
            ('date_start',  'Start Date',   'de_de',    'Start Date',   5),
            ('delete_widget_msg',   'Display widget again by using (+) option', 'de_de',    'Display widget again by using (+) option', 15),
            ('no_upcoming_activities',  'No scheduled activities    ',  'de_de',    'No scheduled activities    ',  15),
            ('check_in_first',  'Please check-in first',    'de_de',    'Please check-in first',    30),
            ('duration',    'Duration', 'de_de',    'Duration', 30),
            ('distance',    'Distance', 'de_de',    'Distance', 30),
            ('proper_address_message',  'Please enter proper address in record\n',  'de_de',    'Please enter proper address in record',    30),
            ('select_status',   'Select Status',    'de_de',    'Select Status',    30),
            ('route_planner',   'Route Planner',    'de_de',    'Route Planner',    30),
            ('route_planning',  'Route Planning',   'de_de',    'Route Planning',   30),
            ('add_route',   'Add Route',    'de_de',    'Add Route',    30),
            ('calender_disabled',   'Calendar Module is disabled',  'de_de',    'Calendar Module is disabled',  30),
            ('close_dialog',    'Close form',   'de_de',    'Close form',   30),
            ('cancel_form_message', 'Are You sure want to close ?', 'de_de',    'Are You sure want to close ?', 30),
            ('create_route',    'Create Route', 'de_de',    'Create Route', 30),
            ('select_module_create_route',  'Select Module to create Route',    'de_de',    'Select Module to create Route',    30),
            ('cancel',  'Cancel',   'de_de',    'Stornieren',   30),
            ('assign_route',    'Assign Route', 'de_de',    'Assign Route', 30),
            ('route_for',   'Route for',    'de_de',    'Route for',    30),
            ('assigned_to', 'Assigned To',  'de_de',    'Assigned To',  30),
            ('enter_route_name',    'Enter Route Name', 'de_de',    'Enter Route Name', 30),
            ('list',    'List', 'de_de',    'List', 30),
            ('map', 'Map',  'de_de',    'Map',  30),
            ('other_modules',   'Other Modules',    'de_de',    'Other Modules',    15),
            ('shortcut_no_record_msg',  'Opps shortcut not setup\n yet!!! Please add shortcut  by click on + icon from record\n search results or view record screen.', 'de_de',    'Opps shortcut not setup\n yet!!! Please add shortcut  by click on + icon from record\n search results or view record screen.', 25),
            ('clear',   'Clear',    'de_de',    'Clear',    25),
            ('open',    'Open', 'de_de',    'Open', 11),
            ('max_file_msg',    'Too many files selected (max:6)',  'de_de',    'Too many files selected (max:6)',  11),
            ('error_voicenote_record',  'Unable to recording voice while another application is recording sound.',  'de_de',    'Unable to recording voice while another application is recording sound.',  11),
            ('msg_warning', 'Warning!', 'de_de',    'Warning!', 11),
            ('Permision_denied_contact',    'Permission denied to access your contacts',    'de_de',    'Permission denied to access your contacts',    15),
            ('no_widget_added', 'Please click + icon to add new widget to your dashboard.', 'de_de',    'Please click + icon to add new widget to your dashboard.', 15),
            ('no_data_available',   'Data not available, please check the selected fields', 'de_de',    'Data not available, please check the selected fields', 15),
            ('check_out_successfully',  'Check out successfully',   'de_de',    'Checked out successfully', 11),
            ('check_in_successfully',   'Check in successfully',    'de_de',    'Checked in successfully',  11),
            ('check_out',   'Check out',    'de_de',    'Check out',    11),
            ('check_in',    'Check in', 'de_de',    'Check in', 11),
            ('navigate',    'Navigate', 'de_de',    'Navigate', 11),
            ('save_to_phone_vcard_success', 'VCard Saved to phone successfully',    'de_de',    'VCard Saved to phone successfully',    15),
            ('download_vcard_success',  'VCard downloaded successfully',    'de_de',    'VCard downloaded successfully',    15),
            ('card_details',    'Card Details', 'de_de',    'Card Details', 15),
            ('add_widget',  'Add Widget',   'de_de',    'Add Widget',   15),
            ('delete_widget',   'Are you sure to hide widget?', 'de_de',    'Are you sure to hide widget?', 15),
            ('already_widgets_added',   'All types of Widget & reports are already added',  'de_de',    'All types of Widget & reports are already added',  15),
            ('retry',   'Retry',    'de_de',    'Retry',    28),
            ('retake',  'Retake',   'de_de',    'Retake',   28),
            ('Reports', 'Reports',  'de_de',    'Reports',  15),
            ('Widgets', 'Widgets',  'de_de',    'Widgets',  15),
            ('vcard_config',    'Vcard Configuration',  'de_de',    'Vcard Configuration',  8),
            ('save_to_phone',   'Save to phone',    'de_de',    'Save to phone',    11),
            ('download_vcard',  'Download Vcard',   'de_de',    'Download Vcard',   11),
            ('share_vcard', 'Share Vcard',  'de_de',    'Share Vcard',  11),
            ('share_record',    'Share Record', 'de_de',    'Share Record', 11),
            ('permission_denied_edit',  'You don\'t have permission to edit this record.',  'de_de',    'You don\'t have permission to edit this record.',  27),
            ('permission_denied_delete',    'You don\'t have permission to delete this record.',    'de_de',    'You don\'t have permission to delete this record.',    27),
            ('Voice_Recording_Started', 'Recording Started',    'de_de',    'Recording Started',    12),
            ('Voice_Recording_Stopped', 'Recording Stopped',    'de_de',    'Recording Stopped',    12),
            ('SEARCH',  'Search',   'de_de',    'Search',   7),
            ('LAST',    'Last', 'de_de',    'Last', 7),
            ('FIRST',   'First',    'de_de',    'First',    7),
            ('MONDAY',  'Monday',   'de_de',    'Monday',   7),
            ('TUESDAY', 'Tuesday',  'de_de',    'Tuesday',  7),
            ('WEDNESDAY',   'Wednesday',    'de_de',    'Wednesday',    7),
            ('THURSDAY',    'Thursday', 'de_de',    'Thursday', 7),
            ('FRIDAY',  'Friday',   'de_de',    'Friday',   7),
            ('SATURDAY',    'Saturday', 'de_de',    'Saturday', 7),
            ('SUNDAY',  'Sunday',   'de_de',    'Sunday',   7),
            ('DAILY',   'Daily',    'de_de',    'Daily',    7),
            ('WEEKLY',  'Weekly',   'de_de',    'Weekly',   7),
            ('MONTHLY', 'Monthly',  'de_de',    'Monthly',  7),
            ('YEARLY',  'Yearly',   'de_de',    'Yearly',   7),
            ('asset_tracking',  'Asset tracking',   'de_de',    'Asset tracking',   15);",array());
    }

    static function zh_cn(){
        global $adb;
        $checkQuery = "DELETE FROM ctmobile_language_keyword WHERE keyword_lang = ?";
        $checkResult = $adb->pquery($checkQuery,array('zh_cn'));
        
        $adb->pquery("INSERT INTO `ctmobile_language_keyword` (`keyword`, `keyword_name`, `keyword_lang`, `language_keyword`, `sectionid`) VALUES
            ('network_error', 'Network connection error!', 'zh_cn', '网络错误！', 1),
            ('connection_check', 'Could not connect to CRM, Please check your Internet connection.', 'zh_cn', '请检查您的Internet连接。', 1),
            ('update', 'Update', 'zh_cn', 'Update', 1),
            ('cancel', 'Cancel', 'zh_cn', 'Cancel', 1),
            ('ok', 'Ok', 'zh_cn', '好', 1),
            ('more_information', 'Click here for more information.', 'zh_cn', '点击这里查看更多信息。', 1),
            ('yes', 'Yes', 'zh_cn', '是', 1),
            ('no', 'No', 'zh_cn', '没有', 1),
            ('click_again_exit', 'Click again to exit', 'zh_cn', '再次单击退出', 1),
            ('forpermission', 'You don\'t have permission to view this feature. Please subscribe for Premium version Click here to Subscribe.', 'zh_cn', '你没有权限查看此功能，请订购高级版。点击这里订购', 1),
            ('clickhere', 'Click here', 'zh_cn', '点击这里', 1),
            ('clickhere_subscribe', 'Click here to subscribe premium version', 'zh_cn', '点击这里订购', 1),
            ('clickhere_configure', 'Click here and view how to Configure.', 'zh_cn', '单击此处查看如何配置。', 1),
            ('please_wait', 'Please Wait…', 'zh_cn', '请耐心等待…', 1),
            ('share__msg', 'Share file with', 'zh_cn', '与…共享文件', 1),
            ('dialog_camera', 'Camera', 'zh_cn', '相机', 1),
            ('dialog_add_file_by', 'Take Photo from', 'zh_cn', '添加文件', 1),
            ('add', 'Add', 'zh_cn', '加', 1),
            ('mail_manager_configured', 'Mail Manager is not configured', 'zh_cn', '未配置邮件管理器', 1),
            ('dialog_add_files_by', 'Add Files by', 'zh_cn', '添加文件', 1),
            ('dialog_drive', 'Drive', 'zh_cn', '驾驶', 1),
            ('dialog_drop_box', 'Drop Box', 'zh_cn', '投递箱', 1),
            ('dialog_need_signin', 'You need to Sign-in to your Drive account first.', 'zh_cn', '你需要先登录', 1),
            ('dialog_gallery', 'Gallery', 'zh_cn', '相册', 1),
            ('delete', 'Delete', 'zh_cn', '删除', 1),
            ('timeoutmessage', 'Oops! Request is taking more time than expected.', 'zh_cn', '请求超时。', 1),
            ('gps_location_message', 'GPS is not enabled. Please turn it on to get your near by locations.', 'zh_cn', 'GPS未启用。请打开它，让你的位置靠近。', 1),
            ('sure_want_delete', 'Are you sure want to delete ?', 'zh_cn', '你确定要删除吗？', 1),
            ('select', 'Select', 'zh_cn', '选择', 1),
            ('msgforrecordaudio', 'Minimum record duration one second.', 'zh_cn', 'Minimum record duration one second.', 1),
            ('permission_storage', 'Permission denied to read your External storage', 'zh_cn', '权限被拒绝读取您的外部存储空间', 1),
            ('send_permission_msg', 'Send message permission denied', 'zh_cn', '发送邮件权限被拒绝', 1),
            ('choosefile', 'Choose File', 'zh_cn', '选择文件', 1),
            ('enter', 'Enter', 'zh_cn', '输入', 1),
            ('select_an_option', 'Select an Option', 'zh_cn', 'Select an Option', 1),
            ('email_validation', 'Email is not valid', 'zh_cn', '电子邮件无效', 1),
            ('please_enter', 'Please Enter', 'zh_cn', '请输入', 1),
            ('website_validation_text', 'Website URL is not valid', 'zh_cn', '网站网址无效', 1),
            ('selectvalue', 'Select value first', 'zh_cn', '选择值', 1),
            ('email', 'Email', 'zh_cn', '电子邮件', 1),
            ('enter_email_address', 'Enter email address', 'zh_cn', '输入电邮地址', 1),
            ('email_address_not_correct', 'Email address incorrect', 'zh_cn', '电邮地址不正确', 1),
            ('pls_enter_subject', 'Please Enter Subject', 'zh_cn', '请输入主题', 1),
            ('attachFiles', 'Attached File', 'zh_cn', '附加文件', 1),
            ('from', 'From', 'zh_cn', '来自', 1),
            ('to', 'To', 'zh_cn', '至', 1),
            ('call_permission_msg', 'Call permission denied', 'zh_cn', '呼叫权限被拒绝', 1),
            ('no_records', 'No records found', 'zh_cn', '没有找到记录', 1),
            ('fullform', 'Create New', 'zh_cn', '完整表格', 1),
            ('save', 'Save', 'zh_cn', '保存', 1),
            ('total', 'Total', 'zh_cn', '总', 1),
            ('discount', 'Discount', 'zh_cn', '折扣', 1),
            ('price', 'Price', 'zh_cn', '价钱 *', 1),
            ('quantity', 'Quantity', 'zh_cn', '数量*', 1),
            ('select_module', 'Select Module', 'zh_cn', '选择模块', 1),
            ('item_list', 'Item List', 'zh_cn', '物品清单', 1),
            ('quickcreate', 'Quick Create', 'zh_cn', '快速创建', 1),
            ('overwrite_msg_part1', 'Overwrite the existing address with the selected', 'zh_cn', 'Overwrite the existing address with the selected', 1),
            ('once_in_every', 'Once in every', 'zh_cn', '每一次', 1),
            ('overwrite_msg_part2', 'address details?', 'zh_cn', 'address details?', 1),
            ('add_item', 'Add Item', 'zh_cn', '新增项目', 1),
            ('recordsave', 'Record saved successfully', 'zh_cn', '记录保存成功', 1),
            ('recordnotsave', 'Could not save record. Try again later', 'zh_cn', '记录未保存', 1),
            ('minutes', 'Minutes', 'zh_cn', '分钟', 1),
            ('hours', 'Hours', 'zh_cn', '小时', 1),
            ('days', 'Days', 'zh_cn', '天', 1),
            ('on', 'On', 'zh_cn', '上', 1),
            ('day_of_the_month', 'day of the month', 'zh_cn', '这个月的某一天', 1),
            ('list_price', 'List Price', 'zh_cn', '价格表 *', 1),
            ('add_record', 'Add Record', 'zh_cn', '添加记录', 1),
            ('add_product', 'Add Product', 'zh_cn', '添加产品', 1),
            ('add_service', 'Add Service', 'zh_cn', '添加服务', 1),
            ('discountin', 'Discount in %', 'zh_cn', '折扣％', 1),
            ('unitprice', 'Unit price', 'zh_cn', '单价 *', 1),
            ('netprice', 'Net price', 'zh_cn', '净价 *', 1),
            ('comments', 'Comments', 'zh_cn', '评论', 1),
            ('add_close', 'Add & Close', 'zh_cn', '添加关', 1),
            ('fetching_rout_message', 'Fetching route, Please wait…', 'zh_cn', '获取路线，请稍候......', 1),
            ('setting', 'Settings', 'zh_cn', '设置', 1),
            ('utc', 'UTC', 'zh_cn', '世界标准时间', 1),
            ('in', 'In', 'zh_cn', '在', 1),
            ('days_ago', 'days ago', 'zh_cn', '几天前', 1),
            ('mins_ago', 'Minutes ago', 'zh_cn', '几分钟前', 1),
            ('justnow', 'Just now', 'zh_cn', '刚才', 1),
            ('hours_ago', 'hours ago', 'zh_cn', '几小时前', 1),
            ('in_1_day', 'In 1 day', 'zh_cn', '在1天内', 1),
            ('scanqrcode', 'Asset / Card scanner', 'zh_cn', '扫描二维码', 1),
            ('call_log', 'Call Log', 'zh_cn', '通话记录', 1),
            ('voice_message', 'Hi', 'zh_cn', 'Hi', 1),
            ('voice_message1', 'What can I search for you in', 'zh_cn', 'What can I search for you in', 1),
            ('live_tracking', 'Live Tracking', 'zh_cn', '实时跟踪', 1),
            ('mailmanager', 'Mail Manager', 'zh_cn', '邮件管理员', 1),
            ('my_location', 'My location', 'zh_cn', '我的位置', 1),
            ('created_on', 'Created On', 'zh_cn', '创建于', 1),
            ('modified_on', 'Modified On', 'zh_cn', '修改于', 1),
            ('enter_comments', 'Enter Comments', 'zh_cn', '输入评论', 1),
            ('viewmore', 'View More', 'zh_cn', '查看更多', 1),
            ('viewless', 'View Less', 'zh_cn', '查看更少', 1),
            ('gotofullform', 'Go to Full Form', 'zh_cn', '转到完整表格', 1),
            ('post', 'Post', 'zh_cn', '发表', 1),
            ('url', 'URL', 'zh_cn', '网址', 1),
            ('dialog_title_text_back_color', 'Select a Text Background Color', 'zh_cn', '选择文本背景颜色', 1),
            ('event_or_task', 'Add event/task', 'zh_cn', 'Add event/task', 1),
            ('shortcut', 'Shortcuts', 'zh_cn', '快捷键', 1),
            ('select_field', 'Select Field', 'zh_cn', '选择字段', 1),
            ('share', 'Share', 'zh_cn', '分享', 1),
            ('title_insert_link', 'Insert Link', 'zh_cn', '插入链接', 1),
            ('addyourcommentshere', 'Add your comments here', 'zh_cn', '在这里添加您的评论', 1),
            ('nocomment', 'No Comments', 'zh_cn', '没意见', 1),
            ('leads', 'Leads', 'zh_cn', '线索', 1),
            ('true_val', 'true', 'zh_cn', '真正', 1),
            ('noresult', 'No Result', 'zh_cn', '没有结果', 1),
            ('version', 'Version', 'zh_cn', '版', 1),
            ('convert_lead', 'Convert Lead', 'zh_cn', 'Convert Lead', 1),
            ('app_name', 'CRMTiger', 'zh_cn', 'CRMTiger', 1),
            ('enter_url', 'Please Enter url', 'zh_cn', '请输入网址', 1),
            ('help', 'Help', 'zh_cn', '帮助', 1),
            ('contact_us', 'Contact Us', 'zh_cn', '联系我们', 1),
            ('updates', 'Updates', 'zh_cn', '更新', 1),
            ('logout', 'LogOut', 'zh_cn', '登出', 1),
            ('busnies_cardscanner', 'Business Card Scanner', 'zh_cn', 'Business Card Scanner', 1),
            ('sure_want_logout', 'Are you sure want to logout ?', 'zh_cn', '您确定要退出吗？', 1),
            ('logout_message', 'Logout successfully', 'zh_cn', '您确定要退出吗？', 1),
            ('all', 'All', 'zh_cn', '所有', 1),
            ('add_event', 'Add event', 'zh_cn', 'Add event', 1),
            ('add_task', 'Add Task', 'zh_cn', 'Add Task', 1),
            ('next', 'Next', 'zh_cn', 'Next', 1),
            ('terms_conditions', 'Terms and Conditions', 'zh_cn', 'Terms and Conditions', 1),
            ('login', 'Login', 'zh_cn', '登录', 2),
            ('privacy_policay', 'By logging in, you agree to our Terms and Conditions & Privacy Policy', 'zh_cn', '登录即表示您同意我们的条款和条件。隐私政策', 2),
            ('copyright', 'Copyright © 2020 CRMTiger Version', 'zh_cn', '版权所有©2019 CRMTiger', 2),
            ('enter_username', 'Please enter username', 'zh_cn', '请输入用户名', 2),
            ('enter_password', 'Please enter password', 'zh_cn', '请输入密码', 2),
            ('remanberme', 'Remember Me', 'zh_cn', '记住账号', 2),
            ('forgot_password', 'Forgot password?', 'zh_cn', '忘记密码？', 2),
            ('privacy_policay1', 'Privacy Policy', 'zh_cn', '隐私政策', 2),
            ('contactsupportmsg', 'Something went wrong. \\n please Click here to contact support.', 'zh_cn', 'Something went wrong. \\n please Click here to contact support.', 2),
            ('enter_username_password', 'Entered Username or Password is wrong', 'zh_cn', '输入的用户名和密码', 2),
            ('server_issue_occured', 'Server issues occurred', 'zh_cn', 'Server issues occurred', 2),
            ('password', 'Password', 'zh_cn', '密码', 3),
            ('user_name', 'Username', 'zh_cn', '用户名', 3),
            ('reset_pwd', 'Reset Password', 'zh_cn', '重设密码', 3),
            ('forgot_password_title', 'Forgot password', 'zh_cn', '忘记密码', 3),
            ('enter_user_name', 'Enter user name', 'zh_cn', '记录输入用户名', 3),
            ('cc', 'Cc', 'zh_cn', '抄送', 4),
            ('body', 'Body', 'zh_cn', '正文', 4),
            ('bcc', 'BCC', 'zh_cn', '暗送', 4),
            ('dialog_title_text_color', 'Select a Text Color', 'zh_cn', '选择文本颜色', 4),
            ('date', 'Date', 'zh_cn', '日期', 4),
            ('subject', 'Subject', 'zh_cn', '学科', 4),
            ('composeMail', 'Compose Mail', 'zh_cn', '撰写邮件', 4),
            ('send', 'Send', 'zh_cn', '发送', 4),
            ('select_message', 'Select message', 'zh_cn', '选择消息', 4),
            ('title_insert_table', 'Insert Table', 'zh_cn', '插入表格', 4),
            ('log_file_sms', 'I agree to Share API Log to Technical team for further troubleshooting', 'zh_cn', '我同意将API日志分享给技术团队以进行进一步的故障排除', 5),
            ('edit_record', 'Edit Records', 'zh_cn', '编辑记录', 5),
            ('select_time', 'Select Time', 'zh_cn', '选择时间', 5),
            ('edit_item', 'Edit Item', 'zh_cn', '编辑项目', 5),
            ('items_total', 'Items Total', 'zh_cn', '物品总数', 5),
            ('number_less_then_31', 'Number should be less than 31', 'zh_cn', 'Number should be less than 31', 5),
            ('users', 'Users', 'zh_cn', '用户', 5),
            ('groups', 'Groups', 'zh_cn', '组', 5),
            ('txt_note_for_file', 'Note : Existing attachments(images/files) will be replaced', 'zh_cn', '注意：将替换现有附件（图像/文件）', 5),
            ('greaterdatetime', 'End DateTime should be greater than Start DateTime', 'zh_cn', '结束日期和时间应大于开始日期和时间', 5),
            ('until', 'Until', 'zh_cn', '直到', 5),
            ('organizations', 'Organizations', 'zh_cn', '组织', 6),
            ('contacts', 'Contacts', 'zh_cn', '联系人', 6),
            ('opportunity', 'Opportunity', 'zh_cn', '销售机会', 6),
            ('lbl_sun', 'SUN', 'zh_cn', '星期天', 7),
            ('lbl_mon', 'MON', 'zh_cn', '星期一', 7),
            ('lbl_tue', 'TUE', 'zh_cn', '星期二', 7),
            ('lbl_wed', 'WED', 'zh_cn', '星期三', 7),
            ('lbl_thu', 'THU', 'zh_cn', '星期四', 7),
            ('lbl_fri', 'FRI', 'zh_cn', '星期五', 7),
            ('lbl_sat', 'SAT', 'zh_cn', '星期六', 7),
            ('lbl_1', '1', 'zh_cn', '1', 7),
            ('lbl_2', '2', 'zh_cn', '2', 7),
            ('lbl_3', '3', 'zh_cn', '3', 7),
            ('lbl_4', '4', 'zh_cn', '4', 7),
            ('lbl_5', '5', 'zh_cn', '5', 7),
            ('lbl_6', '6', 'zh_cn', '6', 7),
            ('lbl_7', '7', 'zh_cn', '7', 7),
            ('lbl_8', '8', 'zh_cn', '8', 7),
            ('lbl_9', '9', 'zh_cn', '9', 7),
            ('lbl_10', '10', 'zh_cn', '10', 7),
            ('lbl_11', '11', 'zh_cn', '11', 7),
            ('lbl_12', '12', 'zh_cn', '12', 7),
            ('lbl_13', '13', 'zh_cn', '13', 7),
            ('lbl_14', '14', 'zh_cn', '14', 7),
            ('lbl_15', '15', 'zh_cn', '15', 7),
            ('lbl_16', '16', 'zh_cn', '16', 7),
            ('lbl_17', '17', 'zh_cn', '17', 7),
            ('lbl_18', '18', 'zh_cn', '18', 7),
            ('lbl_19', '19', 'zh_cn', '19', 7),
            ('lbl_20', '20', 'zh_cn', '20', 7),
            ('lbl_21', '21', 'zh_cn', '21', 7),
            ('lbl_22', '22', 'zh_cn', '22', 7),
            ('lbl_23', '23', 'zh_cn', '23', 7),
            ('lbl_24', '24', 'zh_cn', '24', 7),
            ('lbl_25', '25', 'zh_cn', '25', 7),
            ('lbl_26', '26', 'zh_cn', '26', 7),
            ('lbl_27', '27', 'zh_cn', '27', 7),
            ('lbl_28', '28', 'zh_cn', '28', 7),
            ('lbl_29', '29', 'zh_cn', '29', 7),
            ('lbl_30', '30', 'zh_cn', '30', 7),
            ('lbl_31', '31', 'zh_cn', '31', 7),
            ('lbl_32', '32', 'zh_cn', '32', 7),
            ('lbl_33', '33', 'zh_cn', '33', 7),
            ('lbl_34', '34', 'zh_cn', '34', 7),
            ('lbl_35', '35', 'zh_cn', '35', 7),
            ('lbl_36', '36', 'zh_cn', '36', 7),
            ('lbl_37', '37', 'zh_cn', '37', 7),
            ('lbl_38', '38', 'zh_cn', '38', 7),
            ('lbl_39', '39', 'zh_cn', '39', 7),
            ('lbl_40', '40', 'zh_cn', '40', 7),
            ('lbl_41', '41', 'zh_cn', '41', 7),
            ('lbl_42', '42', 'zh_cn', '42', 7),
            ('current_date', 'current date', 'zh_cn', '当前的日期', 7),
            ('event', 'Events', 'zh_cn', '活动', 7),
            ('calendar', 'Calendar', 'zh_cn', '日历', 7),
            ('latest_version', 'Latest Version :', 'zh_cn', 'Latest Version :', 8),
            ('expire_on', 'Next renewal date : ', 'zh_cn', '过期时间： ', 8),
            ('ctmobile_ext_version', 'CTMobile Ext. Version : ', 'zh_cn', 'CTMobile Ext。版本： ', 8),
            ('you_have_latest_version', 'You already have latest version', 'zh_cn', '您有更新版本', 8),
            ('latest_version1', 'You Already have latest version', 'zh_cn', '你已经有了最新版本', 8),
            ('upgreaded', 'Upgrade', 'zh_cn', '升级', 8),
            ('downgrade', 'Downgrade', 'zh_cn', '降级', 8),
            ('dialog_recent_event_info', 'You can set from here how many number of records you want to show on Home screen for Recent Event.', 'zh_cn', '您可以在此处设置要在主屏幕上显示最近事件的记录数。', 8),
            ('dialog_feedback_info', 'You can submit your feedback with description , our team will check your feedback and get back to you.', 'zh_cn', '您可以通过说明提交反馈，我们的团队会检查您的反馈并回复您。', 8),
            ('dialog_log_info', 'Log functionality is used for customer support / help , If you are facing any issues in app or any module or functionality is not working proper then you can enable share log with our development team.', 'zh_cn', 'Lorem ipsum dolor坐在一起，reque nobis detraxit an quo。 Pri aperiri alterum an，in velid debitis placerat factemque，elitr offendit vituperatoribus est an。 Mel suas提示欧盟。 Mel dicta offendit et，eros aeque bonorum ius ex。', 8),
            ('info', 'Info', 'zh_cn', '信息', 8),
            ('recent_history', 'Recent History', 'zh_cn', '近期历史', 8),
            ('recent_feedback', 'Feedback', 'zh_cn', '近期反馈', 8),
            ('recent_log', 'Log', 'zh_cn', '近期日志', 8),
            ('crmtiger_app_version', 'CRMTiger App Version : ', 'zh_cn', 'CRMTiger应用版本： ', 8),
            ('historylimit', 'Recent History Limit', 'zh_cn', '近期历史范围', 8),
            ('radious_in_miles', 'Radius in miles', 'zh_cn', '英里半径范围', 8),
            ('recentlimit', 'Recent Event Limit', 'zh_cn', '近期事件范围', 8),
            ('upcoming_events', 'Upcoming Events', 'zh_cn', '近期的活动', 8),
            ('rate_our_app', 'Rate Our App!', 'zh_cn', '评价我们的应用！', 8),
            ('feedback', 'Submit Feedback', 'zh_cn', '提交反馈', 8),
            ('sendfeedback', 'Feedback Send', 'zh_cn', '提交反馈', 8),
            ('emaillimit', 'Email limit', 'zh_cn', '电子邮件限制', 8),
            ('log', 'Log', 'zh_cn', '日志', 8),
            ('logclear', 'Log cleared successfully.', 'zh_cn', '清楚日志', 8),
            ('dialog_recent_history_info', 'You can set from here how many number of records you want to show on Home screen for Recent History.', 'zh_cn', '您可以在此处设置要在主屏幕上显示最近历史记录的记录数。', 8),
            ('proceed_to_upgrade1', 'Proceed to', 'zh_cn', 'Proceed to', 8),
            ('upgradation_message', 'will required logout and login again later.', 'zh_cn', 'will required logout and login again later.', 8),
            ('proceed_to_upgrade', 'Proceed to Upgrade', 'zh_cn', 'Proceed to Upgrade', 8),
            ('module_setting', 'Module Setting', 'zh_cn', '模块设置', 9),
            ('sortbyfield', 'Sort by field', 'zh_cn', '按字段排序', 9),
            ('ascending', 'Ascending  A to Z', 'zh_cn', '升序A至Z.', 9),
            ('descending', 'Descending  Z to A', 'zh_cn', '降序Z至A.', 9),
            ('first_field', 'First Field', 'zh_cn', '第一字段', 9),
            ('second_field', 'Second Field', 'zh_cn', '第二字段', 9),
            ('third_field', 'Third Field', 'zh_cn', '第三字段', 9),
            ('sure_want_restore', 'Are you sure you want to reset to default settings?', 'zh_cn', '您确定要恢复默认设置吗？', 9),
            ('orderlist', 'List Order', 'zh_cn', '清单订单', 9),
            ('module_reset', 'Restore to Default', 'zh_cn', '重置为默认', 9),
            ('display_fields', 'Display Fields', 'zh_cn', '显示字段', 9),
            ('discount_lessthen_100', 'Discount % should be less than 100', 'zh_cn', '折扣百分比应小于100', 10),
            ('select_item', 'Select Item', 'zh_cn', '选择物品', 10),
            ('item_comment', 'Item Comment', 'zh_cn', '物品评论', 10),
            ('record_name', 'Record Name is :', 'zh_cn', 'Record Name is :', 11),
            ('go_back', 'Go Back', 'zh_cn', '退回', 11),
            ('please_enter_shortcut_name', 'Please Enter Shortcut Name', 'zh_cn', '请输入快捷方式名称', 11),
            ('number_not_found', 'Contact Number not found', 'zh_cn', '未找到联系号码', 11),
            ('mail_not_found', 'Mail Address not found', 'zh_cn', '找不到邮件地址', 11),
            ('create_shortcut', 'Create Shortcut', 'zh_cn', '创建快捷方式', 11),
            ('contact_summary', 'Summary', 'zh_cn', '联系摘要', 11),
            ('activites', 'Activities', 'zh_cn', '活动', 11),
            ('details', 'Details', 'zh_cn', '细节', 11),
            ('related', 'Related', 'zh_cn', '相关', 11),
            ('share_link', 'Share record with', 'zh_cn', 'Share record with', 11),
            ('edit', 'Edit', 'zh_cn', 'Edit', 11),
            ('duplicate', 'Duplicate', 'zh_cn', 'Duplicate', 11),
            ('whatsapp', 'Whatsapp', 'zh_cn', 'Whatsapp', 11),
            ('call', 'Call', 'zh_cn', 'Call', 11),
            ('choose_contact_for_call', 'Choose Contact for Call', 'zh_cn', 'Choose Contact for Call', 11),
            ('choose_contact_for_sms', 'Choose Contact for SMS', 'zh_cn', 'Choose Contact for SMS', 11),
            ('choose_contact_for_whatsapp', 'Choose Contact for WhatsApp', 'zh_cn', 'Choose Contact for WhatsApp', 11),
            ('chosse_contact_for_email', 'Choose Email', 'zh_cn', 'Choose Email', 11),
            ('attach_file', 'Attach Files', 'zh_cn', 'Attach Files', 11),
            ('close', 'Close', 'zh_cn', 'Close', 11),
            ('status', 'Status', 'zh_cn', '状态', 11),
            ('stop', 'Stop', 'zh_cn', 'Stop', 11),
            ('zero', '0', 'zh_cn', '0', 11),
            ('record', 'Record', 'zh_cn', 'Record', 11),
            ('voice_note', 'Voice Note', 'zh_cn', 'Voice Note', 11),
            ('tickets', 'Tickets', 'zh_cn', '支持单', 12),
            ('check_out', 'Check Out', 'zh_cn', '退出', 12),
            ('check_in', 'Check In', 'zh_cn', '报到', 12),
            ('select_any', 'Select any', 'zh_cn', '选择任何', 12),
            ('fulldetails', 'Show Full Details', 'zh_cn', '显示全部细节', 12),
            ('checkin', 'Check-in', 'zh_cn', '报到', 12),
            ('navigate', 'Navigate', 'zh_cn', '导航', 12),
            ('product', 'Products', 'zh_cn', '产品', 12),
            ('projectMilestone', 'Project Milestone', 'zh_cn', '里程碑', 12),
            ('projecttask', 'Project Tasks', 'zh_cn', '项目任务', 12),
            ('nearby', 'NearBy', 'zh_cn', '附近', 13),
            ('document', 'Document', 'zh_cn', '文档', 14),
            ('reply', 'Reply', 'zh_cn', '答复', 14),
            ('reply_all', 'Reply All', 'zh_cn', '全部回复', 14),
            ('forward', 'Forward', 'zh_cn', '转发', 14),
            ('action', 'Action', 'zh_cn', '行动', 14),
            ('select_first', 'Select First', 'zh_cn', 'Select First', 14),
            ('commentaddsuccessful', 'Comment added successfull', 'zh_cn', '评论添加成功', 14),
            ('move_to', 'Move to', 'zh_cn', '转到', 14),
            ('attach', 'Attach', 'zh_cn', '附加', 14),
            ('addcoment', 'Add Comment', 'zh_cn', '添加评论', 14),
            ('adddocument', 'Add Document', 'zh_cn', '添加文档', 14),
            ('home', 'Home', 'zh_cn', '主页', 15),
            ('checkout', 'Check-out', 'zh_cn', '退出', 15),
            ('message_search', 'Search by name', 'zh_cn', '信息搜索', 15),
            ('start_shift', 'Start shift', 'zh_cn', '开始班次', 15),
            ('end_shift', 'End shift', 'zh_cn', '结束班次', 15),
            ('today_meeting', 'Meetings', 'zh_cn', '今天会议', 15),
            ('shift_time_track', 'Shift Time Track', 'zh_cn', '班次记录', 15),
            ('logout_msg', 'You have to login again , click', 'zh_cn', 'You have to login again , click', 15),
            ('logout_msg1', 'to continue.', 'zh_cn', 'to continue.', 15),
            ('permission_denied', 'You don\'t have permission to create', 'zh_cn', '您没有创建权限', 15),
            ('history', 'Activity stream', 'zh_cn', '活动流', 15),
            ('search_value', 'Search value :', 'zh_cn', 'Search value :', 15),
            ('feed_back_msg', 'Please enter feedback message', 'zh_cn', '请输入反馈信息', 16),
            ('feed_back_hint_msg', 'Enter feedback message', 'zh_cn', '输入反馈信息', 16),
            ('submit', 'Submit', 'zh_cn', '提交', 16),
            ('check_app_not_installed', 'Application is not currently installed.', 'zh_cn', '目前尚未安装应用程序。', 17),
            ('send_sms_fail_message', 'SMS failed, please try again later!', 'zh_cn', '短信发送失败，请稍后再试！', 17),
            ('documentaddsuccessfully', 'Document Attach successfully', 'zh_cn', '文档成功附加', 17),
            ('send_message', 'Send message', 'zh_cn', 'Send message', 17),
            ('sms_to', 'smsto:', 'zh_cn', 'smsto:', 17),
            ('add_list_message', 'Add List', 'zh_cn', '添加信息列表', 18),
            ('mylist', 'My List', 'zh_cn', '我的列表', 18),
            ('filtername', 'Filter Name', 'zh_cn', '过滤器名称', 18),
            ('selectlist', 'Select a List', 'zh_cn', '选择列表*', 18),
            ('assingedto', 'Assigned To', 'zh_cn', '分配给 *', 18),
            ('selectmodule', 'Select a module', 'zh_cn', '选择模块', 18),
            ('add_list', 'Add Filter', 'zh_cn', '添加过滤器', 18),
            ('recent_event', 'Recent Event', 'zh_cn', '最近的事件', 19),
            ('recent_hostory', 'Recent History', 'zh_cn', '近期历史', 19),
            ('module_specific_settings', 'Module-Specific Settings', 'zh_cn', '特定于模块的设置', 19),
            ('talk_to_us', 'Talk to us', 'zh_cn', '跟我们反馈', 19),
            ('report_a_bug', 'Report A Bug', 'zh_cn', '报告错误', 19),
            ('faq', 'FAQ', 'zh_cn', '常问问题', 19),
            ('selectmodules', 'Select Module', 'zh_cn', '选择模块', 19),
            ('myplan', 'My Plan', 'zh_cn', '我的计划', 19),
            ('message', 'Message', 'zh_cn', '信息', 20),
            ('message_validation', 'Please enter Message', 'zh_cn', '信息验证', 20),
            ('contact_select', 'Please Select contact', 'zh_cn', '请选择联系人', 20),
            ('global_search', 'Global Search', 'zh_cn', 'Global Search', 21),
            ('records', 'Records', 'zh_cn', 'Records', 21),
            ('dont_show_again', 'Don\'t Show Again', 'zh_cn', 'Don\'t Show Again', 22),
            ('skip', 'Skip', 'zh_cn', 'Skip', 22),
            ('file_downloading', 'File Downloading', 'zh_cn', '文件下载', 23),
            ('add_screenshots_optional', 'Add screenshots (optional)', 'zh_cn', '添加屏幕截图（可选）', 24),
            ('describe_your_problem', 'Describe your problem', 'zh_cn', '描述你的问题', 24),
            ('default_filter_shortcut', 'Default Filter Shortcut', 'zh_cn', 'Default Filter Shortcut', 25),
            ('record_shortcut', 'Record Shortcut', 'zh_cn', 'Record Shortcut', 25),
            ('enter_url', 'Please Enter url', 'zh_cn', 'Please Enter url', 26),
            ('new_version_is_avaiable', 'You need to update the app to continue using Please update to continue Older versions will no longer work from today', 'zh_cn', 'You need to update the app to continue using Please update to continue Older versions will no longer work from today', 26),
            ('search_by', 'Search by', 'zh_cn', 'Search by', 27),
            ('selected_filter', 'Selected filter :', 'zh_cn', '选定的过滤器：-', 27),
            ('selected_field', 'Selected field :', 'zh_cn', '选定的字段:', 27),
            ('choose', 'Choose', 'zh_cn', 'Choose', 28),
            ('qr_cardscanner', 'QR Code Scanner', 'zh_cn', 'QR Code Scanner', 28),
            ('error_message_for_scan', 'Could not read the card Try again later.', 'zh_cn', 'Could not read the card Try again later.', 28),
            ('press_start_scan', 'Press to Start Scan', 'zh_cn', 'Press to Start Scan', 28),
            ('line_item_quntity_validation_msg', 'Value should be greater than zero', 'zh_cn', 'Value should be greater than zero', 29),
            ('percentage_msg', 'Percentage should be less than 100', 'zh_cn', 'Percentage should be less than 100', 29),
            ('MSG_NO_DATA', 'No data found!', 'zh_cn', 'No data found!', 29),
            ('MSG_SOMETHING_WRONG', 'Something went wrong!', 'zh_cn', 'Something went wrong!', 29),
            ('MSG_COMING_SOON', 'Coming Soon!', 'zh_cn', 'Coming Soon!', 29),
            ('MSG_UPLOAD_PROFILE_IMAGE', 'Please upload profile image.', 'zh_cn', 'Please upload profile image.', 29),
            ('ALERT_TITLE_LOCATION_ACCESS', 'Location Access', 'zh_cn', 'Location Access', 29),
            ('ALERT_MSG_LOCATION_ACCESS', 'Requires your location to show nearby events.', 'zh_cn', 'Requires your location to show nearby events.', 29),
            ('ALERT_BTN_ALLOW', 'ALLOW', 'zh_cn', 'ALLOW', 29),
            ('ALERT_BTN_DENY', 'DENY', 'zh_cn', 'DENY', 29),
            ('ALERT_MSG_LOCATION_SETTING', 'Not able to fetch your current location. Please check your location settings.', 'zh_cn', 'Not able to fetch your current location. Please check your location settings.', 29),
            ('DELETE_RECORD', 'Delete Record', 'zh_cn', 'Delete Record', 29),
            ('ALERT_MSG_DELETE_SHORTCUT', 'Are you sure want to delete this shortcut?', 'zh_cn', 'Are you sure want to delete this shortcut?', 29),
            ('DELETE_SHORTCUT', 'Delete Shortcut', 'zh_cn', 'Delete Shortcut', 29),
            ('LBL_TERMS', 'By logging in, you agree to our Terms and', 'zh_cn', 'By logging in, you agree to our Terms and', 29),
            ('LBL_CONDITIONS', 'Conditions &', 'zh_cn', 'Conditions &', 29),
            ('ALERT_TITLE', 'Alert', 'zh_cn', 'Alert', 29),
            ('ALERT_BTN_SUBSCRIBE', 'Subscribe', 'zh_cn', 'Subscribe', 29),
            ('MSG_SELECT_MODULE', 'Please select any Module', 'zh_cn', 'Please select any Module', 29),
            ('MSG_SELECT_LIST', 'Please select any List', 'zh_cn', 'Please select any List', 29),
            ('ALERT_MSG_DONT_HAVE_CAMERA', 'You don\'t have camera', 'zh_cn', 'You don\'t have camera', 29),
            ('ALERT_MSG_GALLARY_PERMISSION', 'You don\'t have permission to access gallery.', 'zh_cn', 'You don\'t have permission to access gallery.', 29),
            ('ALERT_MSG_CAMERA_PERMISSION', 'You don\'t have permission to access camera. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Camera on', 'zh_cn', 'You don\'t have permission to access camera. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Camera on', 29),
            ('ALERT_MSG_SPEECH_PERMISSION', 'You don\'t have permission to access Speech Recognition. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Speech Recognition on', 'zh_cn', 'You don\'t have permission to access Speech Recognition. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Speech Recognition on', 29),
            ('BTN_DONE', 'Done', 'zh_cn', 'Done', 29),
            ('COMMENT', 'Comment', 'zh_cn', 'Comment', 29),
            ('FULL_FORM', 'Full Form', 'zh_cn', 'Full Form', 29),
            ('QUICK_CREATE', 'Create', 'zh_cn', 'Create', 29),
            ('LBL_SELECT_FIELDS', 'Select Fields', 'zh_cn', 'Select Fields', 29),
            ('LBL_SELECT_FIELDS', 'Select Fields', 'zh_cn', 'Select Fields', 29),
            ('LBL_SELECT_FIRST_FIELDS', 'Select First Field', 'zh_cn', 'Select First Field', 29),
            ('LBL_SELECT_SECOND_FIELDS', 'Select Second Field', 'zh_cn', 'Select Second Field', 29),
            ('LBL_SELECT_THIRD_FIELDS', 'Select Third Field', 'zh_cn', 'Select Third Field', 29),
            ('LBL_SORT_BY_FIELD', 'Select Sort By Field', 'zh_cn', 'Select Sort By Field', 29),
            ('BTN_RESET_TO_DEFAULT', 'Reset to Default', 'zh_cn', 'Reset to Default', 29),
            ('MSG_SELECT_SORT_BY_FIELD', 'Select Sort by field', 'zh_cn', 'Select Sort by field', 29),
            ('kStrClearBtnTitle', 'Clear', 'zh_cn', 'Clear', 29),
            ('kStrShowMoreBtnTitle', 'Show More', 'zh_cn', 'Show More', 29),
            ('kStrAddActivitiesBtnTitle', 'Add Activities', 'zh_cn', 'Add Activities', 29),
            ('kStrAddCommentPlaceHolder', 'Add your comments here', 'zh_cn', 'Add your comments here', 29),
            ('MSG_ENTER_TO_EMAIL', 'Please enter to field.', 'zh_cn', 'Please enter to field.', 29),
            ('WARNING_FILE', 'File can\'t open.', 'zh_cn', 'File can\'t open.', 29),
            ('MSG_FILE_SAVED', 'File saved.', 'zh_cn', 'File saved.', 29),
            ('WARNING_DOWNLOAD_FAIL', 'Download fail!, please try after sometime.', 'zh_cn', 'Download fail!, please try after sometime.', 29),
            ('LBL_SHORTCUT', 'Shortcut', 'zh_cn', 'Shortcut', 29),
            ('TXT_MESSAGE_PLACEHOLDER', 'Type Message', 'zh_cn', 'Type Message', 29),
            ('ALERT_INSTALL_WHATSAPP', 'Install Whatsapp', 'zh_cn', 'Install Whatsapp', 29),
            ('MSG_NO_MAIL_BOX', 'No MailBox found. Please Create Mailbox', 'zh_cn', 'No MailBox found. Please Create Mailbox', 29),
            ('LBL_WROTE', 'Wrote', 'zh_cn', 'Wrote', 29),
            ('MSG_MAIL_SEND', 'Mail sent', 'zh_cn', 'Mail sent', 29),
            ('log_file_not_found', 'API Log file not found.', 'zh_cn', 'API Log file not found.', 29),
            ('unknown_error', 'An unknown error occurred, try again', 'zh_cn', 'An unknown error occurred, try again', 29),
            ('CTMTigerAppVersion', 'CRMTiger App Version', 'zh_cn', 'CRMTiger App Version', 29),
            ('CTMMobileUpdateMsg', 'CTMobile Ext. Version Update Successfully', 'zh_cn', 'CTMobile Ext. Version Update Successfully', 29),
            ('dialog_Premium_downgrade', 'Downgrade will required logout and login again later', 'zh_cn', 'Downgrade will required logout and login again later', 29),
            ('dialog_Premium', 'Upgrade will required logout and login again later', 'zh_cn', 'Upgrade will required logout and login again later', 29),
            ('Overwrite', 'Overwrite', 'zh_cn', 'Overwrite', 29),
            ('MSGAddressOverwrite1', 'Overwrite the existing address with the selected', 'zh_cn', 'Overwrite the existing address with the selected', 29),
            ('MSGAddressOverwrite2', 'address details?', 'zh_cn', 'address details?', 29),
            ('UPGRADE_PLAN', 'Upgrade Plan', 'zh_cn', 'Upgrade Plan', 29),
            ('DOWNGRADE_PLAN', 'Downgrade Plan', 'zh_cn', 'Downgrade Plan', 29),
            ('UPGRADE_EXTENSION', 'Upgrade Extension', 'zh_cn', 'Upgrade Extension', 29),
            ('UPGRADE_APP', 'Upgrade App', 'zh_cn', 'Upgrade App', 29),
            ('SELECT_OPTION', 'Select Option', 'zh_cn', 'Select Option', 29),
            ('PLEASE_SELECT', 'Please select', 'zh_cn', 'Please select', 29),
            ('MSG_ACCESS_DENIED', 'You don\'t have permission for this module.', 'zh_cn', 'You don\'t have permission for this module.', 29),
            ('MSG_SELECT_RECCURING_MONTH_DAY', 'Please select reccuring day of month.', 'zh_cn', 'Please select reccuring day of month.', 29),
            ('MSG_SELECT_RECCURING_WEEK_DAY', 'Please select reccuring day of week.', 'zh_cn', 'Please select reccuring day of week.', 29),
            ('MSG_SELECT_RECCURING_DAYS', 'Please select reccuring days.', 'zh_cn', 'Please select reccuring days.', 29),
            ('Please select reccuring days.', 'Please select reccuring days.', 'zh_cn', 'Please select reccuring days.', 29),
            ('MSG_SELECT_RECCURING_END_DATE', 'Please select reccuring end date.', 'zh_cn', 'Please select reccuring end date.', 29),
            ('MSG_SELECT_RECCURING_TYPE', 'Please select reccuring type.', 'zh_cn', 'Please select reccuring type.', 29),
            ('FREQ_TIME', 'Times', 'zh_cn', 'Times', 29),
            ('REPEAT_YEARLY', 'Repeat Yearly', 'zh_cn', 'Repeat Yearly', 29),
            ('REPEAT_MONTHLY', 'Repeat Monthly', 'zh_cn', 'Repeat Monthly', 29),
            ('REPEAT_WEEKLY', 'Repeat Weekly', 'zh_cn', 'Repeat Weekly', 29),
            ('REPEAT_DAILY', 'Repeat Daily', 'zh_cn', 'Repeat Daily', 29),
            ('ACTION_TITLE', 'Action Title', 'zh_cn', 'Action Title', 29),
            ('MSG_SELECT_VALID_DATE', 'Please select valid day of month.', 'zh_cn', 'Please select valid day of month.', 29),
            ('MSG_SELECT_VALID_START_DATE', 'Start date should be less than end date.', 'zh_cn', 'Start date should be less than end date.', 29),
            ('MSG_SELECT_VALID_START_TIME', 'Start time should be less than end time.', 'zh_cn', 'Start time should be less than end time.', 29),
            ('LBL_LINEITEM_DETAILS', 'Lineitem Details', 'zh_cn', 'Lineitem Details', 29),
            ('MSG_INVALIDE_DISCOUNT_AMOUNT', 'Discount amount should be less than the total.', 'zh_cn', 'Discount amount should be less than the total.', 29),
            ('VIEW', 'View', 'zh_cn', 'View', 29),
            ('MSG_ENTER_VALID', 'Please enter valid', 'zh_cn', 'Please enter valid', 29),
            ('MSG_ENTER_PERCENTAGE', 'Percentage should be less than 100.', 'zh_cn', 'Percentage should be less than 100.', 29),
            ('ITEM_TOTAL', 'Item Total', 'zh_cn', 'Item Total', 29),
            ('ADJUSTMENT', 'Adjustment', 'zh_cn', 'Adjustment', 29),
            ('TITLE_CHOOSE_IMAGE', 'Choose Image', 'zh_cn', 'Choose Image', 29),
            ('COMPRESS', 'Compress', 'zh_cn', 'Compress', 29),
            ('CHOOSE_ANOTHER_IMAGE', 'Your image size is too large, please select another image', 'zh_cn', 'Your image size is too large, please select another image', 29),
            ('OnDayOfMonth', 'On day of month', 'zh_cn', 'On day of month', 29),
            ('OnDayOfWeek', 'On day of week', 'zh_cn', 'On day of week', 29),
            ('AddAndClose', 'Add & Close', 'zh_cn', 'Add & Close', 29),
            ('Repeat', 'Repeat', 'zh_cn', 'Repeat', 29),
            ('OnDay', 'On day', 'zh_cn', 'On day', 29),
            ('View_Line_Item', 'View Line Item', 'zh_cn', 'View Line Item', 29),
            ('TITLE_IMAGE', 'Image', 'zh_cn', 'Image', 29),
            ('TITLE_ICLOUD', 'iCloud', 'zh_cn', 'iCloud', 29),
            ('GOOGLE', 'Google', 'zh_cn', 'Google', 29),
            ('ALERT_BTN_OKAY', 'Okay', 'zh_cn', 'Okay', 29),
            ('ALERT_TITLE_ACCESS_DENIED', 'Access Denied', 'zh_cn', 'Access Denied', 29),
            ('Dont_Show_Again', 'Don\'t show again', 'zh_cn', 'Don\'t show again', 29),
            ('Skip', 'Skip', 'zh_cn', 'Skip', 29),
            ('Fillter_Name', 'Fillter Name', 'zh_cn', 'Fillter Name', 29),
            ('Fillter_Record_Count', 'Fillter Record Count', 'zh_cn', 'Fillter Record Count', 29),('url_note',  'Note : if your URL of CRM is https://example.com/crm enter that into above box',   'zh_cn',    'Note : if your URL of CRM is https://example.com/crm enter that into above box',   31),
            ('vtiger_url',  'Your vTiger CRM URL',  'zh_cn',    'Your vTiger CRM URL',  31),
            ('msg_doc_read_permission', 'You don\'t have permission to Add either This is read-only or Private Field.',  'zh_cn',    'You don\'t have permission to Add either This is read-only or Private Field.',  31),
            ('CLEAR',   'Clear',    'zh_cn',    'Clear',    31),
            ('Files/photos uploaded successfully',  'Files/photos uploaded successfully',   'zh_cn',    'Files/photos uploaded successfully',   32),
            ('Digital signature saved', 'Digital signature saved',  'zh_cn',    'Digital signature saved',  32),
            ('Please upload Signature or Files/photos', 'Please upload Signature or Files/photos',  'zh_cn',    'Please upload Signature or Files/photos',  32),
            ('Files / Photos',  'Files / Photos',   'zh_cn',    'Files / Photos',   32),
            ('Signature',   'Signature',    'zh_cn',    'Signature',    32),
            ('add_photo_using', 'Add Photo Using',  'zh_cn',    'Add Photo Using',  31),
            ('btn_upload_sign', '(+) Add Signature',    'zh_cn',    '(+) Add Signature',    31),
            ('btn_upload_photo_doc',    '(+) Upload Files/Photos',  'zh_cn',    '(+) Upload Files/Photos',  31),
            ('select_photo_doc_to_upload',  'Please select files/photos to upload', 'zh_cn',    'Please select files/photos to upload', 31),
            ('related_module_title',    'Search from related module and Add to \"Route\"',  'zh_cn',    'Search from related module and Add to \"Route\"',  30),
            ('Route status updated successfully',   'Route status updated successfully',    'zh_cn',    'Route status updated successfully',    32),
            ('Session init failed', 'Session init failed',  'zh_cn',    'Session init failed',  32),
            ('You don\'t have permission to access this resource',  'You don\'t have permission to access this resource',   'zh_cn',    'You don\'t have permission to access this resource',   32),
            ('ctroute_realtedto cannot be empty',   'Could not get the Related To - Try again later',   'zh_cn',    'Could not get the Related To - Try again later',   32),
            ('ctroute_planning cannot be empty',    'Could not get the Route Planning Record - Try again later',    'zh_cn',    'Could not get the Route Planning Record - Try again later',    32),
            ('Something went wrong - Try again later',  'Something went wrong - Try again later',   'zh_cn',    'Something went wrong - Try again later',   32),
            ('sequence updated successfully',   'sequence updated successfully',    'zh_cn',    'sequence updated successfully',    32),
            ('sequence cannot be empty',    'sequence cannot be empty', 'zh_cn',    'sequence cannot be empty', 32),
            ('Shortcut details not saved',  'Shortcut details not saved',   'zh_cn',    'Shortcut details not saved',   32),
            ('Shortcut details saved successfully', 'Shortcut details saved successfully',  'zh_cn',    'Shortcut details saved successfully',  32),
            ('Route save successfully', 'Route save successfully',  'zh_cn',    'Route save successfully',  32),
            ('Record save successfully',    'Record save successfully', 'zh_cn',    'Record save successfully', 32),
            ('No dependency found for picklist',    'No dependency found for picklist', 'zh_cn',    'No dependency found for picklist', 32),
            ('No records found',    'No records found', 'zh_cn',    'No records found', 32),
            ('Outgoing server is not enabled, please configure from CRM',   'Outgoing server is not enabled, please configure from CRM',    'zh_cn',    'Outgoing server is not enabled, please configure from CRM',    32),
            ('Removed Successfully',    'Removed Successfully', 'zh_cn',    'Removed Successfully', 32),
            ('Shortcut has been deleted',   'Shortcut has been deleted',    'zh_cn',    'Shortcut has been deleted',    32),
            ('relation of records removed successfully',    'relation of records removed successfully', 'zh_cn',    'relation of records removed successfully', 32),
            ('relation of records not removed', 'relation of records not removed',  'zh_cn',    'relation of records not removed',  32),
            ('Record has been deleted successfully',    'Record has been deleted successfully', 'zh_cn',    'Record has been deleted successfully', 32),
            ('Time Tracking saved successfully',    'Time Tracking saved successfully', 'zh_cn',    'Time Tracking saved successfully', 32),
            ('Time Tracking updated successfully',  'Time Tracking updated successfully',   'zh_cn',    'Time Tracking updated successfully',   32),
            ('Time Tracking ended successfully',    'Time Tracking ended successfully', 'zh_cn',    'Time Tracking ended successfully', 32),
            ('Time Tracking started successfully',  'Time Tracking started successfully',   'zh_cn',    'Time Tracking started successfully',   32),
            ('record cannot be empty',  'record cannot be empty',   'zh_cn',    'record cannot be empty',   32),
            ('Module is disabled',  'Module is disabled',   'zh_cn',    'Module is disabled',   32),
            ('Shift ended successfully',    'Shift ended successfully', 'zh_cn',    'Shift ended successfully', 32),
            ('Shift started successfully',  'Shift started successfully',   'zh_cn',    'Shift started successfully',   32),
            ('relation of records added successfully',  'relation of records added successfully',   'zh_cn',    'relation of records added successfully',   32),
            ('Comment saved successfully',  'Comment saved successfully',   'zh_cn',    'Comment saved successfully',   32),
            ('Comment not saved',   'Comment not saved',    'zh_cn',    'Comment not saved',    32),
            ('Comment module is not active',    'Comment module is not active', 'zh_cn',    'Comment module is not active', 32),
            ('No Upcoming Event',   'No Upcoming Event',    'zh_cn',    'No Upcoming Event',    32),
            ('No Templates found - create it from Message Templates module',    'No Templates found - create it from Message Templates module', 'zh_cn',    'No Templates found - create it from Message Templates module', 32),
            ('No event or task for this date',  'No event or task for this date',   'zh_cn',    'No event or task for this date',   32),
            ('No filters created',  'No filters created',   'zh_cn',    'No filters created',   32),
            ('Select at least one record to attach',    'Select at least one record to attach', 'zh_cn',    'Select at least one record to attach', 32),
            ('Please select one or more attachments',   'Please select one or more attachments',    'zh_cn',    'Please select one or more attachments',    32),
            ('No event for this month', 'No event for this month',  'zh_cn',    'No event for this month',  32),
            ('No Activity found',   'No Activity found',    'zh_cn',    'No Activity found',    32),
            ('Your feedback is valuable for us - it cannot be empty',   'Your feedback is valuable for us - it cannot be empty',    'zh_cn',    'Your feedback is valuable for us - it cannot be empty',    32),
            ('Could not send mail, Please try later',   'Could not send mail, Please try later',    'zh_cn',    'Could not send mail, Please try later',    32),
            ('Latest Version updated successfully', 'Latest Version updated successfully',  'zh_cn',    'Latest Version updated successfully',  32),
            ('User Location Updated Successfully',  'User Location Updated Successfully',   'zh_cn',    'User Location Updated Successfully',   32),
            ('User Location not Updated Successfully',  'User Location not Updated Successfully',   'zh_cn',    'User Location not Updated Successfully',   32),
            ('SMSNotifier is not enable in CRM. Please enable it first',    'SMSNotifier is not enable in CRM. Please enable it first', 'zh_cn',    'SMSNotifier is not enable in CRM. Please enable it first', 32),
            ('Could not submit your feedback - Please try again later', 'Could not submit your feedback - Please try again later',  'zh_cn',    'Could not submit your feedback - Please try again later',  32),
            ('Thank you for submitting your feedback',  'Thank you for submitting your feedback',   'zh_cn',    'Thank you for submitting your feedback',   32),
            ('Please upload User Image',    'Please upload User Image', 'zh_cn',    'Please upload User Image', 32),
            ('Image Not Uploading, please try again',   'Image Not Uploading, please try again',    'zh_cn',    'Image Not Uploading, please try again',    32),
            ('User Image Uploaded Successfully',    'User Image Uploaded Successfully', 'zh_cn',    'User Image Uploaded Successfully', 32),
            ('Invalid Module name', 'Invalid Module name',  'zh_cn',    'Invalid Module name',  32),
            ('Records Sync Successfully',   'Records Sync Successfully',    'zh_cn',    'Records Sync Successfully',    32),
            ('Values cannot be empty',  'Values cannot be empty',   'zh_cn',    'Values cannot be empty',   32),
            ('Record id is empty',  'Record id is empty',   'zh_cn',    'Record id is empty',   32),
            ('Logout Successfully', 'Logout Successfully',  'zh_cn',    'Logout Successfully',  32),
            ('Please Enable CTMobile Module',   'Please Enable CTMobile Module',    'zh_cn',    'Please Enable CTMobile Module',    32),
            ('Authentication Failed',   'Username and Password do not match',   'zh_cn',    'Username and Password do not match',   32),
            ('Mismatched module information',   'Something gone wrong, please try again later', 'zh_cn',    'Something gone wrong, please try again later', 32),
            ('Field does not exists',   'Please set display fields again',  'zh_cn',    'Please set display fields again',  32),
            ('Module does not exists',  'Module does not exists or disabled by admin',  'zh_cn',    'Module does not exists or disabled by admin',  32),
            ('Month cannot be empty',   'Could not get the Month - Try again later',    'zh_cn',    'Could not get the Month - Try again later',    32),
            ('Year cannot be empty',    'Could not get the Year - Try again later', 'zh_cn',    'Could not get the Year - Try again later', 32),
            ('Date cannot be empty',    'Could not get the Date - Try again later', 'zh_cn',    'Could not get the Date - Try again later', 32),
            ('Userid cannot be empty',  'Could not get the Userid - Try again later',   'zh_cn',    'Could not get the Userid - Try again later',   32),
            ('End Date cannot be empty',    'Could not get the status - Try again later',   'zh_cn',    'Could not get the status - Try again later',   32),
            ('Start Date cannot be empty',  'Could not get the Start Date - Try again later',   'zh_cn',    'Could not get the Start Date - Try again later',   32),
            ('You do not configure SMS Notifier in CRM. Please configure SMS Notifier in your CRM to use this feature', 'You do not configure SMS Notifier in CRM. Please configure SMS Notifier in your CRM to use this feature',  'zh_cn',    'You do not configure SMS Notifier in CRM. Please configure SMS Notifier in your CRM to use this feature',  32),
            ('Longitude cannot be empty',   'Could not get location-Please try again',  'zh_cn',    'Could not get location-Please try again',  32),
            ('Latitude cannot be empty',    'Could not get location-Please try again',  'zh_cn',    'Could not get location-Please try again',  32),
            ('User cannot be empty',    'Could not get the User - Try again later', 'zh_cn',    'Could not get the User - Try again later', 32),
            ('Status cannot be empty',  'Could not get the status - Try again later',   'zh_cn',    'Could not get the status - Try again later',   32),
            ('Required fields not found',   'Required fields not found',    'zh_cn',    'Required fields not found',    32),
            ('Tracking module not active',  'Tracking module not active-Please contact CRM Admin',  'zh_cn',    'Tracking module not active-Please contact CRM Admin',  32),
            ('Missing mandatory input values',  'Missing mandatory input values',   'zh_cn',    'Missing mandatory input values',   32),
            ('No MailBox found. Please Create Mailbox', 'No MailBox found. Please Create Mailbox',  'zh_cn',    'No MailBox found. Please Create Mailbox',  32),
            ('Mail not sent',   'Mail not sent',    'zh_cn',    'Mail not sent',    32),
            ('Mail send successfully',  'Mail send successfully',   'zh_cn',    'Mail send successfully',   32),
            ('Email Id or username not match with your record', 'Email Id or username not match with your record',  'zh_cn',    'Email Id or username not match with your record',  32),
            ('Module not specified',    'Module not specified', 'zh_cn',    'Module not specified', 32),
            ('No messages found',   'No messages found',    'zh_cn',    'No messages found',    32),
            ('No Dependency Found For This Module', 'No Dependency Found For This Module',  'zh_cn',    'No Dependency Found For This Module',  32),
            ('Outgoing server is not Enabled',  'Outgoing server is not Enabled',   'zh_cn',    'Outgoing server is not Enabled',   32),
            ('Outgoing server is Enabled',  'Outgoing server is Enabled',   'zh_cn',    'Outgoing server is Enabled',   32),
            ('Email Attached Successfully', 'Email Attached Successfully',  'zh_cn',    'Email Attached Successfully',  32),
            ('Documents Attached Successfully', 'Documents Attached Successfully',  'zh_cn',    'Documents Attached Successfully',  32),
            ('Login required - Please login again', 'Login required - Please login again',  'zh_cn',    'Login required - Please login again',  32),
            ('time_tracking_module_disable',    'Time tracking module is disable',  'zh_cn',    'Time tracking module is disable',  31),
            ('route_planning_module_disable',   'Route planning module is disable', 'zh_cn',    'Route planning module is disable', 31),
            ('mark_as_held',    'Are you sure you want to mark Event as Held?', 'zh_cn',    'Are you sure you want to mark Event as Held?', 31),
            ('stop_timer_msg',  'You have already started Time tracking for another record, Do you want to stop it first ?',    'zh_cn',    'You have already started Time tracking for another record, Do you want to stop it first ?',    31),
            ('access_denied_routeplanning', 'Access denied for route planning', 'zh_cn',    'Access denied for route planning', 31),
            ('time_spent',  'Time Spent',   'zh_cn',    'Time Spent',   31),
            ('select_user', 'Select User',  'zh_cn',    'Select User',  30),
            ('status_cannot_be_held',   'Status cannot be held for future date start',  'zh_cn',    'Status cannot be held for future date start',  30),
            ('please_select_end_date',  'Please select end date',   'zh_cn',    'Please select end date',   30),
            ('please_select_start_date',    'Please select start date', 'zh_cn',    'Please select start date', 30),
            ('tap_on_plus_icon_for_select_route',   'Tap on + icon to select record for your route.',   'zh_cn',    'Tap on + icon to select record for your route.',   30),
            ('please_enter_notes',  'Please enter notes',   'zh_cn',    'Please enter notes',   30),
            ('please_enter_title',  'Please enter title',   'zh_cn',    'Please enter title',   30),
            ('please_select_date',  'Please Select Date',   'zh_cn',    'Please Select Date',   30),
            ('search_by_date',  'Search by Date',   'zh_cn',    'Search by Date',   30),
            ('shortcut_not_setup_yet',  'Opps shortcut not setup yet!!! Please add shortcut by click on [icon] from record search results or view record screen.',  'zh_cn',    'Opps shortcut not setup yet!!! Please add shortcut by click on [icon] from record search results or view record screen.',  30),
            ('max_upload_size', 'max file Upload exceeds',  'zh_cn',    'max file Upload exceeds',  30),
            ('unselect_all',    'UnSelect All', 'zh_cn',    'UnSelect All', 30),
            ('select_all',  'Select All',   'zh_cn',    'Select All',   30),
            ('please_select_records',   'Please select records',    'zh_cn',    'Please select records',    30),
            ('select_date', 'Select Date',  'zh_cn',    'Select Date',  30),
            ('quantity_in_stock_is',    'Quantity in stock is', 'zh_cn',    'Quantity in stock is', 30),
            ('replies', 'Replies',  'zh_cn',    'Replies',  30),
            ('conversation_require_selection',  'Conversion requires selection of Contact or Organization', 'zh_cn',    'Conversion requires selection of Contact or Organization', 30),
            ('please_select_product',   'Please Select Product',    'zh_cn',    'Please Select Product',    30),
            ('timer_msg',   'You can start timer for single task only at same time',    'zh_cn',    'You can start timer for single task only at same time',    31),
            ('save_start_tracking', 'Save & Start Tracking',    'zh_cn',    'Save & Start Tracking',    31),
            ('lbl_notes',   'Notes',    'zh_cn',    'Notes',    31),
            ('enter_title', 'Enter Title',  'zh_cn',    'Enter Title',  31),
            ('select_module_record',    'Select Module / Record',   'zh_cn',    'Select Module / Record',   31),
            ('lbl_tomorrow',    'Tomorrow', 'zh_cn',    'Tomorrow', 30),
            ('lbl_yesterday',   'Yesterday',    'zh_cn',    'Yesterday',    30),
            ('lbl_today',   'Today',    'zh_cn',    'Today',    30),
            ('time_tracker',    'Time Tracker', 'zh_cn',    'Time Tracker', 31),
            ('time_end',    'End Time', 'zh_cn',    'End Time', 5),
            ('due_date',    'End Date', 'zh_cn',    'End Date', 5),
            ('time_start',  'Time Start',   'zh_cn',    'Time Start',   5),
            ('date_start',  'Start Date',   'zh_cn',    'Start Date',   5),
            ('delete_widget_msg',   'Display widget again by using (+) option', 'zh_cn',    'Display widget again by using (+) option', 15),
            ('no_upcoming_activities',  'No scheduled activities    ',  'zh_cn',    'No scheduled activities    ',  15),
            ('check_in_first',  'Please check-in first',    'zh_cn',    'Please check-in first',    30),
            ('duration',    'Duration', 'zh_cn',    'Duration', 30),
            ('distance',    'Distance', 'zh_cn',    'Distance', 30),
            ('proper_address_message',  'Please enter proper address in record\n',  'zh_cn',    'Please enter proper address in record',    30),
            ('select_status',   'Select Status',    'zh_cn',    'Select Status',    30),
            ('route_planner',   'Route Planner',    'zh_cn',    'Route Planner',    30),
            ('route_planning',  'Route Planning',   'zh_cn',    'Route Planning',   30),
            ('add_route',   'Add Route',    'zh_cn',    'Add Route',    30),
            ('calender_disabled',   'Calendar Module is disabled',  'zh_cn',    'Calendar Module is disabled',  30),
            ('close_dialog',    'Close form',   'zh_cn',    'Close form',   30),
            ('cancel_form_message', 'Are You sure want to close ?', 'zh_cn',    'Are You sure want to close ?', 30),
            ('create_route',    'Create Route', 'zh_cn',    'Create Route', 30),
            ('select_module_create_route',  'Select Module to create Route',    'zh_cn',    'Select Module to create Route',    30),
            ('cancel',  'Cancel',   'zh_cn',    '取消',   30),
            ('assign_route',    'Assign Route', 'zh_cn',    'Assign Route', 30),
            ('route_for',   'Route for',    'zh_cn',    'Route for',    30),
            ('assigned_to', 'Assigned To',  'zh_cn',    'Assigned To',  30),
            ('enter_route_name',    'Enter Route Name', 'zh_cn',    'Enter Route Name', 30),
            ('list',    'List', 'zh_cn',    'List', 30),
            ('map', 'Map',  'zh_cn',    'Map',  30),
            ('other_modules',   'Other Modules',    'zh_cn',    'Other Modules',    15),
            ('shortcut_no_record_msg',  'Opps shortcut not setup\n yet!!! Please add shortcut  by click on + icon from record\n search results or view record screen.', 'zh_cn',    'Opps shortcut not setup\n yet!!! Please add shortcut  by click on + icon from record\n search results or view record screen.', 25),
            ('clear',   'Clear',    'zh_cn',    'Clear',    25),
            ('open',    'Open', 'zh_cn',    'Open', 11),
            ('max_file_msg',    'Too many files selected (max:6)',  'zh_cn',    'Too many files selected (max:6)',  11),
            ('error_voicenote_record',  'Unable to recording voice while another application is recording sound.',  'zh_cn',    'Unable to recording voice while another application is recording sound.',  11),
            ('msg_warning', 'Warning!', 'zh_cn',    'Warning!', 11),
            ('Permision_denied_contact',    'Permission denied to access your contacts',    'zh_cn',    'Permission denied to access your contacts',    15),
            ('no_widget_added', 'Please click + icon to add new widget to your dashboard.', 'zh_cn',    'Please click + icon to add new widget to your dashboard.', 15),
            ('no_data_available',   'Data not available, please check the selected fields', 'zh_cn',    'Data not available, please check the selected fields', 15),
            ('check_out_successfully',  'Check out successfully',   'zh_cn',    'Checked out successfully', 11),
            ('check_in_successfully',   'Check in successfully',    'zh_cn',    'Checked in successfully',  11),
            ('check_out',   'Check out',    'zh_cn',    'Check out',    11),
            ('check_in',    'Check in', 'zh_cn',    'Check in', 11),
            ('navigate',    'Navigate', 'zh_cn',    'Navigate', 11),
            ('save_to_phone_vcard_success', 'VCard Saved to phone successfully',    'zh_cn',    'VCard Saved to phone successfully',    15),
            ('download_vcard_success',  'VCard downloaded successfully',    'zh_cn',    'VCard downloaded successfully',    15),
            ('card_details',    'Card Details', 'zh_cn',    'Card Details', 15),
            ('add_widget',  'Add Widget',   'zh_cn',    'Add Widget',   15),
            ('delete_widget',   'Are you sure to hide widget?', 'zh_cn',    'Are you sure to hide widget?', 15),
            ('already_widgets_added',   'All types of Widget & reports are already added',  'zh_cn',    'All types of Widget & reports are already added',  15),
            ('retry',   'Retry',    'zh_cn',    'Retry',    28),
            ('retake',  'Retake',   'zh_cn',    'Retake',   28),
            ('Reports', 'Reports',  'zh_cn',    'Reports',  15),
            ('Widgets', 'Widgets',  'zh_cn',    'Widgets',  15),
            ('vcard_config',    'Vcard Configuration',  'zh_cn',    'Vcard Configuration',  8),
            ('save_to_phone',   'Save to phone',    'zh_cn',    'Save to phone',    11),
            ('download_vcard',  'Download Vcard',   'zh_cn',    'Download Vcard',   11),
            ('share_vcard', 'Share Vcard',  'zh_cn',    'Share Vcard',  11),
            ('share_record',    'Share Record', 'zh_cn',    'Share Record', 11),
            ('permission_denied_edit',  'You don\'t have permission to edit this record.',  'zh_cn',    'You don\'t have permission to edit this record.',  27),
            ('permission_denied_delete',    'You don\'t have permission to delete this record.',    'zh_cn',    'You don\'t have permission to delete this record.',    27),
            ('Voice_Recording_Started', 'Recording Started',    'zh_cn',    'Recording Started',    12),
            ('Voice_Recording_Stopped', 'Recording Stopped',    'zh_cn',    'Recording Stopped',    12),
            ('SEARCH',  'Search',   'zh_cn',    'Search',   7),
            ('LAST',    'Last', 'zh_cn',    'Last', 7),
            ('FIRST',   'First',    'zh_cn',    'First',    7),
            ('MONDAY',  'Monday',   'zh_cn',    'Monday',   7),
            ('TUESDAY', 'Tuesday',  'zh_cn',    'Tuesday',  7),
            ('WEDNESDAY',   'Wednesday',    'zh_cn',    'Wednesday',    7),
            ('THURSDAY',    'Thursday', 'zh_cn',    'Thursday', 7),
            ('FRIDAY',  'Friday',   'zh_cn',    'Friday',   7),
            ('SATURDAY',    'Saturday', 'zh_cn',    'Saturday', 7),
            ('SUNDAY',  'Sunday',   'zh_cn',    'Sunday',   7),
            ('DAILY',   'Daily',    'zh_cn',    'Daily',    7),
            ('WEEKLY',  'Weekly',   'zh_cn',    'Weekly',   7),
            ('MONTHLY', 'Monthly',  'zh_cn',    'Monthly',  7),
            ('YEARLY',  'Yearly',   'zh_cn',    'Yearly',   7),
            ('asset_tracking',  'Asset tracking',   'zh_cn',    'Asset tracking',   15);",array());
    }

    static function th_th(){
        global $adb;
        $checkQuery = "DELETE FROM ctmobile_language_keyword WHERE keyword_lang = ?";
        $checkResult = $adb->pquery($checkQuery,array('th_th'));

        $adb->pquery("INSERT INTO `ctmobile_language_keyword` (`keyword`, `keyword_name`, `keyword_lang`, `language_keyword`, `sectionid`) VALUES
            ('network_error', 'Network connection error!', 'th_th', 'ข้อผิดพลาดการเชื่อมต่อเครือข่าย!', 1),
            ('connection_check', 'Could not connect to CRM, Please check your Internet connection.', 'th_th', 'ไม่สามารถเชื่อมต่อ CRM, กรุณาตรวจสอบการเชื่อมต่ออินเทอร์เน็ตของคุณ', 1),
            ('update', 'Update', 'th_th', 'อัพเดท', 1),
            ('cancel', 'Cancel', 'th_th', 'ยกเลิก', 1),
            ('ok', 'Ok', 'th_th', 'ตกลง', 1),
            ('more_information', 'Click here for more information.', 'th_th', 'คลิกที่นี่สำหรับข้อมูลเพิ่มเติม', 1),
            ('yes', 'Yes', 'th_th', 'ใช่', 1),
            ('no', 'No', 'th_th', 'ไม่', 1),
            ('click_again_exit', 'Click again to exit', 'th_th', 'คลิกอีกครั้งเพื่อออก', 1),
            ('forpermission', 'You don\'t have permission to view this feature. Please subscribe for Premium version Click here to Subscribe.', 'th_th', 'คุณไม่ได้รับอนุญาติให้เข้าชมฟีเจอร์นี้ สมัครสมาชิกพรีเมี่ยมเพื่อเข้าชม คลิกที่นี่เพื่อสมัครสมาชิกพรีเมี่ยม', 1),
            ('clickhere', 'Click here', 'th_th', 'คลิกที่นี่', 1),
            ('clickhere_subscribe', 'Click here to subscribe premium version', 'th_th', 'คลิกที่นี่เพื่อสมัครเป็นสมาชิกรุ่นพรีเมี่ยม', 1),
            ('clickhere_configure', 'Click here and view how to Configure.', 'th_th', 'คลิกที่นี่และดูวิธีการกำหนดค่า', 1),
            ('please_wait', 'Please Wait…', 'th_th', 'โปรดรอ…', 1),
            ('share__msg', 'Share file with', 'th_th', 'แชร์ข้อมูลกับ', 1),
            ('dialog_camera', 'Camera', 'th_th', 'กล้อง', 1),
            ('dialog_add_file_by', 'Take Photo from', 'th_th', 'ถ่ายภาพจาก', 1),
            ('add', 'Add', 'th_th', 'เพิ่ม', 1),
            ('mail_manager_configured', 'Mail Manager is not configured', 'th_th', 'ยังไม่ได้กำหนดการตั้งค่า Mail manager', 1),
            ('dialog_add_files_by', 'Add Files by', 'th_th', 'เพิ่ิ่มไฟล์โดย', 1),
            ('dialog_drive', 'Drive', 'th_th', 'ขับรถ', 1),
            ('dialog_drop_box', 'Drop Box', 'th_th', 'ดร็อปบ็อกซ์', 1),
            ('dialog_need_signin', 'You need to Sign-in to your Drive account first.', 'th_th', 'คุณจำเป็นต้องลงชื่อเข้าใช้บัญชีไดรฟ์ของคุณก่อน', 1),
            ('dialog_gallery', 'Gallery', 'th_th', 'คลังภาพ', 1),
            ('delete', 'Delete', 'th_th', 'ลบ', 1),
            ('timeoutmessage', 'Oops! Request is taking more time than expected.', 'th_th', 'โอ้! ดูเหมือนคำสั่งจะใช้เวลานานกว่าปกติ', 1),
            ('gps_location_message', 'GPS is not enabled. Please turn it on to get your near by locations.', 'th_th', 'จีพีเอสไม่ได้เปิดใช้งาน กรุณาเปิดจีพีเอสเพื่อตรวจสอบสถานที่ใกล้เคียง', 1),
            ('sure_want_delete', 'Are you sure want to delete ?', 'th_th', 'คุณแน่ใจหรือว่าต้องการลบ?', 1),
            ('select', 'Select', 'th_th', 'เลือก', 1),
            ('msgforrecordaudio', 'Minimum record duration one second.', 'th_th', 'ใส่ข้อมูลขั้นต่ำ 1 วินาที', 1),
            ('permission_storage', 'Permission denied to read your External storage', 'th_th', 'ไม่อนุญาติให้เข้าถึงข้อมูลจากอุปกรณ์ภายนอก', 1),
            ('send_permission_msg', 'Send message permission denied', 'th_th', 'ไม่อนุญาติให้ส่งข้อความ', 1),
            ('choosefile', 'Choose File', 'th_th', 'เลือกไฟล์', 1),
            ('enter', 'Enter', 'th_th', 'เข้าสู่', 1),
            ('select_an_option', 'Select an Option', 'th_th', 'เลือกตัวเลือก', 1),
            ('email_validation', 'Email is not valid', 'th_th', 'อีเมลไม่ถูกต้อง', 1),
            ('please_enter', 'Please Enter', 'th_th', 'กรุณาใส่', 1),
            ('website_validation_text', 'Website URL is not valid', 'th_th', 'URL ของเว็บไซต์ไม่ถูกต้อง', 1),
            ('selectvalue', 'Select value first', 'th_th', 'เลือกค่าก่อน', 1),
            ('email', 'Email', 'th_th', 'อีเมล์', 1),
            ('enter_email_address', 'Enter email address', 'th_th', 'ป้อนที่อยู่อีเมล', 1),
            ('email_address_not_correct', 'Email address incorrect', 'th_th', 'ที่อยู่อีเมลที่ไม่ถูกต้อง', 1),
            ('pls_enter_subject', 'Please Enter Subject', 'th_th', 'กรุณาใส่หัวเรื่อง', 1),
            ('attachFiles', 'Attached File', 'th_th', 'ไฟล์ที่แนบ', 1),
            ('from', 'From', 'th_th', 'จาก', 1),
            ('to', 'To', 'th_th', 'ถึง', 1),
            ('call_permission_msg', 'Call permission denied', 'th_th', 'ไม่ได้รับอนุญาติให้โทร', 1),
            ('no_records', 'No records found', 'th_th', 'ไม่เจอบันทึก', 1),
            ('fullform', 'Create New', 'th_th', 'สร้างใหม่', 1),
            ('save', 'Save', 'th_th', 'บันทึก', 1),
            ('total', 'Total', 'th_th', 'รวมทั้งหมด', 1),
            ('discount', 'Discount', 'th_th', 'ส่วนลด', 1),
            ('price', 'Price', 'th_th', 'ราคา', 1),
            ('quantity', 'Quantity', 'th_th', 'ปริมาณ', 1),
            ('select_module', 'Select Module', 'th_th', 'เลือกโมดูล', 1),
            ('item_list', 'Item List', 'th_th', 'รายการไอเท็ม', 1),
            ('quickcreate', 'Quick Create', 'th_th', 'สร้างด่วน', 1),
            ('overwrite_msg_part1', 'Overwrite the existing address with the selected', 'th_th', 'เขียนทับที่อยู่เดิมด้วยที่อยู่ใหม่', 1),
            ('once_in_every', 'Once in every', 'th_th', '1ครั้งในทุกๆ', 1),
            ('overwrite_msg_part2', 'address details?', 'th_th', 'รายละเอียดที่อยู่?', 1),
            ('add_item', 'Add Item', 'th_th', 'เพิ่มรายการ', 1),
            ('recordsave', 'Record saved successfully', 'th_th', 'บันทึกสำเร็จ', 1),
            ('recordnotsave', 'Could not save record. Try again later', 'th_th', 'ไม่สามารถบันทึกข้อมูล ลองอีกครั้งในภายหลัง', 1),
            ('minutes', 'Minutes', 'th_th', 'นาที', 1),
            ('hours', 'Hours', 'th_th', 'ชั่วโมง', 1),
            ('days', 'Days', 'th_th', 'วัน', 1),
            ('on', 'On', 'th_th', 'บน', 1),
            ('day_of_the_month', 'day of the month', 'th_th', 'วันของเดือน', 1),
            ('list_price', 'List Price', 'th_th', 'รายการราคา', 1),
            ('add_record', 'Add Record', 'th_th', 'เพิ่มการบันทึก', 1),
            ('add_product', 'Add Product', 'th_th', 'เพิ่มสินค้า', 1),
            ('add_service', 'Add Service', 'th_th', 'เพิ่มบริการ', 1),
            ('discountin', 'Discount in %', 'th_th', 'ส่วนลดเป็น %', 1),
            ('unitprice', 'Unit price', 'th_th', 'ราคาต่อหน่วย', 1),
            ('netprice', 'Net price', 'th_th', 'ราคาขาดตัว', 1),
            ('comments', 'Comments', 'th_th', 'ความคิดเห็น', 1),
            ('add_close', 'Add & Close', 'th_th', 'เพิ่มและปิด', 1),
            ('fetching_rout_message', 'Fetching route, Please wait…', 'th_th', 'กำลังดึงข้อมูลเส้นทาง กรุณารอสักครู่', 1),
            ('setting', 'Settings', 'th_th', 'การตั้งค่า', 1),
            ('utc', 'UTC', 'th_th', 'UTC', 1),
            ('in', 'In', 'th_th', 'ใน', 1),
            ('days_ago', 'days ago', 'th_th', 'วันที่ผ่านมา', 1),
            ('mins_ago', 'Minutes ago', 'th_th', 'นาทีที่ผ่านมา', 1),
            ('justnow', 'Just now', 'th_th', 'เมื่อสักครู่', 1),
            ('hours_ago', 'hours ago', 'th_th', 'ชั่วโมงที่ผ่านมา', 1),
            ('in_1_day', 'In 1 day', 'th_th', 'ใน 1 วัน', 1),
            ('scanqrcode', 'Asset / Card scanner', 'th_th', 'เครื่องสแกนเนอร์การ์ด', 1),
            ('call_log', 'Call Log', 'th_th', 'บันทึกการโทร', 1),
            ('voice_message', 'Hi', 'th_th', 'สวัสดี', 1),
            ('voice_message1', 'What can I search for you in', 'th_th', 'ให้ฉันช่วยคุณได้อย่างไร ใน', 1),
            ('live_tracking', 'Live Tracking', 'th_th', 'การติดตามแบบ live', 1),
            ('mailmanager', 'Mail Manager', 'th_th', 'ตัวจัดการอีเมล', 1),
            ('my_location', 'My location', 'th_th', 'ตำแหน่งของฉัน', 1),
            ('created_on', 'Created On', 'th_th', 'สร้างเมื่อ', 1),
            ('modified_on', 'Modified On', 'th_th', 'แก้ไขล่าสุดเมื่อ', 1),
            ('enter_comments', 'Enter Comments', 'th_th', 'ใส่ความคิดเห็น', 1),
            ('viewmore', 'View More', 'th_th', 'ดูเพิ่มเติม', 1),
            ('viewless', 'View Less', 'th_th', 'ดูน้อยลง', 1),
            ('gotofullform', 'Go to Full Form', 'th_th', 'ดูทั้งหมด', 1),
            ('post', 'Post', 'th_th', 'Post', 1),
            ('url', 'URL', 'th_th', 'URL', 1),
            ('dialog_title_text_back_color', 'Select a Text Background Color', 'th_th', 'เลือกสีพื้นหลังข้อความ', 1),
            ('event_or_task', 'Add event/task', 'th_th', 'เพิ่มกิจกรรม / งาน', 1),
            ('shortcut', 'Shortcuts', 'th_th', 'ทางลัด', 1),
            ('select_field', 'Select Field', 'th_th', 'เลือกฟิลด์', 1),
            ('share', 'Share', 'th_th', 'แบ่งปัน', 1),
            ('title_insert_link', 'Insert Link', 'th_th', 'แทรกลิงก์', 1),
            ('addyourcommentshere', 'Add your comments here', 'th_th', 'เพิ่มความคิดเห็นของคุณที่นี่', 1),
            ('nocomment', 'No Comments', 'th_th', 'ไม่มีความคิดเห็น', 1),
            ('leads', 'Leads', 'th_th', 'โอกาส', 1),
            ('true_val', 'true', 'th_th', 'จริง', 1),
            ('noresult', 'No Result', 'th_th', 'ไม่มีผลลัพธ์', 1),
            ('version', 'Version', 'th_th', 'รุ่น', 1),
            ('convert_lead', 'Convert Lead', 'th_th', 'เปลี่ยนโอกาสเป็น', 1),
            ('app_name', 'CRMTiger', 'th_th', 'CRMTiger', 1),
            ('enter_url', 'Please Enter url', 'th_th', 'โปรดป้อน URL', 1),
            ('help', 'Help', 'th_th', 'ช่วยเหลือ', 1),
            ('contact_us', 'Contact Us', 'th_th', 'ติดต่อเรา', 1),
            ('updates', 'Updates', 'th_th', 'อัพเดท', 1),
            ('logout', 'LogOut', 'th_th', 'ออกจากระบบ', 1),
            ('busnies_cardscanner', 'Business Card Scanner', 'th_th', 'เครื่องสแกนนามบัตร', 1),
            ('sure_want_logout', 'Are you sure want to logout ?', 'th_th', 'คุณแน่ใจว่าต้องการออกจากระบบ?', 1),
            ('logout_message', 'Logout successfully', 'th_th', 'ออกจากระบบเรียบร้อยแล้ว', 1),
            ('all', 'All', 'th_th', 'ทั้งหมด', 1),
            ('add_event', 'Add event', 'th_th', 'เพิ่มเหตุการณ์', 1),
            ('add_task', 'Add Task', 'th_th', 'เพิ่มงาน', 1),
            ('next', 'Next', 'th_th', 'ต่อไป', 1),
            ('terms_conditions', 'Terms and Conditions', 'th_th', 'Terms and Conditions', 1),
            ('login', 'Login', 'th_th', 'เข้าสู่ระบบ', 2),
            ('privacy_policay', 'By logging in, you agree to our Terms and Conditions & Privacy Policy', 'th_th', 'เมื่อคุณเข้าสู่ระบบ คุณตกลงยอมรับข้อกำหนดและเงื่อนไขและนโยบายความเป็นส่วนตัวของเรา', 2),
            ('copyright', 'Copyright © 2020 CRMTiger Version', 'th_th', 'ลิขสิทธิ์© 2019 CRMTiger รุ่น', 2),
            ('enter_username', 'Please enter username', 'th_th', 'กรุณากรอกชื่อผู้ใช้', 2),
            ('enter_password', 'Please enter password', 'th_th', 'กรุณาใส่รหัสผ่าน', 2),
            ('remanberme', 'Remember Me', 'th_th', 'จดจำฉัน', 2),
            ('forgot_password', 'Forgot password?', 'th_th', 'ลืมรหัสผ่าน?', 2),
            ('privacy_policay1', 'Privacy Policy', 'th_th', 'นโยบายความเป็นส่วนตัว', 2),
            ('contactsupportmsg', 'Something went wrong. \\n please Click here to contact support.', 'th_th', 'อะไรบางอย่างผิดปกติ. โปรดคลิกที่นี่เพื่อติดต่อฝ่ายสนับสนุน', 2),
            ('enter_username_password', 'Entered Username or Password is wrong', 'th_th', 'ป้อนชื่อผู้ใช้หรือรหัสผ่านไม่ถูกต้อง', 2),
            ('server_issue_occured', 'Server issues occurred', 'th_th', 'ปัญหาที่เกิดขึ้นเซิร์ฟเวอร์', 2),
            ('password', 'Password', 'th_th', 'รหัสผ่าน', 3),
            ('user_name', 'Username', 'th_th', 'ชื่อผู้ใช้', 3),
            ('reset_pwd', 'Reset Password', 'th_th', 'รีเซ็ตรหัสผ่าน', 3),
            ('forgot_password_title', 'Forgot password', 'th_th', 'ลืมรหัสผ่าน', 3),
            ('enter_user_name', 'Enter user name', 'th_th', 'ป้อนชื่อผู้ใช้', 3),
            ('cc', 'Cc', 'th_th', 'Cc', 4),
            ('body', 'Body', 'th_th', 'Body', 4),
            ('bcc', 'BCC', 'th_th', 'BCC', 4),
            ('dialog_title_text_color', 'Select a Text Color', 'th_th', 'เลือกสีข้อความ', 4),
            ('date', 'Date', 'th_th', 'วันที่', 4),
            ('subject', 'Subject', 'th_th', 'เรื่อง', 4),
            ('composeMail', 'Compose Mail', 'th_th', 'เขียนจดหมาย', 4),
            ('send', 'Send', 'th_th', 'ส่ง', 4),
            ('select_message', 'Select message', 'th_th', 'เลือกข้อความ', 4),
            ('title_insert_table', 'Insert Table', 'th_th', 'แทรกตาราง', 4),
            ('log_file_sms', 'I agree to Share API Log to Technical team for further troubleshooting', 'th_th', 'ฉันตกลงที่จะแชร์บันทึก API กับทีมเทคนิคสำหรับการแก้ไขปัญหาเพิ่มเติม', 5),
            ('edit_record', 'Edit Records', 'th_th', 'แก้ไขประวัติ', 5),
            ('select_time', 'Select Time', 'th_th', 'เลือกเวลา', 5),
            ('edit_item', 'Edit Item', 'th_th', 'แก้ไขรายการ', 5),
            ('items_total', 'Items Total', 'th_th', 'รายการทั้งหมด', 5),
            ('number_less_then_31', 'Number should be less than 31', 'th_th', 'จำนวนไม่ควรน้อยกว่า 31', 5),
            ('users', 'Users', 'th_th', 'ผู้ใช้', 5),
            ('groups', 'Groups', 'th_th', 'กลุ่ม', 5),
            ('txt_note_for_file', 'Note : Existing attachments(images/files) will be replaced', 'th_th', 'หมายเหตุ: ไฟล์ที่แนบ(รูปภาพ / ไฟล์) จะถูกแทนที่', 5),
            ('greaterdatetime', 'End DateTime should be greater than Start DateTime', 'th_th', 'วัน/เวลาที่สิ้นสุด ควรมากกว่า วัน/เวลาเริ่มต้น', 5),
            ('until', 'Until', 'th_th', 'จนกระทั่ง', 5),
            ('organizations', 'Organizations', 'th_th', 'องค์กร', 6),
            ('contacts', 'Contacts', 'th_th', 'รายชื่อผู้ติดต่อ', 6),
            ('opportunity', 'Opportunity', 'th_th', 'โอกาส', 6),
            ('lbl_sun', 'SUN', 'th_th', 'อา', 7),
            ('lbl_mon', 'MON', 'th_th', 'จ.', 7),
            ('lbl_tue', 'TUE', 'th_th', 'อ.', 7),
            ('lbl_wed', 'WED', 'th_th', 'พ.', 7),
            ('lbl_thu', 'THU', 'th_th', 'พฤ.', 7),
            ('lbl_fri', 'FRI', 'th_th', 'ศ.', 7),
            ('lbl_sat', 'SAT', 'th_th', 'ส.', 7),
            ('lbl_1', '1', 'th_th', '1', 7),
            ('lbl_2', '2', 'th_th', '2', 7),
            ('lbl_3', '3', 'th_th', '3', 7),
            ('lbl_4', '4', 'th_th', '4', 7),
            ('lbl_5', '5', 'th_th', '5', 7),
            ('lbl_6', '6', 'th_th', '6', 7),
            ('lbl_7', '7', 'th_th', '7', 7),
            ('lbl_8', '8', 'th_th', '8', 7),
            ('lbl_9', '9', 'th_th', '9', 7),
            ('lbl_10', '10', 'th_th', '10', 7),
            ('lbl_11', '11', 'th_th', '11', 7),
            ('lbl_12', '12', 'th_th', '12', 7),
            ('lbl_13', '13', 'th_th', '13', 7),
            ('lbl_14', '14', 'th_th', '14', 7),
            ('lbl_15', '15', 'th_th', '15', 7),
            ('lbl_16', '16', 'th_th', '16', 7),
            ('lbl_17', '17', 'th_th', '17', 7),
            ('lbl_18', '18', 'th_th', '18', 7),
            ('lbl_19', '19', 'th_th', '19', 7),
            ('lbl_20', '20', 'th_th', '20', 7),
            ('lbl_21', '21', 'th_th', '21', 7),
            ('lbl_22', '22', 'th_th', '22', 7),
            ('lbl_23', '23', 'th_th', '23', 7),
            ('lbl_24', '24', 'th_th', '24', 7),
            ('lbl_25', '25', 'th_th', '25', 7),
            ('lbl_26', '26', 'th_th', '26', 7),
            ('lbl_27', '27', 'th_th', '27', 7),
            ('lbl_28', '28', 'th_th', '28', 7),
            ('lbl_29', '29', 'th_th', '29', 7),
            ('lbl_30', '30', 'th_th', '30', 7),
            ('lbl_31', '31', 'th_th', '31', 7),
            ('lbl_32', '32', 'th_th', '32', 7),
            ('lbl_33', '33', 'th_th', '33', 7),
            ('lbl_34', '34', 'th_th', '34', 7),
            ('lbl_35', '35', 'th_th', '35', 7),
            ('lbl_36', '36', 'th_th', '36', 7),
            ('lbl_37', '37', 'th_th', '37', 7),
            ('lbl_38', '38', 'th_th', '38', 7),
            ('lbl_39', '39', 'th_th', '39', 7),
            ('lbl_40', '40', 'th_th', '40', 7),
            ('lbl_41', '41', 'th_th', '41', 7),
            ('lbl_42', '42', 'th_th', '42', 7),
            ('current_date', 'current date', 'th_th', 'วันที่ปัจจุบัน', 7),
            ('event', 'Events', 'th_th', 'เหตุการณ์', 7),
            ('calendar', 'Calendar', 'th_th', 'ปฏิทิน', 7),
            ('latest_version', 'Latest Version :', 'th_th', 'รุ่นล่าสุด :', 8),
            ('expire_on', 'Next renewal date : ', 'th_th', 'วันที่ต่ออายุถัดไป: ', 8),
            ('ctmobile_ext_version', 'CTMobile Ext. Version : ', 'th_th', 'CTMobile Ext เวอร์ชัน:', 8),
            ('you_have_latest_version', 'You already have latest version', 'th_th', 'คุณมีอยู่แล้วรุ่นล่าสุด', 8),
            ('latest_version1', 'You Already have latest version', 'th_th', 'คุณมีเวอร์ชันล่าสุด', 8),
            ('upgreaded', 'Upgrade', 'th_th', 'อัพเกรด', 8),
            ('downgrade', 'Downgrade', 'th_th', 'ดาวน์เกรด', 8),
            ('dialog_recent_event_info', 'You can set from here how many number of records you want to show on Home screen for Recent Event.', 'th_th', 'คุณสามารถกำหนดจำนวนบันทึกที่ต้องการแสดงบนหน้าจอหลักสำหรับเหตุการณ์ล่าสุดได้จากที่นี่', 8),
            ('dialog_feedback_info', 'You can submit your feedback with description , our team will check your feedback and get back to you.', 'th_th', '
คุณสามารถส่งความคิดเห็นพร้อมคำอธิบาย ทีมของเราจะตรวจสอบความคิดเห็นของคุณและติดต่อกลับ', 8),
            ('dialog_log_info', 'Log functionality is used for customer support / help , If you are facing any issues in app or any module or functionality is not working proper then you can enable share log with our development team.', 'th_th', 'ฟังก์ชันบันทึก Log ใช้สำหรับการสนับสนุนและช่วยเหลือลูกค้า หากคุณประสบปัญหาการใช้งานใดๆ ในแอพหรือโมดูล หรือฟังก์ชันการทำงานนั้นทำงานไม่ถูกต้อง คุณสามารถเปิดฟังก์ชันบันทึก Log เพื่อแชร์กับทีมพัฒนาของเราได้', 8),
            ('info', 'Info', 'th_th', 'ข้อมูล', 8),
            ('recent_history', 'Recent History', 'th_th', 'ประวัติล่าสุด', 8),
            ('recent_feedback', 'Feedback', 'th_th', 'ข้อเสนอแนะ', 8),
            ('recent_log', 'Log', 'th_th', 'บันทึก', 8),
            ('crmtiger_app_version', 'CRMTiger App Version : ', 'th_th', 'CRMTiger App เวอร์ชัน:', 8),
            ('historylimit', 'Recent History Limit', 'th_th', 'ขีดจำกัดของประวัติล่าสุด', 8),
            ('radious_in_miles', 'Radius in miles', 'th_th', 'รัศมีเป็นไมล์', 8),
            ('recentlimit', 'Recent Event Limit', 'th_th', 'ขีดจำกัดของเหตุการณ์ล่าสุด', 8),
            ('upcoming_events', 'Upcoming Events', 'th_th', 'กิจกรรมที่จะเกิดขึ้น', 8),
            ('rate_our_app', 'Rate Our App!', 'th_th', 'ให้คะแนนแอพของเรา', 8),
            ('feedback', 'Submit Feedback', 'th_th', 'ส่งความคิดเห็น', 8),
            ('sendfeedback', 'Feedback Send', 'th_th', 'ความคิดเห็นถูกส่ง', 8),
            ('emaillimit', 'Email limit', 'th_th', 'ขีดจำกัดของอีเมล', 8),
            ('log', 'Log', 'th_th', 'บันทึก', 8),
            ('logclear', 'Log cleared successfully.', 'th_th', 'ล้างข้อมูลประวัติลำเร็จ', 8),
            ('dialog_recent_history_info', 'You can set from here how many number of records you want to show on Home screen for Recent History.', 'th_th', '
คุณสามารถกำหนดจำนวนบันทึกที่ต้องการแสดงบนหน้าจอหลักสำหรับประวัติล่าสุดได้จากที่นี่', 8),
            ('proceed_to_upgrade1', 'Proceed to', 'th_th', 'ดำเนินการไปที่', 8),
            ('upgradation_message', 'will required logout and login again later.', 'th_th', 'จะต้องออกจากระบบและเข้าสู่ระบบอีกครั้งในภายหลัง', 8),
            ('proceed_to_upgrade', 'Proceed to Upgrade', 'th_th', 'ดำเนินการอัพเกรด', 8),
            ('module_setting', 'Module Setting', 'th_th', 'การตั้งค่าโมดูล', 9),
            ('sortbyfield', 'Sort by field', 'th_th', 'เรียงลำดับตามฟิลด์', 9),
            ('ascending', 'Ascending  A to Z', 'th_th', 'เรียงลำดับจาก A ถึง Z', 9),
            ('descending', 'Descending  Z to A', 'th_th', 'เรียงลำดับจาก Z ถึง A', 9),
            ('first_field', 'First Field', 'th_th', 'ฟิลด์แรก', 9),
            ('second_field', 'Second Field', 'th_th', 'ฟิลด์สอง', 9),
            ('third_field', 'Third Field', 'th_th', 'ฟิลด์สาม', 9),
            ('sure_want_restore', 'Are you sure you want to reset to default settings?', 'th_th', 'แน่ใจไหมว่าต้องการรีเซ็ตเป็นการตั้งค่าเริ่มต้น', 9),
            ('orderlist', 'List Order', 'th_th', 'ลำดับรายการ', 9),
            ('module_reset', 'Restore to Default', 'th_th', 'รีเซ็ตเป็นการตั้งค่าเริ่มต้น', 9),
            ('display_fields', 'Display Fields', 'th_th', 'แสดงฟิลด์', 9),
            ('discount_lessthen_100', 'Discount % should be less than 100', 'th_th', 'ส่วนลด% ควรจะน้อยกว่า 100', 10),
            ('select_item', 'Select Item', 'th_th', 'เลือกรายการ', 10),
            ('item_comment', 'Item Comment', 'th_th', 'ความคิดเห็นของรายการ', 10),
            ('record_name', 'Record Name is :', 'th_th', 'ชื่อที่บันทึกคือ :', 11),
            ('go_back', 'Go Back', 'th_th', 'กลับไป', 11),
            ('please_enter_shortcut_name', 'Please Enter Shortcut Name', 'th_th', 'กรุณาใส่ชื่อทางลัด', 11),
            ('number_not_found', 'Contact Number not found', 'th_th', 'เบอร์ติดต่อไม่พบ', 11),
            ('mail_not_found', 'Mail Address not found', 'th_th', 'ไม่พบอีเมล์', 11),
            ('create_shortcut', 'Create Shortcut', 'th_th', 'สร้างทางลัด', 11),
            ('contact_summary', 'Summary', 'th_th', 'สรุป', 11),
            ('activites', 'Activities', 'th_th', 'กิจกรรม', 11),
            ('details', 'Details', 'th_th', 'รายละเอียด', 11),
            ('related', 'Related', 'th_th', 'ที่เกี่ยวข้อง', 11),
            ('share_link', 'Share record with', 'th_th', 'แบ่งปันบันทึกกับ', 11),
            ('edit', 'Edit', 'th_th', 'แก้ไข', 11),
            ('duplicate', 'Duplicate', 'th_th', 'ซ้ำ', 11),
            ('whatsapp', 'Whatsapp', 'th_th', 'Whatsapp', 11),
            ('call', 'Call', 'th_th', 'โทร', 11),
            ('choose_contact_for_call', 'Choose Contact for Call', 'th_th', 'เลือกผู้ติดต่อสำหรับการโทร', 11),
            ('choose_contact_for_sms', 'Choose Contact for SMS', 'th_th', 'เลือกผู้ติดต่อสำหรับการส่งข้อความ SMS', 11),
            ('choose_contact_for_whatsapp', 'Choose Contact for WhatsApp', 'th_th', 'เลือกผู้ติดต่อสำหรับการส่งข้อความ Whatapps', 11),
            ('chosse_contact_for_email', 'Choose Email', 'th_th', 'เลือกอีเมล์', 11),
            ('attach_file', 'Attach Files', 'th_th', 'แนบไฟล์', 11),
            ('close', 'Close', 'th_th', 'ปิด', 11),
            ('status', 'Status', 'th_th', 'สถานะ', 11),
            ('stop', 'Stop', 'th_th', 'หยุด', 11),
            ('zero', '0', 'th_th', '0', 11),
            ('record', 'Record', 'th_th', 'บันทึก', 11),
            ('voice_note', 'Voice Note', 'th_th', 'บันทึกเสียง', 11),
            ('tickets', 'Tickets', 'th_th', 'ตั๋ว', 12),
            ('check_out', 'Check Out', 'th_th', 'เช็คเอาท์', 12),
            ('check_in', 'Check In', 'th_th', 'เช็คอิน', 12),
            ('select_any', 'Select any', 'th_th', 'เลือกข้อมูลใดก็ได้', 12),
            ('fulldetails', 'Show Full Details', 'th_th', 'แสดงรายละเอียดแบบเต็ม', 12),
            ('checkin', 'Check-in', 'th_th', 'การเช็คอิน', 12),
            ('navigate', 'Navigate', 'th_th', 'นำทาง', 12),
            ('product', 'Products', 'th_th', 'ผลิตภัณฑ์', 12),
            ('projectMilestone', 'Project Milestone', 'th_th', 'เป้าหมายสำคัญของโครงการ', 12),
            ('projecttask', 'Project Tasks', 'th_th', 'สิ่งที่ต้องทำของโครงการ', 12),
            ('nearby', 'NearBy', 'th_th', 'ใกล้เคียง', 13),
            ('document', 'Document', 'th_th', 'เอกสาร', 14),
            ('reply', 'Reply', 'th_th', 'ตอบ', 14),
            ('reply_all', 'Reply All', 'th_th', 'ตอบทั้งหมด', 14),
            ('forward', 'Forward', 'th_th', 'ส่งต่อ', 14),
            ('action', 'Action', 'th_th', 'สิ่่งที่ต้องทำ (Need more context)', 14),
            ('select_first', 'Select First', 'th_th', 'เลือกสิ่งแรก', 14),
            ('commentaddsuccessful', 'Comment added successfull', 'th_th', 'เพิ่มความคิดเห็นสำเร็จ', 14),
            ('move_to', 'Move to', 'th_th', 'ย้ายไปที่', 14),
            ('attach', 'Attach', 'th_th', 'แนบ', 14),
            ('addcoment', 'Add Comment', 'th_th', 'เพิ่มความเห็น', 14),
            ('adddocument', 'Add Document', 'th_th', 'เพิ่มเอกสาร', 14),
            ('home', 'Home', 'th_th', 'บ้าน', 15),
            ('checkout', 'Check-out', 'th_th', 'เช็คเอาท์', 15),
            ('message_search', 'Search by name', 'th_th', 'ค้นหาตามชื่อ', 15),
            ('start_shift', 'Start shift', 'th_th', 'กะเริ่มต้น', 15),
            ('end_shift', 'End shift', 'th_th', 'กะสิ้นสุด', 15),
            ('today_meeting', 'Meetings', 'th_th', 'การประชุม', 15),
            ('shift_time_track', 'Shift Time Track', 'th_th', 'เปลี่ยนเวลาติดตาม', 15),
            ('logout_msg', 'You have to login again , click', 'th_th', 'คุณต้องเข้าสู่ระบบอีกครั้งคลิก', 15),
            ('logout_msg1', 'to continue.', 'th_th', 'เพื่อจะดำเนินการต่อ.', 15),
            ('permission_denied', 'You don\'t have permission to create', 'th_th', 'คุณไม่ได้รับอนุญาตให้สร้าง', 15),
            ('history', 'Activity stream', 'th_th', 'ประวัติ', 15),
            ('search_value', 'Search value :', 'th_th', 'ค้นหาค่า:', 15),
            ('feed_back_msg', 'Please enter feedback message', 'th_th', 'กรุณาใส่ข้อความ ในความคิดเห็น', 16),
            ('feed_back_hint_msg', 'Enter feedback message', 'th_th', 'ป้อนข้อความความคิดเห็น', 16),
            ('submit', 'Submit', 'th_th', 'ส่ง (need more context)', 16),
            ('check_app_not_installed', 'Application is not currently installed.', 'th_th', 'แอพลิเคชันไม่ได้ติดตั้งในปัจจุบัน', 17),
            ('send_sms_fail_message', 'SMS failed, please try again later!', 'th_th', 'SMS ล้มเหลวโปรดลองอีกครั้งในภายหลัง!', 17),
            ('documentaddsuccessfully', 'Document Attach successfully', 'th_th', 'แนบเอกสารสำเร็จ', 17),
            ('send_message', 'Send message', 'th_th', 'ส่งข้อความ', 17),
            ('sms_to', 'smsto:', 'th_th', 'ส่ง SMS ไปที่ :', 17),
            ('add_list_message', 'Add List', 'th_th', 'เพิ่มรายการ', 18),
            ('mylist', 'My List', 'th_th', 'รายการของฉัน', 18),
            ('filtername', 'Filter Name', 'th_th', 'ชื่อตัวกรอง', 18),
            ('selectlist', 'Select a List', 'th_th', 'เลือกรายการ', 18),
            ('assingedto', 'Assigned To', 'th_th', 'ได้รับมอบหมายให้', 18),
            ('selectmodule', 'Select a module', 'th_th', 'เลือกโมดูล', 18),
            ('add_list', 'Add Filter', 'th_th', 'เพิ่มตัวกรอง', 18),
            ('recent_event', 'Recent Event', 'th_th', 'กิจกรรมล่าสุด', 19),
            ('recent_hostory', 'Recent History', 'th_th', 'ประวัติล่าสุด', 19),
            ('module_specific_settings', 'Module-Specific Settings', 'th_th', 'การตั้งค่าโมดูลเฉพาะ', 19),
            ('talk_to_us', 'Talk to us', 'th_th', 'พูดคุยกับเรา', 19),
            ('report_a_bug', 'Report A Bug', 'th_th', 'รายงานข้อผิดพลาด', 19),
            ('faq', 'FAQ', 'th_th', 'คำถามที่พบบ่อย', 19),
            ('selectmodules', 'Select Module', 'th_th', 'เลือกโมดูล', 19),
            ('myplan', 'My Plan', 'th_th', 'แผนของฉัน', 19),
            ('message', 'Message', 'th_th', 'ข้อความ', 20),
            ('message_validation', 'Please enter Message', 'th_th', 'กรุณากรอกข้อความ', 20),
            ('contact_select', 'Please Select contact', 'th_th', 'โปรดเลือกรายชื่อ', 20),
            ('global_search', 'Global Search', 'th_th', 'ค้นหาทั่วโลก', 21),
            ('records', 'Records', 'th_th', 'ประวัติ', 21),
            ('dont_show_again', 'Don\'t Show Again', 'th_th', 'อย่าแสดงอีก', 22),
            ('skip', 'Skip', 'th_th', 'ข้าม', 22),
            ('file_downloading', 'File Downloading', 'th_th', 'กำลังดาวน์โหลดไฟล์', 23),
            ('add_screenshots_optional', 'Add screenshots (optional)', 'th_th', 'เพิ่มภาพ screenshots (ไม่บังคับ)', 24),
            ('describe_your_problem', 'Describe your problem', 'th_th', 'อธิบายปัญหาของคุณ', 24),
            ('default_filter_shortcut', 'Default Filter Shortcut', 'th_th', 'ค่าเริ่มต้นทางลัดตัวกรอง', 25),
            ('record_shortcut', 'Record Shortcut', 'th_th', 'บันทึกทางลัด', 25),
            ('enter_url', 'Please Enter url', 'th_th', 'โปรดป้อน URL', 26),
            ('new_version_is_avaiable', 'You need to update the app to continue using Please update to continue Older versions will no longer work from today', 'th_th', 'คุณต้องอัปเดตแอปเพื่อใช้งานต่อ โปรดอัพเดตเพื่อดำเนินการต่อ เวอร์ชันเก่าจะใช้ไม่ได้อีกต่อไปนับจากวันนี้', 26),
            ('search_by', 'Search by', 'th_th', 'ค้นหาโดย', 27),
            ('selected_filter', 'Selected filter :', 'th_th', 'ตัวกรองที่เลือก:', 27),
            ('selected_field', 'Selected field :', 'th_th', 'ฟิลด์ที่เลือก:', 27),
            ('choose', 'Choose', 'th_th', 'เลือก', 28),
            ('qr_cardscanner', 'QR Code Scanner', 'th_th', 'เครื่องสแกน QR Code', 28),
            ('error_message_for_scan', 'Could not read the card Try again later.', 'th_th', 'ไม่สามารถอ่านการ์ดได้โปรดลองอีกครั้งในภายหลัง', 28),
            ('press_start_scan', 'Press to Start Scan', 'th_th', 'กดปุ่มเพื่อเริ่มสแกน', 28),
            ('line_item_quntity_validation_msg', 'Value should be greater than zero', 'th_th', 'ค่าควรมากกว่าศูนย์', 29),
            ('percentage_msg', 'Percentage should be less than 100', 'th_th', 'เปอร์เซ็นต์ควรน้อยกว่า 100', 29),
            ('MSG_NO_DATA', 'No data found!', 'th_th', 'ไม่พบข้อมูล!', 29),
            ('MSG_SOMETHING_WRONG', 'Something went wrong!', 'th_th', 'อะไรบางอย่างผิดปกติ!', 29),
            ('MSG_COMING_SOON', 'Coming Soon!', 'th_th', 'เร็ว ๆ นี้!', 29),
            ('MSG_UPLOAD_PROFILE_IMAGE', 'Please upload profile image.', 'th_th', 'โปรดอัปโหลดภาพโปรไฟล์', 29),
            ('ALERT_TITLE_LOCATION_ACCESS', 'Location Access', 'th_th', 'เข้าถึงตำแหน่ง', 29),
            ('ALERT_MSG_LOCATION_ACCESS', 'Requires your location to show nearby events.', 'th_th', 'ต้องใช้สถานที่ของคุณเพื่อแสดงให้เห็นเหตุการณ์ที่เกิดขึ้นในบริเวณใกล้เคียง', 29),
            ('ALERT_BTN_ALLOW', 'ALLOW', 'th_th', 'อนุญาติ', 29),
            ('ALERT_BTN_DENY', 'DENY', 'th_th', 'ปฏิเสธ', 29),
            ('ALERT_MSG_LOCATION_SETTING', 'Not able to fetch your current location. Please check your location settings.', 'th_th', 'ไม่สามารถดึงข้อมูลตำแหน่งปัจจุบันของคุณ กรุณาตรวจสอบการตั้งค่าสถานที่ของคุณ', 29),
            ('DELETE_RECORD', 'Delete Record', 'th_th', 'ลบข้อมูลบันทึก', 29),
            ('ALERT_MSG_DELETE_SHORTCUT', 'Are you sure want to delete this shortcut?', 'th_th', 'คุณแน่ใจหรือว่าต้องการลบทางลัดนี้?', 29),
            ('DELETE_SHORTCUT', 'Delete Shortcut', 'th_th', 'ลบทางลัด', 29),
            ('LBL_TERMS', 'By logging in, you agree to our Terms and', 'th_th', 'โดยเข้าสู่ระบบคุณยอมรับข้อตกลงของเราและ', 29),
            ('LBL_CONDITIONS', 'Conditions &', 'th_th', 'เงื่อนไขและ', 29),
            ('ALERT_TITLE', 'Alert', 'th_th', 'เตือนภัย', 29),
            ('ALERT_BTN_SUBSCRIBE', 'Subscribe', 'th_th', 'สมัครสมาชิก', 29),
            ('MSG_SELECT_MODULE', 'Please select any Module', 'th_th', 'กรุณาเลือกโมดูลใด ๆ', 29),
            ('MSG_SELECT_LIST', 'Please select any List', 'th_th', 'กรุณาเลือกรายการใด ๆ', 29),
            ('ALERT_MSG_DONT_HAVE_CAMERA', 'You don\'t have camera', 'th_th', 'คุณไม่มีกล้อง', 29),
            ('ALERT_MSG_GALLARY_PERMISSION', 'You don\'t have permission to access gallery.', 'th_th','คุณไม่ได้รับอนุญาตให้เข้าถึงแกลเลอรี่', 29),
            ('ALERT_MSG_CAMERA_PERMISSION', 'You don\'t have permission to access camera. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Camera on', 'th_th', 'คุณไม่ได้รับอนุญาตให้เข้าถึงกล้อง ไปที่การตั้งค่า -> เลื่อนไปที่ด้านล่างและเลือก CRMTiger App -> เปิดกล้อง', 29),
            ('ALERT_MSG_SPEECH_PERMISSION', 'You don\'t have permission to access Speech Recognition. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Speech Recognition on', 'th_th', 'คุณไม่มีสิทธิ์เข้าถึงการรู้จำเสียง ไปที่การตั้งค่า -> เลื่อนลงไปด้านล่างและเลือกแอป CRMTiger -> เปิด ระบบ Voice Recognition', 29),
            ('BTN_DONE', 'Done', 'th_th', 'เสร็จสิ้น', 29),
            ('COMMENT', 'Comment', 'th_th', 'ความคิดเห็น', 29),
            ('FULL_FORM', 'Full Form', 'th_th', 'แบบเต็มรูปแบบ', 29),
            ('QUICK_CREATE', 'Create', 'th_th', 'สร้าง', 29),
            ('LBL_SELECT_FIELDS', 'Select Fields', 'th_th', 'เลือกเขตข้อมูล', 29),
            ('LBL_SELECT_FIRST_FIELDS', 'Select First Field', 'th_th', 'เลือกฟิลด์แรก', 29),
            ('LBL_SELECT_SECOND_FIELDS', 'Select Second Field', 'th_th', 'เลือกฟิลด์ที่สอง', 29),
            ('LBL_SELECT_THIRD_FIELDS', 'Select Third Field', 'th_th', 'เลือกฟิลด์ที่สาม', 29),
            ('LBL_SORT_BY_FIELD', 'Select Sort By Field', 'th_th', 'เลือกเรียงลำดับตามฟิลด์', 29),
            ('BTN_RESET_TO_DEFAULT', 'Reset to Default', 'th_th', 'รีเซ็ตเป็นค่าเริ่มต้น', 29),
            ('MSG_SELECT_SORT_BY_FIELD', 'Select Sort by field', 'th_th', 'เลือกเรียงลำดับตามฟิลด์', 29),
            ('kStrClearBtnTitle', 'Clear', 'th_th', 'ล้าง', 29),
            ('kStrShowMoreBtnTitle', 'Show More', 'th_th', 'แสดงมากขึ้น', 29),
            ('kStrAddActivitiesBtnTitle', 'Add Activities', 'th_th', 'เพิ่มกิจกรรม', 29),
            ('kStrAddCommentPlaceHolder', 'Add your comments here', 'th_th', 'เพิ่มความคิดเห็นของคุณที่นี่', 29),
            ('MSG_ENTER_TO_EMAIL', 'Please enter to field.', 'th_th', 'กรุณากรอกข้้อมูลในฟิลด์', 29),
            ('WARNING_FILE', 'File can\'t open.', 'th_th', 'ไฟล์ไม่สามารถเปิดได้', 29),
            ('MSG_FILE_SAVED', 'File saved.', 'th_th', 'ไฟล์ถูกบันทึก', 29),
            ('WARNING_DOWNLOAD_FAIL', 'Download fail!, please try after sometime.', 'th_th', 'การดาวน์โหลดล้มเหลว! โปรดลองอีกครั้งในภายหลัง', 29),
            ('LBL_SHORTCUT', 'Shortcut', 'th_th', 'ทางลัด', 29),
            ('TXT_MESSAGE_PLACEHOLDER', 'Type Message', 'th_th', 'เขียนข้อความ', 29),
            ('ALERT_INSTALL_WHATSAPP', 'Install Whatsapp', 'th_th', 'ติดตั้ง Whatsapp', 29),
            ('MSG_NO_MAIL_BOX', 'No MailBox found. Please Create Mailbox', 'th_th', 'ไม่พบกล่องจดหมาย โปรดสร้างกล่องจดหมาย', 29),
            ('LBL_WROTE', 'Wrote', 'th_th', 'เขียน', 29),
            ('MSG_MAIL_SEND', 'Mail sent', 'th_th', 'เมลถูกส่งแล้ว', 29),
            ('log_file_not_found', 'API Log file not found.', 'th_th', 'ไม่พบไฟล์บันทึก API', 29),
            ('unknown_error', 'An unknown error occurred, try again', 'th_th', 'เกิดข้อผิดพลาดที่ไม่รู้จัก โปรดลองอีกครั้ง', 29),
            ('CTMTigerAppVersion', 'CRMTiger App Version', 'th_th', 'เวอร์ชันแอป CRMTiger', 29),
            ('CTMMobileUpdateMsg', 'CTMobile Ext. Version Update Successfully', 'th_th', 'CTMobile Ext. อัปเดตเวอร์ชันเรียบร้อยแล้ว', 29),
            ('dialog_Premium_downgrade', 'Downgrade will required logout and login again later', 'th_th', 'การดาวน์เกรดจะต้องออกจากระบบและเข้าสู่ระบบอีกครั้งในภายหลัง', 29),
            ('dialog_Premium', 'Upgrade will required logout and login again later', 'th_th', 'การอัพเกรดจะต้องออกจากระบบและเข้าสู่ระบบอีกครั้งในภายหลัง', 29),
            ('Overwrite', 'Overwrite', 'th_th', 'เขียนทับ', 29),
            ('MSGAddressOverwrite1', 'Overwrite the existing address with the selected', 'th_th', 'เขียนทับที่อยู่เดิม ด้วยที่อยู่ใหม่', 29),
            ('MSGAddressOverwrite2', 'address details?', 'th_th', 'รายละเอียดที่อยู่?', 29),
            ('UPGRADE_PLAN', 'Upgrade Plan', 'th_th', 'แผนอัพเกรด', 29),
            ('DOWNGRADE_PLAN', 'Downgrade Plan', 'th_th', 'แผนดาวน์เกรด', 29),
            ('UPGRADE_EXTENSION', 'Upgrade Extension', 'th_th', 'ส่วนขยายของการอัพเกรด', 29),
            ('UPGRADE_APP', 'Upgrade App', 'th_th', 'อัพเกรด แอป', 29),
            ('SELECT_OPTION', 'Select Option', 'th_th', 'เลือกตัวเลือก', 29),
            ('PLEASE_SELECT', 'Please select', 'th_th', 'โปรดเลือก', 29),
            ('MSG_ACCESS_DENIED', 'You don\'t have permission for this module.', 'th_th', 'คุณไม่ได้รับอนุญาตสำหรับโมดูลนี้', 29),
            ('MSG_SELECT_RECCURING_MONTH_DAY', 'Please select reccuring day of month.', 'th_th', 'โปรดเลือกวันที่ให้ทำซ้ำของเดือน', 29),
            ('MSG_SELECT_RECCURING_WEEK_DAY', 'Please select reccuring day of week.', 'th_th', 'โปรดเลือกวันที่ให้ทำซ้ำของสัปดาห์', 29),
            ('MSG_SELECT_RECCURING_DAYS', 'Please select reccuring days.', 'th_th', 'โปรดเลือกวันที่ให้ทำซ้ำ', 29),
            ('Please select reccuring days.', 'Please select reccuring days.', 'th_th', 'โปรดเลือกวันที่ให้ทำซ้ำ.', 29),
            ('MSG_SELECT_RECCURING_END_DATE', 'Please select reccuring end date.', 'th_th', 'โปรดเลือกวันที่ให้ทำซ้ำครั้งสุกท้าย', 29),
            ('MSG_SELECT_RECCURING_TYPE', 'Please select reccuring type.', 'th_th', 'โปรดเลือกประเภทที่ให้ทำซ้ำ', 29),
            ('FREQ_TIME', 'Times', 'th_th', 'เวลา', 29),
            ('REPEAT_YEARLY', 'Repeat Yearly', 'th_th', 'ทำซ้ำทุกปี', 29),
            ('REPEAT_MONTHLY', 'Repeat Monthly', 'th_th', 'ทำซ้ำทุกเดือน', 29),
            ('REPEAT_WEEKLY', 'Repeat Weekly', 'th_th', 'ทำซ้ำทุกอาทิตย์', 29),
            ('REPEAT_DAILY', 'Repeat Daily', 'th_th', 'ทำซ้ำทุกวัน', 29),
            ('ACTION_TITLE', 'Action Title', 'th_th', 'ชื่อเรื่องของการกระทำ', 29),
            ('MSG_SELECT_VALID_DATE', 'Please select valid day of month.', 'th_th', 'กรุณาเลือกวันที่ถูกต้องของเดือน', 29),
            ('MSG_SELECT_VALID_START_DATE', 'Start date should be less than end date.', 'th_th', 'วันเริ่มต้นควรจะน้อยกว่าวันที่สิ้นสุด', 29),
            ('MSG_SELECT_VALID_START_TIME', 'Start time should be less than end time.', 'th_th', 'เวลาเริ่มต้นควรจะน้อยกว่าเวลาสิ้นสุด', 29),
            ('LBL_LINEITEM_DETAILS', 'Lineitem Details', 'th_th', 'รายละเอียดรายการสินค้า', 29),
            ('MSG_INVALIDE_DISCOUNT_AMOUNT', 'Discount amount should be less than the total.', 'th_th', 'จำนวนส่วนลดควรน้อยกว่ายอดรวม', 29),
            ('VIEW', 'View', 'th_th', 'ดู', 29),
            ('MSG_ENTER_VALID', 'Please enter valid', 'th_th', 'โปรดใส่ข้อมูลที่ถูกต้อง', 29),
            ('MSG_ENTER_PERCENTAGE', 'Percentage should be less than 100.', 'th_th', 'เปอร์เซ็นต์ควรน้อยกว่า 100', 29),
            ('ITEM_TOTAL', 'Item Total', 'th_th', 'รายการสินค้าทั้งหมด', 29),
            ('ADJUSTMENT', 'Adjustment', 'th_th', 'การปรับ', 29),
            ('TITLE_CHOOSE_IMAGE', 'Choose Image', 'th_th', 'เลือกภาพ', 29),
            ('COMPRESS', 'Compress', 'th_th', 'การบีบอัด', 29),
            ('CHOOSE_ANOTHER_IMAGE', 'Your image size is too large, please select another image', 'th_th', 'ขนาดภาพของคุณมีขนาดใหญ่เกินไปโปรดเลือกภาพอื่น', 29),
            ('OnDayOfMonth', 'On day of month', 'th_th', 'ในวันของเดือน', 29),
            ('OnDayOfWeek', 'On day of week', 'th_th', 'ในวันของสัปดาห์', 29),
            ('AddAndClose', 'Add & Close', 'th_th', 'เพิ่มและปิด', 29),
            ('Repeat', 'Repeat', 'th_th', 'ทำซ้ำ', 29),
            ('OnDay', 'On day', 'th_th', 'ในวันนี้', 29),
            ('View_Line_Item', 'View Line Item', 'th_th', 'ดูรายการสินค้า', 29),
            ('TITLE_IMAGE', 'Image', 'th_th', 'ภาพ', 29),
            ('TITLE_ICLOUD', 'iCloud', 'th_th', 'iCloud', 29),
            ('GOOGLE', 'Google', 'th_th', 'Google', 29),
            ('ALERT_BTN_OKAY', 'Okay', 'th_th', 'โอเค', 29),
            ('ALERT_TITLE_ACCESS_DENIED', 'Access Denied', 'th_th', 'ปฏิเสธการเข้าใช้', 29),
            ('Dont_Show_Again', 'Don\'t show again', 'th_th', 'ไม่ต้องแสดงอีกครั้ง', 29),
            ('Skip', 'Skip', 'th_th', 'ข้าม', 29),
            ('Fillter_Name', 'Fillter Name', 'th_th', 'ชื่อตัวกรอง', 29),
            ('Fillter_Record_Count', 'Fillter Record Count', 'th_th', 'จำนวนตัวกรอง', 29),
            ('url_note',  'Note : if your URL of CRM is https://example.com/crm enter that into above box',   'th_th',    'หมายเหตุ: หาก URL ของ CRM คือ https://example.com/crm ให้ป้อนลงในช่องด้านบน',   31),
            ('vtiger_url',  'Your vTiger CRM URL',  'th_th',    'URL CRM vTiger ของคุณ',  31),
            ('msg_doc_read_permission', 'You don\'t have permission to Add either This is read-only or Private Field.',  'th_th',    'ช่องนี้เป็นช่องแบบอ่านอย่างเดียวคุณไม่มีสิทธิ์เพิ่มข้อมูล',  31),
            ('CLEAR',   'Clear',    'th_th',    'ล้าง',    31),
            ('Files/photos uploaded successfully',  'Files/photos uploaded successfully',   'th_th',    'อัปโหลดไฟล์ / รูปภาพเรียบร้อยแล้ว',   32),
            ('Digital signature saved', 'Digital signature saved',  'th_th',    'บันทึกลายเซ็นดิจิทัลแล้ว',  32),
            ('Please upload Signature or Files/photos', 'Please upload Signature or Files/photos',  'th_th',    'โปรดอัปโหลดลายเซ็นหรือไฟล์ / ภาพถ่าย',  32),
            ('Files / Photos',  'Files / Photos',   'th_th',    'ไฟล์ / ภาพถ่าย',   32),
            ('Signature',   'Signature',    'th_th',    'ลายเซ็น',    32),
            ('add_photo_using', 'Add Photo Using',  'th_th',    'เพิ่มรูปภาพโดย',  31),
            ('btn_upload_sign', '(+) Add Signature',    'th_th',    '(+) เพิ่มลายเซ็น',    31),
            ('btn_upload_photo_doc',    '(+) Upload Files/Photos',  'th_th',    '(+) อัปโหลดไฟล์ / ภาพถ่าย',  31),
            ('select_photo_doc_to_upload',  'Please select files/photos to upload', 'th_th',    'โปรดเลือกไฟล์ / รูปภาพที่จะอัปโหลด', 31),
            ('related_module_title',    'Search from related module and Add to \"Route\"',  'th_th',    'ค้นหาจากโมดูลที่เกี่ยวข้องและเพิ่มใน \"เส้นทาง\"',  30),
            ('Route status updated successfully',   'Route status updated successfully',    'th_th',    'อัปเดตสถานะเส้นทางเรียบร้อยแล้ว',    32),
            ('Session init failed', 'Session init failed',  'th_th',    'การเริ่มเซสชันล้มเหลว',  32),
            ('You don\'t have permission to access this resource',  'You don\'t have permission to access this resource',   'th_th',    'คุณไม่มีสิทธิ์เข้าถึงทรัพยากรนี้',   32),
            ('ctroute_realtedto cannot be empty',   'Could not get the Related To - Try again later',   'th_th',    'ไม่สามารถรับสิ่งที่เกี่ยวข้อง - ลองอีกครั้งในภายหลัง',   32),
            ('ctroute_planning cannot be empty',    'Could not get the Route Planning Record - Try again later',    'th_th',    'ไม่สามารถรับบันทึกการวางแผนเส้นทาง - ลองอีกครั้งในภายหลัง',    32),
            ('Something went wrong - Try again later',  'Something went wrong - Try again later',   'th_th',    'เกิดข้อผิดพลาดโปรดลองอีกครั้งในภายหลัง',   32),
            ('sequence updated successfully',   'sequence updated successfully',    'th_th',    'อัปเดตลำดับเรียบร้อยแล้ว',    32),
            ('sequence cannot be empty',    'sequence cannot be empty', 'th_th',    'ลำดับต้องไม่ว่างเปล่า', 32),
            ('Shortcut details not saved',  'Shortcut details not saved',   'th_th',    'ไม่ได้บันทึกรายละเอียดทางลัด',   32),
            ('Shortcut details saved successfully', 'Shortcut details saved successfully',  'th_th',    'บันทึกรายละเอียดทางลัดสำเร็จแล้ว',  32),
            ('Route save successfully', 'Route save successfully',  'th_th',    'บันทึกเส้นทางสำเร็จ',  32),
            ('Record save successfully',    'Record save successfully', 'th_th',    'บันทึกเรียบร้อยแล้ว', 32),
            ('No dependency found for picklist',    'No dependency found for picklist', 'th_th',    'ไม่พบการอ้างอิงสำหรับรายการเลือก', 32),
            ('No records found',    'No records found', 'th_th',    'ไม่พบบันทึก', 32),
            ('Outgoing server is not enabled, please configure from CRM',   'Outgoing server is not enabled, please configure from CRM',    'th_th',    'ไม่ได้เปิดใช้งานเซิร์ฟเวอร์ขาออกโปรดกำหนดค่าจาก CRM',    32),
            ('Removed Successfully',    'Removed Successfully', 'th_th',    'ถูกลบเรียบร้อย', 32),
            ('Shortcut has been deleted',   'Shortcut has been deleted',    'th_th',    'ทางลัดได้ถูกลบออก',    32),
            ('relation of records removed successfully',    'relation of records removed successfully', 'th_th',    'ความเกี่ยวข้องของบันทึกถูกลบออกเรียบร้อย', 32),
            ('relation of records not removed', 'relation of records not removed',  'th_th',    'ความเกี่ยวข้องของบันทึกไม่ได้ถูกลบ',  32),
            ('Record has been deleted successfully',    'Record has been deleted successfully', 'th_th',    'ลบบันทึกเรียบร้อยแล้ว', 32),
            ('Time Tracking saved successfully',    'Time Tracking saved successfully', 'th_th',    'บันทึกการติดตามเวลาสำเร็จแล้ว', 32),
            ('Time Tracking updated successfully',  'Time Tracking updated successfully',   'th_th',    'อัปเดตการติดตามเวลาเรียบร้อยแล้ว',   32),
            ('Time Tracking ended successfully',    'Time Tracking ended successfully', 'th_th',    'การติดตามเวลาสิ้นสุดลงเรียบร้อยแล้ว', 32),
            ('Time Tracking started successfully',  'Time Tracking started successfully',   'th_th',    'การติดตามเวลาเริ่มประสบความสำเร็จ',   32),
            ('record cannot be empty',  'record cannot be empty',   'th_th',    'บันทึกต้องไม่ว่างเปล่า',   32),
            ('Module is disabled',  'Module is disabled',   'th_th',    'โมดูลถูกปิดใช้งาน',   32),
            ('Shift ended successfully',    'Shift ended successfully', 'th_th',    'หยุดกะได้สำเร็จ', 32),
            ('Shift started successfully',  'Shift started successfully',   'th_th',    'เริ่มกะได้สำเร็จ',   32),
            ('relation of records added successfully',  'relation of records added successfully',   'th_th',    'เพิ่มความเกี่ยวข้องของบันทึกเรียบร้อยแล้ว',   32),
            ('Comment saved successfully',  'Comment saved successfully',   'th_th',    'บันทึกความคิดเห็นเรียบร้อยแล้ว',   32),
            ('Comment not saved',   'Comment not saved',    'th_th',    'ไม่ได้บันทึกความคิดเห็น',    32),
            ('Comment module is not active',    'Comment module is not active', 'th_th',    'โมดูลแสดงความคิดเห็นไม่ได้ใช้งาน', 32),
            ('No Upcoming Event',   'No Upcoming Event',    'th_th',    'ไม่มีกิจกรรมที่จะเกิดขึ้น',    32),
            ('No Templates found - create it from Message Templates module',    'No Templates found - create it from Message Templates module', 'th_th',    'ไม่พบเทมเพลต - สร้างได้จาก เทมเพลโมดูลตข้อความ', 32),
            ('No event or task for this date',  'No event or task for this date',   'th_th',    'ไม่มีกิจกรรมหรืองานสำหรับวันนี้',   32),
            ('No filters created',  'No filters created',   'th_th',    'ไม่มีการสร้างตัวกรอง',   32),
            ('Select at least one record to attach',    'Select at least one record to attach', 'th_th',    'เลือกอย่างน้อยหนึ่งการบันทึกที่จะแนบ', 32),
            ('Please select one or more attachments',   'Please select one or more attachments',    'th_th',    'โปรดเลือกไฟล์แนบอย่างน้อยหนึ่งไฟล์',    32),
            ('No event for this month', 'No event for this month',  'th_th',    'ไม่มีเหตุการณ์ในเดือนนี้',  32),
            ('No Activity found',   'No Activity found',    'th_th',    'ไม่พบกิจกรรม',    32),
            ('Your feedback is valuable for us - it cannot be empty',   'Your feedback is valuable for us - it cannot be empty',    'th_th',    'ความคิดเห็นของคุณมีค่าสำหรับเรา - อย่าปล่อยให้ว่าง',    32),
            ('Could not send mail, Please try later',   'Could not send mail, Please try later',    'th_th',    'ไม่สามารถส่งอีเมลโปรดลองใหม่ภายหลัง',    32),
            ('Latest Version updated successfully', 'Latest Version updated successfully',  'th_th',    'อัปเดตเวอร์ชันล่าสุดเรียบร้อยแล้ว',  32),
            ('User Location Updated Successfully',  'User Location Updated Successfully',   'th_th',    'อัปเดตตำแหน่งของผู้ใช้เรียบร้อยแล้ว',   32),
            ('User Location not Updated Successfully',  'User Location not Updated Successfully',   'th_th',    'ไม่ได้อัปเดตตำแหน่งของผู้ใช้สำเร็จ',   32),
            ('SMSNotifier is not enable in CRM. Please enable it first',    'SMSNotifier is not enable in CRM. Please enable it first', 'th_th',    'SMSNotifier ไม่ได้เปิดใช้งานใน CRM กรุณาเปิดใช้งานก่อน', 32),
            ('Could not submit your feedback - Please try again later', 'Could not submit your feedback - Please try again later',  'th_th',    'ไม่สามารถส่งความคิดเห็นของคุณ - โปรดลองอีกครั้งในภายหลัง',  32),
            ('Thank you for submitting your feedback',  'Thank you for submitting your feedback',   'th_th',    'ขอบคุณสำหรับการส่งความคิดเห็นของคุณ',   32),
            ('Please upload User Image',    'Please upload User Image', 'th_th',    'โปรดอัปโหลดรูปภาพของผู้ใช้', 32),
            ('Image Not Uploading, please try again',   'Image Not Uploading, please try again',    'th_th',    'ภาพไม่ได้อัปโหลดโปรดลองอีกครั้ง',    32),
            ('User Image Uploaded Successfully',    'User Image Uploaded Successfully', 'th_th',    'อัปโหลดรูปภาพของผู้ใช้เรียบร้อยแล้ว', 32),
            ('Invalid Module name', 'Invalid Module name',  'th_th',    'ชื่อโมดูลที่ไม่ถูกต้อง',  32),
            ('Records Sync Successfully',   'Records Sync Successfully',    'th_th',    'บันทึกการซิงค์สำเร็จ',    32),
            ('Values cannot be empty',  'Values cannot be empty',   'th_th',    'ไม่สามารถทิ้งค่าให้ว่างเปล่าได้',   32),
            ('Record id is empty',  'Record id is empty',   'th_th',    'รหัสบันทึกว่างเปล่า',   32),
            ('Logout Successfully', 'Logout Successfully',  'th_th',    'ออกจากระบบเรียบร้อยแล้ว',  32),
            ('Please Enable CTMobile Module',   'Please Enable CTMobile Module',    'th_th',    'กรุณาเปิดใช้งานโมดูล CTMobile',    32),
            ('Authentication Failed',   'Username and Password do not match',   'th_th',    'ชื่อผู้ใช้และรหัสผ่านไม่ตรงกัน',   32),
            ('Mismatched module information',   'Something gone wrong, please try again later', 'th_th',    'เกิดข้อผิดพลาดโปรดลองอีกครั้งในภายหลัง', 32),
            ('Field does not exists',   'Please set display fields again',  'th_th',    'โปรดตั้งค่าช่องฟิลด์อีกครั้ง',  32),
            ('Module does not exists',  'Module does not exists or disabled by admin',  'th_th',    'ไม่มีโมดูลหรือปิดใช้งานโดยผู้ดูแลระบบ',  32),
            ('Month cannot be empty',   'Could not get the Month - Try again later',    'th_th',    'ไม่สามารถเข้าถึงข้อมูลเดือน - ลองอีกครั้งในภายหลัง',    32),
            ('Year cannot be empty',    'Could not get the Year - Try again later', 'th_th',    'ไม่สามารถเข้าถึงข้อมูลปี - ลองอีกครั้งในภายหลัง', 32),
            ('Date cannot be empty',    'Could not get the Date - Try again later', 'th_th',    'ไม่สามารถเข้าถึงวันที่ - ลองอีกครั้งในภายหลัง', 32),
            ('Userid cannot be empty',  'Could not get the Userid - Try again later',   'th_th',    'ไม่สามารถเข้าถึง Id ผู้ใช้งาน - ลองอีกครั้งในภายหลัง',   32),
            ('End Date cannot be empty',    'Could not get the status - Try again later',   'th_th',    'ไม่สามารถเข้าถึงสถานะ- ลองอีกครั้งในภายหลัง',   32),
            ('Start Date cannot be empty',  'Could not get the Start Date - Try again later',   'th_th',    'ไม่สามารถเข้าถึงวันที่เริ่มต้น - ลองอีกครั้งในภายหลังs',   32),
            ('You do not configure SMS Notifier in CRM. Please configure SMS Notifier in your CRM to use this feature', 'You do not configure SMS Notifier in CRM. Please configure SMS Notifier in your CRM to use this feature',  'th_th',    'คุณไม่ได้กำหนดค่า SMS Notifier ใน CRM โปรดกำหนดค่า SMS Notifier ใน CRM ของคุณเพื่อใช้คุณสมบัตินี้',  32),
            ('Longitude cannot be empty',   'Could not get location-Please try again',  'th_th',    'ไม่สามารถเข้าถึงสถานที่ - ลองอีกครั้งในภายหลัง',  32),
            ('Latitude cannot be empty',    'Could not get location-Please try again',  'th_th',    'ไม่สามารถเข้าถึงสถานที่ - ลองอีกครั้งในภายหลัง',  32),
            ('User cannot be empty',    'Could not get the User - Try again later', 'th_th',    'ไม่สามารถเข้าถึงผู้ใช้ - ลองอีกครั้งในภายหลัง', 32),
            ('Status cannot be empty',  'Could not get the status - Try again later',   'th_th',    'ไม่สามารถเข้าถึงสถานะ - ลองอีกครั้งในภายหลัง',   32),
            ('Required fields not found',   'Required fields not found',    'th_th',    'ไม่พบช่องที่ต้องการ',    32),
            ('Tracking module not active',  'Tracking module not active-Please contact CRM Admin',  'th_th',    'โมดูลการติดตามไม่ได้ใช้งานโปรดติดต่อผู้ดูแลระบบ CRM',  32),
            ('Missing mandatory input values',  'Missing mandatory input values',   'th_th',    'ค่าที่จำเป็นหายไป',   32),
            ('No MailBox found. Please Create Mailbox', 'No MailBox found. Please Create Mailbox',  'th_th',    'ไม่มีกล่องจดหมายพบ กรุณาสร้างกล่องจดหมาย',  32),
            ('Mail not sent',   'Mail not sent',    'th_th',    'อีเมลไม่ได้ถูกส่ง',    32),
            ('Mail send successfully',  'Mail send successfully',   'th_th',    'ส่งเมลสำเร็จ',   32),
            ('Email Id or username not match with your record', 'Email Id or username not match with your record',  'th_th',    'อีเมลหรือชื่อผู้ใช้ไม่ตรงกับบันทึกของคุณ',  32),
            ('Module not specified',    'Module not specified', 'th_th',    'โมดูลไม่ระบุ', 32),
            ('No messages found',   'No messages found',    'th_th',    'ไม่พบข้อความ',    32),
            ('No Dependency Found For This Module', 'No Dependency Found For This Module',  'th_th',    'No Dependency Found For This Module',  32),
            ('Outgoing server is not Enabled',  'Outgoing server is not Enabled',   'th_th',    'เซิร์ฟเวอร์ขาออกไม่ได้เปิดใช้งาน',   32),
            ('Outgoing server is Enabled',  'Outgoing server is Enabled',   'th_th',    'เซิร์ฟเวอร์ขาออกถูกเปิดใช้งาน',   32),
            ('Email Attached Successfully', 'Email Attached Successfully',  'th_th',    'แนบอีเมลเรียบร้อยแล้ว',  32),
            ('Documents Attached Successfully', 'Documents Attached Successfully',  'th_th',    'เอกสารแนบเรียบร้อยแล้ว',  32),
            ('Login required - Please login again', 'Login required - Please login again',  'th_th',    'ต้องเข้าสู่ระบบ - กรุณาเข้าสู่ระบบอีกครั้ง',  32),
            ('time_tracking_module_disable',    'Time tracking module is disable',  'th_th',    'โมดูลการติดตามเวลาปิดใช้งาน',  31),
            ('route_planning_module_disable',   'Route planning module is disable', 'th_th',    'โมดูลการวางแผนเส้นทางถูกปิดใช้งาน', 31),
            ('mark_as_held',    'Are you sure you want to mark Event as Held?', 'th_th',    'แน่ใจไหมว่าต้องการทำเครื่องหมายกิจกรรมเป็น รอก่อน', 31),
            ('stop_timer_msg',  'You have already started Time tracking for another record, Do you want to stop it first ?',    'th_th',    'คุณได้เริ่มการติดตามเวลาสำหรับบันทึกอื่นแล้ว คุณต้องการหยุดก่อนหรือไม่',    31),
            ('access_denied_routeplanning', 'Access denied for route planning', 'th_th',    'ถูกปฏิเสธการเข้าถึง สำหรับการวางแผนเส้นทาง', 31),
            ('time_spent',  'Time Spent',   'th_th',    'เวลาที่ใช้ไป',   31),
            ('select_user', 'Select User',  'th_th',    'เลือกผู้ใช้',  30),
            ('status_cannot_be_held',   'Status cannot be held for future date start',  'th_th',    'สถานะไม่สามารถจัดขึ้นเป็นวันที่ในอนาคตเริ่มต้น',  30),
            ('please_select_end_date',  'Please select end date',   'th_th',    'กรุณาเลือกวันที่สิ้นสุด',   30),
            ('please_select_start_date',    'Please select start date', 'th_th',    'กรุณาเลือกวันที่เริ่มต้น', 30),
            ('tap_on_plus_icon_for_select_route',   'Tap on + icon to select record for your route.',   'th_th',    'แตะที่ + ไอคอน เพื่อเลือกบันทึกเส้นทางของคุณ',   30),
            ('please_enter_notes',  'Please enter notes',   'th_th',    'กรุณากรอกหมายเหตุ',   30),
            ('please_enter_title',  'Please enter title',   'th_th',    'กรุณาใส่ชื่อ',   30),
            ('please_select_date',  'Please Select Date',   'th_th',    'กรุณาเลือกวันที่',   30),
            ('search_by_date',  'Search by Date',   'th_th',    'ค้นหาตามวันที่',   30),
            ('shortcut_not_setup_yet',  'Opps shortcut not setup yet!!! Please add shortcut by click on [icon] from record search results or view record screen.',  'th_th',    'ทางลัดยังไม่ได้ตั้งค่า !!! โปรดเพิ่มทางลัดโดยคลิกที่ [icon] จากข้อมูลผลการค้นหาหรือดูหน้าจอบันทึก',  30),
            ('max_upload_size', 'max file Upload exceeds',  'th_th',    'เกินจำนวนการอัปโหลดไฟล์',  30),
            ('unselect_all',    'UnSelect All', 'th_th',    'ไม่เลือกทั้งหมด', 30),
            ('select_all',  'Select All',   'th_th',    'เลือกทั้งหมด',   30),
            ('please_select_records',   'Please select records',    'th_th',    'กรุณาเลือกบันทึก',    30),
            ('select_date', 'Select Date',  'th_th',    'เลือกวันที่',  30),
            ('quantity_in_stock_is',    'Quantity in stock is', 'th_th',    'จำนวนสินค้าในสต็อก', 30),
            ('replies', 'Replies',  'th_th',    'ตอบกลับ',  30),
            ('conversation_require_selection',  'Conversion requires selection of Contact or Organization', 'th_th',    'การแปลงต้องเลือกผู้ติดต่อหรือองค์กร', 30),
            ('please_select_product',   'Please Select Product',    'th_th',    'กรุณาเลือกสินค้า',    30),
            ('timer_msg',   'You can start timer for single task only at same time',    'th_th',    'คุณสามารถเริ่มจับเวลาสำหรับงานเดียวในเวลาเดียวเท่านั้น',    31),
            ('save_start_tracking', 'Save & Start Tracking',    'th_th',    'บันทึกและเริ่มต้นการติดตาม',    31),
            ('lbl_notes',   'Notes',    'th_th',    'หมายเหตุ',    31),
            ('enter_title', 'Enter Title',  'th_th',    'ใส่ชื่อ',  31),
            ('select_module_record',    'Select Module / Record',   'th_th',    'เลือกโมดูล / บันทึก',   31),
            ('lbl_tomorrow',    'Tomorrow', 'th_th',    'วันพรุ่งนี้', 30),
            ('lbl_yesterday',   'Yesterday',    'th_th',    'เมื่อวาน',    30),
            ('lbl_today',   'Today',    'th_th',    'วันนี้',    30),
            ('time_tracker',    'Time Tracker', 'th_th',    'ตัวติดตามเวลา', 31),
            ('time_end',    'End Time', 'th_th',    'เวลาสิ้นสุด', 5),
            ('due_date',    'End Date', 'th_th',    'วันที่สิ้นสุด', 5),
            ('time_start',  'Time Start',   'th_th',    'เวลาเริ่มต้น',   5),
            ('date_start',  'Start Date',   'th_th',    'วันที่เริ่มต้น',   5),
            ('delete_widget_msg',   'Display widget again by using (+) option', 'th_th',    'แสดงวิดเจ็ตอีกครั้งโดยใช้ (+) ตัวเลือก', 15),
            ('no_upcoming_activities',  'No scheduled activities    ',  'th_th',    'ไม่มีกิจกรรมที่กำหนดไว้ ',  15),
            ('check_in_first',  'Please check-in first',    'th_th',    'กรุณาเช็คอินก่อน',    30),
            ('duration',    'Duration', 'th_th',    'ระยะเวลา', 30),
            ('distance',    'Distance', 'th_th',    'ระยะทาง', 30),
            ('proper_address_message',  'Please enter proper address in record\n',  'th_th',    'กรุณาใส่ที่อยู่ที่เหมาะสมในการบันทึก',    30),
            ('select_status',   'Select Status',    'th_th',    'เลือกสถานะ',    30),
            ('route_planner',   'Route Planner',    'th_th',    'ผู้วางแผนเส้นทาง',    30),
            ('route_planning',  'Route Planning',   'th_th',    'วางแผนเส้นทาง',   30),
            ('add_route',   'Add Route',    'th_th',    'เพิ่มเส้นทาง',    30),
            ('calender_disabled',   'Calendar Module is disabled',  'th_th',    'โมดูลปฏิทินถูกปิดใช้งาน',  30),
            ('close_dialog',    'Close form',   'th_th',    'ปิดแบบฟอร์ม',   30),
            ('cancel_form_message', 'Are You sure want to close ?', 'th_th',    'คุณแน่ใจหรือว่าต้องการปิด?', 30),
            ('create_route',    'Create Route', 'th_th',    'สร้างเส้นทาง', 30),
            ('select_module_create_route',  'Select Module to create Route',    'th_th',    'เลือกโมดูลในการสร้างเส้นทาง',    30),
            ('cancel',  'Cancel',   'th_th',    'ยกเลิก',   30),
            ('assign_route',    'Assign Route', 'th_th',    'กำหนดเส้นทาง', 30),
            ('route_for',   'Route for',    'th_th',    'เส้นทางสำหรับ',    30),
            ('assigned_to', 'Assigned To',  'th_th',    'มอบหมายให้',  30),
            ('enter_route_name',    'Enter Route Name', 'th_th',    'กรุณาใส่ชื่อเส้นทาง', 30),
            ('list',    'List', 'th_th',    'รายการ', 30),
            ('map', 'Map',  'th_th',    'แผนที่',  30),
            ('other_modules',   'Other Modules',    'th_th',    'โมดูลอื่น ๆ',    15),
            ('shortcut_no_record_msg',  'Opps shortcut not setup\n yet!!! Please add shortcut  by click on + icon from record\n search results or view record screen.', 'th_th',    'ทางลัดยังไม่ได้ตั้งค่า! โปรดเพิ่มทางลัดโดยคลิกที่ + ไอคอน จากบันทึก หรือ ผลการค้นหาหรือ ดูจากหน้าจอบันทึก', 25),
            ('clear',   'Clear',    'th_th',    'ล้าง',    25),
            ('open',    'Open', 'th_th',    'เปิด', 11),
            ('max_file_msg',    'Too many files selected (max:6)',  'th_th',    'ไฟล์ที่เลือกมากเกินไป (สูงสุด: 6)',  11),
            ('error_voicenote_record',  'Unable to recording voice while another application is recording sound.',  'th_th',    'ไม่สามารถบันทึกเสียงในขณะที่แอปพลิเคชันอื่นกำลังบันทึกเสียง',  11),
            ('msg_warning', 'Warning!', 'th_th',    'คำเตือน!', 11),
            ('Permision_denied_contact',    'Permission denied to access your contacts',    'th_th',    'ไม่อนุญาตให้เข้าถึงรายชื่อของคุณ',    15),
            ('no_widget_added', 'Please click + icon to add new widget to your dashboard.', 'th_th',    'โปรดคลิก + ไอคอนเพื่อเพิ่มวิดเจ็ตใหม่ในแดชบอร์ดของคุณ', 15),
            ('no_data_available',   'Data not available, please check the selected fields', 'th_th',    'ไม่มีข้อมูลโปรดตรวจสอบฟิลด์ที่เลือก', 15),
            ('check_out_successfully',  'Check out successfully',   'th_th',    'เช็คเอ้าท์เรียบร้อย', 11),
            ('check_in_successfully',   'Check in successfully',    'th_th',    'เช็คอินเรียบร้อย',  11),
            ('check_out',   'Check out',    'th_th',    'เช็คเอาท์',    11),
            ('check_in',    'Check in', 'th_th',    'เช็คอิน', 11),
            ('navigate',    'Navigate', 'th_th',    'นำทาง', 11),
            ('save_to_phone_vcard_success', 'VCard Saved to phone successfully',    'th_th',    'VCard บันทึกลงในโทรศัพท์เรียบร้อยแล้ว',    15),
            ('download_vcard_success',  'VCard downloaded successfully',    'th_th',    'วีการ์ดดาวน์โหลดสำเร็จ',    15),
            ('card_details',    'Card Details', 'th_th',    'รายละเอียดบัตร', 15),
            ('add_widget',  'Add Widget',   'th_th',    'เพิ่มวิดเจ็ต',   15),
            ('delete_widget',   'Are you sure to hide widget?', 'th_th',    'คุณแน่ใจหรือไม่ว่าจะซ่อนวิดเจ็ต', 15),
            ('already_widgets_added',   'All types of Widget & reports are already added',  'th_th',    'เพิ่มวิดเจ็ตและรายงานทุกประเภทแล้ว',  15),
            ('retry',   'Retry',    'th_th',    'ลองใหม่',    28),
            ('retake',  'Retake',   'th_th',    'เอาคืน',   28),
            ('Reports', 'Reports',  'th_th',    'รายงาน',  15),
            ('Widgets', 'Widgets',  'th_th',    'วิดเจ็ต',  15),
            ('vcard_config',    'Vcard Configuration',  'th_th',    'การกำหนดค่า vcard',  8),
            ('save_to_phone',   'Save to phone',    'th_th',    'บันทึกไปยังโทรศัพท์',    11),
            ('download_vcard',  'Download Vcard',   'th_th',    'ดาวน์โหลด Vcard',   11),
            ('share_vcard', 'Share Vcard',  'th_th',    'แบ่งปัน Vcard',  11),
            ('share_record',    'Share Record', 'th_th',    'แบ่งปันบันทึก', 11),
            ('permission_denied_edit',  'You don\'t have permission to edit this record.',  'th_th',    'คุณไม่ได้รับอนุญาตให้แก้ไขบันทึกนี้',  27),
            ('permission_denied_delete',    'You don\'t have permission to delete this record.',    'th_th',    'คุณไม่ได้รับสิทธิ์ในการลบบันทึกนี้',    27),
            ('Voice_Recording_Started', 'Recording Started',    'th_th',    'การบันทึกเริ่มต้น',    12),
            ('Voice_Recording_Stopped', 'Recording Stopped',    'th_th',    'การบันทึกสิ้นสุด',    12),
            ('SEARCH',  'Search',   'th_th',    'ค้นหา',   7),
            ('LAST',    'Last', 'th_th',    'ล่าสุด', 7),
            ('FIRST',   'First',    'th_th',    'ครั้งแรก',    7),
            ('MONDAY',  'Monday',   'th_th',    'วันจันทร์',   7),
            ('TUESDAY', 'Tuesday',  'th_th',    'วันอังคาร',  7),
            ('WEDNESDAY',   'Wednesday',    'th_th',    'วันพุธ',    7),
            ('THURSDAY',    'Thursday', 'th_th',    'วันพฤหัสบดี', 7),
            ('FRIDAY',  'Friday',   'th_th',    'วันศุกร์',   7),
            ('SATURDAY',    'Saturday', 'th_th',    'วันเสาร์', 7),
            ('SUNDAY',  'Sunday',   'th_th',    'วันอาทิตย์',   7),
            ('DAILY',   'Daily',    'th_th',    'ประจำวัน',    7),
            ('WEEKLY',  'Weekly',   'th_th',    'รายสัปดาห์',   7),
            ('MONTHLY', 'Monthly',  'th_th',    'รายเดือน',  7),
            ('YEARLY',  'Yearly',   'th_th',    'รายปี',   7),
            ('asset_tracking',  'Asset tracking',   'th_th',    'การติดตามสินทรัพย์',   15);",array());
    }
	
	static function CTMobileUserAccess() {
        global $adb;
		
		$ctmobile_access_Users =$adb->pquery("SELECT * FROM `ctmobile_access_users` ",array());
		if($adb->num_rows($ctmobile_access_Users) == 0 ){
			//Insert Defaullt Users in ctmobile_access_users Table
			$Users =$adb->pquery("SELECT * FROM `vtiger_users` WHERE deleted = 0 AND status = ?",array('Active'));
			$userArray = array();
			for($i=0;$i<($adb->num_rows($Users));$i++){
			$id = $adb->query_result($Users,$i,'id');
			$adb->pquery("INSERT INTO `ctmobile_access_users` (`userid`) VALUES (?)",array($id));
			}
			
		}
		
    }

 
    /**
     * Add CTMobileSettings Widgets at CRM Settings > Other Settings
     * parameters None.
     * @return None
     */
    static function addWidgetTo() {
        global $adb;
        $widgetType = 'HEADERSCRIPT';
        $widgetName = 'CTMobileSettingsJS';
        $link = 'layouts/v7/modules/CTMobileSettings/resources/CTMobileSettings.js';
        include_once 'vtlib/Vtiger/Module.php';

        $moduleNames = array('CTMobileSettings');
        foreach($moduleNames as $moduleName) {
            $module = Vtiger_Module::getInstance($moduleName);
            if($module) {
                $module->addLink($widgetType, $widgetName, $link);
            }
        }
		$adb->pquery("DELETE FROM vtiger_settings_field WHERE `name` = ?",array('CTMobileSettings'));
		$rsBlock=$adb->pquery("SELECT blockid FROM `vtiger_settings_blocks` WHERE label='LBL_OTHER_SETTINGS'",array());
		$blockid=$adb->query_result($rsBlock, 0, 'blockid');
        $max_id=$adb->getUniqueID('vtiger_settings_field');
        $adb->pquery("INSERT INTO `vtiger_settings_field` (`fieldid`, `blockid`, `name`, `description`, `linkto`, `sequence`) VALUES (?, ?, ?, ?, ?, ?)",array($max_id,$blockid,'CTMobileSettings', 'CTMobileSettings', 'index.php?module=CTMobileSettings&parent=Settings&view=Details',$max_id));
    }
	/**
     * remove CTMobileSettings Widgets from CRM Settings > Other Settings
     * parameters None.
     * @return None
     */
	static function removeWidgetTo() {
        global $adb;
        $widgetType = 'HEADERSCRIPT';
        $widgetName = 'CTMobileSettingsJs';
        $link = 'layouts/v7/modules/CTMobileSettings/resources/CTMobileSettings.js';
        include_once 'vtlib/Vtiger/Module.php';

        $moduleNames = array('CTMobileSettings');
        foreach($moduleNames as $moduleName) {
            $module = Vtiger_Module::getInstance($moduleName);
            if($module) {
                $module->deleteLink($widgetType, $widgetName, $link);
            }
        }
        $adb->pquery("DELETE FROM vtiger_settings_field WHERE `name` = ?",array('CTMobileSettings'));
    }
    
}
