<?php
/***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/

include_once 'modules/Vtiger/CRMEntity.php';

class Relations extends Vtiger_CRMEntity {
	var $table_name = 'vtiger_relations';
	var $table_index= 'relationsid';

	/**
	 * Mandatory table for supporting custom fields.
	 */
	var $customFieldTable = Array('vtiger_relationscf', 'relationsid');

	/**
	 * Mandatory for Saving, Include tables related to this module.
	 */
	var $tab_name = Array('vtiger_crmentity', 'vtiger_relations', 'vtiger_relationscf');

	/**
	 * Mandatory for Saving, Include tablename and tablekey columnname here.
	 */
	var $tab_name_index = Array(
		'vtiger_crmentity' => 'crmid',
		'vtiger_relations' => 'relationsid',
		'vtiger_relationscf'=>'relationsid');

	/**
	 * Mandatory for Listing (Related listview)
	 */
	var $list_fields = Array (
		'LBL_REL_NO' => array('relations', 'rel_no'),
		'LBL_ACTOR_A' => array('relations', 'actor_a'),
		'LBL_ACTOR_B' => array('relations', 'actor_b'),
		'LBL_RELATION_TYPE' => array('relations', 'relation_type'),
		'LBL_ENDDATE' => array('relations', 'enddate'),

	);
	var $list_fields_name = Array (
		'LBL_REL_NO' => 'rel_no',
		'LBL_ACTOR_A' => 'actor_a',
		'LBL_ACTOR_B' => 'actor_b',
		'LBL_RELATION_TYPE' => 'relation_type',
		'LBL_ENDDATE' => 'enddate',

	);

	// Make the field link to detail view
	var $list_link_field = '';

	// For Popup listview and UI type support
	var $search_fields = Array(
		'LBL_REL_NO' => array('relations', 'rel_no'),
		'LBL_ACTOR_A' => array('relations', 'actor_a'),
		'LBL_ACTOR_B' => array('relations', 'actor_b'),
		'LBL_RELATION_TYPE' => array('relations', 'relation_type'),
		'LBL_ENDDATE' => array('relations', 'enddate'),

	);
	var $search_fields_name = Array (
		'LBL_REL_NO' => 'rel_no',
		'LBL_ACTOR_A' => 'actor_a',
		'LBL_ACTOR_B' => 'actor_b',
		'LBL_RELATION_TYPE' => 'relation_type',
		'LBL_ENDDATE' => 'enddate',

	);

	// For Popup window record selection
	var $popup_fields = Array ('');

	// For Alphabetical search
	var $def_basicsearch_col = '';

	// Column value to use on detail view record text display
	var $def_detailview_recname = '';

	// Used when enabling/disabling the mandatory fields for the module.
	// Refers to vtiger_field.fieldname values.
	var $mandatory_fields = Array('','assigned_user_id');

	var $default_order_by = '';
	var $default_sort_order='ASC';

	/**
	* Invoked when special actions are performed on the module.
	* @param String Module name
	* @param String Event Type
	*/
	function vtlib_handler($moduleName, $eventType) {
		require_once('include/utils/utils.php');
		global $adb;

 		if($eventType == 'module.postinstall') {
			global $adb;
			include_once('vtlib/Vtiger/Module.php');

			// Mark the module as Standard module
			$adb->pquery('UPDATE vtiger_tab SET customized=0 WHERE name=?', array($moduleName));

			//adds sharing accsess
			$RelationModule  = Vtiger_Module::getInstance('Relations');
			Vtiger_Access::setDefaultSharing($RelationModule);

			//Showing Assets module in the related modules in the More Information Tab
			$relationsInstance = Vtiger_Module::getInstance('Relations');
			$relationsLabel = 'Relations';

			$accountInstance = Vtiger_Module::getInstance('Accounts');
			$accountInstance->setRelatedlist($relationsInstance,$relationsLabel,array(ADD),'get_relations');

			$productInstance = Vtiger_Module::getInstance('Contacts');
			$productInstance->setRelatedlist($relationsInstance,$relationsLabel,array(ADD),'get_relations');

			$InvoiceInstance = Vtiger_Module::getInstance('Leads');
			$InvoiceInstance->setRelatedlist($relationsInstance,$relationsLabel,array(ADD),'get_relations');

			$result = $adb->pquery("SELECT 1 FROM vtiger_modentity_num WHERE semodule = ? AND active = 1", array($moduleName));
			if (!($adb->num_rows($result))) {
				//Initialize module sequence for the module
				$adb->pquery("INSERT INTO vtiger_modentity_num values(?,?,?,?,?,?)", array($adb->getUniqueId("vtiger_modentity_num"), $moduleName, 'REL', 1, 1, 1));
			}

		} else if($eventType == 'module.disabled') {
			// TODO Handle actions before this module is being uninstalled.
		} else if($eventType == 'module.preuninstall') {
			// TODO Handle actions when this module is about to be deleted.
		} else if($eventType == 'module.preupdate') {
			// TODO Handle actions before this module is updated.
		} else if($eventType == 'module.postupdate') {
			//Delete duplicates from all picklist
			static::deleteDuplicatesFromAllPickLists($moduleName);
		}		
 	}

	/**
	 * Delete doubloons from all pick list from module
	 */
	public static function deleteDuplicatesFromAllPickLists($moduleName)
	{
		global $adb,$log;

		$log->debug("Invoking deleteDuplicatesFromAllPickList(".$moduleName.") method ...START");

		//Deleting doubloons
		$query = "SELECT columnname FROM `vtiger_field` WHERE uitype in (15,16,33) "
				. "and tabid in (select tabid from vtiger_tab where name = '$moduleName')";
		$result = $adb->pquery($query, array());

		$a_picklists = array();
		while($row = $adb->fetchByAssoc($result))
		{
			$a_picklists[] = $row["columnname"];
		}
		
		foreach ($a_picklists as $picklist)
		{
			static::deleteDuplicatesFromPickList($picklist);
		}
		
		$log->debug("Invoking deleteDuplicatesFromAllPickList(".$moduleName.") method ...DONE");
	}
	
	public static function deleteDuplicatesFromPickList($pickListName)
	{
		global $adb,$log;
		
		$log->debug("Invoking deleteDuplicatesFromPickList(".$pickListName.") method ...START");
	
		//Deleting doubloons
		$query = "SELECT {$pickListName}id FROM vtiger_{$pickListName} GROUP BY {$pickListName}";
		$result = $adb->pquery($query, array());
	
		$a_uniqueIds = array();
		while($row = $adb->fetchByAssoc($result))
		{
			$a_uniqueIds[] = $row[$pickListName.'id'];
		}
	
		if(!empty($a_uniqueIds))
		{
			$query = "DELETE FROM vtiger_{$pickListName} WHERE {$pickListName}id NOT IN (".implode(",", $a_uniqueIds).")";
			$adb->pquery($query, array());
		}
		
		$log->debug("Invoking deleteDuplicatesFromPickList(".$pickListName.") method ...DONE");
	}
}