<?php
/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/

include_once 'modules/Vtiger/CRMEntity.php';

class WebVisits extends Vtiger_CRMEntity {
	var $table_name = 'vtiger_webvisits';
	var $table_index= 'webvisitsid';

	/**
	 * Mandatory table for supporting custom fields.
	 */
	var $customFieldTable = Array('vtiger_webvisitscf', 'webvisitsid');

	/**
	 * Mandatory for Saving, Include tables related to this module.
	 */
	var $tab_name = Array('vtiger_crmentity', 'vtiger_webvisits', 'vtiger_webvisitscf');

	/**
	 * Mandatory for Saving, Include tablename and tablekey columnname here.
	 */
	var $tab_name_index = Array(
		'vtiger_crmentity' => 'crmid',
		'vtiger_webvisits' => 'webvisitsid',
		'vtiger_webvisitscf'=>'webvisitsid');

	/**
	 * Mandatory for Listing (Related listview)
	 */
	var $list_fields = Array (
		/* Format: Field Label => Array(tablename, columnname) */
		// tablename should not have prefix 'vtiger_'
		'Created Time' => Array('crmentity','createdtime'),
		'Snoobi OrgId' => Array('webvisits','snoobi_idvisitor'),
		'Salesfeed Segments' => Array('webvisits','wv_sfsegments'),
		'Visited Pages' => Array('webvisits','nofpages'),
		'Score' => Array('webvisits','score'),
		'Score Groups' => Array('webvisits','score_groups'),
		'Referer Name' => Array('webvisits','referrer_name'),
		'Referer keyword' => Array('webvisits', 'referrer_keyword'),
		'Entry URL' => Array('webvisits','entry_url'),
		'Web Location No' => Array('webvisits', 'webvisit_no'),
	);
	var $list_fields_name = Array (
		/* Format: Field Label => fieldname */
		'Created Time' => 'createdtime',
		'Snoobi OrgId' => 'snoobi_idvisitor',
		'Salesfeed Segments' => 'wv_sfsegments',
		'Visited Pages' => 'nofpages',
		'Score' => 'score',
		'Score Groups' => 'score_groups',
		'Referer Name' => 'referrer_name',
		'Referer keyword' => 'referrer_keyword',
		'Entry URL' => 'entry_url',
		'Web Visit No' => 'webvisit_no',
		);

	// Make the field link to detail view
	var $list_link_field = 'weblocation_no';

	// For Popup listview and UI type support
	var $search_fields = Array(
		/* Format: Field Label => Array(tablename, columnname) */
		// tablename should not have prefix 'vtiger_'
		'Web Visit No' => Array('webvisits', 'webvisit_no'),
		'Assigned To' => Array('vtiger_crmentity','assigned_user_id'),
	);
	var $search_fields_name = Array (
		/* Format: Field Label => fieldname */
		'Web Visit No' => 'webvisit_no',
		'Assigned To' => 'assigned_user_id',
	);

	// For Popup window record selection
	var $popup_fields = Array ('webvisit_no');

	// For Alphabetical search
	var $def_basicsearch_col = 'webvisit_no';

	// Column value to use on detail view record text display
	var $def_detailview_recname = 'webvisit_no';

	// Used when enabling/disabling the mandatory fields for the module.
	// Refers to vtiger_field.fieldname values.
	var $mandatory_fields = Array('webvisit_no','assigned_user_id');

	var $default_order_by = 'webvisit_no';
	var $default_sort_order='ASC';

	/**
	* Invoked when special actions are performed on the module.
	* @param String Module name
	* @param String Event Type
	*/
	function vtlib_handler($moduleName, $eventType) {
		global $adb;
 		if($eventType == 'module.postinstall') {
			WebVisits::setWSEntity();
			WebVisits::setChangeUIType();
			WebVisits::createTable();
			WebVisits::createSettingsTable();
			WebVisits::createPicklist();
			WebVisits::setRelationWebLocations();
			WebVisits::setRelationWebVisits();
			WebVisits::setLeadsListViewFields();
			WebVisits::setAccountsListViewFields();
			WebVisits::setContactsListViewFields();	
			WebVisits::setCampaignsListViewFields();
			// TODO Handle actions after this module is installed.
		} else if($eventType == 'module.disabled') {
			// TODO Handle actions before this module is being uninstalled.
		} else if($eventType == 'module.preuninstall') {
			// TODO Handle actions when this module is about to be deleted.
		} else if($eventType == 'module.preupdate') {
			// TODO Handle actions before this module is updated.
		} else if($eventType == 'module.postupdate') {
			WebVisits::setWSEntity();
			WebVisits::setChangeUIType();
			WebVisits::createTable();
			WebVisits::createSettingsTable();
			WebVisits::createPicklist();
			WebVisits::setRelationWebLocations();
			WebVisits::setRelationWebVisits();
			WebVisits::setLeadsListViewFields();	
			WebVisits::setAccountsListViewFields();
			WebVisits::setContactsListViewFields();
			WebVisits::setCampaignsListViewFields();
			// TODO Handle actions after this module is updated.
		}
 	}
	static function setWSEntity() {
		global $log;
		$log->debug("Entering setWSEntity() method....");
		global $adb;
		
		$query = "SELECT name FROM vtiger_ws_entity WHERE name=?";
		$result = $adb->pquery($query,array("WebVisits"));
		$norows = $adb->num_rows($result);
		if($norows==0)
		{		 
			$qry = "INSERT INTO vtiger_ws_entity (name, handler_path, handler_class, ismodule) 
					VALUES ('WebVisits', 'include/Webservices/VtigerModuleOperation.php', 'VtigerModuleOperation', '1')";
			$res = $adb->pquery($qry,array());
		}
		
		$log->debug("Exiting setWSEntity() method....");					
	}
	//Change text field to multiselect picklist 
	static function setChangeUIType() {
		global $log;
		$log->debug("Entering setChangeUIType() method....");
		global $adb;
		
		$query1 = "UPDATE `vtiger_field` SET `uitype` = '33' WHERE columnname='score_groups' AND tablename='vtiger_webvisits'";
		$result1 = $adb->pquery($query1,array());
		
		$query2 = "UPDATE `vtiger_field` SET `uitype` = '33' WHERE columnname='wv_sfsegments' AND tablename='vtiger_webvisits'";
		$result2 = $adb->pquery($query2,array());
		
		$query3 = "UPDATE `vtiger_field` SET `uitype` = '33' WHERE columnname='wv_sftags' AND tablename='vtiger_webvisits'";
		$result3 = $adb->pquery($query3,array());
		$log->debug("Exiting setChangeUIType() method....");
	}
	//Create table for picklist
	static function createTable() {
		global $log;
		$log->debug("Entering createTable() method....");
		global $adb;
		
		$query = "CREATE TABLE IF NOT EXISTS `vtiger_score_groups` (
				  `score_groupsid` int(11) NOT NULL AUTO_INCREMENT,
				  `score_groups` varchar(200) NOT NULL,
				  `presence` int(1) NOT NULL,
				  `picklist_valueid` int(11) NOT NULL,
				  `sortorderid` int(11) DEFAULT NULL,
				  PRIMARY KEY (`score_groupsid`)
				) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1";
		$result = $adb->pquery($query,array());
		
		$query1 = "CREATE TABLE IF NOT EXISTS `vtiger_score_groups_seq` (
					  `id` int(11) NOT NULL
					) ENGINE=MyISAM DEFAULT CHARSET=utf8;";
		$result1 = $adb->pquery($query1,array());
		
		$log->debug("Exiting createTable() method....");					
	}
	//Create settings table for WebVisits module
	static function createSettingsTable() {
		global $log;
		$log->debug("Entering createSettingsTable() method....");
		global $adb;
		
		$query = "CREATE TABLE IF NOT EXISTS `vtiger_webvisits_settings` (
					  `id` int(11) NOT NULL AUTO_INCREMENT,
					  `webclick_tracker_accnum` varchar(255) NOT NULL,
					  `minimum_lead_score` int(11) NOT NULL,
					  `status_for_new_lead` varchar(255) NOT NULL,
					  `reactivate_lead_new_visit` varchar(3) NOT NULL,
					  `assumed_closed_status` varchar(255) NOT NULL,
					  `status_for_reactivated_lead` varchar(255) NOT NULL,
					  `piwik_enabled` varchar(3) NOT NULL,
					  `piwik_location` varchar(255) NOT NULL,
					  `piwik_sites` varchar(255) NOT NULL,
					  `salesfeed_enabled` varchar(255) NOT NULL,
					  `salesfeed_accnum` varchar(255) NOT NULL,
					  `snoobi_enabled` varchar(3) NOT NULL,
					  `snoobi_accnum` varchar(255) NOT NULL,
					  PRIMARY KEY (`id`)
					) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ";
		$result = $adb->pquery($query,array());
		
		$col = $adb->pquery("SELECT id FROM vtiger_webvisits_settings",array());
		if (!$col){
			$query = "ALTER TABLE `vtiger_webvisits_settings` ADD `id` INT NOT NULL AUTO_INCREMENT FIRST , ADD PRIMARY KEY ( `id` )";
			$result = $adb->pquery($query,array());
		}
		$log->debug("Exiting createSettingsTable() method....");					
	}
	// Insert picklist entry to the picklist table
	static function createPicklist() {
		global $log;
		$log->debug("Entering createPicklist() method....");
		global $adb;
		
		$query2 = "SELECT name FROM vtiger_picklist WHERE name=?";
		$result2 = $adb->pquery($query2,array("score_groups"));
		$norows = $adb->num_rows($result2);
		if($norows==0)
		{
			$query = "INSERT INTO `vtiger_picklist` (`name`) VALUES ('score_groups')";
			$result = $adb->pquery($query,array());
		}
		
		$query1 	= "SELECT picklistid FROM vtiger_picklist WHERE name=?";
		$result1 	= $adb->pquery($query1,array("score_groups"));
		$picklistid	= $adb->query_result($result1,0,'picklistid');
		if($picklistid != '')
		{		 
			$qry = "UPDATE vtiger_picklist_seq SET id = '$picklistid'";
			$res = $adb->pquery($qry,array());
		}
		
		$log->debug("Exiting createPicklist() method....");					
	}
	//Create relation for module WebLocations, WebLocationSources & WebVisits
	static function setRelationWebLocations() {
		global $log;
		$log->debug("Entering setRelationWebLocations() method....");
		global $adb;
		
		$query  = "SELECT tabid FROM `vtiger_tab`  WHERE `tablabel` = 'WebLocations'";
		$result = $adb->pquery($query,array());
		$tabid	= $adb->query_result($result,0,'tabid');
		
		$query1 = "SELECT tabid FROM `vtiger_tab`  WHERE `tablabel` = 'WebLocationSources'";
		$result1= $adb->pquery($query1,array());
		$tabid1	= $adb->query_result($result1,0,'tabid');
		
		$query2 = "SELECT tabid FROM `vtiger_tab`  WHERE `tablabel` = 'WebVisits'";
		$result2= $adb->pquery($query2,array());
		$tabid2	= $adb->query_result($result2,0,'tabid');
		
		$qry = "SELECT tabid,related_tabid FROM vtiger_relatedlists WHERE tabid=? AND related_tabid=?";
		$res = $adb->pquery($qry,array($tabid,$tabid1));
		$norows = $adb->num_rows($res);
		if($norows==0)
		{
			$maxid  = '';
			$maxqry = $adb->pquery("SELECT relation_id FROM vtiger_relatedlists ORDER BY relation_id DESC LIMIT 1",array());
			$maxid	= $adb->query_result($maxqry,0,'relation_id');
			$maxid	= $maxid +1;
			$qry3 	= "INSERT INTO vtiger_relatedlists (relation_id,tabid, related_tabid, name, sequence, label, actions) 
						VALUES ('$maxid','$tabid', '$tabid1', 'get_related_list', '1', 'Web Location Sources', 'ADD')";
			$res3	= $adb->pquery($qry3,array());
		}
		
		$qry1 = "SELECT tabid,related_tabid FROM vtiger_relatedlists WHERE tabid=? AND related_tabid=?";
		$res1 = $adb->pquery($qry1,array($tabid,$tabid2));
		$norows1 = $adb->num_rows($res1);
		if($norows1==0)
		{
			$maxid1 = '';
			$maxqry1 = $adb->pquery("SELECT relation_id FROM vtiger_relatedlists ORDER BY relation_id DESC LIMIT 1",array());
			$maxid1	= $adb->query_result($maxqry1,0,'relation_id');
			$maxid1	= $maxid1 +1;
			$qry2 = "INSERT INTO vtiger_relatedlists (relation_id,tabid, related_tabid, name, sequence, label, actions) 
					VALUES ('$maxid1','$tabid', '$tabid2', 'get_related_list', '2', 'Web Visits', 'ADD')";
			$res2 = $adb->pquery($qry2,array());
		}
		
		$log->debug("Exiting setRelationWebLocations() method....");					
	}
	
	//Create relation for module WebLocations, WebLocationSources & WebVisits
	static function setRelationWebVisits() {
		global $log;
		$log->debug("Entering setRelationWebVisits() method....");
		global $adb;
		
		$query  = "SELECT tabid FROM `vtiger_tab`  WHERE `tablabel` = 'WebVisits'";
		$result = $adb->pquery($query,array());
		$tabid	= $adb->query_result($result,0,'tabid');
		
		$query1 = "SELECT tabid FROM `vtiger_tab`  WHERE `tablabel` = 'WebLocations'";
		$result1= $adb->pquery($query1,array());
		$tabid1	= $adb->query_result($result1,0,'tabid');
		
		$qry = "SELECT tabid,related_tabid FROM vtiger_relatedlists WHERE tabid=? AND related_tabid=?";
		$res = $adb->pquery($qry,array($tabid,$tabid1));
		$norows = $adb->num_rows($res);
		if($norows==0)
		{
			$maxid  = '';
			$maxqry = $adb->pquery("SELECT relation_id FROM vtiger_relatedlists ORDER BY relation_id DESC LIMIT 1",array());
			$maxid	= $adb->query_result($maxqry,0,'relation_id');
			$maxid	= $maxid +1;
			$qry3 = "INSERT INTO vtiger_relatedlists (relation_id,tabid, related_tabid, name, sequence, label, actions) 
					VALUES ('$maxid','$tabid', '$tabid1', 'get_related_list', '1', 'Web Locations', 'ADD')";
			$res3 = $adb->pquery($qry3,array());
		}
		
		$log->debug("Exiting setRelationWebVisits() method....");					
	}
	/**
	 * Function to set fields to list view in leads module
	 */
	static function setLeadsListViewFields() {
		global $log;
		$log->debug("Entering setLeadsListViewFields() method....");
		global $adb;
		
		$qry = "SELECT cvid FROM vtiger_customview  WHERE entitytype = 'Leads' AND viewname = 'All'";
		$res = $adb->pquery($qry,array());
		$cvid=	$adb->query_result($res,0,'cvid');
		
		$qrydel = "DELETE FROM vtiger_cvcolumnlist WHERE cvid=?";
		$resdel = $adb->pquery($qrydel,array($cvid));
		
		$insertqry1 = "INSERT INTO vtiger_cvcolumnlist (cvid,columnindex,columnname)VALUES ('$cvid', '1', 'vtiger_leaddetails:lead_no:lead_no:Lead No:V');";
		$res1 		= $adb->pquery($insertqry1,array());
		$insertqry2 = "INSERT INTO vtiger_cvcolumnlist (cvid,columnindex,columnname)VALUES ('$cvid', '2', 'vtiger_leaddetails:company:company:Company:V');";
		$res2 		= $adb->pquery($insertqry2,array());
		$insertqry3 = "INSERT INTO vtiger_cvcolumnlist (cvid,columnindex,columnname)VALUES ('$cvid', '3', 'vtiger_leaddetails:lastname:lastname:Last Name:V');";
		$res3 		= $adb->pquery($insertqry3,array());
		$insertqry4 = "INSERT INTO vtiger_cvcolumnlist (cvid,columnindex,columnname)VALUES ('$cvid', '4', 'vtiger_leaddetails:wv_score:wv_score:Score:I');";
		$res4 		= $adb->pquery($insertqry4,array());
		$insertqry5 = "INSERT INTO vtiger_cvcolumnlist (cvid,columnindex,columnname)VALUES ('$cvid', '5', 'vtiger_leaddetails:wv_scoregroups:wv_scoregroups:Scoregroups:V');";
		$res5 		= $adb->pquery($insertqry5,array());
		$insertqry6 = "INSERT INTO vtiger_cvcolumnlist (cvid,columnindex,columnname)VALUES ('$cvid', '6', 'vtiger_leaddetails:wv_datefirstvisit:wv_datefirstvisit:First Visit Date:D');";
		$res6 		= $adb->pquery($insertqry6,array());
		$insertqry7 = "INSERT INTO vtiger_cvcolumnlist (cvid,columnindex,columnname)VALUES ('$cvid', '7', 'vtiger_leaddetails:wv_nofvisits:wv_nofvisits:Visits:N');";
		$res7 		= $adb->pquery($insertqry7,array());
		$insertqry8 = "INSERT INTO vtiger_cvcolumnlist (cvid,columnindex,columnname)VALUES ('$cvid', '8', 'vtiger_leaddetails:wv_nofpages:wv_nofpages:Visited Pages:N');";
		$res8 		= $adb->pquery($insertqry8,array());
		
		$log->debug("Exiting setLeadsListViewFields() method....");					
	}
	/**
	 * Function to set fields to list view in accounts module
	 */
	static function setAccountsListViewFields() {
		global $log;
		$log->debug("Entering setLeadsListViewFields() method....");
		global $adb;
		
		$qry = "SELECT cvid FROM vtiger_customview  WHERE entitytype = 'Accounts' AND viewname = 'All'";
		$res = $adb->pquery($qry,array());
		$cvid=	$adb->query_result($res,0,'cvid');
		
		$qrydel = "DELETE FROM vtiger_cvcolumnlist WHERE cvid=?";
		$resdel = $adb->pquery($qrydel,array($cvid));
		
		$insertqry1 = "INSERT INTO vtiger_cvcolumnlist (cvid,columnindex,columnname)VALUES ('$cvid', '1', 'vtiger_account:account_no:account_no:Account No:V');";
		$res1 		= $adb->pquery($insertqry1,array());
		$insertqry2 = "INSERT INTO vtiger_cvcolumnlist (cvid,columnindex,columnname)VALUES ('$cvid', '2', 'vtiger_account:accountname:accountname:Account Name:V');";
		$res2 		= $adb->pquery($insertqry2,array());
		$insertqry3 = "INSERT INTO vtiger_cvcolumnlist (cvid,columnindex,columnname)VALUES ('$cvid', '3', 'vtiger_account:wv_score:wv_score:Score:I');";
		$res3 		= $adb->pquery($insertqry3,array());
		$insertqry4 = "INSERT INTO vtiger_cvcolumnlist (cvid,columnindex,columnname)VALUES ('$cvid', '4', 'vtiger_account:wv_scoregroups:wv_scoregroups:Scoregroups:V');";
		$res4 		= $adb->pquery($insertqry4,array());
		$insertqry5 = "INSERT INTO vtiger_cvcolumnlist (cvid,columnindex,columnname)VALUES ('$cvid', '5', 'vtiger_account:wv_datefirstvisit:wv_datefirstvisit:First Visit Date:D');";
		$res5 		= $adb->pquery($insertqry5,array());
		$insertqry6 = "INSERT INTO vtiger_cvcolumnlist (cvid,columnindex,columnname)VALUES ('$cvid', '7', 'vtiger_account:wv_nofvisits:wv_nofvisits:Visits:N');";
		$res6 		= $adb->pquery($insertqry6,array());
		$insertqry7 = "INSERT INTO vtiger_cvcolumnlist (cvid,columnindex,columnname)VALUES ('$cvid', '8', 'vtiger_account:wv_nofpages:wv_nofpages:Visited Pages:N');";
		$res7 		= $adb->pquery($insertqry7,array());
		
		$log->debug("Exiting setLeadsListViewFields() method....");					
	}
	
	/**
	 * Function to set fields to list view in contacts module
	 */
	static function setContactsListViewFields() {
		global $log;
		$log->debug("Entering setLeadsListViewFields() method....");
		global $adb;
		
		$qry = "SELECT cvid FROM vtiger_customview  WHERE entitytype = 'Contacts' AND viewname = 'All'";
		$res = $adb->pquery($qry,array());
		$cvid=	$adb->query_result($res,0,'cvid');
		
		$qrydel = "DELETE FROM vtiger_cvcolumnlist WHERE cvid=?";
		$resdel = $adb->pquery($qrydel,array($cvid));
		
		$insertqry1 = "INSERT INTO vtiger_cvcolumnlist (cvid,columnindex,columnname)VALUES ('$cvid', '1', 'vtiger_contactdetails:contact_no:contact_no:Contact Id:V');";
		$res1 		= $adb->pquery($insertqry1,array());
		$insertqry2 = "INSERT INTO vtiger_cvcolumnlist (cvid,columnindex,columnname)VALUES ('$cvid', '2', 'vtiger_contactdetails:lastname:lastname:Last Name:V');";
		$res2 		= $adb->pquery($insertqry2,array());
		$insertqry3 = "INSERT INTO vtiger_cvcolumnlist (cvid,columnindex,columnname)VALUES ('$cvid', '3', 'vtiger_contactdetails:account_id:account_id:Account Name:V');";
		$res3 		= $adb->pquery($insertqry3,array());
		$insertqry4 = "INSERT INTO vtiger_cvcolumnlist (cvid,columnindex,columnname)VALUES ('$cvid', '4', 'vtiger_contactdetails:wv_score:wv_score:Score:I');";
		$res4 		= $adb->pquery($insertqry4,array());
		$insertqry5 = "INSERT INTO vtiger_cvcolumnlist (cvid,columnindex,columnname)VALUES ('$cvid', '5', 'vtiger_contactdetails:wv_scoregroups:wv_scoregroups:Scoregroups:V');";
		$res5 		= $adb->pquery($insertqry5,array());
		$insertqry6 = "INSERT INTO vtiger_cvcolumnlist (cvid,columnindex,columnname)VALUES ('$cvid', '6', 'vtiger_contactdetails:wv_datefirstvisit:wv_datefirstvisit:First Visit Date:D');";
		$res6 		= $adb->pquery($insertqry6,array());
		$insertqry7 = "INSERT INTO vtiger_cvcolumnlist (cvid,columnindex,columnname)VALUES ('$cvid', '7', 'vtiger_contactdetails:wv_nofvisits:wv_nofvisits:Visits:N');";
		$res7 		= $adb->pquery($insertqry7,array());
		$insertqry8 = "INSERT INTO vtiger_cvcolumnlist (cvid,columnindex,columnname)VALUES ('$cvid', '8', 'vtiger_contactdetails:wv_nofpages:wv_nofpages:Visited Pages:N');";
		$res8 		= $adb->pquery($insertqry8,array());
		
		$log->debug("Exiting setLeadsListViewFields() method....");					
	}
	
	/**
	 * Function to set fields to list view in contacts module
	 */
	static function setCampaignsListViewFields() {
		global $log;
		$log->debug("Entering setLeadsListViewFields() method....");
		global $adb;
		
		$qry = "SELECT cvid FROM vtiger_customview  WHERE entitytype = 'Campaigns' AND viewname = 'All'";
		$res = $adb->pquery($qry,array());
		$cvid=	$adb->query_result($res,0,'cvid');
		
		$qrydel = "DELETE FROM vtiger_cvcolumnlist WHERE cvid=?";
		$resdel = $adb->pquery($qrydel,array($cvid));
		
		$insertqry1 = "INSERT INTO vtiger_cvcolumnlist (cvid,columnindex,columnname)VALUES ('$cvid', '1', 'vtiger_campaign:campaign_no:campaign_no:Campaign No:V');";
		$res1 		= $adb->pquery($insertqry1,array());
		$insertqry2 = "INSERT INTO vtiger_cvcolumnlist (cvid,columnindex,columnname)VALUES ('$cvid', '2', 'vtiger_campaign:campaignname:campaignname:Campaign Name:V');";
		$res2 		= $adb->pquery($insertqry2,array());
		$insertqry3 = "INSERT INTO vtiger_cvcolumnlist (cvid,columnindex,columnname)VALUES ('$cvid', '3', 'vtiger_campaign:wv_score:wv_score:Score:I');";
		$res3 		= $adb->pquery($insertqry3,array());
		$insertqry4 = "INSERT INTO vtiger_cvcolumnlist (cvid,columnindex,columnname)VALUES ('$cvid', '4', 'vtiger_campaign:wv_datefirstvisit:wv_datefirstvisit:First Visit Date:D');";
		$res4 		= $adb->pquery($insertqry4,array());
		$insertqry5 = "INSERT INTO vtiger_cvcolumnlist (cvid,columnindex,columnname)VALUES ('$cvid', '5', 'vtiger_campaign:wv_nofvisits:wv_nofvisits:Visits:N');";
		$res5 		= $adb->pquery($insertqry5,array());
		$insertqry6 = "INSERT INTO vtiger_cvcolumnlist (cvid,columnindex,columnname)VALUES ('$cvid', '6', 'vtiger_campaign:wv_nofpages:wv_nofpages:Visited Pages:N');";
		$res6 		= $adb->pquery($insertqry6,array());
		
		$log->debug("Exiting setLeadsListViewFields() method....");					
	}
}