<?php
/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/

class CTMobileSettings_CallRecording_View extends Settings_Vtiger_Index_View {

	public function checkPermission(Vtiger_Request $request) {
        $license_data = CTMobileSettings_Module_Model::getLicenseData();
        if(strtolower($license_data['Plan']) === 'free'){
            throw new AppException(vtranslate('LBL_PERMISSION_DENIED', 'Vtiger'));
        }else{
           return true;
        }
    }

	function getPageTitle(Vtiger_Request $request) {
        $qualifiedModuleName = $request->getModule();
        return vtranslate('CRMTiger Mobile Apps',$qualifiedModuleName).' > '.vtranslate('Call Recording',$qualifiedModuleName);
    }

	function process(Vtiger_Request $request) {
		global $root_directory;
		$viewer = $this->getViewer($request);
		$loginHistoryRecordModel = new  Settings_LoginHistory_Record_Model();
		$usersList = $loginHistoryRecordModel->getAccessibleUsers();
		$viewer->assign('USERSLIST',$usersList);

		$viewer->assign('SOURCE_MODULE', 'CTMobileSettings');
		$viewer->assign('QUALIFIED_MODULE', 'CTMobileSettings');
		$viewer->assign('MODULE', 'Settings:CTMobileSettings');
		$viewer->view('listCallRecording.tpl', $request->get('module'));
	}


	/**
	* Function to get the list of Script models to be included
	* @param Vtiger_Request $request
	* @return <Array> - List of Vtiger_JsScript_Model instances
	*/
    function getHeaderScripts(Vtiger_Request $request) {
        $headerScriptInstances = parent::getHeaderScripts($request);
        $moduleName = $request->getModule();

        $jsFileNames = array(
            "modules.CTMobileSettings.resources.CallRecording",
            "modules.Vtiger.resources.SearchList",
        );

        $jsScriptInstances = $this->checkAndConvertJsScripts($jsFileNames);
        $headerScriptInstances = array_merge($headerScriptInstances, $jsScriptInstances);
        return $headerScriptInstances;
    }
}