 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */
jQuery.Class("CTMobileSettings_RoutePlanning_Js",{
    editInstance:false,
    getInstance: function(){
        if(CTMobileSettings_RoutePlanning_Js.editInstance == false){
            var instance = new CTMobileSettings_Settings_Js();
            CTMobileSettings_RoutePlanning_Js.editInstance = instance;
            return instance;
        }
        return CTMobileSettings_RoutePlanning_Js.editInstance;
    }
},{ 
    
    registerAddStopsEvents : function(){

        jQuery(document).ready(function(){
            var CREATE_ROUTE_TEXT = jQuery('[name="CREATE_ROUTE_TEXT"]').val();
            var CREATE_ROUTE_LINK = jQuery('[name="CREATE_ROUTE_LINK"]').val();
            console.log(CREATE_ROUTE_LINK);
            if(jQuery('.settingModuleName').text().trim() == CREATE_ROUTE_TEXT){
                jQuery('.settingModuleName').html(CREATE_ROUTE_LINK);
            }
        });

        jQuery(document).on('click','.inlineAjaxCancel',function(e){
            $(jQuery(this).closest('tr')).find('.ctrouteprioritytext').removeClass('hide');
            $(jQuery(this).closest('tr')).find('[name="routepriority"]').addClass('hide');
            $(jQuery(this).closest('tr')).find('.input-save-wrap').addClass('hide');
        });

        jQuery(document).on('click','.inlineAjaxSave',function(e){
            var routepriority = $(jQuery(this).closest('tr')).find('[name="routepriority"]').val();
            $(jQuery(this).closest('tr')).find('.ctrouteprioritytext').text(routepriority);
            $(jQuery(this).closest('tr')).attr('data-ctroutepriority',routepriority);
            $(jQuery(this).closest('tr')).find('.ctrouteprioritytext').removeClass('hide');
            $(jQuery(this).closest('tr')).find('[name="routepriority"]').addClass('hide');
            $(jQuery(this).closest('tr')).find('.input-save-wrap').addClass('hide');
        });

        jQuery('#routeUser').on('change',function(){
            var assign_persons = jQuery("#routeUser option:selected").length;
            if(assign_persons){
                jQuery('#assign_person_count').text(assign_persons);
            }
        });

        jQuery('#AddStops').on('click',function(){
            var popupInstance = Vtiger_Popup_Js.getInstance();
            var params = {};
            params['module'] = "CTMobileSettings";
            params['view'] = "RoutePlanning";
            params['mode'] = "AddStops";
            popupInstance.showPopup(params);
        });

        var step = jQuery('#step').val();
        if(step == 2){
            var routename = window.localStorage.getItem('routename');
            if(routename){
                jQuery('#routename').val(routename);
            }
            var routedate = window.localStorage.getItem('routedate');
            if(routedate){
                jQuery('#routedate').val(routedate);
            }

            var routeUser = window.localStorage.getItem('routeUser');
            if(routeUser){
                //jQuery('#routeUser').val(routeUser);
                var routeUserArray = routeUser.split(",");
                jQuery('#routeUser').select2('val', routeUserArray);
                app.changeSelectElementView(jQuery('#routeUser'));
                app.showSelect2ElementView(jQuery('#routeUser'));
                var assign_persons = jQuery("#routeUser option:selected").length;
                if(assign_persons){
                    jQuery('#assign_person_count').text(assign_persons);
                }
            }else{
                var assign_persons = jQuery("#routeUser option:selected").length;
                if(assign_persons){
                    jQuery('#assign_person_count').text(assign_persons);
                }
            }
            
            var tabledata = window.localStorage.getItem('table');
            //tabledata.find('.distanceDiv').remove();
            //tabledata.find('.durationDiv').remove();
            if(tabledata){
                jQuery('#example1 tbody').html(tabledata);
            }

            var stoplength = jQuery('#example1 tbody').find('tr').length;
            if(stoplength){
                jQuery('#stops_count').text(stoplength);
            }

            var trlength = jQuery('#example1 tbody').find('tr').length;
            var data = Array();
            var trr = jQuery('#example1 tbody').find('tr');
            for(var i=0;i<trlength;i++){
                var oldtr = trr[i];
                data.push({'lat':oldtr.getAttribute('data-latitude'),'lng':oldtr.getAttribute('data-longitude'),'label':oldtr.getAttribute('data-label'),'check_in_latitude':oldtr.getAttribute('data-check_in_latitude'),'check_in_longitude':oldtr.getAttribute('data-check_in_longitude'),'check_out_latitude':oldtr.getAttribute('data-check_out_latitude'),'check_out_longitude':oldtr.getAttribute('data-check_out_longitude')});
            }
            if(data.length > 0){
                setTimeout(function(){
                    drawRoute(data);
                },500);
            }
            var record = jQuery('#record').val();
            if(record){
                jQuery('#routeUser').attr('disabled', 'disabled');
            }
        }else if(step ==1){
            var record = jQuery('#record').val();
            if(record == ''){
                var routename = window.localStorage.getItem('routename');
                if(routename){
                    jQuery('#routename').val(routename);
                }
                var routedate = window.localStorage.getItem('routedate');
                if(routedate){
                    jQuery('#routedate').val(routedate);
                }

                var routeUser = window.localStorage.getItem('routeUser');
                if(routeUser){
                    //jQuery('#routeUser').val(routeUser);
                    var routeUserArray = routeUser.split(",");
                    jQuery('#routeUser').select2('val', routeUserArray);
                    app.changeSelectElementView(jQuery('#routeUser'));
                    app.showSelect2ElementView(jQuery('#routeUser'));
                    var assign_persons = jQuery("#routeUser option:selected").length;
                    if(assign_persons){
                        jQuery('#assign_person_count').text(assign_persons);
                    }
                }else{
                    var assign_persons = jQuery("#routeUser option:selected").length;
                    if(assign_persons){
                        jQuery('#assign_person_count').text(assign_persons);
                    }
                }
                
                var tabledata = window.localStorage.getItem('table');
                if(tabledata){
                    jQuery('#example1 tbody').html(tabledata);
                }

                var stoplength = jQuery('#example1 tbody').find('tr').length;
                if(stoplength){
                    jQuery('#stops_count').text(stoplength);
                }

                window.localStorage.setItem('routename', '');
                window.localStorage.setItem('routedate', '');
                window.localStorage.setItem('table', '');
                window.localStorage.setItem('routeUser','');
            }else{
                var assign_persons = jQuery("#routeUser option:selected").length;
                if(assign_persons){
                    jQuery('#assign_person_count').text(assign_persons);
                }
                var stoplength = jQuery('#example1 tbody').find('tr').length;
                if(stoplength){
                    jQuery('#stops_count').text(stoplength);
                }
                jQuery('#routeUser').attr('disabled', 'disabled');
            }
        }else{
            var record = jQuery('#record').val();
            if(record != ''){
                var assign_persons = jQuery("#routeUser option:selected").length;
                if(assign_persons){
                    jQuery('#assign_person_count').text(assign_persons);
                }
                var stoplength = jQuery('#example1 tbody').find('tr').length;
                if(stoplength){
                    jQuery('#stops_count').text(stoplength);
                }
            }
        }

        jQuery('#saveRoute').on('click',function(){
            app.helper.showProgress();
            var routename = jQuery('#routename').val();
            var record = jQuery('#record').val();
            var routedate = jQuery('#routedate').val();
            var routeUser = jQuery('#routeUser').val();
            
            var trlength = jQuery('#example1 tbody').find('tr').length;
            var assign_persons = jQuery("#routeUser option:selected").length;
            var data = Array();
            var trr = jQuery('#example1 tbody').find('tr');
            for(var i=0;i<trlength;i++){
                var oldtr = trr[i];
                data.push({'crmid':oldtr.getAttribute('data-crmid'),'ctroutepriority':oldtr.getAttribute('data-ctroutepriority')});
            }

            if(routename.trim() == ''){
                app.helper.hideProgress();
                var params = {
                    title : app.vtranslate('Please enter Route Name'),
                    text: app.vtranslate('Please enter Route Name'),
                    animation: 'show',
                    type: 'error'
                };
                Vtiger_Helper_Js.showPnotify(params);
                jQuery('#routename').focus();
            }else if(routedate.trim() == ''){
                app.helper.hideProgress();
                var params = {
                    title : app.vtranslate('Please Select Route Date'),
                    text: app.vtranslate('Please Select Route Date'),
                    animation: 'show',
                    type: 'error'
                };
                Vtiger_Helper_Js.showPnotify(params);
            }else if(trlength == 0){
                app.helper.hideProgress();
                var params = {
                    title : app.vtranslate('Please add atleast one stop'),
                    text: app.vtranslate('Please add atleast one stop'),
                    animation: 'show',
                    type: 'error'
                };
                Vtiger_Helper_Js.showPnotify(params);
            }else if(assign_persons == 0){
                app.helper.hideProgress();
                var params = {
                    title : app.vtranslate('Please add atleast one user'),
                    text: app.vtranslate('Please add atleast one user'),
                    animation: 'show',
                    type: 'error'
                };
                Vtiger_Helper_Js.showPnotify(params);
            }else{
                jQuery('#saveRoute').prop('disabled', true);
                var params = {};
                params['module'] = "CTMobileSettings";
                params['view'] = "RoutePlanning";
                params['mode'] = "SaveRoute";
                params['record'] = record;
                params['ctroutename'] = routename;
                params['ctroute_date'] = routedate;
                params['routeUser'] = routeUser;
                params['ctroute_realtedto'] = data;
                AppConnector.request(params).then(function(data) {
                     app.helper.hideProgress();
                     window.localStorage.setItem('routename', '');
                     window.localStorage.setItem('routedate', '');
                     window.localStorage.setItem('table', '');
                     window.localStorage.setItem('routeUser', '');
                     app.helper.showSuccessNotification({message: app.vtranslate('Route Saved successfully')});
                     location.href = 'index.php?module=CTMobileSettings&parent=Settings&view=RouteAnalytics';
                });
            }
        });

        jQuery('#prevStep').on('click',function(){
            var record = jQuery('#record').val();
            if(record){
                location.href = 'index.php?module=CTMobileSettings&parent=Settings&view=RoutePlanning&mode=Edit&record='+record+'&step=step1';
            }else{
                var routename = jQuery('#routename').val();
                var routedate = jQuery('#routedate').val();
                var routeUser = jQuery('#routeUser').val();
                var trlength = jQuery('#example1 tbody').find('tr').length;
                var tabledata = jQuery('#example1 tbody').find('.distanceDiv,.durationDiv,br').remove();
                var tabledata = jQuery('#example1 tbody').html();
                //tabledata.find('.distanceDiv').remove();
                //tabledata.find('.durationDiv').remove();
                window.localStorage.setItem('routename', routename);
                window.localStorage.setItem('routedate', routedate);
                window.localStorage.setItem('table', tabledata);
                window.localStorage.setItem('routeUser',routeUser);
                location.href = 'index.php?module=CTMobileSettings&parent=Settings&view=RoutePlanning&mode=Edit&step=step1';
            }
        });

        jQuery('#secondstep').on('click',function(){
            /*if (navigator.geolocation) {
                var CurrentLocation = navigator.geolocation.getCurrentPosition(showPosition);
                console.log(current_position);
            }*/
            var routename = jQuery('#routename').val();
            var routedate = jQuery('#routedate').val();
            var routeUser = jQuery('#routeUser').val();
            var trlength = jQuery('#example1 tbody').find('tr').length;
            var assign_persons = jQuery("#routeUser option:selected").length;
            
            var tabledata = jQuery('#example1 tbody').find('.distanceDiv,.durationDiv,br').remove();
            var tabledata = jQuery('#example1 tbody').html();
            //tabledata.find('.distanceDiv').remove();
            //tabledata.find('.durationDiv').remove();
            var record = jQuery('#record').val();
            if(record == ''){
                window.localStorage.setItem('routename', routename);
                window.localStorage.setItem('routedate', routedate);
                window.localStorage.setItem('table', tabledata);
                window.localStorage.setItem('routeUser',routeUser);
            }else{
                window.localStorage.setItem('routename', routename);
                window.localStorage.setItem('routedate', routedate);
                window.localStorage.setItem('table', tabledata);
                window.localStorage.setItem('routeUser',routeUser);
            }

            if(routename.trim() == ''){
                var params = {
                    title : app.vtranslate('Please enter Route Name'),
                    text: app.vtranslate('Please enter Route Name'),
                    animation: 'show',
                    type: 'error'
                };
                Vtiger_Helper_Js.showPnotify(params);
                jQuery('#routename').focus();
            }else if(routedate.trim() == ''){
                var params = {
                    title : app.vtranslate('Please Select Route Date'),
                    text: app.vtranslate('Please Select Route Date'),
                    animation: 'show',
                    type: 'error'
                };
                Vtiger_Helper_Js.showPnotify(params);
            }else if(trlength == 0){
                var params = {
                    title : app.vtranslate('Please add atleast one stop'),
                    text: app.vtranslate('Please add atleast one stop'),
                    animation: 'show',
                    type: 'error'
                };
                Vtiger_Helper_Js.showPnotify(params);
            }else if(assign_persons == 0){
                app.helper.hideProgress();
                var params = {
                    title : app.vtranslate('Please add atleast one user'),
                    text: app.vtranslate('Please add atleast one user'),
                    animation: 'show',
                    type: 'error'
                };
                Vtiger_Helper_Js.showPnotify(params);
            }else{
                var record = jQuery('#record').val();
                if(record){
                    location.href = 'index.php?module=CTMobileSettings&parent=Settings&view=RoutePlanning&mode=Edit&record='+record+'&step=step2';
                }else{
                    location.href = 'index.php?module=CTMobileSettings&parent=Settings&view=RoutePlanning&mode=Edit&step=step2';
                }
            }
        });
    },

    /**
     * Function which will handle the registrations for the elements
     */
    registerEvents : function() {
        this.registerAddStopsEvents();
    }
});
/*var current_position;
function showPosition(position) {
  console.log(position);
  current_position = position;
}*/


jQuery(document).ready(function () {
    var instance = new CTMobileSettings_RoutePlanning_Js();
    instance.registerEvents();

    var searchListInstance = new Vtiger_SearchList_Js();
    var BasicSearchInstance = new Vtiger_BasicSearch_Js();
    BasicSearchInstance.registerEvents();
    var vtigerInstance = new Settings_Vtiger_Index_Js();
    vtigerInstance.registerEvents();

});


function deleteStops(event){
  var message = app.vtranslate('Are you sure want to delete this record ?');
  app.helper.showConfirmationBox({'message' : message}).then(function(data) {
    event.closest('tr').remove();
    reArrangeSequence();
    var stoplength = jQuery('#example1 tbody').find('tr').length;
    jQuery('#stops_count').text(stoplength);
  });
}

function changePriority(event){
    $(event.closest('tr')).find('.ctrouteprioritytext').addClass('hide');
    $(event.closest('tr')).find('[name="routepriority"]').removeClass('hide').select2();
    $(event.closest('tr')).find('.input-save-wrap').removeClass('hide');
  
}




