 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */
jQuery.Class("CTMobileSettings_ManualSync_Js",{
    editInstance:false,
    getInstance: function(){
        if(CTMobileSettings_Settings_Js.editInstance == false){
            var instance = new CTMobileSettings_Settings_Js();
            CTMobileSettings_Settings_Js.editInstance = instance;
            return instance;
        }
        return CTMobileSettings_Settings_Js.editInstance;
    }
},{
    
    registerImportFile:function() {

      var mainmodule = app.getModuleName();
      var parentmodule = app.getParentModuleName();
      var action = 'getUserLatLong';
      var mode = 'getModuleLatLongRecords';
      var src_module = jQuery('#SyncTableModule').val();
      var url = "index.php?module="+mainmodule+"&parent="+parentmodule+"&action="+action+"&mode="+mode+"&src_module="+src_module;
      table = jQuery('#manualSyncTable').DataTable({
      'paging'      : true,
      'lengthChange': false,
      'searching'   : true,
      'ordering'    : false,
      'info'        : true,
      'autoWidth'   : false,
      'pageLength' : 20,
      'processing': true,
      'serverSide': true,
      'serverMethod': 'post',
      'destroy': true,
      'ajax': {
          'url':url
      },
      "language": {
          "sProcessing": app.vtranslate('Processing'),
          "sEmptyTable": app.vtranslate('No data available in table'),
          "sInfo": app.vtranslate('Showing')+" _START_ "+app.vtranslate('to')+" _END_ "+app.vtranslate('of')+" _TOTAL_ "+app.vtranslate('entries'),
          "sInfoEmpty": app.vtranslate('Showing')+" 0 "+app.vtranslate('to')+" 0 "+app.vtranslate('of')+" 0 "+app.vtranslate('entries'),
          "oPaginate": {
              "sFirst": app.vtranslate('First'),   
              "sLast": app.vtranslate('Last'),  
              "sNext":   app.vtranslate('Next'), 
              "sPrevious": app.vtranslate('Previous'),
          },
      },
      "columns": [
        { "data":"label" },
        { "data":"address" },
        { "data": "latitude" },
        { "data": "longitude" },
        { "data": "action" }
      ]
      });

      jQuery('#SyncTableModule').on('change',function(){
        var mainmodule = app.getModuleName();
        var parentmodule = app.getParentModuleName();
        var action = 'getUserLatLong';
        var mode = 'getModuleLatLongRecords';
        var src_module = jQuery(this).val();
        var url = "index.php?module="+mainmodule+"&parent="+parentmodule+"&action="+action+"&mode="+mode+"&src_module="+src_module;
        table = jQuery('#manualSyncTable').DataTable({
        'paging'      : true,
        'lengthChange': false,
        'searching'   : true,
        'ordering'    : false,
        'info'        : true,
        'autoWidth'   : false,
        'pageLength' : 20,
        'processing': true,
        'serverSide': true,
        'serverMethod': 'post',
        'destroy': true,
        'ajax': {
            'url':url
        },
        "language": {
            "sProcessing": app.vtranslate('Processing'),
            "sEmptyTable": app.vtranslate('No data available in table'),
            "sInfo": app.vtranslate('Showing')+" _START_ "+app.vtranslate('to')+" _END_ "+app.vtranslate('of')+" _TOTAL_ "+app.vtranslate('entries'),
            "sInfoEmpty": app.vtranslate('Showing')+" 0 "+app.vtranslate('to')+" 0 "+app.vtranslate('of')+" 0 "+app.vtranslate('entries'),
            "oPaginate": {
                "sFirst": app.vtranslate('First'),   
                "sLast": app.vtranslate('Last'),  
                "sNext":   app.vtranslate('Next'), 
                "sPrevious": app.vtranslate('Previous'),
            },
        },
        "columns": [
          { "data":"label" },
          { "data":"address" },
          { "data": "latitude" },
          { "data": "longitude" },
          { "data": "action" }
        ]
        });
      })

      jQuery(document).on('click','.updatelatlog',function(e){
          var recordid = jQuery(this).data('recordid');
          var itemRow = jQuery(this).closest('tr');
          var latitude = itemRow.find('[name="latitude"]').val();
          var longitude = itemRow.find('[name="longitude"]').val();
          if(latitude == '' || longitude == ''){
              app.helper.showErrorNotification({'message' : app.vtranslate('Please enter latitude and longitude first') });
          }else{
               var params= {
                  "module" : "CTMobileSettings",
                  "action" :"getUserLatLong",
                  "src_module" : jQuery('#SyncTableModule').val(),
                  "mode" : "InsetLatLong",
                  "recordid" : recordid,
                  'latitude':latitude,
                  'longitude':longitude
              };
              app.helper.showProgress();
              app.request.post({data: params}).then(function (err, res) {
                  app.helper.hideProgress();
                   app.helper.showSuccessNotification({'message' : app.vtranslate('Latitude and Longitude updated successfully')});
              });
          }
      });

        jQuery("#filename").on("change", function(e) {
          var fp = $("#filename");
          var lg = fp[0].files.length;
          var items = fp[0].files;
          var name = items[0].name;
          $(".uploadedFileDetails #uploadedFileName").text(name);
        });
        jQuery("#fieldfilename").on("change", function(e) {
          var fp = $("#fieldfilename");
          var lg = fp[0].files.length;
          var items = fp[0].files;
          var name = items[0].name;
          $(".uploadedFieldFileDetails #uploadedFieldFileName").text(name);
        });
        jQuery("#uploadForm").on("submit", function(e) {
            var fp = $("#filename");
            var lg = fp[0].files.length;
            if(lg > 0){
              e.preventDefault();
              var formData = new FormData(this);
              
              var params = {
                url: "index.php",
                type: "POST",
                data: formData,
                processData: false,
                contentType: false
              };
              app.helper.showProgress();
              app.request.post(params).then(function(e,res) {
                app.helper.hideProgress();
                if(res['success']){
                   app.helper.showSuccessNotification({'message' : app.vtranslate('JS_UPLOAD_SUCCESSFUL')});

                }else{
                    app.helper.showErrorNotification({'message' : res['msg'] });
                }
              });
            }else{
              app.helper.showErrorNotification({
                'message' : app.vtranslate('JS_PLEASE_SELECT_A_FILE')
              });
              return false;
            }
        });
        jQuery("#uploadEntityForm").on("submit", function(e) {
            var fp = jQuery("#fieldfilename");
            var lg = fp[0].files.length;
            if(lg > 0){
              e.preventDefault();
              var formData = new FormData(this);
              console.log(formData);
              var params = {
                url: "index.php",
                type: "POST",
                data: formData,
                processData: false,
                contentType: false
              };
              app.helper.showProgress();
              app.request.post(params).then(function(e,res) {
                app.helper.hideProgress();
                if(res.success){
                   jQuery('#uploadEntityForm').reset();
                   var popup_params = {
                      "module": 'CTMobileSettings',
                      "view": 'ManualSync',
                      "mode":'showImportStatus',
                      "totalAffectedRows": res.totalAffectedRows,
                      "totalCreatedRows": res.totalCreatedRows,
                      "totalScannedRows": res.totalScannedRows,
                      "totalUpdatedRows": res.totalUpdatedRows
                  }
                   var popupInstance = Vtiger_Popup_Js.getInstance();
                   popupInstance.showPopup(popup_params);

                   setTimeout(function() { 
                      location.reload();
                  }, 2000);
                   //app.helper.showSuccessNotification({'message' : app.vtranslate('JS_UPLOAD_SUCCESSFUL')});
                   //location.reload();
                }else{
                    app.helper.showErrorNotification({'message' : res['msg'] });
                }
              });
            }else{
              app.helper.showErrorNotification({
                'message' : app.vtranslate('JS_PLEASE_SELECT_A_FILE')
              });
              return false;
            }
        });
    },

    //hide and show file and field selection
    registerSelectChangeEvent : function(){
        jQuery("#search_module").on("change", function(e) {
          var modulename = $('#search_module').val();
          
          if(modulename != "")
            $('.contentBlock').show();
          else
            $('.contentBlock').hide();
        });
        jQuery("#entity_search_module").on("change", function(e) {

          var progressIndicatorElement = jQuery.progressIndicator({
            'position' : 'html',
            'blockInfo' : {
             'enabled' : true
            }
          });
          var modulename = $('#entity_search_module').val();
          var selectedFields=jQuery("#uploadEntityForm").find("#fieldMappingData");
          if(modulename != ""){
            $('#fieldMappingData').show();
            var params= {
                "module" : "CTMobileSettings",
                "view" :"ManualSync",
                "search_module" : modulename,
                "mode" : "fieldMapping",
                "data" : {}
            };
            AppConnector.request(params).then(
                function(data) {
                    
                    progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                    selectedFields.html(data.result);
                    app.changeSelectElementView(selectedFields);
                    app.showSelect2ElementView(selectedFields.find('select.select2'));
                }
            )
          }else{
            $('#fieldMappingData').hide();
            progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                selectedFields.html('');
            $('.entityContentBlock').hide();
          }
        });

        //change event of field selection
        jQuery("#search_field_module").live("change", function(e) {
          var modulefields = $('#search_field_module').val();
          var modulename = $('#entity_search_module').val();
          if(modulefields == null){
            $('.entityContentBlock').hide();
          }else{
            $('.entityContentBlock').show();
            var params = {
                "module" : "CTMobileSettings",
                "view" :"ManualSync",
                "mode" : "genarateCSVFile",
                "columns" : modulefields,
                "modulename" : modulename
               
            };
            app.helper.showProgress();
            app.request.post({data: params}).then(function (err, res) {
                app.helper.hideProgress();
                
            });
          }
        });


    },

    /**
     * Function which will handle the registrations for the elements
     */
    registerEvents : function() {
        $('.contentBlock').hide();
        $('.entityContentBlock').hide();
        this.registerImportFile();
        this.registerSelectChangeEvent();
    }
});


jQuery(document).ready(function () {
    var instance = new CTMobileSettings_ManualSync_Js();
    instance.registerEvents();

    var searchListInstance = new Vtiger_SearchList_Js();
    var BasicSearchInstance = new Vtiger_BasicSearch_Js();
    BasicSearchInstance.registerEvents();
    var vtigerInstance = new Settings_Vtiger_Index_Js();
    vtigerInstance.registerEvents();

});
