 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */
jQuery.Class("CTMobileSettings_APILogsSettings_Js",{
    editInstance:false,
    getInstance: function(){
        if(CTMobileSettings_APILogsSettings.editInstance == false){
            var instance = new CTMobileSettings_Settings_Js();
            CTMobileSettings_APILogsSettings_Js.editInstance = instance;
            return instance;
        }
        return CTMobileSettings_APILogsSettings_Js.editInstance;
    }
},{
    updatedBlockSequence : {},    
    registerCheckBoxChange:function() {
       
        if ( jQuery('#apilogs_settings').find('[type="checkbox"]').bootstrapSwitch('state')) {
            jQuery('#apilog_action').show();
        }else{
            jQuery('#apilog_action').hide();
        }

        jQuery("input[type='checkbox']").bootstrapSwitch();

        jQuery('#allow_notification').on('switchChange.bootstrapSwitch',function(e){
            var currentElement = jQuery(e.currentTarget);
            if (currentElement.bootstrapSwitch('state')) {
              jQuery('#apilogs_settings').find('[type="checkbox"]').bootstrapSwitch('state', true);
              jQuery('#apilog_action').show();
              registerUpdateLogValue('1');

            }else{
              jQuery('#apilogs_settings').find('[type="checkbox"]').bootstrapSwitch('state', false);
              jQuery('#apilog_action').hide();
              registerUpdateLogValue('0');
            }
        });

    },
    
    registerAPILogAction : function(){
        jQuery('#removeLogs').on('click',function(){
            var message = app.vtranslate('Are you sure want to clear API logs ?');
            app.helper.showConfirmationBox({'message' : message}).then(function(data) {
                var params = {
                    module: 'CTMobileSettings',
                    action: 'SaveAPILogsSettings',
                    mode: 'removeLogs',
                
                };
                app.helper.showProgress();
                app.request.post({data: params}).then(function (err, res) {
                    app.helper.hideProgress();
                    if(res['success']){
                        app.helper.hideModal();
                        app.helper.showSuccessNotification({message: app.vtranslate('Logs Remove Successfully')});
                    }
                });  
            });
            return false;
        });
        jQuery('#downloadLogs').on('click',function(){
            var params = {
                module: 'CTMobileSettings',
                action: 'SaveAPILogsSettings',
                mode: 'checkLogData',
            
            };
            app.helper.showProgress();
            app.request.post({data: params}).then(function (err, res) {
                app.helper.hideProgress();
                
                if(res['success'] > 0){
                    jQuery('#downloadForm').submit();
                }else{
                    app.helper.showSuccessNotification({message: app.vtranslate('No Data Available.')});
                       
                }
            
            });  
            
        });
    },

    /**
     * Function which will handle the registrations for the elements
     */
    registerEvents : function() {
        this.registerCheckBoxChange();
        this.registerAPILogAction(); 
    }
});

function registerUpdateLogValue(value){
        //alert(value);
        var params = {
            module: 'CTMobileSettings',
            action: 'SaveAPILogsSettings',
            mode: 'updateLogs',
            logvalue: value
        };
        app.helper.showProgress();
        app.request.post({data: params}).then(function (err, res) {
            app.helper.hideProgress();
        });
    }

jQuery(document).ready(function () {
    var instance = new CTMobileSettings_APILogsSettings_Js();
    instance.registerEvents();

    var searchListInstance = new Vtiger_SearchList_Js();
    var BasicSearchInstance = new Vtiger_BasicSearch_Js();
    BasicSearchInstance.registerEvents();
    var vtigerInstance = new Settings_Vtiger_Index_Js();
    vtigerInstance.registerEvents();
});


