{*<!--
 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */
-->*}

{literal}
<style type="text/css">
.nav-tabs > li.active > a, .nav-tabs > li.active > a:hover, .nav-tabs > li.active > a:focus {
    color: #333;
    border-bottom: 3px solid #555;
}
  #result ul{ 
   list-style: none;
   width: 110%;
   padding-right: 0%;
   position: relative;
   padding-left: 0px;
   border: 1px solid #d7d1d1 !important;
   margin-top: 2px;
   margin-left: -11px;
   z-index: 1; 
   background:#999;
   color: #fff;
   box-shadow: 0px 1px 0px 2px rgb(0 0 0 / 30%);
}
#result ul li{ 
    padding: 4px;
    margin-bottom: 1px;
    border-bottom: 1px solid #d7d1d1 !important;
}
#result ul li:hover{ 
   cursor: pointer; 
}

#assign_person_count,#stops_count {
    font-size: 14px;
    background-color: #000;
    color: #fff;
    padding: 5px 10px;
    border-radius: 50%;
}

.sr_no {
    font-size: 11px;
    font-weight: 900;
    background-color: #3F51B5;
    color: #fff;
    padding: 4px 8px;
    border-radius: 10%;
}
.distanceDiv,.durationDiv,#total_duration span,#total_distance span{
    background: #3F51B5;
    border-radius: 3px;
    color: #FFF;
    padding: 3px;
    margin: 10px;
    width: 100px;
    overflow: hidden;
    text-overflow: ellipsis;
    white-space: nowrap;
}
#example1 tbody tr{
  cursor: move;
}
</style>
{/literal}

{if $API_KEY neq ''}
<script>var apikey = 'AIzaSyDB-OZnUKA4RAgXcpGbVGRHKIXIB_qGSFM';</script>
<script src="https://unpkg.com/@google/markerclustererplus@4.0.1/dist/markerclustererplus.min.js"></script>
<script async defer src="https://maps.googleapis.com/maps/api/js?key={$API_KEY}&callback=initMap">
</script>

{literal}
    <script type='text/javascript'>
    jQuery('#modnavigator').remove();
    jQuery('.settingsPageDiv').removeClass('settingsPageDiv content-area clearfix');

    var flightPath;
    var map;
    var paths = [];
    var placeIdArray = [];
    var polylines = [];
    var snappedCoordinates = [];
    function initMap() {
      if (navigator.geolocation) {
        navigator.geolocation.getCurrentPosition(showPosition);
      }
      map = new google.maps.Map(document.getElementById('map'), {
        zoom: 15,
        center: {lat: 0, lng: -180},
        mapTypeId: 'terrain',
        myLocationEnabled:true
      });
      if(currentlocation){
        currentLatitude = currentlocation.coords.latitude;
        currentlongitude = currentlocation.coords.longitude;
        map.setCenter({lat:currentLatitude, lng:currentlongitude});
      }
    }

    setTimeout(function(){
      if(!map){
        initMap();
      }
    },500);

    function drawRoute(data){
      if(!map){
        initMap();
      }

      var flightPlanCoordinates2 = [];
      //map.setCenter({lat:parseInt(data[0].lat), lng:parseInt(data[0].lng)});
      jQuery.each(data, function( index, value ) {
        if(value.lat == 0 || value.lng == 0){
          return true;
        }
        flightPlanCoordinates2.push({lat:parseFloat(value.lat),lng:parseFloat(value.lng),info:value.label,icon:'http://maps.google.com/mapfiles/ms/icons/blue-dot.png'});
        paths.push(parseFloat(value.lat)+','+parseFloat(value.lng));

        if(value.check_in_latitude && value.check_in_longitude){
          var content = '<div id="bodyContent"><table class="table table-bordered"><tr><td> Name </td><td><b>'+value.label+' </b></td></tr><tr><td> Point Type </td><td><b>Check In Location</b></td></tr></div>';
          flightPlanCoordinates2.push({lat:parseFloat(value.check_in_latitude),lng:parseFloat(value.check_in_longitude),info:content,icon:'http://maps.google.com/mapfiles/ms/icons/green-dot.png'});
        }

        if(value.check_out_latitude && value.check_out_longitude){
          var content = '<div id="bodyContent"><table class="table table-bordered"><tr><td> Name </td><td><b>'+value.label+' </b></td></tr><tr><td> Point Type </td><td><b>Check Out Location</b></td></tr></div>';
          flightPlanCoordinates2.push({lat:parseFloat(value.check_in_latitude),lng:parseFloat(value.check_in_longitude),info:content,icon:'http://maps.google.com/mapfiles/ms/icons/red-dot.png'});
        }
          //markers[i] = marker;  
      });

      //runSnapToRoad(paths);

      /*var mIcon = {
        path: google.maps.SymbolPath.CIRCLE,
        scale: 15,
        fillColor: "#3F51B5",
        fillOpacity: 1.0,
        strokeWeight: 6,
        strokeOpacity: 0.8,
        strokeColor:"#3F51B5",
        rotation: 30
      };*/

/*      var infoWin = new google.maps.InfoWindow();
      if(flightPlanCoordinates2){
        var markers = flightPlanCoordinates2.map(function(location, i) {
          var id = i+1;
          var marker = new google.maps.Marker({
            id: id,
            position: location,
            map: map,
            icon : mIcon,
            label: {text: id.toString(), color: "white", fontWeight: 'bold', fontSize: '16px',},
          });
          google.maps.event.addListener(marker, 'mouseover', function(evt) {
            infoWin.setContent(location.info);
            infoWin.open(map, marker);
          })
          map.setCenter(marker.getPosition());
          google.maps.event.addListener(marker, 'mouseout', function(evt) {
            infoWin.close(map, marker);
          })
          map.setCenter(marker.getPosition());
          return marker;
        });
      }

      var mcOptions = {
          imagePath: 'https://developers.google.com/maps/documentation/javascript/examples/markerclusterer/m',
          infoOnClick: true, 
          infoOnClickZoom: 7
      };
  
      markerCluster = new MarkerClusterer(map, markers, mcOptions);

      google.maps.event.addListener(markerCluster, "clusterclick", multiChoice);*/

      runNearestRoad(paths);
    }

    var currentlocation;
    var currentLatitude = '';
    var currentlongitude = '';
    var totalDistance = 0;
    var totalDuration = 0;
    function showPosition(position) {
      currentlocation = position;
    }

    function runNearestRoad(paths) {
      if (navigator.geolocation) {
        navigator.geolocation.getCurrentPosition(showPosition);
      }

      var currentLocationIcon = {
        path: google.maps.SymbolPath.CIRCLE,
        scale: 15,
        fillColor: "#ffffff",
        fillOpacity: 1.0,
        strokeWeight: 6,
        strokeOpacity: 0.8,
        strokeColor:"#3F51B5",
        rotation: 30
      };

      var mIcon = {
        path: google.maps.SymbolPath.CIRCLE,
        scale: 15,
        fillColor: "#3F51B5",
        fillOpacity: 1.0,
        strokeWeight: 6,
        strokeOpacity: 0.8,
        strokeColor:"#3F51B5",
        rotation: 30
      };

      setTimeout(function(){
        //console.log(current_position);
        if(currentlocation){
          currentLatitude = currentlocation.coords.latitude;
          currentlongitude = currentlocation.coords.longitude;

          /*var icon = {
              url: "layouts/v7/modules/CTMobileSettings/images/homemarker.png", // url
              scaledSize: new google.maps.Size(50, 50), // scaled size
              origin: new google.maps.Point(0,0), // origin
              anchor: new google.maps.Point(0, 0) // anchor
          };

          var marker = new google.maps.Marker({
            position: {lat:currentLatitude,lng:currentlongitude},
            map: map,
            icon : icon,
          });*/
          var countmarker = 1;
          var waypoints = [];
          const currentlocations = {lat:parseFloat(currentLatitude),lng:parseFloat(currentlongitude)};
          var destinationlocations = {};
          var newWaypointLabels = [];
          for (var i = 0; i < paths.length; i++) {
            var pathValues = [];
            pathValues.push(currentLatitude+','+currentlongitude);
            pathValues.push(paths[i]);
            const locationvalue = paths[i].split(',');
            //console.log(paths[i]);
            if(i == 0){
              var title = 'Start Point';
            }else{
              var title = (i+1)+ 'Stop';
            }
            var label = (i+1).toString();
            
            if(i!= (paths.length-1)){
              newWaypointLabels.push(label);
              waypoints.push({location:{lat:parseFloat(locationvalue[0]),lng:parseFloat(locationvalue[1])}});
            }else if(i == (paths.length-1)){
              destinationlocations = {lat:parseFloat(locationvalue[0]),lng:parseFloat(locationvalue[1])};
            }

          }

              if(apikey){
                //const currentlocations = {lat:parseFloat(currentLatitude),lng:parseFloat(currentlongitude)};
                //const destinationlocations = {lat:parseFloat(locationvalue[0]),lng:parseFloat(locationvalue[1])};
                let directionsService = new google.maps.DirectionsService();
                let directionsRenderer = new google.maps.DirectionsRenderer({
                  suppressMarkers: true,
                  polylineOptions: {
                    strokeColor: "#3F51B5"
                  }
                });
                directionsRenderer.setMap(map); // Existing map object displays directions
                // Create route from existing points used for markers

                // Function to update marker labels
                function updateMarkerLabels(startLabel, endLabel, waypointLabels) {
                  directionsRenderer.setOptions({
                    markerOptions: {
                      icon: mIcon,
                      label: startLabel, // Label for the starting point
                      endLabel, // Label for the ending point
                      waypoints: waypointLabels // Labels for waypoints (an array)
                    }
                  });
                }

                // Example of updating the labels
                /*const newStartLabel = '1';
                const newEndLabel = '10';
                const newWaypointLabels = ['1', '2', '3'];

                updateMarkerLabels(newStartLabel, newEndLabel, newWaypointLabels);*/

                const route = {
                    origin: currentlocations,
                    destination: destinationlocations,
                    waypoints: waypoints,
                    travelMode: 'DRIVING'
                }

                directionsService.route(route,
                  function(response, status) { // anonymous function to capture directions
                    if (status !== 'OK') {
                      window.alert('Directions request failed due to ' + status);
                      return;
                    } else {
                      directionsRenderer.setDirections(response); // Add route to the map
                      var directionsDatas = response.routes[0].legs; // Get data about the mapped route
                      if (!directionsDatas) {
                        //window.alert('Directions request failed');
                        //return;
                      }
                      else {
                        var legs = response.routes[0].legs;
                        var carMarker = new google.maps.Marker({
                          position: legs[0].start_location,
                          map: map,
                          /*icon: {
                            url: 'layouts/v7/modules/CTMobileSettings/img/car_p4v2owhb7i55_64.png', // Car icon
                            scale: 10 // Size of the icon
                          }*/
                          icon:currentLocationIcon,
                          label: {text: '🚗',color:'#3F51B5'}
                        });

                        var icons = ['1', '2', '3', '4', '5']; // Array of labels for markers
                        for (var i = 0; i < legs.length; i++) {
                          var location = legs[i].end_location;
                          var marker = new google.maps.Marker({
                              position: location,
                              map: map,
                              icon :mIcon,
                              label: {text: icons[i],color:'white'}
                          });

                          totalDistance += legs[i].distance.value;
                          totalDuration += legs[i].duration.value;

                        }

                        totalDistance = parseFloat(totalDistance) / 1000;
                        totalDuration = parseFloat(totalDuration) / 60;
                        jQuery('#total_distance span').text(totalDistance.toFixed(2)+" km");
                        jQuery('#total_duration span').text(totalDuration.toFixed(2)+" mins");

                        jQuery('#total_distance').removeClass('hide');
                        jQuery('#total_duration').removeClass('hide');

                        jQuery(directionsDatas).each(function(index,directionsData){
                          var distance = directionsData.distance.text;
                          var duration = directionsData.duration.text;
                          row = jQuery('#example1 tbody').find('tr').eq(index);
                          row.find('td:last-child').append('<span class="distanceDiv" title="'+distance+'">'+distance+'</span><br/><br/><span class="durationDiv" title="'+duration+'">'+duration+'</span>');
                        });
                       /* if(i == 0){
                          var start_title = "My Location";
                          var end_title = countmarker;
                          countmarker++;
                        }else{
                          var start_title = countmarker;
                          countmarker++;
                          var end_title = countmarker;
                          countmarker++;
                        }
                        makeMarker( directionsData.start_location, mIcon, start_title);
                        makeMarker( directionsData.end_location, mIcon, end_title);*/
                      }
                    }
                  });
              }

             /* $.get('https://roads.googleapis.com/v1/nearestRoads', {
                key: apikey,
                points: pathValues.join('|')
              }, function(data) {
                var snapPaths = [];
                for (var i = 0; i < data.snappedPoints.length; i++) {
                  var latlng = new google.maps.LatLng(
                      data.snappedPoints[i].location.latitude,
                      data.snappedPoints[i].location.longitude);
                  snapPaths.push(data.snappedPoints[i].location.latitude+','+data.snappedPoints[i].location.longitude);
                  //placeIdArray.push(data.snappedPoints[i].placeId);
                }
                runSnapToRoad(snapPaths);
              });*/
              
              //currentLatitude = locationvalue[0];
              //currentlongitude = locationvalue[1];
        }
      },1000);



     /* $.get('https://roads.googleapis.com/v1/nearestRoads', {
        key: apikey,
        points: pathValues.join('|')
      }, function(data) {
        var snapPaths = [];
        for (var i = 0; i < data.snappedPoints.length; i++) {
          var latlng = new google.maps.LatLng(
              data.snappedPoints[i].location.latitude,
              data.snappedPoints[i].location.longitude);
          snapPaths.push(data.snappedPoints[i].location.latitude+','+data.snappedPoints[i].location.longitude);
          //placeIdArray.push(data.snappedPoints[i].placeId);
        }
        runSnapToRoad(snapPaths);
      });*/
    }

    function makeMarker( position, icon, title ) {
     new google.maps.Marker({
      position: position,
      map: map,
      icon: icon,
      title: title
     });
    }

    function runSnapToRoad(paths) {
      var pathValues = [];
      for (var i = 0; i < paths.length; i++) {
        pathValues.push(paths[i]);
      }
      //console.log(pathValues.join('|'));
      $.get('https://roads.googleapis.com/v1/snapToRoads', {
        interpolate: true,
        key: apikey,
        path: pathValues.join('|')
      }, function(data) {
        //console.log(data);
        processSnapToRoadResponse(data);
        drawSnappedPolyline();
      });
    }

    // Store snapped polyline returned by the snap-to-road service.
    function processSnapToRoadResponse(data) {
      snappedCoordinates = [];
      placeIdArray = [];
      for (var i = 0; i < data.snappedPoints.length; i++) {
        var latlng = new google.maps.LatLng(
            data.snappedPoints[i].location.latitude,
            data.snappedPoints[i].location.longitude);
        snappedCoordinates.push(latlng);
        placeIdArray.push(data.snappedPoints[i].placeId);
      }
    }

    // Draws the snapped polyline (after processing snap-to-road response).
    function drawSnappedPolyline() {
      //console.log(snappedCoordinates);
      var snappedPolyline = new google.maps.Polyline({
        path: snappedCoordinates,
        strokeColor: '#3F51B5',
        strokeWeight: 5,
        strokeOpacity: 0.9,
      });

      snappedPolyline.setMap(map);
      polylines.push(snappedPolyline);
    }



    function multiChoice(cluster) {
             /*var cluster = mc.clusters_;*/
             var zoom = markerCluster.getMap().getZoom();
             var maxZoom = 15;
             // if more than 1 point shares the same lat/long
             // the size of the cluster array will be 1 AND
             // the number of markers in the cluster will be > 1
             // REMEMBER: maxZoom was already reached and we can't zoom in anymore
             if (zoom >= maxZoom == 1 && cluster.markers_.length > 1)
             {
                  var markers = cluster.markers_;
                  var a = 360.0 / markers.length;
                  for (var i=0; i < markers.length; i++)
                  {
                      var pos = markers[i].getPosition();
                      var newLat = pos.lat() + -.00002 * Math.cos((+a*i) / 180 * Math.PI);  // x
                      var newLng = pos.lng() + -.00002 * Math.sin((+a*i) / 180 * Math.PI);  // Y
                      var finalLatLng = new google.maps.LatLng(newLat,newLng);
                      markers[i].setPosition(finalLatLng);
                      markers[i].setMap(markerCluster.getMap());
                  }
                  cluster.clusterIcon_.hide();
                  return ;
             }

             return true;
        }



    </script>
{/literal}
{else}
  <script src="https://unpkg.com/leaflet@1.6.0/dist/leaflet.js"></script>
  <link href="https://unpkg.com/leaflet@1.6.0/dist/leaflet.css" rel="stylesheet"/>
    {literal}
        <script type='text/javascript'>
              var markers = [];
              var myMap = '';
              var flightPlanCoordinates = [];
              function initOpenMap() {
                  var element = document.getElementById('map');
                  //element.style = 'height:300px;';
                  myMap = L.map(element);

                  // Add OSM tile leayer to the Leaflet map.
                  var mylayer = L.tileLayer('https://{s}.tile.osm.org/{z}/{x}/{y}.png', {
                      attribution: '&copy; <a href="https://osm.org/copyright">OpenStreetMap</a> contributors'
                  }).addTo(myMap);
              }
              jQuery(document).ready(function () { 
                initOpenMap();
              });

              function drawRoute(result2){
                if(result2.length != 0){
                  
                  
                  var target = L.latLng(result2[0].lat,result2[0].lng);

                  // Set map's center to target with zoom 14.
                  myMap.setView(target, 10);

                  jQuery.each(result2, function(index, item) {
                    i =index;
                    marker = new L.marker([item.lat, item.lng])
                      .bindPopup(item.label)
                      .addTo(myMap);
                      marker.on('mouseover', function(event){
                      marker.openPopup();
                    });
                    
                  });
                }
              }
        </script>
      {/literal}
{/if}

<div class="container-fluid">
<input type="hidden" id="record" value="{$RECORD}">
<input type="hidden" id="step" value="{$STEP}">
<input type="hidden" id="api_key" value="{$API_KEY}">
    <div class="widget_header row-fluid">
        <button type="button" class="btn btn-info pull-right" style="background:#287DF2 !important;" onclick='window.location.href="{CTMobileSettings_Module_Model::$CTMOBILE_DETAILVIEW_URL}"'>{vtranslate('Go To CRMTiger Settings',$MODULE)}</button>
        <h3>{vtranslate('Create Route Planning', 'CTMobileSettings')}</h3>
    </div>
    <hr>
    <!-- <h5 style="margin-left:20px;">{vtranslate('Add/Remove users from list to access of route planning','CTMobileSettings')}</h5> -->
    <div class="clearfix"></div>
    <nav aria-label="breadcrumb">
      <ol class="breadcrumb">
        <li class="breadcrumb-item {if $STEP eq 1} active {/if}" aria-current="page"><a href="#"> {vtranslate('Add Stops','CTMobileSettings')}</a></li>
        <li class="breadcrumb-item {if $STEP eq 2} active {/if}"><a href="#"> {vtranslate('Review Route & optimize','CTMobileSettings')}</a></li>
        <li class="breadcrumb-item"><a href="#"> {vtranslate('Dispatch Route','CTMobileSettings')}</a></li>
      </ol>
    </nav>
    <div class="tab-content massEditContent" style="background:#f3f3f3;">
        <div class="detailViewContainer row" id="route_analytics_settings">
            <input type="hidden" name="CREATE_ROUTE_TEXT" value="{$CREATE_ROUTE_TEXT}"/>
            <input type="hidden" name="CREATE_ROUTE_LINK" value="{$CREATE_ROUTE_LINK}"/>
            <div class="col-md-6">
                <br/>
                <div class="block">
                  <div class="row">
                    <div class="col-md-6">
                      <label>{vtranslate('Route Name','CTMobileSettings')} <span class="redColor">*</span> :</label>
                      <input type="text" class="inputElement" id="routename" name="routename" value="{$ROUTENAME}" placeholder="{vtranslate('Enter Route Name','CTMobileSettings')}" />
                    </div>
                    <div class="col-md-6">
                      <label>{vtranslate('Route Date','CTMobileSettings')} <span class="redColor">*</span> :</label>
                      <div class="input-group inputElement">
                        <input type="text" class="dateField form-control" id="routedate" name="routedate" data-date-format="dd-mm-yyyy" value="{$ROUTEDATE}" placeholder="Route Date" />
                          <span class="input-group-addon"><i class="fa fa-calendar "></i></span>
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-md-12">
                      <h4><b>{vtranslate('Assigned Persons','CTMobileSettings')} <span class="redColor">*</span> <span id="assign_person_count">0</span></b></h4>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-md-12">  
                      <select data-fieldname="routeUser" name="user_id" id="routeUser" data-fieldtype="picklist" class="inputElement select2" multiple="multiple">
                        {foreach key=FIELD_NAME item=FIELD_MODEL from=$USER_MODEL}
                          <option value="{$FIELD_MODEL['userid']}" data-field-name="{$FIELD_MODEL['username']}"
                                       {if $assigned_user_id eq $FIELD_MODEL['userid']} selected {/if}>{$FIELD_MODEL['username']}
                          </option>
                        {/foreach}
                      </select>
                    </div>
                  </div>
                  <br/>
                </div>
                <br/>
                <div class="block">
                  <div class="row" style="margin-top:10px;">
                    <div class="col-md-6">
                      <h4><b>Stops <span class="redColor">*</span> <span id="stops_count">0</span></b></h4>
                    </div>
                    <div class="col-md-6">
                      <button type="button" id="AddStops" class="btn btn-info pull-right" style="background:#287DF2 !important;    margin-bottom: 10px;"><i class="fa fa-plus" ></i> {vtranslate('Add Stops',$MODULE)}</button>
                    </div>
                  </div>
                
                  <div id="listRoute">
                        <table id="example1" class='table table-striped' style="min-height:180px;">
                            <thead>
                                <tr><th>{vtranslate('Sr.No.','CTMobileSettings')}</th><th>{vtranslate('Module','CTMobileSettings')}</th><th> {vtranslate('Record label','CTMobileSettings')} </th><th> {vtranslate('Full Address','CTMobileSettings')} </th><th> {vtranslate('Priority','CTMobileSettings')} </th><th>{vtranslate('LBL_ACTION','CTMobileSettings')}</th></tr>
                            </thead>
                            <tbody>
                            {assign var="trcount" value=1}
                            {foreach item=RelData from=$relatedData}
                            <tr data-crmid="{$RelData['crmid']}" data-label="{$RelData['label']}" data-address="{$RelData['address']}" data-latitude="{$RelData['latitude']}" data-longitude="{$RelData['longitude']}" data-check_in_latitude="{$RelData['check_in_latitude']}" data-check_in_longitude="{$RelData['check_in_longitude']}" data-check_out_latitude="{$RelData['check_out_latitude']}" data-check_out_longitude="{$RelData['check_out_longitude']}" data-ctroutepriority="{$RelData['ctroutepriority']}" draggable="true">
                              <td><span class="sr_no">{$trcount}</span></td>
                              <td>{vtranslate($RelData['setype'],$RelData['setype'])}</td>
                              <td>{$RelData['label']}</td>
                              <td>{$RelData['address']}</td>
                              <td><span class="ctrouteprioritytext">{vtranslate($RelData['ctroutepriority'],$CTMobileSettings)}</span>
                                <div>
                                  <select class="select2 inputElement hide" name="routepriority">
                                    <option value="Low">{vtranslate('Low','CTMobileSettings')}</option>
                                    <option value="Medium">{vtranslate('Medium','CTMobileSettings')}</option>
                                    <option value="High">{vtranslate('High','CTMobileSettings')}</option>
                                </select>
                                <div class="input-save-wrap hide"><span class="pointerCursorOnHover input-group-addon input-group-addon-save inlineAjaxSave"><i class="fa fa-check"></i></span><span class="pointerCursorOnHover input-group-addon input-group-addon-cancel inlineAjaxCancel"><i class="fa fa-close"></i></span></div>
                                </div>
                              </td>
                              <td><span class='more dropdown action'><span href='javascript:;' class='dropdown-toggle' data-toggle='dropdown' aria-expanded='false' style='cursor:pointer;'><i class='fa fa-ellipsis-v icon'></i></span><ul class='dropdown-menu'><li><a class='deleteStops' onclick='deleteStops(this)' title='Delete'>Delete</a></li><li><a class='changePriority' onclick='changePriority(this)' title='Delete'>Change Priority</a></li></ul></span></td>
                            </tr>
                            {assign var="trcount" value=$trcount+1}
                            {/foreach}
                            </tbody>
                        </table>
                  </div>
                  <div class="row">
                    <div class="col-md-6">
                      <p id="total_distance" class="hide"><b> {vtranslate('Total Distance','CTMobileSettings')} : </b> <span></span></p>
                    </div>
                    <div class="col-md-6">
                      <p id="total_duration" class="hide"><b> {vtranslate('Total Duration','CTMobileSettings')} : </b> <span></span></p>
                    </div>
                  </div>
                </div>
                <br/>
                {if $STEP eq 1}  
                  <button id="secondstep" class="btn btn-info pull-right" style="background:#287DF2 !important;">{vtranslate('Generate Route','CTMobileSettings')}</button>
                {else}
                  <button id="saveRoute" class="btn btn-success pull-right" style="background:#35aa47 !important;">{vtranslate('Save Route','CTMobileSettings')}</button>
                  <button id="secondstep" class="btn btn-info pull-right" style="background:#287DF2 !important;margin-right:10px;">{vtranslate('Generate Route','CTMobileSettings')}</button>
                  <button id="prevStep" class="btn btn-info pull-right" style="background:#287DF2 !important;margin-right:10px">{vtranslate('Prev','CTMobileSettings')}</button>
                {/if}
                <br/>
            </div>
            <div class="col-md-6">
              {if $STEP eq 1}  
                <!-- <button type="button" id="AddStops" class="btn btn-info pull-right" style="background:#287DF2 !important;    margin-bottom: 10px;"><i class="fa fa-plus" ></i> {vtranslate('Add Stops',$MODULE)}</button> -->

              {/if}
              <div id='map' style="width:100%;min-height: 35em; margin: 0; padding: 0;margin-top: 14px;">
              </div>
           </div> 
             
                    
        </div>
    </div>

</div>

<script type="text/javascript">
  $(function () {
     /* $("#example1").sortable({
          items: 'tr',
          dropOnEmpty: false,
          start: function (G, ui) {
              ui.item.addClass("select");
          },
          stop: function (G, ui) {
              ui.item.removeClass("select");*/
              /*$(this).find("tr").each(function (example1) {
                  if (example1 > 0) {
                      $(this).find("td").eq(2).html(example1);
                  }
              });*/
      /*
              reArrangeSequence();
          }
      });*/
  });

  const tbody = document.querySelector('#example1 tbody');

  tbody.addEventListener('dragstart', (e) => {
    e.dataTransfer.setData('text/plain', '');
    e.currentTarget.draggedElement = e.target;
  });

  tbody.addEventListener('dragover', (e) => {
    e.preventDefault();
    const draggedOverElement = e.target.closest('tr');
    if (draggedOverElement) {
      const bounding = draggedOverElement.getBoundingClientRect();
      const offset = bounding.y + bounding.height / 2;
      if (e.clientY - offset > 0) {
        draggedOverElement.classList.remove('dragged-over');
        draggedOverElement.nextElementSibling?.classList.add('dragged-over');
      } else {
        draggedOverElement.classList.add('dragged-over');
        draggedOverElement.previousElementSibling?.classList.remove('dragged-over');
      }
    }
  });

  tbody.addEventListener('drop', (e) => {
    const draggedElement = e.currentTarget.draggedElement;
    const draggedOverElement = e.target.closest('tr');
    if (draggedElement && draggedOverElement) {
      e.preventDefault();
      if (draggedElement !== draggedOverElement) {
        const parent = draggedElement.parentNode;
        const nextSibling = draggedElement.nextSibling === draggedOverElement ? draggedElement : draggedElement.nextSibling;
        parent.insertBefore(draggedElement, draggedOverElement);
        parent.insertBefore(draggedOverElement, nextSibling);
      }
      draggedOverElement.classList.remove('dragged-over');
    }
    reArrangeSequence();
  });

  tbody.addEventListener('dragend', (e) => {
    const draggedElement = e.currentTarget.draggedElement;
    if (draggedElement) {
      draggedElement.classList.remove('dragged-over');
      e.currentTarget.draggedElement = null;
    }
  });

  function reArrangeSequence(){
    var trlength = jQuery('#example1 tbody').find('tr').length;
    var trr = jQuery('#example1 tbody').find('tr');
    for(var i=0;i<trlength;i++){
        var oldtr = trr[i];
        var sr_no = (i+1).toString();
        $(oldtr).find('.sr_no').text(sr_no);
    }
  }
</script>





