<?php
/*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */

require_once('data/CRMEntity.php');
require_once('data/Tracker.php');
require_once 'vtlib/Vtiger/Module.php';

class CTMobileSettings extends CRMEntity {
    /**
     * Invoked when special actions are performed on the module.
     * @param String Module name
     * @param String Event Type (module.postinstall, module.disabled, module.enabled, module.preuninstall)
     */
    function vtlib_handler($modulename, $event_type) {
        if($event_type == 'module.postinstall') {
            self::addWidgetTo();
            self::iniData(); 
            self::CTmobileUserAccess();   
            self::languageInit();
            self::sectionInit();     
        } else if($event_type == 'module.disabled') {
            // TODO Handle actions when this module is disabled.
            self::removeWidgetTo();
        } else if($event_type == 'module.enabled') {
            // TODO Handle actions when this module is enabled.
            self::addWidgetTo();
        } else if($event_type == 'module.preuninstall') {
			self::removeWidgetTo();
            // TODO Handle actions when this module is about to be deleted.
        } else if($event_type == 'module.preupdate') {
            // TODO Handle actions before this module is updated.
        } else if($event_type == 'module.postupdate') {
            self::addWidgetTo(); 
			self::CTmobileUserAccess();
            self::languageInit();
            self::sectionInit();
        }
    }
    
    static function sectionInit() {
        global $adb;
        $sectionCheck = $adb->pquery('SELECT * FROM ctmobile_language_section',array());
        if($adb->num_rows($sectionCheck) == 0){
            $adb->pquery("INSERT INTO `ctmobile_language_section` (`section_id`, `section_name`) VALUES
                (1, 'Common Message'),
                (2, 'Login Screen'),
                (3, 'Forgot Password Screen'),
                (4, 'Email Screen'),
                (5, 'Add/Edit Record'),
                (6, 'CoverLead Screen'),
                (7, 'Calender screen'),
                (8, 'Setting Screen'),
                (9, 'Module Setting screen'),
                (10, 'Line item Screen'),
                (11, 'Detail Screen'),
                (12, 'Summary Details screen'),
                (13, 'NearBy screen'),
                (14, 'Email Detail Screen'),
                (15, 'Home Screen'),
                (16, 'FeedBack Screen'),
                (17, 'EmailTemplate Screen'),
                (18, 'UserFilterView Screen'),
                (19, 'Activity Setting'),
                (20, 'SMS Send Screen'),
                (21, 'Global Search screen'),
                (22, 'App Introduction screen'),
                (23, 'Drive Record screen'),
                (24, 'ReportBug screen'),
                (25, 'Shortcut screen'),
                (26, 'Check URL screen'),
                (27, 'List Screen'),
                (28, 'Card Scanner Screen'),
                (29, 'Other Message');",array());
        }
    }
    
    static function iniData() {
        global $adb;
        $allModules = Vtiger_Module_Model::getSearchableModules();
        $searchModules=array_keys($allModules);
        foreach($searchModules as $module) {
            $adb->pquery("INSERT INTO `ctmobile_address_modules` (`module`, `active`) VALUES (?, ?)",array($module,'1'));
        }
        //Insert Contact Address Fields
        $adb->pquery("INSERT INTO ctmobile_address_fields (module,fieldname) VALUES (?,?)",array("Contacts","vtiger_contactaddress:mailingstreet:mailingstreet:Contacts_Mailing_Street:V"));
		$adb->pquery("INSERT INTO ctmobile_address_fields (module,fieldname) VALUES (?,?)",array("Contacts","vtiger_contactaddress:mailingcity:mailingcity:Contacts_Mailing_City:V"));
		$adb->pquery("INSERT INTO ctmobile_address_fields (module,fieldname) VALUES (?,?)",array("Contacts","vtiger_contactaddress:mailingstate:mailingstate:Contacts_Mailing_State:V"));
		$adb->pquery("INSERT INTO ctmobile_address_fields (module,fieldname) VALUES (?,?)",array("Contacts","vtiger_contactaddress:mailingcountry:mailingcountry:Contacts_Mailing_Country:V"));
		$adb->pquery("INSERT INTO ctmobile_address_fields (module,fieldname) VALUES (?,?)",array("Contacts","vtiger_contactaddress:mailingzip:mailingzip:Contacts_Mailing_Zip:V"));
		//Insert Accounts Address Fields
		$adb->pquery("INSERT INTO ctmobile_address_fields (module,fieldname) VALUES (?,?)",array("Accounts","vtiger_accountshipads:ship_street:ship_street:Accounts_Shipping_Address:V"));
		$adb->pquery("INSERT INTO ctmobile_address_fields (module,fieldname) VALUES (?,?)",array("Accounts","vtiger_accountshipads:ship_city:ship_city:Accounts_Shipping_City:V"));
		$adb->pquery("INSERT INTO ctmobile_address_fields (module,fieldname) VALUES (?,?)",array("Accounts","vtiger_accountshipads:ship_state:ship_state:Accounts_Shipping_State:V"));
		$adb->pquery("INSERT INTO ctmobile_address_fields (module,fieldname) VALUES (?,?)",array("Accounts","vtiger_accountshipads:ship_country:ship_country:Accounts_Shipping_Country:V"));
		$adb->pquery("INSERT INTO ctmobile_address_fields (module,fieldname) VALUES (?,?)",array("Accounts","vtiger_accountshipads:ship_code:ship_code:Accounts_Shipping_Code:V"));
		//Insert Leads Address Fields
		$adb->pquery("INSERT INTO ctmobile_address_fields (module,fieldname) VALUES (?,?)",array("Leads","vtiger_leadaddress:lane:lane:Leads_Street:V"));
		$adb->pquery("INSERT INTO ctmobile_address_fields (module,fieldname) VALUES (?,?)",array("Leads","vtiger_leadaddress:city:city:Leads_City:V"));
		$adb->pquery("INSERT INTO ctmobile_address_fields (module,fieldname) VALUES (?,?)",array("Leads","vtiger_leadaddress:state:state:Leads_State:V"));
		$adb->pquery("INSERT INTO ctmobile_address_fields (module,fieldname) VALUES (?,?)",array("Leads","vtiger_leadaddress:country:country:Leads_Country:V"));
		$adb->pquery("INSERT INTO ctmobile_address_fields (module,fieldname) VALUES (?,?)",array("Leads","vtiger_leadaddress:code:code:Leads_Postal_Code:V"));
		//Insert Calendar Address Fields
		$adb->pquery("INSERT INTO ctmobile_address_fields (module,fieldname) VALUES (?,?)",array("Calendar","vtiger_activity:location:location:Events_Location:V"));
		
    }

    static function languageInit(){
        global $adb;
        $AllLanguage = Vtiger_Language::getAll();
        foreach ($AllLanguage as $language => $langname) {
           $result = $adb->pquery("SELECT * FROM ctmobile_language_keyword WHERE keyword_lang=?",array($language));
           $numRow = $adb->num_rows($result);
           if($numRow == 0){
               if(function_exists($language)){
                 self::$language();
               }else{
                 self::en_us($language);
               }
           }
        }

        //code start for add new language Keyword
        $newlanguageKeyword = array(
        array('Voice_Recording_Stopped','Recording Stopped',12),
        array('Voice_Recording_Started','Recording Started',12),
        array('permission_denied_delete','You don\'t have permission to delete this record.',27),
        array('permission_denied_edit','You don\'t have permission to edit this record.',27),
        array('share_record','Share Record',11),
        array('share_vcard','Share Vcard',11),
        array('download_vcard','Download Vcard',11),
        array('vcard_config','Vcard Configuration',8),
        array('Widgets','Widgets',15),
        array('Reports','Reports',15),
        array('retake','Retake',28),
        array('retry','Retry',28),
        array('already_widgets_added','All types of Widget & reports are already added',15),
        array('delete_widget','Delete Widget',15),
        array('add_widget','Add Widget',15),
        array('card_details','Card Details',11),
        array('download_vcard_success','VCard downloaded successfully',11),
        array('save_to_phone_vcard_success','VCard Saved to phone successfully',11),
        array('navigate','Navigate',11),
        array('check_in','Check in',11),
        array('check_out','Check out',11),
        array('check_in_successfully','Checked in successfully',11),
        array('check_out_successfully','Checked out successfully',11),
        array('no_widget_added','Please click + icon to add new widget to your dashboard.',15),
        array('no_data_available','Data not available, please check the selected fields',15),
        array('Permision_denied_contact','Permission denied to access your contacts',15),
        array('msg_warning','Warning!',11),
        array('error_voicenote_record','Unable to recording voice while another application is recording sound.',11),
        array('max_file_msg','Too many files selected (max:6)',11),
        array('asset_tracking','Asset tracking',15),
        array('YEARLY','Yearly',7),
        array('MONTHLY','Monthly',7),
        array('WEEKLY','Weekly',7),
        array('DAILY','Daily',7),
        array('SUNDAY','Sunday',7),
        array('SATURDAY','Saturday',7),
        array('FRIDAY','Friday',7),
        array('THURSDAY','Thursday',7),
        array('WEDNESDAY','Wednesday',7),
        array('TUESDAY','Tuesday',7),
        array('MONDAY','Monday',7),
        array('FIRST','First',7),
        array('LAST','Last',7),
        array('SEARCH','Search',7)
        );
        foreach ($AllLanguage as $language => $langname) {
            foreach($newlanguageKeyword as $key => $languages){
                $keyword = $languages[0];
                $keyword_name = $languages[1];
                $language_keyword = $languages[1];
                $sectionid = $languages[2];
                $checkQuery = $adb->pquery("SELECT 1 FROM ctmobile_language_keyword WHERE keyword = ? AND keyword_lang = ?",array($keyword,$language));
                if($adb->num_rows($checkQuery) == 0){
                    $adb->pquery("INSERT INTO `ctmobile_language_keyword` (`keyword`, `keyword_name`, `keyword_lang`, `language_keyword`, `sectionid`) VALUES (?, ?, ?, ?, ?)",array($keyword,$keyword_name,$language,$language_keyword,$sectionid));
                }
            }
        }
        $adb->pquery("UPDATE `ctmobile_language_keyword` SET `keyword_name`='History',`language_keyword`='History' WHERE `keyword` = 'history'",array());

        $checkBarcode = $adb->pquery("SELECT 1 FROM ctmobile_barcode_fields",array());
        if($adb->num_rows($checkBarcode) == 0){
            $adb->pquery("INSERT INTO `ctmobile_barcode_fields` (`module`, `fieldname`) VALUES ('Products', 'vtiger_products:product_no:product_no:Products_Product_No:V')",array());
        }

        $checkAsset = $adb->pquery("SELECT 1 FROM ctmobile_asset_field",array());
        if($adb->num_rows($checkAsset) == 0){
            $adb->pquery("INSERT INTO `ctmobile_asset_field` (`module`, `fieldname`) VALUES ('Assets', 'vtiger_assets:asset_no:asset_no:Assets_Asset_No:V')",array());
        }

        $checkVcard = $adb->pquery("SELECT 1 FROM ctmobile_vcard_fields",array());
        if($adb->num_rows($checkVcard) == 0){
            $adb->pquery("INSERT INTO `ctmobile_vcard_fields` (`module`, `fieldname`)VALUES ('Vendors','vtiger_vendor:vendorname:vendorname:Vendors_Vendor_Name:V'),
            ('Leads','vtiger_leaddetails:firstname:firstname:Leads_First_Name:V'),
            ('Leads','vtiger_leaddetails:lastname:lastname:Leads_Last_Name:V'),
            ('Contacts', 'vtiger_contactdetails:firstname:firstname:Contacts_First_Name:V'),
            ('Contacts', 'vtiger_contactdetails:lastname:lastname:Contacts_Last_Name:V')
            ",array());  
        }
    }

    static function en_us($language = 'en_us'){
        global $adb;
        $checkQuery = "SELECT * FROM ctmobile_language_keyword WHERE keyword_lang = ?";
        $checkResult = $adb->pquery($checkQuery,array($language));
        if($adb->num_rows($checkResult) == 0){

        $adb->pquery("INSERT INTO `ctmobile_language_keyword` (`keyword`, `keyword_name`, `keyword_lang`, `language_keyword`, `sectionid`) VALUES
            ('network_error', 'Network connection error!', '".$language."', 'Network connection error!', 1),
            ('connection_check', 'Could not connect to CRM, Please check your Internet connection.', '".$language."', 'Could not connect to CRM, Please check your Internet connection.', 1),
            ('update', 'Update', '".$language."', 'Update', 1),
            ('cancel', 'Cancel', '".$language."', 'Cancel', 1),
            ('ok', 'Ok', '".$language."', 'Ok', 1),
            ('more_information', 'Click here for more information.', '".$language."', 'Click here for more information.', 1),
            ('yes', 'Yes', '".$language."', 'Yes', 1),
            ('no', 'No', '".$language."', 'No', 1),
            ('click_again_exit', 'Click again to exit', '".$language."', 'Click again to exit', 1),
            ('forpermission', 'You don\'t have permission to view this feature. Please subscribe for Premium version Click here to Subscribe.', '".$language."', 'You don\'t have permission to view this feature. Please subscribe for Premium version Click here to Subscribe.', 1),
            ('clickhere', 'Click here', '".$language."', 'Click here', 1),
            ('clickhere_subscribe', 'Click here to subscribe premium version', '".$language."', 'Click here to subscribe premium version', 1),
            ('clickhere_configure', 'Click here and view how to Configure.', '".$language."', 'Click here and view how to Configure.', 1),
            ('please_wait', 'Please Wait…', '".$language."', 'Please Wait…', 1),
            ('share__msg', 'Share file with', '".$language."', 'Share file with', 1),
            ('dialog_camera', 'Camera', '".$language."', 'Camera', 1),
            ('dialog_add_file_by', 'Take Photo from', '".$language."', 'Take Photo from', 1),
            ('add', 'Add', '".$language."', 'Add', 1),
            ('mail_manager_configured', 'Mail Manager is not configured', '".$language."', 'Mail Manager is not configured', 1),
            ('dialog_add_files_by', 'Add Files by', '".$language."', 'Add Files by', 1),
            ('dialog_drive', 'Drive', '".$language."', 'Drive', 1),
            ('dialog_drop_box', 'Drop Box', '".$language."', 'Drop Box', 1),
            ('dialog_need_signin', 'You need to Sign-in to your Drive account first.', '".$language."', 'You need to Sign-in to your Drive account first.', 1),
            ('dialog_gallery', 'Gallery', '".$language."', 'Gallery', 1),
            ('delete', 'Delete', '".$language."', 'Delete', 1),
            ('timeoutmessage', 'Oops! Request is taking more time than expected.', '".$language."', 'Oops! Request is taking more time than expected.', 1),
            ('gps_location_message', 'GPS is not enabled. Please turn it on to get your near by locations.', '".$language."', 'GPS is not enabled. Please turn it on to get your near by locations.', 1),
            ('sure_want_delete', 'Are you sure want to delete ?', '".$language."', 'Are you sure want to delete ?', 1),
            ('select', 'Select', '".$language."', 'Select', 1),
            ('msgforrecordaudio', 'Minimum record duration one second.', '".$language."', 'Minimum record duration one second.', 1),
            ('permission_storage', 'Permission denied to read your External storage', '".$language."', 'Permission denied to read your External storage', 1),
            ('send_permission_msg', 'Send message permission denied', '".$language."', 'Send message permission denied', 1),
            ('choosefile', 'Choose File', '".$language."', 'Choose File', 1),
            ('enter', 'Enter', '".$language."', 'Enter', 1),
            ('select_an_option', 'Select an Option', '".$language."', 'Select an Option', 1),
            ('email_validation', 'Email is not valid', '".$language."', 'Email is not valid', 1),
            ('please_enter', 'Please Enter', '".$language."', 'Please Enter', 1),
            ('website_validation_text', 'Website URL is not valid', '".$language."', 'Website URL is not valid', 1),
            ('selectvalue', 'Select value first', '".$language."', 'Select value first', 1),
            ('email', 'Email', '".$language."', 'Email', 1),
            ('enter_email_address', 'Enter email address', '".$language."', 'Enter email address', 1),
            ('email_address_not_correct', 'Email address incorrect', '".$language."', 'Email address incorrect', 1),
            ('pls_enter_subject', 'Please Enter Subject', '".$language."', 'Please Enter Subject', 1),
            ('attachFiles', 'Attached File', '".$language."', 'Attached File', 1),
            ('from', 'From', '".$language."', 'From', 1),
            ('to', 'To', '".$language."', 'To', 1),
            ('call_permission_msg', 'Call permission denied', '".$language."', 'Call permission denied', 1),
            ('no_records', 'No records found', '".$language."', 'No records found', 1),
            ('fullform', 'Create New', '".$language."', 'Create New', 1),
            ('save', 'Save', '".$language."', 'Save', 1),
            ('total', 'Total', '".$language."', 'Total', 1),
            ('discount', 'Discount', '".$language."', 'Discount', 1),
            ('price', 'Price', '".$language."', 'Price', 1),
            ('quantity', 'Quantity', '".$language."', 'Quantity', 1),
            ('select_module', 'Select Module', '".$language."', 'Select Module', 1),
            ('item_list', 'Item List', '".$language."', 'Item List', 1),
            ('quickcreate', 'Quick Create', '".$language."', 'Quick Create', 1),
            ('overwrite_msg_part1', 'Overwrite the existing address with the selected', '".$language."', 'Overwrite the existing address with the selected', 1),
            ('once_in_every', 'Once in every', '".$language."', 'Once in every', 1),
            ('overwrite_msg_part2', 'address details?', '".$language."', 'address details?', 1),
            ('add_item', 'Add Item', '".$language."', 'Add Item', 1),
            ('recordsave', 'Record saved successfully', '".$language."', 'Record saved successfully', 1),
            ('recordnotsave', 'Could not save record. Try again later', '".$language."', 'Could not save record. Try again later', 1),
            ('minutes', 'Minutes', '".$language."', 'Minutes', 1),
            ('hours', 'Hours', '".$language."', 'Hours', 1),
            ('days', 'Days', '".$language."', 'Days', 1),
            ('on', 'On', '".$language."', 'On', 1),
            ('day_of_the_month', 'day of the month', '".$language."', 'day of the month', 1),
            ('list_price', 'List Price', '".$language."', 'List Price', 1),
            ('add_record', 'Add Record', '".$language."', 'Add Record', 1),
            ('add_product', 'Add Product', '".$language."', 'Add Product', 1),
            ('add_service', 'Add Service', '".$language."', 'Add Service', 1),
            ('discountin', 'Discount in %', '".$language."', 'Discount in %', 1),
            ('unitprice', 'Unit price', '".$language."', 'Unit price', 1),
            ('netprice', 'Net price', '".$language."', 'Net price', 1),
            ('comments', 'Comments', '".$language."', 'Comments', 1),
            ('add_close', 'Add & Close', '".$language."', 'Add & Close', 1),
            ('fetching_rout_message', 'Fetching route, Please wait…', '".$language."', 'Fetching route, Please wait…', 1),
            ('setting', 'Settings', '".$language."', 'Settings', 1),
            ('utc', 'UTC', '".$language."', 'UTC', 1),
            ('in', 'In', '".$language."', 'In', 1),
            ('days_ago', 'days ago', '".$language."', 'days ago', 1),
            ('mins_ago', 'Minutes ago', '".$language."', 'Minutes ago', 1),
            ('justnow', 'Just now', '".$language."', 'Just now', 1),
            ('hours_ago', 'hours ago', '".$language."', 'hours ago', 1),
            ('in_1_day', 'In 1 day', '".$language."', 'In 1 day', 1),
            ('scanqrcode', 'Card Scanner', '".$language."', 'Card Scanner', 1),
            ('call_log', 'Call Log', '".$language."', 'Call Log', 1),
            ('voice_message', 'Hi', '".$language."', 'Hi', 1),
            ('voice_message1', 'What can I search for you in', '".$language."', 'What can I search for you in', 1),
            ('live_tracking', 'Live Tracking', '".$language."', 'Live Tracking', 1),
            ('mailmanager', 'Mail Manager', '".$language."', 'Mail Manager', 1),
            ('my_location', 'My location', '".$language."', 'My location', 1),
            ('created_on', 'Created On', '".$language."', 'Created On', 1),
            ('modified_on', 'Modified On', '".$language."', 'Modified On', 1),
            ('enter_comments', 'Enter Comments', '".$language."', 'Enter Comments', 1),
            ('viewmore', 'View More', '".$language."', 'View More', 1),
            ('viewless', 'View Less', '".$language."', 'View Less', 1),
            ('gotofullform', 'Go to Full Form', '".$language."', 'Go to Full Form', 1),
            ('post', 'Post', '".$language."', 'Post', 1),
            ('url', 'URL', '".$language."', 'URL', 1),
            ('dialog_title_text_back_color', 'Select a Text Background Color', '".$language."', 'Select a Text Background Color', 1),
            ('event_or_task', 'Add event/task', '".$language."', 'Add event/task', 1),
            ('shortcut', 'Shortcuts', '".$language."', 'Shortcuts', 1),
            ('select_field', 'Select Field', '".$language."', 'Select Field', 1),
            ('share', 'Share', '".$language."', 'Share', 1),
            ('title_insert_link', 'Insert Link', '".$language."', 'Insert Link', 1),
            ('addyourcommentshere', 'Add your comments here', '".$language."', 'Add your comments here', 1),
            ('nocomment', 'No Comments', '".$language."', 'No Comments', 1),
            ('leads', 'Leads', '".$language."', 'Leads', 1),
            ('true_val', 'true', '".$language."', 'true', 1),
            ('noresult', 'No Result', '".$language."', 'No Result', 1),
            ('version', 'Version', '".$language."', 'Version', 1),
            ('convert_lead', 'Convert Lead', '".$language."', 'Convert Lead', 1),
            ('app_name', 'CRMTiger', '".$language."', 'CRMTiger', 1),
            ('enter_url', 'Please Enter url', '".$language."', 'Please Enter url', 1),
            ('help', 'Help', '".$language."', 'Help', 1),
            ('contact_us', 'Contact Us', '".$language."', 'Contact Us', 1),
            ('updates', 'Updates', '".$language."', 'Updates', 1),
            ('logout', 'LogOut', '".$language."', 'LogOut', 1),
            ('busnies_cardscanner', 'Business Card Scanner', '".$language."', 'Business Card Scanner', 1),
            ('sure_want_logout', 'Are you sure want to logout ?', '".$language."', 'Are you sure want to logout ?', 1),
            ('logout_message', 'Logout successfully', '".$language."', 'Logout successfully', 1),
            ('all', 'All', '".$language."', 'All', 1),
            ('add_event', 'Add event', '".$language."', 'Add event', 1),
            ('add_task', 'Add Task', '".$language."', 'Add Task', 1),
            ('next', 'Next', '".$language."', 'Next', 1),
            ('login', 'Login', '".$language."', 'Login', 2),
            ('privacy_policay', 'By logging in, you agree to our Terms and Conditions & Privacy Policy', '".$language."', 'By logging in, you agree to our Terms and Conditions & Privacy Policy', 2),
            ('copyright', 'Copyright © 2020 CRMTiger Version', '".$language."', 'Copyright © 2020 CRMTiger Version', 2),
            ('enter_username', 'Please enter username', '".$language."', 'Please enter username', 2),
            ('enter_password', 'Please enter password', '".$language."', 'Please enter password', 2),
            ('remanberme', 'Remember Me', '".$language."', 'Remember Me', 2),
            ('forgot_password', 'Forgot password?', '".$language."', 'Forgot password?', 2),
            ('privacy_policay1', 'Privacy Policy', '".$language."', 'Privacy Policy', 2),
            ('contactsupportmsg', 'Something went wrong. \\n please Click here to contact support.', '".$language."', 'Something went wrong. \\n please Click here to contact support.', 2),
            ('enter_username_password', 'Entered Username or Password is wrong', '".$language."', 'Entered Username or Password is wrong', 2),
            ('server_issue_occured', 'Server issues occurred', '".$language."', 'Server issues occurred', 2),
            ('password', 'Password', '".$language."', 'Password', 3),
            ('user_name', 'Username', '".$language."', 'Username', 3),
            ('reset_pwd', 'Reset Password', '".$language."', 'Reset Password', 3),
            ('forgot_password_title', 'Forgot password', '".$language."', 'Forgot password', 3),
            ('enter_user_name', 'Enter user name', '".$language."', 'Enter user name', 3),
            ('cc', 'Cc', '".$language."', 'Cc', 4),
            ('body', 'Body', '".$language."', 'Body', 4),
            ('bcc', 'BCC', '".$language."', 'BCC', 4),
            ('dialog_title_text_color', 'Select a Text Color', '".$language."', 'Select a Text Color', 4),
            ('date', 'Date', '".$language."', 'Date', 4),
            ('subject', 'Subject', '".$language."', 'Subject', 4),
            ('composeMail', 'Compose Mail', '".$language."', 'Compose Mail', 4),
            ('send', 'Send', '".$language."', 'Send', 4),
            ('select_message', 'Select message', '".$language."', 'Select message', 4),
            ('title_insert_table', 'Insert Table', '".$language."', 'Insert Table', 4),
            ('log_file_sms', 'I agree to Share API Log to Technical team for further troubleshooting', '".$language."', 'I agree to Share API Log to Technical team for further troubleshooting', 5),
            ('edit_record', 'Edit Records', '".$language."', 'Edit Records', 5),
            ('select_time', 'Select Time', '".$language."', 'Select Time', 5),
            ('edit_item', 'Edit Item', '".$language."', 'Edit Item', 5),
            ('items_total', 'Items Total', '".$language."', 'Items Total', 5),
            ('number_less_then_31', 'Number should be less than 31', '".$language."', 'Number should be less than 31', 5),
            ('users', 'Users', '".$language."', 'Users', 5),
            ('groups', 'Groups', '".$language."', 'Groups', 5),
            ('txt_note_for_file', 'Note : Existing attachments(images/files) will be replaced', '".$language."', 'Note : Existing attachments(images/files) will be replaced', 5),
            ('greaterdatetime', 'End DateTime should be greater than Start DateTime', '".$language."', 'End DateTime should be greater than Start DateTime', 5),
            ('until', 'Until', '".$language."', 'Until', 5),
            ('organizations', 'Organizations', '".$language."', 'Organizations', 6),
            ('contacts', 'Contacts', '".$language."', 'Contacts', 6),
            ('opportunity', 'Opportunity', '".$language."', 'Opportunity', 6),
            ('lbl_sun', 'SUN', '".$language."', 'SUN', 7),
            ('lbl_mon', 'MON', '".$language."', 'MON', 7),
            ('lbl_tue', 'TUE', '".$language."', 'TUE', 7),
            ('lbl_wed', 'WED', '".$language."', 'WED', 7),
            ('lbl_thu', 'THU', '".$language."', 'THU', 7),
            ('lbl_fri', 'FRI', '".$language."', 'FRI', 7),
            ('lbl_sat', 'SAT', '".$language."', 'SAT', 7),
            ('lbl_1', '1', '".$language."', '1', 7),
            ('lbl_2', '2', '".$language."', '2', 7),
            ('lbl_3', '3', '".$language."', '3', 7),
            ('lbl_4', '4', '".$language."', '4', 7),
            ('lbl_5', '5', '".$language."', '5', 7),
            ('lbl_6', '6', '".$language."', '6', 7),
            ('lbl_7', '7', '".$language."', '7', 7),
            ('lbl_8', '8', '".$language."', '8', 7),
            ('lbl_9', '9', '".$language."', '9', 7),
            ('lbl_10', '10', '".$language."', '10', 7),
            ('lbl_11', '11', '".$language."', '11', 7),
            ('lbl_12', '12', '".$language."', '12', 7),
            ('lbl_13', '13', '".$language."', '13', 7),
            ('lbl_14', '14', '".$language."', '14', 7),
            ('lbl_15', '15', '".$language."', '15', 7),
            ('lbl_16', '16', '".$language."', '16', 7),
            ('lbl_17', '17', '".$language."', '17', 7),
            ('lbl_18', '18', '".$language."', '18', 7),
            ('lbl_19', '19', '".$language."', '19', 7),
            ('lbl_20', '20', '".$language."', '20', 7),
            ('lbl_21', '21', '".$language."', '21', 7),
            ('lbl_22', '22', '".$language."', '22', 7),
            ('lbl_23', '23', '".$language."', '23', 7),
            ('lbl_24', '24', '".$language."', '24', 7),
            ('lbl_25', '25', '".$language."', '25', 7),
            ('lbl_26', '26', '".$language."', '26', 7),
            ('lbl_27', '27', '".$language."', '27', 7),
            ('lbl_28', '28', '".$language."', '28', 7),
            ('lbl_29', '29', '".$language."', '29', 7),
            ('lbl_30', '30', '".$language."', '30', 7),
            ('lbl_31', '31', '".$language."', '31', 7),
            ('lbl_32', '32', '".$language."', '32', 7),
            ('lbl_33', '33', '".$language."', '33', 7),
            ('lbl_34', '34', '".$language."', '34', 7),
            ('lbl_35', '35', '".$language."', '35', 7),
            ('lbl_36', '36', '".$language."', '36', 7),
            ('lbl_37', '37', '".$language."', '37', 7),
            ('lbl_38', '38', '".$language."', '38', 7),
            ('lbl_39', '39', '".$language."', '39', 7),
            ('lbl_40', '40', '".$language."', '40', 7),
            ('lbl_41', '41', '".$language."', '41', 7),
            ('lbl_42', '42', '".$language."', '42', 7),
            ('current_date', 'current date', '".$language."', 'current date', 7),
            ('event', 'Events', '".$language."', 'Events', 7),
            ('calendar', 'Calendar', '".$language."', 'Calendar', 7),
            ('latest_version', 'Latest Version :', '".$language."', 'Latest Version :', 8),
            ('expire_on', 'Next renewal date : ', '".$language."', 'Next renewal date : ', 8),
            ('ctmobile_ext_version', 'CTMobile Ext. Version : ', '".$language."', 'CTMobile Ext. Version : ', 8),
            ('you_have_latest_version', 'You already have latest version', '".$language."', 'You already have latest version', 8),
            ('latest_version1', 'You Already have latest version', '".$language."', 'You Already have latest version', 8),
            ('upgreaded', 'Upgrade', '".$language."', 'Upgrade', 8),
            ('downgrade', 'Downgrade', '".$language."', 'Downgrade', 8),
            ('dialog_recent_event_info', 'You can set from here how many number of records you want to show on Home screen for Recent Event.', '".$language."', 'You can set from here how many number of records you want to show on Home screen for Recent Event.', 8),
            ('dialog_feedback_info', 'You can submit your feedback with description , our team will check your feedback and get back to you.', '".$language."', 'You can submit your feedback with description , our team will check your feedback and get back to you.', 8),
            ('dialog_log_info', 'Log functionality is used for customer support / help , If you are facing any issues in app or any module or functionality is not working proper then you can enable share log with our development team.', '".$language."', 'Log functionality is used for customer support / help , If you are facing any issues in app or any module or functionality is not working proper then you can enable share log with our development team.', 8),
            ('info', 'Info', '".$language."', 'Info', 8),
            ('recent_history', 'Recent History', '".$language."', 'Recent History', 8),
            ('recent_feedback', 'Feedback', '".$language."', 'Feedback', 8),
            ('recent_log', 'Log', '".$language."', 'Log', 8),
            ('crmtiger_app_version', 'CRMTiger App Version : ', '".$language."', 'CRMTiger App Version : ', 8),
            ('historylimit', 'Recent History Limit', '".$language."', 'Recent History Limit', 8),
            ('radious_in_miles', 'radious_in_miles', '".$language."', 'radious_in_miles', 8),
            ('recentlimit', 'Recent Event Limit', '".$language."', 'Recent Event Limit', 8),
            ('upcoming_events', 'Upcoming Events', '".$language."', 'Upcoming Events', 8),
            ('rate_our_app', 'Rate Our App!', '".$language."', 'Rate Our App!', 8),
            ('feedback', 'Submit Feedback', '".$language."', 'Submit Feedback', 8),
            ('sendfeedback', 'Feedback Send', '".$language."', 'Feedback Send', 8),
            ('emaillimit', 'Email limit', '".$language."', 'Email limit', 8),
            ('log', 'Log', '".$language."', 'Log', 8),
            ('logclear', 'Log cleared successfully.', '".$language."', 'Log cleared successfully.', 8),
            ('dialog_recent_history_info', 'You can set from here how many number of records you want to show on Home screen for Recent History.', '".$language."', 'You can set from here how many number of records you want to show on Home screen for Recent History.', 8),
            ('proceed_to_upgrade1', 'Proceed to', '".$language."', 'Proceed to', 8),
            ('upgradation_message', 'will required logout and login again later.', '".$language."', 'will required logout and login again later.', 8),
            ('proceed_to_upgrade', 'Proceed to Upgrade', '".$language."', 'Proceed to Upgrade', 8),
            ('module_setting', 'Module Setting', '".$language."', 'Module Setting', 9),
            ('sortbyfield', 'Sort by field', '".$language."', 'Sort by field', 9),
            ('ascending', 'Ascending  A to Z', '".$language."', 'Ascending  A to Z', 9),
            ('descending', 'Descending  Z to A', '".$language."', 'Descending  Z to A', 9),
            ('first_field', 'First Field', '".$language."', 'First Field', 9),
            ('second_field', 'Second Field', '".$language."', 'Second Field', 9),
            ('third_field', 'Third Field', '".$language."', 'Third Field', 9),
            ('sure_want_restore', 'Are you sure you want to reset to default settings?', '".$language."', 'Are you sure you want to reset to default settings?', 9),
            ('orderlist', 'List Order', '".$language."', 'List Order', 9),
            ('module_reset', 'Restore to Default', '".$language."', 'Restore to Default', 9),
            ('display_fields', 'Display Fields', '".$language."', 'Display Fields', 9),
            ('discount_lessthen_100', 'Discount % should be less than 100', '".$language."', 'Discount % should be less than 100', 10),
            ('select_item', 'Select Item', '".$language."', 'Select Item', 10),
            ('item_comment', 'Item Comment', '".$language."', 'Item Comment', 10),
            ('record_name', 'Record Name is :', '".$language."', 'Record Name is :', 11),
            ('go_back', 'Go Back', '".$language."', 'Go Back', 11),
            ('please_enter_shortcut_name', 'Please Enter Shortcut Name', '".$language."', 'Please Enter Shortcut Name', 11),
            ('number_not_found', 'Contact Number not found', '".$language."', 'Contact Number not found', 11),
            ('mail_not_found', 'Mail Address not found', '".$language."', 'Mail Address not found', 11),
            ('create_shortcut', 'Create Shortcut', '".$language."', 'Create Shortcut', 11),
            ('contact_summary', 'Summary', '".$language."', 'Summary', 11),
            ('activites', 'Activities', '".$language."', 'Activities', 11),
            ('details', 'Details', '".$language."', 'Details', 11),
            ('related', 'Related', '".$language."', 'Related', 11),
            ('share_link', 'Share record with', '".$language."', 'Share record with', 11),
            ('edit', 'Edit', '".$language."', 'Edit', 11),
            ('duplicate', 'Duplicate', '".$language."', 'Duplicate', 11),
            ('whatsapp', 'Whatsapp', '".$language."', 'Whatsapp', 11),
            ('call', 'Call', '".$language."', 'Call', 11),
            ('choose_contact_for_call', 'Choose Contact for Call', '".$language."', 'Choose Contact for Call', 11),
            ('choose_contact_for_sms', 'Choose Contact for SMS', '".$language."', 'Choose Contact for SMS', 11),
            ('choose_contact_for_whatsapp', 'Choose Contact for WhatsApp', '".$language."', 'Choose Contact for WhatsApp', 11),
            ('chosse_contact_for_email', 'Choose Email', '".$language."', 'Choose Email', 11),
            ('attach_file', 'Attach Files', '".$language."', 'Attach Files', 11),
            ('close', 'Close', '".$language."', 'Close', 11),
            ('status', 'Status', '".$language."', 'Status', 11),
            ('stop', 'Stop', '".$language."', 'Stop', 11),
            ('zero', '0', '".$language."', '0', 11),
            ('record', 'Record', '".$language."', 'Record', 11),
            ('voice_note', 'Voice Note', '".$language."', 'Voice Note', 11),
            ('tickets', 'Tickets', '".$language."', 'Tickets', 12),
            ('check_out', 'Check Out', '".$language."', 'Check Out', 12),
            ('check_in', 'Check In', '".$language."', 'Check In', 12),
            ('select_any', 'Select any', '".$language."', 'Select any', 12),
            ('fulldetails', 'Show Full Details', '".$language."', 'Show Full Details', 12),
            ('checkin', 'Check-in', '".$language."', 'Check-in', 12),
            ('navigate', 'Navigate', '".$language."', 'Navigate', 12),
            ('product', 'Products', '".$language."', 'Products', 12),
            ('projectMilestone', 'Project Milestone', '".$language."', 'Project Milestone', 12),
            ('projecttask', 'Project Tasks', '".$language."', 'Project Tasks', 12),
            ('nearby', 'NearBy', '".$language."', 'NearBy', 13),
            ('document', 'Document', '".$language."', 'Document', 14),
            ('reply', 'Reply', '".$language."', 'Reply', 14),
            ('reply_all', 'Reply All', '".$language."', 'Reply All', 14),
            ('forward', 'Forward', '".$language."', 'Forward', 14),
            ('action', 'Action', '".$language."', 'Action', 14),
            ('select_first', 'Select First', '".$language."', 'Select First', 14),
            ('commentaddsuccessful', 'Comment added successfull', '".$language."', 'Comment added successfull', 14),
            ('move_to', 'Move to', '".$language."', 'Move to', 14),
            ('attach', 'Attach', '".$language."', 'Attach', 14),
            ('addcoment', 'Add Comment', '".$language."', 'Add Comment', 14),
            ('adddocument', 'Add Document', '".$language."', 'Add Document', 14),
            ('home', 'Home', '".$language."', 'Home', 15),
            ('checkout', 'Check-out', '".$language."', 'Check-out', 15),
            ('message_search', 'Search by name', '".$language."', 'Search by name', 15),
            ('start_shift', 'Start shift', '".$language."', 'Start shift', 15),
            ('end_shift', 'End shift', '".$language."', 'End shift', 15),
            ('today_meeting', 'Meetings', '".$language."', 'Meetings', 15),
            ('shift_time_track', 'Shift Time Track', '".$language."', 'Shift Time Track', 15),
            ('logout_msg', 'You have to login again , click', '".$language."', 'You have to login again , click', 15),
            ('logout_msg1', 'to continue.', '".$language."', 'to continue.', 15),
            ('permission_denied', 'You don\'t have permission to create', '".$language."', 'You don\'t have permission to create', 15),
            ('history', 'Activity stream', '".$language."', 'Activity stream', 15),
            ('search_value', 'Search value :', '".$language."', 'Search value :', 15),
            ('feed_back_msg', 'Please enter feedback message', '".$language."', 'Please enter feedback message', 16),
            ('feed_back_hint_msg', 'Enter feedback message', '".$language."', 'Enter feedback message', 16),
            ('submit', 'Submit', '".$language."', 'Submit', 16),
            ('check_app_not_installed', 'Application is not currently installed.', '".$language."', 'Application is not currently installed.', 17),
            ('send_sms_fail_message', 'SMS failed, please try again later!', '".$language."', 'SMS failed, please try again later!', 17),
            ('documentaddsuccessfully', 'Document Attach successfully', '".$language."', 'Document Attach successfully', 17),
            ('send_message', 'Send message', '".$language."', 'Send message', 17),
            ('sms_to', 'smsto:', '".$language."', 'smsto:', 17),
            ('add_list_message', 'Add List', '".$language."', 'Add List', 18),
            ('mylist', 'My List', '".$language."', 'My List', 18),
            ('filtername', 'Filter Name', '".$language."', 'Filter Name', 18),
            ('selectlist', 'Select a List', '".$language."', 'Select a List', 18),
            ('assingedto', 'Assigned To', '".$language."', 'Assigned To', 18),
            ('selectmodule', 'Select a module', '".$language."', 'Select a module', 18),
            ('add_list', 'Add Filter', '".$language."', 'Add Filter', 18),
            ('recent_event', 'Recent Event', '".$language."', 'Recent Event', 19),
            ('recent_hostory', 'Recent History', '".$language."', 'Recent History', 19),
            ('module_specific_settings', 'Module-Specific Settings', '".$language."', 'Module-Specific Settings', 19),
            ('talk_to_us', 'Talk to us', '".$language."', 'Talk to us', 19),
            ('report_a_bug', 'Report A Bug', '".$language."', 'Report A Bug', 19),
            ('faq', 'FAQ', '".$language."', 'FAQ', 19),
            ('selectmodules', 'Select Module', '".$language."', 'Select Module', 19),
            ('myplan', 'My Plan', '".$language."', 'My Plan', 19),
            ('message', 'Message', '".$language."', 'Message', 20),
            ('message_validation', 'Please enter Message', '".$language."', 'Please enter Message', 20),
            ('contact_select', 'Please Select contact', '".$language."', 'Please Select contact', 20),
            ('global_search', 'Global Search', '".$language."', 'Global Search', 21),
            ('records', 'Records', '".$language."', 'Records', 21),
            ('dont_show_again', 'Don\'t Show Again', '".$language."', 'Don\'t Show Again', 22),
            ('skip', 'Skip', '".$language."', 'Skip', 22),
            ('file_downloading', 'File Downloading', '".$language."', 'File Downloading', 23),
            ('add_screenshots_optional', 'Add screenshots (optional)', '".$language."', 'Add screenshots (optional)', 24),
            ('describe_your_problem', 'Describe your problem', '".$language."', 'Describe your problem', 24),
            ('default_filter_shortcut', 'Default Filter Shortcut', '".$language."', 'Default Filter Shortcut', 25),
            ('record_shortcut', 'Record Shortcut', '".$language."', 'Record Shortcut', 25),
            ('enter_url', 'Please Enter url', '".$language."', 'Please Enter url', 26),
            ('new_version_is_avaiable', 'You need to update the app to continue using Please update to continue Older versions will no longer work from today', '".$language."', 'You need to update the app to continue using Please update to continue Older versions will no longer work from today', 26),
            ('search_by', 'Search by', '".$language."', 'Search by', 27),
            ('selected_filter', 'Selected filter :', '".$language."', 'Selected filter :', 27),
            ('selected_field', 'Selected field :', '".$language."', 'Selected field :', 27),
            ('choose', 'Choose', '".$language."', 'Choose', 28),
            ('qr_cardscanner', 'QR Code Scanner', '".$language."', 'QR Code Scanner', 28),
            ('error_message_for_scan', 'Could not read the card Try again later.', '".$language."', 'Could not read the card Try again later.', 28),
            ('press_start_scan', 'Press to Start Scan', '".$language."', 'Press to Start Scan', 28),
            ('line_item_quntity_validation_msg', 'Value should be greater than zero', '".$language."', 'Value should be greater than zero', 29),
            ('percentage_msg', 'Percentage should be less than 100', '".$language."', 'Percentage should be less than 100', 29),
            ('MSG_NO_DATA', 'No data found!', '".$language."', 'No data found!', 29),
            ('MSG_SOMETHING_WRONG', 'Something went wrong!', '".$language."', 'Something went wrong!', 29),
            ('MSG_COMING_SOON', 'Coming Soon!', '".$language."', 'Coming Soon!', 29),
            ('MSG_UPLOAD_PROFILE_IMAGE', 'Please upload profile image.', '".$language."', 'Please upload profile image.', 29),
            ('ALERT_TITLE_LOCATION_ACCESS', 'Location Access', '".$language."', 'Location Access', 29),
            ('ALERT_MSG_LOCATION_ACCESS', 'Requires your location to show nearby events.', '".$language."', 'Requires your location to show nearby events.', 29),
            ('ALERT_BTN_ALLOW', 'ALLOW', '".$language."', 'ALLOW', 29),
            ('ALERT_BTN_DENY', 'DENY', '".$language."', 'DENY', 29),
            ('ALERT_MSG_LOCATION_SETTING', 'Not able to fetch your current location. Please check your location settings.', '".$language."', 'Not able to fetch your current location. Please check your location settings.', 29),
            ('DELETE_RECORD', 'Delete Record', '".$language."', 'Delete Record', 29),
            ('ALERT_MSG_DELETE_SHORTCUT', 'Are you sure want to delete this shortcut?', '".$language."', 'Are you sure want to delete this shortcut?', 29),
            ('DELETE_SHORTCUT', 'Delete Shortcut', '".$language."', 'Delete Shortcut', 29),
            ('LBL_TERMS', 'By logging in, you agree to our Terms and', '".$language."', 'By logging in, you agree to our Terms and', 29),
            ('LBL_CONDITIONS', 'Conditions &', '".$language."', 'Conditions &', 29),
            ('ALERT_TITLE', 'Alert', '".$language."', 'Alert', 29),
            ('ALERT_BTN_SUBSCRIBE', 'Subscribe', '".$language."', 'Subscribe', 29),
            ('MSG_SELECT_MODULE', 'Please select any Module', '".$language."', 'Please select any Module', 29),
            ('MSG_SELECT_LIST', 'Please select any List', '".$language."', 'Please select any List', 29),
            ('ALERT_MSG_DONT_HAVE_CAMERA', 'You don\'t have camera', '".$language."', 'You don\'t have camera', 29),
            ('ALERT_MSG_GALLARY_PERMISSION', 'You don\'t have permission to access gallery.', '".$language."', 'You don\'t have permission to access gallery.', 29),
            ('ALERT_MSG_CAMERA_PERMISSION', 'You don\'t have permission to access camera. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Camera on', '".$language."', 'You don\'t have permission to access camera. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Camera on', 29),
            ('ALERT_MSG_SPEECH_PERMISSION', 'You don\'t have permission to access Speech Recognition. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Speech Recognition on', '".$language."', 'You don\'t have permission to access Speech Recognition. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Speech Recognition on', 29),
            ('BTN_DONE', 'Done', '".$language."', 'Done', 29),
            ('COMMENT', 'Comment', '".$language."', 'Comment', 29),
            ('FULL_FORM', 'Full Form', '".$language."', 'Full Form', 29),
            ('QUICK_CREATE', 'Create', '".$language."', 'Create', 29),
            ('LBL_SELECT_FIELDS', 'Select Fields', '".$language."', 'Select Fields', 29),
            ('LBL_SELECT_FIELDS', 'Select Fields', '".$language."', 'Select Fields', 29),
            ('LBL_SELECT_FIRST_FIELDS', 'Select First Field', '".$language."', 'Select First Field', 29),
            ('LBL_SELECT_SECOND_FIELDS', 'Select Second Field', '".$language."', 'Select Second Field', 29),
            ('LBL_SELECT_THIRD_FIELDS', 'Select Third Field', '".$language."', 'Select Third Field', 29),
            ('LBL_SORT_BY_FIELD', 'Select Sort By Field', '".$language."', 'Select Sort By Field', 29),
            ('BTN_RESET_TO_DEFAULT', 'Reset to Default', '".$language."', 'Reset to Default', 29),
            ('MSG_SELECT_SORT_BY_FIELD', 'Select Sort by field', '".$language."', 'Select Sort by field', 29),
            ('kStrClearBtnTitle', 'Clear', '".$language."', 'Clear', 29),
            ('kStrShowMoreBtnTitle', 'Show More', '".$language."', 'Show More', 29),
            ('kStrAddActivitiesBtnTitle', 'Add Activities', '".$language."', 'Add Activities', 29),
            ('kStrAddCommentPlaceHolder', 'Add your comments here', '".$language."', 'Add your comments here', 29),
            ('MSG_ENTER_TO_EMAIL', 'Please enter to field.', '".$language."', 'Please enter to field.', 29),
            ('WARNING_FILE', 'File can\'t open.', '".$language."', 'File can\'t open.', 29),
            ('MSG_FILE_SAVED', 'File saved.', '".$language."', 'File saved.', 29),
            ('WARNING_DOWNLOAD_FAIL', 'Download fail!, please try after sometime.', '".$language."', 'Download fail!, please try after sometime.', 29),
            ('LBL_SHORTCUT', 'Shortcut', '".$language."', 'Shortcut', 29),
            ('TXT_MESSAGE_PLACEHOLDER', 'Type Message', '".$language."', 'Type Message', 29),
            ('ALERT_INSTALL_WHATSAPP', 'Install Whatsapp', '".$language."', 'Install Whatsapp', 29),
            ('MSG_NO_MAIL_BOX', 'No MailBox found. Please Create Mailbox', '".$language."', 'No MailBox found. Please Create Mailbox', 29),
            ('LBL_WROTE', 'Wrote', '".$language."', 'Wrote', 29),
            ('MSG_MAIL_SEND', 'Mail sent', '".$language."', 'Mail sent', 29),
            ('log_file_not_found', 'API Log file not found.', '".$language."', 'API Log file not found.', 29),
            ('unknown_error', 'An unknown error occurred, try again', '".$language."', 'An unknown error occurred, try again', 29),
            ('CTMTigerAppVersion', 'CRMTiger App Version', '".$language."', 'CRMTiger App Version', 29),
            ('CTMMobileUpdateMsg', 'CTMobile Ext. Version Update Successfully', '".$language."', 'CTMobile Ext. Version Update Successfully', 29),
            ('dialog_Premium_downgrade', 'Downgrade will required logout and login again later', '".$language."', 'Downgrade will required logout and login again later', 29),
            ('dialog_Premium', 'Upgrade will required logout and login again later', '".$language."', 'Upgrade will required logout and login again later', 29),
            ('Overwrite', 'Overwrite', '".$language."', 'Overwrite', 29),
            ('MSGAddressOverwrite1', 'Overwrite the existing address with the selected', '".$language."', 'Overwrite the existing address with the selected', 29),
            ('MSGAddressOverwrite2', 'address details?', '".$language."', 'address details?', 29),
            ('UPGRADE_PLAN', 'Upgrade Plan', '".$language."', 'Upgrade Plan', 29),
            ('DOWNGRADE_PLAN', 'Downgrade Plan', '".$language."', 'Downgrade Plan', 29),
            ('UPGRADE_EXTENSION', 'Upgrade Extension', '".$language."', 'Upgrade Extension', 29),
            ('UPGRADE_APP', 'Upgrade App', '".$language."', 'Upgrade App', 29),
            ('SELECT_OPTION', 'Select Option', '".$language."', 'Select Option', 29),
            ('PLEASE_SELECT', 'Please select', '".$language."', 'Please select', 29),
            ('MSG_ACCESS_DENIED', 'You don\'t have permission for this module.', '".$language."', 'You don\'t have permission for this module.', 29),
            ('MSG_SELECT_RECCURING_MONTH_DAY', 'Please select reccuring day of month.', '".$language."', 'Please select reccuring day of month.', 29),
            ('MSG_SELECT_RECCURING_WEEK_DAY', 'Please select reccuring day of week.', '".$language."', 'Please select reccuring day of week.', 29),
            ('MSG_SELECT_RECCURING_DAYS', 'Please select reccuring days.', '".$language."', 'Please select reccuring days.', 29),
            ('Please select reccuring days.', 'Please select reccuring days.', '".$language."', 'Please select reccuring days.', 29),
            ('MSG_SELECT_RECCURING_END_DATE', 'Please select reccuring end date.', '".$language."', 'Please select reccuring end date.', 29),
            ('MSG_SELECT_RECCURING_TYPE', 'Please select reccuring type.', '".$language."', 'Please select reccuring type.', 29),
            ('FREQ_TIME', 'Times', '".$language."', 'Times', 29),
            ('REPEAT_YEARLY', 'Repeat Yearly', '".$language."', 'Repeat Yearly', 29),
            ('REPEAT_MONTHLY', 'Repeat Monthly', '".$language."', 'Repeat Monthly', 29),
            ('REPEAT_WEEKLY', 'Repeat Weekly', '".$language."', 'Repeat Weekly', 29),
            ('REPEAT_DAILY', 'Repeat Daily', '".$language."', 'Repeat Daily', 29),
            ('ACTION_TITLE', 'Action Title', '".$language."', 'Action Title', 29),
            ('MSG_SELECT_VALID_DATE', 'Please select valid day of month.', '".$language."', 'Please select valid day of month.', 29),
            ('MSG_SELECT_VALID_START_DATE', 'Start date should be less than end date.', '".$language."', 'Start date should be less than end date.', 29),
            ('MSG_SELECT_VALID_START_TIME', 'Start time should be less than end time.', '".$language."', 'Start time should be less than end time.', 29),
            ('LBL_LINEITEM_DETAILS', 'Lineitem Details', '".$language."', 'Lineitem Details', 29),
            ('MSG_INVALIDE_DISCOUNT_AMOUNT', 'Discount amount should be less than the total.', '".$language."', 'Discount amount should be less than the total.', 29),
            ('VIEW', 'View', '".$language."', 'View', 29),
            ('MSG_ENTER_VALID', 'Please enter valid', '".$language."', 'Please enter valid', 29),
            ('MSG_ENTER_PERCENTAGE', 'Percentage should be less than 100.', '".$language."', 'Percentage should be less than 100.', 29),
            ('ITEM_TOTAL', 'Item Total', '".$language."', 'Item Total', 29),
            ('ADJUSTMENT', 'Adjustment', '".$language."', 'Adjustment', 29),
            ('TITLE_CHOOSE_IMAGE', 'Choose Image', '".$language."', 'Choose Image', 29),
            ('COMPRESS', 'Compress', '".$language."', 'Compress', 29),
            ('CHOOSE_ANOTHER_IMAGE', 'Your image size is too large, please select another image', '".$language."', 'Your image size is too large, please select another image', 29),
            ('OnDayOfMonth', 'On day of month', '".$language."', 'On day of month', 29),
            ('OnDayOfWeek', 'On day of week', '".$language."', 'On day of week', 29),
            ('AddAndClose', 'Add & Close', '".$language."', 'Add & Close', 29),
            ('Repeat', 'Repeat', '".$language."', 'Repeat', 29),
            ('OnDay', 'On day', '".$language."', 'On day', 29),
            ('View_Line_Item', 'View Line Item', '".$language."', 'View Line Item', 29),
            ('TITLE_IMAGE', 'Image', '".$language."', 'Image', 29),
            ('TITLE_ICLOUD', 'iCloud', '".$language."', 'iCloud', 29),
            ('GOOGLE', 'Google', '".$language."', 'Google', 29),
            ('ALERT_BTN_OKAY', 'Okay', '".$language."', 'Okay', 29),
            ('ALERT_TITLE_ACCESS_DENIED', 'Access Denied', '".$language."', 'Access Denied', 29),
            ('Dont_Show_Again', 'Don\'t show again', '".$language."', 'Don\'t show again', 29),
            ('Skip', 'Skip', '".$language."', 'Skip', 29),
            ('Fillter_Name', 'Fillter Name', '".$language."', 'Fillter Name', 29),
            ('Fillter_Record_Count', 'Fillter Record Count', '".$language."', 'Fillter Record Count', 29);",array());
        }
    }

    static function ar_ae(){
         global $adb;
        $checkQuery = "SELECT * FROM ctmobile_language_keyword WHERE keyword_lang = ?";
        $checkResult = $adb->pquery($checkQuery,array('ar_ae'));
        if($adb->num_rows($checkResult) == 0){

        $adb->pquery("INSERT INTO `ctmobile_language_keyword` (`keyword`, `keyword_name`, `keyword_lang`, `language_keyword`, `sectionid`) VALUES
            ('network_error', 'Network connection error!', 'ar_ae', 'خطأ في الشبكة!', 1),
            ('connection_check', 'Could not connect to CRM, Please check your Internet connection.', 'ar_ae', 'الرجاء التحقق من اتصال الانترنت الخاص بك.', 1),
            ('update', 'Update', 'ar_ae', 'تحديث', 1),
            ('cancel', 'Cancel', 'ar_ae', 'Cancel', 1),
            ('ok', 'Ok', 'ar_ae', 'حسنا', 1),
            ('more_information', 'Click here for more information.', 'ar_ae', 'انقر هنا للمزيد من المعلومات.', 1),
            ('yes', 'Yes', 'ar_ae', 'نعم فعلا', 1),
            ('no', 'No', 'ar_ae', 'لا', 1),
            ('click_again_exit', 'Click again to exit', 'ar_ae', 'انقر مرة أخرى للخروج', 1),
            ('forpermission', 'You don\'t have permission to view this feature. Please subscribe for Premium version Click here to Subscribe.', 'ar_ae', 'ليس لديك إذن لعرض هذه الميزات. يرجى الاشتراك للحصول على نسخة متميزة انقر هنا للاشتراك.', 1),
            ('clickhere', 'Click here', 'ar_ae', 'انقر هنا', 1),
            ('clickhere_subscribe', 'Click here to subscribe premium version', 'ar_ae', 'انقر هنا للاشتراك في الإصدار المميز', 1),
            ('clickhere_configure', 'Click here and view how to Configure.', 'ar_ae', 'انقر هنا وعرض كيفية تكوين.', 1),
            ('please_wait', 'Please Wait…', 'ar_ae', 'ارجوك انتظر…', 1),
            ('share__msg', 'Share file with', 'ar_ae', 'مشاركة الملف مع', 1),
            ('dialog_camera', 'Camera', 'ar_ae', 'الة تصوير', 1),
            ('dialog_add_file_by', 'Take Photo from', 'ar_ae', 'إضافة ملفات', 1),
            ('add', 'Add', 'ar_ae', 'إضافة', 1),
            ('mail_manager_configured', 'Mail Manager is not configured', 'ar_ae', 'لم يتم تكوين مدير البريد', 1),
            ('dialog_add_files_by', 'Add Files by', 'ar_ae', 'إضافة ملفات', 1),
            ('dialog_drive', 'Drive', 'ar_ae', 'قيادة', 1),
            ('dialog_drop_box', 'Drop Box', 'ar_ae', 'بصندوق الإسقاط', 1),
            ('dialog_need_signin', 'You need to Sign-in to your Drive account first.', 'ar_ae', 'يجب تسجيل الدخول إلى حساب Drive أولاً.', 1),
            ('dialog_gallery', 'Gallery', 'ar_ae', 'صالة عرض', 1),
            ('delete', 'Delete', 'ar_ae', 'حذف', 1),
            ('timeoutmessage', 'Oops! Request is taking more time than expected.', 'ar_ae', 'انتبه! الطلب يستغرق وقتًا أكثر مما هو متوقع.', 1),
            ('gps_location_message', 'GPS is not enabled. Please turn it on to get your near by locations.', 'ar_ae', 'لم يتم تمكين GPS. يرجى تشغيلها للحصول على قرب من المواقع.', 1),
            ('sure_want_delete', 'Are you sure want to delete ?', 'ar_ae', 'هل أنت متأكد من حذف؟', 1),
            ('select', 'Select', 'ar_ae', 'تحديد', 1),
            ('msgforrecordaudio', 'Minimum record duration one second.', 'ar_ae', 'الحد الأدنى لمدة سجل ثانية واحدة.', 1),
            ('permission_storage', 'Permission denied to read your External storage', 'ar_ae', 'تم رفض الإذن لقراءة وحدة التخزين الخارجية', 1),
            ('send_permission_msg', 'Send message permission denied', 'ar_ae', 'إرسال تم رفض الإذن', 1),
            ('choosefile', 'Choose File', 'ar_ae', 'اختر ملف', 1),
            ('enter', 'Enter', 'ar_ae', 'أدخل', 1),
            ('select_an_option', 'Select an Option', 'ar_ae', 'حدد اختيارا', 1),
            ('email_validation', 'Email is not valid', 'ar_ae', 'البريد الإلكتروني غير صالح', 1),
            ('please_enter', 'Please Enter', 'ar_ae', 'تفضل ', 1),
            ('website_validation_text', 'Website URL is not valid', 'ar_ae', 'عنوان url للموقع غير صالح', 1),
            ('selectvalue', 'Select value first', 'ar_ae', 'حدد القيمة أولا', 1),
            ('email', 'Email', 'ar_ae', 'البريد الإلكتروني', 1),
            ('enter_email_address', 'Enter email address', 'ar_ae', 'أدخل عنوان البريد الالكتروني', 1),
            ('email_address_not_correct', 'Email address incorrect', 'ar_ae', 'عنوان البريد الالكتروني غير صحيح', 1),
            ('pls_enter_subject', 'Please Enter Subject', 'ar_ae', 'من فضلك أدخل الموضوع', 1),
            ('attachFiles', 'Attached File', 'ar_ae', 'ملف مرفق', 1),
            ('from', 'From', 'ar_ae', 'من عند', 1),
            ('to', 'To', 'ar_ae', 'إلى', 1),
            ('call_permission_msg', 'Call permission denied', 'ar_ae', 'رفض تصريح المكالمة', 1),
            ('no_records', 'No records found', 'ar_ae', 'لا توجد سجلات', 1),
            ('fullform', 'Create New', 'ar_ae', 'خلق جديد إبداع جديد', 1),
            ('save', 'Save', 'ar_ae', 'حفظ', 1),
            ('total', 'Total', 'ar_ae', 'مجموع', 1),
            ('discount', 'Discount', 'ar_ae', 'خصم(٪)', 1),
            ('price', 'Price', 'ar_ae', 'السعر *', 1),
            ('quantity', 'Quantity', 'ar_ae', 'الكمية *', 1),
            ('select_module', 'Select Module', 'ar_ae', 'حدد الوحدة', 1),
            ('item_list', 'Item List', 'ar_ae', 'قائمة البند', 1),
            ('quickcreate', 'Quick Create', 'ar_ae', 'إنشاء سريع', 1),
            ('overwrite_msg_part1', 'Overwrite the existing address with the selected', 'ar_ae', 'الكتابة فوق العنوان الموجود مع المحدد ', 1),
            ('once_in_every', 'Once in every', 'ar_ae', 'مرة واحدة في كل', 1),
            ('overwrite_msg_part2', 'address details?', 'ar_ae', 'تفاصيل العنوان؟', 1),
            ('add_item', 'Add Item', 'ar_ae', 'اضافة عنصر', 1),
            ('recordsave', 'Record saved successfully', 'ar_ae', 'حفظ السجل بنجاح', 1),
            ('recordnotsave', 'Could not save record. Try again later', 'ar_ae', 'السجل لا يحفظ', 1),
            ('minutes', 'Minutes', 'ar_ae', 'الدقائق', 1),
            ('hours', 'Hours', 'ar_ae', 'ساعات', 1),
            ('days', 'Days', 'ar_ae', 'أيام', 1),
            ('on', 'On', 'ar_ae', 'على', 1),
            ('day_of_the_month', 'day of the month', 'ar_ae', 'يوم من الشهر', 1),
            ('list_price', 'List Price', 'ar_ae', 'قائمة الأسعار *', 1),
            ('add_record', 'Add Record', 'ar_ae', 'أضف سجل', 1),
            ('add_product', 'Add Product', 'ar_ae', 'أضف منتج', 1),
            ('add_service', 'Add Service', 'ar_ae', 'أضف خدمة', 1),
            ('discountin', 'Discount in %', 'ar_ae', 'الخصم في٪', 1),
            ('unitprice', 'Unit price', 'ar_ae', 'Unit price', 1),
            ('netprice', 'Net price', 'ar_ae', 'السعر الصافي*', 1),
            ('comments', 'Comments', 'ar_ae', 'تعليقات', 1),
            ('add_close', 'Add & Close', 'ar_ae', 'إضافة وإغلاق', 1),
            ('fetching_rout_message', 'Fetching route, Please wait…', 'ar_ae', 'إحضار الطريق ، يرجى الانتظار …', 1),
            ('setting', 'Settings', 'ar_ae', 'الإعدادات', 1),
            ('utc', 'UTC', 'ar_ae', 'التوقيت العالمي', 1),
            ('in', 'In', 'ar_ae', 'في ', 1),
            ('days_ago', 'days ago', 'ar_ae', 'أيام مضت', 1),
            ('mins_ago', 'Minutes ago', 'ar_ae', 'قبل دقيقة', 1),
            ('justnow', 'Just now', 'ar_ae', 'الآن فقط', 1),
            ('hours_ago', 'hours ago', 'ar_ae', 'منذ ساعات', 1),
            ('in_1_day', 'In 1 day', 'ar_ae', 'في يوم واحد', 1),
            ('scanqrcode', 'Card Scanner', 'ar_ae', 'ماسحة بطاقة', 1),
            ('call_log', 'Call Log', 'ar_ae', 'سجل المكالمات', 1),
            ('voice_message', 'Hi', 'ar_ae', 'مرحبا', 1),
            ('voice_message1', 'What can I search for you in', 'ar_ae', 'ما الذي يمكنني البحث عنه في', 1),
            ('live_tracking', 'Live Tracking', 'ar_ae', 'تتبع مباشر (فريق)', 1),
            ('mailmanager', 'Mail Manager', 'ar_ae', 'مدير البريد', 1),
            ('my_location', 'My location', 'ar_ae', 'موقعي', 1),
            ('created_on', 'Created On', 'ar_ae', 'تم إنشاؤها على', 1),
            ('modified_on', 'Modified On', 'ar_ae', 'تعديل على', 1),
            ('enter_comments', 'Enter Comments', 'ar_ae', 'أدخل التعليقات', 1),
            ('viewmore', 'View More', 'ar_ae', 'عرض المزيد', 1),
            ('viewless', 'View Less', 'ar_ae', 'عرض أقل', 1),
            ('gotofullform', 'Go to Full Form', 'ar_ae', 'الذهاب إلى النموذج الكامل', 1),
            ('post', 'Post', 'ar_ae', 'بريد', 1),
            ('url', 'URL', 'ar_ae', 'URL', 1),
            ('dialog_title_text_back_color', 'Select a Text Background Color', 'ar_ae', 'Select a Text Background Color', 1),
            ('event_or_task', 'Add event/task', 'ar_ae', 'البحث عن طريق', 1),
            ('shortcut', 'Shortcuts', 'ar_ae', 'اختصارات', 1),
            ('select_field', 'Select Field', 'ar_ae', 'اختر المجال', 1),
            ('share', 'Share', 'ar_ae', 'شارك', 1),
            ('title_insert_link', 'Insert Link', 'ar_ae', 'Insert Link', 1),
            ('addyourcommentshere', 'Add your comments here', 'ar_ae', 'أضف تعليقاتك هنا', 1),
            ('nocomment', 'No Comments', 'ar_ae', 'لا تعليقات', 1),
            ('leads', 'Leads', 'ar_ae', 'يؤدي', 1),
            ('true_val', 'true', 'ar_ae', 'true', 1),
            ('noresult', 'No Result', 'ar_ae', 'No Result', 1),
            ('version', 'Version', 'ar_ae', 'الإصدار', 1),
            ('convert_lead', 'Convert Lead', 'ar_ae', ' تحويل الرصاص', 1),
            ('app_name', 'CRMTiger', 'ar_ae', 'SalesHiker', 1),
            ('enter_url', 'Please Enter url', 'ar_ae', 'يرجى إدخال url', 1),
            ('help', 'Help', 'ar_ae', 'مساعدة', 1),
            ('contact_us', 'Contact Us', 'ar_ae', 'اتصل بنا', 1),
            ('updates', 'Updates', 'ar_ae', 'Updates', 1),
            ('logout', 'LogOut', 'ar_ae', 'الخروج', 1),
            ('busnies_cardscanner', 'Business Card Scanner', 'ar_ae', 'ماسحة بطاقة العمل', 1),
            ('sure_want_logout', 'Are you sure want to logout ?', 'ar_ae', 'هل أنت متأكد من تسجيل الخروج؟', 1),
            ('logout_message', 'Logout successfully', 'ar_ae', 'Logout successfully', 1),
            ('all', 'All', 'ar_ae', 'الكل', 1),
            ('add_event', 'Add event', 'ar_ae', 'إضافة حدث', 1),
            ('add_task', 'Add Task', 'ar_ae', 'إضافة مهمة', 1),
            ('next', 'Next', 'ar_ae', 'التالى', 1),
            ('login', 'Login', 'ar_ae', 'تسجيل الدخول', 2),
            ('privacy_policay', 'By logging in, you agree to our Terms and Conditions & Privacy Policy', 'ar_ae', 'من خلال تسجيل الدخول ، فإنك توافق على الشروط والأحكام  سياسة خاصة', 2),
            ('copyright', 'Copyright © 2020 CRMTiger Version', 'ar_ae', 'حقوق الطبع والنشر © 2020clickhere_subscribe CRMTiger الإصدار', 2),
            ('enter_username', 'Please enter username', 'ar_ae', 'الرجاء إدخال اسم المستخدم', 2),
            ('enter_password', 'Please enter password', 'ar_ae', 'يرجى إدخال كلمة المرور', 2),
            ('remanberme', 'Remember Me', 'ar_ae', 'تذكرنى', 2),
            ('forgot_password', 'Forgot password?', 'ar_ae', 'هل نسيت كلمة المرور؟', 2),
            ('privacy_policay1', 'Privacy Policy', 'ar_ae', 'سياسة خاصة', 2),
            ('contactsupportmsg', 'Something went wrong. \\n please Click here to contact support.', 'ar_ae', 'هناك خطأ ما. \ n يرجى النقر هنا للاتصال بالدعم.', 2),
            ('enter_username_password', 'Entered Username or Password is wrong', 'ar_ae', 'اسم المستخدم أو كلمة المرور المدخلتين غير صحيحين', 2),
            ('server_issue_occured', 'Server issues occurred', 'ar_ae', 'حدثت مشكلات في الخادم', 2),
            ('password', 'Password', 'ar_ae', 'كلمه السر', 3),
            ('user_name', 'Username', 'ar_ae', 'اسم المستخدم', 3),
            ('reset_pwd', 'Reset Password', 'ar_ae', 'إعادة ضبط كلمة المرور', 3),
            ('forgot_password_title', 'Forgot password', 'ar_ae', 'هل نسيت كلمة المرور', 3),
            ('enter_user_name', 'Enter user name', 'ar_ae', 'ادخل اسم المستخدم', 3),
            ('cc', 'Cc', 'ar_ae', 'سم مكعب', 4),
            ('body', 'Body', 'ar_ae', 'الجسم', 4),
            ('bcc', 'BCC', 'ar_ae', 'مخفية', 4),
            ('dialog_title_text_color', 'Select a Text Color', 'ar_ae', 'حدد لون النص', 4),
            ('date', 'Date', 'ar_ae', 'تاريخ', 4),
            ('subject', 'Subject', 'ar_ae', 'موضوع', 4),
            ('composeMail', 'Compose Mail', 'ar_ae', 'كتابة رسالة', 4),
            ('send', 'Send', 'ar_ae', 'إرسال', 4),
            ('select_message', 'Select message', 'ar_ae', 'اختر الرسالة', 4),
            ('title_insert_table', 'Insert Table', 'ar_ae', 'إدراج جدول', 4),
            ('log_file_sms', 'I agree to Share API Log to Technical team for further troubleshooting', 'ar_ae', 'أوافق على مشاركة سجل API إلى الفريق الفني لمزيد من استكشاف الأخطاء وإصلاحها', 5),
            ('edit_record', 'Edit Records', 'ar_ae', 'تحرير السجل', 5),
            ('select_time', 'Select Time', 'ar_ae', 'اختر الوقت', 5),
            ('edit_item', 'Edit Item', 'ar_ae', 'Edit Item', 5),
            ('items_total', 'Items Total', 'ar_ae', 'Items Total', 5),
            ('number_less_then_31', 'Number should be less than 31', 'ar_ae', 'Number should be less than 31', 5),
            ('users', 'Users', 'ar_ae', 'المستخدمين', 5),
            ('groups', 'Groups', 'ar_ae', 'المجموعات', 5),
            ('txt_note_for_file', 'Note : Existing attachments(images/files) will be replaced', 'ar_ae', 'ملاحظة: سيتم استبدال المرفقات الحالية (الصور / الملفات)', 5),
            ('greaterdatetime', 'End DateTime should be greater than Start DateTime', 'ar_ae', '<![CDATA[يجب أن يكون تاريخ ووقت الانتهاء أكبر من تاريخ ووقت البدء]]>', 5),
            ('until', 'Until', 'ar_ae', 'حتى', 5),
            ('organizations', 'Organizations', 'ar_ae', 'المنظمات', 6),
            ('contacts', 'Contacts', 'ar_ae', 'جهات الاتصال', 6),
            ('opportunity', 'Opportunity', 'ar_ae', 'فرصة', 6),
            ('lbl_sun', 'SUN', 'ar_ae', 'شمس', 7),
            ('lbl_mon', 'MON', 'ar_ae', 'MON', 7),
            ('lbl_tue', 'TUE', 'ar_ae', 'TUE', 7),
            ('lbl_wed', 'WED', 'ar_ae', 'WED', 7),
            ('lbl_thu', 'THU', 'ar_ae', 'THU', 7),
            ('lbl_fri', 'FRI', 'ar_ae', 'جمعة', 7),
            ('lbl_sat', 'SAT', 'ar_ae', 'جلسنا', 7),
            ('lbl_1', '1', 'ar_ae', '1', 7),
            ('lbl_2', '2', 'ar_ae', '2', 7),
            ('lbl_3', '3', 'ar_ae', '3', 7),
            ('lbl_4', '4', 'ar_ae', '4', 7),
            ('lbl_5', '5', 'ar_ae', '5', 7),
            ('lbl_6', '6', 'ar_ae', '6', 7),
            ('lbl_7', '7', 'ar_ae', '7', 7),
            ('lbl_8', '8', 'ar_ae', '8', 7),
            ('lbl_9', '9', 'ar_ae', '9', 7),
            ('lbl_10', '10', 'ar_ae', '10', 7),
            ('lbl_11', '11', 'ar_ae', '11', 7),
            ('lbl_12', '12', 'ar_ae', '12', 7),
            ('lbl_13', '13', 'ar_ae', '13', 7),
            ('lbl_14', '14', 'ar_ae', '14', 7),
            ('lbl_15', '15', 'ar_ae', '15', 7),
            ('lbl_16', '16', 'ar_ae', '16', 7),
            ('lbl_17', '17', 'ar_ae', '17', 7),
            ('lbl_18', '18', 'ar_ae', '18', 7),
            ('lbl_19', '19', 'ar_ae', '19', 7),
            ('lbl_20', '20', 'ar_ae', '20', 7),
            ('lbl_21', '21', 'ar_ae', '21', 7),
            ('lbl_22', '22', 'ar_ae', '22', 7),
            ('lbl_23', '23', 'ar_ae', '23', 7),
            ('lbl_24', '24', 'ar_ae', '24', 7),
            ('lbl_25', '25', 'ar_ae', '25', 7),
            ('lbl_26', '26', 'ar_ae', '26', 7),
            ('lbl_27', '27', 'ar_ae', '27', 7),
            ('lbl_28', '28', 'ar_ae', '28', 7),
            ('lbl_29', '29', 'ar_ae', '29', 7),
            ('lbl_30', '30', 'ar_ae', '30', 7),
            ('lbl_31', '31', 'ar_ae', '31', 7),
            ('lbl_32', '32', 'ar_ae', '32', 7),
            ('lbl_33', '33', 'ar_ae', '33', 7),
            ('lbl_34', '34', 'ar_ae', '34', 7),
            ('lbl_35', '35', 'ar_ae', '35', 7),
            ('lbl_36', '36', 'ar_ae', '36', 7),
            ('lbl_37', '37', 'ar_ae', '37', 7),
            ('lbl_38', '38', 'ar_ae', '38', 7),
            ('lbl_39', '39', 'ar_ae', '39', 7),
            ('lbl_40', '40', 'ar_ae', '40', 7),
            ('lbl_41', '41', 'ar_ae', '41', 7),
            ('lbl_42', '42', 'ar_ae', '42', 7),
            ('current_date', 'current date', 'ar_ae', 'التاريخ الحالي', 7),
            ('event', 'Events', 'ar_ae', 'أحداث', 7),
            ('calendar', 'Calendar', 'ar_ae', 'التقويم', 7),
            ('latest_version', 'Latest Version :', 'ar_ae', 'احدث اصدار : ', 8),
            ('expire_on', 'Expire On :', 'ar_ae', 'تنتهي في:', 8),
            ('ctmobile_ext_version', 'CTMobile Ext. Version :', 'ar_ae', 'CTMobile تحويلة. الإصدار :', 8),
            ('you_have_latest_version', 'You already have latest version', 'ar_ae', 'لديك بالفعل أحدث نسخة', 8),
            ('latest_version1', 'You Already have latest version', 'ar_ae', 'لديك بالفعل أحدث نسخة', 8),
            ('upgreaded', 'Upgrade', 'ar_ae', 'تطوير', 8),
            ('downgrade', 'Downgrade', 'ar_ae', 'تخفيض', 8),
            ('dialog_recent_event_info', 'You can set from here how many number of records you want to show on Home screen for Recent Event.', 'ar_ae', 'يمكنك تعيين عدد السجلات التي تريد إظهارها على الشاشة الرئيسية للحدث الأخير من هنا.', 8),
            ('dialog_feedback_info', 'You can submit your feedback with description , our team will check your feedback and get back to you.', 'ar_ae', 'يمكنك تعيين عدد السجلات التي تريد إظهارها على الشاشة الرئيسية للحدث الأخير من هنا.', 8),
            ('dialog_log_info', 'Log functionality is used for customer support / help , If you are facing any issues in app or any module or functionality is not working proper then you can enable share log with our development team.', 'ar_ae', 'يتم استخدام وظيفة سجل لدعم / مساعدة العملاء ، إذا كنت تواجه أي مشاكل في التطبيق أو أي وحدة نمطية أو وظيفة لا يعمل بشكل صحيح ، يمكنك تمكين سجل المشاركة مع فريق التطوير لدينا.', 8),
            ('info', 'Info', 'ar_ae', 'معلومات', 8),
            ('recent_history', 'Recent History', 'ar_ae', 'التاريخ الحديث', 8),
            ('recent_feedback', 'Feedback', 'ar_ae', 'ردود الفعل', 8),
            ('recent_log', 'Log', 'ar_ae', 'سجل', 8),
            ('crmtiger_app_version', 'CRMTiger App Version :', 'ar_ae', 'إصدار تطبيق CRMTiger:', 8),
            ('historylimit', 'Recent History Limit', 'ar_ae', 'حد التاريخ الحديث', 8),
            ('radious_in_miles', 'radious_in_miles', 'ar_ae', 'نصف القطر بالأميال', 8),
            ('recentlimit', 'Recent Event Limit', 'ar_ae', 'حدود الأحداث الأخيرة', 8),
            ('upcoming_events', 'Upcoming Events', 'ar_ae', 'الأحداث القادمة', 8),
            ('rate_our_app', 'Rate Our App!', 'ar_ae', 'Rate Our App!', 8),
            ('feedback', 'Submit Feedback', 'ar_ae', 'إرسال ملاحظات', 8),
            ('sendfeedback', 'Feedback Send', 'ar_ae', 'Feedback Send', 8),
            ('emaillimit', 'Email limit', 'ar_ae', 'حد البريد الإلكتروني', 8),
            ('log', 'Log', 'ar_ae', 'سجل', 8),
            ('logclear', 'Log cleared successfully.', 'ar_ae', 'تم محو السجل بنجاح', 8),
            ('dialog_recent_history_info', 'You can set from here how many number of records you want to show on Home screen for Recent History.', 'ar_ae', 'يمكنك تعيين عدد السجلات التي تريد إظهارها على الشاشة الرئيسية للسجل الحديث من هنا.', 8),
            ('proceed_to_upgrade1', 'Proceed to', 'ar_ae', 'الشروع في', 8),
            ('upgradation_message', 'will required logout and login again later.', 'ar_ae', 'سوف يتطلب تسجيل الخروج وتسجيل الدخول مرة أخرى في وقت لاحق.', 8),
            ('proceed_to_upgrade', 'Proceed to Upgrade', 'ar_ae', 'تابع للترقية', 8),
            ('module_setting', 'Module Setting', 'ar_ae', 'إعدادات الوحدة', 9),
            ('sortbyfield', 'Sort by field', 'ar_ae', 'الترتيب حسب المجال', 9),
            ('ascending', 'Ascending  A to Z', 'ar_ae', 'تصاعدي A إلى Z', 9),
            ('descending', 'Descending  Z to A', 'ar_ae', 'تنازلي Z إلى A', 9),
            ('first_field', 'First Field', 'ar_ae', 'الحقل الأول', 9),
            ('second_field', 'Second Field', 'ar_ae', 'الحقل الثاني', 9),
            ('third_field', 'Third Field', 'ar_ae', 'المجال الثالث', 9),
            ('sure_want_restore', 'Are you sure you want to reset to default settings?', 'ar_ae', 'هل تريد بالتأكيد إعادة تعيين الإعدادات الافتراضية؟', 9),
            ('orderlist', 'List Order', 'ar_ae', 'ترتيب القائمة', 9),
            ('module_reset', 'Restore to Default', 'ar_ae', 'إعادة تعيين إلى الافتراضي', 9),
            ('display_fields', 'Display Fields', 'ar_ae', 'حقول العرض', 9),
            ('discount_lessthen_100', 'Discount % should be less than 100', 'ar_ae', 'يجب أن يكون الخصم٪ أقل من 100', 10),
            ('select_item', 'Select Item', 'ar_ae', 'اختر البند', 10),
            ('item_comment', 'Item Comment', 'ar_ae', 'تعليق البند', 10),
            ('record_name', 'Record Name is :', 'ar_ae', 'اسم السجل هو: -', 11),
            ('go_back', 'Go Back', 'ar_ae', 'Go Back', 11),
            ('please_enter_shortcut_name', 'Please Enter Shortcut Name', 'ar_ae', 'الرجاء إدخال اسم الاختصار', 11),
            ('number_not_found', 'Contact Number not found', 'ar_ae', 'رقم الاتصال غير موجود', 11),
            ('mail_not_found', 'Mail Address not found', 'ar_ae', 'عنوان البريد غير موجود ', 11),
            ('create_shortcut', 'Create Shortcut', 'ar_ae', 'انشاء اختصار', 11),
            ('contact_summary', 'Summary', 'ar_ae', 'Summary', 11),
            ('activites', 'Activities', 'ar_ae', 'أنشطة', 11),
            ('details', 'Details', 'ar_ae', 'Details', 11),
            ('related', 'Related', 'ar_ae', 'Related', 11),
            ('share_link', 'Share record with', 'ar_ae', 'مشاركة السجل مع', 11),
            ('edit', 'Edit', 'ar_ae', 'Edit', 11),
            ('duplicate', 'Duplicate', 'ar_ae', 'Duplicate', 11),
            ('whatsapp', 'Whatsapp', 'ar_ae', 'Whatsapp', 11),
            ('call', 'Call', 'ar_ae', 'Call', 11),
            ('choose_contact_for_call', 'Choose Contact for Call', 'ar_ae', 'Choose Contact for Call', 11),
            ('choose_contact_for_sms', 'Choose Contact for SMS', 'ar_ae', 'Choose Contact for SMS', 11),
            ('choose_contact_for_whatsapp', 'Choose Contact for WhatsApp', 'ar_ae', 'Choose Contact for WhatsApp', 11),
            ('chosse_contact_for_email', 'Choose Email', 'ar_ae', 'Choose Email', 11),
            ('attach_file', 'Attach Files', 'ar_ae', 'Attach Files', 11),
            ('close', 'Close', 'ar_ae', 'Close', 11),
            ('status', 'Status', 'ar_ae', 'الحالة', 11),
            ('stop', 'Stop', 'ar_ae', 'توقف', 11),
            ('zero', '0', 'ar_ae', '0', 11),
            ('record', 'Record', 'ar_ae', 'سجل', 11),
            ('voice_note', 'Voice Note', 'ar_ae', ' ملاحظة صوتية', 11),
            ('tickets', 'Tickets', 'ar_ae', 'تذاكر', 12),
            ('check_out', 'Check Out', 'ar_ae', 'الدفع', 12),
            ('check_in', 'Check In', 'ar_ae', 'تحقق في', 12),
            ('select_any', 'Select any', 'ar_ae', 'Select any', 12),
            ('fulldetails', 'Show Full Details', 'ar_ae', 'إظهار التفاصيل الكاملة', 12),
            ('checkin', 'Check-in', 'ar_ae', 'تحقق في', 12),
            ('navigate', 'Navigate', 'ar_ae', 'التنقل', 12),
            ('product', 'Products', 'ar_ae', 'منتجات', 12),
            ('projectMilestone', 'Project Milestone', 'ar_ae', 'معلما المشروع', 12),
            ('projecttask', 'Project Tasks', 'ar_ae', 'المشاريع المهمة', 12),
            ('nearby', 'NearBy', 'ar_ae', 'مجاوز', 13),
            ('document', 'Document', 'ar_ae', 'وثيقة', 14),
            ('reply', 'Reply', 'ar_ae', 'الرد', 14),
            ('reply_all', 'Reply All', 'ar_ae', 'الرد على الجميع', 14),
            ('forward', 'Forward', 'ar_ae', 'إلى الأمام', 14),
            ('action', 'Action', 'ar_ae', 'عمل', 14),
            ('select_first', 'Select First', 'ar_ae', 'اختر الأول', 14),
            ('commentaddsuccessful', 'Comment added successfull', 'ar_ae', 'تم إضافة التعليق بنجاح', 14),
            ('move_to', 'Move to', 'ar_ae', 'الانتقال إلى', 14),
            ('attach', 'Attach', 'ar_ae', 'يربط', 14),
            ('addcoment', 'Add Comment', 'ar_ae', 'أضف تعليق', 14),
            ('adddocument', 'Add Document', 'ar_ae', 'إضافة وثيقة', 14),
            ('home', 'Home', 'ar_ae', 'الصفحة الرئيسية', 15),
            ('checkout', 'Check-out', 'ar_ae', 'الدفع', 15),
            ('message_search', 'Search by name', 'ar_ae', 'البحث عن طريق الإسم', 15),
            ('start_shift', 'Start shift', 'ar_ae', 'بدء التحول', 15),
            ('end_shift', 'End shift', 'ar_ae', 'نهاية التحول', 15),
            ('today_meeting', 'Meetings', 'ar_ae', 'اجتماعات', 15),
            ('shift_time_track', 'Shift Time Track', 'ar_ae', 'التحول الزمني المسار', 15),
            ('logout_msg', 'You have to login again , click', 'ar_ae', 'You have to login again , click', 15),
            ('logout_msg1', 'to continue.', 'ar_ae', 'to continue.', 15),
            ('permission_denied', 'You don\'t have permission to create', 'ar_ae', 'ليس لديك إذن لإنشاء', 15),
            ('history', 'Activity stream', 'ar_ae', 'تيار النشاط', 15),
            ('search_value', 'Search value :', 'ar_ae', 'قيمة البحث: -', 15),
            ('feed_back_msg', 'Please enter feedback message', 'ar_ae', 'يرجى إدخال رسالة ملاحظات', 16),
            ('feed_back_hint_msg', 'Enter feedback message', 'ar_ae', 'أدخل رسالة التعليقات', 16),
            ('submit', 'Submit', 'ar_ae', 'خضع', 16),
            ('check_app_not_installed', 'Application is not currently installed.', 'ar_ae', 'التطبيق غير مثبت حاليا.', 17),
            ('send_sms_fail_message', 'SMS failed, please try again later!', 'ar_ae', 'فشلت رسالة SMS ، يرجى المحاولة مرة أخرى في وقت لاحق!', 17),
            ('documentaddsuccessfully', 'Document Attach successfully', 'ar_ae', 'إرفاق المستند بنجاح', 17),
            ('send_message', 'Send message', 'ar_ae', 'إرسال رسالة', 17),
            ('sms_to', 'smsto:', 'ar_ae', 'smsto:', 17),
            ('add_list_message', 'Add List', 'ar_ae', 'اضف قائمة', 18),
            ('mylist', 'My List', 'ar_ae', 'قوائمي', 18),
            ('filtername', 'Filter Name', 'ar_ae', 'اسم الفلتر', 18),
            ('selectlist', 'Select a List', 'ar_ae', 'حدد وحدة نمطية *', 18),
            ('assingedto', 'Assigned To', 'ar_ae', 'مخصص ل*', 18),
            ('selectmodule', 'Select a module', 'ar_ae', 'حدد وحدة نمطية', 18),
            ('add_list', 'Add Filter', 'ar_ae', 'إضافة مرشح', 18),
            ('recent_event', 'Recent Event', 'ar_ae', 'حدث حديث', 19),
            ('recent_hostory', 'Recent History', 'ar_ae', 'التاريخ الحديث', 19),
            ('module_specific_settings', 'Module-Specific Settings', 'ar_ae', 'إعدادات الوحدة النمطية', 19),
            ('talk_to_us', 'Talk to us', 'ar_ae', 'تكلم معنا', 19),
            ('report_a_bug', 'Report A Bug', 'ar_ae', 'الإبلاغ عن خطأ', 19),
            ('faq', 'FAQ', 'ar_ae', 'التعليمات', 19),
            ('selectmodules', 'Select Module', 'ar_ae', 'اختر الوحدة', 19),
            ('myplan', 'My Plan', 'ar_ae', 'My Plan', 19),
            ('message', 'Message', 'ar_ae', 'رسالة', 20),
            ('message_validation', 'Please enter Message', 'ar_ae', 'يرجى إدخال الرسالة', 20),
            ('contact_select', 'Please Select contact', 'ar_ae', 'يرجى تحديد الاتصال', 20),
            ('global_search', 'Global Search', 'ar_ae', 'البحث العالمي', 21),
            ('records', 'Records', 'ar_ae', 'تسجيل', 21),
            ('dont_show_again', 'Don\'t Show Again', 'ar_ae', 'لا تظهر مرة أخرى', 22),
            ('skip', 'Skip', 'ar_ae', 'تخطى >', 22),
            ('file_downloading', 'File Downloading', 'ar_ae', 'تحميل الملف', 23),
            ('add_screenshots_optional', 'Add screenshots (optional)', 'ar_ae', 'إضافة لقطات شاشة (اختياري)', 24),
            ('describe_your_problem', 'Describe your problem', 'ar_ae', 'صف مشكلتك', 24),
            ('default_filter_shortcut', 'Default Filter Shortcut', 'ar_ae', 'اختصار تصفية الافتراضي', 25),
            ('record_shortcut', 'Record Shortcut', 'ar_ae', 'Record Shortcut', 25),
            ('enter_url', 'Please Enter url', 'ar_ae', 'Please Enter url', 26),
            ('new_version_is_avaiable', 'You need to update the app to continue using Please update to continue Older versions will no longer work from today', 'ar_ae', 'تحتاج إلى تحديث التطبيق لمتابعة الاستخدام. الرجاء التحديث للمتابعة. الإصدارات القديمة لن تعمل من اليوم', 26),
            ('search_by', 'Search by', 'ar_ae', 'البحث عن طريق', 27),
            ('selected_filter', 'Selected filter :', 'ar_ae', 'مرشح محدد: -', 27),
            ('selected_field', 'Selected field :', 'ar_ae', 'الحقل المحدد: -', 27),
            ('choose', 'Choose', 'ar_ae', 'أختر', 28),
            ('qr_cardscanner', 'QR Code Scanner', 'ar_ae', 'رمز الاستجابة السريعة الماسح الضوئي', 28),
            ('error_message_for_scan', 'Could not read the card Try again later.', 'ar_ae', 'لا يمكن قراءة البطاقة حاول مرة أخرى لاحقًا.', 28),
            ('press_start_scan', 'Press to Start Scan', 'ar_ae', 'اضغط لبدء المسح الضوئي', 28),
            ('line_item_quntity_validation_msg', 'Value should be greater than zero', 'ar_ae', 'Value should be greater than zero', 29),
            ('percentage_msg', 'Percentage should be less than 100', 'ar_ae', 'Percentage should be less than 100', 29),
            ('MSG_NO_DATA', 'No data found!', 'ar_ae', 'No data found!', 29),
            ('MSG_SOMETHING_WRONG', 'Something went wrong!', 'ar_ae', 'Something went wrong!', 29),
            ('MSG_COMING_SOON', 'Coming Soon!', 'ar_ae', 'Coming Soon!', 29),
            ('MSG_UPLOAD_PROFILE_IMAGE', 'Please upload profile image.', 'ar_ae', 'Please upload profile image.', 29),
            ('ALERT_TITLE_LOCATION_ACCESS', 'Location Access', 'ar_ae', 'Location Access', 29),
            ('ALERT_MSG_LOCATION_ACCESS', 'Requires your location to show nearby events.', 'ar_ae', 'Requires your location to show nearby events.', 29),
            ('ALERT_BTN_ALLOW', 'ALLOW', 'ar_ae', 'ALLOW', 29),
            ('ALERT_BTN_DENY', 'DENY', 'ar_ae', 'DENY', 29),
            ('ALERT_MSG_LOCATION_SETTING', 'Not able to fetch your current location. Please check your location settings.', 'ar_ae', 'Not able to fetch your current location. Please check your location settings.', 29),
            ('DELETE_RECORD', 'Delete Record', 'ar_ae', 'Delete Record', 29),
            ('ALERT_MSG_DELETE_SHORTCUT', 'Are you sure want to delete this shortcut?', 'ar_ae', 'Are you sure want to delete this shortcut?', 29),
            ('DELETE_SHORTCUT', 'Delete Shortcut', 'ar_ae', 'Delete Shortcut', 29),
            ('LBL_TERMS', 'By logging in, you agree to our Terms and', 'ar_ae', 'By logging in, you agree to our Terms and', 29),
            ('LBL_CONDITIONS', 'Conditions &', 'ar_ae', 'Conditions &', 29),
            ('ALERT_TITLE', 'Alert', 'ar_ae', 'Alert', 29),
            ('ALERT_BTN_SUBSCRIBE', 'Subscribe', 'ar_ae', 'Subscribe', 29),
            ('MSG_SELECT_MODULE', 'Please select any Module', 'ar_ae', 'Please select any Module', 29),
            ('MSG_SELECT_LIST', 'Please select any List', 'ar_ae', 'Please select any List', 29),
            ('ALERT_MSG_DONT_HAVE_CAMERA', 'You don\'t have camera', 'ar_ae', 'You don\'t have camera', 29),
            ('ALERT_MSG_GALLARY_PERMISSION', 'You don\'t have permission to access gallery.', 'ar_ae', 'You don\'t have permission to access gallery.', 29),
            ('ALERT_MSG_CAMERA_PERMISSION', 'You don\'t have permission to access camera. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Camera on', 'ar_ae', 'You don\'t have permission to access camera. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Camera on', 29),
            ('ALERT_MSG_SPEECH_PERMISSION', 'You don\'t have permission to access Speech Recognition. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Speech Recognition on', 'ar_ae', 'You don\'t have permission to access Speech Recognition. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Speech Recognition on', 29),
            ('BTN_DONE', 'Done', 'ar_ae', 'Done', 29),
            ('COMMENT', 'Comment', 'ar_ae', 'Comment', 29),
            ('FULL_FORM', 'Full Form', 'ar_ae', 'Full Form', 29),
            ('QUICK_CREATE', 'Create', 'ar_ae', 'Create', 29),
            ('LBL_SELECT_FIELDS', 'Select Fields', 'ar_ae', 'Select Fields', 29),
            ('LBL_SELECT_FIELDS', 'Select Fields', 'ar_ae', 'Select Fields', 29),
            ('LBL_SELECT_FIRST_FIELDS', 'Select First Field', 'ar_ae', 'Select First Field', 29),
            ('LBL_SELECT_SECOND_FIELDS', 'Select Second Field', 'ar_ae', 'Select Second Field', 29),
            ('LBL_SELECT_THIRD_FIELDS', 'Select Third Field', 'ar_ae', 'Select Third Field', 29),
            ('LBL_SORT_BY_FIELD', 'Select Sort By Field', 'ar_ae', 'Select Sort By Field', 29),
            ('BTN_RESET_TO_DEFAULT', 'Reset to Default', 'ar_ae', 'Reset to Default', 29),
            ('MSG_SELECT_SORT_BY_FIELD', 'Select Sort by field', 'ar_ae', 'Select Sort by field', 29),
            ('kStrClearBtnTitle', 'Clear', 'ar_ae', 'Clear', 29),
            ('kStrShowMoreBtnTitle', 'Show More', 'ar_ae', 'Show More', 29),
            ('kStrAddActivitiesBtnTitle', 'Add Activities', 'ar_ae', 'Add Activities', 29),
            ('kStrAddCommentPlaceHolder', 'Add your comments here', 'ar_ae', 'Add your comments here', 29),
            ('MSG_ENTER_TO_EMAIL', 'Please enter to field.', 'ar_ae', 'Please enter to field.', 29),
            ('WARNING_FILE', 'File can\'t open.', 'ar_ae', 'File can\'t open.', 29),
            ('MSG_FILE_SAVED', 'File saved.', 'ar_ae', 'File saved.', 29),
            ('WARNING_DOWNLOAD_FAIL', 'Download fail!, please try after sometime.', 'ar_ae', 'Download fail!, please try after sometime.', 29),
            ('LBL_SHORTCUT', 'Shortcut', 'ar_ae', 'Shortcut', 29),
            ('TXT_MESSAGE_PLACEHOLDER', 'Type Message', 'ar_ae', 'Type Message', 29),
            ('ALERT_INSTALL_WHATSAPP', 'Install Whatsapp', 'ar_ae', 'Install Whatsapp', 29),
            ('MSG_NO_MAIL_BOX', 'No MailBox found. Please Create Mailbox', 'ar_ae', 'No MailBox found. Please Create Mailbox', 29),
            ('LBL_WROTE', 'Wrote', 'ar_ae', 'Wrote', 29),
            ('MSG_MAIL_SEND', 'Mail sent', 'ar_ae', 'Mail sent', 29),
            ('log_file_not_found', 'API Log file not found.', 'ar_ae', 'API Log file not found.', 29),
            ('unknown_error', 'An unknown error occurred, try again', 'ar_ae', 'An unknown error occurred, try again', 29),
            ('CTMTigerAppVersion', 'CRMTiger App Version', 'ar_ae', 'CRMTiger App Version', 29),
            ('CTMMobileUpdateMsg', 'CTMobile Ext. Version Update Successfully', 'ar_ae', 'CTMobile Ext. Version Update Successfully', 29),
            ('dialog_Premium_downgrade', 'Downgrade will required logout and login again later', 'ar_ae', 'Downgrade will required logout and login again later', 29),
            ('dialog_Premium', 'Upgrade will required logout and login again later', 'ar_ae', 'Upgrade will required logout and login again later', 29),
            ('Overwrite', 'Overwrite', 'ar_ae', 'Overwrite', 29),
            ('MSGAddressOverwrite1', 'Overwrite the existing address with the selected', 'ar_ae', 'Overwrite the existing address with the selected', 29),
            ('MSGAddressOverwrite2', 'address details?', 'ar_ae', 'address details?', 29),
            ('UPGRADE_PLAN', 'Upgrade Plan', 'ar_ae', 'Upgrade Plan', 29),
            ('DOWNGRADE_PLAN', 'Downgrade Plan', 'ar_ae', 'Downgrade Plan', 29),
            ('UPGRADE_EXTENSION', 'Upgrade Extension', 'ar_ae', 'Upgrade Extension', 29),
            ('UPGRADE_APP', 'Upgrade App', 'ar_ae', 'Upgrade App', 29),
            ('SELECT_OPTION', 'Select Option', 'ar_ae', 'Select Option', 29),
            ('PLEASE_SELECT', 'Please select', 'ar_ae', 'Please select', 29),
            ('MSG_ACCESS_DENIED', 'You don\'t have permission for this module.', 'ar_ae', 'You don\'t have permission for this module.', 29),
            ('MSG_SELECT_RECCURING_MONTH_DAY', 'Please select reccuring day of month.', 'ar_ae', 'Please select reccuring day of month.', 29),
            ('MSG_SELECT_RECCURING_WEEK_DAY', 'Please select reccuring day of week.', 'ar_ae', 'Please select reccuring day of week.', 29),
            ('MSG_SELECT_RECCURING_DAYS', 'Please select reccuring days.', 'ar_ae', 'Please select reccuring days.', 29),
            ('Please select reccuring days.', 'Please select reccuring days.', 'ar_ae', 'Please select reccuring days.', 29),
            ('MSG_SELECT_RECCURING_END_DATE', 'Please select reccuring end date.', 'ar_ae', 'Please select reccuring end date.', 29),
            ('MSG_SELECT_RECCURING_TYPE', 'Please select reccuring type.', 'ar_ae', 'Please select reccuring type.', 29),
            ('FREQ_TIME', 'Times', 'ar_ae', 'Times', 29),
            ('REPEAT_YEARLY', 'Repeat Yearly', 'ar_ae', 'Repeat Yearly', 29),
            ('REPEAT_MONTHLY', 'Repeat Monthly', 'ar_ae', 'Repeat Monthly', 29),
            ('REPEAT_WEEKLY', 'Repeat Weekly', 'ar_ae', 'Repeat Weekly', 29),
            ('REPEAT_DAILY', 'Repeat Daily', 'ar_ae', 'Repeat Daily', 29),
            ('ACTION_TITLE', 'Action Title', 'ar_ae', 'Action Title', 29),
            ('MSG_SELECT_VALID_DATE', 'Please select valid day of month.', 'ar_ae', 'Please select valid day of month.', 29),
            ('MSG_SELECT_VALID_START_DATE', 'Start date should be less than end date.', 'ar_ae', 'Start date should be less than end date.', 29),
            ('MSG_SELECT_VALID_START_TIME', 'Start time should be less than end time.', 'ar_ae', 'Start time should be less than end time.', 29),
            ('LBL_LINEITEM_DETAILS', 'Lineitem Details', 'ar_ae', 'Lineitem Details', 29),
            ('MSG_INVALIDE_DISCOUNT_AMOUNT', 'Discount amount should be less than the total.', 'ar_ae', 'Discount amount should be less than the total.', 29),
            ('VIEW', 'View', 'ar_ae', 'View', 29),
            ('MSG_ENTER_VALID', 'Please enter valid', 'ar_ae', 'Please enter valid', 29),
            ('MSG_ENTER_PERCENTAGE', 'Percentage should be less than 100.', 'ar_ae', 'Percentage should be less than 100.', 29),
            ('ITEM_TOTAL', 'Item Total', 'ar_ae', 'Item Total', 29),
            ('ADJUSTMENT', 'Adjustment', 'ar_ae', 'Adjustment', 29),
            ('TITLE_CHOOSE_IMAGE', 'Choose Image', 'ar_ae', 'Choose Image', 29),
            ('COMPRESS', 'Compress', 'ar_ae', 'Compress', 29),
            ('CHOOSE_ANOTHER_IMAGE', 'Your image size is too large, please select another image', 'ar_ae', 'Your image size is too large, please select another image', 29),
            ('OnDayOfMonth', 'On day of month', 'ar_ae', 'On day of month', 29),
            ('OnDayOfWeek', 'On day of week', 'ar_ae', 'On day of week', 29),
            ('AddAndClose', 'Add & Close', 'ar_ae', 'Add & Close', 29),
            ('Repeat', 'Repeat', 'ar_ae', 'Repeat', 29),
            ('OnDay', 'On day', 'ar_ae', 'On day', 29),
            ('View_Line_Item', 'View Line Item', 'ar_ae', 'View Line Item', 29),
            ('TITLE_IMAGE', 'Image', 'ar_ae', 'Image', 29),
            ('TITLE_ICLOUD', 'iCloud', 'ar_ae', 'iCloud', 29),
            ('GOOGLE', 'Google', 'ar_ae', 'Google', 29),
            ('ALERT_BTN_OKAY', 'Okay', 'ar_ae', 'Okay', 29),
            ('ALERT_TITLE_ACCESS_DENIED', 'Access Denied', 'ar_ae', 'Access Denied', 29),
            ('Dont_Show_Again', 'Don\'t show again', 'ar_ae', 'Don\'t show again', 29),
            ('Skip', 'Skip', 'ar_ae', 'Skip', 29),
            ('Fillter_Name', 'Fillter Name', 'ar_ae', 'Fillter Name', 29),
            ('Fillter_Record_Count', 'Fillter Record Count', 'ar_ae', 'Fillter Record Count', 29);",array());
        }
    }

    static function de_de(){
         global $adb;
        $checkQuery = "SELECT * FROM ctmobile_language_keyword WHERE keyword_lang = ?";
        $checkResult = $adb->pquery($checkQuery,array('de_de'));
        if($adb->num_rows($checkResult) == 0){

        $adb->pquery("INSERT INTO `ctmobile_language_keyword` (`keyword`, `keyword_name`, `keyword_lang`, `language_keyword`, `sectionid`) VALUES
            ('network_error', 'Network connection error!', 'de_de', 'Netzwerkfehler!', 1),
            ('connection_check', 'Could not connect to CRM, Please check your Internet connection.', 'de_de', 'Bitte überprüfe deine Internetverbindung.', 1),
            ('update', 'Update', 'de_de', 'Aktualisieren', 1),
            ('cancel', 'Cancel', 'de_de', 'Stornieren', 1),
            ('ok', 'Ok', 'de_de', 'OK', 1),
            ('more_information', 'Click here for more information.', 'de_de', 'Klicken Sie hier für weitere Informationen.', 1),
            ('yes', 'Yes', 'de_de', 'Ja', 1),
            ('no', 'No', 'de_de', 'Nein', 1),
            ('click_again_exit', 'Click again to exit', 'de_de', 'Klicken Sie erneut, um den Vorgang zu beenden', 1),
            ('forpermission', 'You don\'t have permission to view this feature. Please subscribe for Premium version Click here to Subscribe.', 'de_de', 'Sie haben keine Berechtigung, diese Funktion anzuzeigen. Bitte abonnieren Sie die Premium-Version. Klicken Sie hier, um sich anzumelden.', 1),
            ('clickhere', 'Click here', 'de_de', 'Klick hier', 1),
            ('clickhere_subscribe', 'Click here to subscribe premium version', 'de_de', 'Klicken Sie hier, um sich anzumelden', 1),
            ('clickhere_configure', 'Click here and view how to Configure.', 'de_de', 'Klicken Sie hier und sehen Sie, wie Sie konfigurieren.', 1),
            ('please_wait', 'Please Wait…', 'de_de', 'Warten Sie mal…', 1),
            ('share__msg', 'Share file with', 'de_de', 'Datei teilen mit', 1),
            ('dialog_camera', 'Camera', 'de_de', 'Kamera', 1),
            ('dialog_add_file_by', 'Take Photo from', 'de_de', 'Dateien hinzufügen von', 1),
            ('add', 'Add', 'de_de', 'Hinzufügen', 1),
            ('mail_manager_configured', 'Mail Manager is not configured', 'de_de', 'Mail Manager ist nicht konfiguriert', 1),
            ('dialog_add_files_by', 'Add Files by', 'de_de', 'Dateien hinzufügen von', 1),
            ('dialog_drive', 'Drive', 'de_de', 'Fahrt', 1),
            ('dialog_drop_box', 'Drop Box', 'de_de', 'Drop Box', 1),
            ('dialog_need_signin', 'You need to Sign-in to your Drive account first.', 'de_de', 'Sie müssen sich zuerst anmelden', 1),
            ('dialog_gallery', 'Gallery', 'de_de', 'Galerie', 1),
            ('delete', 'Delete', 'de_de', 'Löschen', 1),
            ('timeoutmessage', 'Oops! Request is taking more time than expected.', 'de_de', 'Hoppla, die Anfrage dauert länger als erwartet.', 1),
            ('gps_location_message', 'GPS is not enabled. Please turn it on to get your near by locations.', 'de_de', 'GPS ist nicht aktiviert. Bitte schalten Sie es ein, um in Ihre Nähe zu gelangen.', 1),
            ('sure_want_delete', 'Are you sure want to delete ?', 'de_de', 'Möchten Sie wirklich löschen?', 1),
            ('select', 'Select', 'de_de', 'Select', 1),
            ('msgforrecordaudio', 'Minimum record duration one second.', 'de_de', 'Minimale Aufzeichnungsdauer eine Sekunde.', 1),
            ('permission_storage', 'Permission denied to read your External storage', 'de_de', 'Die Berechtigung zum Lesen Ihres externen Speichers wurde verweigert', 1),
            ('send_permission_msg', 'Send message permission denied', 'de_de', 'Berechtigung zum Senden von Nachrichten verweigert', 1),
            ('choosefile', 'Choose File', 'de_de', 'Datei wählen', 1),
            ('enter', 'Enter', 'de_de', 'Eingeben', 1),
            ('select_an_option', 'Select an Option', 'de_de', 'Wähle eine Option', 1),
            ('email_validation', 'Email is not valid', 'de_de', 'Email ist ungültig', 1),
            ('please_enter', 'Please Enter', 'de_de', ' Bitte
            eintreten', 1),
            ('website_validation_text', 'Website URL is not valid', 'de_de', 'Die URL der Website ist ungültig', 1),
            ('selectvalue', 'Select value first', 'de_de', 'Wählen Sie zuerst einen Wert aus', 1),
            ('email', 'Email', 'de_de', 'Email', 1),
            ('enter_email_address', 'Enter email address', 'de_de', 'E-Mail Adresse eingeben', 1),
            ('email_address_not_correct', 'Email address incorrect', 'de_de', 'E-Mail-Adresse falsch', 1),
            ('pls_enter_subject', 'Please Enter Subject', 'de_de', 'Bitte geben Sie einen Betreff ein', 1),
            ('attachFiles', 'Attached File', 'de_de', 'Angehängte Datei', 1),
            ('from', 'From', 'de_de', 'Von', 1),
            ('to', 'To', 'de_de', 'Zu', 1),
            ('call_permission_msg', 'Call permission denied', 'de_de', 'Anruferlaubnis verweigert', 1),
            ('no_records', 'No records found', 'de_de', 'Keine Aufzeichnungen gefunden', 1),
            ('fullform', 'Create New', 'de_de', 'Vollständige Form', 1),
            ('save', 'Save', 'de_de', 'sparen', 1),
            ('total', 'Total', 'de_de', 'Gesamt', 1),
            ('discount', 'Discount', 'de_de', 'Rabatt', 1),
            ('price', 'Price', 'de_de', 'Preis *', 1),
            ('quantity', 'Quantity', 'de_de', 'Menge *', 1),
            ('select_module', 'Select Module', 'de_de', 'Modul
            auswählen', 1),
            ('item_list', 'Item List', 'de_de', 'Artikelliste', 1),
            ('quickcreate', 'Quick Create', 'de_de', 'Schnell erstellen', 1),
            ('overwrite_msg_part1', 'Overwrite the existing address with the selected', 'de_de', 'Überschreiben Sie die vorhandene Adresse mit der ausgewählten', 1),
            ('once_in_every', 'Once in every', 'de_de', 'Einmal in jedem', 1),
            ('overwrite_msg_part2', 'address details?', 'de_de', 'Adressen Details?', 1),
            ('add_item', 'Add Item', 'de_de', 'Artikel
            hinzufügen', 1),
            ('recordsave', 'Record saved successfully', 'de_de', 'Aufzeichnung erfolgreich gespeichert', 1),
            ('recordnotsave', 'Could not save record. Try again later', 'de_de', 'Aufzeichnung nicht speichern', 1),
            ('minutes', 'Minutes', 'de_de', 'Minutes', 1),
            ('hours', 'Hours', 'de_de', 'Std', 1),
            ('days', 'Days', 'de_de', 'Tage', 1),
            ('on', 'On', 'de_de', 'Auf', 1),
            ('day_of_the_month', 'day of the month', 'de_de', 'Tag des Monats', 1),
            ('list_price', 'List Price', 'de_de', ' Listenpreis *', 1),
            ('add_record', 'Add Record', 'de_de', 'Datensatz
            hinzufügen', 1),
            ('add_product', 'Add Product', 'de_de', 'Produkt
            hinzufügen', 1),
            ('add_service', 'Add Service', 'de_de', 'Dienst
            hinzufügen', 1),
            ('discountin', 'Discount in %', 'de_de', 'Rabatt in%', 1),
            ('unitprice', 'Unit price', 'de_de', 'Unit price', 1),
            ('netprice', 'Net price', 'de_de', ' Nettopreis *', 1),
            ('comments', 'Comments', 'de_de', 'Bemerkungen', 1),
            ('add_close', 'Add & Close', 'de_de', 'Hinzufügen &amp; Schließen', 1),
            ('fetching_rout_message', 'Fetching route, Please wait…', 'de_de', 'Route wird abgerufen, bitte warten …', 1),
            ('setting', 'Settings', 'de_de', 'die Einstellungen', 1),
            ('utc', 'UTC', 'de_de', 'koordinierte Weltzeit', 1),
            ('in', 'In', 'de_de', 'Im', 1),
            ('days_ago', 'days ago', 'de_de', 'Vor Tagen', 1),
            ('mins_ago', 'Minutes ago', 'de_de', 'Protokoll ', 1),
            ('justnow', 'Just now', 'de_de', 'Gerade jetzt', 1),
            ('hours_ago', 'hours ago', 'de_de', 'Vor Stunden', 1),
            ('in_1_day', 'In 1 day', 'de_de', 'In 1 Tag', 1),
            ('scanqrcode', 'Card Scanner', 'de_de', 'QR-Kartenscanner', 1),
            ('call_log', 'Call Log', 'de_de', 'Anrufliste', 1),
            ('voice_message', 'Hi', 'de_de', 'Hallo', 1),
            ('voice_message1', 'What can I search for you in', 'de_de', 'Was kann ich für Sie suchen', 1),
            ('live_tracking', 'Live Tracking', 'de_de', 'Live Tracking', 1),
            ('mailmanager', 'Mail Manager', 'de_de', 'Mail-Manager', 1),
            ('my_location', 'My location', 'de_de', 'Mein
            Standort ', 1),
            ('created_on', 'Created On', 'de_de', 'Erstellt am', 1),
            ('modified_on', 'Modified On', 'de_de', 'Geändert am', 1),
            ('enter_comments', 'Enter Comments', 'de_de', 'Geben Sie Kommentare ein', 1),
            ('viewmore', 'View More', 'de_de', 'Mehr sehen ', 1),
            ('viewless', 'View Less', 'de_de', 'Weniger anzeigen', 1),
            ('gotofullform', 'Go to Full Form', 'de_de', 'Gehe zum vollständigen Formular', 1),
            ('post', 'Post', 'de_de', 'Post', 1),
            ('url', 'URL', 'de_de', 'URL', 1),
            ('dialog_title_text_back_color', 'Select a Text Background Color', 'de_de', 'Select a Text Background Color', 1),
            ('event_or_task', 'Add event/task', 'de_de', ' Ereignis / Aufgabe hinzufügen', 1),
            ('shortcut', 'Shortcuts', 'de_de', 'Verknüpfungen', 1),
            ('select_field', 'Select Field', 'de_de', 'Feld auswählen', 1),
            ('share', 'Share', 'de_de', 'Share', 1),
            ('title_insert_link', 'Insert Link', 'de_de', 'Insert Link', 1),
            ('addyourcommentshere', 'Add your comments here', 'de_de', 'Fügen Sie hier Ihre Kommentare hinzu', 1),
            ('nocomment', 'No Comments', 'de_de', 'Keine
            Kommentare', 1),
            ('leads', 'Leads', 'de_de', 'Führt', 1),
            ('true_val', 'true', 'de_de', 'true', 1),
            ('noresult', 'No Result', 'de_de', 'Kein Ergebnis', 1),
            ('version', 'Version', 'de_de', 'Ausführung', 1),
            ('convert_lead', 'Convert Lead', 'de_de', 'Lead konvertieren', 1),
            ('app_name', 'CRMTiger', 'de_de', 'CRMTiger', 1),
            ('enter_url', 'Please Enter url', 'de_de', 'Bitte geben Sie die URL ein', 1),
            ('help', 'Help', 'de_de', 'Hilfe', 1),
            ('contact_us', 'Contact Us', 'de_de', 'Kontaktiere uns', 1),
            ('updates', 'Updates', 'de_de', 'Updates', 1),
            ('logout', 'LogOut', 'de_de', 'Ausloggen', 1),
            ('busnies_cardscanner', 'Business Card Scanner', 'de_de', 'Visitenkartenscanner', 1),
            ('sure_want_logout', 'Are you sure want to logout ?', 'de_de', 'Möchten Sie sich wirklich abmelden?', 1),
            ('logout_message', 'Logout successfully', 'de_de', 'Logout successfully', 1),
            ('all', 'All', 'de_de', 'Alles', 1),
            ('add_event', 'Add event', 'de_de', 'Ereignis hinzufügen', 1),
            ('add_task', 'Add Task', 'de_de', 'Aufgabe hinzufügen ', 1),
            ('next', 'Next', 'de_de', 'Nächster', 1),
            ('login', 'Login', 'de_de', 'Anmeldung', 2),
            ('privacy_policay', 'By logging in, you agree to our Terms and Conditions & Privacy Policy', 'de_de', 'Mit Ihrer Anmeldung stimmen Sie unseren Allgemeinen Geschäftsbedingungen zu &amp; Datenschutz-Bestimmungen', 2),
            ('copyright', 'Copyright © 2020 CRMTiger Version', 'de_de', 'Urheberrechte © \u00A9 2020 CRMTiger \n Ausführung', 2),
            ('enter_username', 'Please enter username', 'de_de', 'Bitte geben sie einen Benutzernamen ein', 2),
            ('enter_password', 'Please enter password', 'de_de', 'Bitte Passwort eingeben', 2),
            ('remanberme', 'Remember Me', 'de_de', 'Erinnere dich an mich', 2),
            ('forgot_password', 'Forgot password?', 'de_de', 'Passwort vergessen?', 2),
            ('privacy_policay1', 'Privacy Policy', 'de_de', 'Datenschutz-Bestimmungen ', 2),
            ('contactsupportmsg', 'Something went wrong. \\n please Click here to contact support.', 'de_de', 'Etwas ist schief gelaufen. \ n Klicken Sie hier, um den Support zu kontaktieren.', 2),
            ('enter_username_password', 'Entered Username or Password is wrong', 'de_de', 'Eingegebener Benutzername oder Passwort ist falsch', 2),
            ('server_issue_occured', 'Server issues occurred', 'de_de', 'Serverprobleme sind aufgetreten', 2),
            ('password', 'Password', 'de_de', 'Passwort', 3),
            ('user_name', 'Username', 'de_de', 'Nutzername', 3),
            ('reset_pwd', 'Reset Password', 'de_de', 'Passwort zurücksetzen', 3),
            ('forgot_password_title', 'Forgot password', 'de_de', 'Passwort vergessen ', 3),
            ('enter_user_name', 'Enter user name', 'de_de', 'Benutzernamen eingeben', 3),
            ('cc', 'Cc', 'de_de', 'Cc', 4),
            ('body', 'Body', 'de_de', 'Karosserie', 4),
            ('bcc', 'BCC', 'de_de', 'BCC', 4),
            ('dialog_title_text_color', 'Select a Text Color', 'de_de', 'Wählen Sie eine Textfarbe', 4),
            ('date', 'Date', 'de_de', 'Datum', 4),
            ('subject', 'Subject', 'de_de', 'Gegenstand', 4),
            ('composeMail', 'Compose Mail', 'de_de', 'Mail schreiben', 4),
            ('send', 'Send', 'de_de', 'Senden', 4),
            ('select_message', 'Select message', 'de_de', 'Nachricht auswählen', 4),
            ('title_insert_table', 'Insert Table', 'de_de', 'Tabelle einfügen', 4),
            ('log_file_sms', 'I agree to Share API Log to Technical team for further troubleshooting', 'de_de', 'Ich bin damit einverstanden, das API-Protokoll an das technische Team zur weiteren Fehlerbehebung weiterzuleiten', 5),
            ('edit_record', 'Edit Records', 'de_de', 'Datensätze
            bearbeiten', 5),
            ('select_time', 'Select Time', 'de_de', 'Zeit auswählen', 5),
            ('edit_item', 'Edit Item', 'de_de', 'Edit Item', 5),
            ('items_total', 'Items Total', 'de_de', 'Items Total', 5),
            ('number_less_then_31', 'Number should be less than 31', 'de_de', 'Number should be less than 31', 5),
            ('users', 'Users', 'de_de', 'Benutzer', 5),
            ('groups', 'Groups', 'de_de', 'Gruppen', 5),
            ('txt_note_for_file', 'Note : Existing attachments(images/files) will be replaced', 'de_de', 'Hinweis: Vorhandene Anhänge (Bilder / Dateien) werden ersetzt', 5),
            ('greaterdatetime', 'End DateTime should be greater than Start DateTime', 'de_de', '<![CDATA[End Date & Time should be greater than Start Date & Time]]>', 5),
            ('until', 'Until', 'de_de', 'Bis um', 5),
            ('organizations', 'Organizations', 'de_de', 'Organisationen', 6),
            ('contacts', 'Contacts', 'de_de', 'Kontakte', 6),
            ('opportunity', 'Opportunity', 'de_de', 'Gelegenheit', 6),
            ('lbl_sun', 'SUN', 'de_de', 'SONNE', 7),
            ('lbl_mon', 'MON', 'de_de', 'MON', 7),
            ('lbl_tue', 'TUE', 'de_de', 'DI', 7),
            ('lbl_wed', 'WED', 'de_de', 'HEIRATEN', 7),
            ('lbl_thu', 'THU', 'de_de', 'DO', 7),
            ('lbl_fri', 'FRI', 'de_de', 'FRI', 7),
            ('lbl_sat', 'SAT', 'de_de', 'SAT', 7),
            ('lbl_1', '1', 'de_de', '1', 7),
            ('lbl_2', '2', 'de_de', '2', 7),
            ('lbl_3', '3', 'de_de', '3', 7),
            ('lbl_4', '4', 'de_de', '4', 7),
            ('lbl_5', '5', 'de_de', '5', 7),
            ('lbl_6', '6', 'de_de', '6', 7),
            ('lbl_7', '7', 'de_de', '7', 7),
            ('lbl_8', '8', 'de_de', '8', 7),
            ('lbl_9', '9', 'de_de', '9', 7),
            ('lbl_10', '10', 'de_de', '10', 7),
            ('lbl_11', '11', 'de_de', '11', 7),
            ('lbl_12', '12', 'de_de', '12', 7),
            ('lbl_13', '13', 'de_de', '13', 7),
            ('lbl_14', '14', 'de_de', '14', 7),
            ('lbl_15', '15', 'de_de', '15', 7),
            ('lbl_16', '16', 'de_de', '16', 7),
            ('lbl_17', '17', 'de_de', '17', 7),
            ('lbl_18', '18', 'de_de', '18', 7),
            ('lbl_19', '19', 'de_de', '19', 7),
            ('lbl_20', '20', 'de_de', '20', 7),
            ('lbl_21', '21', 'de_de', '21', 7),
            ('lbl_22', '22', 'de_de', '22', 7),
            ('lbl_23', '23', 'de_de', '23', 7),
            ('lbl_24', '24', 'de_de', '24', 7),
            ('lbl_25', '25', 'de_de', '25', 7),
            ('lbl_26', '26', 'de_de', '26', 7),
            ('lbl_27', '27', 'de_de', '27', 7),
            ('lbl_28', '28', 'de_de', '28', 7),
            ('lbl_29', '29', 'de_de', '29', 7),
            ('lbl_30', '30', 'de_de', '30', 7),
            ('lbl_31', '31', 'de_de', '31', 7),
            ('lbl_32', '32', 'de_de', '32', 7),
            ('lbl_33', '33', 'de_de', '33', 7),
            ('lbl_34', '34', 'de_de', '34', 7),
            ('lbl_35', '35', 'de_de', '35', 7),
            ('lbl_36', '36', 'de_de', '36', 7),
            ('lbl_37', '37', 'de_de', '37', 7),
            ('lbl_38', '38', 'de_de', '38', 7),
            ('lbl_39', '39', 'de_de', '39', 7),
            ('lbl_40', '40', 'de_de', '40', 7),
            ('lbl_41', '41', 'de_de', '41', 7),
            ('lbl_42', '42', 'de_de', '42', 7),
            ('current_date', 'current date', 'de_de', 'aktuelles Datum', 7),
            ('event', 'Events', 'de_de', 'Veranstaltungen', 7),
            ('calendar', 'Calendar', 'de_de', 'Kalender', 7),
            ('latest_version', 'Latest Version :', 'de_de', 'Letzte Version :', 8),
            ('expire_on', 'Expire On :', 'de_de', 'Verfällt am :', 8),
            ('ctmobile_ext_version', 'CTMobile Ext. Version :', 'de_de', 'CTMobile ext. Ausführung :', 8),
            ('you_have_latest_version', 'You already have latest version', 'de_de', 'Sie haben die Version aktualisiert', 8),
            ('latest_version1', 'You Already have latest version', 'de_de', 'Sie haben bereits die neueste Version', 8),
            ('upgreaded', 'Upgrade', 'de_de', 'Aktualisierung', 8),
            ('downgrade', 'Downgrade', 'de_de', 'Downgrade', 8),
            ('dialog_recent_event_info', 'You can set from here how many number of records you want to show on Home screen for Recent Event.', 'de_de', 'Hier können Sie festlegen, wie viele Datensätze auf dem Startbildschirm für das letzte Ereignis angezeigt werden sollen.', 8),
            ('dialog_feedback_info', 'You can submit your feedback with description , our team will check your feedback and get back to you.', 'de_de', 'Sie können Ihr Feedback mit einer Beschreibung einreichen. Unser Team prüft Ihr Feedback und meldet sich bei Ihnen.', 8),
            ('dialog_log_info', 'Log functionality is used for customer support / help , If you are facing any issues in app or any module or functionality is not working proper then you can enable share log with our development team.', 'de_de', 'Die Protokollfunktion wird für die Kundenunterstützung / -hilfe verwendet. Wenn Probleme in der App auftreten oder ein Modul oder eine Funktion nicht ordnungsgemäß funktioniert, können Sie die Freigabe des Protokolls für unser Entwicklungsteam aktivieren.', 8),
            ('info', 'Info', 'de_de', 'Info', 8),
            ('recent_history', 'Recent History', 'de_de', 'Jüngste Geschichte ', 8),
            ('recent_feedback', 'Feedback', 'de_de', 'Feedback', 8),
            ('recent_log', 'Log', 'de_de', 'Log', 8),
            ('crmtiger_app_version', 'CRMTiger App Version :', 'de_de', 'CRMTiger App Version:', 8),
            ('historylimit', 'Recent History Limit', 'de_de', ' Jüngste
            Historienbegrenzung', 8),
            ('radious_in_miles', 'radious_in_miles', 'de_de', 'Radius
            in
            Meilen', 8),
            ('recentlimit', 'Recent Event Limit', 'de_de', 'Letzte
            Ereignisbegrenzung', 8),
            ('upcoming_events', 'Upcoming Events', 'de_de', 'Kommende Veranstaltungen', 8),
            ('rate_our_app', 'Rate Our App!', 'de_de', 'Bewerten Sie unsere App!', 8),
            ('feedback', 'Submit Feedback', 'de_de', 'Feedback senden', 8),
            ('sendfeedback', 'Feedback Send', 'de_de', 'Feedback Send', 8),
            ('emaillimit', 'Email limit', 'de_de', 'E-Mail-Limit', 8),
            ('log', 'Log', 'de_de', 'Log', 8),
            ('logclear', 'Log cleared successfully.', 'de_de', 'Klar erfolgreich', 8),
            ('dialog_recent_history_info', 'You can set from here how many number of records you want to show on Home screen for Recent History.', 'de_de', 'Hier können Sie festlegen, wie viele Datensätze im Startbildschirm für den Verlauf der letzten Zeit angezeigt werden sollen', 8),
            ('proceed_to_upgrade1', 'Proceed to', 'de_de', 'Weiter zu', 8),
            ('upgradation_message', 'will required logout and login again later.', 'de_de', ' muss abgemeldet und später erneut angemeldet werden.', 8),
            ('proceed_to_upgrade', 'Proceed to Upgrade', 'de_de', 'Fahren Sie mit dem Upgrade fort', 8),
            ('module_setting', 'Module Setting', 'de_de', 'Moduleinstellung', 9),
            ('sortbyfield', 'Sort by field', 'de_de', 'Nach Feld sortieren', 9),
            ('ascending', 'Ascending  A to Z', 'de_de', 'Aufsteigend von A bis Z.', 9),
            ('descending', 'Descending  Z to A', 'de_de', 'Absteigend von Z nach A', 9),
            ('first_field', 'First Field', 'de_de', 'Erstes Feld', 9),
            ('second_field', 'Second Field', 'de_de', 'Zweites Feld', 9),
            ('third_field', 'Third Field', 'de_de', 'Drittes Feld ', 9),
            ('sure_want_restore', 'Are you sure you want to reset to default settings?', 'de_de', 'Möchten Sie die Standardeinstellungen wirklich wiederherstellen?', 9),
            ('orderlist', 'List Order', 'de_de', 'Liste bestellen', 9),
            ('module_reset', 'Restore to Default', 'de_de', 'Zurück zu Werkeinstellungen', 9),
            ('display_fields', 'Display Fields', 'de_de', 'Anzeigefelder', 9),
            ('discount_lessthen_100', 'Discount % should be less than 100', 'de_de', 'Rabatt% sollte weniger als 100 sein', 10),
            ('select_item', 'Select Item', 'de_de', 'Menüpunkt
            wählen', 10),
            ('item_comment', 'Item Comment', 'de_de', 'Artikelkommentar', 10),
            ('record_name', 'Record Name is :', 'de_de', 'Der Name des Datensatzes lautet: -', 11),
            ('go_back', 'Go Back', 'de_de', 'Go Back', 11),
            ('please_enter_shortcut_name', 'Please Enter Shortcut Name', 'de_de', 'Bitte geben Sie den Namen der Verknüpfung ein', 11),
            ('number_not_found', 'Contact Number not found', 'de_de', 'Kontaktnummer nicht gefunden', 11),
            ('mail_not_found', 'Mail Address not found', 'de_de', 'Mail-Adresse nicht gefunden ', 11),
            ('create_shortcut', 'Create Shortcut', 'de_de', 'Verknüpfung erstellen', 11),
            ('contact_summary', 'Summary', 'de_de', 'Summary', 11),
            ('activites', 'Activities', 'de_de', 'Aktivitäten', 11),
            ('details', 'Details', 'de_de', 'Details', 11),
            ('related', 'Related', 'de_de', 'Related', 11),
            ('share_link', 'Share record with', 'de_de', 'Rekord teilen mit', 11),
            ('edit', 'Edit', 'de_de', 'Edit', 11),
            ('duplicate', 'Duplicate', 'de_de', 'Duplicate', 11),
            ('whatsapp', 'Whatsapp', 'de_de', 'Whatsapp', 11),
            ('call', 'Call', 'de_de', 'Call', 11),
            ('choose_contact_for_call', 'Choose Contact for Call', 'de_de', 'Choose Contact for Call', 11),
            ('choose_contact_for_sms', 'Choose Contact for SMS', 'de_de', 'Choose Contact for SMS', 11),
            ('choose_contact_for_whatsapp', 'Choose Contact for WhatsApp', 'de_de', 'Choose Contact for WhatsApp', 11),
            ('chosse_contact_for_email', 'Choose Email', 'de_de', 'Choose Email', 11),
            ('attach_file', 'Attach Files', 'de_de', 'Attach Files', 11),
            ('close', 'Close', 'de_de', 'Close', 11),
            ('status', 'Status', 'de_de', 'Status', 11),
            ('stop', 'Stop', 'de_de', 'Halt', 11),
            ('zero', '0', 'de_de', '0', 11),
            ('record', 'Record', 'de_de', 'Aufzeichnung', 11),
            ('voice_note', 'Voice Note', 'de_de', 'Sprachnotiz', 11),
            ('tickets', 'Tickets', 'de_de', 'Tickets', 12),
            ('check_out', 'Check Out', 'de_de', 'Auschecken', 12),
            ('check_in', 'Check In', 'de_de', 'Check-In', 12),
            ('select_any', 'Select any', 'de_de', 'Wählen', 12),
            ('fulldetails', 'Show Full Details', 'de_de', 'Vollständige Details anzeigen', 12),
            ('checkin', 'Check-in', 'de_de', 'Check-In', 12),
            ('navigate', 'Navigate', 'de_de', 'Navigieren', 12),
            ('product', 'Products', 'de_de', 'Produkte', 12),
            ('projectMilestone', 'Project Milestone', 'de_de', 'Meilenstein des Projekts', 12),
            ('projecttask', 'Project Tasks', 'de_de', 'Projektaufgabe', 12),
            ('nearby', 'NearBy', 'de_de', 'In der Nähe', 13),
            ('document', 'Document', 'de_de', 'Dokumentieren', 14),
            ('reply', 'Reply', 'de_de', 'Antworten', 14),
            ('reply_all', 'Reply All', 'de_de', 'Allen antworten', 14),
            ('forward', 'Forward', 'de_de', 'Nach vorne', 14),
            ('action', 'Action', 'de_de', 'Aktion', 14),
            ('select_first', 'Select First', 'de_de', 'Wählen Sie zuerst', 14),
            ('commentaddsuccessful', 'Comment added successfull', 'de_de', 'Kommentar hinzufügen Erfolgreich', 14),
            ('move_to', 'Move to', 'de_de', 'Ziehen nach', 14),
            ('attach', 'Attach', 'de_de', 'Anfügen', 14),
            ('addcoment', 'Add Comment', 'de_de', 'Einen Kommentar hinzufügen', 14),
            ('adddocument', 'Add Document', 'de_de', 'Dokument hinzufügen', 14),
            ('home', 'Home', 'de_de', 'Zuhause', 15),
            ('checkout', 'Check-out', 'de_de', 'Auschecken', 15),
            ('message_search', 'Search by name', 'de_de', 'Suche mit Name', 15),
            ('start_shift', 'Start shift', 'de_de', 'Schicht
            starten', 15),
            ('end_shift', 'End shift', 'de_de', 'Schicht
            beenden', 15),
            ('today_meeting', 'Meetings', 'de_de', 'Besprechungen', 15),
            ('shift_time_track', 'Shift Time Track', 'de_de', 'Zeitspur
            verschieben', 15),
            ('logout_msg', 'You have to login again , click', 'de_de', 'You have to login again , click', 15),
            ('logout_msg1', 'to continue.', 'de_de', 'to continue.', 15),
            ('permission_denied', 'You don\'t have permission to create', 'de_de', 'Sie haben keine Berechtigung zum Erstellen', 15),
            ('history', 'Activity stream', 'de_de', 'Aktivitätsanzeige', 15),
            ('search_value', 'Search value :', 'de_de', 'Suchwert: -', 15),
            ('feed_back_msg', 'Please enter feedback message', 'de_de', 'Bitte geben Sie eine Rückmeldung ein', 16),
            ('feed_back_hint_msg', 'Enter feedback message', 'de_de', 'Geben Sie eine Rückmeldung ein', 16),
            ('submit', 'Submit', 'de_de', 'einreichen', 16),
            ('check_app_not_installed', 'Application is not currently installed.', 'de_de', 'Die Anwendung ist derzeit nicht installiert.', 17),
            ('send_sms_fail_message', 'SMS failed, please try again later!', 'de_de', 'SMS fehlgeschlagen, bitte versuchen Sie es später noch einmal!', 17),
            ('documentaddsuccessfully', 'Document Attach successfully', 'de_de', 'Dokument erfolgreich anhängen', 17),
            ('send_message', 'Send message', 'de_de', 'Nachricht senden', 17),
            ('sms_to', 'smsto:', 'de_de', 'smsto:', 17),
            ('add_list_message', 'Add List', 'de_de', 'Liste hinzufügen', 18),
            ('mylist', 'My List', 'de_de', 'Meine
            Liste', 18),
            ('filtername', 'Filter Name', 'de_de', 'Filtername', 18),
            ('selectlist', 'Select a List', 'de_de', 'Wählen Sie eine Liste *', 18),
            ('assingedto', 'Assigned To', 'de_de', 'Zugewiesen an *', 18),
            ('selectmodule', 'Select a module', 'de_de', 'Wählen Sie ein Modul aus', 18),
            ('add_list', 'Add Filter', 'de_de', 'Filter
            hinzufügen', 18),
            ('recent_event', 'Recent Event', 'de_de', 'Aktuelles Ereignis', 19),
            ('recent_hostory', 'Recent History', 'de_de', 'Jüngste Geschichte', 19),
            ('module_specific_settings', 'Module-Specific Settings', 'de_de', 'Modulspezifische Einstellungen', 19),
            ('talk_to_us', 'Talk to us', 'de_de', 'Rede mit uns', 19),
            ('report_a_bug', 'Report A Bug', 'de_de', 'Melde einen technischen Fehler ', 19),
            ('faq', 'FAQ', 'de_de', 'FAQ', 19),
            ('selectmodules', 'Select Module', 'de_de', 'Modul auswählen ', 19),
            ('myplan', 'My Plan', 'de_de', 'Mein Plan', 19),
            ('message', 'Message', 'de_de', 'Botschaft', 20),
            ('message_validation', 'Please enter Message', 'de_de', 'Bitte geben Sie eine Nachricht ein', 20),
            ('contact_select', 'Please Select contact', 'de_de', 'Bitte Kontakt auswählen', 20),
            ('global_search', 'Global Search', 'de_de', 'Globale Suche', 21),
            ('records', 'Records', 'de_de', 'Aufzeichnungen', 21),
            ('dont_show_again', 'Don\'t Show Again', 'de_de', 'Nicht mehr anzeigen', 22),
            ('skip', 'Skip', 'de_de', 'Überspringen >', 22),
            ('file_downloading', 'File Downloading', 'de_de', 'Herunterladen von Dateien', 23),
            ('add_screenshots_optional', 'Add screenshots (optional)', 'de_de', 'Screenshots hinzufügen (optional)', 24),
            ('describe_your_problem', 'Describe your problem', 'de_de', 'Beschreiben Sie Ihr Problem', 24),
            ('default_filter_shortcut', 'Default Filter Shortcut', 'de_de', 'Standardfilter-Verknüpfung', 25),
            ('record_shortcut', 'Record Shortcut', 'de_de', 'default_filter_shortcut', 25),
            ('enter_url', 'Please Enter url', 'de_de', 'Please Enter url', 26),
            ('new_version_is_avaiable', 'You need to update the app to continue using Please update to continue Older versions will no longer work from today', 'de_de', 'Sie müssen die App aktualisieren, um fortzufahren. Bitte aktualisieren, um fortzufahren. Ältere Versionen funktionieren ab heute nicht mehr', 26),
            ('search_by', 'Search by', 'de_de', 'Suche nach ', 27),
            ('selected_filter', 'Selected filter :', 'de_de', 'Ausgewählter Filter: -', 27),
            ('selected_field', 'Selected field :', 'de_de', 'Ausgewähltes Feld: -', 27),
            ('choose', 'Choose', 'de_de', 'alemana', 28),
            ('qr_cardscanner', 'QR Code Scanner', 'de_de', 'QR-Code-Scanner', 28),
            ('error_message_for_scan', 'Could not read the card Try again later.', 'de_de', 'Die Karte konnte nicht gelesen werden. Versuchen Sie es später erneut.', 28),
            ('press_start_scan', 'Press to Start Scan', 'de_de', 'Drücken Sie, um den Scan zu starten', 28),
            ('line_item_quntity_validation_msg', 'Value should be greater than zero', 'de_de', 'Value should be greater than zero', 29),
            ('percentage_msg', 'Percentage should be less than 100', 'de_de', 'Percentage should be less than 100', 29),
            ('MSG_NO_DATA', 'No data found!', 'de_de', 'No data found!', 29),
            ('MSG_SOMETHING_WRONG', 'Something went wrong!', 'de_de', 'Something went wrong!', 29),
            ('MSG_COMING_SOON', 'Coming Soon!', 'de_de', 'Coming Soon!', 29),
            ('MSG_UPLOAD_PROFILE_IMAGE', 'Please upload profile image.', 'de_de', 'Please upload profile image.', 29),
            ('ALERT_TITLE_LOCATION_ACCESS', 'Location Access', 'de_de', 'Location Access', 29),
            ('ALERT_MSG_LOCATION_ACCESS', 'Requires your location to show nearby events.', 'de_de', 'Requires your location to show nearby events.', 29),
            ('ALERT_BTN_ALLOW', 'ALLOW', 'de_de', 'ALLOW', 29),
            ('ALERT_BTN_DENY', 'DENY', 'de_de', 'DENY', 29),
            ('ALERT_MSG_LOCATION_SETTING', 'Not able to fetch your current location. Please check your location settings.', 'de_de', 'Not able to fetch your current location. Please check your location settings.', 29),
            ('DELETE_RECORD', 'Delete Record', 'de_de', 'Delete Record', 29),
            ('ALERT_MSG_DELETE_SHORTCUT', 'Are you sure want to delete this shortcut?', 'de_de', 'Are you sure want to delete this shortcut?', 29),
            ('DELETE_SHORTCUT', 'Delete Shortcut', 'de_de', 'Delete Shortcut', 29),
            ('LBL_TERMS', 'By logging in, you agree to our Terms and', 'de_de', 'By logging in, you agree to our Terms and', 29),
            ('LBL_CONDITIONS', 'Conditions &', 'de_de', 'Conditions &', 29),
            ('ALERT_TITLE', 'Alert', 'de_de', 'Alert', 29),
            ('ALERT_BTN_SUBSCRIBE', 'Subscribe', 'de_de', 'Subscribe', 29),
            ('MSG_SELECT_MODULE', 'Please select any Module', 'de_de', 'Please select any Module', 29),
            ('MSG_SELECT_LIST', 'Please select any List', 'de_de', 'Please select any List', 29),
            ('ALERT_MSG_DONT_HAVE_CAMERA', 'You don\'t have camera', 'de_de', 'You don\'t have camera', 29),
            ('ALERT_MSG_GALLARY_PERMISSION', 'You don\'t have permission to access gallery.', 'de_de', 'You don\'t have permission to access gallery.', 29),
            ('ALERT_MSG_CAMERA_PERMISSION', 'You don\'t have permission to access camera. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Camera on', 'de_de', 'You don\'t have permission to access camera. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Camera on', 29),
            ('ALERT_MSG_SPEECH_PERMISSION', 'You don\'t have permission to access Speech Recognition. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Speech Recognition on', 'de_de', 'You don\'t have permission to access Speech Recognition. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Speech Recognition on', 29),
            ('BTN_DONE', 'Done', 'de_de', 'Done', 29),
            ('COMMENT', 'Comment', 'de_de', 'Comment', 29),
            ('FULL_FORM', 'Full Form', 'de_de', 'Full Form', 29),
            ('QUICK_CREATE', 'Create', 'de_de', 'Create', 29),
            ('LBL_SELECT_FIELDS', 'Select Fields', 'de_de', 'Select Fields', 29),
            ('LBL_SELECT_FIELDS', 'Select Fields', 'de_de', 'Select Fields', 29),
            ('LBL_SELECT_FIRST_FIELDS', 'Select First Field', 'de_de', 'Select First Field', 29),
            ('LBL_SELECT_SECOND_FIELDS', 'Select Second Field', 'de_de', 'Select Second Field', 29),
            ('LBL_SELECT_THIRD_FIELDS', 'Select Third Field', 'de_de', 'Select Third Field', 29),
            ('LBL_SORT_BY_FIELD', 'Select Sort By Field', 'de_de', 'Select Sort By Field', 29),
            ('BTN_RESET_TO_DEFAULT', 'Reset to Default', 'de_de', 'Reset to Default', 29),
            ('MSG_SELECT_SORT_BY_FIELD', 'Select Sort by field', 'de_de', 'Select Sort by field', 29),
            ('kStrClearBtnTitle', 'Clear', 'de_de', 'Clear', 29),
            ('kStrShowMoreBtnTitle', 'Show More', 'de_de', 'Show More', 29),
            ('kStrAddActivitiesBtnTitle', 'Add Activities', 'de_de', 'Add Activities', 29),
            ('kStrAddCommentPlaceHolder', 'Add your comments here', 'de_de', 'Add your comments here', 29),
            ('MSG_ENTER_TO_EMAIL', 'Please enter to field.', 'de_de', 'Please enter to field.', 29),
            ('WARNING_FILE', 'File can\'t open.', 'de_de', 'File can\'t open.', 29),
            ('MSG_FILE_SAVED', 'File saved.', 'de_de', 'File saved.', 29),
            ('WARNING_DOWNLOAD_FAIL', 'Download fail!, please try after sometime.', 'de_de', 'Download fail!, please try after sometime.', 29),
            ('LBL_SHORTCUT', 'Shortcut', 'de_de', 'Shortcut', 29),
            ('TXT_MESSAGE_PLACEHOLDER', 'Type Message', 'de_de', 'Type Message', 29),
            ('ALERT_INSTALL_WHATSAPP', 'Install Whatsapp', 'de_de', 'Install Whatsapp', 29),
            ('MSG_NO_MAIL_BOX', 'No MailBox found. Please Create Mailbox', 'de_de', 'No MailBox found. Please Create Mailbox', 29),
            ('LBL_WROTE', 'Wrote', 'de_de', 'Wrote', 29),
            ('MSG_MAIL_SEND', 'Mail sent', 'de_de', 'Mail sent', 29),
            ('log_file_not_found', 'API Log file not found.', 'de_de', 'API Log file not found.', 29),
            ('unknown_error', 'An unknown error occurred, try again', 'de_de', 'An unknown error occurred, try again', 29),
            ('CTMTigerAppVersion', 'CRMTiger App Version', 'de_de', 'CRMTiger App Version', 29),
            ('CTMMobileUpdateMsg', 'CTMobile Ext. Version Update Successfully', 'de_de', 'CTMobile Ext. Version Update Successfully', 29),
            ('dialog_Premium_downgrade', 'Downgrade will required logout and login again later', 'de_de', 'Downgrade will required logout and login again later', 29),
            ('dialog_Premium', 'Upgrade will required logout and login again later', 'de_de', 'Upgrade will required logout and login again later', 29),
            ('Overwrite', 'Overwrite', 'de_de', 'Overwrite', 29),
            ('MSGAddressOverwrite1', 'Overwrite the existing address with the selected', 'de_de', 'Overwrite the existing address with the selected', 29),
            ('MSGAddressOverwrite2', 'address details?', 'de_de', 'address details?', 29),
            ('UPGRADE_PLAN', 'Upgrade Plan', 'de_de', 'Upgrade Plan', 29),
            ('DOWNGRADE_PLAN', 'Downgrade Plan', 'de_de', 'Downgrade Plan', 29),
            ('UPGRADE_EXTENSION', 'Upgrade Extension', 'de_de', 'Upgrade Extension', 29),
            ('UPGRADE_APP', 'Upgrade App', 'de_de', 'Upgrade App', 29),
            ('SELECT_OPTION', 'Select Option', 'de_de', 'Select Option', 29),
            ('PLEASE_SELECT', 'Please select', 'de_de', 'Please select', 29),
            ('MSG_ACCESS_DENIED', 'You don\'t have permission for this module.', 'de_de', 'You don\'t have permission for this module.', 29),
            ('MSG_SELECT_RECCURING_MONTH_DAY', 'Please select reccuring day of month.', 'de_de', 'Please select reccuring day of month.', 29),
            ('MSG_SELECT_RECCURING_WEEK_DAY', 'Please select reccuring day of week.', 'de_de', 'Please select reccuring day of week.', 29),
            ('MSG_SELECT_RECCURING_DAYS', 'Please select reccuring days.', 'de_de', 'Please select reccuring days.', 29),
            ('Please select reccuring days.', 'Please select reccuring days.', 'de_de', 'Please select reccuring days.', 29),
            ('MSG_SELECT_RECCURING_END_DATE', 'Please select reccuring end date.', 'de_de', 'Please select reccuring end date.', 29),
            ('MSG_SELECT_RECCURING_TYPE', 'Please select reccuring type.', 'de_de', 'Please select reccuring type.', 29),
            ('FREQ_TIME', 'Times', 'de_de', 'Times', 29),
            ('REPEAT_YEARLY', 'Repeat Yearly', 'de_de', 'Repeat Yearly', 29),
            ('REPEAT_MONTHLY', 'Repeat Monthly', 'de_de', 'Repeat Monthly', 29),
            ('REPEAT_WEEKLY', 'Repeat Weekly', 'de_de', 'Repeat Weekly', 29),
            ('REPEAT_DAILY', 'Repeat Daily', 'de_de', 'Repeat Daily', 29),
            ('ACTION_TITLE', 'Action Title', 'de_de', 'Action Title', 29),
            ('MSG_SELECT_VALID_DATE', 'Please select valid day of month.', 'de_de', 'Please select valid day of month.', 29),
            ('MSG_SELECT_VALID_START_DATE', 'Start date should be less than end date.', 'de_de', 'Start date should be less than end date.', 29),
            ('MSG_SELECT_VALID_START_TIME', 'Start time should be less than end time.', 'de_de', 'Start time should be less than end time.', 29),
            ('LBL_LINEITEM_DETAILS', 'Lineitem Details', 'de_de', 'Lineitem Details', 29),
            ('MSG_INVALIDE_DISCOUNT_AMOUNT', 'Discount amount should be less than the total.', 'de_de', 'Discount amount should be less than the total.', 29),
            ('VIEW', 'View', 'de_de', 'View', 29),
            ('MSG_ENTER_VALID', 'Please enter valid', 'de_de', 'Please enter valid', 29),
            ('MSG_ENTER_PERCENTAGE', 'Percentage should be less than 100.', 'de_de', 'Percentage should be less than 100.', 29),
            ('ITEM_TOTAL', 'Item Total', 'de_de', 'Item Total', 29),
            ('ADJUSTMENT', 'Adjustment', 'de_de', 'Adjustment', 29),
            ('TITLE_CHOOSE_IMAGE', 'Choose Image', 'de_de', 'Choose Image', 29),
            ('COMPRESS', 'Compress', 'de_de', 'Compress', 29),
            ('CHOOSE_ANOTHER_IMAGE', 'Your image size is too large, please select another image', 'de_de', 'Your image size is too large, please select another image', 29),
            ('OnDayOfMonth', 'On day of month', 'de_de', 'On day of month', 29),
            ('OnDayOfWeek', 'On day of week', 'de_de', 'On day of week', 29),
            ('AddAndClose', 'Add & Close', 'de_de', 'Add & Close', 29),
            ('Repeat', 'Repeat', 'de_de', 'Repeat', 29),
            ('OnDay', 'On day', 'de_de', 'On day', 29),
            ('View_Line_Item', 'View Line Item', 'de_de', 'View Line Item', 29),
            ('TITLE_IMAGE', 'Image', 'de_de', 'Image', 29),
            ('TITLE_ICLOUD', 'iCloud', 'de_de', 'iCloud', 29),
            ('GOOGLE', 'Google', 'de_de', 'Google', 29),
            ('ALERT_BTN_OKAY', 'Okay', 'de_de', 'Okay', 29),
            ('ALERT_TITLE_ACCESS_DENIED', 'Access Denied', 'de_de', 'Access Denied', 29),
            ('Dont_Show_Again', 'Don\'t show again', 'de_de', 'Don\'t show again', 29),
            ('Skip', 'Skip', 'de_de', 'Skip', 29),
            ('Fillter_Name', 'Fillter Name', 'de_de', 'Fillter Name', 29),
            ('Fillter_Record_Count', 'Fillter Record Count', 'de_de', 'Fillter Record Count', 29);",array());
        }
    }

    /*static function es_es(){
         global $adb;
        $checkQuery = "SELECT * FROM ctmobile_language_keyword WHERE keyword_lang = ?";
        $checkResult = $adb->pquery($checkQuery,array('es_es'));
        if($adb->num_rows($checkResult) == 0){
            $adb->pquery("",array());
        }
    }*/

    /*static function zh_cn(){
         global $adb;
        $checkQuery = "SELECT * FROM ctmobile_language_keyword WHERE keyword_lang = ?";
        $checkResult = $adb->pquery($checkQuery,array('zh_cn'));
        if($adb->num_rows($checkResult) == 0){
            $adb->pquery("",array());
        }
    }*/

    static function it_it(){
         global $adb;
        $checkQuery = "SELECT * FROM ctmobile_language_keyword WHERE keyword_lang = ?";
        $checkResult = $adb->pquery($checkQuery,array('it_it'));
        if($adb->num_rows($checkResult) == 0){
            $adb->pquery("INSERT INTO `ctmobile_language_keyword` (`keyword`, `keyword_name`, `keyword_lang`, `language_keyword`, `sectionid`) VALUES
                ('network_error', 'Network connection error!', 'it_it', 'Errore di rete!', 1),
                ('connection_check', 'Could not connect to CRM, Please check your Internet connection.', 'it_it', 'Per favore controlla la tua connessione Internet.', 1),
                ('update', 'Update', 'it_it', 'Aggiornare', 1),
                ('cancel', 'Cancel', 'it_it', 'Cancel', 1),
                ('ok', 'Ok', 'it_it', 'ok', 1),
                ('more_information', 'Click here for more information.', 'it_it', 'Clicca qui per maggiori informazioni.', 1),
                ('yes', 'Yes', 'it_it', 'sì', 1),
                ('no', 'No', 'it_it', 'No', 1),
                ('click_again_exit', 'Click again to exit', 'it_it', 'Clicca di nuovo per uscire', 1),
                ('forpermission', 'You don\'t have permission to view this feature. Please subscribe for Premium version Click here to Subscribe.', 'it_it', 'Non hai il permesso di vedere questa funzione. Si prega di iscriversi per la versione Premium Clicca qui per iscriverti.', 1),
                ('clickhere', 'Click here', 'it_it', 'Clicca qui', 1),
                ('clickhere_subscribe', 'Click here to subscribe premium version', 'it_it', 'Clicca qui per iscriverti', 1),
                ('clickhere_configure', 'Click here and view how to Configure.', 'it_it', 'Clicca qui e vedi come configurare.', 1),
                ('please_wait', 'Please Wait…', 'it_it', 'Attendere prego…', 1),
                ('share__msg', 'Share file with', 'it_it', 'condividi file con', 1),
                ('dialog_camera', 'Camera', 'it_it', 'telecamera', 1),
                ('dialog_add_file_by', 'Take Photo from', 'it_it', 'Aggiungi file per', 1),
                ('add', 'Add', 'it_it', 'Inserisci', 1),
                ('mail_manager_configured', 'Mail Manager is not configured', 'it_it', 'Mail Manager non è configurato', 1),
                ('dialog_add_files_by', 'Add Files by', 'it_it', 'Aggiungi file per', 1),
                ('dialog_drive', 'Drive', 'it_it', 'Guidare', 1),
                ('dialog_drop_box', 'Drop Box', 'it_it', 'Drop Box', 1),
                ('dialog_need_signin', 'You need to Sign-in to your Drive account first.', 'it_it', 'Devi prima effettuare l\'accesso', 1),
                ('dialog_gallery', 'Gallery', 'it_it', 'Galleria', 1),
                ('delete', 'Delete', 'it_it', 'Elimina', 1),
                ('timeoutmessage', 'Oops! Request is taking more time than expected.', 'it_it', 'La richiesta richiede più tempo del previsto.', 1),
                ('gps_location_message', 'GPS is not enabled. Please turn it on to get your near by locations.', 'it_it', 'Il GPS non è abilitato. Si prega di accenderlo per ottenere il tuo vicino da posizioni.', 1),
                ('sure_want_delete', 'Are you sure want to delete ?', 'it_it', 'Sei sicuro di voler cancellare?', 1),
                ('select', 'Select', 'it_it', 'Selezionare', 1),
                ('msgforrecordaudio', 'Minimum record duration one second.', 'it_it', 'Durata minima del record un secondo.', 1),
                ('permission_storage', 'Permission denied to read your External storage', 'it_it', 'Autorizzazione negata per leggere la memoria esterna', 1),
                ('send_permission_msg', 'Send message permission denied', 'it_it', 'Permesso negato per invio messaggio', 1),
                ('choosefile', 'Choose File', 'it_it', 'Scegli il file', 1),
                ('enter', 'Enter', 'it_it', 'accedere', 1),
                ('select_an_option', 'Select an Option', 'it_it', 'Seleziona un\'opzione', 1),
                ('email_validation', 'Email is not valid', 'it_it', 'L\'email non è valida', 1),
                ('please_enter', 'Please Enter', 'it_it', 'Prego entra', 1),
                ('website_validation_text', 'Website URL is not valid', 'it_it', 'L\'URL del sito web non è valido', 1),
                ('selectvalue', 'Select value first', 'it_it', 'Seleziona prima il valore', 1),
                ('email', 'Email', 'it_it', 'E-mail', 1),
                ('enter_email_address', 'Enter email address', 'it_it', 'Inserisci l\'indirizzo email', 1),
                ('email_address_not_correct', 'Email address incorrect', 'it_it', 'Indirizzo email errato', 1),
                ('pls_enter_subject', 'Please Enter Subject', 'it_it', 'Per favore, inserisci l\'oggetto', 1),
                ('attachFiles', 'Attached File', 'it_it', 'File allegato', 1),
                ('from', 'From', 'it_it', 'A partire dal', 1),
                ('to', 'To', 'it_it', 'A', 1),
                ('call_permission_msg', 'Call permission denied', 'it_it', 'Permesso negato per la chiamata', 1),
                ('no_records', 'No records found', 'it_it', 'Nessun record trovato', 1),
                ('fullform', 'Create New', 'it_it', 'Modulo completo', 1),
                ('save', 'Save', 'it_it', 'Salvare', 1),
                ('total', 'Total', 'it_it', 'Totale', 1),
                ('discount', 'Discount', 'it_it', 'Sconto', 1),
                ('price', 'Price', 'it_it', 'Prezzo *', 1),
                ('quantity', 'Quantity', 'it_it', 'Quantità *', 1),
                ('select_module', 'Select Module', 'it_it', 'Seleziona il modulo', 1),
                ('item_list', 'Item List', 'it_it', 'Elenco degli elementi', 1),
                ('quickcreate', 'Quick Create', 'it_it', 'Creazione rapida', 1),
                ('overwrite_msg_part1', 'Overwrite the existing address with the selected', 'it_it', 'Sovrascrivi l\'indirizzo esistente con quello selezionato ', 1),
                ('once_in_every', 'Once in every', 'it_it', 'Una volta in ogni', 1),
                ('overwrite_msg_part2', 'address details?', 'it_it', 'dettagli dell\'indirizzo?', 1),
                ('add_item', 'Add Item', 'it_it', 'Aggiungi elemento', 1),
                ('recordsave', 'Record saved successfully', 'it_it', 'Il Record è stato salvato con successo', 1),
                ('recordnotsave', 'Could not save record. Try again later', 'it_it', 'Record non salvato', 1),
                ('minutes', 'Minutes', 'it_it', 'Minuti', 1),
                ('hours', 'Hours', 'it_it', 'Hours', 1),
                ('days', 'Days', 'it_it', 'giorni', 1),
                ('on', 'On', 'it_it', 'Sopra', 1),
                ('day_of_the_month', 'day of the month', 'it_it', 'giorno del mese', 1),
                ('list_price', 'List Price', 'it_it', 'Listino prezzi *', 1),
                ('add_record', 'Add Record', 'it_it', 'Aggiungi record', 1),
                ('add_product', 'Add Product', 'it_it', 'Aggiungi prodotto', 1),
                ('add_service', 'Add Service', 'it_it', 'Aggiungi servizio', 1),
                ('discountin', 'Discount in %', 'it_it', 'Sconto in%', 1),
                ('unitprice', 'Unit price', 'it_it', 'Unit price', 1),
                ('netprice', 'Net price', 'it_it', 'Prezzo netto *', 1),
                ('comments', 'Comments', 'it_it', 'Commenti', 1),
                ('add_close', 'Add & Close', 'it_it', 'Aggiungi e Chiudi', 1),
                ('fetching_rout_message', 'Fetching route, Please wait…', 'it_it', 'Recupero del percorso, attendere prego …', 1),
                ('setting', 'Settings', 'it_it', 'impostazioni', 1),
                ('utc', 'UTC', 'it_it', 'UTC', 1),
                ('in', 'In', 'it_it', 'Nel', 1),
                ('days_ago', 'days ago', 'it_it', 'giorni fa', 1),
                ('mins_ago', 'Minutes ago', 'it_it', 'minuti fa', 1),
                ('justnow', 'Just now', 'it_it', 'Proprio adesso', 1),
                ('hours_ago', 'hours ago', 'it_it', 'ore fa', 1),
                ('in_1_day', 'In 1 day', 'it_it', 'In 1 giorno', 1),
                ('scanqrcode', 'Card Scanner', 'it_it', 'Scanner QR', 1),
                ('call_log', 'Call Log', 'it_it', 'Registro chiamate', 1),
                ('voice_message', 'Hi', 'it_it', 'Ciao', 1),
                ('voice_message1', 'What can I search for you in', 'it_it', 'In cosa posso cercarti', 1),
                ('live_tracking', 'Live Tracking', 'it_it', 'Monitoraggio dal vivo', 1),
                ('mailmanager', 'Mail Manager', 'it_it', 'Mail Manager', 1),
                ('my_location', 'My location', 'it_it', 'La mia posizione', 1),
                ('created_on', 'Created On', 'it_it', 'Creato', 1),
                ('modified_on', 'Modified On', 'it_it', 'Modificato', 1),
                ('enter_comments', 'Enter Comments', 'it_it', 'Inserisci commenti', 1),
                ('viewmore', 'View More', 'it_it', 'Visualizza altro', 1),
                ('viewless', 'View Less', 'it_it', 'Visualizza meno', 1),
                ('gotofullform', 'Go to Full Form', 'it_it', 'Vai a modulo completo', 1),
                ('post', 'Post', 'it_it', 'Inviare', 1),
                ('url', 'URL', 'it_it', 'URL', 1),
                ('dialog_title_text_back_color', 'Select a Text Background Color', 'it_it', 'Select a Text Background Color', 1),
                ('event_or_task', 'Add event/task', 'it_it', 'Aggiungi evento / attività', 1),
                ('shortcut', 'Shortcuts', 'it_it', 'Tasti di scelta rapida', 1),
                ('select_field', 'Select Field', 'it_it', 'Seleziona campo', 1),
                ('share', 'Share', 'it_it', 'Condividere', 1),
                ('title_insert_link', 'Insert Link', 'it_it', 'Insert Link', 1),
                ('addyourcommentshere', 'Add your comments here', 'it_it', 'Aggiungi i tuoi commenti qui', 1),
                ('nocomment', 'No Comments', 'it_it', 'Non ci sono commenti', 1),
                ('leads', 'Leads', 'it_it', 'Conduce', 1),
                ('true_val', 'true', 'it_it', 'true', 1),
                ('noresult', 'No Result', 'it_it', 'No Result', 1),
                ('version', 'Version', 'it_it', 'Versione', 1),
                ('convert_lead', 'Convert Lead', 'it_it', 'Converti piombo', 1),
                ('app_name', 'CRMTiger', 'it_it', 'CRMTiger', 1),
                ('enter_url', 'Please Enter url', 'it_it', 'Si prega di inserire l\'url', 1),
                ('help', 'Help', 'it_it', 'Aiuto', 1),
                ('contact_us', 'Contact Us', 'it_it', 'Contattaci', 1),
                ('updates', 'Updates', 'it_it', 'Updates', 1),
                ('logout', 'LogOut', 'it_it', 'Disconnettersi', 1),
                ('busnies_cardscanner', 'Business Card Scanner', 'it_it', 'Scanner per biglietti da visita', 1),
                ('sure_want_logout', 'Are you sure want to logout ?', 'it_it', 'Sei sicuro di voler uscire?', 1),
                ('logout_message', 'Logout successfully', 'it_it', 'Logout successfully', 1),
                ('all', 'All', 'it_it', 'Tutti', 1),
                ('add_event', 'Add event', 'it_it', 'Aggiungi evento', 1),
                ('add_task', 'Add Task', 'it_it', 'Aggiungi attività', 1),
                ('next', 'Next', 'it_it', 'Il prossimo', 1),
                ('login', 'Login', 'it_it', 'Accesso', 2),
                ('privacy_policay', 'By logging in, you agree to our Terms and Conditions & Privacy Policy', 'it_it', 'Effettuando il login, accetti i nostri Termini e condizioni nonché la politica sulla riservatezza', 2),
                ('copyright', 'Copyright © 2020 CRMTiger Version', 'it_it', 'Copyright \u00A9 2020 CRMTiger \n Version', 2),
                ('enter_username', 'Please enter username', 'it_it', 'Si prega di inserire il nome utente', 2),
                ('enter_password', 'Please enter password', 'it_it', 'Per favore, inserisci la password', 2),
                ('remanberme', 'Remember Me', 'it_it', 'Ricordati di me', 2),
                ('forgot_password', 'Forgot password?', 'it_it', 'Hai dimenticato la password?', 2),
                ('privacy_policay1', 'Privacy Policy', 'it_it', 'politica sulla riservatezza', 2),
                ('contactsupportmsg', 'Something went wrong. \\n please Click here to contact support.', 'it_it', 'Qualcosa è andato storto. \ n, fai clic qui per contattare lassistenza.', 2),
                ('enter_username_password', 'Entered Username or Password is wrong', 'it_it', 'Il nome utente o la password inseriti sono errati', 2),
                ('server_issue_occured', 'Server issues occurred', 'it_it', 'Si sono verificati problemi con il server', 2),
                ('password', 'Password', 'it_it', 'Password', 3),
                ('user_name', 'Username', 'it_it', 'Nome utente', 3),
                ('reset_pwd', 'Reset Password', 'it_it', 'Resetta la password', 3),
                ('forgot_password_title', 'Forgot password', 'it_it', 'Hai dimenticato la password', 3),
                ('enter_user_name', 'Enter user name', 'it_it', 'Inserire username', 3),
                ('cc', 'Cc', 'it_it', 'cc', 4),
                ('body', 'Body', 'it_it', 'Corpo', 4),
                ('bcc', 'BCC', 'it_it', 'CCN', 4),
                ('dialog_title_text_color', 'Select a Text Color', 'it_it', 'Seleziona il colore del testo', 4),
                ('date', 'Date', 'it_it', 'Data', 4),
                ('subject', 'Subject', 'it_it', 'Oggetto', 4),
                ('composeMail', 'Compose Mail', 'it_it', 'Scrivi una mail', 4),
                ('send', 'Send', 'it_it', 'Inviare', 4),
                ('select_message', 'Select message', 'it_it', 'Seleziona messaggio', 4),
                ('title_insert_table', 'Insert Table', 'it_it', 'Inserisci tabella', 4),
                ('log_file_sms', 'I agree to Share API Log to Technical team for further troubleshooting', 'it_it', 'Accetto di condividere il log dell\'API al team tecnico per una ulteriore analisi e risoluzione dei problemi', 5),
                ('edit_record', 'Edit Records', 'it_it', 'Modifica record', 5),
                ('select_time', 'Select Time', 'it_it', 'Seleziona ora', 5),
                ('edit_item', 'Edit Item', 'it_it', 'Edit Item', 5),
                ('items_total', 'Items Total', 'it_it', 'Items Total', 5),
                ('number_less_then_31', 'Number should be less than 31', 'it_it', 'Number should be less than 31', 5),
                ('users', 'Users', 'it_it', 'utenti', 5),
                ('groups', 'Groups', 'it_it', 'gruppi', 5),
                ('txt_note_for_file', 'Note : Existing attachments(images/files) will be replaced', 'it_it', 'Nota: gli allegati esistenti (immagini / file) saranno sostituiti', 5),
                ('greaterdatetime', 'End DateTime should be greater than Start DateTime', 'it_it', 'End DateTime should be greater than Start DateTime', 5),
                ('until', 'Until', 'it_it', 'Fino a', 5),
                ('organizations', 'Organizations', 'it_it', 'organizzazioni', 6),
                ('contacts', 'Contacts', 'it_it', 'Contatti', 6),
                ('opportunity', 'Opportunity', 'it_it', 'Opportunità', 6),
                ('lbl_sun', 'SUN', 'it_it', 'DOM', 7),
                ('lbl_mon', 'MON', 'it_it', 'LUN', 7),
                ('lbl_tue', 'TUE', 'it_it', 'MAR', 7),
                ('lbl_wed', 'WED', 'it_it', 'MER', 7),
                ('lbl_thu', 'THU', 'it_it', 'GIO', 7),
                ('lbl_fri', 'FRI', 'it_it', 'VEN', 7),
                ('lbl_sat', 'SAT', 'it_it', 'SAB', 7),
                ('lbl_1', '1', 'it_it', '1', 7),
                ('lbl_2', '2', 'it_it', '2', 7),
                ('lbl_3', '3', 'it_it', '3', 7),
                ('lbl_4', '4', 'it_it', '4', 7),
                ('lbl_5', '5', 'it_it', '5', 7),
                ('lbl_6', '6', 'it_it', '6', 7),
                ('lbl_7', '7', 'it_it', '7', 7),
                ('lbl_8', '8', 'it_it', '8', 7),
                ('lbl_9', '9', 'it_it', '9', 7),
                ('lbl_10', '10', 'it_it', '10', 7),
                ('lbl_11', '11', 'it_it', '11', 7),
                ('lbl_12', '12', 'it_it', '12', 7),
                ('lbl_13', '13', 'it_it', '13', 7),
                ('lbl_14', '14', 'it_it', '14', 7),
                ('lbl_15', '15', 'it_it', '15', 7),
                ('lbl_16', '16', 'it_it', '16', 7),
                ('lbl_17', '17', 'it_it', '17', 7),
                ('lbl_18', '18', 'it_it', '18', 7),
                ('lbl_19', '19', 'it_it', '19', 7),
                ('lbl_20', '20', 'it_it', '20', 7),
                ('lbl_21', '21', 'it_it', '21', 7),
                ('lbl_22', '22', 'it_it', '22', 7),
                ('lbl_23', '23', 'it_it', '23', 7),
                ('lbl_24', '24', 'it_it', '24', 7),
                ('lbl_25', '25', 'it_it', '25', 7),
                ('lbl_26', '26', 'it_it', '26', 7),
                ('lbl_27', '27', 'it_it', '27', 7),
                ('lbl_28', '28', 'it_it', '28', 7),
                ('lbl_29', '29', 'it_it', '29', 7),
                ('lbl_30', '30', 'it_it', '30', 7),
                ('lbl_31', '31', 'it_it', '31', 7),
                ('lbl_32', '32', 'it_it', '32', 7),
                ('lbl_33', '33', 'it_it', '33', 7),
                ('lbl_34', '34', 'it_it', '34', 7),
                ('lbl_35', '35', 'it_it', '35', 7),
                ('lbl_36', '36', 'it_it', '36', 7),
                ('lbl_37', '37', 'it_it', '37', 7),
                ('lbl_38', '38', 'it_it', '38', 7),
                ('lbl_39', '39', 'it_it', '39', 7),
                ('lbl_40', '40', 'it_it', '40', 7),
                ('lbl_41', '41', 'it_it', '41', 7),
                ('lbl_42', '42', 'it_it', '42', 7),
                ('current_date', 'current date', 'it_it', 'data odierna', 7),
                ('event', 'Events', 'it_it', 'eventi', 7),
                ('calendar', 'Calendar', 'it_it', 'Calendario', 7),
                ('latest_version', 'Latest Version :', 'it_it', 'Ultima versione :', 8),
                ('expire_on', 'Expire On :', 'it_it', 'Scadenza:', 8),
                ('ctmobile_ext_version', 'CTMobile Ext. Version :', 'it_it', 'CTMobile Ext. Versione:', 8),
                ('you_have_latest_version', 'You already have latest version', 'it_it', 'Hai aggiornato la versione', 8),
                ('upgreaded', 'Upgrade', 'it_it', 'aggiornamento', 8),
                ('downgrade', 'Downgrade', 'it_it', 'retrocedere', 8),
                ('dialog_recent_event_info', 'You can set from here how many number of records you want to show on Home screen for Recent Event.', 'it_it', 'Puoi impostare da qui quanti numeri di record vuoi mostrare sulla schermata Home per Eventi recenti.', 8),
                ('dialog_feedback_info', 'You can submit your feedback with description , our team will check your feedback and get back to you.', 'it_it', 'Puoi inviare il tuo feedback con la descrizione, il nostro team controllerà il tuo feedback e ti risponderà.', 8),
                ('dialog_log_info', 'Log functionality is used for customer support / help , If you are facing any issues in app or any module or functionality is not working proper then you can enable share log with our development team.', 'it_it', 'La funzionalità di registro viene utilizzata per l\'assistenza / aiuto clienti, se si riscontrano problemi nell\'app o in qualsiasi modulo o se la funzionalità non funziona correttamente, è possibile abilitare il registro di condivisione con il nostro team di sviluppo.', 8),
                ('info', 'Info', 'it_it', 'Informazioni', 8),
                ('recent_history', 'Recent History', 'it_it', 'Storia recente', 8),
                ('recent_feedback', 'Feedback', 'it_it', 'Risposta', 8),
                ('recent_log', 'Log', 'it_it', 'Log', 8),
                ('crmtiger_app_version', 'CRMTiger App Version :', 'it_it', 'Versione dell\'app CRMTiger:', 8),
                ('historylimit', 'Recent History Limit', 'it_it', 'Limite della cronologia recente', 8),
                ('radious_in_miles', 'Radius in miles', 'it_it', 'Raggio in miglia', 8),
                ('recentlimit', 'Recent Event Limit', 'it_it', 'Limite eventi recenti', 8),
                ('upcoming_events', 'Upcoming Events', 'it_it', 'Prossimi eventi', 8),
                ('rate_our_app', 'Rate Our App!', 'it_it', 'Vota la nostra app!', 8),
                ('feedback', 'Submit Feedback', 'it_it', 'Invia feedback', 8),
                ('sendfeedback', 'Feedback Send', 'it_it', 'Feedback Send', 8),
                ('emaillimit', 'Email limit', 'it_it', 'Limite email', 8),
                ('log', 'Log', 'it_it', 'Log', 8),
                ('logclear', 'Log cleared successfully.', 'it_it', 'Cancellazione eseguita', 8),
                ('dialog_recent_history_info', 'You can set from here how many number of records you want to show on Home screen for Recent History.', 'it_it', 'È possibile impostare da qui quanti numeri di record si desidera mostrare nella schermata Home per la cronologia recente.', 8),
                ('proceed_to_upgrade1', 'Proceed to', 'it_it', 'Procedi a', 8),
                ('upgradation_message', 'will required logout and login again later.', 'it_it', 'sarà necessario disconnettersi e accedere nuovamente in un secondo momento.', 8),
                ('proceed_to_upgrade', 'Proceed to Upgrade', 'it_it', 'Procedere allaggiornamento', 8),
                ('module_setting', 'Module Setting', 'it_it', 'Impostazione del modulo', 9),
                ('sortbyfield', 'Sort by field', 'it_it', 'Ordina per campo', 9),
                ('ascending', 'Ascending  A to Z', 'it_it', 'Ascendente dalla A alla Z.', 9),
                ('descending', 'Descending  Z to A', 'it_it', 'Decrescente dalla Z alla A', 9),
                ('first_field', 'First Field', 'it_it', 'Primo campo', 9),
                ('second_field', 'Second Field', 'it_it', 'Secondo campo', 9),
                ('third_field', 'Third Field', 'it_it', 'Terzo campo', 9),
                ('sure_want_restore', 'Are you sure you want to reset to default settings?', 'it_it', 'Sei sicuro di voler ripristinare il valore predefinito', 9),
                ('orderlist', 'List Order', 'it_it', 'Ordine di lista', 9),
                ('module_reset', 'Restore to Default', 'it_it', 'Ripristina al valore predefinito', 9),
                ('display_fields', 'Display Fields', 'it_it', 'Visualizza campi', 9),
                ('discount_lessthen_100', 'Discount % should be less than 100', 'it_it', 'La percentuale di sconto deve essere inferiore a 100', 10),
                ('select_item', 'Select Item', 'it_it', 'Scegliere elemento', 10),
                ('item_comment', 'Item Comment', 'it_it', 'Commento elemento', 10),
                ('record_name', 'Record Name is :', 'it_it', 'Il nome del record è: -', 11),
                ('go_back', 'Go Back', 'it_it', 'Go Back', 11),
                ('please_enter_shortcut_name', 'Please Enter Shortcut Name', 'it_it', 'Si prega di inserire il nome del collegamento', 11),
                ('number_not_found', 'Contact Number not found', 'it_it', 'Numero di contatto non trovato', 11),
                ('mail_not_found', 'Mail Address not found', 'it_it', 'Indirizzo di posta non trovato', 11),
                ('create_shortcut', 'Create Shortcut', 'it_it', 'Creare una scorciatoia', 11),
                ('contact_summary', 'Summary', 'it_it', 'Summary', 11),
                ('activites', 'Activities', 'it_it', 'attività', 11),
                ('details', 'Details', 'it_it', 'Details', 11),
                ('related', 'Related', 'it_it', 'Related', 11),
                ('share_link', 'Share record with', 'it_it', 'Condividi record con', 11),
                ('edit', 'Edit', 'it_it', 'Edit', 11),
                ('duplicate', 'Duplicate', 'it_it', 'Duplicate', 11),
                ('whatsapp', 'Whatsapp', 'it_it', 'Whatsapp', 11),
                ('call', 'Call', 'it_it', 'Call', 11),
                ('choose_contact_for_call', 'Choose Contact for Call', 'it_it', 'Choose Contact for Call', 11),
                ('choose_contact_for_sms', 'Choose Contact for SMS', 'it_it', 'Choose Contact for SMS', 11),
                ('choose_contact_for_whatsapp', 'Choose Contact for WhatsApp', 'it_it', 'Choose Contact for WhatsApp', 11),
                ('chosse_contact_for_email', 'Choose Email', 'it_it', 'Choose Email', 11),
                ('attach_file', 'Attach Files', 'it_it', 'Attach Files', 11),
                ('close', 'Close', 'it_it', 'Close', 11),
                ('status', 'Status', 'it_it', 'Stato', 11),
                ('stop', 'Stop', 'it_it', 'Fermare', 11),
                ('zero', '0', 'it_it', '0', 11),
                ('record', 'Record', 'it_it', 'Disco', 11),
                ('voice_note', 'Voice Note', 'it_it', 'Nota vocale', 11),
                ('tickets', 'Tickets', 'it_it', 'Biglietti', 12),
                ('check_out', 'Check Out', 'it_it', 'Registra Uscita', 12),
                ('check_in', 'Check In', 'it_it', 'Registra Entrata', 12),
                ('select_any', 'Select any', 'it_it', 'Select any', 12),
                ('fulldetails', 'Show Full Details', 'it_it', 'Mostra tutti i dettagli', 12),
                ('checkin', 'Check-in', 'it_it', 'Registrare', 12),
                ('navigate', 'Navigate', 'it_it', 'Navigare', 12),
                ('product', 'Products', 'it_it', 'Prodotti', 12),
                ('projectMilestone', 'Project Milestone', 'it_it', 'Milestone', 12),
                ('projecttask', 'Project Tasks', 'it_it', 'Task', 12),
                ('nearby', 'NearBy', 'it_it', 'Nelle vicinanze', 13),
                ('document', 'Document', 'it_it', 'Documento', 14),
                ('reply', 'Reply', 'it_it', 'rispondere', 14),
                ('reply_all', 'Reply All', 'it_it', 'Rispondi a tutti', 14),
                ('forward', 'Forward', 'it_it', 'Inoltrare', 14),
                ('action', 'Action', 'it_it', 'Azione', 14),
                ('select_first', 'Select First', 'it_it', 'Select First', 14),
                ('commentaddsuccessful', 'Comment added successfull', 'it_it', 'Commento aggiungere con successo', 14),
                ('move_to', 'Move to', 'it_it', 'Sposta a', 14),
                ('attach', 'Attach', 'it_it', 'allegare', 14),
                ('addcoment', 'Add Comment', 'it_it', 'Aggiungi un commento', 14),
                ('adddocument', 'Add Document', 'it_it', 'Aggiungi documento', 14),
                ('home', 'Home', 'it_it', 'Casa', 15),
                ('checkout', 'Check-out', 'it_it', 'Registra Uscita', 15),
                ('message_search', 'Search by name', 'it_it', 'Ricerca per nome', 15),
                ('start_shift', 'Start shift', 'it_it', 'Inizia il turno', 15),
                ('end_shift', 'End shift', 'it_it', 'Fine turno', 15),
                ('today_meeting', 'Meetings', 'it_it', 'incontri', 15),
                ('shift_time_track', 'Shift Time Track', 'it_it', 'Traccia dei turni', 15),
                ('logout_msg', 'You have to login again , click', 'it_it', 'You have to login again , click', 15),
                ('logout_msg1', 'to continue.', 'it_it', 'to continue.', 15),
                ('permission_denied', 'You don\'t have permission to create', 'it_it', 'Non hai il permesso di creare', 15),
                ('history', 'Activity stream', 'it_it', 'Flusso di attività', 15),
                ('search_value', 'Search value :', 'it_it', 'Valore di ricerca: -', 15),
                ('feed_back_msg', 'Please enter feedback message', 'it_it', 'Si prega di inserire un messaggio di feedback', 16),
                ('feed_back_hint_msg', 'Enter feedback message', 'it_it', 'Inserisci un messaggio di feedback', 16),
                ('submit', 'Submit', 'it_it', 'Sottoscrivi', 16),
                ('check_app_not_installed', 'Application is not currently installed.', 'it_it', 'L\'applicazione non è attualmente installata.', 17),
                ('send_sms_fail_message', 'SMS failed, please try again later!', 'it_it', 'SMS fallito, per favore riprova più tardi!', 17),
                ('documentaddsuccessfully', 'Document Attach successfully', 'it_it', 'Documento Allega con successo', 17),
                ('send_message', 'Send message', 'it_it', 'Invia messaggio', 17),
                ('sms_to', 'smsto:', 'it_it', 'smsto:', 17),
                ('add_list_message', 'Add List', 'it_it', 'Aggiungi lista', 18),
                ('mylist', 'My List', 'it_it', 'La mia lista', 18),
                ('filtername', 'Filter Name', 'it_it', 'Nome filtro', 18),
                ('selectlist', 'Select a List', 'it_it', 'Seleziona un elenco *', 18),
                ('assingedto', 'Assigned To', 'it_it', 'Assegnato a *', 18),
                ('selectmodule', 'Select a module', 'it_it', 'Seleziona un modulo', 18),
                ('add_list', 'Add Filter', 'it_it', 'Aggiungi filtro', 18),
                ('recent_event', 'Recent Event', 'it_it', 'Evento recente', 19),
                ('recent_hostory', 'Recent History', 'it_it', 'Storia recente', 19),
                ('module_specific_settings', 'Module-Specific Settings', 'it_it', 'Impostazioni specifiche del modulo', 19),
                ('talk_to_us', 'Talk to us', 'it_it', 'Parla con noi', 19),
                ('report_a_bug', 'Report A Bug', 'it_it', 'Segnalare un bug', 19),
                ('faq', 'FAQ', 'it_it', 'FAQ', 19),
                ('selectmodules', 'Select Module', 'it_it', 'Seleziona il modulo', 19),
                ('myplan', 'My Plan', 'it_it', 'Il mio piano', 19),
                ('message', 'Message', 'it_it', 'Messaggio', 20),
                ('message_validation', 'Please enter Message', 'it_it', 'Si prega di inserire il messaggio', 20),
                ('contact_select', 'Please Select contact', 'it_it', 'Si prega di selezionare un contatto', 20),
                ('global_search', 'Global Search', 'it_it', 'Ricerca globale', 21),
                ('records', 'Records', 'it_it', 'Records', 21),
                ('dont_show_again', 'Don\'t Show Again', 'it_it', 'Non mostrare più', 22),
                ('skip', 'Skip', 'it_it', 'Salta', 22),
                ('file_downloading', 'File Downloading', 'it_it', 'Download di file', 23),
                ('add_screenshots_optional', 'Add screenshots (optional)', 'it_it', 'Aggiungi screenshot (opzionale)', 24),
                ('describe_your_problem', 'Describe your problem', 'it_it', 'Descrivi il tuo problema', 24),
                ('default_filter_shortcut', 'Default Filter Shortcut', 'it_it', 'Collegamento filtro predefinito', 25),
                ('record_shortcut', 'Record Shortcut', 'it_it', 'Collegamento scorciatoia', 25),
                ('enter_url', 'Please Enter url', 'it_it', 'Please Enter url', 26),
                ('new_version_is_avaiable', 'You need to update the app to continue using Please update to continue Older versions will no longer work from today', 'it_it', 'È necessario aggiornare l\'app per continuare a utilizzare Aggiorna per continuare Le versioni precedenti non funzioneranno più da oggi', 26),
                ('search_by', 'Search by', 'it_it', 'Cercato da', 27),
                ('selected_filter', 'Selected filter :', 'it_it', 'Filtro selezionato: -', 27),
                ('selected_field', 'Selected field :', 'it_it', 'Campo selezionato: -', 27),
                ('choose', 'Choose', 'it_it', 'Scegliere', 28),
                ('qr_cardscanner', 'QR Code Scanner', 'it_it', 'Scanner di codici QR', 28),
                ('error_message_for_scan', 'Could not read the card Try again later.', 'it_it', 'Impossibile leggere la scheda Riprovare più tardi.', 28),
                ('press_start_scan', 'Press to Start Scan', 'it_it', 'Premere per avviare la scansione', 28),
                ('line_item_quntity_validation_msg', 'Value should be greater than zero', 'it_it', 'Value should be greater than zero', 29),
                ('percentage_msg', 'Percentage should be less than 100', 'it_it', 'Percentage should be less than 100', 29),
                ('MSG_NO_DATA', 'No data found!', 'it_it', 'No data found!', 29),
                ('MSG_SOMETHING_WRONG', 'Something went wrong!', 'it_it', 'Something went wrong!', 29),
                ('MSG_COMING_SOON', 'Coming Soon!', 'it_it', 'Coming Soon!', 29),
                ('MSG_UPLOAD_PROFILE_IMAGE', 'Please upload profile image.', 'it_it', 'Please upload profile image.', 29),
                ('ALERT_TITLE_LOCATION_ACCESS', 'Location Access', 'it_it', 'Location Access', 29),
                ('ALERT_MSG_LOCATION_ACCESS', 'Requires your location to show nearby events.', 'it_it', 'Requires your location to show nearby events.', 29),
                ('ALERT_BTN_ALLOW', 'ALLOW', 'it_it', 'ALLOW', 29),
                ('ALERT_BTN_DENY', 'DENY', 'it_it', 'DENY', 29),
                ('ALERT_MSG_LOCATION_SETTING', 'Not able to fetch your current location. Please check your location settings.', 'it_it', 'Not able to fetch your current location. Please check your location settings.', 29),
                ('DELETE_RECORD', 'Delete Record', 'it_it', 'Delete Record', 29),
                ('ALERT_MSG_DELETE_SHORTCUT', 'Are you sure want to delete this shortcut?', 'it_it', 'Are you sure want to delete this shortcut?', 29),
                ('DELETE_SHORTCUT', 'Delete Shortcut', 'it_it', 'Delete Shortcut', 29),
                ('LBL_TERMS', 'By logging in, you agree to our Terms and', 'it_it', 'By logging in, you agree to our Terms and', 29),
                ('LBL_CONDITIONS', 'Conditions &', 'it_it', 'Conditions &', 29),
                ('ALERT_TITLE', 'Alert', 'it_it', 'Alert', 29),
                ('ALERT_BTN_SUBSCRIBE', 'Subscribe', 'it_it', 'Subscribe', 29),
                ('MSG_SELECT_MODULE', 'Please select any Module', 'it_it', 'Please select any Module', 29),
                ('MSG_SELECT_LIST', 'Please select any List', 'it_it', 'Please select any List', 29),
                ('ALERT_MSG_DONT_HAVE_CAMERA', 'You don\'t have camera', 'it_it', 'You don\'t have camera', 29),
                ('ALERT_MSG_GALLARY_PERMISSION', 'You don\'t have permission to access gallery.', 'it_it', 'You don\'t have permission to access gallery.', 29),
                ('ALERT_MSG_CAMERA_PERMISSION', 'You don\'t have permission to access camera. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Camera on', 'it_it', 'You don\'t have permission to access camera. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Camera on', 29),
                ('ALERT_MSG_SPEECH_PERMISSION', 'You don\'t have permission to access Speech Recognition. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Speech Recognition on', 'it_it', 'You don\'t have permission to access Speech Recognition. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Speech Recognition on', 29),
                ('BTN_DONE', 'Done', 'it_it', 'Done', 29),
                ('COMMENT', 'Comment', 'it_it', 'Comment', 29),
                ('FULL_FORM', 'Full Form', 'it_it', 'Full Form', 29),
                ('QUICK_CREATE', 'Create', 'it_it', 'Create', 29),
                ('LBL_SELECT_FIELDS', 'Select Fields', 'it_it', 'Select Fields', 29),
                ('LBL_SELECT_FIELDS', 'Select Fields', 'it_it', 'Select Fields', 29),
                ('LBL_SELECT_FIRST_FIELDS', 'Select First Field', 'it_it', 'Select First Field', 29),
                ('LBL_SELECT_SECOND_FIELDS', 'Select Second Field', 'it_it', 'Select Second Field', 29),
                ('LBL_SELECT_THIRD_FIELDS', 'Select Third Field', 'it_it', 'Select Third Field', 29),
                ('LBL_SORT_BY_FIELD', 'Select Sort By Field', 'it_it', 'Select Sort By Field', 29),
                ('BTN_RESET_TO_DEFAULT', 'Reset to Default', 'it_it', 'Reset to Default', 29),
                ('MSG_SELECT_SORT_BY_FIELD', 'Select Sort by field', 'it_it', 'Select Sort by field', 29),
                ('kStrClearBtnTitle', 'Clear', 'it_it', 'Clear', 29),
                ('kStrShowMoreBtnTitle', 'Show More', 'it_it', 'Show More', 29),
                ('kStrAddActivitiesBtnTitle', 'Add Activities', 'it_it', 'Add Activities', 29),
                ('kStrAddCommentPlaceHolder', 'Add your comments here', 'it_it', 'Add your comments here', 29),
                ('MSG_ENTER_TO_EMAIL', 'Please enter to field.', 'it_it', 'Please enter to field.', 29),
                ('WARNING_FILE', 'File can\'t open.', 'it_it', 'File can\'t open.', 29),
                ('MSG_FILE_SAVED', 'File saved.', 'it_it', 'File saved.', 29),
                ('WARNING_DOWNLOAD_FAIL', 'Download fail!, please try after sometime.', 'it_it', 'Download fail!, please try after sometime.', 29),
                ('LBL_SHORTCUT', 'Shortcut', 'it_it', 'Shortcut', 29),
                ('TXT_MESSAGE_PLACEHOLDER', 'Type Message', 'it_it', 'Type Message', 29),
                ('ALERT_INSTALL_WHATSAPP', 'Install Whatsapp', 'it_it', 'Install Whatsapp', 29),
                ('MSG_NO_MAIL_BOX', 'No MailBox found. Please Create Mailbox', 'it_it', 'No MailBox found. Please Create Mailbox', 29),
                ('LBL_WROTE', 'Wrote', 'it_it', 'Wrote', 29),
                ('MSG_MAIL_SEND', 'Mail sent', 'it_it', 'Mail sent', 29),
                ('log_file_not_found', 'API Log file not found.', 'it_it', 'API Log file not found.', 29),
                ('unknown_error', 'An unknown error occurred, try again', 'it_it', 'An unknown error occurred, try again', 29),
                ('CTMTigerAppVersion', 'CRMTiger App Version', 'it_it', 'CRMTiger App Version', 29),
                ('CTMMobileUpdateMsg', 'CTMobile Ext. Version Update Successfully', 'it_it', 'CTMobile Ext. Version Update Successfully', 29),
                ('dialog_Premium_downgrade', 'Downgrade will required logout and login again later', 'it_it', 'Downgrade will required logout and login again later', 29),
                ('dialog_Premium', 'Upgrade will required logout and login again later', 'it_it', 'Upgrade will required logout and login again later', 29),
                ('Overwrite', 'Overwrite', 'it_it', 'Overwrite', 29),
                ('MSGAddressOverwrite1', 'Overwrite the existing address with the selected', 'it_it', 'Overwrite the existing address with the selected', 29),
                ('MSGAddressOverwrite2', 'address details?', 'it_it', 'address details?', 29),
                ('UPGRADE_PLAN', 'Upgrade Plan', 'it_it', 'Upgrade Plan', 29),
                ('DOWNGRADE_PLAN', 'Downgrade Plan', 'it_it', 'Downgrade Plan', 29),
                ('UPGRADE_EXTENSION', 'Upgrade Extension', 'it_it', 'Upgrade Extension', 29),
                ('UPGRADE_APP', 'Upgrade App', 'it_it', 'Upgrade App', 29),
                ('SELECT_OPTION', 'Select Option', 'it_it', 'Select Option', 29),
                ('PLEASE_SELECT', 'Please select', 'it_it', 'Please select', 29),
                ('MSG_ACCESS_DENIED', 'You don\'t have permission for this module.', 'it_it', 'You don\'t have permission for this module.', 29),
                ('MSG_SELECT_RECCURING_MONTH_DAY', 'Please select reccuring day of month.', 'it_it', 'Please select reccuring day of month.', 29),
                ('MSG_SELECT_RECCURING_WEEK_DAY', 'Please select reccuring day of week.', 'it_it', 'Please select reccuring day of week.', 29),
                ('MSG_SELECT_RECCURING_DAYS', 'Please select reccuring days.', 'it_it', 'Please select reccuring days.', 29),
                ('Please select reccuring days.', 'Please select reccuring days.', 'it_it', 'Please select reccuring days.', 29),
                ('MSG_SELECT_RECCURING_END_DATE', 'Please select reccuring end date.', 'it_it', 'Please select reccuring end date.', 29),
                ('MSG_SELECT_RECCURING_TYPE', 'Please select reccuring type.', 'it_it', 'Please select reccuring type.', 29),
                ('FREQ_TIME', 'Times', 'it_it', 'Times', 29),
                ('REPEAT_YEARLY', 'Repeat Yearly', 'it_it', 'Repeat Yearly', 29),
                ('REPEAT_MONTHLY', 'Repeat Monthly', 'it_it', 'Repeat Monthly', 29),
                ('REPEAT_WEEKLY', 'Repeat Weekly', 'it_it', 'Repeat Weekly', 29),
                ('REPEAT_DAILY', 'Repeat Daily', 'it_it', 'Repeat Daily', 29),
                ('ACTION_TITLE', 'Action Title', 'it_it', 'Action Title', 29),
                ('MSG_SELECT_VALID_DATE', 'Please select valid day of month.', 'it_it', 'Please select valid day of month.', 29),
                ('MSG_SELECT_VALID_START_DATE', 'Start date should be less than end date.', 'it_it', 'Start date should be less than end date.', 29),
                ('MSG_SELECT_VALID_START_TIME', 'Start time should be less than end time.', 'it_it', 'Start time should be less than end time.', 29),
                ('LBL_LINEITEM_DETAILS', 'Lineitem Details', 'it_it', 'Lineitem Details', 29),
                ('MSG_INVALIDE_DISCOUNT_AMOUNT', 'Discount amount should be less than the total.', 'it_it', 'Discount amount should be less than the total.', 29),
                ('VIEW', 'View', 'it_it', 'View', 29),
                ('MSG_ENTER_VALID', 'Please enter valid', 'it_it', 'Please enter valid', 29),
                ('MSG_ENTER_PERCENTAGE', 'Percentage should be less than 100.', 'it_it', 'Percentage should be less than 100.', 29),
                ('ITEM_TOTAL', 'Item Total', 'it_it', 'Item Total', 29),
                ('ADJUSTMENT', 'Adjustment', 'it_it', 'Adjustment', 29),
                ('TITLE_CHOOSE_IMAGE', 'Choose Image', 'it_it', 'Choose Image', 29),
                ('COMPRESS', 'Compress', 'it_it', 'Compress', 29),
                ('CHOOSE_ANOTHER_IMAGE', 'Your image size is too large, please select another image', 'it_it', 'Your image size is too large, please select another image', 29),
                ('OnDayOfMonth', 'On day of month', 'it_it', 'On day of month', 29),
                ('OnDayOfWeek', 'On day of week', 'it_it', 'On day of week', 29),
                ('AddAndClose', 'Add & Close', 'it_it', 'Add & Close', 29),
                ('Repeat', 'Repeat', 'it_it', 'Repeat', 29),
                ('OnDay', 'On day', 'it_it', 'On day', 29),
                ('View_Line_Item', 'View Line Item', 'it_it', 'View Line Item', 29),
                ('TITLE_IMAGE', 'Image', 'it_it', 'Image', 29),
                ('TITLE_ICLOUD', 'iCloud', 'it_it', 'iCloud', 29),
                ('GOOGLE', 'Google', 'it_it', 'Google', 29),
                ('ALERT_BTN_OKAY', 'Okay', 'it_it', 'Okay', 29),
                ('ALERT_TITLE_ACCESS_DENIED', 'Access Denied', 'it_it', 'Access Denied', 29),
                ('Dont_Show_Again', 'Don\'t show again', 'it_it', 'Don\'t show again', 29),
                ('Skip', 'Skip', 'it_it', 'Skip', 29),
                ('Fillter_Name', 'Fillter Name', 'it_it', 'Fillter Name', 29),
                ('Fillter_Record_Count', 'Fillter Record Count', 'it_it', 'Fillter Record Count', 29);",array());
        }
    }
	
	static function CTMobileUserAccess() {
        global $adb;
		
		$ctmobile_access_Users =$adb->pquery("SELECT * FROM `ctmobile_access_users` ",array());
		if($adb->num_rows($ctmobile_access_Users) == 0 ){
			//Insert Defaullt Users in ctmobile_access_users Table
			$Users =$adb->pquery("SELECT * FROM `vtiger_users` WHERE deleted = 0 AND status = ?",array('Active'));
			$userArray = array();
			for($i=0;$i<($adb->num_rows($Users));$i++){
			$id = $adb->query_result($Users,$i,'id');
			$adb->pquery("INSERT INTO `ctmobile_access_users` (`userid`) VALUES (?)",array($id));
			}
			
		}
		
    }

 
    /**
     * Add CTMobileSettings Widgets at CRM Settings > Other Settings
     * parameters None.
     * @return None
     */
    static function addWidgetTo() {
        global $adb;
        $widgetType = 'HEADERSCRIPT';
        $widgetName = 'CTMobileSettingsJS';
        $link = 'layouts/v7/modules/CTMobileSettings/resources/CTMobileSettings.js';
        include_once 'vtlib/Vtiger/Module.php';

        $moduleNames = array('CTMobileSettings');
        foreach($moduleNames as $moduleName) {
            $module = Vtiger_Module::getInstance($moduleName);
            if($module) {
                $module->addLink($widgetType, $widgetName, $link);
            }
        }
		$adb->pquery("DELETE FROM vtiger_settings_field WHERE `name` = ?",array('CTMobileSettings'));
		$rsBlock=$adb->pquery("SELECT blockid FROM `vtiger_settings_blocks` WHERE label='LBL_OTHER_SETTINGS'",array());
		$blockid=$adb->query_result($rsBlock, 0, 'blockid');
        $max_id=$adb->getUniqueID('vtiger_settings_field');
        $adb->pquery("INSERT INTO `vtiger_settings_field` (`fieldid`, `blockid`, `name`, `description`, `linkto`, `sequence`) VALUES (?, ?, ?, ?, ?, ?)",array($max_id,$blockid,'CTMobileSettings', 'CTMobileSettings', 'index.php?module=CTMobileSettings&parent=Settings&view=Details',$max_id));
    }
	/**
     * remove CTMobileSettings Widgets from CRM Settings > Other Settings
     * parameters None.
     * @return None
     */
	static function removeWidgetTo() {
        global $adb;
        $widgetType = 'HEADERSCRIPT';
        $widgetName = 'CTMobileSettingsJs';
        $link = 'layouts/v7/modules/CTMobileSettings/resources/CTMobileSettings.js';
        include_once 'vtlib/Vtiger/Module.php';

        $moduleNames = array('CTMobileSettings');
        foreach($moduleNames as $moduleName) {
            $module = Vtiger_Module::getInstance($moduleName);
            if($module) {
                $module->deleteLink($widgetType, $widgetName, $link);
            }
        }
        $adb->pquery("DELETE FROM vtiger_settings_field WHERE `name` = ?",array('CTMobileSettings'));
    }
    
}
