<?php
 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */
include_once dirname(__FILE__) . '/models/Alert.php';
include_once dirname(__FILE__) . '/models/SearchFilter.php';
include_once dirname(__FILE__) . '/models/Paging.php';
include_once 'include/QueryGenerator/QueryGenerator.php';

class CTMobile_WS_GetMonthBaseEventCount extends CTMobile_WS_Controller {
	
	function getSearchFilterModel($module, $search) {
		return CTMobile_WS_SearchFilterModel::modelWithCriterias($module, Zend_JSON::decode($search));
	}
	
	function getPagingModel(CTMobile_API_Request $request) {
		$page = $request->get('page', 0);
		return CTMobile_WS_PagingModel::modelWithPageStart($page);
	}
	
	function process(CTMobile_API_Request $request) {
		global $current_user,$adb, $site_URL;
		$current_user = $this->getActiveUser();
		$userid = trim($request->get('userid'));
		$month = trim($request->get('month'));
		$year = trim($request->get('year'));
		$response = new CTMobile_API_Response();
		$recentEvent_data = array();
		$generator = new QueryGenerator('Events', $current_user);
		$generator->setFields(array('subject','activitytype','location','date_start','time_start','location','createdtime','modifiedtime','id'));
		$eventQuery = $generator->getQuery();
		$month = $request->get('month');
  
		if (empty($month)) {
			$message = vtranslate('Month cannot be empty!','CTMobile');
			$response->setError(1501, $message);
			return $response;
		}
		$year = $request->get('year');
		if (empty($year)) {
			$message = vtranslate('Year cannot be empty!','CTMobile');
			$response->setError(1501, $message);
			return $response;
		}
		 
		if (empty($userid)) {
			$message = vtranslate('Userid cannot be empty!','CTMobile');
			$response->setError(1501, $message);
			return $response;
		}
		$startdate = date($year.'-'.$month.'-01');
		$enddate = date($year.'-'.$month.'-t');
		
		$startDateTime = Vtiger_Datetime_UIType::getDBDateTimeValue($startdate . ' 00:00:00');
													
																	   
																  
		
		$endDateTime = Vtiger_Datetime_UIType::getDBDateTimeValue($enddate . ' 23:59:00');
												
																   
															  

		$userPrivModel = Users_Privileges_Model::getInstanceById($current_user->id);
		if($userPrivModel->isAdminUser()){
			$eventQuery .= " AND vtiger_crmentity.setype = 'Calendar' AND CONCAT(date_start,' ',time_start) BETWEEN '" . $startDateTime . "' and '" . $endDateTime . "'  AND vtiger_crmentity.deleted =0  ORDER BY vtiger_activity.date_start, time_start DESC";
		}else{
			$eventQuery .= " AND vtiger_crmentity.setype = 'Calendar' AND vtiger_crmentity.smownerid = '".$current_user->id."' AND CONCAT(date_start,' ',time_start) BETWEEN '" . $startDateTime . "' and '" . $endDateTime . "'  AND vtiger_crmentity.deleted =0  ORDER BY vtiger_activity.date_start, time_start DESC";
		}
		
																																																																																														
		$query = $adb->pquery($eventQuery);
		for($i=0; $i<$adb->num_rows($query); $i++) {
			$startDate = $adb->query_result($query, $i, 'date_start');
			$startTime = $adb->query_result($query, $i, 'time_start');
			$activityid = $adb->query_result($query, $i, 'activityid');
			if($startDate!=''){
				$startDateTime = $startDate." ".$startTime;
				$UserStartDateTime= Vtiger_Datetime_UIType::getDisplayDateTimeValue($startDateTime);
				$DATE_TIME_COMPONENTS = explode(' ' ,$UserStartDateTime);
				$startDate = $DATE_TIME_COMPONENTS[0];
				$startTime = $DATE_TIME_COMPONENTS[1];
				if(Users_Privileges_Model::isPermitted('Calendar', 'DetailView', $activityid)){
					$recentEvent_data[] = $startDate;
				}
			}
		}
		
		$recentEvent_data = array_values(array_unique($recentEvent_data));
										  
		if($adb->num_rows($query) == 0){
			$message = vtranslate('No event for this month','CTMobile'); 
			$response->setResult(array('GetEventCount'=>[],'date_format'=>$current_user->date_format,'hour_format'=>$current_user->hour_format,'module'=>'Events','code'=>404,'message'=>$message));
		} else {
			$response->setResult(array('GetEventCount'=>$recentEvent_data,'date_format'=>$current_user->date_format,'hour_format'=>$current_user->hour_format,'module'=>'Events', 'message'=>''));
		}
		
		return $response;
	}
}
