<?php
 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */
class CTMobile_WS_FetchModuleFilters extends CTMobile_WS_Controller {
	
	function process(CTMobile_API_Request $request) {
		$response = new CTMobile_API_Response();

		$module = trim($request->get('module'));
		if($module == 'Events'){
			$module = 'Calendar';
		}
		global $adb,$current_user;
		$current_user = $this->getActiveUser();
		
		$results = array();
		$filters = array();
		$AllFilters = CustomView_Record_Model::getAll($module);
		foreach ($AllFilters as $key => $filter) {
			$cvid = $filter->get('cvid');
			$viewname = $filter->get('viewname');
			$setdefault = $filter->get('setdefault');
			$setmetrics = $filter->get('setmetrics');
			$moduleName = $filter->get('entitytype');
			$status = $filter->get('status');
			$userid = $filter->get('userid');
			$userRecordModel = Users_Record_Model::getInstanceById($userid,'Users');
			$userName = $userRecordModel->get('first_name').' '.$userRecordModel->get('last_name');
			$CVRecordModel = CustomView_Record_Model::getInstanceById($cvid);
			if($CVRecordModel->isDefault()){
				$isDefault = 1;
			}else{
				$isDefault = 0;
			}
			$filters[] = array('cvid'=>$cvid,'viewname'=>$viewname,'setdefault'=>$setdefault,'setmetrics'=>$setmetrics,'moduleName'=>$moduleName,'userName'=>$userName,'isDefault'=>$isDefault);
		}

		/*$filters = $this->getModuleFilters($module, $current_user);

		$yours = array();
		$others= array();
		if(!empty($filters)) {
			foreach($filters as $filter) {
				if($filter['userName'] == $current_user->column_fields['user_name']) {
					$yours[] = $filter;
				} else {
					$others[]= $filter;
				}
			}
		}
		$filters = array_merge($yours,$others);
		$filter = $filters;
		foreach($filter as $key => $value){
			$filters[$key]['isDefault'] = 0;
			global $adb;
			$tabId = getTabid($module); 
			$result = $adb->pquery('SELECT default_cvid FROM vtiger_user_module_preferences WHERE userid = ? AND tabid = ?',
				array($current_user->id, $tabId));
			if($adb->num_rows($result) > 0) {
				$cvId = $adb->query_result($result, 0, 'default_cvid');
				if($cvId === $value['cvid']) {
					$filters[$key]['isDefault'] = 1;
				} else {
					$filters[$key]['isDefault'] = 0;
				}
			}
		}*/
		$results = $filters;
		if(count($filters) == 0){
			$results['code'] = 404;
			$results['message'] = vtranslate('LBL_NO_RECORDS_FOUND','Vtiger');
			$response->setResult($results);
		}else{
			$response->setResult(array('filters'=>$results));
		}

		return $response;
	}
}
