<?php
include_once('modules/Vtiger/CRMEntity.php');

class MFAuthorisation extends Vtiger_CRMEntity {

  public function vtlib_handler($moduleName, $eventType) {

    if ($eventType == 'module.postinstall') {

      $this->initialSettings();
      // $this->handlePackaged();
      $this->addFields();
      $this->setMenu();
    }
    elseif($eventType == 'module.postupdate') {

      // TODO Handle actions after this module is updated.
    } 
  }

  private function addFields()  {

    Vtiger_Utils::AddColumn('vtiger_users', 'ga_secret', 'varchar(255) DEFAULT NULL');
    Vtiger_Utils::AddColumn('vtiger_users', 'is_ga_enable', 'int(3) DEFAULT 0');
  }

  private function initialSettings() {

    global $adb;
  }

  private function setMenu() {

    global $adb;
  }

  private function handlePackaged() {

    $modulePath =  'modules/MFAuthorisation';

    $packagedFiles = array(
                      array('src' => 'UsersModelsDetailView.php',
                            'dst' => 'DetailView.php',
                            'path' => 'modules/Users/models/'
                      ),
                      array('src' => 'UsersModelsRecord.php',
                            'dst' => 'Record.php',
                            'path' => 'modules/Users/models/'
                      ),
                      array('src' => 'UsersActionsSaveAjax.php',
                            'dst' => 'SaveAjax.php',
                            'path' => 'modules/Users/actions/'
                      ),
                      array('src' => 'UsersActionsLogin.php',
                            'dst' => 'Login.php',
                            'path' => 'modules/Users/actions/'
                      ),
                      array('src' => 'GoogleAuthenticator.php',
                            'dst' => 'GoogleAuthenticator.php',
                            'path' => 'modules/Users/helpers/'
                      ),
                      array('src' => 'ConnectionsSetup.php',
                            'dst' => 'ConnectionsSetup.php',
                            'path' => 'modules/Users/helpers/'
                      ),
                      array('src' => 'UsersViewsLogin.php',
                            'dst' => 'Login.php',
                            'path' => 'modules/Users/views/'
                      ),
                      array('src' => 'UsersViewsEditAjax.php',
                            'dst' => 'EditAjax.php',
                            'path' => 'modules/Users/views/'
                      )
    );

    foreach($packagedFiles as $packagedFile) {

      // test if directory exists
      if (!file_exists($packagedFile['path'])) mkdir($packagedFile['path'], 0755, true);

      if (file_exists($packagedFile['path'] . $packagedFile['dst'])) {

        // check the hash
	$srcFile = $modulePath . '/packaged/' . $packagedFile['src'];
	$dstFile = $packagedFile['path'] . $packagedFile['dst'];

        // $sha1org = sha1_file('modules/MFAuthorisation/packaged/' . $packagedFile['src']);
	$sha1org = sha1(preg_replace('/\s+/', '', file_get_contents($srcFile)));

	// $sha1dst = sha1_file($packagedFile['path'] . $packagedFile['dst']);
        $sha1dst = sha1(preg_replace('/\s+/', '', file_get_contents($dstFile)));

        // no overwrite needed if hash is equal
        if ($sha1org == $sha1dst) continue;

        copy($packagedFile['path'] . $packagedFile['dst'], $packagedFile['path'] . $packagedFile['dst'] . '_before_' . date('Ymd'));
      }

      // ok to override
      $src = $modulePath . '/packaged/' . $packagedFile['src'];
      $dst = $packagedFile['path'] . $packagedFile['dst'];
      copy($src, $dst);
    }
  }
}
