<?php
require_once('config.php');
require_once('libraries/nusoap/nusoap.php');
require_once('include/utils/utils.php');

// replace by vtiger url from config
$URL       = $site_URL."wvaservice.php";
$namespace = $URL . '?wsdl';

$server = new soap_server;
$server->debug_flag = true;

// configureWSDL(); the method acts as a flag to tell the server to generate a WSDL file for our service.
// The first argument is the name of the service and the second is the namespace for our service.
$server->configureWSDL("wvaservice ",$namespace);

$server->wsdl->schemaTargetNamespace = $namespace;

/**
 * Class wva
 *
 * @link http://www.greenacorn-websolutions.com/php/working-with-nusoap.php
 * @link http://sourceforge.net/projects/nusoap/
 * @link http://stackoverflow.com/questions/18779953/how-to-deal-with-array-complextype-in-nusoap
 */
class wvaservice 
{
	// create the function 
	function getpicklist($fieldname) 
	{ 
		global $adb;
		
		// @todo soap_fault does not work! known issue!
		if(!$fieldname){ 
			return new soap_fault('Client','','Choose fieldname for picklist!');
		}
		
		$sql = "select vtiger_". $fieldname.".* from vtiger_". $fieldname;
		
		$result 	= $adb->pquery($sql, array());
		$numrows 	= $adb->num_rows($result);

		// @todo soap_fault does not work! known issue!		
		if($numrows == 0 || $result === false) {
			return new soap_fault('Server', '', "Field $fieldname Not found");
		}
		
		$rows = array();
		for($i=1;$i<=$numrows;$i++)
		{
			$row = $adb->fetch_array($result);
			$rows[] = array( 
				'id' => $row[$fieldname.'id'],
				'label' => $row[$fieldname],
				'presence' => $row['presence'],
				'valueid' => $row['picklist_valueid'],
				'sortorderid' => $row['sortorderid'],
			);
		}
		return array(
			'listname' => $fieldname."-".phpversion(),
			'values' => $rows,
		);
	}
	
	/**
	 *
	 * @return	soap	
	 */
	function getconfig($username, $password)
	{
		global $vtiger_current_version;
		global $default_timezone;
	
		return array(
			'timezone' => $default_timezone,
			'phpversion' => phpversion(),
			'vtigerversion' => $vtiger_current_version,
		);
	}	

}

$server->wsdl->addComplexType(
  'PicklistArray',
  'complexType',
  'array',
  '',
  'SOAP-ENC:Array',
  array(
    'id' => array('name' => 'id', 'type' => 'xsd:string'),
    'label' => array('name' => 'label', 'type' => 'xsd:string'),
    'presence' => array('name' => 'label', 'type' => 'xsd:int'),
    'valueid' => array('name' => 'label', 'type' => 'xsd:int'),
    'sortorderid' => array('name' => 'label', 'type' => 'xsd:int'),
  )
);

$server->wsdl->addComplexType(
  'Picklist',
  'complexType',
  'struct',
  'all',
  '',
  array(
    'listname' => array('name' => 'listname', 'type' => 'xsd:string'),
    'values' => array('name' => 'values', 'type' => 'tns:PicklistArray'),
  )
);

$server->wsdl->addComplexType(
  'Configlist',
  'complexType',
  'struct',
  'all',
  '',
  array(
	'timezone' => array('name' => 'timezone', 'type' => 'xsd:string'),
	'phpversion' => array('name' => 'phpversion', 'type' => 'xsd:string'),
	'vtigerversion' => array('name' => 'vtigerversion', 'type' => 'xsd:string'),   
  )
);

//register a function that works on server 
//$server->register('get_picklistvalues'); 
//register a function that works on server
$server->register("wvaservice.getpicklist",
		array("fieldname" => "xsd:string"),
		array("return" => "tns:Picklist"),
		$namespace."",
		$namespace."#getpicklist",
		"rpc",
		"enoded",
		"Get WVA picklist by fieldname");

//register a function that works on server 
//$server->register('get_picklistvalues'); 
//register a function that works on server
$server->register("wvaservice.getconfig",
		array('username' => 'xsd:string', 'password' => 'xsd:string'),
		array("return" => "tns:Configlist"),
		$namespace,
		$namespace."#getconfig",
		"rpc",
		"enoded",
		"Get config settings");

// create HTTP listener 
if ( !isset( $HTTP_RAW_POST_DATA ) )
	$HTTP_RAW_POST_DATA = file_get_contents( 'php://input' );
 // create HTTP listener  
$server->service($HTTP_RAW_POST_DATA);  

exit(); 
// eof