<?php
/*
 * dit bestand staat in de root van het crm systeem als vtshopwebservice.php
 *
 */
include('../crm/config.php');

$connector = mysqli_connect($dbconfig['db_server'], $dbconfig['db_username'], $dbconfig['db_password'], $dbconfig['db_name']);

// check connection
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}

$lvl1 = null;
$lvl2 = null;
$lvl3 = null;

if ($_POST && isset($_POST['q'])) $query = $_POST['q'];

if ($_POST && isset($_POST['lvl1'])) $lvl1 = $_POST['lvl1'];
if ($_POST && isset($_POST['lvl2'])) $lvl2 = $_POST['lvl2'];
if ($_POST && isset($_POST['lvl3'])) $lvl3 = $_POST['lvl3'];

if ($_POST && isset($_POST['c'])) $crmId = $_POST['c'];

$rows = null;

switch($query)
{
  case 1:
  {
    // first level must be defined
    $sql = "select distinct p.webcategory_lvl_1 as webcategory
            from vtiger_products p, vtiger_crmentity c
            where p.productid = c.crmid
            and c.deleted = 0
            and p.discontinued = 1
            and p.webproduct = 1
            and p.webcategory_lvl_1 is not null
            and p.webcategory_lvl_1 != ''
            and p.webcategory_lvl_1 != '--None--'";

    break;
  }

  case 2:
  {
    $sql = "select distinct p.webcategory_lvl_2 as webcategory
            from vtiger_products p, vtiger_crmentity c
            where p.productid = c.crmid
            and p.webcategory_lvl_1 = '%s'
            and c.deleted = 0
            and p.discontinued = 1
            and p.webproduct = 1";

    $sql = sprintf($sql, $lvl1);

    break;
  }

  case 3:
  {
    $sql = "select distinct p.webcategory_lvl_3 as webcategory
            from vtiger_products p, vtiger_crmentity c
            where p.productid = c.crmid
            and p.webcategory_lvl_1 = '%s'
            and p.webcategory_lvl_2 = '%s'
            and c.deleted = 0
            and p.discontinued = 1
            and p.webproduct = 1;";

    $sql = sprintf($sql, $lvl1, $lvl2);

    break;
  }

  case 4:
  {
    // @change lro added price
    $sql = "select c.description, p.productid as product_no, p.productname, p.usageunit, p.qty_per_unit, p.unit_price
            from vtiger_products p, vtiger_crmentity c
            where p.productid = c.crmid
            and p.webcategory_lvl_1 = '%s'
            and p.webcategory_lvl_2 = '%s'
            and p.webcategory_lvl_3 = '%s'
            and c.deleted = 0
            and p.discontinued = 1
            and p.webproduct = 1;";

    $sql = sprintf($sql, $lvl1, $lvl2, $lvl3);
    break;
  }

  case 5:
  {
    // first level must be defined
    $sql = "select c.description, p.productid as product_no, p.productname, p.usageunit, p.qty_per_unit, p.unit_price, p.productcode
            from vtiger_products p, vtiger_crmentity c
            where p.productid = c.crmid
            and c.deleted = 0
            and p.discontinued = 1
            and p.webproduct = 1
            and p.webcategory_lvl_1 is not null
            and p.webcategory_lvl_1 != ''
            and p.webcategory_lvl_1 != '--None--'";

    if ($lvl1 != null) $sql .= sprintf("\nand p.webcategory_lvl_1 = '%s'", $lvl1);
    if ($lvl2 != null) $sql .= sprintf("\nand p.webcategory_lvl_2 = '%s'", $lvl2);
    if ($lvl3 != null) $sql .= sprintf("\nand p.webcategory_lvl_3 = '%s'", $lvl3);

    $result = mysqli_query($connector, $sql);

    $rows = array();

    while($row = $result->fetch_array(MYSQLI_ASSOC))
    {
      $row['description'] = veb_getHTMLtext($row['description']);

      $rows[] = $row;
    }

    break;
  }

  case 6:
  {
    // not yet implemented
    include('../crm/modules/Accounts/nl_nl.lang.php');
    break;
  }

  case 7:
  {
    // not yet implemented
    include('../crm/languages/Contacts/nl_nl.lang.php');
    break;
  }

  case 8:
  {
    // not yet implemented
    include('../crm/modules/Products/language/nl_nl.lang.php');
    break;
  }

  case 9:
  {
    // get the labels for the dropdowns
    // @todo - take care of the translations !!!
    $sql = "select columnname, fieldlabel from vtiger_field where columnname in ('webcategory_lvl_1', 'webcategory_lvl_2', 'webcategory_lvl_3')";
    break;
  }

  case 100:
  {
    $sql = "SELECT a.accountname, cd.*, cf.*, ca.*, acf.*
	    FROM vtiger_contactdetails cd, vtiger_contactscf cf, vtiger_contactaddress ca, vtiger_crmentity c1, vtiger_crmentity c2, vtiger_account a, vtiger_accountscf acf
            WHERE cd.contactid = ca.contactaddressid
            AND cd.contactid = cf.contactid
            AND cd.contactid = c1.crmid
            AND c1.deleted = 0
            AND cd.contactid = %s
            AND cd.accountid = a.accountid
            AND a.accountid = c2.crmid
            AND c2.deleted = 0
            AND a.accountid = acf.accountid
           ";

    $sql = sprintf($sql, $crmId);
  }
}

if (!is_array($rows))
{
  $result = mysqli_query($connector, $sql);

  $rows = array();

  while($row = $result->fetch_array(MYSQLI_ASSOC))
  {
    // if ($query == 5) var_dump($row);
    $rows[] = $row;
  }
}

echo json_encode($rows);
exit();

function veb_getHTMLtext($text, $size = '12px', $renvooiTextBlock = FALSE, $headerText = "")
{
  global $renvooi;

  $text = utf8_encode($text);

  $style = 'font-size: '.$size;

  // first have real paragraphs
  if($text == '') 
  { 
    return '';
  }
  else
  {
    $newText = nl2br($text); 
  }

  $newText = str_ireplace('<br>','<br />',$newText);
  $newText = str_ireplace('<br/>','<br />',$newText);
  $newTextArray = explode('<br />',$newText);

  $ulBlockStarted = false;
  $ulBlockClosed = true;

  $olBlockStarted = false;
  $olBlockClosed = true;

  $newText = '';

  foreach ($newTextArray as $rowId => $textLine) 
  {
    $textLine = str_replace("\r\n","",$textLine);
    $textLine = str_replace("\n\r","",$textLine);
    $textLine = str_replace("\n","",$textLine);
    $textLine = str_replace("\r","",$textLine);

    if (substr($textLine,0,2) == "- ")
    {
      if (!$ulBlockStarted)
      {
        $newText .= '<ul style="list-style-position: outside; margin: 0 0 20px 20px;">'."\n";
      }

     $ulBlockStarted = true;
     $ulBlockClosed = false;
     $newText .= '<li style="'.$style.'">'.substr($textLine,2,strlen($textLine)-2)."</li>\n";
    }
    elseif (substr($textLine,0,1) == "-")
    {
      if (!$ulBlockStarted)
      {
        $newText .= '<ul style="list-style-position: outside; margin: 0 0 20px 20px;">'."\n";
      }

      $ulBlockStarted = true;
      $ulBlockClosed = false;
      $newText .= '<li style="'.$style.'">'.substr($textLine,1,strlen($textLine)-1)."</li>\n";

      // @change lro 150618 added for ol
    }
    elseif (substr($textLine,0,2) == "# ")
    {
      if (!$olBlockStarted)
      {
        $newText .= '<ol style="list-style-position: outside; margin: 0 0 20px 20px;">'."\n";
      }

      $olBlockStarted = true;
      $olBlockClosed = false;
      $newText .= '<li style="'.$style.'">'.substr($textLine,2,strlen($textLine)-2)."</li>\n";
    }
    elseif (substr($textLine,0,1) == "#")
    {
      if (!$olBlockStarted)
      {
        $newText .= '<ol style="list-style-position: outside; margin: 0 0 20px 20px;">'."\n";
      }

      $olBlockStarted = true;
      $olBlockClosed = false;
      $newText .= '<li style="'.$style.'">'.substr($textLine,1,strlen($textLine)-1)."</li>\n";
    }
    elseif (substr($textLine,0,2) == "<t" || substr($textLine,0,2) == "</" )
    {
      // probably a html table / or end command, so do't wrap the line in <p></p>
      $newText .= $textLine."\n";
    }
    else
    {
      if ($ulBlockStarted)
      {
        $newText .= "</ul>\n";
	$ulBlockClosed = true;
      }

      $ulBlockStarted = false; 

      if ($olBlockStarted)
      {
        $newText .= "</ol>\n";
	$olBlockClosed = true;
      }

      $olBlockStarted = false; 

      $newText .= '<p style="'.$style.'">'.$textLine."</p>\n";
    }
  }

  if (!$ulBlockClosed)
  {
    $newText .= "</ul>\n";
    $ulBlockClosed = true;
  }

  // @change lro 130325 add header in quote tekst. Use only for short / summary quotes !
  if ($newText && $headerText)
  {
    $newText = "<p><b>$headerText:</b></p>".$newText;
  }

  if ($renvooi)
  {
    if ($renvooiTextBlock)
    {
      $newText = "[>".$newText."<]";
    }
    else
    {
      $newText = "[START EIGEN TEKST]".$newText."[EINDE EIGEN TEKST]";
    }
  }

  return $newText;
}
