<?php
/**
 * xDate - Date tools class
 *
 * @package 000-Speakap
 * @subpackage Core
 * @version 2.0
 * @author daniel.mark@speakap.nl
 */
class xDate
{
  /**
   * xDate::TimeStamp2Str()
   *
   * @param string $DateTime
   * @param constant $DateFormat
   * @return
   */
  public static function TimeStamp2Str($DateTime, $DateFormat = dtShortDate)
  {
    return (($DateTime > - 2209032000000) || ($DateTime == 0)) ? date($DateFormat, $DateTime) : '';
  }

  /**
   * xDate::DMY2TimeStamp()
   *
   * @param string $DateStr
   * @return string
   */
  public static function DMY2TimeStamp($DateStr)
  {
    $Result = null;
    $DateStr = trim($DateStr);
    if (($DateStr != '') && ($DateStr != '1-1-1970'))
    {
      $Date = explode('-', $DateStr, 3);
      if (count($Date) == 3)
        $Result = "{$Date[2]}-{$Date[1]}-{$Date[0]}";
    }
    return ($Result == '0000-00-00 00:00:00') ? null : strtotime($Result);
  }

  /**
   * xDate::DMY2MySQL()
   *
   * @param string $DateStr
   * @param bool $AddTime
   * @return timestamp
   */
  public static function DMY2MySQL($DateStr, $AddTime = true)
  {
    $DateTime = xDate::DMY2TimeStamp($DateStr);
    return ($DateTime == null) ? null : xDate::TimeStamp2MySQL($DateTime, $AddTime);
  }

  /**
   * xDate::MySQL2TimeStamp()
   *
   * @param sting $MySQLDateStr
   * @return time
   */
  public static function MySQL2TimeStamp($MySQLDateStr)
  {
    return (($MySQLDateStr == '') || ($MySQLDateStr == '0000-00-00') || ($MySQLDateStr == '0000-00-00 00:00:00')) ?
     0 : strtotime($MySQLDateStr);
  }

  /**
   * xDate::MySQL2DMY()
   *
   * @param string $MySQLDateStr
   * @param constant $DateFormat
   * @return
   */
  public static function MySQL2DMY($MySQLDateStr, $DateFormat = dtShortDate)
  {
    $DateTime = xDate::MySQL2TimeStamp($MySQLDateStr);
    return ($DateTime != 0) ? date($DateFormat, $DateTime) : '';
  }

  /**
   * xDate::TimeStamp2MySQL()
   *
   * @param timestamp $Time
   * @param bool $AddTime
   * @return sting
   */
  public static function TimeStamp2MySQL($Time, $AddTime = true)
  {
    return ($Time == null) ? '' : date(($AddTime ? dtMySQLDateTime : dtMySQLDate), $Time);
  }
}
?>