<?php
/**
 * Security functions (Check, Encrypt, Password, etc.)
 *
 * @package 000-Speakap
 * @subpackage Core_Security
 * @version 2.0
 * @author daniel.mark@speakap.nl
 */

/**
 * Has_Group_Right()
 *
 * @param mixed $Right_ID
 * @param mixed $Group_ID
 * @return
 */
function Has_Group_Right($Right_ID, $Group_ID)
{
  $NwRole = xArray::Get_Array($_SESSION, 'Nw_Role', array());
  $SpeakapAdmin = xArray::Get_Bool($NwRole, 'isSpeakapAdmin', false, Err_No_Error) === true;
  $Role_Type_ID = xArray::Get_Int($NwRole, 'Role_Type_ID', null);
  if ($SpeakapAdmin || ($Role_Type_ID === grt_Admin))
    return true;

  $Grp_Roles = xArray::Get_Array($_SESSION, 'Grp_Roles', array());
  $Role = xArray::Get_Array($Grp_Roles, $Group_ID, array());
  $Role_Type_ID = xArray::Get_Int($Role, 'Role_Type_ID', null);
  $Right = ($Role_Type_ID === grt_Admin) ? true :
    xArray::Get_Bool($Role, 'R' . $Right_ID, false, Err_No_Error);
  return $Right;
}

/**
 * Has_Network_Right()
 *
 * @param mixed $Right_ID
 * @return
 */
function Has_Network_Right($Right_ID)
{
  $Role = xArray::Get_Array($_SESSION, 'Nw_Role', array());
  $SpeakapAdmin = xArray::Get_Bool($Role, 'isSpeakapAdmin', false, Err_No_Error) === true;
  $Role_Type_ID = xArray::Get_Int($Role, 'Role_Type_ID', null);
  $Right = ($SpeakapAdmin || ($Role_Type_ID === grt_Admin)) ? true :
    xArray::Get_Bool($Role, 'R' . $Right_ID, false, Err_No_Error);
  return $Right;
}

function SI_CanAccess($ThisUser_ID, $NwAdminRight, $GrpAdminRight, $AccessRight, $Share_Item)
{
  global $DB;
  $Access = $Share_Item['Shared_With_All'] == 1;
  $Access = ($Share_Item['from_User_ID'] == $ThisUser_ID) ? true : $Access;
  if ($Access !== true)
    if ($NwAdminRight !== false)
      $Access = Has_Network_Right($NwAdminRight);
  if ($Access !== true)
  {
    $SILs = str_replace(':NaN', ':null', $Share_Item['Share_Item_Links']);
    $SILs = str_replace(':NaN', ':""', $SILs);
    $SILs = json_decode('[' . $SILs . ']', true);
    foreach ($SILs as $Key => $SIL)
    {
      // If shared with user's network and user has (network) access
      if ($SIL['for_Network_ID'] == $DB->Network_ID)
        $Access = Has_Network_Right($AccessRight);

      // If Shared with This User, Access is granted
      if (($SIL['for_User_ID'] != '') && (intval($SIL['for_User_ID']) == $ThisUser_ID))
        $Access = true;

      // If Shared with Group And this user had read rights in this group
      if (($SIL['for_Group_ID'] != ''))
      {
        $Group_ID = xArray::Get_Int($SIL, 'for_Group_ID');
        if (Has_Group_Right($AccessRight, $Group_ID))
          $Access = true;
        elseif ($GrpAdminRight !== false)
          if (Has_Group_Right($GrpAdminRight, $Group_ID))
            $Access = true;
      }

      if ($Access)
        break;
    }
  }
  return $Access;
}

/**
 * xSecurity - Several security functions
 *
 * @author daniel.mark@speakap.nl
 */
class xSecurity
{
  /**
   * xSecurity::Unique_MD5()
   *
   * @return string
   */
  public static function Unique_MD5()
  {
    mt_srand(microtime(true) * 100000 + memory_get_usage(true));
    return md5(uniqid(mt_rand(), true));
  }

  public static function Get_Server_Key($ExtraSalt = '')
  {
    return xSecurity::Encrypt(time(), Server_Authentication_Salt . $ExtraSalt);
  }

  public static function Check_Server_Key($Key, $ExtraSalt = '')
  {
    $dKey = intval(xSecurity::Decrypt($Key, Server_Authentication_Salt . $ExtraSalt));
    return (($dKey - time()) < Max_ServerKey_Drift) && ((time() - $dKey) < Max_ServerKey_Drift);
  }

  public static function Hash_User_Password($Password, $Password_Salt)
  {
    $Result = crypt($Password, '$2a$11$' . $Password_Salt . '$');
    return $Result;
  }

  /**
   * xSecurity::New_Password_Salt()
   *
   * @return string
   */
  public static function New_Password_Salt()
  {
    $Result = xSecurity::Secure_Rand(40);
    return $Result;
  }

  /**
   * xSecurity::Secure_Rand()
   *
   * @param integer $Length - Nr. of bytes
   * @return string
   */
  public static function Secure_Rand($Length)
  {
    if (function_exists('openssl_random_pseudo_bytes'))
    {
      $rnd = openssl_random_pseudo_bytes($Length, $Strong);
      if ($Strong === true)
        return sha1($rnd);
    }
    $sha = '';
    $rnd = '';
    for ($i = 0; $i < $Length; $i++)
    {
      $sha = hash('sha256', $sha . mt_rand());
      $char = mt_rand(0, 62);
      $rnd .= chr(hexdec($sha[$char] . $sha[$char + 1]));
    }
    return sha1($rnd);
  }

  /**
   * xSecurity::GeneratePassword()
   *
   * @return string
   */
  public static function GeneratePassword()
  {
    $strength = 4;
    $length = 9;

    $vowels = 'aeuy';
    $consonants = 'bdghjmnpqrstvz';
    if ($strength & 1)
      $consonants .= 'BDGHJLMNPQRSTVWXZ';
    if ($strength & 2)
      $vowels .= "AEUY";
    if ($strength & 4)
      $consonants .= '23456789';
    if ($strength & 8)
      $consonants .= '@#$%';

    $password = '';
    $alt = time() % 2;
    for ($i = 0; $i < $length; $i++)
      if ($alt == 1)
      {
        $password .= $consonants[(mt_rand() % strlen($consonants))];
        $alt = 0;
      }
      else
      {
        $password .= $vowels[(mt_rand() % strlen($vowels))];
        $alt = 1;
      }
    return $password;
  }

  /**
   * xSecurity::Encrypt()
   *
   * @param string $string
   * @return EncryptiedString
   */
  public static function Encrypt($string, $salt = null)
  {
    global $DB;
    $PasswordSalt = ($salt != null) ? $salt : $DB->Get_Password_Salt();
    srand((double) microtime() * 1000000); //for sake of MCRYPT_RAND
    $key = md5($PasswordSalt); //to improve variance
    /* Open module, and create IV */
    $td = mcrypt_module_open('des', '','cfb', '');
    $key = substr($key, 0, mcrypt_enc_get_key_size($td));
    $iv_size = 8;
    $iv = mcrypt_create_iv($iv_size, MCRYPT_RAND);
    /* Initialize encryption handle */
    if (mcrypt_generic_init($td, $key, $iv) != -1)
    {
      /* Encrypt data */
      $c_t = mcrypt_generic($td, $string);
      mcrypt_generic_deinit($td);
      mcrypt_module_close($td);
      $c_t = $iv.$c_t;
      return base64_encode($c_t);
    } //end if
  }

  /**
   * xSecurity::Decrypt()
   *
   * @param string $string
   * @return DecryptedString
   */
  public static function Decrypt($string, $salt = null)
  {
    global $DB;
    $string = base64_decode($string);
    $PasswordSalt = ($salt != null) ? $salt : $DB->Get_Password_Salt();
    $key = md5($PasswordSalt); //to improve variance
    /* Open module, and create IV */
    $td = mcrypt_module_open('des', '','cfb', '');
    $key = substr($key, 0, mcrypt_enc_get_key_size($td));
    $iv_size = 8;
    $iv = substr($string,0,$iv_size);
    $string = substr($string,$iv_size);
    /* Initialize encryption handle */
    if (mcrypt_generic_init($td, $key, $iv) != -1)
    {
      /* Encrypt data */
      $c_t = mdecrypt_generic($td, $string);
      mcrypt_generic_deinit($td);
      mcrypt_module_close($td);
      return $c_t;
    } //end if
  }
}


?>