<?php
// Set timezone for all time functions to: Europe/Amsterdam
date_default_timezone_set('Europe/Amsterdam');

$Dummy = null;

// Set this var to true to log each SQL to FirePHP
$SQL2FirePHP = false;

$FilePath_To_ERP = '../../public_ftp/to_erp/';
$FilePath_To_ERP_Archive = '../../public_ftp/to_erp/archive/';
$FilePath_To_CRM = '../../public_ftp/to_crm/';
$FilePath_To_CRM_Archive = '../../public_ftp/to_crm/archive/';

require_once _php_lib . "general.php";
require_once _php_lib . "tMultiQuery.php";
require_once _php_lib . "tDateTools.php";
require_once _php_lib . "debug.php";
require_once _php_lib . "db.php";
require_once _php_lib . "xml.php";

class VosbaXMLElement extends SimpleXMLElement
{
  public function addChild($name, $value = null, $namespace = null)
  {
    $value = str_replace('&', '&amp;', $value);
    return parent::addChild($name, $value, $namespace);
  }
}

function Date_ymd2Timestamp($Input)
{
  $Year = intval(substr($Input, 0, 4));
  $Month = intval(substr($Input, 4, 2));
  $Day = intval(substr($Input, 6, 2));
  return mktime(0, 0, 0, $Month, $Day, $Year);
}

function Date_ymd2MySQL($Input)
{
  $Date = Date_ymd2Timestamp($Input);
  return date('Y-m-d', $Date);
}

function formatDecimals($value)
{
  return sprintf('%0.02f', $value);
}

