<?php
/**
 * General functions and objects
 *
 * @package 000-Speakap
 * @subpackage Core_General
 * @version 2.0
 * @author daniel.mark@speakap.nl
 */
require_once _php_lib . "constants.php";

/**
 * tBaseClass - Baseclass for all PHP classes. Adds properties with Get and / or Set methods
 *
 * @author daniel.mark@speakap.nl
 */
class tBaseClass extends stdClass
{
  protected $Properties = array();
  public function Add_Properties($Properties)
  {
    foreach ($Properties as $Key => $InitialValue)
    {
      if (isset($this->Properties[$Key]))
        throw new tSpeakap_Exception(Err_Class_Property_Exists);
      else
        $this->Properties[$Key] = $InitialValue;
    }
  }

  public function __set($PropertyName, $PropertyValue)
  {
    global $Debug;
    if (property_exists($this, $PropertyName) === true)
      $this->$PropertyName = $PropertyValue;
    if (method_exists($this, 'set_' . $PropertyName))
      call_user_func(array($this, 'set_' . $PropertyName), array($PropertyValue));
    else
    {
      if (!isset($this->Properties[$PropertyName]))
      {
        $Warning = sprintf('Set Class Parameter "%s" without initial declaration', $PropertyName);
        try
        {
          throw new tSpeakap_Warning($Warning);
        }
        catch (Exception $e)
        {
          FB::send($e);
          if (isset($Debug))
            $Debug->Log->VarDump('Speakap_Warning', $e, lol_PHP_Warning);
        }
      }
      $this->Properties[$PropertyName] = $PropertyValue;
    }
  }

  public function __get($PropertyName)
  {
    if (property_exists($this, $PropertyName) === true)
      return $this->$PropertyName;
    if (method_exists($this, 'get_' . $PropertyName))
      return call_user_func(array($this, 'get_' . $PropertyName));
    else
    {
      if (isset($this->Properties[$PropertyName]))
        return $this->Properties[$PropertyName];
      else
        throw new tSpeakap_Exception(Err_Undefined_Class_Property);
    }
  }

  public function __call($Method, $Args)
  {
    if (isset($this->Properties[$Method]))
      call_user_func_array($this->Properties[$Method], $Args);
    elseif (isset($this->$Method))
      call_user_func_array($this->$Method, $Args);
    else
      throw new tSpeakap_Exception(Err_Undefined_Class_Method);
  }
}

/** @example Anonymous Function With Closure
$Const = function ()
{
  $a = 5;
  $ReturnObject = new tBaseClass();
  $ReturnObject->MyFunc =
      function ($x) use ($a)
      {
        FB::send($a . $x, 'FuncTest');
      };  // OR
  $ReturnObject->Add_Properties(
    array(
      'MyFunc' => function ($x) use ($a)
      {
        FB::send($a . $x, 'FuncTest');
      }
    ));
  return $ReturnObject;
};
$a = $Const();
$a->MyFunc('bla');
*/

//--- String convert/encode/decode functions --------------------------------//
function XMLtoUTF8($Input)
{
  global $UTF8_Chars, $HTML_Codes;
  $Result = $Input;
  foreach ($UTF8_Chars as $Key => $Value)
    $Result = str_replace($HTML_Codes[$Key], $Value, $Result);
  $Result = str_replace('&amp;', '&', $Result);
  return $Result;
}

function UTF8toXML($Input)
{
  global $UTF8_Chars, $HTML_Codes;
  $Result = str_replace('&', '&amp;', $Input);
  foreach ($UTF8_Chars as $Key => $Value)
    $Result = str_replace($Value, $HTML_Codes[$Key], $Result);
  return $Result;
}
/** Strips last character (if half of UTF-8 dubbel char) from a UTF-8 string to avoid mid UTF-8 dubbel char cut off */
function UTF8_Safe_Substr($StripedString)
{
  $StripedString .= ' ';
  return utf8_encode(substr(utf8_decode($StripedString),0, strlen(utf8_decode($StripedString)) - 1));
}

function Safe_HTML($XMLText)
{
  global $Dummy;
  require_once path_XML_Parser;
  $XMLText = '<span>' . str_replace('&', '&amp;', $XMLText) . '</span>';
  $XMLText = str_replace('<br>', '<br />', $XMLText);
  $XMLf = new tXML_F($Dummy, 'root');
  $XMLf->ParseText($XMLText, 'UTF-8');
  $XMLText = $XMLf->FirstChild()->GetInnerXML(); //str_replace('&amp;', '&', $XMLf->FirstChild()->GetInnerXML());
  //FB::send($XMLText, 'Safe_HTML - $XMLText');
  return $XMLText;
}

/** Strips return codes and extra spaces (Only used in tests) */
function ReformatSQL($SQL)
{
  // Strips returns and extra spaces
  $SQL = str_replace("\r\n", '', $SQL);
  $SQL = str_replace("   ", ' ', $SQL);
  $SQL = str_replace("   ", ' ', $SQL);
  $SQL = str_replace("  ", ' ', $SQL);
  $SQL = str_replace("  ", ' ', $SQL);
  return $SQL;
}

function Format($Input, $Vars)
{
  $Result = $Input;
  $i = 1;
  foreach ($Vars as $VarNr => $Var)
  {
    $Result = str_replace('%' . $i, $Var, $Result);
    $i = $i + 1;
  }
  return $Result;
}

function Float2String($Value, $Decimals = 2, $Seperator = ',', $ThousandsSeperator = '', $BeforeDecimals = '')
{
  $Result = number_format($Value, $Decimals, $Seperator, $ThousandsSeperator);
  $Len = strlen(round($Value));
  $Result = substr($BeforeDecimals, $Len) . $Result;
  return $Result;
}

function FloatToEuro($Value, $Decimals=2)
{
  return '&euro;&nbsp;' . Float2String($Value, $Decimals);
}

function IPto3333($Input, $FillChr=' ')
{
  $IP = explode('.', $Input);
  for ($i = 0; $i < count($IP); $i++)
    $IP[$i] = substr($FillChr . $FillChr . $FillChr . $IP[$i], strlen($IP[$i]), 3);
  return implode('.', $IP);
}

/** Generate Random String **/
/** Like PHPs explode, but trims string of each element */
function TrimExplode($Seperator, $Text)
{
  $Result = explode($Seperator, $Text);
  for ($i = 0; $i < count($Result); $i++)
    $Result[$i] = trim($Result[$i]);
  return $Result;
}

/**
 * GetIfSet - Returns an array field if exists. Else it returns $Default
 *
 * @param Array $Array - The array
 * @param string $FieldName
 * @param mixed $Default
 * @return mixed
 */
function GetIfSet(&$Array, $FieldName, $Default = false)
{
  return isset($Array[$FieldName]) ? $Array[$FieldName] : $Default;
}

/**
 * xArray - Several general array function
 *
 * @author daniel.mark@speakap.nl
 */
class xArray
{
  /** Only add if the value [$TheValue] isn't already in the Array [$TheArray] */
  public static function AddUnique(&$TheArray, $TheValue)
  {
    return (!in_array($TheValue, $TheArray)) ? array_push($TheArray, $TheValue) : false;
  }

  /**
   * xArray::ValuesToInt (static) - Converts each of the values in the array to an Integer
   *
   * @param Array $Array - The array (Variable itself will be altered)
   * @return Boolean - True = Success
   */
  /*public static function ValuesToInt(&$Array)
  {
    return array_walk($Array,
      function (&$Value, $Key)
      {
        $Value = (int)$Value;
      });
  }*/

  /**
   * xArray::UnsetFields (static) - Unset some array keys of an array
   *
   * @param Array $Array - The array
   * @param String $Fields - Comma seperated string with array keys that should be unset
   * @return void
   */
  public static function UnsetFields(&$Array, $Fields)
  {
    $FieldsArray = explode(',', $Fields);
    foreach ($FieldsArray as $Field)
      unset($Array[trim($Field)]);
  }

  /**
   * xArray::UnsetValue (static) - Unset some array values of an array
   *
   * @param Array $Array - The array
   * @param Array $Values - Array of values that should be unset from the array
   * @return void
   */
  public static function UnsetValues(&$Array, $Values)
  {
    $Keys = array();
    if (count($Values) > 0)
      foreach ($Values as $Value)
        if (array_search($Value, $Array) !== false)
          $Keys[] = array_search($Value, $Array);
    if (count($Values) > 0)
      foreach ($Keys as $Key)
        unset($Array[$Key]);
  }

  /**
   * xArray::Clone_Fields (static) - Create new array, and copy specified array keys from original
   *
   * @param Array $Array - The original array
   * @param String $Fields - Comma seperated string with array keys that should be copied/cloned
   * @return Array - The clone Array
   */
  public static function Clone_Fields($Array, $Fields)
  {
    $Result = array();
    $FieldsArray = explode(',', $Fields);
    foreach ($FieldsArray as $Field)
    {
      $Field = trim($Field);
      if (array_key_exists($Field, $Array))
        $Result[$Field] = $Array[$Field];
    }
    return $Result;
  }

  /**
   * xArray::Clone_ExceptFields (static) - Create new array, and copy specified all except
   *   specified array keys from original
   *
   * @param Array $Array - The original array
   * @param String $Fields - Comma seperated string with array keys that should be ignored
   * @return Array - The clone Array
   */
  public static function Clone_ExceptFields($Array, $Fields)
  {
    $Result = array();
    $FieldsArray = explode(',', $Fields);
    foreach ($FieldsArray as $Key => $Value)
    {
      //$Field = trim($Field);
      if (!in_array($Key, $FieldsArray))
        $Result[$Key] = $Value;
    }
    return $Result;
  }

  public static function Diff($Array1, $Array2)
  {
    $Result = array();
    foreach ($Array1 as $Key => $Value1)
      if (($Value2 = GetIfSet($Array2, $Key, false)) !== false)
        if ($Value1 != $Value2)
          $Result[$Key] = $Value1;
    return $Result;
  }

  /** Get Integer value from array[key]. If Missing: Return Default value OR throw exception if false */
  public static function Get_Int($Array, $Key, $Default = false,
    $Missing_ErrorType = Err_Missing_Required_Array_Key)
  {
    return self::Get_Value($Array, $Key, vvt_Integer, $Default, $Missing_ErrorType);
  }

  /** Get String value from array[key]. If Missing: Return Default value OR throw exception if false */
  public static function Get_String($Array, $Key, $Default = false,
    $Missing_ErrorType = Err_Missing_Required_Array_Key)
  {
    return self::Get_Value($Array, $Key, vvt_String, $Default, $Missing_ErrorType);
  }

  /** Get Boolean value from array[key]. If Missing: Return Default value OR throw exception if false */
  public static function Get_Bool($Array, $Key, $Default = false,
    $Missing_ErrorType = Err_Missing_Required_Array_Key)
  {
    return self::Get_Value($Array, $Key, vvt_Boolean, $Default, $Missing_ErrorType);
  }

  /** Get Array from array[key]. If Missing: Return Default value OR throw exception if false */
  public static function Get_Array($Array, $Key, $Default = false,
    $Missing_ErrorType = Err_Missing_Required_Array_Key)
  {
    return self::Get_Value($Array, $Key, vvt_Array, $Default, $Missing_ErrorType);
  }

  /** Get value from array[key] >> Type cast to FieldType >> If Missing: Return Default value OR throw exception if false */
  public static function Get_Value($Array, $Key, $VariableValueType, $Default = false,
    $Missing_ErrorType = Err_Missing_Required_Array_Key)
  {
    if (isset($Array[$Key]))
      switch ($VariableValueType)
      {
        case vvt_Integer: return (int) $Array[$Key];
        case vvt_Boolean: return (boolean) $Array[$Key];
        case vvt_Float: return (float) $Array[$Key];
        case vvt_String: return (string) $Array[$Key];
        case vvt_Array: return (array) $Array[$Key];
        case vvt_Unset: return false;
        default: return $Array[$Key];
      }
    elseif ($Missing_ErrorType == Err_No_Error)
      return $Default;
    elseif ($Default === false)
      throw new tSpeakap_Exception($Missing_ErrorType);
    else return $Default;
  }
}

