<?php

require_once _php_lib . 'FirePHP/lib/FirePHPCore/FirePHP.class.php';
require_once 'FirePHP/lib/FirePHPCore/fb.php';
$firephp = FirePHP::getInstance(true);
$Last_MySQL_Query = '';
$Last_MySQL_Error = '';


if (debug_mode && !$Do_Echo)
{
  $firephp->registerErrorHandler(false);
  $firephp->registerExceptionHandler();
  $firephp->registerAssertionHandler(true, false);
}


//--- Exceptions ------------------------------------------------------------//
class tBase_Exception extends Exception
{
  public function __toString()
  {
    return __CLASS__ . "[{$this->code}]: {$this->message}\n";
  }
}

class tSpeakap_Warning extends tBase_Exception
{
  public function __construct($ErrorType = Err_No_Error, Exception $Previous = null)
  {
    //$BackTrace = debug_backtrace();
    //$BacktraceFile = '';
    /*if (is_array($BackTrace))
      foreach ($BackTrace as $Function)
        if (GetIfSet($Function, 'class') != 'tSpeakap_Warning')
        {
          $BacktraceFile .= " || {$Function['file']}[{$Function['line']}]";
          break;
        }*/
    $BacktraceFile = $this->getTraceAsString();
    $BacktraceFile = ($BacktraceFile == '') ? '' : ' || Backtrace: ' . $BacktraceFile;
    $Message = '' . $ErrorType . $BacktraceFile;
    $ErrorType = ($ErrorType == '') ? Err_General_Error : $ErrorType;
    $ErrorCodeArr = explode('_', $ErrorType);
    $ErrorCodeNr = isset($ErrorCodeArr[0]) ? intval($ErrorCodeArr[0]) : 0;
    parent::__construct($Message, $ErrorCodeNr, $Previous);
  }
}

class tSpeakap_Exception extends tBase_Exception
{
  public function __construct($ErrorType = Err_No_Error, Exception $Previous = null)
  {
    $BackTrace = debug_backtrace();
    $BacktraceFile = '';
    if (is_array($BackTrace))
      foreach ($BackTrace as $Function)
        if (GetIfSet($Function, 'class') != 'tSpeakap_Exception')
        {
          $BacktraceFile .= " || {$Function['file']}[{$Function['line']}]";
          break;
        }
    $BacktraceFile = ($BacktraceFile == '') ? '' : ' || Backtrace: ' . $BacktraceFile;
    //if (is_string($ErrorCode))
    $Message = '' . $ErrorType . $BacktraceFile;
    $ErrorType = ($ErrorType == '') ? Err_General_Error : $ErrorType;
    $ErrorCodeArr = explode('_', $ErrorType);
    $ErrorCodeNr = isset($ErrorCodeArr[0]) ? intval($ErrorCodeArr[0]) : 0;
    parent::__construct($Message, $ErrorCodeNr, $Previous);
  }
}

class tFileServer_Exception extends tSpeakap_Exception
{
}

class tSQL_Exception extends Exception
{
  public function __construct($ErrorType = Err_SQL_Error, $SQL = '', Exception $Previous = null)
  {
    global $Last_MySQL_Query, $Last_MySQL_Error;
    $BackTrace = debug_backtrace();
    $BacktraceFile = '';
    if (is_array($BackTrace))
      foreach ($BackTrace as $Function)
        if (GetIfSet($Function, 'class') == 'tDB')
          $BacktraceFile = " || Backtrace: {$Function['file']}[{$Function['line']}]";

    $Query = ($SQL == '') ? $Last_MySQL_Query : $SQL;
    $Query = str_replace("\r", ' ', $Query);
    $Query = str_replace("\n", ' ', $Query);
    $Query = str_replace('   ', ' ', $Query);
    $Query = str_replace('   ', ' ', $Query);
    $Query = trim(str_replace('  ', ' ', $Query));
    //$SQL = ($SQL == '') ? $Last_MySQL_Error : $SQL;
    $Message = "$Last_MySQL_Error - '$Query'{$BacktraceFile}";
    $ErrorType = ($ErrorType == '') ? Err_General_Error : $ErrorType;
    $ErrorCodeArr = explode('_', $ErrorType);
    $ErrorCodeNr = isset($ErrorCodeArr[0]) ? intval($ErrorCodeArr[0]) : 0;
    parent::__construct($Message, $ErrorCodeNr, $Previous);
  }

  public function __toString()
  {
    return __CLASS__ . ": {$this->message}\n";
  }
}

class tJSON_Exception extends Exception
{
  public function __construct($ErrorType = Err_No_Error, Exception $Previous = null)
  {
    global $Last_JSON_Function;
    //$BackTrace = debug_backtrace();
    $BacktraceFile = '';
/*    if (is_array($BackTrace))
      foreach ($BackTrace as $Function)
        if (GetIfSet($Function, 'class') == 'tModelDataSet')
          $BacktraceFile = " || Backtrace: {$Function['file']}[{$Function['line']}]";
*/
    $JSON = json_encode($Last_JSON_Function);
    $Message = "({$ErrorType}): $JSON{$BacktraceFile}";
    $ErrorType = ($ErrorType == '') ? Err_General_Error : $ErrorType;
    $ErrorCodeArr = explode('_', $ErrorType);
    $ErrorCodeNr = isset($ErrorCodeArr[0]) ? intval($ErrorCodeArr[0]) : 0;
    parent::__construct($Message, $ErrorCodeNr, $Previous);
  }

  public function __toString()
  {
    return __CLASS__ . "{$this->message}\n";
  }
}