<?php
/**
 * Connection to / function for database(s). tDB controls the database connection(s)
 *
 */

$DBs = array();

function DisconnectAll_DBs()
{
  global $DBs;
  foreach ($DBs as $DB)
    $DB->Disconnect();
}

/**
 * tDB
 *
 * @author dma@vicus.nl
 */
class tDB
{
  public $Read_Connection;
  public $Write_Connection;
  public $Chat_Connection;
  public $MemCache = false;
  public $Network_ID;
  public $Network_URL;
  public $User_ID = false;
  protected $NetworkSettings;

  /**
   * tDB::__construct()
   *
   * @param Array|Object $NS ->Network_URL ()
   * @param bool $NewConstructor
   * @return tDB
   */
  function __construct($NS)
  {
    global $DBs;
    $DBs[] = &$this;
    $this->NetworkSettings = $NS;
    $this->Network_ID = xArray::Get_Int($NS, 'Network_ID', null);
    // 'p:' .
    $this->Read_Connection = new mysqli($NS['Read_Server_Path'], $NS['Database_UserName'],
      $NS['Database_Password'], $NS['Database_Name'], $NS['Read_Server_Port']) or
      die('Unable to connect to database server');
    $this->Read_Connection->set_charset('utf8');
    $Link1 = $this->Read_Connection->select_db($NS['Database_Name']);
    if (!$Link1)
    {
      FB::send($NS);
      die('Not connected(1): ' . $NS['Database_Name']);
    }

    // 'p:' .
    $this->Write_Connection = new mysqli($NS['Write_Server_Path'], $NS['Database_UserName'],
      $NS['Database_Password'], $NS['Database_Name'], $NS['Write_Server_Port']) or
      die('Unable to connect to database server');
    $this->Write_Connection->set_charset('utf8');
    $Link2 = $this->Write_Connection->select_db($NS['Database_Name']);
    if (!$Link2)
    {
      FB::send($NS);
      die('Not connected(2): ' . $NS['Database_Name']);
    }
  }

  /**
   * tDB::Disconnect()
   *
   * @return void
   */
  public function Disconnect()
  {
    if ($this->Write_Connection)
      $this->Write_Connection->close();
    if ($this->Read_Connection)
      $this->Read_Connection->close();
  }

  /**
   * tDB::Change_DB()
   *
   * @param string $Database_Name
   * @return void
   */
  public function Change_DB($Database_Name)
  {
    $this->Write_Connection->select_db($Database_Name);
    $this->Read_Connection->select_db($Database_Name);
  }

  /**
   * tDB::SQL_Escape()
   *
   * @param mixed $Value
   * @param bool $OnReadConnection
   * @return string
   */
  public function SQL_Escape($Value, $OnReadConnection = true)
  {
    return $OnReadConnection ? $this->Read_Connection->escape_string($Value) :
      $this->Write_Connection->escape_string($Value);
  }

  /**
   * tDB::SQLStr_Escape()
   *
   * @internal param string $SQL - Works like sprintf @see http://php.net/manual/en/function.sprintf.php
   * @internal param $mixed Args_1, Args_2, Args_n
   * @return string
   */
  public function SQLStr_Escape(/* $SQL, Args_1, Args_2, ... Args_n */)
  {
    $Arguments = func_get_args();
    foreach ($Arguments as $Key => &$Arg)
    if ($Key > 0)
      $Arg = $this->SQL_Escape($Arg);
    $SQL = call_user_func_array('sprintf', $Arguments);
    return str_replace('%', '%%', $SQL);  // Replace % by %% to escape for the next sprintf (e.g. by SQL_Select function)
  }

  public function Get_Token_Salt()
  {
    return $this->NetworkSettings['Token_Salt'];
  }

  public function Get_Password_Salt()
  {
    return $this->NetworkSettings['Password_Salt'];
  }

  public function Get_DB_Pass()
  {
    return $this->NetworkSettings['Database_Password'];
  }
  /**
   * tDB::Ping()
   *
   * @param mysqli $Connection
   * @return Bool
   */
  protected function Ping($Connection)
  {
    return $Connection->ping();
  }

/* --- New SQL functions ----------------------------------------------------------------------- */
  /**
   * tDB::SQL_Select()
   *
   * @internal param string $SQL - Works like sprintf @see http://php.net/manual/en/function.sprintf.php
   * @internal param mixed Args1, Args2...
   * @return tReadDataSet
   */
  public function SQL_Select(/* $SQL, Arg1, Arg2 ...*/)
  {
    global $SQL2FirePHP;
    $Arguments = func_get_args();
    foreach ($Arguments as $Key => &$Arg)
    if ($Key > 0)
      $Arg = $this->SQL_Escape($Arg);
    $SQL = call_user_func_array('sprintf', $Arguments);
    if ($SQL2FirePHP)
      FB::send($SQL, 'DB::SQL_Select');
    return new tReadDataSet($this, $SQL);
  }

  /**
   * tDB::SQL_Select_WDB() - Like SQL_Select but on Write connection
   *
   * @internal param string $SQL - Works like sprintf @see http://php.net/manual/en/function.sprintf.php
   * @internal param mixed Args1, Args2...
   * @return tReadDataSet
   */
  public function SQL_Select_WDB(/* $SQL, Arg1, Arg2 ...*/)
  {
    global $SQL2FirePHP;
    $Arguments = func_get_args();
    foreach ($Arguments as $Key => &$Arg)
    if ($Key > 0)
      $Arg = $this->SQL_Escape($Arg);
    $SQL = call_user_func_array('sprintf', $Arguments);
    if ($SQL2FirePHP)
      FB::send($SQL, 'DB::SQL_Select');
    return new tReadDataSet($this, $SQL, true);
  }

  /**
   * tDB::SQL_Insert()
   *
   * @param string $TableName
   * @param array $Fields (Field => Value, ...)
   * @throws tSQL_Exception
   * @return int
   */
  public function SQL_Insert($TableName, $Fields)
  {
    global $SQL2FirePHP, $Last_MySQL_Query, $Last_MySQL_Error;
    $Last_MySQL_Error = '';

    // Convert and SQL Escape field values
    $FieldTypes = $this->Get_FieldTypes($TableName, false);
    foreach ($Fields as $Field => $Value)
      $Fields[$Field] = $this->Convert_4_SQL_Write($Value, $FieldTypes[$Field]);

    $ValueStr = implode(', ', array_values($Fields));

    // SQL Escape field names
    $FieldNames = array_keys($Fields);
    foreach ($FieldNames as $Key => $FieldName)
      $FieldNames[$Key] = $this->SQL_Escape($FieldName);
    $FieldStr = implode(', ', array_keys($Fields));

    // Execute Insert
    $Last_MySQL_Query = "INSERT INTO $TableName ($FieldStr) VALUES ($ValueStr)";
    if (count($Fields) < 1)
      throw new tSQL_Exception(Err_SQL_Insert__NoFieldsToInsert, $Last_MySQL_Query);

    if ($SQL2FirePHP)
      FB::send($Last_MySQL_Query, 'DB::SQL_Insert');

    if (($Result = $this->Write_Connection->query($Last_MySQL_Query)) !== false)
      $Result = $this->Write_Connection->insert_id;
    else
    {
      $Last_MySQL_Error = $this->Write_Connection->error;
      throw new tSQL_Exception(Err_SQL_Error);
    }
    return $Result;
  }

  /**
   * tDB::SQL_UpdateOrInsert()
   *
   * @param string $TableName
   * @param array $Fields (Field => Value, ...)
   * @param string $UpdateExcludeFields Fieldnames ('FieldName,FieldName') that should be excluded in UPDATE statement
   * @param string $PrimaryKey Fieldname of Primarykey (or any other field) from TABLE[$TableName]
   * @param string $WhereSQL Condition when to UPDATE, or when Not to INSERT
   *    - Works like sprintf
   * @throws tSQL_Exception
   * @see http://php.net/manual/en/function.sprintf.php
   * @internal param mixed $Arg_1 , ... $Arg_n Values to be used (after escape) in $WhereSQL
   * @return int
   */
  public function SQL_UpdateOrInsert($TableName, $Fields, $UpdateExcludeFields, $PrimaryKey,
    $WhereSQL /*, $Arg_1, ... $Arg_n */)
  {
    global $SQL2FirePHP, $Last_MySQL_Query, $Last_MySQL_Error;
    $Last_MySQL_Error = '';

    // Escape WhereSQL Params
    $WhereArgs = array($WhereSQL);
    $Arguments = func_get_args();
    foreach ($Arguments as $Key => &$Arg)
    if ($Key > 4)
      $WhereArgs[] = $this->SQL_Escape($Arg);
    $WhereSQL = call_user_func_array('sprintf', $WhereArgs);

    // Escape Fields
    if (count($Fields) < 1)
      throw new tSQL_Exception(Err_SQL_Update__NoFieldsToUpdate, "UPDATE $TableName SET WHERE $WhereSQL");
    $UpdateFields = array();
    $InsertFields = array();
    $FieldTypes = $this->Get_FieldTypes($TableName, false);


    foreach ($Fields as $Field => $Value)
    {
      $FieldValue = $this->Convert_4_SQL_Write($Value, $FieldTypes[$Field]);
      $UpdateFields[$Field] = "$Field = $FieldValue";
      $InsertFields[$Field] = $FieldValue;
    }

    xArray::UnsetFields($UpdateFields, $UpdateExcludeFields);

    // Build Update / Insert Query
    $FieldNames = implode(', ', array_keys($InsertFields));
    $FieldValues = implode(', ', $InsertFields);
    $UpdateFieldsStr = implode(', ', $UpdateFields);
    $Last_MySQL_Query = "START TRANSACTION;
  UPDATE $TableName SET $UpdateFieldsStr WHERE ($WhereSQL);
  INSERT INTO $TableName ($FieldNames)
    SELECT $FieldValues FROM $TableName T1 WHERE NOT EXISTS(
      SELECT $PrimaryKey FROM $TableName T2 WHERE $WhereSQL ORDER BY T2.$PrimaryKey)
     LIMIT 1;
  COMMIT;";

    if ($SQL2FirePHP)
      FB::send($Last_MySQL_Query, 'DB::SQL_UpdateOrInsert');

    if (($Result = $this->Write_Connection->multi_query($Last_MySQL_Query)) == false)
    {
      FB::send($Result, 'Result is false!');
      //$Result = $this->Write_Connection->insert_id();
      $Last_MySQL_Error = $this->Write_Connection->error;
      throw new tSQL_Exception(Err_SQL_Error);
    }
    else
    {
      // After Multiquery, result must be cleared before next SQL command
      do
      {
        if ($Result = $this->Write_Connection->store_result())
          $Result->free();
      }
      while ($this->Write_Connection->more_results() && $this->Write_Connection->next_result());
      //FB::send($Result, 'Result is niet false!');
      //$Last_MySQL_Error = $this->Write_Connection->error;
      //throw new tSQL_Exception(Err_SQL_Error);
    }
    return $Result;
  }

  /**
   * tDB::SQL_Update()
   *
   * @param string $TableName
   * @param array $Fields
   * @param string $WhereSQL - Works like sprintf @see http://php.net/manual/en/function.sprintf.php
   * @throws tSQL_Exception
   * @internal param $mixed Args1, Args2...
   * @return bool
   */
  public function SQL_Update($TableName, $Fields, $WhereSQL /*, Arg1, Arg2 ...*/)
  {
    global $SQL2FirePHP, $Last_MySQL_Query, $Last_MySQL_Error;
    $Last_MySQL_Error = '';

    // Escape Where string
    $Arguments = func_get_args();
    $WhereArgs = array($WhereSQL);
    foreach ($Arguments as $Key => &$Arg)
    if ($Key > 2)
      $WhereArgs[] = $this->SQL_Escape($Arg);
    $WhereSQL = call_user_func_array('sprintf', $WhereArgs);

    // Escape Fields
    $First = true;
    $FieldsStr = "";
    $FieldTypes = $this->Get_FieldTypes($TableName, false);
    foreach ($Fields as $Field => $Value)
    {
      $FieldValue = $this->Convert_4_SQL_Write($Value, $FieldTypes[$Field]);
      $FieldsStr .= (!$First) ? ", " : '';
      $FieldsStr .= "$Field = $FieldValue";
      $First = false;
    }

    // Execute Update
    $Last_MySQL_Query = "UPDATE $TableName SET $FieldsStr WHERE ($WhereSQL)";
    if (count($Fields) < 1)
      throw new tSQL_Exception(Err_SQL_Update__NoFieldsToUpdate, $Last_MySQL_Query);

    if ($SQL2FirePHP)
      FB::send($Last_MySQL_Query, 'DB::SQL_Update');

    if (($Result = $this->Write_Connection->multi_query($Last_MySQL_Query)) == false)
    {
      $Last_MySQL_Error = $this->Write_Connection->error;
      throw new tSQL_Exception(Err_SQL_Error);
    }
    return $Result;
  }

  /**
   * tDB::SQL_Delete()
   *
   * @param string $TableName
   * @param string $WhereSQL - Works like sprintf @see http://php.net/manual/en/function.sprintf.php
   * @throws tSQL_Exception
   * @internal param mixed Args1, Args2, ...
   * @return bool
   */
  public function SQL_Delete($TableName, $WhereSQL /*, Arg1, Arg2 ...*/)
  {
    global $SQL2FirePHP, $Last_MySQL_Query, $Last_MySQL_Error;
    $Last_MySQL_Error = '';

    $Arguments = func_get_args();
    $WhereArgs = array($WhereSQL);
    foreach ($Arguments as $Key => &$Arg)
    if ($Key > 1)
      $WhereArgs[] = $this->SQL_Escape($Arg);
    $WhereSQL = call_user_func_array('sprintf', $WhereArgs);

    $Last_MySQL_Query = "DELETE FROM {$TableName} WHERE {$WhereSQL};";

    if ($SQL2FirePHP)
      FB::send($Last_MySQL_Query, 'DB::SQL_Delete');

    if (($Result = $this->Write_Connection->multi_query($Last_MySQL_Query)) == false)
    {
      $Last_MySQL_Error = $this->Write_Connection->error;
      throw new tSQL_Exception(Err_SQL_Error);
    }
    return $Result;
  }


/* --- Old SQL functions ----------------------------------------------------------------------- */
  /**
   * tDB::ExecuteMultiInsert()
   *
   * @param string $TableName
   * @param array $Rows
   * @param bool $Print_Query
   * @param bool $ReturnSQL
   * @throws tSQL_Exception
   * @return mixed
   */
  public function ExecuteMultiInsert($TableName, $Rows, $Print_Query = false, $ReturnSQL = false)
  {
    global $Last_MySQL_Query, $Last_MySQL_Error;
    $Last_MySQL_Error = '';
    $Fields = array();
    foreach($Rows as $Row)
      foreach ($Row as $FieldName => $Field)
        xArray::AddUnique($Fields, $FieldName);
    $FieldStr = implode(', ', $Fields);
    $FieldTypes = $this->Get_FieldTypes($TableName, false);
    $Last_MySQL_Query = "INSERT INTO $TableName ($FieldStr) VALUES ";
    $FirstRow = true;
    foreach ($Rows as $Row)
    {
      $Last_MySQL_Query .= $FirstRow ? '(' : ', (';
      $FirstField = true;
      foreach ($Fields as $Field)
      {
        $FieldValue = $this->Convert_4_SQL_Write(GetIfSet($Row, $Field, null), $FieldTypes[$Field]);
        $Last_MySQL_Query .= $FirstField ? $FieldValue : ", {$FieldValue}";
        $FirstField = false;
      }
      $Last_MySQL_Query .= ')';
      $FirstRow = false;
    }

    // Query done. Mow Execute, Return or Output
    $Result = false;
    if ($Print_Query)
      print_r($Last_MySQL_Query);
    elseif ($ReturnSQL)
      $Result = $Last_MySQL_Query;
    elseif (($Result = $this->Write_Connection->query($Last_MySQL_Query)) !== false)
      $Result = $this->Write_Connection->insert_id;
    else
    {
      $Last_MySQL_Error = $this->Write_Connection->error;
      throw new tSQL_Exception(Err_SQL_Error);
    }
    return $Result;
  }

  /**
   * tDB::ExecuteDuplicate()
   *
   * @param string $TableName
   * @param array $Fields
   * @param bool $Print_Query
   * @param bool $ReturnSQL
   * @throws tSQL_Exception
   * @return mixed
   */
  public function ExecuteDuplicate($TableName, $Fields, $Print_Query = false, $ReturnSQL = false)
  {
    global $Last_MySQL_Query, $Last_MySQL_Error;
    $Last_MySQL_Error = '';
    $First = true;
    $FieldStr = implode(', ', array_keys($Fields));
    $ValueStr = "";
    $DuplicateString = "";
    $FieldTypes = $this->Get_FieldTypes($TableName, false);
    foreach ($Fields as $Field => $Value)
    {
      $FieldValue = $this->Convert_4_SQL_Write($Value, $FieldTypes[$Field]);
      $ValueStr .= (!$First) ? ", {$FieldValue}" : $FieldValue;
      $DuplicateString .= (!$First) ? ", {$Field} = {$FieldValue}" : "$Field = $FieldValue";
      $First = false;
    }
    $Last_MySQL_Query = "INSERT INTO $TableName ($FieldStr) VALUES ($ValueStr) ON DUPLICATE KEY UPDATE $DuplicateString";
    $Result = false;
    if ($Print_Query)
      print_r($Last_MySQL_Query);
    elseif ($ReturnSQL)
      $Result = $Last_MySQL_Query;
    elseif (($Result = $this->Write_Connection->query($Last_MySQL_Query)) !== false)
      $Result = $this->Write_Connection->insert_id;
    else
    {
      $Last_MySQL_Error = $this->Write_Connection->error;
      throw new tSQL_Exception(Err_SQL_Error);
    }
    return $Result;
  }

  /**
   * tDB::Execute_Multi_Query()
   *
   * @param string $SQL
   * @param bool $OnWriteDB
   * @param bool $Print_Query
   * @return mixed
   */
  public function Execute_Multi_Query($SQL, $OnWriteDB = true, $Print_Query = false)
  {
    global $Last_MySQL_Query;
    $Last_MySQL_Query = $SQL;
    $Conn = $OnWriteDB ? $this->Write_Connection : $this->Read_Connection;
    if ($Print_Query)
      print_r($SQL);
    else
      return $Conn->multi_query($SQL);
    return false;
  }

/* --- END: Old SQL functions ------------------------------------------------------------------ */

  /**
   * tDB::Get_FieldTypes()
   *
   * @param string $TableName
   * @param bool $FlushMemCache
   * @return bool/array
   */
  public function Get_FieldTypes($TableName, $FlushMemCache = false)
  {
    $Result = false;
    switch ($this->Network_ID)
    {
      case dsn_Speakap_Server: $DBType = 'Speakap'; break;
      case dsn_Sync_Server: $DBType = 'Sync'; break;
      case dsn_Chat_Server: $DBType = 'Chat'; break;
      case dsn_File_Server: $DBType = 'File'; break;
      case dsn_LocalDB_Server: $DBType = 'Local'; break;
      default: $DBType = 'Network';
    }
    if (class_exists('Memcache') && ($FlushMemCache == false) && is_object($this->MemCache))
    {
      $Table = $this->MemCache->get(sprintf(mc_DB_Fields_FieldName, $DBType, $TableName));
      $Result = ($Table != '') ? $Table : false;
    }
    if (!$Result)
    {
      $Result = array();
      $ds_Table = $this->SQL_Select("SELECT * FROM $TableName LIMIT 1");
      $Fields = $ds_Table->Resource->fetch_fields();
      foreach ($Fields as $Field)
        $Result[$Field->name] = $Field->type;
      if (class_exists('Memcache') && is_object($this->MemCache))
        $this->MemCache->set(sprintf(mc_DB_Fields_FieldName, $DBType, $TableName), $Result,
          mc_DB_Fields_Compress, mc_DB_Fields_Expire);
    }
    return $Result;
  }

  /**
   * tDB::Convert_4_SQL_Write()
   *
   * @param string $FieldValue
   * @param integer $FieldType
   * @return mixed
   */
  public function Convert_4_SQL_Write($FieldValue, $FieldType)
  {
    if ($FieldValue === null)
      return 'null';
    else
    {
      $Value = "'" . mysqli_real_escape_string($this->Write_Connection, (string)$FieldValue) . "'";
      switch ($FieldType)
      {
        case mft_Date:
          $Value = xDate::DMY2MySQL($FieldValue, false);
          $Value = ($FieldValue === null) ? 'null' : "'" . mysqli_real_escape_string($this->Write_Connection, (string)$Value) . "'";
          break;

        case mft_DateTime:
          $Value = ($FieldValue == '0000-00-00 00:00:00') ? 'null' : "'" .
            mysqli_real_escape_string($this->Write_Connection, $FieldValue) . "'";
          break;

        case mft_BigInt:
          $Value = preg_replace ('/[^0-9]/', '', $Value);
          break;
        case mft_TimeStamp:
          if ($FieldValue === -1)
            $Value = 'CURRENT_TIMESTAMP';
          elseif ($FieldValue === -2)
            $Value = '(CURRENT_TIMESTAMP - 1)';
          elseif ($FieldValue === 1)
            $Value = '(CURRENT_TIMESTAMP + 1)';
          else
            $Value = intval($Value);
          break;
        case mft_TinyInt:
        case mft_SmallInt:
        case mft_Integer:
        case mft_MediumInt: // No quotes
          $Value = intval($FieldValue);
          break;

        default:
          $Value = "'" . mysqli_real_escape_string($this->Write_Connection, (string)$FieldValue) . "'";
      }
      return $Value;
    }
  }


  /**
   * tDB::Copy_Table()
   *
   * @param string $Table_Name
   * @param string $Source_DB_Name
   * @param mysqli $Root_Conn
   * @param string $Target_DB_Name
   * @return MySQLi result set
   */
  public function Copy_Table($Table_Name, $Source_DB_Name, $Target_DB_Name, $Root_Conn)
  {
    global $Last_MySQL_Query;
    $Last_MySQL_Query = "CREATE TABLE $Target_DB_Name.$Table_Name LIKE $Source_DB_Name.$Table_Name";
    mysqli_query($Root_Conn, $Last_MySQL_Query);
    $Last_MySQL_Query = "INSERT INTO $Target_DB_Name.$Table_Name SELECT * FROM $Source_DB_Name.$Table_Name";
    return $Root_Conn->query($Last_MySQL_Query);
  }

  /**
   * tDB::Copy_Procedure()
   *
   * @param string $Procedure_Name
   * @param object $Source_DB_Name
   * @param string $Target_DB_Name
   * @param mysqli $Source_Conn
   * @param mysqli $Target_Conn
   * @internal param object $Root_Conn
   * @return MySQLi result set
   */
  public function Copy_Procedure($Procedure_Name, $Source_DB_Name, $Target_DB_Name, $Source_Conn, $Target_Conn)
  {
    global $Last_MySQL_Query;
    $Last_MySQL_Query = "SHOW CREATE FUNCTION $Source_DB_Name.$Procedure_Name";
//    return $Last_MySQL_Query;
    $result = $Source_Conn->query($Last_MySQL_Query);
    if ($row = $result->fetch_array())
    {
      //xLog::JSON('MySQL SHOW Create Function', $row, lot_New, lca_Network);
      mysqli_select_db($Target_Conn, $Target_DB_Name);
      $Last_MySQL_Query = $row['Create Function'];
      return $Target_Conn->query($Last_MySQL_Query);
    }
    else
    {
      return false;
    }
  }

  //--- Static Methods ------------------------------------------------------//
  //-------------------------------------------------------------------------//
  /**
   * tDB::Get_DB_Local() (Static) function creates new tDB object for Connection to local Database
   *
   * @return tDB - Connection to local Database
   */
  public static function Get_DB_Local()
  {
    global $DB_Local, $ns_Local;
    if ($DB_Local === false)
      $DB_Local = new tDB($ns_Local, true);
    return $DB_Local;
  }

  /**
   * tDB::Get_SpeakapServer_DB() (Static) function creates new tDB object for Connection to Speakap Server Database
   *
   * @return tDB - Connection to Speakap Server Database
   */
  public static function Get_SpeakapServer_DB()
  {
    global $db_General, $ns_SpeakapServer;
    if (!$db_General)
      $db_General = new tDB($ns_SpeakapServer, true);
    return $db_General;
  }

  /**
   * tDB::Get_Network_DB() (Static) function creates new tDB object for Connection to a Network Database
   *
   * @param mixed $SubDomain
   * @param mixed $DB
   * @return tDB - Connection to the Network Database
   */
  public static function Get_Network_DB($SubDomain, &$DB)
  {
    global $MemCache;

    $DB = false;
    $Network_DB_Settings = $MemCache->Get_Key(sprintf(mc_Network_Server_FieldName, $SubDomain),
      'tDB::Get_Network_DB_Fallback', array($SubDomain), mc_Network_Server_Compress, mc_Network_Server_Expire);
    $DB = new tDB($Network_DB_Settings, true);
    return $DB;
  }

  /**
   * tDB::Get_Network_DB_Fallback()
   *
   * @param mixed $SubDomain
   * @return array
   */
  public static function Get_Network_DB_Fallback($SubDomain)
  {
    global $db_General;
    $db_General = tDB::Get_SpeakapServer_DB();
    $SubDomain = $db_General->SQL_Escape($SubDomain);
    $ds_Network = $db_General->SQL_Select("
    SELECT
      N.Network_ID, N.Password_Salt, N.Token_Salt,
      D.Database_UserName, D.Database_Password, D.Database_Name,
      S.Read_Server_Path, S.Read_Server_Port,
      S.Write_Server_Path, S.Write_Server_Port
    FROM
      net_Network N
        LEFT JOIN net_Network_Database D ON (D.Network_ID = N.Network_ID)
        LEFT JOIN net_Database_Server S ON (S.Database_Server_ID = D.Database_Server_ID)
    WHERE
      (N.SubDomain LIKE '%s')", $SubDomain);
    if (($Network_DB_Settings = $ds_Network->Fetch_Array()) == false)
    {
      FB::send($SubDomain, 'Subdomain not found in network list');
      die('Unknown network');
    }

    $Network_DB_Settings['Database_Password'] = xSecurity::Decrypt(base64_decode(
      $Network_DB_Settings['Database_Password']), "c7e84bf496c521b70e077a2f400e6a70");
    return $Network_DB_Settings;
  }

  /**
   * tDB::Get_SyncServer_DBs() (Static) function creates new tDB object for Connection to SyncServer Database
   *
   * @return tDB - Connection to SyncServer Database
   */
  public static function Get_SyncServer_DBs()
  {
    global $DB_Sync, $MemCache;
    $Sync_Server = $MemCache->Get_Key(mc_Sync_Server_FieldName, 'tDB::Get_SyncServer_DBs_Fallback',
      array(), mc_Sync_Server_Compress, mc_Sync_Server_Expire);
    $Sync_Server['Database_Password'] = xSecurity::Decrypt(base64_decode(
      $Sync_Server['Database_Password']), "c7e84bf496c521b70e077a2f400e6a70");
    $DB_Sync = new tDB($Sync_Server, true);
    return $DB_Sync;
  }

  /**
   * tDB::Get_SyncServer_DB_Fallback()
   *
   * @throws tSpeakap_Exception
   * @return mixed
   */
  public static function Get_SyncServer_DBs_Fallback()
  {
    $db_General = tDB::Get_SpeakapServer_DB();
    $Sync_Servers = false;
    $ds_SyncServers = $db_General->SQL_Select("SELECT * FROM net_Sync_Server ORDER BY From_Network_ID");
    while ($row = $ds_SyncServers->Fetch_Array())
      $Sync_Servers[$row['Sync_Server_ID']] = $row;

    if (!$Sync_Servers)
      throw new tSpeakap_Exception(Err_SSS_No_SyncServers_Found);

    $Sync_Server = $Sync_Servers[1]; // TODO: Temp
    //FB::send($Sync_Servers);
    $Sync_Server['Network_ID'] = dsn_Sync_Server;
    return $Sync_Server;
  }
}


/**
 * tBaseDataSet
 *
 * @author daniel.mark@speakap.nl
 */
class tBaseDataSet extends tBaseClass
{
  /** @var mysqli_result $Resource */
  public $Resource;
  public $Owner;

  /**
   * tBaseDataSet::__construct()
   *
   * @param mixed $Owner
   * @param string $SQL
   * @return \tBaseDataSet
   */
  function __construct(&$Owner, $SQL = '')
  {
    $this->Owner = $Owner;
  }

  function Fetch_Fields()
  {
    return $this->Resource->fetch_fields();
  }
//--- PHP mysql functions ---------------------------------------------------//

  /**
   * tBaseDataSet::Field_Type()
   *
   * @param integer $FieldNr
   * @return string
   */
  function Field_Type($FieldNr)
  {
    $finfo = $this->Resource->fetch_fields();
    return $finfo[$FieldNr]->type;
  }

  /**
   * tBaseDataSet::Field_Name()
   *
   * @param integer $FieldNr
   * @return string
   */
  function Field_Name($FieldNr)
  {
    $finfo = $this->Resource->fetch_fields();
    return $finfo[$FieldNr]->name;
  }

  /**
   * tBaseDataSet::Num_Fields()
   *
   * @return integer
   */
  function Num_Fields()
  {
    return $this->Resource->field_count;
  }

  /**
   * tBaseDataSet::Num_Rows()
   *
   * @return integer
   */
  function Num_Rows()
  {
    return $this->Resource->num_rows;
  }

//--- Uitbereiding t.o.v. PHP mysql functies --------------------------------//
  /**
   * tBaseDataSet::Field_Type_By_Name()
   *
   * @param string $FieldName
   * @return mixed
   */
  function Field_Type_By_Name($FieldName)
  {
    $Nr = $this->Field_Nr_By_Name($FieldName);
    return $this->Field_Type($Nr);
  }

  /**
   * tBaseDataSet::Field_Nr_By_Name()
   *
   * @param string $FieldName
   * @return bool
   */
  function Field_Nr_By_Name($FieldName)
  {
    $Result = false;
    for ($i = 0; $i < $this->Num_Fields(); $i++)
      if ($this->Field_Name($i) == $FieldName)
      {
        $Result = $i;
        break;
      }
    return $Result;
  }
}

/**
 * tReadDataSet
 *
 * @author daniel.mark@speakap.nl
 */
class tReadDataSet extends tBaseDataSet
{
  /**
   * tReadDataSet::__construct()
   *
   * @param mixed $Owner
   * @param string $SQL
   * @param bool $Use_WriteDB
   * @throws tSQL_Exception
   * @return tReadDataSet
   */
  function __construct(&$Owner, $SQL, $Use_WriteDB = false) // override
  {
    global $Last_MySQL_Query, $Last_MySQL_Error;
    $Last_MySQL_Error = '';
    $Last_MySQL_Query = $SQL;
    /** @var Mysqli $Connection */
    $Connection = $Use_WriteDB ? $Owner->Write_Connection : $Owner->Read_Connection;
    parent::__construct($Owner, $SQL);

    if (($this->Resource = $Connection->query($SQL)) == false)
    {
      $Last_MySQL_Error = $Connection->error;
      throw new tSQL_Exception(Err_SQL_Error);
    }
  }

  /**
   * tReadDataSet::Fetch_Array()
   *
   * @param int $ResultType
   * @return array
   */
  function Fetch_Array($ResultType = MYSQL_ASSOC) // Liever default MYSQL_ASSOC dan MYSQL_BOTH
  {
    return ($this->Resource) ? $this->Resource->fetch_array($ResultType) : false;
  }

  /**
   * tReadDataSet::Fetch_Rows()
   * Return a amount of rows
   * @return integer
   */
  function Fetch_Rows()
  {
    return ($this->Resource) ? mysqli_num_rows($this->Resource): false;
  }
}

/**
 * tWriteDataSet
 *
 * @author daniel.mark@speakap.nl
 */
class tWriteDataSet extends tBaseDataSet
{
  /**
   * tWriteDataSet::__construct()
   *
   * @param mixed $Owner
   * @param string $SQL
   * @return \tWriteDataSet
   */
  function __construct(&$Owner, $SQL) // override
  {
    parent::__construct($Owner, $SQL);

  }
}