<?php
/**
 * Debug Constants
 *
 * @package 000-Speakap
 * @subpackage Core_Constants
 * @version 2.0
 */

//--- Constants for Errorlogging --------------------------------------------//
  define('Err_No_Error', '0_Err_No_Error');
  define('Err_General_Error', '1_Err_General_Error');
  define('Err_Missing_Session_ID', '2_Err_Missing_Session_ID');
  define('Err_Missing_Required_Array_Key', '3_Err_Missing_Required_Array_Key');
  define('Err_MemCache_Could_Not_Connect', '4_Err_MemCache_Could_Not_Connect');
  define('Err_Missing_Parameter', '5_Err_Missing_Parameter');
  define('Err_Undefined_Class_Property', '6_Err_Undefined_Class_Property');
  define('Err_Class_Property_Exists', '7_Err_Class_Property_Exists');
  define('Err_Undefined_Class_Method', '8_Err_Undefined_Class_Method');
  define('Err_UnknownUser', '301_Err_UnknownUser');
  define('Err_TheProgrammerWhoWroteThis_IsAnIdiot', '302_Err_TheProgrammerWhoWroteThis_IsAnIdiot');

//--- SQL Error codes -------------------------------------------------------//
  define('Err_SQL_Error', '200_Err_SQL_Error');
  define('Err_SQL_Insert__NoFieldsToInsert', '201_Err_SQL_Insert__NoFieldsToInsert');
  define('Err_SQL_Update__NoFieldsToUpdate', '202_Err_SQL_Update__NoFieldsToUpdate');
  define('Err_SQL_MultiInsert__NoFieldsToInsert', '203_Err_SQL_MultiInsert__NoFieldsToInsert');
  define('Err_SQL_MultiInsert__NoRecordsToInsert', '204_Err_SQL_MultiInsert__NoRecordsToInsert');
  define('Err_SQL_No_Records_Found', '205_Err_SQL_No_Records_Found');

//--- Model Function Error codes --------------------------------------------//
  define('Err_Missing_Model_File', '100_Err_Missing_Model_File');
  define('Err_Missing_Model_Class', '101_Err_Missing_Model_Class');
  define('Err_Missing_Model_Function', '102_Err_Missing_Model_Function');
  define('Err_Missing_JSON_Parameter', '103_Err_Missing_JSON_Parameter');
  define('Err_Incorrect_JSON_Parameter_Value', '104_Err_Incorrect_JSON_Parameter_Value');
  define('Err_AccessDenied__InvalidKey', '105_Err_AccessDenied__InvalidKey');
  define('Err_AccessDenied__ModelFunction', '110_Err_AccessDenied__ModelFunction');       // Model Function flags undefined in Model Constructor
  define('Err_AccessDenied__UserLogin_Required', '111_Err_AccessDenied__UserLogin_Required');  // User must be loggedin for this Model Fuction
  define('Err_AccessDenied__SpeakapAdmin_Only', '112_Err_AccessDenied__SpeakapAdmin_Only');   // User must be a SpeakapAdmin to access this Model Function
  define('Err_AccessDenied__For_HTTP_Request', '113_Err_AccessDenied__For_HTTP_Request');    // Model Function may not be accessed by HTTP Request
  define('Err_AccessDenied__For_CRONjob', '114_Err_AccessDenied__For_CRONjob');         // Model Function may not be accessed by CRONjob
  define('Err_AccessDenied__For_ExternalServer', '115_Err_AccessDenied__For_ExternalServer');  // Model Function may not be accessed by External(Speakap)Server
  define('Err_AccessDenied__For_3rdParty_API', '116_Err_AccessDenied__For_3rdParty_API');    // Model Function may not be accessed by 3rd Party APIs
  define('Err_AccessDenied__Source_Is_Not_AJAX', '117_Err_AccessDenied__Source_Is_Not_AJAX');  // JSON function (from HTTP) was not send by AJAX. CSRF

//--- tModelMessage Error codes ---------------------------------------------//
  define('Err_Error_Sending_Message', '5001_Err_Error_Sending_Message');
  define('Err_MessageFolder_NotFound', '5002_Err_MessageFolder_NotFound');

//--- Fileserver Error codes ------------------------------------------------//
  define('Err_File__No_Error', '1000_Err_File__No_Error');
  define('Err_File__Folder_Undefined', '1001_Err_File__Folder_Undefined');
  define('Err_File__Folder_Owner_Undefined', '1002_Err_File__Folder_Owner_Undefined');
  define('Err_File__Parent_Folder_Undefined', '1003_Err_File__Parent_Folder_Undefined');
  define('Err_File__Create_User_Undefined', '1004_Err_File__Create_User_Undefined');
  define('Err_File__Change_User_Undefined', '1005_Err_File__Change_User_Undefined');
  define('Err_File__No_such_folder_found_with_this_owner', '1006_Err_File__No_such_folder_found_with_this_owner');
  define('Err_File__Unknown_Root_Folder', '1007_Err_File__Unknown_Root_Folder');
  define('Err_File__Unknown_Parent_Folder', '1008_Err_File__Unknown_Parent_Folder');
  define('Err_File__Cant_Delete_Folder', '1009_Err_File__Cant_Delete_Folder');
  define('Err_File__Folders_deleted_but_directories_remain', '1010_Err_File__Folders_deleted_but_directories_remain');
  define('Err_File__Invalid_Folder_Name', '1011_Err_File__Invalid_Folder_Name');
  define('Err_File__Invalid_Document_Name', '1012_Err_File__Invalid_Document_Name');
  define('Err_File__Folder_Edit_DB_Error', '1013_Err_File__Folder_Edit_DB_Error');
  define('Err_File__Error_Creating_Folder', '1014_Err_File__Error_Creating_Folder');
  define('Err_File__File_Undefined', '1015_Err_File__File_Undefined');
  define('Err_File__File_Not_Found', '1016_Err_File__File_Not_Found');
  define('Err_File__Error_Deleting_File', '1017_Err_File__Error_Deleting_File');
  define('Err_File__File_Edit_DB_Error', '1018_Err_File__File_Edit_DB_Error');
  define('Err_File__Nothing_To_Change', '1019_Err_File__Nothing_To_Change');
  define('Err_File__Error_Reading_File', '1020_Err_File__Error_Reading_File');
  define('Err_File__Error_Uploading_File', '1021_Err_File__Error_Uploading_File');
  define('Err_File__Fileserver_Connect_Error', '1022_Err_File__Fileserver_Connect_Error');
  define('Err_File__Unknown_Fileserver_Error', '1023_Err_File__Unknown_Fileserver_Error');
  define('Err_File__Folder_Path_Undefined', '1024_Err_File__Folder_Path_Undefined');
  define('Err_File__File_Name_Undefined', '1025_Err_File__File_Name_Undefined');
  define('Err_File__Fileserver_Undefined', '1026_Err_File__Fileserver_Undefined');
  define('Err_File__Folder_Not_Found', '1027_Err_File__Folder_Not_Found');
  define('Err_File__File_Extention_Undefined', '1028_Err_File__File_Extention_Undefined');
  define('Err_File__Unable_To_Delete_File', '1029_Err_File__Unable_To_Delete_File');
  define('Err_File__Unable_To_Copy_File', '1030_Err_File__Unable_To_Copy_File');
  define('Err_File__Unable_To_Move_File', '1031_Err_File__Unable_To_Move_File');
  define('Err_File__Folder_Name_Undefined', '1032_Err_File__Folder_Name_Undefined');
  define('Err_File__Shared_With_Undefined', '1033_Err_File__Shared_With_Undefined');
  define('Err_File__Change_Type_Undefined', '1034_Err_File__Change_Type_Undefined');
  define('Err_File__AccessDenied', '1040_Err_File__AccessDenied');


//--- Speakap server Error codes --------------------------------------------//
  define('Err_SpS_General_Error', '2000_Err_SpS_General_Error');
  define('Err_SpS_Create_User_Undefined', '2001_Err_SpS_Create_User_Undefined');
  define('Err_SpS_Unknown_Network', '2002_Err_SpS_Unknown_Network');
  define('Err_SpS_Connection_Error', '2003_Err_SpS_Connection_Error');
  define('Err_SpS_Undefined_Network', '2004_Err_SpS_Undefined_Network'); // Network_ID param not set
  define('Err_SpS_Network_Not_Found', '2005_Err_SpS_Network_Not_Found'); // Network_ID params is set, but not found in DB


//--- Speakap Sync Server Error codes ---------------------------------------//
  define('Err_SSS_General_Error', '3000_Err_SSS_General_Error');
  define('Err_SSS_No_Networks_Found', '3001_Err_SSS_No_Networks_Found');
  define('Err_SSS_No_SyncServers_Found', '3002_Err_SSS_No_SyncServers_Found');

//--- Speakap Chat Server Error codes ---------------------------------------//
  define('Err_SCS_General_Error', '4000_Err_SCS_General_Error');
  define('Err_SCS_No_ChatServers_Found', '4002_Err_SCS_No_ChatServers_Found');

//--- Speakap user right Error codes ---------------------------------------//
  define('Err_Right_User_Permission_Denied', '5002_Err_Right_User_Permission_Denied');

//--- Log_Type_ID
  define('lot_None', 0);
  define('log_Debug', 10);
  define('lot_General', 20);
  define('lot_PHP_Error', 30);
  define('lol_PHP_Warning', 31);
  define('lot_SQL_Error', 40);
  define('lot_SQL_Warning', 41);
  define('lot_JS_Error', 50);
  define('lot_JS_Warning', 51);
  define('lot_New', 60);
  define('lot_Change', 70);
  define('lot_Delete', 80);
  define('lot_AccessDenied', 90);

//--- Log_Category_ID
  define('lca_None', 0);
  define('lca_Home', 1);
  define('lca_Communications', 2);
  define('lca_Network', 3);
  define('lca_Media', 4);
  define('lca_Documents', 5);
  define('lca_Apps', 6);
  define('lca_Search', 7);
  define('lca_Login', 8);

//--- Log_Data_Type_ID
  define('ldt_None', 0);
  define('ldt_Param', 1);
  define('ldt_VarDump', 2);
  define('ldt_JSON', 3);
  define('ldt_Table', 4);

//--- Errorlevels gebruikt in log.php
  define("erlFatal",      0, "[0 - Fatal Error ]");
  define("erlError",      1, "[1 - Error       ]");
  define("erlWarning",    2, "[2 - Warning     ]");
  define("erlLogMessage", 3, "[3 - Logmessage  ]");
  define("erlHint",       4, "[4 - Hint        ]");
  define("erlDebug",      5, "[5 - Debug       ]");

  define("ertUndefined",  999);
  define("ertDebug",      998);
  define("ertJavaScript", 997);

  $ErrorTypes = array();
  $ErrorTypeLevels = array();

  $ErrorTypes[E_ERROR]           = "E_ERROR";           $ErrorTypeLevels[E_ERROR]           = erlError;
  $ErrorTypes[E_WARNING]         = "E_WARNING";         $ErrorTypeLevels[E_WARNING]         = erlWarning;
  $ErrorTypes[E_PARSE]           = "E_PARSE";           $ErrorTypeLevels[E_PARSE]           = erlWarning;
  $ErrorTypes[E_NOTICE]          = "E_NOTICE";          $ErrorTypeLevels[E_NOTICE]          = erlHint;
  $ErrorTypes[E_STRICT]          = "E_STRICT";          $ErrorTypeLevels[E_STRICT]          = erlHint;
  $ErrorTypes[E_USER_ERROR]      = "E_USER_ERROR";      $ErrorTypeLevels[E_USER_ERROR]      = erlError;
  $ErrorTypes[E_USER_WARNING]    = "E_USER_WARNING";    $ErrorTypeLevels[E_USER_WARNING]    = erlWarning;
  $ErrorTypes[E_USER_NOTICE]     = "E_USER_NOTICE";     $ErrorTypeLevels[E_USER_NOTICE]     = erlHint;
  $ErrorTypes[E_CORE_ERROR]      = "E_CORE_ERROR";      $ErrorTypeLevels[E_CORE_ERROR]      = erlError;
  $ErrorTypes[E_CORE_WARNING]    = "E_CORE_WARNING";    $ErrorTypeLevels[E_CORE_WARNING]    = erlWarning;
  $ErrorTypes[E_COMPILE_ERROR]   = "E_COMPILE_ERROR";   $ErrorTypeLevels[E_COMPILE_ERROR]   = erlError;
  $ErrorTypes[E_COMPILE_WARNING] = "E_COMPILE_WARNING"; $ErrorTypeLevels[E_COMPILE_WARNING] = erlWarning;
  $ErrorTypes[ertUndefined]      = "Undefined_error";   $ErrorTypeLevels[ertUndefined]      = erlError;
  $ErrorTypes[ertDebug]          = "Debug_Message";     $ErrorTypeLevels[ertDebug]          = erlDebug;
  $ErrorTypes[ertJavaScript]     = "ertJavaScript";     $ErrorTypeLevels[ertJavaScript]     = erlError;

//----------------------------------------------------------------------------//