<?php
/**
 * Journaal posten voor Pullz
 *
 * @return SimpleXMLElements
 *
 */
function GetXML_King_JournaalPosten_P($DB)
{
  $invoiceIds = array();

  $now = date("Y-m-d H:i");

  $xml_King_Journaal = new VosbaXMLElement('<?xml version="1.0" encoding="UTF-8"?><KING_JOURNAAL></KING_JOURNAAL>', LIBXML_NOEMPTYTAG);

  $xml_King_JournaalBoekingsgangen = $xml_King_Journaal->addChild('BOEKINGSGANGEN');

  $xml_King_JournaalBoekingsgang = $xml_King_JournaalBoekingsgangen->addChild('BOEKINGSGANG');
  $xml_King_JournaalBoekingsgang->addChild('BG_OMSCHRIJVING','Import uit vtigercrm ' . $now);

  $xml_King_JournaalPosten = $xml_King_JournaalBoekingsgang->addChild('JOURNAALPOSTEN');

  /* change assign user
   *
   * 28 = Healthynez
   * 29 = Pullz
   * 30 = Supplementz
   *
   */
  $dsInvoice = $DB->SQL_Select("SELECT i.invoiceid,
                                       i.v_erp_id AS JR_FACTUURNUMMER,
                                       i.invoicedate AS JP_BOEKDATUM,
                                       i.invoicestatus AS JP_STATUS,
                                       i.total AS JR_VALUTABEDRAG,
                                       c.v_d_naw_nummer AS JR_DEBITEURNUMMER2,
                                       a.v_d_naw_nummer AS JR_DEBITEURNUMMER1
                                FROM vtiger_invoice i
                                LEFT JOIN vtiger_crmentity e ON (e.crmid = i.invoiceid)
                                LEFT JOIN vtiger_contactdetails c ON (c.contactid = i.contactid)
                                LEFT JOIN vtiger_account a ON (a.accountid = i.accountid)
                                WHERE e.deleted = 0
                                AND smownerid = 29
                                AND i.v_erp_id != ''
                                AND i.v_erp_id IS NOT NULL
                                AND i.invoicedate > '2014-12-31'
                                AND (i.jpsent2king = 0 OR i.jpsent2king IS NULL)
                                AND (i.invoicestatus = 'Betaald Contant' OR i.invoicestatus = 'Betaald PIN')
                                AND ((a.v_d_naw_nummer != '' AND a.v_d_naw_nummer IS NOT NULL) OR (c.v_d_naw_nummer != '' AND c.v_d_naw_nummer IS NOT NULL))
                                AND (i.total > 0 )
                                LIMIT 0, 1000");

  while ($row = $dsInvoice->Fetch_Array())
  {
    $invoiceIds[] = $row['invoiceid'];

    if (($row['JR_DEBITEURNUMMER2'] != null) && ($row['JR_DEBITEURNUMMER2'] != ''))
    {
      $row['JR_REKENINGNUMMER'] = $row['JR_DEBITEURNUMMER2'];
    }
    if (($row['JR_DEBITEURNUMMER1'] != null) && ($row['JR_DEBITEURNUMMER1'] != ''))
    {
      $row['JR_REKENINGNUMMER'] = $row['JR_DEBITEURNUMMER1'];
    }

    $xml_King_JournaalPost = $xml_King_JournaalPosten->addChild('JOURNAALPOST');
    $xml_King_JournaalPost->addChild('JP_DAGBOEKCODE', 'CRM');
    $xml_King_JournaalPost->addChild('JP_BOEKDATUM', $row['JP_BOEKDATUM']);
    $xml_King_JournaalPost->addChild('JP_OMSCHRIJVING', $row['JP_STATUS']);
    $xml_King_JournaalRegels = $xml_King_JournaalPost->addChild('JOURNAALREGELS');

    $xml_King_JournaalRegel = $xml_King_JournaalRegels->addChild('JOURNAALREGEL');
    $xml_King_JournaalRegel->addChild('JR_REKENINGNUMMER', $row['JR_REKENINGNUMMER']);
    $xml_King_JournaalRegel->addChild('JR_BOEKZIJDE', 'CRED');
    $xml_King_JournaalRegel->addChild('JR_VALUTACODE', 'EUR');
    $xml_King_JournaalRegel->addChild('JR_VALUTABEDRAG', formatDecimals($row['JR_VALUTABEDRAG']));
    $xml_King_JournaalRegel->addChild('JR_FACTUURNUMMER', $row['JR_FACTUURNUMMER']);

    $xml_King_JournaalRegel = $xml_King_JournaalRegels->addChild('JOURNAALREGEL');
    $xml_King_JournaalRegel->addChild('JR_REKENINGNUMMER', '1150');
    $xml_King_JournaalRegel->addChild('JR_BOEKZIJDE', 'DEB');
    $xml_King_JournaalRegel->addChild('JR_VALUTACODE', 'EUR');
    $xml_King_JournaalRegel->addChild('JR_VALUTABEDRAG', formatDecimals($row['JR_VALUTABEDRAG']));

    if (count($invoiceIds) > 0)
    {
      $DB->SQL_Update('vtiger_invoice', array('jpsent2king' => 1), 'invoiceid IN (%s)', implode(',', $invoiceIds));
    }
  }

  return $xml_King_Journaal;
}
