<?php
/**
 * @return SimpleXMLElements
 *
 */
function GetXML_King_OrderS($DB)
{
  // global $DB;
  $Invoice_IDs = array();

  $ds_Invoice = $DB->SQL_Select("SELECT i.invoiceid,
                                        i.accountid,
                                        i.contactid,
                                        i.invoice_no AS ORK_EXTERNORDERNUMMER,
                                        i.invoicedate AS ORK_ORDERDATUM,
                                       i.invoice_no AS ORK_REFERENTIE,
                                       i.invoicestatus AS ORK_BETALINGSCONDITIE,
                                       a.v_d_naw_nummer AS ORK_DEBITEURNUMMER1,
                                       c.v_d_naw_nummer AS ORK_DEBITEURNUMMER2,
                                       c.v_d_naw_con_nummer AS ORK_CONTACTPERSOON,
                                       c.firstname AS ORK_VOORNAAM,
                                       c.lastname AS ORK_ACHTERNAAM,
                                       c.email AS ORK_EMAIL,
                                       c.fax AS ORK_FAX,
                                       c.mobile AS ORK_TELEFOON
                                 FROM vtiger_invoice i
                                 LEFT JOIN vtiger_crmentity e ON (e.crmid = i.invoiceid)
                                 LEFT JOIN vtiger_account a ON (a.accountid = i.accountid)
                                 LEFT JOIN vtiger_contactdetails c ON (c.contactid = i.contactid)
                                 WHERE e.deleted = 0
                                 AND (i.sent2king = 0 OR i.sent2king IS NULL)
                                 AND i.invoicedate > '2014-12-31'
                                 AND ((a.v_d_naw_nummer != '' AND a.v_d_naw_nummer IS NOT NULL) OR (c.v_d_naw_nummer != '' AND c.v_d_naw_nummer IS NOT NULL))
                                 AND smownerid = 17
                                 LIMIT 0, 1000");

  /* tijdelijk om bedrijven te splitsen
   *
   *  smownerid = 15 = Pullz
   *  smownerid = 16 = Healthynez
   *  smownerid = 17 = Supplementz
   *
   */

  $xml_King_Order_XML = new VosbaXMLElement('<?xml version="1.0"?><ORDERS></ORDERS>', LIBXML_NOEMPTYTAG);

  while ($row = $ds_Invoice->Fetch_Array())
  {
    $Invoice_IDs[] = $row['invoiceid'];
    $invoiceid = $row['invoiceid'];

    if (($row['ORK_DEBITEURNUMMER2'] != null) && ($row['ORK_DEBITEURNUMMER2'] != ''))
    {
            $debiteurnummer = $row['ORK_DEBITEURNUMMER2'];
    }
    if (($row['ORK_DEBITEURNUMMER1'] != null) && ($row['ORK_DEBITEURNUMMER1'] != ''))
    {
            $debiteurnummer = $row['ORK_DEBITEURNUMMER1'];
    }

    if ($row['ORK_BETALINGSCONDITIE'] == "Betaald bank")
    {
            $betalingsconditie = "012";
    }
    if ($row['ORK_BETALINGSCONDITIE'] == "Betaald Contant")
    {
            $betalingsconditie = "001";
    }
    if ($row['ORK_BETALINGSCONDITIE'] == "Betaald PIN")
    {
            $betalingsconditie = "010";
    }
    if ($row['ORK_BETALINGSCONDITIE'] == "Incasso")
    {
            $betalingsconditie = "011";
    }
    if ($row['ORK_BETALINGSCONDITIE'] == "Op Rekening")
    {
            $betalingsconditie = "012";
    }
    if ($row['ORK_BETALINGSCONDITIE'] == "Created")
    {
            $betalingsconditie = "900";
    }

    $xml_King_Order = $xml_King_Order_XML->addChild('ORDER');
    $xml_Orderkop = $xml_King_Order->addChild('ORDERKOP');
    $xml_Ork_Externordernummer = $xml_Orderkop->addChild('ORK_EXTERNORDERNUMMER', $row['ORK_EXTERNORDERNUMMER']);
    $xml_Ork_Debiteurnummer = $xml_Orderkop->addChild('ORK_DEBITEURNUMMER', $debiteurnummer);
    $xml_Ork_Contactpersoon = $xml_Orderkop->addChild('ORK_CONTACTPERSOON', $row['ORK_CONTACTPERSOON']);
    $xml_Ork_Referentie = $xml_Orderkop->addChild('ORK_REFERENTIE', $row['ORK_REFERENTIE']);
    $xml_Ork_Orderdatum = $xml_Orderkop->addChild('ORK_ORDERDATUM', $row['ORK_ORDERDATUM']);
    $xml_Ork_Vertegenwoordiger = $xml_Orderkop->addChild('ORK_VERTEGENWOORDIGER');
    $xml_Ork_Prijzeninexbtw = $xml_Orderkop->addChild('ORK_PRIJZENINEXBTW', 'EXCLBTW');
    $xml_Ork_Prijzeninexbtw = $xml_Orderkop->addChild('ORK_GOEDGEKEURD', 'true');

    // TEMP tot Bart van Zutphen anders zegt    $xml_Ork_Prijzeninexbtw = $xml_Orderkop->addChild('ORK_VRIJVOORVERZAMELLIJST', 'true');

    $xml_Ork_Prijzeninexbtw = $xml_Orderkop->addChild('ORK_VRIJVOORLEVERING', 'true');
    $xml_Ork_Prijzeninexbtw = $xml_Orderkop->addChild('ORK_VRIJVOORFACTURERING', 'true');
    $xml_Ork_Betalingscondities = $xml_Orderkop->addChild('ORK_BETALINGSCONDITIE', $betalingsconditie);
    $xml_Ork_Leveringscondities = $xml_Orderkop->addChild('ORK_LEVERINGSCONDITIE','101');

    // $xml_Ork_Verzendadres = $xml_Orderkop->addChild('ORK_VERZENDADRES');
    // $xml_Adr_Naam1 = $xml_Ork_Verzendadres->addChild('ADR_NAAM1', $row['ORK_VOORNAAM'].' '.$row['ORK_ACHTERNAAM']);
    // $xml_Adr_Straat = $xml_Ork_Verzendadres->addChild('ADR_STRAAT');
    // $xml_Adr_Huisnummer = $xml_Ork_Verzendadres->addChild('ADR_HUISNUMMER');
    // $xml_Adr_Postcode = $xml_Ork_Verzendadres->addChild('ADR_POSTCODE');
    // $xml_Adr_Woonplaats = $xml_Ork_Verzendadres->addChild('ADR_WOONPLAATS');
    // $xml_Adr_Land = $xml_Ork_Verzendadres->addChild('ADR_LAND');
    // $xml_Adr_Email = $xml_Ork_Verzendadres->addChild('ADR_EMAIL', $row['ORK_EMAIL']);
    // $xml_Adr_Telefoon = $xml_Ork_Verzendadres->addChild('ADR_TELEFOON', $row['ORK_TELEFOON']);
    // $xml_Adr_Telefax = $xml_Ork_Verzendadres->addChild('ADR_TELEFAX', $row['ORK_FAX']);

    $xml_King_Orderregels = $xml_King_Order->addChild('ORDERREGELS');

    $ds_InvoiceRows = $DB->SQL_Select("SELECT p.v_erp_id AS ORR_ARTIKELNUMMER_P,
                                              s.v_erp_id AS ORR_ARTIKELNUMMER_S,
                                              i.sequence_no AS ORR_GID,
                                              i.comment AS ORR_TEKSTOPFACTUUR,
                                              i.listprice AS ORR_PRIJS,
                                              i.quantity AS ORR_AANTALBESTELD,
                                              i.discount_amount AS ORR_KORTINGSBEDRAG1
                                       FROM vtiger_inventoryproductrel i
                                       LEFT JOIN vtiger_products p ON (p.productid = i.productid)
                                       LEFT JOIN vtiger_service s ON (s.serviceid = i.productid)
                                       WHERE i.id = $invoiceid
                                       LIMIT 0, 100");

    while ($row = $ds_InvoiceRows->Fetch_Array())
    {
      $artikelnummer = '';
      if (($row['ORR_ARTIKELNUMMER_P'] != null) && ($row['ORR_ARTIKELNUMMER_P'] != ''))
      {
        $artikelnummer = $row['ORR_ARTIKELNUMMER_P'];
      }
      if (($row['ORR_ARTIKELNUMMER_S'] != null) && ($row['ORR_ARTIKELNUMMER_S'] != ''))
      {
        $artikelnummer = $row['ORR_ARTIKELNUMMER_S'];
      }
      $xml_King_Orderregel = $xml_King_Orderregels->addChild('ORDERREGEL');
      $xml_King_Orr_Gid = $xml_King_Orderregel->addChild('ORR_GID', $row['ORR_GID']);
      $xml_King_Orr_Soort = $xml_King_Orderregel->addChild('ORR_SOORT', 'ART');
      $xml_King_Orr_Artikelnummer = $xml_King_Orderregel->addChild('ORR_ARTIKELNUMMER', $artikelnummer);
      $xml_King_Orr_Tekstopfactuur = $xml_King_Orderregel->addChild('ORR_TEKSTOPFACTUUR', $row['ORR_TEKSTOPFACTUUR']);
      $xml_King_Orr_Aantalbesteld = $xml_King_Orderregel->addChild('ORR_AANTALBESTELD', $row['ORR_AANTALBESTELD']);
      $xml_King_Orr_Prijs = $xml_King_Orderregel->addChild('ORR_PRIJS', $row['ORR_PRIJS']);
      $xml_King_Orr_Kortingsbedrag1 = $xml_King_Orderregel->addChild('ORR_KORTINGSBEDRAG1', $row['ORR_KORTINGSBEDRAG1']);
    }

    if (count($Invoice_IDs) > 0)
    {
      $today = date("d.m.Y");
      $date = date('Y-m-d', strtotime($today));
      $DB->SQL_Update('vtiger_invoice', array('sent2king' => 1, 'datesent2king' => $date), 'invoiceid IN (%s)', implode(',', $Invoice_IDs));

      /* change assign user
       *
       * 28 = Healthynez
       * 29 = Pullz
       * 30 = Supplementz
       */

      $DB->SQL_Update('vtiger_crmentity', array('smownerid ' => 30), 'crmid IN (%s)', implode(',', $Invoice_IDs));
    }
  }

  return $xml_King_Order_XML;
}
