<?php
/**
 * King2vTiger_Betalingen()
 *
 * @param tMultiQuery $MQ
 * @param string $XMLFile
 * @return void
 */

function king2vtiger_Betalingen(&$MQ, $XMLFile)
{
  global $DB;

  $xmlDATAPACKET = new VosbaXMLElement($XMLFile, LIBXML_NOEMPTYTAG, true);
  $xmlRowData = $xmlDATAPACKET->{'ROWDATA'};

  foreach ($xmlRowData->children() AS $xmlRow)
  {
    $objAttributes = (array) $xmlRow->attributes();
    $attributes = $objAttributes['@attributes'];
    $paymentRef = $attributes['Dagboekcode'] . '-' . $attributes['Stuknummer'] . '-' . $attributes['Volgnummer'];
    $invoiceNo = $attributes['Betalingskenmerk'];

    /*
     * added a start date 
     * change by gvt 
     * 16-07-2013
     *
     */
    $invoiceDate = Date_ymd2MySQL($attributes['Factuurdatum']);
    $dateStart = "01-06-2013";
    $startDate = date('Y-m-d', strtotime($dateStart)) ;  

    if (strtotime($invoiceDate) > strtotime($startDate))
    {
      $dsInvoice = $DB->SQL_Select("SELECT invoiceid
                                     FROM vtiger_invoice, vtiger_crmentity
                                     WHERE vtiger_invoice.invoiceid = vtiger_crmentity.crmid
                                    AND vtiger_crmentity.deleted = 0
                                    AND invoice_no = '%s'", trim($invoiceNo)
                         );

      $rowInvoice = $dsInvoice->Fetch_Array();

      if ($rowInvoice === NULL)
      {
        // throw new Exception("Factuur bij betaling niet gevonden: '$invoiceNo'");
        if (debug) echo 'Factuur bij betaling niet gevonden: ' . $invoiceNo . "\n";
        continue;
      }

      // Boekzijde 0 is debit, Boekzijde 1 is credit - handle credit only
      if ($attributes['Boekzijde'] == 0) 
      {
        $MQ->Add_Update('vtiger_invoice', array('v_erp_id' => $attributes['FactuurReferentieNummer']), "invoiceid = '" . $rowInvoice['invoiceid'] . "'");
        continue;
      }

      $dsPayment = $DB->SQL_Select("SELECT paymentid
                                    FROM vtiger_payment, vtiger_crmentity
                                    WHERE vtiger_payment.paymentid = vtiger_crmentity.crmid
                                    AND vtiger_crmentity.deleted = 0
                                    AND vtiger_payment.reference = '%s'", trim($paymentRef)
                         );

      $rowPayment = $dsPayment->Fetch_Array();

      if ($rowPayment !== NULL && $rowPayment['paymentid'] != '')
      {
        // found, so (according to hdr) do nothing - next
        if (debug) echo 'payment found, do nothing: ' . $paymentRef . "\n";

        continue;

        // one time fix: $MQ->Add_Update('vtiger_payment', array('amount' => $attributes['BedragInBoekValuta']), "reference = '" . trim($paymentRef) . "'");
      }

      $MQ->Add_Set('@crmid', '(SELECT id + 1 FROM vtiger_crmentity_seq)');

      $MQ->Add_Update('vtiger_crmentity_seq', array('id' => '@crmid'), 'id < @crmid');

      $entityFields = array(
                             'crmid' => '@crmid',
                             'smcreatorid' => 0,
                             'smownerid' => 0,
                             'modifiedby' => 0,
                             'setype' => 'Payment',
                             'createdtime' => date('Y-m-d H:i:s'),
                             'modifiedtime' => date('Y-m-d H:i:s')
                       );

      $MQ->Add_Insert('vtiger_crmentity', $entityFields);

      $paymentFields = array(
                             'paymentid' => '@crmid',
                             'description' => $attributes['Betalingskenmerk'],
                             'reference' => $paymentRef,
                             'duedate' => Date_ymd2MySQL($attributes['Vervaldatum']),
                             'register' => Date_ymd2MySQL($attributes['Factuurdatum']),
                             'related_id' => $rowInvoice['invoiceid'],
                             'amount' => $attributes['BedragInBasisValuta'],
                             'paid' => 1
                       );

      $MQ->Add_Insert('vtiger_payment', $paymentFields);
    }
  }
}
