<?php
/*
 * script to import the Betalingen.xml
 *
 */

// debug - when true: no updates, no copy to archive, dump to screen
define('debug', false);

$inFile = 'FactBetalingenDeb_HO.xml';

// debug notice
if (debug) echo '** debug active ** no updates, no copy to archive, dump to screen' . "\n";

require('../config.php');

define('_php_lib', 'lib/');
require_once _php_lib . 'initialize.php';

if (!file_exists($FilePath_To_CRM . $inFile))
{
  echo $FilePath_To_CRM . $inFile . ' does not exist.' . "\n";
}
else
{
  // payments
  require('includes/Betalingen/king2vtiger_Betalingen.php');

  $vTiger_Connector = array(
                            'Read_Server_Path' => $dbconfig['db_server'],
                            'Read_Server_Port' => str_replace(':','',$dbconfig['db_port']),
                            'Write_Server_Path' => $dbconfig['db_server'],
                            'Write_Server_Port' => str_replace(':','',$dbconfig['db_port']),
                            'Database_UserName' => $dbconfig['db_username'],
                            'Database_Password' => $dbconfig['db_password'],
                            'Database_Name' => $dbconfig['db_name']
                      );

  $DB = new tDB($vTiger_Connector);
  $MQ = new tMultiQuery($DB->Write_Connection, $DB);

  // payments
  king2vtiger_Betalingen($MQ, $FilePath_To_CRM . $inFile);

  if (debug)
  {
    echo "SQL\n" . $MQ->Get_SQL("\n");
  }
  else
  {
    fb::send($MQ->SQL, 'SQL');
    $MQ->Execute(true);
  }

  // archive
  if (!debug) rename($FilePath_To_CRM . $inFile, $FilePath_To_CRM_Archive . date('YmdHis') . '_' . $inFile);

  DisconnectAll_DBs();
}

echo "\n done \n";

// debug notice
if (debug) echo '** debug active ** no updates, no copy to archive, dump to screen' . "\n";
