<?php
/*
 * script to export the crm journaalposten to feed into king
 *
 */
require('../config.php');

define('_php_lib', 'lib/');
require(_php_lib . 'initialize.php');

require('includes/JournaalPosten/GetXML_King_JpS.php');
require('includes/JournaalPosten/GetXML_King_JpP.php');
require('includes/JournaalPosten/GetXML_King_JpH.php');

$vTiger_Connector = array(
                          'Read_Server_Path' => $dbconfig['db_server'],
                          'Read_Server_Port' => str_replace(':','',$dbconfig['db_port']),
                          'Write_Server_Path' => $dbconfig['db_server'],
                          'Write_Server_Port' => str_replace(':','',$dbconfig['db_port']),
                          'Database_UserName' => $dbconfig['db_username'],
                          'Database_Password' => $dbconfig['db_password'],
                          'Database_Name' => $dbconfig['db_name']
                    );

$DB = new tDB($vTiger_Connector);

$xml_King_JpS = GetXML_King_JournaalPosten_S($DB);
$xml_King_JpP = GetXML_King_JournaalPosten_P($DB);
$xml_King_JpH = GetXML_King_JournaalPosten_H($DB);

DisconnectAll_DBs();

// formatting
$dom = new DOMDocument('1.0', 'encoding="UTF-8"');
$dom->preserveWhiteSpace = false;
$dom->formatOutput = true;
$dom->loadXML($xml_King_JpS->asXML());
$dom->save($FilePath_To_ERP . 'KING_JOURNAALPOSTEN_Supplementz.xml');

$dom = new DOMDocument('1.0', 'encoding="UTF-8"');
$dom->preserveWhiteSpace = false;
$dom->formatOutput = true;
$dom->loadXML($xml_King_JpH->asXML());
$dom->save($FilePath_To_ERP . 'KING_JOURNAALPOSTEN_Healthynez.xml');

$dom = new DOMDocument('1.0', 'encoding="UTF-8"');
$dom->preserveWhiteSpace = false;
$dom->formatOutput = true;
$dom->loadXML($xml_King_JpP->asXML());
$dom->save($FilePath_To_ERP . 'KING_JOURNAALPOSTEN_Pullz.xml');

// safety backup - nonsense, will be done by ftp process
// copy($FilePath_To_ERP . 'KING_JOURNAALPOSTEN_Supplementz.xml', $FilePath_To_ERP_Archive . date('Ymd_His') . '_KING_JOURNAALPOSTEN_Supplementz.xml');
// copy($FilePath_To_ERP . 'KING_JOURNAALPOSTEN_Healthynez.xml', $FilePath_To_ERP_Archive . date('Ymd_His') . '_KING_JOURNAALPOSTEN_Healthynez.xml');
// copy($FilePath_To_ERP . 'KING_JOURNAALPOSTEN_Pullz.xml', $FilePath_To_ERP_Archive . date('Ymd_His') . '_KING_JOURNAALPOSTEN_Pullz.xml');

echo 'done';
