<?php

// Solution Vtiger2King
// 
// Toevoegen van blokken en velden aan de Vtiger-CONTACT module
// die noodzakelijk zijn voor de technische werking van de koppeling
// (zonder deze velden kan de koppeling NIET werken)
//

// Turn on debugging level
$Vtiger_Utils_Log = true;
include_once('vtlib/Vtiger/Menu.php');
include_once('vtlib/Vtiger/Module.php');

// create nieuw block
$module = Vtiger_Module::getInstance('Contacts');
$block = new Vtiger_Block();
$block->label = 'LBL_v_v2kmandatory';
$module->addBlock($block); //to create a new block

// equivalent van het King-debiteurnummer
// samen v_d_naw_con_nummer met hierop worden contactpersonen binnen debiteuren gematched aan contacts
$field = new Vtiger_Field();
$field->label = 'LBL_v_d_naw_nummer';
$field->name = 'v_d_naw_nummer';
$field->table = 'vtiger_contactdetails';
$field->column = 'v_d_naw_nummer';
$field->columntype = 'int(10)';
$field->uitype = 7;
$field->typeofdata = 'I~O';
$block->addField($field);

// equivalent van het King-crediteurnummer
// samen v_c_naw_con_nummer met hierop worden contactpersonen binnen crediteuren 1-op-1 gematched aan accounts
$field = new Vtiger_Field();
$field->label = 'LBL_v_c_naw_nummer';
$field->name = 'v_c_naw_nummer';
$field->table = 'vtiger_contactdetails';
$field->column = 'v_c_naw_nummer';
$field->columntype = 'int(10)';
$field->uitype = 7;
$field->typeofdata = 'I~O';
$block->addField($field);

// equivalent van het King-contactnummer
// samen v_d_naw_nummer met hierop worden contactpersonen binnen debiteuren gematched aan contacts
$field = new Vtiger_Field();
$field->label = 'LBL_v_d_naw_con_nummer';
$field->name = 'v_d_naw_con_nummer';
$field->table = 'vtiger_contactdetails';
$field->column = 'v_d_naw_con_nummer';
$field->columntype = 'int(4)';
$field->uitype = 7;
$field->typeofdata = 'I~O';
$block->addField($field);

// equivalent van het King-contactnummer
// samen v_d_naw_nummer met hierop worden contactpersonen binnen crediteuren gematched aan contacts
$field = new Vtiger_Field();
$field->label = 'LBL_v_c_naw_con_nummer';
$field->name = 'v_c_naw_con_nummer';
$field->table = 'vtiger_contactdetails';
$field->column = 'v_c_naw_con_nummer';
$field->columntype = 'int(4)';
$field->uitype = 7;
$field->typeofdata = 'I~O';
$block->addField($field);

// tickbox op de account waarmee wordt gemarkeerd dat het account een debiteur is/wordt
// triggered via de workflows het uittrekken van een v_d_naw_nummer
$field = new Vtiger_Field();
$field->label = 'LBL_v_debiteur';
$field->name = 'v_debiteur';
$field->table = 'vtiger_contactdetails';
$field->column = 'v_debiteur';
$field->columntype = 'varchar(1)';
$field->uitype = 56;
$field->typeofdata = 'C~O';
$block->addField($field);

// tickbox op de account waarmee wordt gemarkeerd dat het account een crediteur is/wordt
// triggered via de workflows het uittrekken van een v_c_naw_nummer
$field = new Vtiger_Field();
$field->label = 'Crediteur';
$field->name = 'v_crediteur';
$field->table = 'vtiger_contactdetails';
$field->column = 'v_crediteur';
$field->columntype = 'varchar(1)';
$field->uitype = 56;
$field->typeofdata = 'C~O';
$block->addField($field);

// tickbox die door Vosba wordt gezet bij importeren van mutaties
// als gezet wordt de workflow om wijzigingen in Vtiger naar King te sturen NIET uitgevoerd
// (anders worden alle ingelezen mutaties gelijk weer teruggestuurd)
$field = new Vtiger_Field();
$field->label = 'LBL_v_by_vosba';
$field->name = 'v_by_vosba';
$field->table = 'vtiger_contactdetails';
$field->column = 'v_by_vosba';
$field->columntype = 'varchar(3)';
$field->uitype = 56;
$field->typeofdata = 'C~O';
$block->addField($field);
$field->uitype = 56;
$field->typeofdata = 'C~O';
$block->addField($field);

