<?php
/**
 * vema_hub.php
 *
 * Send email including link
 * use normal vtiger email including [CONSENCONFIRMTLINK] mark
 * this mark will be replaced by a separate script
 *
 */
require_once('include/utils/utils.php');
require_once('includes/Loader.php');
require_once('includes/runtime/BaseModel.php');
require_once('includes/runtime/Globals.php');
require_once('includes/exceptions/AppException.php');

// for vttranslate
require_once('includes/runtime/LanguageHandler.php');

// can be tested in programms called by this wrapper to change behaviour
define("WRAPPER","VEMA");

// only ws_create is used
include_once('include/Webservices/Create.php');

/**
 *
 * Email templates
 * - confirm enrollment
 * - reminder
 * - thank you
 *
 * Message
 *
 * tokens:
 * - [CONSENTCONFIRMLINK] to be used to include a confirmationlink in the email
 * - [CONSENTOPTOUTLINK] to include in templates, once clicked we set email consent optout
 */
// do we have the crmid webservice?
// if yes than we can also handle older already converted links

// nieuwsbrief API user
$emailFromId = Settings_VebSettings_Record_Model::getSetting('emailconsent_from_id', 'VebEmailConsent');

$current_user = CRMEntity::getInstance('Users');
$current_user->retrieveCurrentUserInfoFromFile($emailFromId);
$current_user->authenticated = true;

// keep get for error reporting
$originalGet = $_GET;

// First style url - encrypted
$s = null;
if (array_key_exists('s', $_GET)) {

  $query = VebEmailConsent_Record_Model::decrypt($_GET['s']);

  $linkParams = explode('&', $query);

  $params = array();
  foreach ($linkParams as $key => $linkParam) {

    list($paramKey, $paramValue) = explode('=', $linkParam);
    $params[$paramKey] = $paramValue;
  }

  $_GET = $params;
}

$action = VebEmailConsent_Record_Model::cleanGetParam('a', 'GET');
$formaction = VebEmailConsent_Record_Model::cleanGetParam('form-action','POST');

vemalogMessage(__LINE__, $formaction, 'formaction');
vemalogMessage(__LINE__, $action, 'action');

// a=viewpage&t='.$title.'&m='.base64_encode($message));
if ($action == 'viewpage') {

    $title = rawurldecode(base64_decode($_GET['t']));
    $message = rawurldecode(base64_decode($_GET['m']));

    viewPage($title, $message);
    exit();
}

// Second style url
$version = VebEmailConsent_Record_Model::cleanGetParam('v', 'GET', 'integer');

// if it is base64 encoded than first decode
// deze mogen we niet cleanen = encoded!
$content = $_GET['c'];

// Example second style url
// consent.php?utm_source=crm
//            &utm_medium=email
//            &cid=323590
//            &vebwvat=c18225895d25b8adcf3d04a05f350a26
//            &vebwvatv=2
//            &utm_content=textlink
//            &consent=confirm
// 
// https://autoresponder.vicus.nl/vema_hub.php?utm_source=crm
//                                            &utm_medium=email
//                                            &utm_term=185
//                                            &utm_content=textlink
//                                            &utm_campaign=Contacts%20Invite%20email
//                                            &cid=3137
//                                            &vebwvat=6afc521c2b54eec0c9aaec8b8d3897aa
//                                            &vebwvatv=2

// niet cleanen, is encoded
$token = $_GET['vebwvat'];

// $_GET['vebwvatv'];
$tversion = VebEmailConsent_Record_Model::cleanGetParam('vebwvatv', 'GET');

// $_GET['cid'];
$cid = VebEmailConsent_Record_Model::cleanGetParam('cid', 'GET', 'integer');

// is this a subscribe to our newsletter? -- initial action - show the subscribeform
switch ($action) {

  // Con: https://autoresponder.vicus.nl/vema_hub.php?cid=75265&a=editprofile
  // Lea: https://autoresponder.vicus.nl/vema_hub.php?cid=322097&a=editprofile
  // https://autoresponder.vicus.nl/vema_hub.php?a=editprofile&cid=3897
  case 'editprofile':

    editProfile();
    die();

  case 'subscribe':

    consentSubscribePage();
    die();

  case 'unsubscribe':

    // call function to show page with reasons to unsubscribe
    consentUnsubscribePage();
    die();

  case 'optin':

    $entity = getEntityById($cid);

    $_GET['email'] = $entity->email;
    $_GET['firstname'] = $entity->firstname;
    $_GET['lastname'] = $entity->lastname;

    consentSubscribePage();
    die();
}

switch ($formaction) {

  case 'staysubscribed':

    $title = vtranslate('Fijn dat je blijft', 'VebEmailConsent');

    $message = 'Dit scherm kan nu gesloten worden';

    // showPage does not return
    showPage($title, $message);
    break;

  case 'reactivate':

    $title = vtranslate('Je profiel is is weer actief', 'VebEmailConsent');

    // this data is the 'before update profile' data
    $serializedFormToken = VebEmailConsent_Record_Model::decrypt($_POST['form-token']);
    $formEntity = unserialize($serializedFormToken);

    if($formEntity === false) {

        $message = vtranslate('Er is een fout opgetreden.', 'VebEmailConsent');

        // showPage does not return
        showPage($title, $message);
    }

    VebEmailConsent_Record_Model::reactivateSubscription($formEntity);

    $message = 'Dit scherm kan nu gesloten worden';

    // showPage does not return
    showPage($title, $message);
    break;

  case 'updateprofile':

    $title = vtranslate('Je profiel is aangepast', 'VebEmailConsent');

    $email = VebEmailConsent_Record_Model::cleanGetParam('email', 'POST', 'email');
    $lastname = VebEmailConsent_Record_Model::cleanGetParam('lastname', 'POST', 'name');
    $firstname = VebEmailConsent_Record_Model::cleanGetParam('firstname', 'POST', 'name');

    // used for secretkey
    $cid = VebEmailConsent_Record_Model::cleanGetParam('cid', 'POST');

    // if($email == '' || $firstname == '' || $lastname == '' || VebEmailConsent_Record_Model::isSecretKeyValid() === false) {
    if($email == '' || $lastname == '' || VebEmailConsent_Record_Model::isSecretKeyValid() === false) {

        $message = vtranslate('Er is een fout opgetreden.', 'VebEmailConsent');
        $message .= ' ';
        $message .= vtranslate('Je moet alle verplichte velden invullen met toegestane waarden.', 'VebEmailConsent');

        // showPage does not return
        showPage($title, $message);
    }

    // this data is the 'before update profile' data
    $serializedFormToken = VebEmailConsent_Record_Model::decrypt($_POST['form-token']);
    $formEntity = unserialize($serializedFormToken);

    // and this is the data from the current form
    $formEntity->firstname = $firstname;
    $formEntity->lastname = $lastname;
    $formEntity->email = $email;

    // emailCampaign preferences are set via $_POST
    VebEmailConsent_Record_Model::updateProfile($formEntity);

    $message = '<h3>' . vtranslate('Dit scherm kan nu gesloten worden', 'VebEmailConsent') . '</h3>';

    // showPage does not return
    showPage($title, $message);
    break;

  case 'unsubscribe':

    $title = vtranslate('Uitschrijven nieuwsbrief', 'VebEmailConsent');

    // is token valid?
    if(VebEmailConsent_Record_Model::isSecretKeyValid() === false) {

        vebHandleError(vtranslate('Er is een fout opgetreden.', 'VebEmailConsent'));
    }

    // this data is the 'before unsubscribe' data
    $serializedFormToken = VebEmailConsent_Record_Model::decrypt($_POST['form-token']);
    $formEntity = unserialize($serializedFormToken);

    if ($formEntity === false) {

        $message = vtranslate('Er is een fout opgetreden.', 'VebEmailConsent');
        $message .= vtranslate('Geen emailadres om uit te schrijven.', 'VebEmailConsent');

        // showPage does not return
        showPage($title, $message);
    }

    // call update consent routine
    $message = updateConsent($formEntity, $formaction);

    $message = '<h3>';
    $message .= vtranslate('Je bent uitgeschreven.', 'VebEmailConsent');
    $message .= '</h3>';
    $message .= '<p>';
    $message .= vtranslate('Jammer dat je ons hebt verlaten.', 'VebEmailConsent');
    $message .= '</p>';

    // showPage does not return
    showPage($title, $message);
    break;

  // is this a subscribe to our newsletter? -- receiving the subscribeform
  case 'subscribe':

    $title = vtranslate('Inschrijven nieuwsbrief', 'VebEmailConsent');

    // check honeypot
    // @todo - must be empty:  [xx_companynamename] => [xx_lastname] => [xx_firstname] => )

    // is token valid?
    if(VebEmailConsent_Record_Model::isSecretKeyValid() === false) {

        vebHandleError(vtranslate('Er is een fout opgetreden.', 'VebEmailConsent'));
    }

    // this data is the 'before unsubscribe' data
    $serializedFormToken = VebEmailConsent_Record_Model::decrypt($_POST['form-token']);
    $formEntity = unserialize($serializedFormToken);

    $email = VebEmailConsent_Record_Model::cleanGetParam('email', 'POST', 'email');

    $mailValidated = validateEmail($email);

    $firstname = VebEmailConsent_Record_Model::cleanGetParam('firstname', 'POST', 'name');
    $lastname = VebEmailConsent_Record_Model::cleanGetParam('lastname', 'POST', 'name');

    // test for minimum required fields
    if($email == '' || $firstname == '' || $lastname == '' || VebEmailConsent_Record_Model::isSecretKeyValid() === false) {

        $message = vtranslate('Er is een fout opgetreden.', 'VebEmailConsent');
        $message .= ' ';
        $message .= vtranslate('Je moet alle verplichte velden invullen met toegestane waarden.', 'VebEmailConsent');

        // showPage does not return
        showPage($title, $message);
    }

    // do we have a registration of this email already?
    // read database leads, contacts
    if ($email != '') $entity = getEntityByEmail($email);

    if (is_object($entity) && !empty($entity->id)) {

/*
        // found what is the consent status? maybe already subscribed?
        if (strtolower($entity->emailconsent_status) == 'invited') {

            $message = '<h3>' . vtranslate('Je bent al uitgenodigd voor inschrijving met dit e-mail adres.', 'VebEmailConsent') . '</h3>';
            $message .= '<p>' . vtranslate('Je hebt een email ontvangen om dit te bevestigen.', 'VebEmailCampaigns') . '</p>';

            // showPage does not return
            showPage($title, $message);
        }
        elseif (strtolower($entity->emailconsent_status) == 'subscribed') {
*/
        if (strtolower($entity->emailconsent_status) == 'subscribed') {

            if ($firstname == $entity->firstname && $lastname == $entity->lastname) {

                $message = '<h3>' . vtranslate('Je bent al ingeschreven met dit e-mail adres.', 'VebEmailConsent') . '</h3>';
                $message .= '<p>' . vtranslate('Je hoeft nu verder niets te doen.', 'VebEmailConsent') . '</p>';
            }
            else {

                // kan wel zijn dat de gegevens afwijken, dan is het wel handig om te vragen hoe het zit.
                $message .= '<h3>' . vtranslate('Je gegevens zijn veranderd', 'VebEmailConsent') . '</h3>';
                $message .= '<ol>';

                if ( strtolower($firstname) != strtolower($entity->firstname) ) {

                  $message .= ' <li>';
                  $trString = vtranslate('Voornaam nu opgegeven <b>%s</b>, eerder geregistreerd <b>%s</b>', 'VebEmailConsent');
                  $message .= sprintf($trString, $firstname, $entity->firstname);
                }

                if ( strtolower($lastname) != strtolower($entity->lastname) ) {

                  $message .= ' <li>';
                  $trString = vtranslate('Achternaam nu opgegeven <b>%s</b>, eerder geregistreerd <b>%s</b>', 'VebEmailConsent');
                  $message .= sprintf($trString, $lastname, $entity->lastname);
                }

                $message .= '</ol>';
                $message .= '<p>';
                $message .= sprintf('Je bent nu ingeschreven met dit e-mailadres.', 'VebEmailConsent');
                $message .= vtranslate('Je hoeft nu verder niets te doen.', 'VebEmailConsent');
                $message .= '</p>';

                // keuze geven
                // bestaande overschrijven of nieuwe inschrijving aanmaken
            }

            $content = vtranslate('Via webformulier nogmaals ingeschreven voor de nieuwsbrief met de volgende gegevens:', 'VebEmalConsent');
            $trString = vtranslate('Voornaam: %s, Achternaam: %s, emailadres: %s', 'VebEmailConsent');
            $content .= sprintf($trString, $firstname, $lastname, $email);
            addForm($entity->id, $content, $entity->assigned_user_id);
            $trSubject = vtranslate('Controleer de Voornaam en Achternaam', 'VebEmailConsent');
            $trBody = vtranslate('Bij inschrijven op de nieuwsbrief is hetvolgende op het scherm getoond', 'VebEmailConsent');
            vebSendMail($trSubject, '<p>' . $trBody . $message . '</p><hr>');

            // showPage does not return
            showPage($title, $message);
        }
        elseif (strtolower($entity->emailconsent_status) == 'blacklisted') {

            // if BLACKLISTED
            $content = vtanslate('Huidige status is Blacklisted, maar toch via webformulier ingeschreven voor de nieuwsbrief met de volgende gegevens:', 'VebEmailConsent');
            $trString = vtranslate('Voornaam: %s, Achternaam: %s, Emailadres: %s', 'VebEmailConsent');
            $content .= sprintf($trString, $firstname, $lastname, $email);
            addForm($entity->id, $content, $entity->assigned_user_id);
            vebHandleError(vtranslate('Nieuws inschrijving van Blacklisted record', 'VebEmailConsent'));
            die();
        }
        else {

            // FOUND existing record not yet Subscribed
            // might work based on rest of the code already using $entity
            $action = 'optin';
        }
    }
    else {

        // NOT found
        // create new lead (rest of process will be handled further on)
        // $cid = nr of new lead
        $action = 'optin';
        $entity = new StdClass;
        $entity->firstname = $firstname;
        $entity->lastname = $lastname;
        $entity->company = $company;
        $entity->email = $email;

        $entity->id = createLead($entity);

        list($wsEntityId, $crmId) = explode('x', $entity->id);
        $entity = getEntityById($crmId);
        $content = vtranslate('Via webformulier ingeschreven voor de nieuwsbrief met de volgende gegevens:', 'VebEmailConsent');
        $trString = vtranslate('Voornaam: %s, Achternaam: %s, Emailadres: %s, Bedrijf: %s', 'VebEmailConsent');
        $content .= sprintf($trString, $firstname, $lastname, $email, $company);
        addForm($entity->id, $content, $entity->assigned_user_id);
    }

    break;
}

/**
 * ============= validate token
 */
if ($token != '' && $tversion != '' && $cid > 0 && $action != '')
{
    if (!vebValidateWVAtoken($token, $cid, $tversion)) {

        vebHandleError(vtranslate('token', 'VebEmailConsent'));
    }
}

/**
 * ============= using the obfuscated url
 *
 * incomming: https://autoresponder.vicus.nl/vema_hub.php?v=1&m=vema&c=bW9kdWxlcy9FbWFpbENhbXBhaWducy9saW5rdHJhY2stZGVjb2RlZC5waHA/Y3VycmVudF91c2VyX2lkPTEmZW1haWx0cmFja2luZ3JlcG9ydGlkPTM0ODMyOSZwYXJlbnRfaWQ9MjY5MjYwJmVtYWlsaWQ9MzQ4MzI5JmxpbmtfbmFtZT1PcGxvc3NpbmdlbiZ1cmw9YUhSMGNITTZMeTkzZDNjdWRtbGpkWE11Ym13dmIzQnNiM056YVc1blpXND0=
 * continue with: https://autoresponder.vicus.nl/modules/EmailCampaigns/linktrack.php?current_user_id=1&emailtrackingreportid=348329&parent_id=269260&emailid=348329&link_name=Oplossingen&url=aHR0cHM6Ly93d3cudmljdXMubmwvb3Bsb3NzaW5nZW4=
 * @todo add url to settings
 * $url = 'https://autoresponder.vicus.nl/';
 */
if ($version == '1' && $content && $action == '') {

    $decoded_content = VebEmailConsent_Record_Model::decrypt($content);

    $query = parse_url($decoded_content, PHP_URL_QUERY);
    $path = parse_url($decoded_content, PHP_URL_PATH);
    $host = parse_url($decoded_content, PHP_URL_HOST);

    vemaShowDebug(__LINE__, $version, 'version');
    vemaShowDebug(__LINE__, $content, 'content');
    vemaShowDebug(__LINE__, $action, 'action');
    vemaShowDebug(__LINE__, $decoded_content, 'decoded_content');
    vemaShowDebug(__LINE__, $query, 'query');
    vemaShowDebug(__LINE__, $path, 'path');
    vemaShowDebug(__LINE__, $host, 'host');
    vemaShowDebug(__LINE__, false, 'stop');

    $linkParams = explode('&', $query);

    $params = array();
    foreach ($linkParams as $key => $param) {

        list($paramkey, $paramvalue) = explode('=', $param);
        $params[$paramkey] = $paramvalue;
        $_REQUEST[$paramkey] = $paramvalue; // need it for linktrack
    }

    // fill GET with the same
    $_GET = $params;

    if (substr($path, 0, 1) == '/')  $path = substr($path, 1);

    // filter the action
    $emailMarketingModule = false;

    switch ($path) {

         case 'shorturl.php':
         case '/shorturl.php':

             $emailMarketingModule = false;

             require_once('modules/Vtiger/helpers/ShortURL.php');
             Vtiger_ShortURL_Helper::handle($params['id']);
             die();

        case 'modules/Emails/actions/TrackAccess.php':
        case '/modules/Emails/actions/TrackAccess.php':

            $emailMarketingModule = false;

            require_once('modules/Emails/actions/TrackAccess.php'); 
            die();

        case 'modules/EmailCampaigns/unsubscriber.php':

            $emailMarketingModule = true;
            $cid = $params['recordid'];
            $action = 'unsubscribe';
            break;

        case 'modules/EmailCampaigns/subscriber.php':

            $emailMarketingModule = true;
            $cid = $params['recordid'];
            $action = 'confirm';
            break;

        case 'modules/EmailCampaigns/linktrack.php':

            $emailMarketingModule = true;
            // backwards compatible
            if (array_key_exists('parent_id', $params)) $cid = $params['parent_id'];
            if (array_key_exists('p_id', $params)) $cid = $params['p_id'];
            $action = 'linktrack';

            vemaShowDebug(__LINE__, $emailMarketingModule, 'emailMarketingModule');
            vemaShowDebug(__LINE__, $action, 'emailMarketingAction');
            vemaShowDebug(__LINE__, false, 'stop');

            break;

        case 'modules/EmailCampaigns/emailopen.php':

            $emailMarketingModule = true;
            // backwards compatible
            if (array_key_exists('parent_id', $params)) $cid = $params['parent_id'];
            if (array_key_exists('p_id', $params)) $cid = $params['p_id'];
            $action = 'emailopen';
            break;

        default:

            // if host is one of ours, redirect
            $ownUrls = Settings_VebSettings_Record_Model::getSetting('own_urls', 'VebEmailConsent');
            $validUrls = explode("\n", $ownUrls);
            $ownUrls = array_map('trim', $validUrls);

            if (in_array($host, $ownUrls)) {

              header("Location: $decoded_content");
              die();
            }

            vebHandleError(vtranslate('error unknown path:', 'VebEmailConsent') . $path);
    }
}
elseif ($cid > 0 && $action != '') {

  // cid = parent of contact ??!??
  // just to be sure
  $entity = getEntityById($cid);

  // print_r($_REQUEST);
  // print('<li>'.$action);
}
elseif ($action == 'optin' && $formaction == 'subscribe') {

  // we are passing the subscription form which is fine
  // print("<li> action=$action, formaction=$formaction");
}
else {

  // no valid set of parameters
  // print_r($_REQUEST);
  vebHandleError(vtranslate('invalid params', 'VebEmailConsent'));
  die();
}

vemaShowDebug(__LINE__, $entity, 'entity');
vemaShowDebug(__LINE__, $cid, 'cid');
vemaShowDebug(__LINE__, false, 'stop');

// only look for the entity if not already found
if (!$entity) {

    // $entity->id = 0 than not found, can be old not existing anymore!
    $entity = getEntityById($cid);
}

if ($entity->id > 0 && $entity->type) {

    vemaShowDebug(__LINE__, $entity, 'entity');
    vemaShowDebug(__LINE__, false, 'stop');

    // handle exceptions if one was blacklisted
    $emailoptout = strtolower($entity->emailoptout);
    $emailconsent_status = strtolower($entity->emailconsent_status);

    // @change lro 190911 added && $action !== 'emailopen'
    if ($action !== 'unsubscribe' && $action !== 'emailopen' && ($emailoptout == 1 || $emailconsent_status == 'blacklisted')) {

        // one is allowed to run the opt-out procedure, no problems with that
        // in other cases send email to sales with exceptional situation to handle manually
        $msg = vtranslate('Een Lead of Contact voerde een actie uit terwijl hij blacklisted/geblokkeerd is voor e-mail verkeer.', 'VebEmailConsent');
        $msg .= vtranslate('Klik op onderstaande link en voer handmatige eventuele vervolgacties uit.', 'VebEmailConsent');

        if ($entity->type == 'Leads') {

            $msg .= sprintf("\n\nLink: %s/index.php?module=Leads&view=Detail&record=", VtigerConfig::get('site_URL'), $entity->id);
        }
        else {

            $msg .= sprintf("\n\nLink: %s/index.php?module=Contacts&view=Detail&record=%d", VtigerConfig::get('site_URL'), $entity->id);
        }

       $msg .= "\n\n".print_r($entity,true);

       $trString = vtranslate('Actie bij geblokkeerde/blacklisted', 'VebEmailConsent');
       vebHandleError($trString . $entity->type, $msg);
    }
    elseif ($action != 'emailopen' && $action != 'linktrack') {

      // need to get the reason of unsubscribe
      if ($action == 'unsubscribe') {

        $_GET['email'] = $entity->email;

        // call function to show page with reasons to unsubscribe
        consentUnsubscribePage();
        die();
      }

      $message = updateConsent($entity, $action);
    }

    if ($action != 'emailopen' && $action != 'linktrack') {

        // @change t33626
        $translationsForAction = array('optin' => vtranslate('uitnodiging', 'VebEmailConsent'),
                                       'confirm' => vtranslate('aanmelding', 'VebEmailConsent'),
                                       'optout' => vtranslate('afmelding', 'VebEmailConsent'),
                                       'unsubscribe' => vtranslate('afmelding', 'VebEmailConsent')
                                 );

        $translatedAction = $action;

        if (array_key_exists($action, $translationsForAction)) {

          $translatedAction = $translationsForAction[$action];
        }
        //

        // @change t33626
        $title = vtranslate('Bevestiging e-mail', 'VebEmailConsent') . ' ' . $translatedAction;
        //

        addForm($entity->wsid, $title.' - '.strip_tags($message, '<br>'), $entity->assigned_user_id);

        // showPage does not return
        showPage($title, $message);
    }
}
else {

    $errorMsg = vtranslate('Ongeldige waarden voor cid %s, entity->id %s of setype %s', 'VebEmailConsent');
    vebHandleError($errorMsg, $cid, $entity->id, $entity->setype);
}

// if marketing module enabled than we continue to load the standard handlers that belong to the module
if ($emailMarketingModule ===  true) {

    switch (strtolower($action)) {

        case 'optin':
            require('modules/EmailCampaigns/subscriber.php');
            break;

        case 'confirm':
            require('modules/EmailCampaigns/subscriber.php');
            break;

        case 'optout':
        case 'unsubscribe':
            require('modules/EmailCampaigns/unsubscriber.php');
            break;

        case 'linktrack':

            require('modules/EmailCampaigns/linktrack.php');
            break;

        case 'emailopen':
            require('modules/EmailCampaigns/emailopen.php');
            break;

        default:
            vebHandleError(vtranslate('error - unknown action', 'VebEmailConsent') . ' ' . __LINE__ . ' ' . $action);
    }
}

die();

// we need to protect against reloads with Post/Redirect/Get approach
// so we show the data through viewPage
// @see https://en.wikipedia.org/wiki/Post/Redirect/Get
function showPage($title, $message) {

      // now use reload using get
      $title = base64_encode(rawurlencode($title));
      $message = base64_encode(rawurlencode($message));

      $params = 'a=viewpage&t='.$title.'&m='.$message;
      $url = VebEmailConsent_Record_Model::encrypt($params);
      header('Location: /vema_hub.php?s=' . $url);
      exit();

      header('Location: /vema_hub.php?a=viewpage&t='.$title.'&m='.$message);
      exit();
}

function viewPage($title, $message) {

      // get company settings
      $companyModel = Settings_Vtiger_CompanyDetails_Model::getInstance();

      $values = array(Settings_VebSettings_Record_Model::getSetting('endpoint_url', 'VebEmailConsent'),
                      $companyModel->get('website'),
                      $companyModel->logoPath . $companyModel->get('logoname'),
                      $companyModel->get('organizationname'),
                      $companyModel->get('address'),
                      $companyModel->get('code'),
                      $companyModel->get('city'),
                      $companyModel->get('country'),
                      $companyModel->get('phone'),
                      vtranslate('Privacyvoorwaarden', 'VebEmailConsent'),
                      date("Y"),
                      Settings_VebSettings_Record_Model::getSetting('company_email', 'VebEmailConsent'),
                      Settings_VebSettings_Record_Model::getSetting('company_privacy_link', 'VebEmailConsent'),
                      vtranslate('footerInfoText', 'VebEmailConsent'),
                      vtranslate('footerEmailSuiteAdvert', 'VebEmailConsent')
                );

      $replace = array('[configSiteUrl]',
                       '[companyModelWebsite]',
                       '[companyModelLogo]',
                       '[companyModelCompanyname]',
                       '[companyModelAddress]',
                       '[companyModelCode]',
                       '[companyModelCity]',
                       '[companyModelCountry]',
                       '[companyModelPhone]',
                       '[Privacyvoorwaarden]',
                       '[copyrightyear]',
                       '[settingsCompanyEmail]',
                       '[settingsCompanyPrivacyLink]',
                       '[footerInfoText]',
                       '[footerEmailSuiteAdvert]'
                 );

      $header = file_get_contents('modules/VebEmailConsent/webpages/header.inc.html');
      $header = str_replace($replace, $values, $header);

      $footer = file_get_contents('modules/VebEmailConsent/webpages/footer.inc.html');
      $footer = str_replace($replace, $values, $footer);

      echo $header . '<h1 style="padding-bottom:20px;">' . $title . '</h1>' . $message . $footer;
}

function updateConsent($entity, $action = '') {

    global $current_user;

    $crmid = $entity->wsid;
    $setype = $entity->type;

    $element = array();

    switch (strtolower($action)) {

        case 'optin':

            VebEmailConsent_Record_Model::setEmailConsentOptin($entity);

            $message = '<p>';
            $message .= vtranslate('Dank je wel voor je aanmelding.', 'VebEmailConsent');
            $message .= ' ';
            $message .= vtranslate('We sturen je een e-mail met een bevestigingslink.', 'VebEmailConsent');
            $message .= '</p>';
            $message .= '<p>';
            $message .= vtranslate('Vergeet niet om je inschrijving via de link in de e-mail te bevestigen.', 'VebEmailConsent');
            $message .= '</p>';
            break;

        case 'confirm':

            // @todo - maar als inmiddels blacklisted dan toch ff checken eerst!
            VebEmailConsent_Record_Model::setEmailConsentConfirmed($entity);

            $message = '<h3>';
            $message .= vtranslate('Dankjewel voor je interesse', 'VebEmailConsent');
            $message .= '</h3>';
            $message .= '<p>';
            $message .= vtranslate('Je inschrijving is hiermee bevestigd.', 'VebEmailConsent');
            $message .= '</p>';
            $message .= '<p>';
            $message .= vtranslate('Binnenkort kun je het eerste bericht van ons verwachten.', 'VebEmailConsent');
            $message .= '</p>';
            break;

        case 'unsubscribe':
        case 'optout':

            VebEmailConsent_Record_Model::setEmailConsentOptout($entity);

            $message = '<h3>';
            $message .= vtranslate('We zullen je missen', 'VebEmailConsent');
            $message .= '</h3>';
            $message .= '<p>';
            $message .= vtranslate('Je uitschrijving is hiermee verwerkt.', 'VebEmailConsent');
            $message .= '</p>';
            break;
    }

    return $message;
}

function createLead($entity) {

    global $current_user;

    try {

        // seems we need this! - these are std vtiger lead-fields
        $element['firstname'] = $entity->firstname;
        $element['lastname'] = $entity->lastname;
        $element['email'] = $entity->email;
        $element['company'] = (isset($entity->companyname) && $entity->companyname != '')? $entity->companyname : '-';
        $element['assigned_user_id'] = $current_user->id;
        $result = vtws_create('Leads',$element, $current_user);
    }
    catch (WebServiceException $ex) {

        $errString =  __FUNCTION__ . vtranslate('company=%s, firstname=%s, lastname=%s %s', 'VebEmailConsent');
        error_log(sprintf($errString, $entity->companyname, $entity->firstname, $entity->lastname, $ex->getMessage()), 0);
    }

    // format TabxCrmid
    return $result['id'];
}

/**
 * Check database or webservice
 * @param   integer $crmid
 */
function getEntityById($crmid) {

    global $current_user;

    $entity = VebEmailConsent_Record_Model::getEntityById($crmid, $current_user);

    return $entity;
}

function getEntityByEmail($email) {

    global $current_user;

    $entity = VebEmailConsent_Record_Model::getEntityByEmail($email, $current_user);

    return $entity;
}

function vebHandleError($header = '', $text = '') { 

    $subject = 'vema_hub: error ' . $header;
    $message = "\r\n\r\n";;
    $message .= 'originalGet Informatie: <pre>'. print_r($originalGet,1) . "</pre>\r\n";
    $message .= 'Request Informatie: <pre>'. print_r($_REQUEST,1) . "</pre>\r\n";
    $message .= 'Session Informatie: <pre>'. print_r($_SESSION,1) . "</pre>\r\n";
    $message .= 'Server Informatie: <pre>'. print_r($_SERVER,1) . "</pre>\r\n";
    $message .= 'Cookie Informatie: <pre>'. print_r($_COOKIE,1) . "</pre>\r\n";
    error_log($header, 0);

$logname = '/logs/requestsVemaError'.date("Y-M").'.log';
file_put_contents(dirname(__FILE__) . $logname, __LINE__.' request:'.var_export('***', true)."\n", FILE_APPEND);
file_put_contents(dirname(__FILE__) . $logname, __LINE__.' request:'.var_export(date('Y-m-d h:s'), true)."\n", FILE_APPEND);
file_put_contents(dirname(__FILE__) . $logname, __LINE__.' request:'.var_export($header, true)."\n", FILE_APPEND);
file_put_contents(dirname(__FILE__) . $logname, __LINE__.' request:'.var_export($message, true)."\n", FILE_APPEND);
file_put_contents(dirname(__FILE__) . $logname, __LINE__.' request:'.var_export('***', true)."\n", FILE_APPEND);

    vebSendMail($header, $message);
    $title = vtranslate('Dank voor je reactie', 'VebEmailConsent');
    $message = '<p>';
    $message .= vtranslate('Je verzoek wordt naar onze salesafdeling gestuurd om te verwerken.', 'VebEmailConsent');
    $message .= '</p>';
    $message .= '<p>';
    $message .= vtranslate('Het kan ca 1 werkdag duren voordat jouw keuze is verwerkt.', 'VebEmailConsent');
    $message .= '</p>';

    // showPage does not return
    showPage($title, $message);
}

function vebSendMail($subject, $text) {

    $message = vtranslate('Aandachtspunt:', 'VebEmailConsent') . $subject . "\r\n\r\n";
    $message .= $text;
    $message = str_replace("\r\n",'<br />', $message);

    $headers = 'From: marketing@vicus.nl' . "\r\n" .
               'Reply-To: marketing@vicus.com' . "\r\n" .
               'X-Mailer: PHP/' . phpversion();
    $headers .= "MIME-Version: 1.0\r\n";
    $headers .= "Content-Type: text/html; charset=UTF-8\r\n";

    $to = VebEmailConsent_Record_Model::blacklistToAddress();

    if ($to !== false) @mail($to, $subject, $message, $headers);

    // log it - to keep it in one file, determine the date
    $logDate = date('Ymd');
    $logFile = dirname(__FILE__) . '/logs/vemahubdiscarded_' . $logDate . '.log';

    file_put_contents($logFile, date('Y-m-d H:i:s') . ' ', FILE_APPEND);
    file_put_contents($logFile, var_export(strip_tags($header), true)."\n", FILE_APPEND);
    file_put_contents($logFile, var_export(strip_tags($message), true)."\n", FILE_APPEND);
}

function validateEmail($email) {

// for now
return false;

    // module installed and active
    if (!vtlib_isModuleActive('VebEmailValidator')) return false;

    // configured to check
    if (Settings_VebSettings_Record_Model::getSetting('emailconsent_validate', 'VebEmailValidator') != 1) return false;

    // e-mailaddress used to check for existance customer e-mailaddress
    $emailaddress = Settings_VebSettings_Record_Model::getSetting('validatoremail', 'VebEmailValidator');

    if (empty($emailAddress)) return false;

    include_once('modules/VebEmailValidator/VerifyEmail.class.php');

    $vmail = new verifyEmail();
    $vmail->setStreamTimeoutWait(20);
    $vmail->Debug= TRUE;
    $vmail->Debugoutput= 'html';

    // change this email address
    $vmail->setEmailFrom($emailAdress);

    if ($vmail->check($email)) {

      return 'email ' . $email . ' exist!';
    }
    elseif (verifyEmail::validate($email)) {

      return 'email ' . $email . ' valid, but not exist!';
    }
    else {

      return 'email ' . $email . ' not valid and not exist!';
    }
}

/**
 * Add the form as memo
 * @param   text    commentcontent    Your text
 * @param   text    related_to  The Vtiger Record in format (TabIDxRecordId)
 * @param   text    assigned_user_id    Assigned Author in format (TabIDxRecordId)
 * @return  void
 */
function addForm($wsid, $content, $assigned_user_id = '19x1') {

    global $current_user;

    try {
            $data = array (
                'commentcontent' => $content,
                'related_to'=> $wsid,
                'assigned_user_id' => $assigned_user_id, // '19x1', 19=Users Module ID, 1=First user Entity ID
            );

            $comment = vtws_create('ModComments', $data, $current_user);
    }
    catch (WebServiceException $ex) {

        error_log(  __FUNCTION__ . ' - related_to:' . $wsid . ',  assigned_user_id:' . $assigned_user_id . ' ' . $ex->getMessage(),0);
    }

    return true;
}

// function to show page with reasons to unsubscribe
function consentUnsubscribePage() {

    $title = vtranslate('Uitschrijven nieuwsbrief', 'VebEmailConsent');

    $crmId = VebEmailConsent_Record_Model::cleanGetParam('cid', 'GET', 'integer');

    $email = VebEmailConsent_Record_Model::cleanGetParam('email', 'GET', 'email');

    if ($email != '') {

      $entity = getEntityByEmail($email);
      // don't have the cid (?)
      list($wsEntity, $crmId) = explode('x', $entity->id);
    }

    $entity = getEntityById($crmId);

    if (empty($email)) $email = $entity->email;

    if (strtolower($entity->emailconsent_status) == 'unsubscribed' || strtolower($entity->emailconsent_status) == 'optout') {

        // outdated link
        return alreadyUnsubscribed($entity);
    }

    $message = file_get_contents('modules/VebEmailConsent/webpages/unsubscribe-form.inc.html');

    $reasons = array(vtranslate('Ik wil deze e-mails niet meer ontvangen', 'VebEmailConsent'),
                     vtranslate('Ik heb mij nooit aangemeld voor deze mailinglijst', 'VebEmailConsent'),
                     vtranslate('De e-mails zijn ongepast', 'VebEmailConsent'),
                     vtranslate('De e-mails zijn spam en moeten worden gemeld', 'VebEmailConsent'),
                     vtranslate('Anders (vul hieronder je reden in)', 'VebEmailConsent')
               );

    $reasonsSection = '';

    foreach ($reasons as $reason) {

      $reasonsSection .= '<div style="text-align:left;">';
      $reasonsSection .= '<input type="checkbox" name="reason[]" value="' . $reason . '">' . $reason . '</div>';
    }

    $configFormUrl = getFormUrl();

    $lblFirstname = vtranslate('Voornaam', 'VebEmailConsent');
    $lblLastname = vtranslate('Achternaam', 'VebEmailConsent');
    $lblEmail = vtranslate('E-mailadres', 'VebEmailConsent');
    $lblReason = vtranslate('Reden', 'VebEmailConsent');

    $buttonSend = vtranslate('Verstuur', 'VebEmailConsent');
    $buttonAdapt = vtranslate('Profiel aanpassen', 'VebEmailConsent');
    $buttonAgain = vtranslate('Opnieuw inschrijven', 'VebEmailConsent');
    $buttonStay = vtranslate('Toch lid blijven', 'VebEmailConsent');

    $placeHolderReason = vtranslate('geldige reden', 'VebEmailConsent');

    $formToken = VebEmailConsent_Record_Model::encrypt(serialize($entity));
    $token = VebEmailConsent_Record_Model::getSecretKey($entity->crmid);

    $find = array('[settingsFormUrl]',
                  '[Voornaam]',
                  '[firstname]',
                  '[Achternaam]',
                  '[lastname]',
                  '[E-mailadres]',
                  '[email]',
                  '[Reden]',
                  '[reasons]',
                  '[Verstuur]',
                  '[Profiel aanpassen]',
                  '[Opnieuw inschrijven]',
                  '[Toch lid blijven]',
                  '[geldige reden]',
                  '[cid]',
                  '[formtoken]',
                  '[token]');

    $replace = array($configFormUrl,
                     $lblFirstname,
                     $entity->firstname,
                     $lblLastname,
                     $entity->lastname,
                     $lblEmail,
                     $email,
                     $lblReason,
                     $reasonsSection,
                     $buttonSend,
                     $buttonAdapt,
                     $buttonAgain,
                     $buttonStay,
                     $placeHolderReason,
                     $entity->crmid,
                     $formToken,
                     $token);

    $message = str_replace($find, $replace, $message);
    viewPage($title, $message);
}

function getFormUrl() {

  $endpointURL = Settings_VebSettings_Record_Model::getSetting('endpoint_url', 'VebEmailConsent');
  return $endpointURL;
}

function alreadyUnsubscribed($entity) {

  $title = 'Je bent al uitgeschreven';
  $message = file_get_contents('modules/VebEmailConsent/webpages/unsubscribed-form.inc.html');
  $optoutReasons = str_replace(' |##| ', '<br />', $entity->emailconsent_optout_reason);

  $configFormUrl = getFormUrl();

  $lblEmail = vtranslate('E-mailadres', 'VebEmailConsent');
  $buttonSend = vtranslate('Verstuur', 'VebEmailConsent');
  $lblReasons = vtranslate('Opgegeven reden', 'VebEmailConsent');
  $lblInterest = vtranslate('Jouw interesses', 'VebEmailConsent');

  // show enrollments
  $enrollments = '';

  foreach ($entity->emailconsent_mailings as $label => $value) {

    if ($value == 1) $enrollments .= '<div style="text-align:left;">' . $label . '</div>';
  }

  if (empty($optoutReasons)) $optoutReasons = vtranslate('Geen', 'VebEmailConsent');
  if (empty($enrollments)) $lblInterest = ' ';

  $formToken = VebEmailConsent_Record_Model::encrypt(serialize($entity));
  $token = VebEmailConsent_Record_Model::getSecretKey($entity->crmid);
  
  $find = array('[settingsFormUrl]',
                '[E-mailadres]',
                '[email]',
                '[Opgegeven reden]',
                '[reasons]',
                '[Abonnement]',
                '[enrollments]',
                '[Verstuur]',
                '[cid]',
                '[formToken]',
                '[token]');

  $replace = array($configFormUrl,
                   $lblEmail,
                   $entity->email,
                   $lblReasons,
                   $optoutReasons,
                   $lblInterest,
                   $enrollments,
                   $buttonSend,
                   $entity->crmid,
                   $formToken,
                   $token);

  $message = str_replace($find, $replace, $message);

  viewPage($title, $message);
}

function consentSubscribePage() {

    $title = vtranslate('Inschrijven nieuwsbrief', 'VebEmailConsent');

    $email = VebEmailConsent_Record_Model::cleanGetParam('email', 'GET', 'email');
    $firstname = VebEmailConsent_Record_Model::cleanGetParam('firstname', 'GET', 'name');
    $lastname = VebEmailConsent_Record_Model::cleanGetParam('lastname', 'GET', 'name');

    $message ='';
    if (array_key_exists('m', $_GET)) $message = sprintf('<p class="alert">%s</p>', base64_decode($_GET['m']));

    $message .= file_get_contents('modules/VebEmailConsent/webpages/subscribe-form.inc.html');

    $configFormUrl = getFormUrl();
    // $formAction = 
    $lblFirstname = vtranslate('Voornaam', 'VebEmailConsent');
    $lblLastname = vtranslate('Achternaam', 'VebEmailConsent');
    $lblEmail = vtranslate('E-mailadres', 'VebEmailConsent');
    $placeHolder = vtranslate('geldig e-mailadres', 'VebEmailConsent');
    $buttonSend = vtranslate('Verstuur', 'VebEmailConsent');

    $find = array('[settingsFormUrl]',
                  '[Voornaam]',
                  '[firstname]',
                  '[Achternaam]',
                  '[lastname]',
                  '[E-mailadres]',
                  '[email]',
                  '[geldig e-mailadres]',
                  '[Verstuur]');

    $replace = array($configFormUrl,
                     $lblFirstname,
                     $firstname,
                     $lblLastname,
                     $lastname,
                     $lblEmail,
                     $email,
                     $placeHolder,
                     $buttonSend);

    $message = str_replace($find, $replace, $message);
    viewPage($title, $message);
}

function editProfile() {

    // global $config;
    $title = vtranslate('Aanpassen profiel', 'VebEmailConsent');

    // $_GET['cid'];
    $cid = VebEmailConsent_Record_Model::cleanGetParam('cid', 'GET', 'integer');

    if ($cid != '') $crmId = $cid;

    $email = VebEmailConsent_Record_Model::cleanGetParam('email', 'POST', 'email');

    if (empty($email)) {

      $email = VebEmailConsent_Record_Model::cleanGetParam('email', 'GET', 'email');
    }

    if ($email != '') {

      $entity = getEntityByEmail($email);
    }
    else {

      $entity = getEntityById($crmId);
    }

    // is it found?
    if ($entity->crmid == 0) {

      // it's not found, go to subscribe page
      $message = base64_encode(vtranslate('Inschrijving niet gevonden, hieronder kun je je inschrijven voor onze nieuwsbrief', 'VebEmailConsent'));
      header('Location: /vema_hub.php?a=subscribe&m=' . $message);
      exit();
    }

    // make a form section
    $enrollmentsSettings = VebEmailConsent_Record_Model::getEnrollmentsSettingsHtml($entity);

    $lblInterest = vtranslate('Jouw interesse', 'VebEmailConsent');

    if (empty($enrollmentsSettings))  $lblInterest = ' ';

    $message = file_get_contents('modules/VebEmailConsent/webpages/profile-form.inc.html');
    $configFormUrl = getFormUrl();

    $lblFirstname = vtranslate('Voornaam', 'VebEmailConsent');
    $lblLastname = vtranslate('Achternaam', 'VebEmailConsent');
    $lblEmail = vtranslate('E-mailadres', 'VebEmailConsent');
    $buttonSend = vtranslate('Verstuur', 'VebEmailConsent');

    $token = VebEmailConsent_Record_Model::getSecretKey($entity->crmid);
    $formToken = VebEmailConsent_Record_Model::encrypt(serialize($entity));

    $find = array('[settingsFormUrl]',
                  '[Voornaam]',
                  '[firstname]',
                  '[Achternaam]',
                  '[lastname]',
                  '[E-mailadres]',
                  '[email]',
                  '[Jouw interesse]',
                  '[enrollments]',
                  '[Verstuur]',
                  '[cid]',
                  '[formtoken]',
                  '[token]');

    $replace = array($configFormUrl,
                     $lblFirstname,
                     $entity->firstname,
                     $lblLastname,
                     $entity->lastname,
                     $lblEmail,
                     $entity->email,
                     $lblInterest,
                     $enrollmentsSettings,
                     $buttonSend,
                     $entity->crmid,
                     $formToken,
                     $token);

    $message = str_replace($find, $replace, $message);
    viewPage($title, $message);
}

function obsolete_getConsentConfigSetting($field) {

  return Settings_VebEmailConsent_Record_Model::getSetting($field, 'VebEmailConsent');
}

function vemalogError($lineNr, $msg, $lbl = '') {

  $logDate = date('Ymd');
  $logFile = 'veb/logs/vemaRequestsErrors_' . $logDate . '.txt';

  $label = $lbl;

  if (!empty($lbl)) $label = $lbl . ': ';

  file_put_contents($logFile, date('Y-m-d h:s') . ' ' . $lineNr . ' ' . $label . var_export($msg, true) . "\n", FILE_APPEND);
}

function vemalogMessage($lineNr, $msg, $lbl = '') {

  $logDate = date('Ymd');
  $logFile = 'veb/logs/vemaRequestsErrors_' . $logDate . '.txt';

  $label = $lbl;

  if (!empty($lbl)) $label = $lbl . ': ';

  file_put_contents('veb/logs/vema.txt', date('Y-m-d h:s') . ' ' . $lineNr . ' ' . $label . var_export($msg, true) . "\n", FILE_APPEND);
}

function vemaShowDebug($lineNr, $msg, $lbl = '') {

  $allowed =  array('213.125.152.50' => false, '77.166.42.114' => false);

  if (array_key_exists($_SERVER['REMOTE_ADDR'], $allowed) && $allowed[$_SERVER['REMOTE_ADDR']] === true) {

    if ($lbl === 'stop' && $msg === true) die(__LINE__ . ':debug stopped');
    if ($lbl === 'stop' && $msg === false) return;

    $label = $lbl;

    $message = $msg;

    if (is_object($msg) || is_array($msg)) $message = var_export($msg, true);

    if (!empty($lbl)) $label = $lbl . ':';

    echo '<pre>';
    var_dump($lineNr . ':' . $label . $message);
    echo '</pre>';
  }
}
