<?php
/**
 * 
 * Portions created by Vicus are Copyright (C) Vicus (www.vicus.nl).
 * All Rights Reserved.
 * @author	l.roovers <l.roovers@vicus.nl>
 */
 
//ini_set("include_path", "../");

$ivr_server_phone = '+31570500630';
$dec_point = ',';
$thousands_sep = '.';
$authenticated_app_id = ''; // vtiger APP id

ob_start("ob_gzhandler");
session_start();

//require('send_mail.php');
require_once('config.php');
require_once('config_veb.php');
require_once('veb/functions/format_fields.php');
require_once('veb/functions/get_related.php');
require_once('veb/functions/add_remark.php');

require_once('veb/classes/webapp.php');
require_once('veb/classes/datetime.php');

require_once('include/utils/utils.php');
//require_once('include/language/en_us.lang.php');

$app = new WebApp;


// Check to see if there is an authenticated user in the session.
require_once('veb/functions/login.php'); // handles all login
$login_user_name = login($application_unique_key);

global $crmEntityLog;
$crmEntityLog = array(); // keeps track of all numbers already handled

$emailHeaders = 'From: crm@vicus.nl' . "\r\n" .
'Reply-To: sales@vicus.nl' . "\r\n" .
'X-Mailer: PHP/' . phpversion();

$htmlHeader = $app->getHeader();

$htmlFooter = $app->getFooter();

/**********************************************************************************
** 
* Finds the Open Actions and/or calls and updates the custom field 'Next Action Date' in the leads forms
* Now we have an updated list.
* If no actions is found the Next Action Date is emptied, and an alert mail is send to the user
* all email messages are clustered so each user receives one email
********************************************************************************/

	
	#
	# GET parameters
	# http://voice2crm.vicus.nl/democrm/vebmobilecrm.php?cun=demo1
	
	//Code added for 'Multiple SQL Injection Vulnerabilities & XSS issue' fixes - Philip
	if(isset($_REQUEST['record']) && !is_numeric($_REQUEST['record']) && $_REQUEST['record']!='')
	{
	    die("An invalid record number specified to view details.");
	}	
	
	if (isset($_GET['user_name']))
	{
//		$selectUser = "AND user_name= '{$_GET['user_name']}'";
		$listForUser = $_GET['user_name'];
	} else {
		$selectUser = '';
	}

	// for now we override with logged in user // only see own assigned leads/pots

	if (isset($login_user_name))
	{
		$selectUser = "AND user_name= '{$login_user_name}'";
		$listForUser = $login_user_name;
	}

	if (isset($_GET['cun']))
	{
		$selectUser = "AND user_name= '{$_GET['cun']}'";
		$listForUser = $_GET['cun'];
	} 

	$module = $_REQUEST['module'];	
				
	if (isset($_REQUEST['action']))
	{
		switch(strtoupper($_REQUEST['action']))
		{
			case 'U': 
				$doUpdateAction = 'plusUur'; 
				$doUpdateMsg = '1 uur verpl.';
				$newActionDate = date('Y-m-d H:i:s', mktime(date("H")+1, date("i"), date("s"), date("m") , date("d"), date("Y")));
				break;
			case 'D': 
				$doUpdateAction = 'plusDag'; 
				$doUpdateMsg = '1 dag verpl.';
				$newActionDate  = date('Y-m-d', mktime(0, 0, 0, date("m")  , date("d")+1, date("Y")));
				break;
			case 'NB': 
				$doUpdateAction = 'volgendeWerkDag'; 
				$moveDays = datetimehelper::daysTillNextWorkingDay();
				$doUpdateMsg = 'NB '.$moveDays.' dg verpl.';
				$newActionDate  = date('Y-m-d', mktime(0, 0, 0, date("m")  , date("d")+$moveDays, date("Y")));
				break;
			case 'VMI': 
				$doUpdateAction = 'volgendeWerkDag'; 
				$moveDays = datetimehelper::daysTillNextWorkingDay();
				$doUpdateMsg = 'Vm Ingespr. '.$moveDays.' dg verpl.';
				$newActionDate  = date('Y-m-d', mktime(0, 0, 0, date("m")  , date("d")+$moveDays, date("Y")));
				break;
			case 'VMN': 
				//$doUpdateAction = 'volgendeWerkDag'; 
				//$moveDays = datetimehelper::daysTillNextWorkingDay();
				//$doUpdateMsg = 'Vm Niet Ingespr. '.$moveDays.' dg verpl.';
				//$newActionDate  = date('Y-m-d', mktime(0, 0, 0, date("m")  , date("d")+$moveDays, date("Y")));
				$doUpdateAction = 'Vandaag'; 
				$doUpdateMsg = 'Vm Niet Ingespr - Later Terugbellen';
				$newActionDate  = date('Y-m-d', mktime(date("h")+1, 0, 0, date("m")  , date("d"), date("Y")));
				break;
			case 'AFW': 
				$doUpdateAction = 'volgendeWerkDag'; 
				$moveDays = datetimehelper::daysTillNextWorkingDay();
				$doUpdateMsg = 'Afw. '.$moveDays.' dg verpl.';
				$newActionDate  = date('Y-m-d', mktime(0, 0, 0, date("m")  , date("d")+$moveDays, date("Y")));
				break;
			case 'LTB': 
				$doUpdateAction = 'Vandaag'; 
				$doUpdateMsg = 'Later Terugbellen';
				$newActionDate  = date('Y-m-d', mktime(date("h")+1, 0, 0, date("m")  , date("d"), date("Y")));
				break;
			case '1XBELLEN': 
				$doUpdateAction = '1xBELLEN'; 
				$doUpdateMsg = 'Nog 1x bellen en dan op Uitval';
				$newActionDate  = date('Y-m-d', mktime(date("h"), 0, 0, date("m")  , date("d")+1, date("Y")));
				break;
			case 'NODATE':
				$doUpdateAction = 'resetActionDate'; 
				$doUpdateMsg = 'Actiedatum reset (=leeg)';
				$newActionDate  = NULL;
				break;
			case 'W': 
				$doUpdateAction = 'plusWeek'; 
				$doUpdateMsg = 'Week verpl.';
				$newActionDate  = date('Y-m-d', mktime(0, 0, 0, date("m")  , date("d")+7, date("Y")));
				break;
			case 'M': 
				$doUpdateAction = 'plusMonth'; 
				$doUpdateMsg = 'Maand verpl.';
				$newActionDate  = date('Y-m-d', mktime(0, 0, 0, date("m")+1  , date("d"), date("Y")));
				break;
			case 'MA':
			case 'DI':
			case 'WO':
			case 'DO':
			case 'VR':
			case 'ZA':
			case 'ZO':
				$doUpdateAction = 'next'.$_REQUEST['action']; 
				$doUpdateMsg = 'naar '.$_REQUEST['action'].' as verpl.';
				$newActionDate  = datetimehelper::calculateNextWeekday($_REQUEST['action']);
				break;				
			case 'LOGOUT':
				session_unset();
				session_destroy();
				$_SESSION = array();
				header("Location: vebmobilecrm.php");
				die();
				break;

			case 'NURTURE':
			case 'QOUT':
			case 'QUALIFIED':
			case 'INFOSTUREN':
			case 'AFSPRAAK':
			case 'STATUS':
				// @todo , make it even more intelligent
				// - Select more standard messages from the sdcreen to prevent homework
				// - Make possble to send info / brochures from selectlist (klik-klik-send)
				$doUpdateAction = 'set'.$_REQUEST['action']; 
				// so we're changing the status
				// update description & modified time field
/*				$sql = 'SELECT leadstatus FROM vtiger_leadstatus';
				$readAction = $adb->pquery($sql, array());
				while ($leadRow2 = $adb->fetch_array($result2))
				{}
*/
				$settings['Leads'] = array(
					'field' => 'leadstatus',
					'field_id' => 'leadid',
					'table' => 'vtiger_leaddetails',
					'status' => array(
						'NURTURE' => 'Nurture',
						'QOUT'  => 'Uitval - Qualified Out',
						'UITVAL'  => 'Uitval',
						'LOST'  => 'Uitval',
						'QO'  => 'Uitval',
						'QUALIFIED' => 'Gekwalificeerd',
						'INFOSTUREN' => 'Voorstel/info sturen',
						'FOLLOWUP'=>'Voorstel/info opvolgen',
						'AFSPRAAK'=>'Afspraak maken'
					)
				);
				$settings['Potentials'] = array(
					'field' => 'sales_stage',
					'field_id' => 'potentialid',
					'table' => 'vtiger_potential',
					'status' => array(
						'NURTURE' => 'Nurture',
						'QOUT' => 'Closed Lost',
					)
				);

				if(isset( $settings[$module]['status'][strtoupper($_REQUEST['action'])] )) 
				{
					$field = $settings[$module]['field'];
					$fieldid = $settings[$module]['field_id'];
					$table = $settings[$module]['table'];
					$status = $settings[$module]['status'][strtoupper($_REQUEST['action'])];

					switch (strtoupper($_REQUEST['action'])){
						case 'NURTURE':
								$newActionDate = date('Y-m-d', mktime(0, 0, 0, date("m")+6  , date("d"), date("Y")));
								$doUpdateMsg = "{$status} FUP {$newActionDate}"; 
								break;
						case 'INFOSTUREN':
								// when selected . send reminder per email to the user
								$emailTo = $_SESSION['user_email'];
								$subject = "Info nog versturen naar {$module} {$_REQUEST['record']}";
								$message = 'Via je telefoon heb je aangegeven dat je nog info wilt sturen naar:'."\n";
								$message.= "http://castellum.vicus.nl/index.php?module={$module}&action=DetailView&record={$_REQUEST['record']}";
								mail($emailTo, $subject, $message, $emailHeaders);								
								$newActionDate  = date('Y-m-d', mktime(0, 0, 0, date("m")  , date("d")+1, date("Y")));
								$doUpdateMsg = "{$status} FUP {$newActionDate}"; 
								break;
						case 'AFSPRAAK':
								// when selected . send reminder per email to the user
								$emailTo = $_SESSION['user_email'];
								$subject = "Afspraak maken met {$module} {$_REQUEST['record']}";
								$message = 'Via je telefoon heb je aangegeven dat je nog een afspraak wilt maken met:'."\n";
								$message.= "http://castellum.vicus.nl/index.php?module={$module}&action=DetailView&record={$_REQUEST['record']}";
								mail($emailTo, $subject, $message, $emailHeaders);								
								$newActionDate  = date('Y-m-d', mktime(0, 0, 0, date("m")  , date("d")+1, date("Y")));
								$doUpdateMsg = "{$status} FUP {$newActionDate}"; 
								break;
						case 'FOLLOWUP':
								$newActionDate  = date('Y-m-d', mktime(0, 0, 0, date("m")  , date("d")+1, date("Y")));
								$doUpdateMsg = "{$status} FUP {$newActionDate}"; 
								break;
						case 'QUALIFIED':
								$newActionDate  = date('Y-m-d', mktime(0, 0, 0, date("m")  , date("d")+1, date("Y")));
								$doUpdateMsg = "{$status} FUP {$newActionDate}"; 
								break;
						case 'QOUT':
								$newActionDate  = date('Y-m-d', mktime(0, 0, 0, date("m")  , date("d"), date("Y")));
								$doUpdateMsg = "{$status} Geen FUP"; 
								break;

						default:
								$newActionDate  = date('Y-m-d', mktime(0, 0, 0, date("m")  , date("d")+1, date("Y")));
								$doUpdateMsg = "{$status} FUP {$newActionDate}"; 
								break;
					}

					// update status
					$sql = "UPDATE {$table} SET {$field}=? WHERE {$fieldid}=?";
					$updateAction = $adb->pquery($sql, array($status, $_REQUEST['record']));
					
					// update description & modified time field
					// duplicate message now
					//$newActionNote = "Status {$status}";
					//updateDescription($module,$_REQUEST['record'],$newActionNote);
				} else {
					echo '<font style="color:red;">Actie '.$_REQUEST['action'] ." wordt voor {$module} nog niet ondersteund!</font>";
					die();
				}
				break;

			case 'LUUK':
			case 'HELENUS':
			case 'JOOST':
				// so we're changing the assignment
				require_once('modules/Users/Users.php');			
				$oUser = new Users();				
				$newUserId = $oUser->retrieve_user_id($_REQUEST['action']);

				if($newUserId)
				{
					// update description & timestamp
					$newActionNote = "Toegewezen aan {$_REQUEST['action']}";
					updateDescription($module,$_REQUEST['record'],$newActionNote);
					// update assignment
					$sql = 'UPDATE vtiger_crmentity SET smownerid=? WHERE crmid=?';
					$updateAction = $adb->pquery($sql, array($newUserId,$_REQUEST['record']));				
				} else {
					echo 'ERROR - user not found '.$_REQUEST['action'];
					die();
				}
				$doUpdateAction = false;
				$showSummary = true;
				break;
			case 'MVDGEIJS':
			case 'HARRY':
			case 'QMAKSOUDI':
			case 'JPOLIME':
			case 'SHUISKAMP':
			case 'INEKE':
			case 'AKRIJT':
			case 'JDEVRIES':
				die("user not active, try again");
			default: 
				$doUpdateAction = false;
//				$_GET['action'] = 'DetailView';
		}
	}
	
	if($doUpdateAction) 
	{
		$msg = '';
		$newActionNote = "{$doUpdateMsg}"; // {$doUpdateAction}
		switch ($_REQUEST['module'])
		{
			case 'Leads':					
					// Update next action date
					if (isValidFieldName($leadNextActionDateField)) {
//						$sql = 'UPDATE vtiger_leadscf SET '.$leadNextActionDateField.'=? WHERE leadid=?';
						$sql = 'UPDATE vtiger_leaddetails SET '.$leadNextActionDateField.'=? WHERE leadid=?';
						$updateAction = $adb->pquery($sql, array($newActionDate,(int)$_REQUEST['record']));
//						print $sql;
//						print_r($adb); die();
					}
					// Add new message
					updateDescription($module,$_REQUEST['record'],$newActionNote);
					break;
			case 'Potentials':			
					// Update next action date
					if (isValidFieldName($leadNextActionDateField)) {
//						$sql = 'UPDATE vtiger_potentialscf SET '.$potentialNextActionDateField.'=? WHERE potentialid=?';
						$sql = 'UPDATE vtiger_potential SET '.$potentialNextActionDateField.'=? WHERE potentialid=?';
						$updateAction = $adb->pquery($sql, array($newActionDate,(int)$_REQUEST['record']));
						//print_r($adb); die();
					}
					// Add new message
					updateDescription($module,$_REQUEST['record'],$newActionNote);			
					break;
			case 'Calendar':
					$newActionNote = '';
					// Add new message
//					$newActionNote = date('ymd')." {$login_user_name} - {$doUpdateAction} {$doUpdateMsg}\n".$readAction->fields[$potentialActionNotesField];
					// Update
					$newStartDate = substr($newActionDate,0,10);
					$newStartTime = substr($newActionDate,11,5);

					// read old time 
					$sql = 'SELECT date_start, due_date, time_start, time_end FROM vtiger_activity WHERE activityid=?';
					$readAction = $adb->pquery($sql, array((int)$_REQUEST['record']));
					$oldStartTime = $readAction->fields['time_start'];
					$oldEndDate = $readAction->fields['due_date'];					
					
					// if starttime changes, we should also change the end time, whcih has impact on whole date calculations
					// so need to do a new mktime !
					if($oldEndDate < $newStartDate) {
						$newActionNote .= 'Due date aangepast!'."\n";
						$oldEndDate = $newStartDate;
					}

					// if times defer we have risk of date overflow, so recalculate from scratch
					if($newStartTime != $oldStartTime)
					{
						$oldEndTime = $readAction->fields['time_end'];
						
						$hour = (int)substr($newStartTime,0,2);
						$minute = (int)substr($newStartTime,3,2);
						$month = (int)substr($newStartDate,5,2);
						$day = (int)substr($newStartDate,8,2);
						$year = (int)substr($newStartDate,0,4);
						$actionStartDateTime  = date('Y-m-d H:m:i', mktime($hour, $minute, 0, $month, $day, $year));
//						print "<br>New DT: $newStartDate $newStartTime $hour, $minute, 0, $month, $day, $year)";
						$newStartDate = substr($actionStartDateTime,0,10);
						$newStartTime = substr($actionStartDateTime,11,5);

						$hour = (int)substr($oldEndTime,0,2);
						$minute = (int)substr($oldEndTime,3,2);
						$month = (int)substr($oldEndDate,5,2);
						$day = (int)substr($oldEndDate,8,2);
						$year = (int)substr($oldEndDate,0,4);
//						print "<br>Old DT: $oldEndDate $oldEndTime $hour, $minute, 0, $month, $day, $year)";
						$actionEndDateTime  = date('Y-m-d H:m:i', mktime($hour, $minute, 0, $month, $day, $year));
						$newEndDate = substr($actionEndDateTime,0,10);
						if (!empty($oldEndTime)) {
							$newEndTime = substr($actionEndDateTime,11,5);
						} else {
							$newEndTime ='';
						}
					}
					
					$newActionNote .= date("ymd").' '.$login_user_name.' - Calender '.$doUpdateMsg."\n";
					 
					$sql = 'UPDATE vtiger_activity SET date_start=?, time_start=?, due_date=?, time_end=?  WHERE activityid=?';
//					print "Upd: |$actionStartDateTime >|$newStartDate|$newStartTime|$actionEndDateTime >|$newEndDate|$newEndTime|"; die();
					$updateAction = $adb->pquery($sql, array($newStartDate,$newStartTime,$newEndDate,$newEndTime,$_REQUEST['record']));	
					
					// Add new message
					updateDescription($module,$_REQUEST['record'],$newActionNote);

					break;
					
    case 'Accounts':

        $page .= 'Account not yet supported on line '.__LINE__;
        break;
					
			default: 
			  die('Module not supported');
		}
		$showSummary = true;
	}
	
	if($showSummary) {
		echo $htmlHeader;
		echo "\n\t".'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a class="link" href="javascript:window.close();"><img border="0" src="veb/mobilecrm/images/mobilecrm-undo.png" width="100px" alt="[Terug]"></a>';
		echo '<br /><br /><br />';
		echo "Updated:";
		echo '<ul>';
//		echo "<li>SQL      :".$sql.'</li>';
		echo "<li>New date :".$newActionDate.'</li>';
		echo "<li>Do action:".$doUpdateAction.'</li>';
		echo "<li>Actuele notitie:".nl2br($newActionNote).'</li>';
		echo '</ul><br />';
		echo $htmlFooter;

		die();
	}

	$html_headers = get_request_headers();

	$user_agent = $html_headers['User-Agent'];
	// Mozilla/5.0 (iPhone; U; CPU iPhone OS 4_1 like Mac OS X; nl-nl) AppleWebKit/532.9 (KHTML, like Gecko) Version/4.0.5 Mobile/8B117 Safari/6531.22.7
	
	if (stristr($user_agent, 'iphone')) 
	{
		$device = 'iPhone'; 
		$mobile = true;
		$screenWidth = '100%';
	}
	else 
	{
		$device = 'other';
		$mobile = false;
		$screenWidth = '100%';
	}
	
//	$page = '<div class="main">';

	$page = '<body style="width:'.$screenWidth.';"><div id="vebmobilemain" class="vebmobilemain" style="width:'.$screenWidth.';">';
	
	if ($_GET['action'] == 'DetailView')
	{
		// lead or potential?
		// valid id?
		// set to list mode or page mode

		switch ($_GET['module'])
		{
			case 'Leads':
			
				// if fields are false (i.c. not supported) we don't call them from database
					$sql = buildLeadQuery("ld.leadid = ".$_GET['record']);
						
					$result = $adb->pquery($sql, array());
					$leadRow = $result->fields;
					
					$page .= formatProspectLineDetailView(
						'ID',
						$leadRow['lead_no'].' - '.strtoupper($leadRow['leadstatus'])
						);
											
					if ($leadBudgetField AND $leadChanceField) 
					{
						$page .= formatProspectLineDetailView(
							'Verwachting',
							'&euro;&nbsp;'.number_format ( (float)$leadRow[$leadBudgetField]/1000, 0, $dec_point, $thousands_sep).'k'
							.' x '
							.number_format ( (float)$leadRow[$leadChanceField], 0, $dec_point, $thousands_sep).'%'
							);
					} elseif ($leadBudgetField)  {
						$page .= formatProspectLineDetailView(
							'Verwachting',
							'&euro;&nbsp;'.number_format ( (float)$leadRow[$leadBudgetField]/1000, 0, $dec_point, $thousands_sep).'k'
							);
					};
					$page .= formatProspectLineDetailView(
						'Contact',
						cleanSalutation($leadRow['salutation']).' '.$leadRow['firstname'].' '.$leadRow['lastname']
						);
					$page .= formatProspectLineDetailView(
						'Bedrijf',
						$leadRow['company']
						);
					$page .= formatProspectLineDetailView(
						'Adres',
						$leadRow['city'].' '.$leadRow['country']
						);
//					print_r($leadRow);
					$page .= formatProspectLineDetailView(
						'Industrie',
						$leadRow['industry'].' '.$leadRow['branche']
						);
					$page .= formatProspectLineDetailView(
						'Telefoon',
						format_phone($leadRow['phone'])
						);
					$page .= formatProspectLineDetailView(
						'Mobiel',
						format_phone($leadRow['mobile'])
						);
					$page .= formatProspectLineDetailView(
						'E-mail',
						'<a href="mailto:'.$leadRow['email'].'">'.$leadRow['email'].'</a>'
						);
						
					$page .= formatProspectLineDetailView(
						'Bron',
						$leadRow['leadsource'].' '.$leadRow['source_background']
						);

					$page .= formatProspectLineDetailView(
						'Prioriteit',
						$leadRow['priority']
						);

					$page .= formatProspectLineDetailView(
						'LinkedIn',
						$leadRow['linkedin']
						);

					$page .= formatProspectLineDetailView(
						'Interesse',
						$leadRow[$leadInterestedField].' '.$leadRow[$leadProductsField].' '.$leadRow[$leadSolutionsField]
						);
					$page .= formatProspectLineDetailView(
						'Gemaakt',
						$leadRow['createdtime']
						);

					$page .= formatProspectLineDetailView(
						'Aangepast',
						$leadRow['modifiedtime']
						);

					$page .= formatProspectLineDetailView(
						'Behandeld',
						$leadRow['user_name']
						);

					$page .= formatProspectLineDetailView(
						'Campagne',
						$leadRow['campaign']
						);

					if ($leadRow['req_users']) $page .= formatProspectLineDetailView(
						'Gebruikers',
						$leadRow['req_users']
						);
					if ($leadRow['req_interfaces']) $page .= formatProspectLineDetailView(
						'Koppelingen',
						$leadRow['req_interfaces']
						);
					if ($leadRow['req_functions']) $page .= formatProspectLineDetailView(
						'Functies',
						$leadRow['req_functions']
						);
					if ($leadRow['req_goals']) $page .= formatProspectLineDetailView(
						'Doelen',
						$leadRow['req_goals']
						);
					if ($leadRow['req_replacing']) $page .= formatProspectLineDetailView(
						'Vervangt',
						$leadRow['req_replacing']
						);
					if ($leadRow['req_hosted']) $page .= formatProspectLineDetailView(
						'Hosted',
						$leadRow['req_hosted']
						);

					$page .= '<tr class="prospect-row"><td colspan="3" class="prospect-cell">'.nl2br($leadRow['actionnotes']).'</td></tr>';
					$page .= '<tr class="prospect-row"><td colspan="3" class="prospect-cell">'.$leadRow['description'].'</td></tr>';
										
					$page .= '<tr class="prospect-row"><td colspan="3" class="prospect-cell">';
//					$page .= '<br /><h2>Acties</h2>';
					$activities = getRelatedActivities('Leads',$leadRow['leadid'], 'all');
					$page .= $activities['html'];
					$page .= '</td></tr>';
					$page .= '</table>';

					$page .= getButtonsDetailView('Leads',$leadRow['leadid'],$listForUser);

					$subject = 'Dictaat: '.$leadRow['company'].' - '.$leadRow['firstname'].' '.$leadRow['lastname'];
				break;
				
			case 'Potentials':

					$sql = buildPotentialQuery("po.potentialid = ".$_GET['record']);
			
					$result = $adb->pquery($sql, array());
					$potentialRow = $result->fields;
					
					$page .= formatProspectLineDetailView(
						'ID',
						$potentialRow['potential_no'].' - '.strtoupper($potentialRow['sales_stage'])
						);					
					$page .= formatProspectLineDetailView(
						'Naam',
						$potentialRow['potentialname']
						);
					$page .= formatProspectLineDetailView(
						'Verwachting',	
						'&euro;&nbsp;'.number_format ( (float)$potentialRow['amount']/1000, 0, $dec_point, $thousands_sep).'k'
						.' x '
						.number_format ( (float)$potentialRow['probability'], 0, $dec_point, $thousands_sep).'%'
						);
					$page .= formatProspectLineDetailView(
						'Contact',
//						$potentialRow['salutation'].' '.$potentialRow['firstname'].' '.$potentialRow['lastname']
						getPotentialContactBlock($potentialRow['potentialid'],true)
						);
					$page .= formatProspectLineDetailView(
						'Bedrijf',
						$potentialRow['accountname']
						);
/*
					$page .= formatProspectLineDetailView(
						'Telefoon',
						format_phone($potentialRow['phone'])
						);
					$page .= formatProspectLineDetailView(
						'Mobiel',
						format_phone($potentialRow['mobile'])
						);
					$page .= formatProspectLineDetailView(
						'E-mail',
						'<a href="mailto:'.$potentialRow['email'].'">'.$potentialRow['email'].'</a>'
						);
*/
/*
					$page .= formatProspectLineDetailView(
						'Interesse',
						$potentialRow['cf_541'].' '.$potentialRow['cf_540'].' '.$potentialRow['cf_538']
						);
*/
					$page .= formatProspectLineDetailView(
						'Campagne',
						$potentialRow['campaign']
						);

					if ($potentialRow['req_users']) $page .= formatProspectLineDetailView(
						'Gebruikers',
						$potentialRow['req_users']
						);
					if ($potentialRow['req_interfaces']) $page .= formatProspectLineDetailView(
						'Koppelingen',
						$potentialRow['req_interfaces']
						);
					if ($potentialRow['req_functions']) $page .= formatProspectLineDetailView(
						'Functies',
						$potentialRow['req_functions']
						);
					if ($potentialRow['req_goals']) $page .= formatProspectLineDetailView(
						'Doelen',
						$potentialRow['req_goals']
						);
					if ($potentialRow['req_replacing']) $page .= formatProspectLineDetailView(
						'Vervangt',
						$potentialRow['req_replacing']
						);
					if ($potentialRow['req_hosted']) $page .= formatProspectLineDetailView(
						'Hosted',
						$potentialRow['req_hosted']
						);

					$page .= '<tr class="prospect-row"><td colspan="3" class="prospect-cell">'.nl2br($potentialRow['actionnotes']).'</td></tr>';

					$page .= '<tr class="prospect-row"><td colspan="3" class="prospect-cell">'.nl2br($potentialRow['description']).'</td></tr>';
//					$page .= '</table>';
					$page .= '<tr class="prospect-row"><td colspan="3" class="prospect-cell">';
					$page .= '<h2>Akties</h2>';
					
					$activities = getRelatedActivities('Potentials',$potentialRow['potentialid'], 'all');
					$page .= $activities['html'];
					$page .= '</td></tr>';					

					$page .= getButtonsDetailView('Potentials',$potentialRow['potentialid'],$listForUser);

					$subject = 'Dictaat: '.$potentialRow['accountname'].' - '.$potentialRow['potentialname'];
				break;

			case 'Calendar':
					$sql = 'SELECT 
								va.activityid,
								va.activitytype,
								va.date_start,
								va.time_start,
								va.status,
								va.eventstatus,
								va.location,
								va.priority,
								va.subject,
								ce.setype,
								ce.description,
								ce.status AS status2,
								u.user_name
							FROM
								vtiger_activity as va
							LEFT JOIN
								vtiger_crmentity as ce
							ON
								va.activityid = ce.crmid
							LEFT JOIN 
								vtiger_users as u
							ON
								ce.smownerid = u.id
							WHERE
								va.activityid = '.$_GET['record']
							;
					$result = $adb->pquery($sql, array());
					$calendarRow = $result->fields;
					
					$page .= formatProspectLineDetailView(
						'ID',
						$calendarRow['activityid'].' - '.strtoupper($calendarRow['status'])
						);
						
					$page .= formatProspectLineDetailView(
						'Onderwerp',
						$calendarRow['subject']
						);
						
					$page .= '<tr class="prospect-row"><td colspan="3" class="prospect-cell">'.nl2br($calendarRow['description']).'</td></tr>';
					$page .= '<tr class="prospect-row"><td colspan="3" class="prospect-cell">';
					$page .= '<h2>Relaties</h2>';
//					$activities = getRelatedActivities('Potentials',$calendarRow['potentialid'], 'all');
//					$page .= $activities['html'];
					$page .= '</td></tr>';					

					$page .= getButtonsDetailView('Calendar',$calendarRow['activityid'],$listForUser);

					$subject = 'Dictaat: '.$calendarRow['activityid'].' - '.$calendarRow['subject'];
				break;

      case 'Accounts':

        $page .= 'Account not yet supported on line '.__LINE__;
        break;

			default:
				break;
		}
		// action=DetailView&module=Leads&record=

		$header = "\n".'<table class="prospect-table" style="width:'.$screenWidth.';">';
		$header .= "\n\t".'<tr class="toolbar">';
		
		$header .= "\n\t".'<td style="text-align: center;" align="center"><a class="toolbar-link" href="javascript:window.close();"><img border="0" src="veb//mobilecrm/images/mobilecrm-undo.png" width="150px" alt="[Terug]"></a>'.'</td>';

/* not supported anymore
		switch ($device)
		{
			case 'iPhone': 
				$link = '<a href="winscribe://subject='.$subject.'&amp;user1='.$_GET['no'].'&amp;user2=luuk&amp;user3=vtiger51iphone&amp;jobt=crm1" rel="nofollow"><img border="0" src="veb/mobilecrm/images/mobilecrm-record.jpg" width="200px" alt="[Dicteer]"></a>';
				break;
			default:
				$link = '<a href="callto: '.$ivr_server_phone.'"><img border="0" src="veb/mobilecrm/images/mobilecrm-record.jpg" alt="[Dicteer]"></a>';
		}
*/
		$header .= "\n\t".'<td align="left">&nbsp;&nbsp;'.$link.'</td>';
		$header .= "\n\t".'<td align="left"><h1 class="page_title">Prospect</h1></td>';
		$header .= "\n\t".'<tr>';
//		$header .= "\n".'</table>';
//		$page .= "\n".'<table class="prospect-table">';

		print ($htmlHeader.$header.$page.$htmlFooter);

		die();
		
	}
	
	$listBlock = array();
	$pageBlock = array();
	
	###########################################################################
	#
	# get relevant LEADS
	# query the vtiger_notificationscheduler vtiger_table and get data for those notifications which are active
	#

	$sql = buildLeadQuery("	ld.leadstatus != 'Dood'
				AND ld.leadstatus != 'Dead'
				AND ld.leadstatus != 'Coma'
				AND ld.leadstatus != 'Target'
				AND ld.leadstatus != 'Geconverteerd' 
				AND ld.leadstatus != 'Converted' 
				
				AND ld.leadstatus != 'Warm houden met datum'
				AND ld.leadstatus != 'Warm houden'
				
				AND ld.leadstatus != 'CLOSED - lost'
				AND ld.leadstatus != 'CLOSED - verloren'
				AND ld.leadstatus != 'CLOSED - na deskresearch'
				AND ld.leadstatus != 'CLOSED - na 1e contact'
				AND ld.leadstatus != 'CLOSED - na 2e contact'
				AND ld.leadstatus != 'CLOSED - na kwalificatie'
				AND ld.leadstatus != 'CLOSED - doorverwezen'
				AND ld.leadstatus != 'CLOSED - na demo-proef-downl'

				AND ld.leadstatus != 'Uitval Reden onbekend'
				AND ld.leadstatus != 'Uitval Geen interesse'
				AND ld.leadstatus != 'Uitval Gediskwalificeerd'
				AND ld.leadstatus != 'Uitval Contact niet gelukt'
				AND ld.leadstatus != 'Uitval Dubbel'
				AND ld.leadstatus != 'Nurture'
				AND ld.leadstatus != 'Uitval Concurrent gekozen'
				AND ld.leadstatus != 'CLOSED lost'
				AND ld.leadstatus != 'Uitval Doorverwezen'
				
				AND ld.leadstatus != 'UITVAL - LOST'
				AND ld.leadstatus != 'UITVAL - QUALIFIED OUT'
				AND ld.leadstatus != 'NURTURE PARTNER'

				AND ld.leadstatus != 'Demo-Proef-Download fup 1'
				AND ld.leadstatus != 'Demo-Proef-Download fup 2'
				AND ld.leadstatus != 'Demo-Proef-Download fup 3'

				AND ld.leadstatus != ''
				AND ld.converted = 0
				AND ce.deleted = 0 
				".$selectUser);
	
	$result = $adb->pquery($sql, array());

	if($result)
	{

		// Leads found
		// Prospectlist
		while ($leadRow = $adb->fetch_array($result))
		{			
			$firstdate = '';
			$leadBlock = '';
			$sorted = array();

			$leadBlock .= "\n\t\t".'<table class="prospect-table">';

			if ($mobile) {
			  $leadBlock .= formatProspectLineListView(
					'',
					'<a href="vebmobilecrm.php?action=DetailView&module=Leads&user='.$listForUser.'&record='.$leadRow['leadid'].'&no='.$leadRow['lead_no'].'" target="_blank">'.$leadRow['lead_no'].'</a>&nbsp;<strong>'.	shortenCompanyName($leadRow['company']).'</strong>'
					);
			} else {
			$leadBlock .= formatProspectLineListView(
					'',
//					'<a href="index.php?action=DetailView&module=Leads&record='.$leadRow['leadid'].'" target="_blank">'.$leadRow['lead_no'].'</a>&nbsp;<strong>'.	shortenCompanyName($leadRow['company']).'</strong>'
					'<a href="index.php?module=Leads&view=Detail&record='.$leadRow['leadid'].'" target="_blank">'.$leadRow['lead_no'].'</a>&nbsp;<strong>'.	shortenCompanyName($leadRow['company']).'</strong>'
					);
			}
// http://intranet2.vicus.nl/crm/index.php?action=DetailView&module=Leads&record=202735

			$expected = ($leadBudgetField AND $leadChanceField) ? '  &euro;&nbsp;'.number_format ( (float)$leadRow[$leadBudgetField]/1000, 0, $dec_point, $thousands_sep).'k'.' x '.number_format ( (float)$leadRow[$leadChanceField], 0, $dec_point, $thousands_sep).'%' : "";

			$leadBlock .= formatProspectLineListView(
				'',
				strtoupper($leadRow['leadstatus']).$expected
				);

			$leadBlock .= formatProspectLineListView(
				'',
				$leadRow['cf_541'].' '.$leadRow['cf_540'].' '.$leadRow['cf_538']
				);
				
			$leadBlock .= formatProspectLineListView(
				'',
				cleanSalutation($leadRow['salutation']).' '.$leadRow['firstname'].' '.$leadRow['lastname']
				);
/*
			$leadBlock .= formatProspectLineListView(
				'',
				$leadRow['leadsource'].'<br>'.$leadRow['campaign']
				);
*/
/*
			$leadBlock .= '</table></td>';
			$leadBlock .= '</tr>';
*/
//			$personActions[$leadRow['firstname'].' '.$leadRow['lastname']][] = $leadRow['lead_no'];
			
			$sql = " SELECT 
						a.activityid,
						a.subject,
						a.activitytype,
						a.date_start,
						a.time_start,
						a.due_date,
						a.status AS activity_status,
						a.eventstatus,
						a.priority,
						ce.crmid,
						ce.smcreatorid,
						ce.smownerid,
						ce.modifiedby,
						ce.setype,
						ce.description,
						ce.createdtime,
						ce.status AS entity_status,
						ce.deleted
					FROM 
						vtiger_activity as a
					LEFT JOIN
						# table: vtiger_seactivityrel ( crmid, activityid) 
						vtiger_seactivityrel as sar
					ON
						a.activityid = sar.activityid
					LEFT JOIN
						#  crmid, smcreatorid, smownerid, modifiedby, setype, description
						vtiger_crmentity as ce
					ON
						sar.activityid = ce.crmid
					WHERE
						sar.crmid = {$leadRow['leadid']}
						AND ce.deleted = 0
		#				AND (ce.setype = 'Calendar')
						AND (ce.setype != 'Emails')
		#				AND (a.activitytype = 'Task' OR a.activitytype = 'Call')
		#				AND (a.status = 'Planned' 
			#					OR a.eventstatus = 'Planned' 
			#					OR a.eventstatus = 'Gepland' 
			#					OR a.status = 'In Progress' 
			#					OR a.status = 'Not Started'
			#					OR a.status = 'Pending Input'
			#					OR a.status = 'Deferred'
			#					)
						AND (
							a.eventstatus != 'Held'
							AND a.eventstatus != 'Not Held'
							# AND a.status != 'Completed'
							)
			#			AND a.status != 'Completed'
			#			AND (a.activitytype = 'Task' AND a.status != 'Completed')
						
					;				
				";
				
			$result2 = $adb->pquery($sql, array());		
						
			if (is_array($result2->fields))
/*
			$actionsBlock = getRelatedActivities('Leads',$potentialRow['leadid'], 'all');

			if ($actionsBlock)
*/
			{

				// Leads found
				$i=1;
				while ($leadRow2 = $adb->fetch_array($result2))
				{
				
					$i++;
					$dateToSortOn = $leadRow2['date_start'].$leadRow2['time_start'];
					
					$sorted[$dateToSortOn.'-'.$i] = $leadRow2;
					$crmEntityLog[$leadRow2['crmid']]=$leadRow2;//['crmid']; // log that we handled it already
				}	
				
				ksort($sorted);
				
				$leadDetailBlock = '';
				
//				$leadDetailBlock = "\n\t".'<table class="actions">';
				
				foreach ($sorted as $key => $value)
				{
					// recover some leakage from the query
					if ($value['activity_status'] == 'Completed' && $value['activitytype'] == 'Task') 
					{
						// do nothing
//						print '<pre>NOK '; print $leadRow['lead_no'].' '; print_r($value);
					} else {
						$leadDetailBlock .= "\n\t\t\t".'<tr class="actions">';
/*
						$leadDetailBlock .= '<td style="border:0px solid black;">&nbsp;</td>';
						// $value['setype'] .' '. 
						$leadDetailBlock .= '<td style="border:1px solid black;vertical-align:top;" colspan="4"><strong>'.$value['date_start'].'</strong> - '.$value['activitytype']. ' - '. $value['eventstatus'].'/'.$value['activity_status'].'/'.$value['entity_status'].' - '.$value['subject'].'<br>'.$value['description']. '</td>';
						$leadDetailBlock .= "\n\t\t\t".'<td class="prospect-label">'.$value['date_start'].'</td>';
						$leadDetailBlock .= "\n\t\t\t".'<td class="prospect-value">'.$value['activitytype']. ' - '. $value['eventstatus'].'/'.$value['activity_status'].'/'.$value['entity_status'].' - '.$value['subject'].'</td>';
				*/
						$leadDetailBlock .= formatProspectLineListView(
							$value['date_start'].' '.$value['time_start'],
							$value['activitytype']. ' - '. $value['eventstatus'].$value['activity_status'].$value['entity_status'].' - '.$value['subject']
							);

	//					$leadDetailBlock .= '<td style="border:0px solid black;" colspan="2">&nbsp;</td>';
						$leadDetailBlock .= "\n\t\t\t"."</tr>";

					}	
					// strange if prio is high and status = Coma
				}
				
				$leadDetailBlock .= "\n\t\t".'</table>';

				if (!empty($leadRow['nextactiondate'])) {
					$dateToSortOn = $leadRow['nextactiondate']." 09:00:00";
				} else {
					$dateToSortOn = $leadRow2['date_start'].$leadRow2['time_start'];
				}

				$listBlock[$dateToSortOn.' '.$leadRow['leadid']] = $leadBlock.$leadDetailBlock;
/*
				if ($value['activity_status'] == 'Completed' && $value['activitytype'] == 'Task') 
				{
					print '<pre>NO ! '; print $leadRow['lead_no'].' '; print_r($value);
					$listBlock[$firstdate.' '.$leadRow['leadid']] = $leadBlock;
				} else {
					print '<pre>YES '; print $leadRow['lead_no'].' '; print_r($value);
				}
*/
			}
			else 
			{

				#
				# If no actions are found fill the no action blocks
				#

				$assignedToUser = $leadRow['user_name'];
/*
				$noaction[$assignedToUser] .= "\n<ul><li>";
				$noaction[$assignedToUser] .= $leadRow['leadid']. ' ';
				$noaction[$assignedToUser] .= $leadRow['lead_no']. ' ';
				$noaction[$assignedToUser] .= $leadRow['company']. ' - ';
				$noaction[$assignedToUser] .= $leadRow['firstname']. ' ';
				$noaction[$assignedToUser] .= $leadRow['lastname']. ' - ';
				$noaction[$assignedToUser] .= $leadRow['leadsource']. ' (';
				$noaction[$assignedToUser] .= $leadRow['leadstatus']. ' ';
				$noaction[$assignedToUser] .= $leadRow['user_name']. ') ';	
				$noaction[$assignedToUser] .=  ' - geen aktie gevonden!</li></ul>';
*/
/*
//				$leadBlock .= "\n\t".'<table class="actions">';
				$leadBlock .= "\n\t\t\t".'<tr class="prospect-row">';
//				$leadBlock .= '<td style="border:0px solid black;">&nbsp;</td>';
				// $value['setype'] .' '. 
				$leadBlock .= "\n\t\t\t".'<td class="prospect-label">Akties</td>';
				$leadBlock .= "\n\t\t\t".'<td class="prospect-value">Geen acties gepland!</td>';
				$leadBlock .= "\n\t\t\t"."</tr>";
*/

//print_r($leadRow);

				if (!empty($leadRow['nextactiondate'])) {
					$dateToSortOn = $leadRow['nextactiondate']." 09:00:00";;
					$leadBlock .= formatProspectLineListView(
							$leadRow['nextactiondate'],
							"Opvolging"
							);
				} else {
					// don;t overload today with old not scheduled stuff
					$nextWorkingDay  = mktime(0, 0, 0, date("m")  , date("d")+datetimehelper::daysTillNextWorkingDay(), date("Y"));
					$dateToSortOn = date('Y-m-d',$nextWorkingDay." 23:59:00");
					$leadBlock .= formatProspectLineListView(
							$dateToSortOn,
							"Opvolging ".'<font style=""></font>'
							);
							// 							"Opvolging ".'<font style="color:red;">- Niets gepland!</font>'
				}

				$leadBlock .= "\n\t\t".'</table>';
				$listBlock[$dateToSortOn.' '.$leadRow['leadid']] = $leadBlock;

			}
		}
		
	} else {
		die('FAILED query: '.$sql);
	}


	###########################################################################
	#
	# get relevant POTENTIALS
	# query the vtiger_tables and get data
	#

/*
	cp.salutation,
	cp.firstname,
	cp.lastname,
	cp.email,
	a.phone,
	a.mobile,
	pocf.cf_612 AS req_interfaces,
	pocf.cf_609 AS req_functions,
	pocf.cf_613 AS req_goals,
	pocf.cf_610 AS req_replacing,
	pocf.cf_617 AS req_hosted,
	pocf.cf_615 AS req_usage,
	pocf.cf_608 AS req_users,
*/
	
	$cf_where = ($potentialNextActionDateField) ? "po.{$potentialNextActionDateField}" : "closingdate";
	$where = " po.sales_stage != 'Closed Won'
				AND po.sales_stage != 'Closed Lost'
				AND po.sales_stage != 'Gesloten Verloren'
				AND po.sales_stage != 'Gesloten Gewonnen'
				 	
				AND po.sales_stage != 'On Hold'
				AND po.sales_stage != 'Closed By Us'
				AND po.sales_stage != 'Gesloten door Vicus'
				AND po.sales_stage != 'Cancelled By Customer'
				AND po.sales_stage != 'Coma'
				AND po.sales_stage != 'Delivered'
				AND po.sales_stage != 'Nurture'
				AND po.sales_stage != 'Nurture Partner'
				AND po.sales_stage != 'Uitvoering'
				
				AND po.sales_stage != 'Uitval Gediskwalificeerd'
				AND po.sales_stage != 'Uitval Verloren'
				
				AND po.sales_stage != 'Project Afgeleverd'
				AND po.sales_stage != 'Uitval - Lost'
				AND po.sales_stage != 'Uitval - Qualified Out'
				AND po.sales_stage != 'Project in Uitvoering'

				AND po.sales_stage != 'Project in onderhoud'				
				
				AND ce.deleted = 0
 				AND ({$cf_where} < '".date("Y-m-d", strtotime("+1 months"))."') 
				{$selectUser}";
	
	$sql = buildPotentialQuery($where);

	$result = $adb->pquery($sql, array());

	if($result)
	{
		// Potentials found
		while ($potentialRow = $adb->fetch_array($result))
		{
			$contactBlock = getPotentialContactBlock($potentialRow['potentialid']);		

			$activities = getRelatedActivities('Potentials',$potentialRow['potentialid'], 'open');
			$actionsBlock= $activities['html'];


			$firstdate = $activities['firstdate'];
			
			if (!$firstdate) {
				$firstdate = $potentialRow['action_date'];
			}
			
			$potentialBlock = '';
			$sorted = array();

			$potentialBlock .= "\n\t\t".'<table class="prospect-table">';

			if ($mobile) {
			$potentialBlock .= formatProspectLineListView(
					'<a href="vebmobilecrm.php?action=DetailView&module=Potentials&user='.$listForUser.'&record='.$potentialRow['potentialid'].'&no='.$potentialRow['potential_no'].'" target="_blank">'.$potentialRow['potential_no'].'</a>',
					'<strong>'.shortenCompanyName($potentialRow['accountname']).'</strong>'
					);
			} else {
			$potentialBlock .= formatProspectLineListView(
				'<a href="index.php?module=Potentials&view=Detail&record='.$potentialRow['potentialid'].'" target="_blank">'.$potentialRow['potential_no'].'</a>',
				'<strong>'.shortenCompanyName($potentialRow['accountname']).'</strong>'
				);
			}



			$potentialBlock .= formatProspectLineListView(
				'',
				shortenPotentialName($potentialRow['potentialname'],$potentialRow['accountname'])
				);
								
			$potentialBlock .= formatProspectLineListView(
				'',
				$potentialRow['city'].' '.strtoupper($potentialRow['sales_stage']). '  &euro;&nbsp;'.number_format ( (float)$potentialRow['amount']/1000, 0, $dec_point, $thousands_sep).'k'.' x '.number_format ( (float)$potentialRow['probability'], 0, $dec_point, $thousands_sep).'%'
				);
/*
			$potentialBlock .= formatProspectLineListView(
				'Interesse',
				$potentialRow['cf_541'].' '.$potentialRow['cf_540'].' '.$potentialRow['cf_538']
				);
*/
			$potentialBlock .= formatProspectLineListView(
				'',
//					$potentialRow['salutation'].' '.$potentialRow['firstname'].' '.$potentialRow['lastname']
				$contactBlock
				);
/*	
			$potentialBlock .= formatProspectLineListView(
				'',
				$potentialRow['leadsource'].'<br>'.$potentialRow['campaign']
				);
*/				

			if ($actionsBlock)
			{
				$potentialBlock .= $actionsBlock;
// $potentialRow['action_date'].' '


				$listBlock[$firstdate.' '.$potentialRow['potentialid']] = $potentialBlock;
			} 
			else 
			{	
				#
				# If no actions are found fill the no action blocks
				#
/**
				$assignedToUser = $potentialRow['user_name'];
				$noaction[$assignedToUser] .= "\n<ul><li>";
				$noaction[$assignedToUser] .= $potentialRow['potentialid']. ' ';
				$noaction[$assignedToUser] .= $potentialRow['potential_no']. ' ';
				$noaction[$assignedToUser] .= $potentialRow['accountname']. ' - ';
				$noaction[$assignedToUser] .= $potentialRow['potentialname']. ' - ';
				$noaction[$assignedToUser] .= $potentialRow['leadsource']. ' (';
				$noaction[$assignedToUser] .= $potentialRow['sales_stage']. ' ';	
				$noaction[$assignedToUser] .= $potentialRow['user_name']. ')';	
				$noaction[$assignedToUser] .= ' - geen aktie gevonden!</li></ul>';
*/
				if (!empty($potentialRow['nextactiondate'])) {
					$dateToSortOn = $potentialRow['nextactiondate']." 09:00:00";;
					$potentialBlock .= formatProspectLineListView(
							$potentialRow['nextactiondate'],
							"Opvolging"
							);
				} else {
					// don;t overload today with old not scheduled stuff
					$nextWorkingDay  = mktime(0, 0, 0, date("m")  , date("d")+datetimehelper::daysTillNextWorkingDay(), date("Y"));
					$dateToSortOn = date('Y-m-d H:m:i',$nextWorkingDay." 23:59:00");
					$potentialBlock .= formatProspectLineListView(
							$dateToSortOn,
							"Opvolging ".'<font style="color:red;">- Niets gepland!</font>'
							);
				}

				$potentialBlock .= "\n\t\t".'</table>';
				$listBlock[$dateToSortOn.' '.$potentialRow['potentialid']] = $potentialBlock;
			}
		}
	} else {
		die( 'FAILED query '.$sql );
	}

	###########################################################################
	#
	# Get any Tasks and Calendar items and filter out what we did not cover yet
	# all that was coverde is captured in $crmEntityLog
//				u.user_name,
	$maxActionDate  = date('Y-m-d', mktime(0, 0, 0, date("m")  , date("d")+100, date("Y")));
	$sql = 'SELECT 
				va.activityid,
				va.activitytype,
				va.date_start,
				va.time_start,
				va.status,
				va.eventstatus,
				va.location,
				va.priority,
				va.subject,
				ce.setype,
				ce.description,
				ce.status AS status2,
				u.user_name
			FROM
				vtiger_activity as va
			LEFT JOIN
				vtiger_crmentity as ce
			ON
				va.activityid = ce.crmid
			LEFT JOIN 
				vtiger_users as u
			ON
				ce.smownerid = u.id
			WHERE
				va.activitytype IN ("Task", "Call", "Meeting")
				AND activityid NOT IN ('.implode(',',array_keys($crmEntityLog)).') 
				AND date_start < "'.$maxActionDate.'"
				AND va.status NOT IN ("Completed")
				AND u.user_name = "'.$listForUser.'"
				AND ce.deleted = 0
				AND 1=3
			';

	// AND date_start < "'.date("Y-m-d").'"
	$result = $adb->pquery($sql, array());
	if($result)
	{
		// Actions found
		while ($calendarRow = $adb->fetch_array($result))
		{
// Call
// ?action=DetailView&module=Calendar&record=98352&activity_mode=Events&viewtype=calendar&parenttab=Marketing
// Vergadering
// ?action=DetailView&module=Calendar&record=103376&activity_mode=Events&viewtype=calendar&parenttab=Marketing
// Todo
// ?action=DetailView&module=Calendar&record=6739&activity_mode=Task&parenttab=Marketing	
// ?action=DetailView&module=Calendar&record=87212&user=luuk
			$calendarBlock = '';
			$calendarBlock .= "\n\t\t".'<table class="prospect-table">';
			$calendarBlock .= formatProspectLineListView(
					'<a href="vebmobilecrm.php?action=DetailView&module=Calendar&record='.$calendarRow['activityid'].'&user='.$listForUser.'" target="_blank">ACT'.$calendarRow['activityid'].'</a>',
					'<strong>'.$calendarRow['subject'].'</strong>'
					);

			$calendarBlock .= formatProspectLineListView(
				'Start',
				$calendarRow['date_start'].' '.$calendarRow['time_start'].' '.$calendarRow['status'].' '.$calendarRow['priority']
				);
			$calendarBlock .= formatProspectLineListView(
				'',
				$calendarRow['description']
				);
			$calendarBlock .= formatProspectLineListView(
				'Locatie',
				$calendarRow['location']
				);
			
			$calendarBlock .= "\n\t\t".'</table>';
			$dateToSortOn = $calendarRow['date_start'].$calendarRow['time_start'];
			$listBlock[$dateToSortOn.' '.$calendarRow['activityid']] = $calendarBlock;
		}	
	}


	###########################################################################
	#
	# Compose the report
	#
	/*
	$page .= "\n".'<table class="prospect-table">';
	$page .= "\n\t".'<tr class="toolbar">';
	$page .= "\n\t".'<td width="10%" align="center">&nbsp;</td>';
	$page .= "\n\t".'<td width="80%" align="center"><h1 class="page_title">Getting Things Done</h1></td>';
	$page .= "\n\t".'<td width="10%" align="center">&nbsp;</td>';
	$page .= "\n\t".'<tr>';
	$page .= "\n".'</table>';
	*/
	$page .= "\n".'<table class="main-table">';
	$page .= "\n\t".'<tr class="toolbar">';
	$qty = count($listBlock);
	$page .= "\n\t".'<td colspan=10 align="center"><h1 class="page_title">'.$listForUser.' is Getting '.$qty.' Things Done</h1></td>';
//	$page .= "\n\t".'<tr>';
	$page .= "\n\t".'<tr class="main-row">';
	$page .= "\n\t\t".'<td class="main-cell">';
	ksort($listBlock);

	foreach ($listBlock as $key => $block)
	{
		// only show stuf not further than 2 days ahead to spead up a bit
		$datePlan = strtotime(substr($key,0,10));
		$dateNow = strtotime(date('Y-m-d'));
		$diff = $datePlan - $dateNow;
//		print "$diff = $datePlan - $dateNow;"; // seconds = 86400 per day
		$maxDiff = 3 * 86400; // 2 days ahead
		if ($qty < 40) $maxDiff = 10 * 86400; // 5 days ahead
		if ($diff > $maxDiff) continue;
		$page .= $block;
		$page .= "\n";
	}
	
	$page .= "\n\t\t".'</td>';
	$page .= "\n\t".'</tr>';
	$page .= "\n".'</table>';

	foreach((array)$noaction[$assignedToUser] as $key => $noactionRecord)
	{
		$page .= $noactionRecord;
	}
	$page .= "\n";
	$page .= getButtonsListView('','','');
	$page .= '</div>';  // vebmobilemain
	$page .= '</body>';
	$page .= "\n";
	$page .= '</html>';

print( $htmlHeader.$page.$htmlFooter );

// ============================================================================================


function formatProspectLineDetailView($label, $content)
{
	$content = str_replace(' |##| ',', ', $content);

	$block = '';
	$block .= "\n\t\t\t".'<tr class="prospect-row">';
	$block .= "\n\t\t\t".'<td class="prospect-label">'.$label.'</td>';
	$block .= "\n\t\t\t".'<td colspan="2" class="prospect-value">'.$content.'</td>';
	$block .= "\n\t\t\t"."</tr>";
	$block .= "\n";
	return $block;
}

function formatProspectLineListView($label = "", $content)
{
	$content = str_replace(' |##| ',', ', $content);
	$block = '';
	$block .= "\n\t\t\t".'<tr class="prospect-row">';
//	$block .= "\n\t\t\t".'<td class="prospect-label">'.$label.'</td>';
	$block .= "\n\t\t\t".'<td colspan="3" class="prospect-value">';
	if ($label) $block .= $label. ' - ';
	$block .= $content.'</td>';
	$block .= "\n\t\t\t"."</tr>";
	$block .= "\n";
	return $block;
}



function buildLeadQuery($where)
{
	global $leadBudgetField, $leadChanceField, $leadNextActionDateField,$leadActionNotesField,$leadInterestedField,$leadProductsField,$leadSolutionsField;

	$cf_select = '';
	$cf_select .= ($leadBudgetField) ? " ld.{$leadBudgetField}, " : '';
	$cf_select .= ($leadChanceField) ? " ld.{$leadChanceField}, " : '';
	$cf_select .= ($leadNextActionDateField) ? " ld.{$leadNextActionDateField} as nextactiondate, " : '';
	$cf_select .= ($leadActionNotesField) ? " ld.{$leadActionNotesField} as actionnotes, " : '';
	$cf_select .= ($leadInterestedField) ? " ld.{$leadInterestedField}, " : '';
	$cf_select .= ($leadProductsField) ? " ld.{$leadProductsField}, " : '';
	$cf_select .= ($leadSolutionsField) ? " ld.{$leadSolutionsField}, " : '';

//	$cf_select .= ' ld.c_picklist_solutions as lead_solutions, '; // was ldcf.cf_641
//	$cf_select .= ' ld.c_picklist_products as lead_products, '; // was ldcf.cf_541
//	$cf_select .= ' ld.c_lead_interest as lead_interest, '; // was ldcf.cf_538
	$cf_select .= ' ld.c_crm_users AS req_users, '; // was ldcf.cf_586
	$cf_select .= ' ld.c_desired_integrations AS req_interfaces, '; // was ldcf.cf_587
	$cf_select .= ' ld.c_essential_functions AS req_functions, '; // was ldcf.cf_588
	$cf_select .= ' ld.c_future_plans AS req_goals, '; // was ldcf.cf_589
	$cf_select .= ' ld.c_systems_to_replace AS req_replacing, '; // was ldcf.cf_590
//	$cf_select .= ' ldcf.cf_592 AS req_hosted, '; // niet gevonden
//	$cf_select .= ' ldcf.cf_598 AS req_usage, '; // niet gevonden
	$cf_select .= ' ld.c_lead_source_bg AS source_background, '; // ldcf.cf_597
	$cf_select .= ' ld.c_picklist_priorities AS priority, '; // ldcf.cf_886
	$cf_select .= ' ld.c_lead_linkedin AS linkedin, '; // ldcf.cf_653
	$cf_select .= ' ld.c_industry_particular AS branche, '; // ldcf.cf_928

	$where = " WHERE {$where} ";
	$order = ($leadNextActionDateField) ? " ORDER BY ld.{$leadNextActionDateField} ASC " : "";
$cf_select = "";

	$sql = "SELECT 
			ld.leadid,
			ld.lead_no,
			ld.company,
			ld.salutation,
			ld.firstname,
			ld.lastname,
			ld.leadsource,
			ld.leadstatus,
			ld.industry,
			ld.campaign,
			ld.email,
			".$cf_select."
			la.city,
			la.country,
			la.phone,
			la.mobile,
			u.user_name,
			u.email1,
			ce.description,
			ce.createdtime,
			ce.modifiedtime
		FROM 
			vtiger_leaddetails as ld 
		LEFT JOIN
			vtiger_leadscf as ldcf
		ON
			ld.leadid = ldcf.leadid
		LEFT JOIN
			#  crmid, smcreatorid, smownerid, modifiedby, setype, description
			vtiger_crmentity as ce
		ON
			ld.leadid = ce.crmid
		LEFT JOIN 
			vtiger_leadaddress as la
		ON
			ld.leadid = la.leadaddressid
		LEFT JOIN 
			vtiger_users as u
		ON
			ce.smownerid = u.id
		{$where}
		{$order}
			";
// 				AND ldcf.cf_596  < '".date("Y-m-d", strtotime("+1 months"))."'

	return $sql;
}

function buildPotentialQuery($where)
{
	global $potentialExpectedValueField, $potentialNextActionDateField, $potentialActionNotesField;

	$cf_select = '';
	$cf_select .= ($potentialExpectedValueField) ? "po.{$potentialExpectedValueField} AS expected_value,\n" : '';
	$cf_select .= ($potentialNextActionDateField) ? "po.{$potentialNextActionDateField} AS nextactiondate,\n" : '';				
	$cf_select .= ($potentialActionNotesField) ? "po.{$potentialActionNotesField} AS actionnotes,\n" : '';
	
	$where = " WHERE {$where} ";
	$order = ($potentialNextActionDateField) ? " ORDER BY po.{$potentialNextActionDateField} ASC " : " ORDER BY closingdate ASC ";
// #				AND po.sales_stage != ''
// #				AND ldcf.cf_596  < '".date("Y-m-d", strtotime("+1 months"))."'
// pocf.cf_603 ='' OR 	
//			a.ship_city AS account_city,
//			a.ship_country AS account_country,

	$sql = "
		SELECT 
			po.potentialid,
			po.potential_no,
			po.potentialname,
			a.accountname,
			a.phone AS account_phone,
			a.website,
			ce.description,
			po.leadsource,
			po.sales_stage,
			po.campaignid,
			po.closingdate,
			po.amount,
			po.probability,
			".$cf_select."
			u.user_name,
			u.email1
		FROM 
			vtiger_potential as po 
		LEFT JOIN
			vtiger_potentialscf as pocf
		ON
			po.potentialid = pocf.potentialid
		LEFT JOIN
			vtiger_crmentity as ce
		ON
			po.potentialid = ce.crmid
		LEFT JOIN 
			vtiger_account as a
		ON
			po.related_to = a.accountid
		LEFT JOIN 
			vtiger_users as u
		ON
			ce.smownerid = u.id
		{$where}
		{$order}
		";
		
		return $sql;
}

/**
 * Transforms $_SERVER HTTP headers into a nice associative array. For example:
 *   array(
 *       'Referer' => 'example.com',
 *       'X-Requested-With' => 'XMLHttpRequest'
 *   )
 */
function get_request_headers() {
    $headers = array();
    foreach($_SERVER as $key => $value) {
        if(strpos($key, 'HTTP_') === 0) {
            $headers[str_replace(' ', '-', ucwords(str_replace('_', ' ', strtolower(substr($key, 5)))))] = $value;
        }
    }
    return $headers;
}

/**
 * Gets and formats the Contactblock
 */
function getPotentialContactBlock($id,$showPhone = false)
{
	global $adb;
	$sql = "	SELECT 
					*
				FROM
					vtiger_contactdetails AS cp
				LEFT JOIN
					vtiger_contpotentialrel AS cpr
				ON
					cp.contactid = cpr.contactid
				WHERE
					cpr.potentialid = {$id}
	";

	$resultContacts = $adb->pquery($sql, array());
	$contactBlock = '';
				
	if (is_array($resultContacts->fields))
	{
		// Contacts found for this Potential
		while ($potentialContact = $adb->fetch_array($resultContacts))
		{
			// salutation,firstname,lastname,email,phone,mobile
			$contactBlock .= '- '.cleanSalutation($potentialContact['salutation']).' ';
			$contactBlock .= $potentialContact['firstname'].' ';
			$contactBlock .= $potentialContact['lastname'].' ';
			if ($showPhone) {
				$contactBlock .= format_phone($potentialContact['phone']);
				if (!empty($potentialContact['phone']) && !empty($potentialContact['mobile']))  $contactBlock .= ' | ';
				$contactBlock .= format_phone($potentialContact['mobile']);
			}
			$contactBlock .= '<br>';
			$contactBlock = trim($contactBlock);
//					$personActions[$potentialContact['firstname'].' '.$potentialContact['lastname']][] = $potentialRow['potential_no'] . ' - '. $potentialRow['accountname'].' '.$potentialRow['potentialname'];
		}
	}
	return $contactBlock;
}


/**
 * Formats the butonbar
 */
function getButtonsDetailView($module, $id, $listForUser) 
{
  global $app;
  
	$buttons ='';
	$buttons .= '<table class="buttonbar">';
	$buttons .= '<tr><th colspan=5 class="buttonbar-header">Verplaats</th></tr>';
	$buttons .= '<tr>';
	$buttons .= $app->makeButton($module,$id,$listForUser,'U','1 uur vooruit');
	$buttons .= $app->makeButton($module,$id,$listForUser,'D','1 werkdag vooruit');
	$buttons .= $app->makeButton($module,$id,$listForUser,'W','1 week vooruit');
	$buttons .= $app->makeButton($module,$id,$listForUser,'M','1 maand vooruit');
	$buttons .= $app->makeButton($module,$id,$listForUser,'NoDate','Maak actiedatum leeg');
	$buttons .= '</tr>';
	$buttons .= '<tr><th colspan=5 class="buttonbar-header">Eerstvolgende</th></tr>';
	$buttons .= '<tr>';
	$buttons .= $app->makeButton($module,$id,$listForUser,'Ma','Volgende Maandag');
	$buttons .= $app->makeButton($module,$id,$listForUser,'Di','Volgende Dinsdag');
	$buttons .= $app->makeButton($module,$id,$listForUser,'Wo','Volgende Woensdag');
	$buttons .= $app->makeButton($module,$id,$listForUser,'Do','Volgende donderdag');
	$buttons .= $app->makeButton($module,$id,$listForUser,'Vr','Volgende Vrijdag');
	$buttons .= '</tr>';
	$buttons .= '<tr><th colspan=5 class="buttonbar-header">Geen contact</th></tr>';
	$buttons .= '<tr>';
	$buttons .= $app->makeButton($module,$id,$listForUser,'NB','Niet bereikbaar +1d)');
	$buttons .= $app->makeButton($module,$id,$listForUser,'VMI','Voicemail Wel Ingesproken (+1d)');
	$buttons .= $app->makeButton($module,$id,$listForUser,'VMN','Voicemail Niet Ingesproken (+1d)');
	$buttons .= $app->makeButton($module,$id,$listForUser,'AFW','Vandaag Afwezig (+1d)');
	$buttons .= $app->makeButton($module,$id,$listForUser,'LTB','Later vandaag terugbellen (+1 u)');
	$buttons .= '</tr>';
	$buttons .= '<tr><th colspan=5 class="buttonbar-header">Status</th></tr>';
	$buttons .= '<tr>';
//	$buttons .= $app->makeButton($module,$id,$listForUser,'Qualified','Gekwalificeerd');
	$buttons .= $app->makeButton($module,$id,$listForUser,'InfoSturen','Informatie Sturen');
	$buttons .= $app->makeButton($module,$id,$listForUser,'Fup','Later Opvolgen');
	$buttons .= $app->makeButton($module,$id,$listForUser,'Afspraak','Afspraak maken');
	$buttons .= $app->makeButton($module,$id,$listForUser,'Nur','Nurture - Voorlopig met rust laten');
	$buttons .= $app->makeButton($module,$id,$listForUser,'Lost','Uitval Lost Status aanpassen');
	$buttons .= '</tr>';
	$buttons .= '<tr>';
	$buttons .= $app->makeButton($module,$id,$listForUser,'1BEL','Nog 1x bellen dan Qualified Out');
	$buttons .= $app->makeButton($module,$id,$listForUser,'QOUT','Uitval Qualified out');
	$buttons .= '</tr>';	

	$buttons .= '<tr><th colspan=5 class="buttonbar-header">Reasign</th></tr>';
	$buttons .= '<tr>';
//	$buttons .= $app->makeButton($module,$id,$listForUser,'akrijt','Arjen Krijt');
//	$buttons .= $app->makeButton($module,$id,$listForUser,'jdevries','Jaap de Vries');
	$buttons .= $app->makeButton($module,$id,$listForUser,'luuk','Luuk Roovers');
	$buttons .= $app->makeButton($module,$id,$listForUser,'helenus','Helenus de Rijke');
//	$buttons .= $app->makeButton($module,$id,$listForUser,'ineke','Ineke Swart');
//	$buttons .= $app->makeButton($module,$id,$listForUser,'shuiskamp','Sophie Huiskamp');
//	$buttons .= $app->makeButton($module,$id,$listForUser,'jpolime','Jobun Polime');
//	$buttons .= $app->makeButton($module,$id,$listForUser,'qmaksoudi','Qeis Maksoudi');
//	$buttons .= $app->makeButton($module,$id,$listForUser,'hrikken','Harry Rikken');
//	$buttons .= $app->makeButton($module,$id,$listForUser,'mvdgeijs','Mark vd Geijs');
	$buttons .= $app->makeButton($module,$id,$listForUser,'joost','Joost Wijma');

	$buttons .= '</tr>';
	$buttons .= '</table>';
	$buttons .= '<br /><br />';
	return $buttons;
}

/**
 * Formats the butonbar
 */
function getButtonsListView($module= '', $id= '', $listForUser) 
{
  global $app;

	$buttons ='';
	if ($_SESSION['is_admin'] == 'on') {
		$buttons .= '<table border="0" width="100%">';
		$buttons .= '<tr><th colspan=5 style="border-top:2px solid #7f7f7f;">Wissel gebruiker</th></tr>';
		$buttons .= '<tr>';
//		$buttons .= $app->makeButton('','','akrijt','AKR','Arjen Krijt');
//		$buttons .= $app->makeButton('','','jdevries','JDV','Jaap de Vries');
//		$buttons .= $app->makeButton('','','shuiskamp','SHU','Sophie Huiskamp');
//		$buttons .= $app->makeButton('','','jpolime','JPO','Jobun Polime');
		$buttons .= $app->makeButton('','','luuk','LRO','Luuk Roovers');
		$buttons .= $app->makeButton('','','helenus','HDR','Helenus de Rijke');
        $buttons .= $app->makeButton('','','joost','JWI','Joost Wijma');

//		$buttons .= $app->makeButton('','','qmaksoudi','QMA','Qeis Maksoudi');
//$buttons .= $app->makeButton('','','mising','MIS','Michael Ising');
//$buttons .= $app->makeButton('','','hrikken','HRI','Harry Rikken');
//$buttons .= $app->makeButton('','','mvdgeijs','MVG','Mark vd Geijs');

//		$buttons .= $app->makeButton('','','ineke','ISW','Ineke Swart');
		$buttons .= '</tr>';
		$buttons .= '</table>';
	}
	return $buttons;
}






/**
 * Check if given field is configured
 * @todo can be improved, but works for now
 */
function isValidFieldName($fieldname)
{
	if($fieldname != '') {
		return true;
	} else {
		echo 'Invalid fieldname:'.$fieldname; die();
		return false;
	}
}
?>