<?php
/*
 * webservice voor retrieve is niet handig:
 * het geeft nl. maar 100 entries terug...
 * castellum heeft 111 componenten, dus we missen er 11...
 *
 */
function VebSetComponentsOnInstallation($entity){

  global $current_user;

  // get installationid
  list($module, $installationId) = explode('x', $entity->data['comp_installation']);
  
  // if none, do nothing
  if (!$installationId)  return void;

  //get all components connected to this installation
  try {

    $recordModel = Vtiger_Record_Model::getInstanceById($installationId, 'Installations');
    $listViewModel = Vtiger_RelationListView_Model::getInstance($recordModel, 'Components', 'Components');

    $pagingModel = new Vtiger_Paging_Model;
    $pagingModel->set('limit', $listViewModel->getRelatedEntriesCount());
    $componentRecordModels = $listViewModel->getEntries($pagingModel);

    $content = '| ';

    foreach($componentRecordModels as $componentRecordModel) {

      if ($componentRecordModel->get('comp_status') == 'Active') {

        $productId = $componentRecordModel->get('comp_product');

        if ($productId) {

          $productEntity = CRMEntity::getInstance('Products');
          $productEntity->retrieve_entity_info($productId, 'Products');

          $content .= $productEntity->column_fields['cf_2031'] . ' | ';
        }
      }
    }
  }
  catch (Exception $ex) {

    echo $ex->getMessage();
  }

  // and save content on installation
  if ($content) {

    $focus = CRMEntity::getInstance('Installations');
    $focus->retrieve_entity_info($installationId, 'Installations');
    $focus->mode = "edit";
    $focus->id= $installationId;
    $focus->column_fields['cf_2337'] = $content;
    $focus->saveentity('Installations');
    unset($focus);
  }
}
