<?php

class SalesOrder_View extends SalesOrder
{

  var $container = array();

  public function getBody($id = 0)
  {

    $data = $this->getRecord($id);
//    var_dump($data);
    $dataMapped = $this->_mapTheData($data);
    

    return $this->_getViewBody($dataMapped);
  }
  
  
  public function _getViewBody($dataMapped)
  {
  
    $signature = new signing();
    $geomap = new geomap();
  
    $html = $this->_startViewBody();
    
    $html .= $signature->getJS();

    
    $html .= '<ul class="pageitem">'."\n";
		$html .= '<li class="textbox"><span class="header">'.$dataMapped['title'].' - '.$dataMapped['objectno'].'</span>'.$dataMapped['description'].'</li>'."\n";
		if( $dataMapped['status']) $html .= '<li class="textbox"><span class="header">'.$dataMapped['status'].'</span>'.'</li>'."\n";
		if( $dataMapped['plan']) $html .= '<li class="textbox"><span class="header">'.format::plan($dataMapped['plan']).'</span>'.'</li>'."\n";
    $html .= '</ul>'."\n\n";

    // =================================================================== Contactpersoon
    $html .= '<span class="graytitle">Contactpersoon</span>'."\n";
    $icon = ' <img src="veb/webapp/images/vtiger-icons-24x24/Contacts.png"> ';

    $html .= '<ul class="pageitem">'."\n";

    $contacts = $this->getContactBlock();
    
    if($dataMapped['salutation'].$dataMapped['firstname'].$dataMapped['lastname'] != '' || count($contacts)>0)
    {
      if ($dataMapped['salutation'].$dataMapped['firstname'].$dataMapped['lastname'] != '' ) 
      {
  		  $html .= '<li class="textbox">'.$icon.format::salutation($dataMapped['salutation']).' '.$dataMapped['firstname'].' '.$dataMapped['lastname'].' '.$dataMapped['phone'].' '.$dataMapped['mobile'].'</li>'."\n";
      }
      if (is_array($contacts)) foreach ($contacts as $id => $cpinfo) {
        $html .= '<li class="textbox">'.$icon.$cpinfo['salutation'].' '.$cpinfo['firstname'].' '.$cpinfo['lastname'].'</li>'."\n";
      }
    }
    else {
      $html .= '<li class="textbox"><span class="header">Geen contactpersoon beschikbaar</span></li>'."\n";
    }
    
    $html .= '</ul>'."\n\n";

    // =================================================================== Actie notities
    $html .= '<span class="graytitle">Actie notities</span>'."\n";
    $html .= '<ul class="pageitem">'."\n";
    if($dataMapped['nextaction_date']) {
      $icon = ' <img src="veb/webapp/images/vtiger-icons-24x24/Calendar.png"> ';
		  $html .= '<li class="textbox"><span class="header">'.$icon.$dataMapped['nextaction_date'].' '.$dataMapped['nextaction_time'].' '.$dataMapped['nextaction_type'].'</span></li>'."\n";
		}
		
		if($dataMapped['nextaction_text']) {
      $aTxt = explode("\n",$dataMapped['nextaction_text']);
      foreach($aTxt as $txtId => $txtTxt) {
    		$html .= '<li class="textbox">'.$txtTxt.'</li>'."\n";
  		}
		}
		else {
		   $html .= '<li class="textbox"><span class="header">Geen info beschikbaar</span></li>'."\n";
		}
		
    $html .= '</ul>'."\n\n";

    $html .= '<ul class="pageitem">'."\n";
		$html .= '<li class="textbox"><span class="header">Geolocatie</span>'.$geomap->getCanvas().'</li>'."\n";
    $html .= $geomap->getJS();
    $html .= '</ul>'."\n\n";

    $html .= '<ul class="pageitem">'."\n";
		$html .= '<li class="textbox"><span class="header">Handtekening</span>'.$signature->getCanvas().'</li>'."\n";
    $html .= '<li class="smallfield"><span class="name">Naam ondertekenaar</span><input placeholder="Voer volledige naam in" id="document_signedby" name="signing[signed_by]" type="text" value="" /></li>'."\n";
    $html .= '</ul>'."\n\n";
    
    $html .= $this->_endViewBody();
    
    return $html;
  }
  
  
}