<?php

class SalesOrder extends Action
{

  var $_actionDateTable = 'vtiger_salesorders';
  var $_actionNoteTable = 'vtiger_salesorders';

  static function getMapping()
  {
    $mapping = array(
      'module' => 'setype',
      'objectno' => 'salesorder_no',
      'crmid' => 'salesorderid',
      'title' => 'subject',
      'status' => 'sostatus',
      'priority' => false,
      'plan' => false,  // bij account is dit 'c_accountplan',
      
      'expected_projectamount' => 'total',
      'expected_annualamount' => false,
      'expected_value' => false,
      
      'salutation' => false,
      'firstname' => false,
      'lastname' => false,
      
      'phone' => 'phone',
      'phone2' => 'otherphone',
      'mobile' => 'mobile',
      'email' => 'email1',
      
      'nextaction_date' => 'duedate',
      'nextaction_time' => false,
      'nextaction_type' => false,
      'nextaction_text' => false,
      
      'wv_score' => false,
      'wv_sourcefirstvisit' => false,
      'wv_searchterms' => false,
      'wv_allsources' => false,
      'wv_nofvisits' => false,
      'wv_nofpages' => false,
      'wv_scoregroups' => false,
      
    );
    return $mapping;  
    
  }
  
  function statusMapping() 
  {
    $mapping = array(
    );
  }
  
  function getRecord($crmid)
  {
    global $adb;

    $where = " WHERE so.salesorderid = ?";
    
    $sql = "SELECT 
      ce.setype, 
      so.salesorder_no, so.salesorderid, so.subject, so.sostatus, so.total,
      ac.phone, ac.otherphone, ac.email1,
      so.duedate,
      ac.wv_score, ac.wv_sourcefirstvisit, ac.wv_searchterms, ac.wv_allsources, ac.wv_nofvisits, ac.wv_nofpages, ac.wv_scoregroups
		FROM 
			vtiger_salesorder as so 
		LEFT JOIN
			vtiger_salesordercf as socf
		ON
			so.salesorderid = socf.salesorderid
		LEFT JOIN
			vtiger_crmentity as ce
		ON
			so.salesorderid = ce.crmid
		LEFT JOIN 
			vtiger_account as ac
		ON
			so.accountid = ac.accountid
		LEFT JOIN 
			vtiger_users as u
		ON
			ce.smownerid = u.id
		{$where}";
		
    $result = $adb->pquery($sql, array($crmid));
    if (!$result) print_r($adb);
    return $result->fields;
  }
  
  function getList($limit = 10)
  {
    // @todo   
    $skipstatus = array();
    
    $where = " WHERE so.sostatus != ''";
//    $where .= " AND po.sales_stage NOT IN ('Project afgeleverd', 'Nurture', 'Nurture Partner', 'Target', 'Uitval - Lost', 'Uitval - Qualified Out', 'Uitval Reden onbekend', 'Marketing Qualified') ";
		$where .= " AND ce.deleted = 0 ";
    
    $order = " ORDER BY duedate ASC";
//	  $order = ($potentialNextActionDateField) ? " ORDER BY po.{$potentialNextActionDateField} ASC " : " ORDER BY closingdate ASC ";
	    
    $limit = " LIMIT {$limit}";
    
    $sql = "SELECT * 
		FROM 
			vtiger_salesorder as so
		LEFT JOIN
			vtiger_salesordercf as socf
		ON
			so.salesorderid = socf.salesorderid
		LEFT JOIN
			vtiger_crmentity as ce
		ON
			so.salesorderid = ce.crmid
		LEFT JOIN 
			vtiger_account as a
		ON
			so.accountid = a.accountid
		LEFT JOIN 
			vtiger_users as u
		ON
			ce.smownerid = u.id
		{$where}
		{$order}
		{$limit}
			";

    return $this->_runListQuery($sql);
  
  }
  
  /**
  * Gets and formats the Contactblock
  */
  function getContactBlock()
  {
    $sql = "	SELECT *
      FROM
      	vtiger_contactdetails AS cp
      LEFT JOIN
      	vtiger_contpotentialrel AS cpr
      ON
      	cp.contactid = cpr.contactid
      LEFT JOIN
        vtiger_crmentity as ce
      ON
        cp.contactid = ce.crmid  
      WHERE
      	cpr.potentialid = ?
        AND ce.deleted = 0";
    
    return $this->_contacts($sql);
  }
  
}