<?php

class Potentials extends Action
{

  var $_actionDateTable = 'vtiger_potential';
  var $_actionNoteTable = 'vtiger_potential';

  static function getMapping()
  {
    $mapping = array(
      'module' => 'setype',
      'objectno' => 'potential_no',
      'crmid' => 'potentialid',
      'title' => 'org_and_potentialname',
      'status' => 'sales_stage',
      'priority' => 'probability',
      'plan' => false,  // bij account is dit 'c_accountplan',
      
      'expected_projectamount' => 'amount',
      'expected_annualamount' => 'c_annualbudget',
      'expected_value' => 'forecast_amount',
      
      'salutation' => false,
      'firstname' => false,
      'lastname' => false,
      
      'phone' => 'phone',
      'phone2' => 'otherphone',
      'mobile' => 'mobile',
      'email' => 'email1',
      
      'nextaction_date' => 'c_date_followup',
      'nextaction_time' => false,
      'nextaction_type' => false,
      'nextaction_text' => 'c_initiative_notes',
      
      'wv_score' => 'wv_score',
      'wv_sourcefirstvisit' => 'wv_sourcefirstvisit',
      'wv_searchterms' => 'wv_searchterms',
      'wv_allsources' => 'wv_allsources',
      'wv_nofvisits' => 'wv_nofvisits',
      'wv_nofpages' => 'wv_nofpages',
      'wv_scoregroups' => 'wv_scoregroups',
      
    );
    return $mapping;  
    
  }
  
  function statusMapping() 
  {
    $mapping = array(
				'NURTURE' => 'Nurture',
				'QOUT' => 'Closed Lost',
    );
  }
  
  function getRecord($crmid)
  {
    global $adb;

    $where = " WHERE po.potentialid = ?";
    
     
    $sql = "SELECT 
      ce.setype, 
      po.potential_no, po.potentialid, 
      concat(ac.accountname,' - ',po.potentialname) as org_and_potentialname,
      po.potentialname, po.sales_stage, po.amount, po.c_annualbudget, po.forecast_amount,
      ac.phone, ac.otherphone, ac.email1,
      po.c_date_followup, po.c_initiative_notes,
      ac.wv_score, ac.wv_sourcefirstvisit, ac.wv_searchterms, ac.wv_allsources, ac.wv_nofvisits, ac.wv_nofpages, ac.wv_scoregroups
		FROM 
			vtiger_potential as po 
		LEFT JOIN
			vtiger_potentialscf as pocf
		ON
			po.potentialid = pocf.potentialid
		LEFT JOIN
			vtiger_crmentity as ce
		ON
			po.potentialid = ce.crmid
		LEFT JOIN 
			vtiger_account as ac
		ON
			po.related_to = ac.accountid
		LEFT JOIN 
			vtiger_users as u
		ON
			ce.smownerid = u.id
		{$where}";
		
    $result = $adb->pquery($sql, array($crmid));
//    print_r($adb);
    return $result->fields;
  }
  
  function getList($limit = 10)
  {
    // @todo   
    $skipstatus = array();
    
    $where = " WHERE po.sales_stage != ''";
    $where .= " AND po.sales_stage NOT IN ('Closed Won','Project afgeleverd', 'Project in onderhoud', 'Project in Uitvoering', 'Nurture', 'Nurture Partner', 'Target', 'Uitval - Lost', 'Uitval - uitgekwalificeerd', 'Uitval - Qualified Out', 'Uitval Reden onbekend', 'Marketing Qualified') ";
		$where .= " AND ce.deleted = 0 ";
		    $where .= " AND ce.smownerid = 10";
    
    $order = " ORDER BY c_date_followup, probability, closingdate ASC";
//	  $order = ($potentialNextActionDateField) ? " ORDER BY po.{$potentialNextActionDateField} ASC " : " ORDER BY closingdate ASC ";
	    
    $limit = " LIMIT {$limit}";
    
    $sql = "SELECT 
      *,
      concat(a.accountname,' - ',po.potentialname) as org_and_potentialname
		FROM 
			vtiger_potential as po 
		LEFT JOIN
			vtiger_potentialscf as pocf
		ON
			po.potentialid = pocf.potentialid
		LEFT JOIN
			vtiger_crmentity as ce
		ON
			po.potentialid = ce.crmid
		LEFT JOIN 
			vtiger_account as a
		ON
			po.related_to = a.accountid
		LEFT JOIN 
			vtiger_users as u
		ON
			ce.smownerid = u.id
		{$where}
		{$order}
		{$limit}
			";

    return $this->_runListQuery($sql);
  
  }
  
  /**
  * Gets and formats the Contactblock
  */
  function getContactBlock()
  {
    $sql = "	SELECT *
      FROM
      	vtiger_contactdetails AS cp
      LEFT JOIN
      	vtiger_contpotentialrel AS cpr
      ON
      	cp.contactid = cpr.contactid
      LEFT JOIN
        vtiger_crmentity as ce
      ON
        cp.contactid = ce.crmid  
      WHERE
      	cpr.potentialid = ?
        AND ce.deleted = 0";
        
    $part1 = $this->_contacts($sql);
    
     $sql = "SELECT *
      FROM
      	vtiger_contactdetails AS cp
      LEFT JOIN
      	vtiger_potential as po
      ON
      	cp.contactid = po.contact_id
      LEFT JOIN
        vtiger_crmentity as ce
      ON
        cp.contactid = ce.crmid
      WHERE
      	po.potentialid = ?
        AND ce.deleted = 0;";
              
    $part2 = $this->_contacts($sql);    

//    print_r($part1);
//    print_r($part2);
    $return = $part1 + $part2;
//    print_r($return);
//    die();

    return $return;  
  }
  
}