<?php

class Leads extends Action
{

    var $_actionDateTable = 'vtiger_leaddetails';
    var $_actionNoteTable = 'vtiger_leaddetails';

    static function getMapping()
    {
        $mapping = array(
            'module' => 'setype',
            'objectno' => 'lead_no',
            'crmid' => 'leadid',
            'title' => 'company',
            'status' => 'leadstatus',
            'priority' => 'c_picklist_priorities',
            'plan' => false, // bij account is dit 'c_accountplan',
            'expected_projectamount' => 'c_onetimebudget',
            'expected_annualamount' => 'c_annualbudget',
            'expected_value' => 'c_expectedvalue',
            'salutation' => 'c_lead_preamble',
            'firstname' => 'firstname',
            'lastname' => 'lastname',
            'description' => 'description',
            'phone' => 'phone',
            'mobile' => 'mobile',
            'email' => 'email',
            'nextaction_date' => 'c_date_follow_up',
            'nextaction_time' => false,
            'nextaction_type' => false,
            'nextaction_text' => 'c_initiative_notes',
            'interest_solutions' => 'c_lead_solutions',
            'interest_products' => 'c_lead_products',
            'interest_text' => 'c_lead_interest',
            'interest_webform' => 'c_webform',
            'wv_score' => 'wv_score',
            'wv_sourcefirstvisit' => 'wv_sourcefirstvisit',
            'wv_searchterms' => 'wv_searchterms',
            'wv_allsources' => 'wv_allsources',
            'wv_nofvisits' => 'wv_nofvisits',
            'wv_nofpages' => 'wv_nofpages',
            'wv_scoregroups' => 'wv_scoregroups',
        );
        return $mapping;
    }

    function statusMapping()
    {
        $mapping = array(
            'NURTURE' => 'Nurture',
            'QOUT' => 'Uitval - Qualified Out',
            'UITVAL' => 'Uitval - Qualified Out',
            'LOST' => 'Uitval',
            'QO' => 'Uitval - Qualified Out',
            'QUALIFIED' => 'Gekwalificeerd',
            'INFOSTUREN' => 'Voorstel/info sturen',
            'FOLLOWUP' => 'Voorstel/info opvolgen',
            'AFSPRAAK' => 'Afspraak maken'
        );
    }

    function getRecord($crmid)
    {
        global $adb;

        $where = " WHERE ld.leadid = ?";
        $sql = "SELECT * 
    FROM 
			vtiger_leaddetails as ld 
		LEFT JOIN
			vtiger_leadscf as ldcf
		ON
			ld.leadid = ldcf.leadid
		LEFT JOIN
			vtiger_crmentity as ce
		ON
			ld.leadid = ce.crmid
		LEFT JOIN 
			vtiger_leadaddress as la
		ON
			ld.leadid = la.leadaddressid
		LEFT JOIN 
			vtiger_users as u
		ON
			ce.smownerid = u.id
		{$where}";

        $result = $adb->pquery($sql, array($crmid));
//    print_r($result->fields);
        return $result->fields;
    }

    function getList($limit = 10)
    {
        // @todo   
        $skipstatus = array();

        $where = " WHERE ld.leadstatus != ''";
        $where .= " AND ld.leadstatus NOT IN ('', 'Unknown', 'Converted', 'Nurture', 'Nurture Partner', 'Target', 'Uitval - Lost', 'Uitval - Uitgekwalificeerd', 'Uitval - Qualified Out', 'Uitval - Reden onbekend', 'Uitval - Onbekend', 'Marketing Qualified', 'Nieuw', 'New', 'Webbezoeker') ";
        $where .= " AND ld.converted = 0";
        $where .= " AND ce.deleted = 0";
        $where .= " AND ce.smownerid = 10";


        $order = " ORDER BY c_date_follow_up ASC, priority";

        $limit = " LIMIT {$limit}";

        $sql = "SELECT * 
    FROM 
			vtiger_leaddetails as ld 
		LEFT JOIN
			vtiger_leadscf as ldcf
		ON
			ld.leadid = ldcf.leadid
		LEFT JOIN
			vtiger_crmentity as ce
		ON
			ld.leadid = ce.crmid
		LEFT JOIN 
			vtiger_leadaddress as la
		ON
			ld.leadid = la.leadaddressid
		LEFT JOIN 
			vtiger_users as u
		ON
			ce.smownerid = u.id
		{$where}
		{$order}
		{$limit}
			";

        return $this->_runListQuery($sql);
    }

    /**
     * Gets and formats the Contactblock
     */
    function getContactBlock()
    {
        return false;
    }

}

/**
Array
(
    [0] => 271347
    [leadid] => 271347
    [1] => LEA11807
    [lead_no] => LEA11807
    [2] => jeffrey@autowal.nl
    [email] => jeffrey@autowal.nl
    [3] => 
    [interest] => 
    [4] => Jeffrey
    [firstname] => Jeffrey
    [5] => Dhr.
    [salutation] => Dhr.
    [6] => Wallenburg
    [lastname] => Wallenburg
    [7] => Autogroothandel Wallenburg
    [company] => Autogroothandel Wallenburg
    [8] => 
    [annualrevenue] => 
    [9] => Autos motorfietsen en aanhangers
    [industry] => Autos motorfietsen en aanhangers
    [10] => 
    [campaign] => 
    [11] => 
    [rating] => 
    [12] => Webformulier ontvangen
    [leadstatus] => Webformulier ontvangen
    [13] => Website vicus.nl
    [leadsource] => Website vicus.nl
    [14] => 0
    [converted] => 0
    [15] => 
    [designation] => 
    [16] => 
    [licencekeystatus] => 
    [17] => 
    [space] => 
    [18] => 
    [comments] => 
    [19] => 
    [priority] => 
    [20] => 
    [demorequest] => 
    [21] => 
    [partnercontact] => 
    [22] => 
    [productversion] => 
    [23] => 
    [product] => 
    [24] => 
    [maildate] => 
    [25] => 
    [nextstepdate] => 
    [26] => 
    [fundingsituation] => 
    [27] => 
    [purpose] => 
    [28] => 
    [evaluationstatus] => 
    [29] => 
    [transferdate] => 
    [30] => 
    [revenuetype] => 
    [31] => 0
    [noofemployees] => 0
    [32] => 
    [secondaryemail] => 
    [33] => 0
    [assignleadchk] => 0
    [34] => 
    [emailoptout] => 
    [35] => 4000
    [c_onetimebudget] => 4000
    [36] => 2017-05-09
    [c_date_follow_up] => 2017-05-09
    [37] => 700
    [c_annualbudget] => 700
    [38] => 610
    [c_expectedvalue] => 610
    [39] => 10
    [c_probability] => 10
    [40] => 2.Middel
    [c_lead_priority] => 2.Middel
    [41] => 
    [c_initiative_notes] => 
    [42] => 
    [c_webform] => 
    [43] => C2 Stabiel kleintje
    [c_customertype] => C2 Stabiel kleintje
    [44] => 
    [c_demo_wf_status] => 
    [45] => 
    [c_demo_wf_date] => 
    [46] => 
    [c_lead_email2] => 
    [47] => 
    [c_lead_initials] => 
    [48] => 
    [c_lead_linkedin] => 
    [49] => heer
    [c_lead_preamble] => heer
    [50] => nl
    [c_lead_language] => nl
    [51] => bedrijven
    [c_targetgroup] => bedrijven
    [52] => 
    [c_industry_particular] => 
    [53] => 
    [c_other_websites] => 
    [54] => 30138859
    [c_coc_number] => 30138859
    [55] => 
    [c_legal_entity] => 
    [56] => 
    [c_sbi_codes] => 
    [57] => 
    [c_coc_extra] => 
    [58] => 
    [c_tradenames] => 
    [59] => 
    [c_latest_update] => 
    [60] => 0
    [c_coc_block] => 0
    [61] => 
    [c_lead_preferences] => 
    [62] => Webshop
    [c_lead_solutions] => Webshop
    [63] => Magento
    [c_lead_products] => Magento
    [64] => Graag wou ik een offerte krijgen om een magento webshop door jullie op te laten zetten.
    [c_lead_interest] => Graag wou ik een offerte krijgen om een magento webshop door jullie op te laten zetten.
    [65] => 
    [c_tracking] => 
    [66] => 
    [c_lead_source] => 
    [67] => WebLeadCapture meer_informatie
    [c_lead_source_bg] => WebLeadCapture meer_informatie
    [68] => 
    [c_lead_search_terms] => 
    [69] => 0
    [c_lead_purchaseprice] => 0
    [70] => 
    [c_seminar_code] => 
    [71] => Webformulier
    [c_lead_poe] => Webformulier
    [72] => 
    [c_commisionpartner] => 
    [73] => 
    [c_current_shop_sw_other] => 
    [74] => 
    [c_current_shop_sw] => 
    [75] => 
    [c_current_crm_sw_other] => 
    [76] => 
    [c_current_crm_sw] => 
    [77] => 
    [c_current_erp_sw_other] => 
    [78] => 
    [c_erp_details] => 
    [79] => 
    [c_current_erp_sw] => 
    [80] => 
    [c_king_dealer] => 
    [81] => 
    [c_current_misc_sw_other] => 
    [82] => 
    [c_current_misc_sw] => 
    [83] => 
    [c_essential_functions] => 
    [84] => 
    [c_desired_integrations] => 
    [85] => 
    [c_systems_to_replace] => 
    [86] => 
    [c_current_provider] => 
    [87] => 
    [c_future_plans] => 
    [88] => 0
    [c_crm_users] => 0
    [89] => 0
    [c_weborders_pw] => 0
    [90] => 0
    [c_product_count] => 0
    [91] => 
    [c_successmodel] => 
    [92] => 
    [c_branchemodel] => 
    [93] => 
    [c_salesregion] => 
    [94] => 
    [c_competition] => 
    [95] => 
    [c_lostanalysis] => 
    [96] => 
    [c_current_cms_sw_other] => 
    [97] => 
    [c_current_cms_sw] => 
    [98] => 
    [c_current_mailing_sw] => 
    [99] => 
    [c_current_mailing_sw_other] => 
    [100] => 
    [c_current_webanalysis_sw] => 
    [101] => 
    [c_current_webanalysis_sw_other] => 
    [102] => 
    [c_current_bi_reports_sw] => 
    [103] => 
    [c_current_bi_reports_sw_other] => 
    [104] => 
    [c_current_middleware_sw] => 
    [105] => 
    [c_current_middleware_sw_other] => 
    [106] => 0
    [wv_score] => 0
    [107] => 
    [wv_sourcefirstvisit] => 
    [108] => 
    [wv_searchterms] => 
    [109] => 
    [wv_datefirstvisit] => 
    [110] => 
    [wv_lastvisitdate] => 
    [111] => 
    [wv_allsources] => 
    [112] => 0
    [wv_nofvisits] => 0
    [113] => 0
    [wv_nofpages] => 0
    [114] => 
    [wv_scoregroups] => 
    [115] => 
    [wv_sfcocnumber] => 
    [116] => 
    [wv_sfsbi] => 
    [117] => 
    [wv_isic2] => 
    [118] => 
    [wv_snassic] => 
    [119] => 
    [wv_sfbranche] => 
    [120] => 
    [wv_snaisicdescr] => 
    [121] => 
    [wv_sfemployeesrange] => 
    [122] => 
    [wv_creditrating] => 
    [123] => 
    [wv_sfsegments] => 
    [124] => 
    [wv_sftags] => 
    [125] => 0
    [wv_sffollow] => 0
    [126] => 0
    [wv_sfforce] => 0
    [127] => 
    [wv_wvaorgid] => 
    [128] => 
    [wv_wvaconid] => 
    [129] => 
    [wv_sforgid] => 
    [130] => 
    [wv_sfvisitorid] => 
    [131] => 0
    [c_newsletter_optout] => 0
    [132] => 
    [c_linkedin_account] => 
    [133] => 
    [c_linkedin_contact] => 
    [134] => 271347
    [135] => 
    [cf_1288] => 
    [136] => 
    [cf_1429] => 
    [137] => 
    [cf_1433] => 
    [138] => 0
    [cf_1465] => 0
    [139] => 0
    [cf_1481] => 0
    [140] => 0
    [cf_1483] => 0
    [141] => Boomgaardweg 59, 3984 KH Odijk, Nederland
    [ee_google_search] => Boomgaardweg 59, 3984 KH Odijk, Nederland
    [142] => 0
    [cf_1576] => 0
    [143] => 1
    [cf_1578] => 1
    [144] => 0
    [cf_1580] => 0
    [145] => 0
    [cf_1582] => 0
    [146] => 0
    [cf_1584] => 0
    [147] => 
    [cf_1639] => 
    [148] => 
    [cf_1651] => 
    [149] => 0
    [cf_1661] => 0
    [150] => Groothandel
    [cf_1663] => Groothandel
    [151] => 0
    [cf_1712] => 0
    [152] => 0
    [cf_1714] => 0
    [153] => 0
    [cf_1716] => 0
    [154] => 0
    [cf_1728] => 0
    [155] => 271347
    [crmid] => 271347
    [156] => 2163
    [smcreatorid] => 2163
    [157] => 10
    [smownerid] => 10
    [158] => 10
    [modifiedby] => 10
    [159] => Leads
    [setype] => Leads
    [160] => 
    [description] => 
    [161] => 2017-05-08 16:36:00
    [createdtime] => 2017-05-08 16:36:00
    [162] => 2017-05-09 06:03:59
    [modifiedtime] => 2017-05-09 06:03:59
    [163] => 
    [viewedtime] => 
    [164] => 
    [status] => Active
    [165] => 0
    [version] => 0
    [166] => 1
    [presence] => 1
    [167] => 0
    [deleted] => 0
    [168] => Jeffrey Wallenburg
    [label] => Jeffrey Wallenburg
    [169] => 271347
    [leadaddressid] => 271347
    [170] => Odijk
    [city] => Odijk
    [171] => 3984 KH
    [code] => 3984 KH
    [172] => Utrecht
    [state] => Utrecht
    [173] => 
    [pobox] => 
    [174] => Nederland
    [country] => Nederland
    [175] => 0303020293
    [phone] => 0303020293
    [176] => 0653218434
    [mobile] => 0653218434
    [177] => 
    [fax] => 
    [178] => Boomgaardweg 59
    [lane] => Boomgaardweg 59
    [179] => Billing
    [leadaddresstype] => Billing
    [180] => 10
    [id] => 10
    [181] => luuk
    [user_name] => luuk
    [182] => $1$lu000000$lczTEj7d2r1GZRlHikpTT1
    [user_password] => $1$lu000000$lczTEj7d2r1GZRlHikpTT1
    [183] => 7a6dd2412fefd6948d892e3cc5bad081
    [user_hash] => 7a6dd2412fefd6948d892e3cc5bad081
    [184] => #E6FAD8
    [cal_color] => #E6FAD8
    [185] => Luuk
    [first_name] => Luuk
    [186] => Roovers
    [last_name] => Roovers
    [187] => 
    [reports_to_id] => 
    [188] => on
    [is_admin] => on
    [189] => 1
    [currency_id] => 1
    [190] => 
    [191] => 2017-05-08 22:22:41
    [date_entered] => 2017-05-08 22:22:41
    [192] => 0000-00-00 00:00:00
    [date_modified] => 0000-00-00 00:00:00
    [193] => 
    [modified_user_id] => 
    [194] => directeur marketing en verkoop
    [title] => directeur marketing en verkoop
    [195] => marketing en verkoop
    [department] => marketing en verkoop
    [196] => 035 603 3939
    [phone_home] => 035 603 3939
    [197] => 0642301865
    [phone_mobile] => 0642301865
    [198] => 033 461 1196
    [phone_work] => 033 461 1196
    [199] => 
    [phone_other] => 
    [200] => 
    [phone_fax] => 
    [201] => l.roovers@vicus.nl
    [email1] => l.roovers@vicus.nl
    [202] => 
    [email2] => 
    [203] => 
    [204] => Active
    [205] => 
    [signature] => 
    [206] => Vanadiumweg 22
    [address_street] => Vanadiumweg 22
    [207] => Amersfoort
    [address_city] => Amersfoort
    [208] => Utrecht
    [address_state] => Utrecht
    [209] => Nederland
    [address_country] => Nederland
    [210] => 3812 PZ
    [address_postalcode] => 3812 PZ
    [211] => 
    [user_preferences] => 
    [212] => 
    [tz] => 
    [213] => 
    [holidays] => 
    [214] => 
    [namedays] => 
    [215] => 
    [workdays] => 
    [216] => 
    [weekstart] => 
    [217] => dd-mm-yyyy
    [date_format] => dd-mm-yyyy
    [218] => 24
    [hour_format] => 24
    [219] => 09:00
    [start_hour] => 09:00
    [220] => 
    [end_hour] => 
    [221] => This Week
    [activity_view] => This Week
    [222] => Last 2 Days
    [lead_view] => Last 2 Days
    [223] => Luuk-Roovers-Vicus-16-5094_foto_200x200.jpg
    [imagename] => Luuk-Roovers-Vicus-16-5094_foto_200x200.jpg
    [224] => 0
    [225] => $1$lu000000$lczTEj7d2r1GZRlHikpTT1
    [confirm_password] => $1$lu000000$lczTEj7d2r1GZRlHikpTT1
    [226] => 1
    [internal_mailer] => 1
    [227] => 1 Hour
    [reminder_interval] => 1 Hour
    [228] => 2011-08-09 08:53
    [reminder_next_time] => 2011-08-09 08:53
    [229] => PHP5.3MD5
    [crypt_type] => PHP5.3MD5
    [230] => 97vAQ3xrj0BO77t
    [accesskey] => 97vAQ3xrj0BO77t
    [231] => softed
    [theme] => softed
    [232] => nl_nl
    [language] => nl_nl
    [233] => Europe/Amsterdam
    [time_zone] => Europe/Amsterdam
    [234] => 123,456,789
    [currency_grouping_pattern] => 123,456,789
    [235] => ,
    [currency_decimal_separator] => ,
    [236] => .
    [currency_grouping_separator] => .
    [237] => $1.0
    [currency_symbol_placement] => $1.0
    [238] => 505
    [phone_crm_extension] => 505
    [239] => 2
    [no_of_currency_decimals] => 2
    [240] => 1
    [truncate_trailing_zeros] => 1
    [241] => Monday
    [dayoftheweek] => Monday
    [242] => 10
    [callduration] => 10
    [243] => 5
    [othereventduration] => 5
    [244] => public
    [calendarsharedtype] => public
    [245] => Detail
    [default_record_view] => Detail
    [246] => 0
    [leftpanelhide] => 0
    [247] => narrow
    [rowheight] => narrow
    [248] => Planned
    [defaulteventstatus] => Planned
    [249] => Meeting
    [defaultactivitytype] => Meeting
    [250] => 0
    [hidecompletedevents] => 0
    [251] => 1
    [is_owner] => 1
    [252] => 0
    [import_user_id] => 0
*/