<?php

class Accounts extends Action
{

  var $_actionDateTable = 'vtiger_account';
  var $_actionNoteTable = 'vtiger_account';

  static function getMapping()
  {
    $mapping = array(
      'module' => 'setype',
      'objectno' => 'account_no',
      'crmid' => 'accountid',
      'title' => 'accountname',
      'status' => 'account_type',
      'priority' => 'rating',
      'plan' => 'c_accountplan',
      
      'expected_projectamount' => false,
      'expected_annualamount' => false,
      'expected_value' => false,
      
      'salutation' => false,
      'firstname' => false,
      'lastname' => false,
      
      'phone' => 'phone',
      'mobile' => 'mobile',
      'email' => 'email1',
      
      'nextaction_date' => 'c_date_follow_up',
      'nextaction_time' => false,
      'nextaction_type' => false,
      'nextaction_text' => 'c_initiative_notes',
      
      'wv_score' => 'wv_score',
      'wv_sourcefirstvisit' => 'wv_sourcefirstvisit',
      'wv_searchterms' => 'wv_searchterms',
      'wv_allsources' => 'wv_allsources',
      'wv_nofvisits' => 'wv_nofvisits',
      'wv_nofpages' => 'wv_nofpages',
      'wv_scoregroups' => 'wv_scoregroups',
      
    );
    return $mapping;  
    
  }
  
  function statusMapping() 
  {
    $mapping = array(
				'NURTURE' => 'Nurture',
				'QOUT' => 'Closed Lost',
    );
  }
  
  function getRecord($crmid)
  {
    global $adb;

    $where = " WHERE ac.accountid = ?";    
    $sql = "SELECT * 
		FROM 
			vtiger_account as ac
		LEFT JOIN
			vtiger_accountscf as accf
		ON
			ac.accountid = accf.accountid
		LEFT JOIN
			vtiger_crmentity as ce
		ON
			ac.accountid = ce.crmid
		LEFT JOIN 
			vtiger_users as u
		ON
			ce.smownerid = u.id
		{$where}";
		
    $result = $adb->pquery($sql, array($crmid));
    return $result->fields;
  }
  
  function getList($limit = 10)
  {
    // @todo   
    $skipstatus = array();
    
//    $where = " WHERE po.sales_stage != ''";
//    $where .= " AND po.sales_stage NOT IN ('Project afgeleverd', 'Nurture', 'Nurture Partner', 'Target', 'Uitval - Lost', 'Uitval - Qualified Out', 'Uitval Reden onbekend', 'Marketing Qualified') ";
		$where = " WHERE c_date_follow_up != '' AND ce.deleted = 0 ";
    //$where .= " AND user_name= '{$this->_user_name}'";
		$where .= " AND ce.smownerid = 10";
		    
    $order = " ORDER BY c_date_follow_up ASC, rating";
//	  $order = ($potentialNextActionDateField) ? " ORDER BY po.{$potentialNextActionDateField} ASC " : " ORDER BY closingdate ASC ";
	    
    $limit = " LIMIT {$limit}";
    
    $sql = "SELECT * 
		FROM 
			vtiger_account as ac
		LEFT JOIN
			vtiger_accountscf as accf
		ON
			ac.accountid = accf.accountid
		LEFT JOIN
			vtiger_crmentity as ce
		ON
			ac.accountid = ce.crmid
		LEFT JOIN 
			vtiger_users as u
		ON
			ce.smownerid = u.id
		{$where}
		{$order}
		{$limit}
			";

    return $this->_runListQuery($sql);
  
  }
  
  /**
  * Gets and formats the Contactblock
  * @todo change from pot to acc
  */
  function getContactBlock()
  {

    $sql = "	SELECT *
      FROM
        vtiger_contactdetails AS cp
      LEFT JOIN
       vtiger_crmentity as ce
      ON
        cp.contactid = ce.crmid
      WHERE
        cp.accountid = ?
        AND ce.deleted = 0";

    return $this->_contacts($sql);
  }


  /**
  * Gets and formats the Contactblock
  * @todo change from pot to acc
  */
  function getPotentialsBlock()
  {
    
    $sql = "	SELECT *
      FROM
        vtiger_potential AS pot
      LEFT JOIN
       vtiger_crmentity as ce
      ON
        pot.potentialid = ce.crmid
      WHERE
        pot.related_to = ?
        AND pot.sales_stage NOT IN ('Project Afgeleverd', 'Uitval - Lost')
        AND ce.deleted = 0";

    return $this->_potentials($sql);
  }
  
}