<?php
/**
 * vtWebManager - Webinterface to vtiger CRM.
 *
 * THIS IS COPYRIGHTED SOFTWARE, UNAUTORIZED USE WILL BE PROSECUTED.
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 * @copyright	(c)2016 Vicus eBusiness Solutions BV (all rights reserved)
 * @license	Ask for a license at our sales department <sales@vicus.nl>
 * @category	Webmanager
 * @package	pages\includes
 */
 
/**
 * Prototype Signing a document
 * 
 * - Shows the info
 * - Takes the signature
 * - Sends (POST) info to xxxxx
 */ 
class signing
{
  var $contentMd5 = '';
  var $timestamp = '';
  var $apitoken = '';
  var $crmApiKey = '';

  function __construct()
  {  
    /* some calculations */

    $this->contentMd5 = md5($content2besigned);
    $this->timestamp = date('YmdHmi');
    $this->apitoken = $this->calculateApiToken($timestamp,$vtmodule,$recordId);
    //echo "token 1 $timestamp, $vtmodule, $recordId";
  }
  

  function getCanvas()
  {
    $content = base64_encode ( $this->content2besigned );  

    $html = <<<EOT
    
<div class="sign">
  <input id="envelop_apitoken" name="envelop[apitoken]" type="hidden" value="{$this->apitoken}" />
  <textarea id="document_content" name="document[content]" style="display:none;">{$content}</textarea>
  <input id="document_hash" name="document[hash]" type="hidden" value="{$this->contentMd5}" />                  
  <input id="document_datetime" name="signing[datetime]" type="hidden" value="{$this->timestamp}" />
  <input id="document_signature" name="signing[signature]" type="hidden" value="/signatures/original/missing.png" />
  <input id="force-reload" name="force-reload" type="hidden" value="force-reload" />
  <div class="board" id="sign"></div>
</div>

EOT;
  
    return $html;
  }
  
  
  function getJs()
  {
          
    $script = <<<EOD
<script src="veb/webapp/javascript/simple-undo.js"></script>
<script src="veb/webapp/javascript/drawingboard.min.js"></script>
<script>
$(document).ready(function(){
    var myBoard = new DrawingBoard.Board('sign', {
        background: false,
        controls: [
          { Navigation: { back: false, forward: false } }
        ],
    });

    $('form').submit(function(e) {
         //get drawingboard content
        var img = myBoard.getImg();

        //we keep drawingboard content only if it's not the 'blank canvas'
        var imgInput = (myBoard.blankCanvas == img) ? '' : img;

        //put the drawingboard content in the form field to send it to the server
        $('#document_signature').val(imgInput);

        $('#document_geolocation').val($('#geolocation').html());

        //$('#document_content').val($('#content').html());

        //we can also assume that everything goes well server-side
        //and directly clear webstorage here so that the drawing isn't shown again after form submission
        //but the best would be to do when the server answers that everything went well
        myBoard.clearWebStorage();
    });
});
</script>

EOD;

    return $script;

  }
  
  
  
  /**
   * function base64_to_png.
   *
   */
  function base64_to_png($base64_string, $output_file) {
      $ifp = fopen($output_file, "wb"); 
  
      $data = explode(',', $base64_string);
  
      if ($data) 
      {
          fwrite($ifp, base64_decode($data[1])); 
          fclose($ifp); 
          return $output_file; 
      } else {
          // no content!
          return false;
      }
  }  

  /**
   * function array2XML.
   * 
   * function to convert multi-dimensional array to xml
   */
  function array2XML($obj, $array)
  {
      foreach ($array as $key => $value)
      {
          if(is_numeric($key))
              $key = 'item' . $key;
  
          if (is_array($value))
          {
              $node = $obj->addChild($key);
              array2XML($node, $value);
          }
          else
          {
              $obj->addChild($key, htmlspecialchars($value));
          }
      }
  }
  
  /**
   * function calculateApiToken.
   *
   */
  function calculateApiToken($timestamp,$vtmodule,$vtmodule_id)
  {
      
      return md5($timestamp.$vtmodule.$vtmodule_id.$this->crmApiKey);
  }
  
  /**
   * function validateApiToken.
   *
   */
  function validateApiToken($apitoken,$timestamp,$vtmodule,$vtmodule_id)
  {
      
      $md5 = md5($timestamp.$vtmodule.$vtmodule_id.$this->crmApiKey);

      return ($apitoken == $md5) ? true : false;
      
  }
  
  /**
   * function validateCrmModule.
   *
   */
  function validateCrmModule($module) 
  {
      global $config;
      
      $module = strtolower($module);
      
      $allowed = strtolower($config['crm']['allowedmodules']);
      $allowed = preg_replace('/\s+/','',$allowed);
      
      $aAlowed = explode(',',$allowed);
  //echo "module=$module, ".print_r($aAlowed);
      return in_array ($module,$aAlowed);
  }

}
// eof