<?php


class html
{

  static function header()
  {

    $dateUntil = (DATE("Y") != 2016) ? '-'. DATE("Y") : '';
  
    $html = <<<EOD
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<!--
VtWebmanager by Vicus eBusiness Solutions B.V.
Webmanager for vtiger CRM
Copyright 2016{$dateUntil} Vicus
www.vicus.nl
-->
<head>
<title>Vicus JFM WebApp</title>
<meta content="text/html; charset=utf-8" http-equiv="Content-Type" />
<meta content="minimum-scale=1.0, width=device-width, maximum-scale=0.6667, user-scalable=no" name="viewport" />

<link href="veb/webapp/css/webapp.css" rel="stylesheet" media="screen" type="text/css" />
<link href="veb/webapp/css/jfm.css" rel="stylesheet" media="screen" type="text/css" />

<script src="veb/webapp/javascript/functions.js" type="text/javascript"></script>
<script src="veb/webapp/javascript/jquery/jquery-1.12.3.min.js"></script>
<script src="veb/webapp/javascript/jquery/jquery-ui.js"></script>

<meta content="webapp" name="keywords" />
<meta content="Vicus webapp" name="description" />

<link rel="apple-touch-icon" href="veb/webapp/images/WebVisitAnalyser-transp_icon_150x150.png" />
<link rel="apple-touch-startup-image" href="veb/webapp/images/WebVisitAnalyser_icon_150x150.png" />

<meta name="apple-mobile-web-app-capable" content="yes" />
<meta name="apple-mobile-web-app-status-bar-style" content="black" />

<meta http-equiv="X-UA-Compatible" content="IE=edge" />
<meta name="generator" content="VtWebApp" />
<meta name="Language" content="NL" />
<meta name="copyright" content="2016{$dateUntil} Vicus eBusiness Solutions BV" />
<meta name="web_author" content="Vicus eBusiness Solutions BV" />
<meta name="author" content="Vicus eBusiness Solutions BV" />
<meta name="robots" content="noindex, nofollow" />
<meta name="revisit-after" content="1 month" />
<meta name="subject" content="VtWebApp" />
</head>
<body onload="getLocation();">

EOD;

  return $html;

  }

/**
<link rel="apple-touch-icon" href="touch-icon-iphone.png">
<link rel="apple-touch-icon" sizes="152x152" href="touch-icon-ipad.png">
<link rel="apple-touch-icon" sizes="180x180" href="touch-icon-iphone-retina.png">
<link rel="apple-touch-icon" sizes="167x167" href="touch-icon-ipad-retina.png">
*/


  static function footer()
  {
      return '
<div id="footer">
<a href="https://www.vicus.nl">Powered by Vicus</a></div>    
</body>
</html>';
  }

  static function topbar($leftnav = '', $rightnav = '')
  {
    $targetLeft = '';
    $targetRight = '';
  
    $html = '<div id="topbar" class="transparent">'."\n";
    $html .= "\t".'<div id="title">JourneyFunnel Manager</div>'."\n";
  
    switch ($leftnav)
    {
      case 'home': 
        $targetLeft = "\t".'<a href="jfm.php?m=jfmtodo&a=list">Home</a>';
        break;
      default:
        $targetLeft = "\t".'<a href="https://www.vicus.nl" class="noeffect">Vicus</a>';
    }
    

    switch ($rightnav)
    {
      case 'home': 
        $targetRight = "\t".'<a href="jfm.php?m=jfmtodo&a=list">Home</a>';
        break;
      case 'logout':
      default:
        //$targetRight = '<a href="https://www.vicus.nl" class="noeffect">Vicus</a>';
        $targetRight = "\t".'<a href="jfm.php?m=users&a=logout">Log uit</a>';
    }
    
    if ($leftnav !== false && $targetLeft != '') {
      $html .= "\t".'<div id="leftnav">'.$targetLeft.'</div>'."\n";
    }
    
    if ($rightnav !== false && $targetRight != '') {
      $html .= "\t".'<div id="rightnav">'.$targetRight.'</div>'."\n";
    }

    $html .= '</div>'."\n";

    return $html;
  }


  static function menubar($options = array())
  {
    $html = '';

    foreach ($options as $id => $settings)
    {  
        if (isset($settings['_new']) && $settings['_new'] === true)
        {
          $menu[] = '<a href="https://www.vicus.nl" class="noeffect">Vicus</a>';
        }
        else {
            $item = $settings['item'];
            $link = $settings['link'];

            $pressed = '';
            if ($_GET['m'] == 'jfmtodo' && $item == 'bellijst') {
                $pressed = 'id="pressed"';// jfmtodo
            }

            $menu[] = '<a href="'.$link.'" ' .$pressed.' >'.$item.'</a>';
        }
    }
    
    if ( count($menu) > 0 )
    {

      $html .= '<div id="tributton">';
      $html .= '<div class="links">';
      $html .= implode(' ',$menu);
      $html .= '</div>';
      $html .= '</div>';
    }

    return $html;
  }


  
  static function searchbox()
  {
    return '
<div class="searchbox">
<form action="" method="get">
  <fieldset><input id="search" placeholder="search" type="text" />
  <input id="submit" type="hidden" /></fieldset>
</form>
</div>';
  }
  
    static function formStart($module, $id = '', $crmid = 0)
    {
      $html = '<form ';
      if ($id) $html .= ' id="'.$id.'"';
      $html .= 'method="post" action="'.$_SERVER['SCRIPT_NAME'].'?m='.$module.'&a=save" >'."\n";
    
      $html .= '<input type="hidden" name="i" value="'.$crmid.'">'."\n";
      $html .= '<input type="hidden" name="starttime" value="'.date("Y-m-d H:m:i").'">'."\n";
      
      return $html;
    }

    static function fieldsetStart($title = '', $class = 'graytitle')
    {
      $html = '<fieldset>'."\n";
      if ($title) $html .= '<span class="'.$class.'">'.$title.'</span>'."\n";
      return $html;
    }

    static function fieldsetEnd($title = '')
    {
      return '</fieldset>'."\n";
    }    


    static function message($msg = '', $type = 'info')
    {
      $html = '';
//      $html .= '<span class="graytitle">'.$type.'</span>';
      $html .= '<ul class="pageitem">'."\n";
      $html .=  '<li class="textbox"><span class="header">Systeembericht - '.$type.'</span>'.$msg.'</li>'."\n";
		  $html .=  '</ul>'."\n\n";
      return $html;
    }    
  
}