<?PHP

abstract class AsbstractAction
{

    abstract protected function getBody($id = 0);
}

class Action extends AsbstractAction
{

    var $_module = '';
    var $_action = '';
    var $_crmid = '';
    var $_user_name = '';
    var $_mapping = array();
    var $_idfield = '';
//  var $focus = object;
    //var $container = array();
    var $_actionDateField = 'c_date_follow_up';
    var $_actionNoteField = 'c_initiative_notes';

    function __construct($module = '', $action = '', $crmid = '')
    {
        global $login_user_name;

        $this->_user_name = $login_user_name;
        $this->_mapping = $this->getMapping();
        $this->_idfield = (isset($this->_mapping['crmid'])) ? $this->_mapping['crmid'] : false;
        $this->_actionDateField = (isset($this->_mapping['nextaction_date'])) ? $this->_mapping['nextaction_date'] : false;
        $this->_actionNoteField = (isset($this->_mapping['nextaction_text'])) ? $this->_mapping['nextaction_text'] : false;

        if ($this->isModule($module))
        {
            $this->_module = ucfirst($module);
        }

        $this->_action = ucfirst($action);

        if ($this->isId($crmid))
        {
            $this->_crmid = (int) $crmid;
        }

        // initiate new module object
        /**
          if($this->isModule($module) && in_array($module, array('Leads','Accounts'))) {
          $this->_module = 'Leads';
          $this->focus = CRMEntity::getInstanceById(230786, $this->_module);
          //      $this->focus->setId();
          echo 'hihi';
          var_dump($this);
          }
         */
    }

    function getBody($id = 0)
    {
        return '';
    }

    function formatListSplit()
    {

        //  case 'Goal4today-target': $image = 'goal4today-target.png'; break;      
        //  case 'Goal4today-target': $image = 'goal4today-reached.png'; break;
        $image = 'goal4today-reached.png';

        $html = '';
        $html .= '<li class="store">';
//    $html .= '<span class="image" style="background-image: url(\'veb/webapp/images/vtiger-icons-50x50/'.$image.'\')"><br /><br /><br /><br />'.$data['objectno'].'</span>';
        $html .= '<span class="image" style="background-image: url(\'veb/webapp/images/vtiger-icons-50x50/' . $image . '\')"><br /><br /><br /><br /></span>';
        $html .= '<span class="name">Klaar voor vandaag!</span>';
        $html .= '<span class="comment">Verder bellen mag altijd!</span>';
//    $html .= '<span class="stars'.$stars.'"></span>';
//    $html .= '<span class="starcomment">'.$data['nextaction_date']. ' ' . $data['status'].' '.format::euro($data['expected_value']).'</span><span class="arrow"></span>';
//    $html .= '</a>';
        $html .= '</li>';

        return $html;
    }

    /**
     * Prefered todo list format
     */
    function formatListItem($data)
    {
        $link = '';
        $html = '';

        if (isset($data['module']) && isset($data['crmid']))
        {
            $link = $this->formatLink($data['module'], 'view', $data['crmid']);
        }

        $html .= '<li class="store">';
        $html .= '<a href="' . $link . '" title="' . $data['module'] . '" target="_top">'; // class="noeffect" add to open in new screen

        switch (strtolower($data['module']))
        {
            case 'leads': $image = 'leads.png';
                break;
            case 'potentials': $image = 'potentials.png';
                break;
            case 'accounts': $image = 'accounts.png';
                break;
            case 'contacts': $image = 'contacts.png';
                break;
            case 'calendar': $image = 'calendar.png';
                break;
            case 'salesorder': $image = 'salesorder.png';
                break;

            default:
                $image = 'default.png';
        }

        $rawscore = intval($data['wv_score']);
        $score = intval($rawscore/100);
        switch ($leadscore)
        {
            case 5: $stars = 5;
                break;
            case 4: $stars = 4;
                break;
            case 3: $stars = 3;
                break;
            case 2: $stars = 2;
                break;
            case 1: $stars = 1;
                break;
            default:
                $stars = 0;
        }


        // liever 170x170 // https://castellum.vicus.nl/jfm.php?m=jfmtodo&a=list
        $html .= '<span class="image" style="background-image: url(\'veb/webapp/images/vtiger-icons-50x50/' . $image . '\')"><br /><br /><br /><br />' . $data['objectno'] . '</span>';
        $html .= '<span class="name">' . $data['title'] . '</span>';
        $html .= '<span class="comment">' . $data['salutation'] . ' ' . $data['firstname'] . ' ' . $data['lastname'] . '</span>';
        $html .= '<span class="stars' . $stars . '"></span>';
        $html .= '<span class="starcomment">' . $data['nextaction_date'] . ' ' . $data['status'] . ' ' . format::euro($data['expected_value']) . '</span><span class="arrow"></span>';
        $html .= '</a>';
        $html .= '</li>';
        return $html;
    }

    function formatLink($module = '', $action = '', $crmid = 0)
    {

        $params = array();
        if ($module <> '')
            $params['m'] = 'm=' . ucfirst($module);
        if ($action <> '')
            $params['a'] = 'a=' . ucfirst($action);
        if ($crmid <> '')
            $params['i'] = 'i=' . (int) $crmid;

        $link = $_SERVER['SCRIPT_NAME'];

        if (count($params) > 0)
        {
            $link .= '?';
            $link .= implode('&', $params);
        }
        return $link;
    }

    /**
     * expected input is container with standard formatted data
     * @obsolete
     */
    function formatListItem2($data)
    {
        $html = "\n";

        $html .= '<a href="https://www.vicus.nl">';
        $html .= '<div class="listitem ' . $this->_module . '">' . "\n";

        $html .= "\t" . '<div class="row header">' . "\n";
        $html .= "\t\t" . '<div class="cell text">' . $data['objectno'] . '</div>' . "\n";
        $html .= "\t\t" . '<div class="cell3 text bold">' . $data['title'] . '</div>' . "\n";
        $html .= "\t" . '</div>' . "\n";

        $html .= "\t" . '<div class="row status">' . "\n";
        $html .= "\t\t" . '<div class="cell text">' . $data['status'] . '</div>' . "\n";
        $html .= "\t\t" . '<div class="cell euro">' . $data['expected_projectamount'] . '</div>' . "\n";
        $html .= "\t\t" . '<div class="cell euro">' . $data['expected_annualamount'] . '</div>' . "\n";
        $html .= "\t\t" . '<div class="cell euro">' . $data['expected_value'] . '</div>' . "\n";
        $html .= "\t" . '</div>' . "\n";

        $html .= "\t" . '<div class="row contact">' . "\n";
        $html .= "\t\t" . '<div class="cell text">' . $data['salutation'] . '</div>' . "\n";
        $html .= "\t\t" . '<div class="cell text">' . $data['firstname'] . '</div>' . "\n";
        $html .= "\t\t" . '<div class="cell2 text">' . $data['lastname'] . '</div>' . "\n";
        $html .= "\t" . '</div>' . "\n";

        $html .= "\t" . '<div class="row planning">' . "\n";
        $html .= "\t\t" . '<div class="cell date">' . $data['nextaction_date'] . '</div>' . "\n";
        $html .= "\t\t" . '<div class="cell time">' . $data['nextaction_time'] . '</div>' . "\n";
        $html .= "\t\t" . '<div class="cell type">' . $data['nextaction_type'] . '</div>' . "\n";
        $html .= "\t\t" . '<div class="cell text">' . $data['nextaction_text'] . '</div>' . "\n";
        $html .= "\t" . '</div>' . "\n";
        $html .= '</a>' . "\n\n";

        $html .= '</div>' . "\n";

        return $html;
    }

    function actionResult($code)
    {
        switch (strtoupper($code))
        {
            case 'GO':
                $doUpdateMsg = 'GO we gaan verder';
                break;
            case 'HLD':
                $doUpdateMsg = 'HLD Hold';
                break;
            case 'GCO':
                $doUpdateMsg = 'GCO Geen contact';
                break;
            case 'NOB':
                $doUpdateMsg = 'NOB Nummer onbekend of fout';
                break;
            case 'CPM':
                $doUpdateMsg = 'CPM Contactpersoon mist of onbekend';
                break;
            case 'VMI':
                $doUpdateMsg = 'VMI Voicemail Ingesproken';
                break;
            case 'VMN':
                $doUpdateMsg = 'VMN Voicemail Niet Ingesproken';
                break;
            case 'AFW':
                $doUpdateMsg = 'AFW Afwezig';
                break;
            case 'AFG':
                $doUpdateMsg = 'AFG Afspraak gemaakt';
                break;
            case 'LOS':
                $doUpdateMsg = 'LOS Lost';
                break;
            case 'QO':
                $doUpdateMsg = 'QO Qualified Out';
                break;
            case 'NUR':
                $doUpdateMsg = 'NUR Nurture';
                break;
            default:
                print("code {$code} niet gevonden in " . __FUNCTION__);
        }
        return array('note' => $doUpdateMsg);
    }

    function actionNext($code)
    {
        switch (strtoupper($code))
        {
            case 'HLD':
                $doUpdateMsg = 'HLD Hold';
                break;
            case 'IAF':
                $doUpdateMsg = 'IAF Intern Afstemmen';
                break;
            case 'LTB':
                $doUpdateMsg = 'LTB Later terugbellen';
                break;
            case 'INF':
                $doUpdateMsg = 'INF Info sturen';
                break;
            case 'DEM':
                $doUpdateMsg = 'DEMO inlog sturen';
                break;
            case 'AFM':
                $doUpdateMsg = 'AFM Afspraak maken';
                break;
            case 'OFF':
                $doUpdateMsg = 'OFF Offerte maken/sturen';
                break;
            case 'CNV':
                $doUpdateMsg = 'CNV Converteren';
                break;
            default:
                print("code {$code} niet gevonden in " . __FUNCTION__);
        }
        return array('note' => $doUpdateMsg, 'status' => $newStatus);
    }

    function actionWhen($code)
    {
        switch (strtoupper($code))
        {

            case 'VAN':
            case 'U':
                $doUpdateMsg = 'VAN 1 uur verplaatst';
                $newActionDate = date('Y-m-d H:i:s', mktime(date("H") + 1, date("i"), date("s"), date("m"), date("d"), date("Y")));
                break;
            case 'D':
                $doUpdateMsg = '1 dag verplaatst';
                $newActionDate = date('Y-m-d', mktime(0, 0, 0, date("m"), date("d") + 1, date("Y")));
                break;
            case 'W':
                $doUpdateMsg = 'Week verplaatst';
                $newActionDate = date('Y-m-d', mktime(0, 0, 0, date("m"), date("d") + 7, date("Y")));
                break;
            case '+2W':
                $doUpdateMsg = '2 Weken verplaatst';
                $newActionDate = date('Y-m-d', mktime(0, 0, 0, date("m"), date("d") + 14, date("Y")));
                break;
            case '+3W':
                $doUpdateMsg = '3 Weken verplaatst';
                $newActionDate = date('Y-m-d', mktime(0, 0, 0, date("m"), date("d") + 21, date("Y")));
                break;
            case '+4W':
                $doUpdateMsg = '4 Weken verplaatst';
                $newActionDate = date('Y-m-d', mktime(0, 0, 0, date("m"), date("d") + 28, date("Y")));
                break;
            case '+8W':
                $doUpdateMsg = '8 Weken verplaatst';
                $newActionDate = date('Y-m-d', mktime(0, 0, 0, date("m"), date("d") + 56, date("Y")));
                break;
            case '+1M':
                $doUpdateMsg = 'Maand verplaatst';
                $newActionDate = date('Y-m-d', mktime(0, 0, 0, date("m") + 1, date("d"), date("Y")));
                break;
            case '+3M':
                $doUpdateMsg = 'Maand verplaatst';
                $newActionDate = date('Y-m-d', mktime(0, 0, 0, date("m") + 3, date("d"), date("Y")));
            case 'MAA':
            case 'DIN':
            case 'WOE':
            case 'DON':
            case 'VRI':
            case 'ZAT':
            case 'ZON':
                $doUpdateMsg = 'naar ' . $code . ' as verplaatst';
                $newActionDate = datetimehelper::calculateNextWeekday($code);
                break;
            case 'RES':
                $doUpdateMsg = 'Actiedatum reset (=leeg)';
                $newActionDate = NULL;
                break;
            default:
                print("code {$code} niet gevonden in " . __FUNCTION__);
        }
        return array('note' => $doUpdateMsg, 'date' => $newActionDate);
    }

    /**
     * Code added for 'Multiple SQL Injection Vulnerabilities & XSS issue' fixes - Philip
     */
    function isId($id)
    {
        if (isset($id) && !is_numeric($id) && $id != '')
        {
            die("An invalid record number specified");
        }
        return true;
    }

    function isModule($m)
    {
        return true;
        if (isset($m) && $m == '')
        {
            die("An invalid module /{$m}/ specified");
        }
    }

    function _mapTheData($row)
    {
        $mapping = $this->getMapping();
        $data = array();
        foreach ($mapping as $JFMkey => $CRMkey)
        {
            //$data[$JFMkey] = ($CRMkey === false || $CRMkey == '') ? '' : $row[$CRMkey];
            $data[$JFMkey] = (isset($row[$CRMkey]) && $CRMkey != '') ? $row[$CRMkey] : '';


            if ($JFMkey == 'nextaction_time' && $data[$JFMkey] = '')
            {
                $data['nextaction_time'] = '00:00:00';
            }
        }

        return $data;
    }

    function _runListQuery($sql)
    {
        global $adb;

        $data = array();

        $result = $adb->pquery($sql, array());

        if ($result)
        {
            while ($row = $adb->fetch_array($result)) {
                $rowMapped = $this->_mapTheData($row);
                $id = $rowMapped['nextaction_date'] . $rowMapped['nextaction_time'] . $rowMapped['crmid']; // next action date / time 00:00:00
                $data[$id] = $this->formatListItem($rowMapped);
            }
        } else
        {
            var_dump($adb);
        }

        return $data;
    }

    function _startViewBody()
    {
        $html = html::topbar('home', 'logout');
        $html .= '<div id="content">' . "\n";
        $html .= html::formStart($this->_module, '', $this->_crmid);

        return $html;
    }

    function _endViewBody()
    {
        $html = '
<ul class="pageitem">
	<li class="button">
	<input name="Submit input" type="submit" value="Opslaan" /></li>
</ul>' . "\n";

        $html .= '</form>' . "\n";
        $html .= '</div>' . "\n";
        return $html;
    }

    function _getViewBody($dataMapped)
    {

        $html = $this->_startViewBody();

//    $html .= html::fieldsetStart('Lead Info - '.$dataMapped['objectno']);
//    $html .= html::fieldsetStart('xxxxx');
        $html .= '<ul class="pageitem">' . "\n";
        $html .= '<li class="textbox"><span class="header">' . $dataMapped['title'] . ' - ' . $dataMapped['objectno'] . '</span>' . $dataMapped['description'] . '</li>' . "\n";
        if ($dataMapped['status'])
            $html .= '<li class="textbox"><span class="header">' . $dataMapped['status'] . '</span>' . '</li>' . "\n";
        if ($dataMapped['plan'])
            $html .= '<li class="textbox"><span class="header">' . format::plan($dataMapped['plan']) . '</span>' . '</li>' . "\n";
        $html .= '</ul>' . "\n\n";
//    $html .= html::fieldsetEnd();
//    $html .= html::fieldsetStart('Verwachtingen');
        /*
          $html .= '<ul class="pageitem">';
          $html .= '<li class="textbox"><span class="header">Verwachtingswaarde</span>'.$dataMapped['expected_projectamount'].' + 3x '.$dataMapped['expected_annualamount'].' = '.$dataMapped['expected_value'].'</li>';
          $html .= '</ul>';
          //    $html .= html::fieldsetEnd();
         */

        // =================================================================== Gerelateerde Verkoopkansen (bij accounts)
        if ($this->_module == 'Accounts')
        {
            $potentials = $this->getPotentialsBlock();

            if (count($potentials) > 0)
            {
                $html .= '<span class="graytitle">Verkoopkansen</span>' . "\n";
                $html .= '<ul class="pageitem">' . "\n";
                foreach ($potentials as $id => $pData)
                {
                    $html .= '<li class="textbox">' . '- ' . $pData['potentialname'] . ' ' . $pData['sales_stage'] . '</li>' . "\n";
                }
                $html .= '</ul>' . "\n\n";
            }
        }


        // =================================================================== Interesse

        $html .= '<span class="graytitle">Interesse</span>';
        $html .= '<ul class="pageitem">';
        if ($dataMapped['interest_solutions'] . $dataMapped['interest_products'] . $dataMapped['interest_text'] . $dataMapped['interest_webform'] != '')
        {
            if ($dataMapped['interest_solutions'])
            {
                $html .= '<li class="textbox"><span class="header">Oplossingen</span>' . str_replace(' |##| ', ', ', $dataMapped['interest_solutions']) . '</li>';
            }
            if ($dataMapped['interest_products'])
            {
                $html .= '<li class="textbox"><span class="header">Producten</span>' . str_replace(' |##| ', ', ', $dataMapped['interest_products']) . '</li>';
            }
            if ($dataMapped['interest_text'])
            {
                $html .= '<li class="textbox"><span class="header">Vraagstelling</span>' . $dataMapped['interest_text'] . '</li>';
            }
            if ($dataMapped['interest_webform'])
            {
                $html .= '<li class="textbox"><span class="header">Webformulier</span>' . $dataMapped['interest_webform'] . '</li>';
            }
        } else
        {
            $html .= '<li class="textbox"><span class="header">Geen info beschikbaar</span></li>';
        }
        $html .= '</ul>';

        // =================================================================== Contactpersoon
        $html .= '<span class="graytitle">Contactpersoon</span>';
        $icon = ' <img src="veb/webapp/images/vtiger-icons-24x24/Contacts.png"> ';
//    $html .= html::fieldsetStart('Contactgegevens');
        $html .= '<ul class="pageitem">';

        $contacts = $this->getContactBlock();

        if ($dataMapped['salutation'] . $dataMapped['firstname'] . $dataMapped['lastname'] != '' || count($contacts) > 0)
        {
            if ($dataMapped['salutation'] . $dataMapped['firstname'] . $dataMapped['lastname'] != '')
            {
                $html .= '<li class="textbox">' . $icon . format::salutation($dataMapped['salutation']) . ' ' . $dataMapped['firstname'] . ' ' . $dataMapped['lastname'] . ' ' . $dataMapped['phone'] . ' ' . $dataMapped['mobile'] . '</li>';
            }
            if (is_array($contacts))
                foreach ($contacts as $id => $cpinfo)
                {
                    $html .= '<li class="textbox">' . $icon . $cpinfo['salutation'] . ' ' . $cpinfo['firstname'] . ' ' . $cpinfo['lastname'] . '</li>';
                }
        } else
        {
            $html .= '<li class="textbox"><span class="header">Geen contactpersoon beschikbaar</span></li>';
        }

        $html .= '</ul>';

        // ======================================== Phone try to have all numbers once
        // challenge generic phone vs personal phone
        // use new format:phoneasindex to have clean phonenumber to use as index
        $htmlPhone = array();
        $iconMob = ' <img src="veb/webapp/images/vtiger-icons-24x24/Mobile.png">';
        $iconPhon = ' <img src="veb/webapp/images/vtiger-icons-24x24/PBXManager.png">';

        if ($dataMapped['phone'] . $dataMapped['mobile'] != '')
        {
            $lastname = ($dataMapped['lastname']) ? $dataMapped['lastname'] : 'Algemeen';
            if ($dataMapped['phone'])
            {
                $index = format::phoneasindex($dataMapped['phone']);
                if (!isset($htmlPhone[$index]))
                {
                    $htmlPhone[$index] = '<li class="callbutton"><a href="tel:' . format::phoneasindex($dataMapped['phone']) . '">' . $iconPhon . ' Tel:<br>' . $lastname . '</a></li>';
                }
            }
            // format::phone($dataMapped['phone'])
            if ($dataMapped['mobile'])
            {
                $index = format::phoneasindex($dataMapped['mobile']);
                if (!isset($htmlPhone[$index]))
                    $htmlPhone[$index] = '<li class="callbutton"><a href="tel:' . format::phoneasindex($dataMapped['mobile']) . '">' . $iconMob . ' Mob:<br>' . $lastname . '</a></li>';

                // .format::phone($dataMapped['mobile'])
            }
            // $icon = ' <img src="veb/webapp/thumbs/mail.png">';
            //		if ($dataMapped['email']) $html .= '<li class="callbutton"><a href="mailto:'.$dataMapped['email'].'">'.$icon.'<br>'.substr($dataMapped['email'],0,8).'</a></li>';
        }

        if (is_array($contacts) && count($contacts) > 0)
        {
            foreach ($contacts as $id => $cpinfo)
            {
                if ($cpinfo['phone'])
                {
                    $index = format::phoneasindex($cpinfo['phone']);
                    $phone = ($cpinfo['phone']) ? ' <a href="tel:' . str_replace(' ', '', $cpinfo['phone']) . '">' . $iconPhon . ' Tel:<br />' . format::nameshort($cpinfo['firstname'], $cpinfo['lastname']) . '</a>' : '';
                    if (!isset($htmlPhone[$index]))
                        $htmlPhone[$index] = '<li class="callbutton">' . $phone . '</li>';
                }
                if ($cpinfo['mobile'])
                {
                    $index = format::phoneasindex($cpinfo['mobile']);
                    $mobile = ($cpinfo['mobile']) ? ' <a href="tel:' . str_replace(' ', '', $cpinfo['mobile']) . '">' . $iconMob . ' Mob:<br />' . format::nameshort($cpinfo['firstname'], $cpinfo['lastname']) . '</a>' : '';
                    if (!isset($htmlPhone[$index]))
                        $htmlPhone[$index] = '<li class="callbutton">' . $mobile . '</li>';
                }
            }
        }
//print_r($htmlPhone);
        $html .= '<ul class="buttonrow">';
        $html .= implode("\n", $htmlPhone);
        $html .= '</ul>';

        // =================================================================== WebVisitAnalyser
        $html .= '<span class="graytitle">WebVisitAnalyser</span>';

        $html .= '<ul class="pageitem">';
        if ($dataMapped['wv_allsources'] . $dataMapped['wv_scoregroups'] . $dataMapped['wv_score'] . $dataMapped['wv_nofvisits'] . $dataMapped['wv_nofpages'] == '')
        {

//		$html .= '<li class="textbox"><span class="header">WebVisitAnalyser</span></li>';
//		$html .= '<table><tr>';
//		$html .= '<td>'.$dataMapped['wv_score'].'</td>';
//		$html .= '</tr></table>';
//		$html .= '<li class="smallfield"><span class="name">Score</span><input readonly placeholder="enter text" name="wv_score" type="text" value="'.$dataMapped['wv_score'].'" /></li>';
///		$html .= '<li class="smallfield"><span class="name">Bezoeken</span><input readonly placeholder="enter text" name="wv_nofvisits" type="text" value="'.$dataMapped['wv_nofvisits'].'" /></li>';
//		$html .= '<li class="smallfield"><span class="name">Pagina\'s</span><input readonly placeholder="enter text" type="text" value="'.$dataMapped['wv_nofpages'].'" /></li>';
//		$html .= '<li class="smallfield"><span class="name">Bron</span><input readonly placeholder="enter text" type="text" value="'.$dataMapped['wv_sourcefirstvisit'].'" /></li>';
            if ($dataMapped['wv_allsources'])
            {
                //  		$html .= '<li class="bigfield"><input readonly placeholder="enter text" type="text" value="'.str_replace(' |##| ',', ', $dataMapped['wv_allsources']).'" /></li>';
                $html .= '<li class="textbox"><span class="header">Bronnen</span>' . str_replace(' |##| ', ', ', $dataMapped['wv_allsources']) . '</li>';
            }
            if ($dataMapped['wv_scoregroups'])
            {
                //		  $html .= '<li class="bigfield"><input readonly placeholder="enter text" type="text" value="'.str_replace(' |##| ',', ', $dataMapped['wv_scoregroups']).'" /></li>';
                $html .= '<li class="textbox"><span class="header">Scoregroepen</span>' . str_replace(' |##| ', ', ', $dataMapped['wv_scoregroups']) . '</li>';
            }
            $html .= '</ul>';

            $html .= '<ul class="buttonrow">';
            $icon = ' <img src="veb/webapp/thumbs/stocks.png">';
            if ($dataMapped['wv_score'])
                $html .= '<li class="wvainfo">' . $icon . '<br>Score: ' . $dataMapped['wv_score'] . '</a></li>';
            if ($dataMapped['wv_nofvisits'])
                $html .= '<li class="wvainfo">' . $icon . '<br>Visits: ' . $dataMapped['wv_nofvisits'] . '</a></li>';
            if ($dataMapped['wv_nofpages'])
                $html .= '<li class="wvainfo">' . $icon . '<br>Pages: ' . $dataMapped['wv_nofpages'] . '</a></li>';
            $html .= '</ul>';
        }
        else
        {
            $html .= '<li class="textbox"><span class="header">Geen info beschikbaar</span></li>';
        }
        $html .= '</ul>';

        // =================================================================== Actie notities
        $html .= '<span class="graytitle">Actie notities</span>';
        $html .= '<ul class="pageitem">';
        if ($dataMapped['nextaction_date'])
        {
            $icon = ' <img src="veb/webapp/images/vtiger-icons-24x24/Calendar.png"> ';
            $html .= '<li class="textbox"><span class="header">' . $icon . $dataMapped['nextaction_date'] . ' ' . $dataMapped['nextaction_time'] . ' ' . $dataMapped['nextaction_type'] . '</span></li>';
        }

        if ($dataMapped['nextaction_text'])
        {
            $aTxt = explode("\n", $dataMapped['nextaction_text']);
            foreach ($aTxt as $txtId => $txtTxt)
            {
                $html .= '<li class="textbox">' . $txtTxt . '</li>';
            }
        } else
        {
            $html .= '<li class="textbox"><span class="header">Geen info beschikbaar</span></li>';
        }
        

        $html .= '</ul>';

        // =================================================================== ModComments
        $html .= '<span class="graytitle">Comments</span>';
        $html .= '<ul class="pageitem">';
        $comments = $this->getModComments($dataMapped['crmid']);
        if (count($comments) >0) {
            foreach ($comments as $commentId => $commentTxt)
            {
                $html .= '<li class="textbox">' . $commentTxt . '</li>';
            }
        }
        $html .= '</ul>';
        
        // =================================================================== Sentiment
        $html .= '<span class="graytitle">Sentiment</span>';
        $html .= '<ul class="buttonrow">';
        $smiley1 = ' <img src="veb/webapp/images/webapp/smiley-1-green.png">';
        $smiley2 = ' <img src="veb/webapp/images/webapp/smiley-2-green.png">';
        $smiley3 = ' <img src="veb/webapp/images/webapp/smiley-3-yellow.png">';
        $smiley4 = ' <img src="veb/webapp/images/webapp/smiley-4-red.png">';
        $smiley5 = ' <img src="veb/webapp/images/webapp/smiley-5-red-dark.png">';

        $html .= '
<li class="radiobutton"><input name="sentiment" type="radio" value="--" />' . $smiley1 . '</li>
<li class="radiobutton"><input name="sentiment" type="radio" value="--" />' . $smiley2 . '</li>
<li class="radiobutton"><input name="sentiment" type="radio" value="--" />' . $smiley3 . '</li>
<li class="radiobutton"><input name="sentiment" type="radio" value="--" />' . $smiley4 . '</li>
<li class="radiobutton"><input name="sentiment" type="radio" value="--" />' . $smiley5 . '</li>
';
        $html .= '</ul>';


        // =================================================================== Next actions
        // 5 stappen
        // hold, proceed, lost, qualified out, nurture
        // Lead info
        $html .= '<span class="graytitle">Resultaat</span>';
        $html .= '<ul class="buttonrow">';
//    $html .= '<span class="header">Resultaat</span>';

        $html .= '
			<li class="radiobutton"><span class="name">GO</span><input name="action-result" type="radio" value="GO" /><span class="title">GO</span></li>
			<li class="radiobutton"><span class="name">HLD</span><input name="action-result" type="radio" value="HLD" /><span class="title">Hold</span></li>
			<li class="radiobutton"><span class="name">GCO</span><input name="action-result" type="radio" value="GCO" /><span class="title">Geen Contact</span></li>
			<li class="radiobutton"><span class="name">CPM</span><input name="action-result" type="radio" value="CPM" /><span class="title">Contactpersoon mist</span></li>
			<li class="radiobutton"><span class="name">NOB</span><input name="action-result" type="radio" value="NOB" /><span class="title">Nummer fout</span></li>
			<li class="radiobutton"><span class="name">VMI</span><input name="action-result" type="radio" value="VMI" /><span class="title">Voicemail ingespr.</span></li>
			<li class="radiobutton"><span class="name">VMN</span><input name="action-result" type="radio" value="VMN" /><span class="title">Voicemail niet ingespr.</span></li>
			<li class="radiobutton"><span class="name">AFW</span><input name="action-result" type="radio" value="AFW" /><span class="title">Afwezig</span></li>
			<li class="radiobutton"><span class="name">AFG</span><input name="action-result" type="radio" value="AFG" /><span class="title">Afspraak gemaakt</span></li>
			<li class="radiobutton"><span class="name">LOS</span><input name="action-result" type="radio" value="LOS" /><span class="title">Lost</span></li>
			<li class="radiobutton"><span class="name">QO</span><input name="action-result" type="radio" value="QO" /><span class="title">Qualified Out</span></li>
			<li class="radiobutton"><span class="name">NUR</span><input name="action-result" type="radio" value="NUR" /><span class="title">Nurture</span></li>
			';
        $html .= '</ul>';

        $html .= '<span class="graytitle">Volgende actie</span>';
        $html .= '<ul class="buttonrow">';
//    $html .= '<span class="header">Volgende actie</span>';

        $html .= '
			<li class="radiobutton"><span class="name">HLD</span><input name="action-next" type="radio" value="HLD" /><span class="title">Hold</span></li>
			<li class="radiobutton"><span class="name">IAF</span><input name="action-next" type="radio" value="IAF" /><span class="title">Intern Afstemmen</span></li>
			<li class="radiobutton"><span class="name">LTB</span><input name="action-next" type="radio" value="LTB" /><span class="title">Later terug bellen</span></li>
			<li class="radiobutton"><span class="name">INF</span><input name="action-next" type="radio" value="INF" /><span class="title">Informatie sturen</span></li>
			<li class="radiobutton"><span class="name">DEM</span><input name="action-next" type="radio" value="DEM" /><span class="title">Demo (inlog) sturen</span></li>
			<li class="radiobutton"><span class="name">AFM</span><input name="action-next" type="radio" value="AFM" /><span class="title">Afspraak maken</span></li>
			<li class="radiobutton"><span class="name">OFF</span><input name="action-next" type="radio" value="OFF" /><span class="title">Offerte sturen</span></li>
			<li class="radiobutton"><span class="name">CNV</span><input name="action-next" type="radio" value="CNV" /><span class="title">Converteren</span></li>
			';
        $html .= '</ul>';

        $html .= '<span class="graytitle">Wanneer?</span>';
        $html .= '<ul class="buttonrow">';
//    $html .= '<span class="header">Wanneer?</span>';
        $dH = new DateTimeHelper();
        $html .= '
			<li class="radiobutton"><span class="name">VAN</span><input name="action-when" type="radio" value="' . $dH->day(0) . '" /><span class="title">Vandaag ' . $dH->day(0) . '</span></li>
			<li class="radiobutton"><span class="name">' . $dH->day(1) . '</span><input name="action-when" type="radio" value="' . $dH->day(1) . '" /><span class="title">Volgende werkdag</span></li>
			<li class="radiobutton"><span class="name">' . $dH->day(2) . '</span><input name="action-when" type="radio" value="' . $dH->day(2) . '" /><span class="title"></span></li>
			<li class="radiobutton"><span class="name">' . $dH->day(3) . '</span><input name="action-when" type="radio" value="' . $dH->day(3) . '" /><span class="title"></span></li>
			<li class="radiobutton"><span class="name">' . $dH->day(4) . '</span><input name="action-when" type="radio" value="' . $dH->day(4) . '" /><span class="title"></span></li>
			<li class="radiobutton"><span class="name">' . $dH->day(5) . '</span><input name="action-when" type="radio" value="' . $dH->day(5) . '" /><span class="title"></span></li>
			<li class="radiobutton"><span class="name">+2W</span><input name="action-when" type="radio" value="+2W" /><span class="title">Over 2 weken</span></li>
			<li class="radiobutton"><span class="name">+4W</span><input name="action-when" type="radio" value="+4W" /><span class="title">Over 4 weken</span></li>
			<li class="radiobutton"><span class="name">+8W</span><input name="action-when" type="radio" value="+8W" /><span class="title">Over 8 weken</span></li>
			<li class="radiobutton"><span class="name">RES</span><input name="action-when" type="radio" value="RES" /><span class="title">Datum leeg maken</span></li>
			';
        $html .= '</ul>';

        /*
          $html .= '
          <span class="graytitle">Notities</span>
          <ul class="pageitem">
          <li class="textbox"><textarea name="TextArea" rows="4"></textarea></li>
          </ul>';
         */
//		$html .= '</fieldset>';

        $html .= $this->_endViewBody();
        return $html;
    }

    function _contacts($sql)
    {
        global $adb;

        $id = $this->_crmid;

        $resultContacts = $adb->pquery($sql, array($id));
        $data = array();

        if (is_array($resultContacts->fields))
        {
            // Contacts found for this Potential
            while ($Contact = $adb->fetch_array($resultContacts)) {
                $id = $Contact['contactid'];
                // salutation,firstname,lastname,email,phone,mobile
                $data[$id]['salutation'] = format::salutation($Contact['salutation']);
                $data[$id]['firstname'] = $Contact['firstname'];
                $data[$id]['lastname'] = $Contact['lastname'] . ' ';
                $data[$id]['phone'] = format::phone($Contact['phone']);
                $data[$id]['mobile'] = format::phone($Contact['mobile']);
            }
        }
        return $data;
    }

    function _potentials($sql)
    {
        global $adb;

        $id = $this->_crmid;
        $resultPotentials = $adb->pquery($sql, array($id));
        $data = array();

        if (is_array($resultPotentials->fields))
        {
            // Potential found for this Account
            while ($Potential = $adb->fetch_array($resultPotentials)) {
//    	print_r($Potential);
                $id = $Potential['potentialid'];
                // salutation,firstname,lastname,email,phone,mobile
                $data[$id]['potentialname'] = $Potential['potentialname'];
                $data[$id]['sales_stage'] = $Potential['sales_stage'];
                $data[$id]['probability'] = $Potential['probability'];
            }
        }
        return $data;
    }

    function saveForm()
    {
        $actionResult = ($_POST['action-result']) ? $this->actionResult($_POST['action-result']) : '';
        $actionNext = ($_POST['action-next']) ? $this->actionNext($_POST['action-next']) : '';
        $actionWhen = ($_POST['action-when']) ? $this->actionWhen($_POST['action-when']) : '';

        $actionDate = '';
        $actionNotes = array();

        $starttime = ($_POST['starttime']) ? $_POST['starttime'] : '';
        $spendtime = datetimehelper::diff($starttime, date("Y:m:d H:m:i"));
        $actionNotes[] = $spendtime->minsec;

        if (is_array($actionResult) && count($actionResult) > 0 && $actionResult['note'] != '')
        {
            $actionNotes[] = $actionResult['note'];
        }

        if (is_array($actionNext) && count($actionNext) > 0 && $actionNext['note'] != '')
        {
            $actionNotes[] = $actionNext['note'];
        }

        if (is_array($actionWhen) && count($actionWhen) > 0)
        {
            $actionDate = $actionWhen['date'];
            if ($actionWhen['note'] != '')
                $actionNotes[] = $actionWhen['note'];
            $this->updateActionDate($actionDate);
        }

        if (is_array($actionNotes) && count($actionNotes) > 0)
        {
            $actionNote = implode(' - ', array_unique($actionNotes));
            $this->updateActionNote($actionNote);
        }



        $html = html::topbar('home', 'logout');
        $html .= '<div id="content">';
        $html .= '<ul class="pageitem">';
        $html .= '<li class="textbox"><span class="header">actionNote</span>' . $actionNote . '</li>';
        $html .= '<li class="textbox"><span class="header">actionDate</span>' . $actionDate . '</li>';

        $html .= '<li class="textbox"><span class="header">actionResult</span>' . print_r($actionResult, true) . '</li>';
        $html .= '<li class="textbox"><span class="header">actionNext</span>' . print_r($actionNext, true) . '</li>';
        $html .= '<li class="textbox"><span class="header">actionWhen</span>' . print_r($actionWhen, true) . '</li>';

        $html .= '<li class="textbox"><span class="header">POST</span>' . print_r($_POST, true) . '</li>';
        $html .= '</ul>';

        $redirectUrl = $this->formatLink('jfmtodo', 'list');
        
        $html .= '
	<ul class="pageitem">
		<li class="button">
  	<a href="' . $redirectUrl . '">Ga naar de lijst</a></li>
  </ul>';
        $html .= '</div>';

//        header('Window-target: _top');
//        header("Location: $redirectUrl");

        return $html;
    }

    function updateActionDate($date)
    {
        global $adb;

        $sql = "UPDATE {$this->_actionDateTable} SET {$this->_actionDateField}=? WHERE {$this->_idfield}=?";

        $result = $adb->pquery($sql, array($date, $this->_crmid));
    }

    function updateActionNote($text)
    {
        global $adb;

        if ($text == '')
            return;

        // first read old = existing values
        $sql = "SELECT {$this->_actionNoteField} FROM {$this->_actionNoteTable} WHERE {$this->_idfield}=?";
        $readAction = $adb->pquery($sql, array($this->_crmid));

        $message = date('ymd') . " {$this->_user_name} - {$text}\n" . $readAction->fields[$this->_actionNoteField];
        // Update custom notes field, defers per entity
        $sql = "UPDATE {$this->_actionNoteTable} SET {$this->_actionNoteField}=? WHERE {$this->_idfield}=?";
        $result = $adb->pquery($sql, array($message, $this->_crmid));
//    print_r($adb);
    }

    /**
     * Read the mod comments by date
     *
     * @since 190418
     * @author lro
     * @param   integer crmid
     * @return  array   with text per date/record
     */
    function getModComments($crmid)
    {
        global $adb;
        
        $commentcontent = array();
        $sql = "SELECT 
                    mc.userid, mc.related_to, mc.commentcontent,
                    ce.createdtime
                FROM 
                    vtiger_modcomments as mc
                LEFT JOIN
                    vtiger_crmentity as ce
                ON
                    mc.modcommentsid = ce.crmid
                WHERE 
                    related_to=? 
                ORDER BY modcommentsid DESC;";
        $result = $adb->pquery($sql, array($crmid));

        $noofrow = $adb->num_rows($result);
        for($i=0; $i<$noofrow ; $i++) {
            $timestamp = nl2br($adb->query_result($result,$i,'createdtime'));
            $commentcontent[] = $timestamp." - ".nl2br($adb->query_result($result,$i,'commentcontent'));

        }

        return $commentcontent;
    }
}

class ActionFactory
{

    public static function create($module, $action, $crmid)
    {
        global $root_directory;

        if ($module == '' || $action == '')
        {
//        echo html::message('er gaat iets fout met aanroepen van module en actie');
            return false;
        }

        $module = ucfirst(strtolower($module));
        $action = ucfirst($action);

        $fileModule = "{$root_directory}veb/webapp/modules/{$module}.php";
        $fileAction = "{$root_directory}veb/webapp/modules/{$module}/{$action}.php";

        require_once("{$root_directory}veb/webapp/modules/Leads.php");
        require_once("{$root_directory}veb/webapp/modules/Potentials.php");
        require_once("{$root_directory}veb/webapp/modules/Accounts.php");
        require_once("{$root_directory}veb/webapp/modules/Jfmtodo.php");
        require_once("{$root_directory}veb/webapp/modules/Salesorder.php");

        if (is_file($fileAction))
        {

            $classname = "{$module}_{$action}";
            require_once($fileAction);

            if (class_exists($classname))
            {
                $obj = new $classname($module, $action, $crmid);
                return $obj;
            } else
            {
                echo html::message("Invalid class {$classname} specified");
                return false;
            }
        } else
        {
            echo html::message("Invalid filename " . str_replace('$root_directory', '', $fileAction) . " specified");
            return false;
        }
    }

}
