<?php
/*********************************************************************************
** 
* The contents of this file are subject to the vtiger CRM Public License Version 1.0
* ("License"); You may not use this file except in compliance with the License
* The Original Code is:  vtiger CRM Open Source
* The Initial Developer of the Original Code is vtiger.
* Portions created by vtiger are Copyright (C) vtiger.
* Portions created by Vicus are Copyright (C) Vicus (www.vicus.nl).
* All Rights Reserved.
* @author	l.roovers <l.roovers@vicus.nl>
********************************************************************************/
ini_set("include_path", "../../");

//require('send_mail.php');
require_once('config.php');
require_once('config_veb.php');
require_once('include/utils/utils.php');
require_once('include/language/en_us.lang.php');

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<title>Vicus - Sales Funnel</title>
<link href="css/style.css" rel="stylesheet" type="text/css" />
</head>
<body>
<?php

/**********************************************************************************
* Finds the Leads and presdents them as Managementreport
* We make a correction after the query.. 
* For any converted leads (converted=1) we will change the leadstatus to Converted
* to have appropriate reporting
* cf_641 text LEA solutions - type 2, 33, maxlen=100
* cf_712 text POT solutions - type 2, 33, maxlen=100
* cf_541 text LEA products - type 2, 33 - was VARCHAR (200) type 2, 15
* cf_604 text POT products - type 2, 33 - was VARCHAR (200) type 2, 15
********************************************************************************/
	
	#
	# GET parameters
	#&& $_GET['user'] != ""
	
	if (isset($_GET['user']) )
	{
		$msg .= '<li>Gebruiker : '.$_GET['user'].'</li>';
		$selectLeadUser = "AND ce.smownerid = '{$_GET['user']}'";
		$selectPotUser = "AND ce.smownerid = '{$_GET['user']}'";
	} else {
		$selectLeadUser = '';
		$selectPotUser = '';
	}

# && $_GET['sol'] != ""
	if (isset($_GET['sol']))
	{
		$msg .= '<li>Oplossing : '.$_GET['sol'].'</li>';
		$solincom = str_replace(',',' |##| ',$_GET['sol']);
//		$msg .= '<li>Oplossing : '.$solincom.'</li>';
		if ($_GET['sol'] != "")
		{
			$selectLeadSol = "AND {$leadSolutionsField} LIKE '%{$solincom}%'  ";
			$selectPotSol = "AND {$potentialSolutionsField} LIKE '%{$solincom}%'  ";
		} else {
			$selectLeadSol = "AND {$leadSolutionsField} = ''  ";
			$selectPotSol = "AND {$potentialSolutionsField} = ''  ";
		}

	} else {
		$selectLeadSol = '';
		$selectPotSol = '';
	}

# && $_GET['prod'] != ""
	if (isset($_GET['prod']))
	{
		$msg .= '<li>Product : '.$_GET['prod'].'</li>';
		$solincom = str_replace(',',' |##| ',$_GET['prod']);
		if ($_GET['prod'] != "")
		{
			$selectLeadProd = "AND {$leadProductsField} LIKE '%{$solincom}%'  ";
			$selectPotProd = "AND {$potentialProductsField} LIKE '%{$solincom}%'  ";
		} else {
			$selectLeadProd = "AND {$leadProductsField} = ''  ";
			$selectPotProd = "AND {$potentialProductsField} = ''  ";
		}

	} else {
		$selectLeadProd = '';
		$selectPotProd = '';
	}

# && $_GET['stat'] != ""
	if (isset($_GET['stat']))
	{
		$msg .= '<li>Status : '.$_GET['stat'].'</li>';
		
		if ($_GET['stat'] == 'Converted')
		{
			$selectLeadStat = "AND (leadstatus LIKE '%{$_GET['stat']}%' or converted = 1) ";
			$selectPotStat = "AND (sales_stage LIKE '%{$_GET['stat']}%') ";
		} else {	
			$selectLeadStat = "AND leadstatus LIKE '%{$_GET['stat']}%'  ";
			$selectPotStat = "AND sales_stage LIKE '%{$_GET['stat']}%'  ";
		}
	} else {
		$selectLeadStat = '';
		$selectPotStat = '';
	}
	
	$reportBlock = array();

	###########################################################################
	#
	# get relevant Solutions from Leads
	#
	$sql = "
			SELECT DISTINCT
				ldcf.{$leadSolutionsField} AS solutions
			FROM 
				vtiger_leadscf as ldcf;
			";
//print $sql;		
	$result = $adb->pquery($sql, array());			
	if($result)
	{
		while ($leadRow = $adb->fetch_array($result))
		{
			$aNewSolutions = explode(' |##| ',$leadRow['solutions']);
			foreach($aNewSolutions as $id => $solution)
			{
				$aSolutions[$solution] ++;
			}
		}
	} else {
		echo "no solutions found" ;
	}
	ksort($aSolutions);
//  	print_r($aSolutions);
	
	###########################################################################
	#
	# get relevant Products from leads
	#
	$sql = "
			SELECT DISTINCT
				ldcf.{$leadProductsField} AS products
			FROM 
				vtiger_leadscf as ldcf;
			";		
	$result = $adb->pquery($sql, array());

	if($result)
	{
		while ($leadRow = $adb->fetch_array($result))
		{
			$aNewProducts = explode(' |##| ',$leadRow['products']);
			foreach($aNewProducts as $id => $products)
			{
				$aProducts[$products] ++;
			}
		}
	} else {
		echo "no products found" ;
	}
	ksort($aProducts);

	###########################################################################
	#
	# get relevant Users from leads
	#
	$sql = "
			SELECT
				user_name,
				id
			FROM 
				vtiger_users
			WHERE
				status = 'Active';
			";		
	$result = $adb->pquery($sql, array());

	if($result)
	{
		while ($leadRow = $adb->fetch_array($result))
		{
			$aUsers[$leadRow['user_name']] = $leadRow['id'];
		}
	} else {
		echo "no users found" ;
	}
	ksort($aUsers);

	###########################################################################
	#
	# get relevant LEADS
	#
	
	$sql = "
			SELECT 
				ld.leadid,
				ld.lead_no,
				ld.company,
				ld.leadsource,
				ld.leadstatus,
				ld.campaign,
				ld.converted,
				ldcf.{$leadBudgetField} AS budgetproject,
				ldcf.{$leadBudgetYearlyField } AS budgetyearly,
				ldcf.{$leadChanceField} AS chance,
				ldcf.{$leadProductsField} AS products,
				ldcf.{$leadInterestedField},
				ldcf.{$leadNextActionDateField},
				ldcf.{$leadSolutionsField} AS solutions,
				la.city,
				u.user_name,
				ce.description
			FROM 
				vtiger_leaddetails as ld 
			LEFT JOIN
				vtiger_leadscf as ldcf
			ON
				ld.leadid = ldcf.leadid
			LEFT JOIN
				#  crmid, smcreatorid, smownerid, modifiedby, setype, description
				vtiger_crmentity as ce
			ON
				ld.leadid = ce.crmid
			LEFT JOIN 
				vtiger_leadaddress as la
			ON
				ld.leadid = la.leadaddressid
			LEFT JOIN 
				vtiger_users as u
			ON
				ce.smownerid = u.id
			WHERE 
				ce.deleted = 0 
				".$selectLeadUser."
				".$selectLeadSol."
				".$selectLeadProd."
				".$selectLeadStat."
				AND ld.converted != 1
				AND ld.leadstatus != 'converted'
			ORDER BY
				ldcf.{$leadNextActionDateField} ASC
			";
// 				AND ldcf.cf_596  < '".date("Y-m-d", strtotime("+1 months"))."'
// 				AND ld.leadstatus != 'Target'
//AND ld.leadstatus != 'converted'
/*
				ldcf.cf_540,
				ldcf.cf_586 AS req_users,
				ldcf.cf_587 AS req_interfaces,
				ldcf.cf_588 AS req_functions,
				ldcf.cf_589 AS req_goals,
				ldcf.cf_590 AS req_replacing,
				ldcf.cf_592 AS req_hosted,
				ldcf.cf_598 AS req_usage,
*/

	$result = $adb->pquery($sql, array());

	if($result)
	{

		// Leads found
		while ($leadRow = $adb->fetch_array($result))
		{

			// correct for reporting all leads having Converted=1 become Converted
			if ($leadRow['converted']) {
				$leadRow['leadstatus'] = 'Converted';
			}
				
			$leadRow['solutions'] = str_replace(' |##| ',',',$leadRow['solutions']);
			$leadRow['products'] = str_replace(' |##| ',',',$leadRow['products']);

			// preparing for reporting
			$leadByStatus[$leadRow['leadstatus']][] = $leadRow['leadid'];
			$leadInfo[$leadRow['leadid']] = $leadRow;

			if (isset($_GET['det']) && $_GET['det'] == 'yes')
			{
				$leadBlock = '';
				$leadBlock .= '<tr style="border:1px solid #efefef;">';
				$leadBlock .= '<td style="border:1px solid #efefef;vertical-align:top;">'.'<a href="'.$site_URL.'/index.php?action=DetailView&module=Leads&record='.$leadRow['leadid'].'&parenttab=My%20Home%20Page" target="_blank">'.$leadRow['lead_no'].'</a><br>'.$leadRow['user_name'].'</td>';
				$leadBlock .= '<td style="border:1px solid #efefef;vertical-align:top;"><strong>'.strtoupper($leadRow['leadstatus']).' - '.$leadRow['company'].'</strong> '.strtoupper($leadRow['city']).'<br>Interesse: '.$leadRow[$leadInterestedField].'</td>';
				$leadBlock .= '<td style="border:1px solid #efefef;vertical-align:top;">Oplossingen: '.$leadRow['solutions'].'<br>Producten: '.$leadRow['products'].'</td>';
				$leadBlock .= '<td style="border:1px solid #efefef;vertical-align:top;">'.$leadRow['leadsource'].'<br>'.$leadRow['campaign']. '</td>';
				$leadBlock .= '<td style="border:1px solid #efefef;vertical-align:top;"><strong>'. '&euro;'.$leadRow[$leadBudgetField].' x '.$leadRow[$leadChanceField].'% = &euro;'. ($leadRow[$leadBudgetField] * $leadRow[$leadChanceField] / 100).'</strong>'.' </td>';
				$leadBlock .= "</tr>";
	
				$leadBlock .= "<tr>";
				$leadBlock .= '<td style="border:0px solid black;">&nbsp;</td>';				
				$leadBlock .= '<td style="border:1px solid #efefef;vertical-align:top;" colspan="4"><em>'.$leadRow['description']. '<br><br></em></td>';
				$leadBlock .= "</tr>";
	
				$leadDetailsBlock .= $leadBlock;
			}		
		}
	
	} else {
		echo 'FAILED';
	}

	$matrix = array();

	foreach ((array)$leadByStatus as $status => $aInfo)
	{
		// $aInfo contains id's of all leads within this stage
		//print_r($aInfo); die();
		$combined = array();
		foreach ($aInfo as $id => $leadid)
		{

			// $leadInfo contains the raw info per lead (refered by leadid)
//			print '<pre>'; print_r($leadInfo[$leadid]); print '</pre>';

			$combined[$leadInfo[$leadid]['solutions']][$leadInfo[$leadid]['products']]['qty'] ++;
			$expected = ( (float)$leadInfo[$leadid]['budgetproject'] + ( 3 * (float)$leadInfo[$leadid]['budgetyearly'])) * (float)$leadInfo[$leadid]['chance'] / 100;
//			print $expected.'<hr>';
			$combined[$leadInfo[$leadid]['solutions']][$leadInfo[$leadid]['products']]['value'] += $expected;
		}
		

	
		switch ($status)
		{
			case 'Target':
			case 'Target e-mail':
			case 'Last Call':
			case 'Nieuw':
			case 'Recycled':
				$matrix['1.Target'][$status]['out'] = count($aInfo);
				$matrix['1.Target'][$status]['combined'] = $combined;
				//$matrix['1.Target'][$status]['expected'] = $expectedValue;
				break;

			case 'Demo-Proef-Download fup 1':
			case 'Demo-Proef-Download fup 2':
			case 'Demo-Proef-Download fup 3':
			case 'Demo/Proef/Download fup 1':
			case 'Demo/Proef/Download fup 2':
			case 'Demo/Proef/Download fup 3':
//				$matrix['2.Demo/Proef/Download'][$status]['direct'] = count($aInfo);
//				$matrix['2.Demo/Proef/Download'][$status]['combined'] = $combined;
//				//$matrix['2.Lead Kwalificeren'][$status]['expected'] = $expectedValue;
//				break;
			case 'Campagne opvolgen':
			case 'Voorstel/info sturen':
			case 'Voorstel/info opvolgen':
			case 'Informatie sturen':
			case 'Seminar ingeschreven':
				$matrix['2.Lead Kwalificeren'][$status]['direct'] = count($aInfo);
				$matrix['2.Lead Kwalificeren'][$status]['combined'] = $combined;
				//$matrix['2.Lead Kwalificeren'][$status]['expected'] = $expectedValue;
				break;

			case 'Warm houden':						
			case 'Warm houden met datum':
			case 'Coma':
				$matrix['1.Target'][$status]['out'] = count($aInfo);
				$matrix['1.Target'][$status]['combined'] = $combined;
				//$matrix['1.Target'][$status]['expected'] = $expectedValue;
				break;
		
			case 'Wacht op reactie':
			case 'Kwalificeren':
			case 'Na Seminar':
				$matrix['2.Lead Kwalificeren'][$status]['direct'] = count($aInfo);
				$matrix['2.Lead Kwalificeren'][$status]['combined'] = $combined;
				//$matrix['2.Lead Kwalificere'][$status]['expected'] = $expectedValue;
				break;
		
			case 'Gekwalificeerd':
			case 'Afspraak maken':
			case 'Afspraak ingepland':
				$matrix['3.Lead Gekwalificeerd'][$status]['direct'] = count($aInfo);
				$matrix['3.Lead Gekwalificeerd'][$status]['combined'] = $combined;
				//$matrix['3.Lead Gekwalificeerdt'][$status]['expected'] = $expectedValue;
				break;
		
		
			case 'Closed - na 2e contact':
			case 'Closed - na kwalificatie':
			case 'Closed - na 1e contact':
			case 'Closed - doorverwezen':
			case 'Closed - na deskresearch':
			case 'Closed - na Demo-Proef-Downl':
			case 'Closed - lost':
			case 'Dead':
				$matrix['2.Lead Kwalificeren'][$status]['out'] = count($aInfo);
//				$matrix['2.Lead Kwalificeren'][$status]['combined'] = $combined;
				//$matrix['2.Lead Kwalificeret'][$status]['expected'] = $expectedValue;
				break;
			case 'Converted':
				$matrix['3.Lead Gekwalificeerd'][$status]['direct'] = count($aInfo);
				$matrix['3.Lead Gekwalificeerd'][$status]['expected'] = $expectedValue;
//				//$matrix['3.Lead Gekwalificeerd'][$status]['combined'] = $combined;
				break;
	
			default:
				print "<li>unexpected LEA status $status</li>";
				$matrix['1.unknown.lead'][$status]['direct'] = count($aInfo);
				$matrix['1.unknown.lead'][$status]['combined'] = $combined;
				//$matrix['1.unknown.lead'][$status]['expected'] = $expectedValue;
		}



	}


	###########################################################################
	#
	# get relevant POTENTIALS
	# query the vtiger_tables and get data
	#
/*
				pocf.cf_601 AS expected_value,
				pocf.cf_603 AS action_date,				
				pocf.cf_612 AS req_interfaces,
				pocf.cf_609 AS req_functions,
				pocf.cf_613 AS req_goals,
				pocf.cf_610 AS req_replacing,
				pocf.cf_617 AS req_hosted,
				pocf.cf_615 AS req_usage,
				pocf.cf_608 AS req_users,
*/
	$sql = "
			SELECT 
				po.potentialid,
				po.potential_no,
				po.potentialname,
				a.accountname,
				ce.description,
				po.leadsource,
				po.sales_stage,
				po.campaignid,
				po.amount AS budgetproject,
				pocf.{$potentialBudgetYearlyField} AS budgetyearly,
				po.probability AS chance,
				pocf.{$potentialProductsField} AS products,
				pocf.{$potentialSolutionsField} AS solutions,
				u.user_name
			FROM 
				vtiger_potential as po 
			LEFT JOIN
				vtiger_potentialscf as pocf
			ON
				po.potentialid = pocf.potentialid
			LEFT JOIN
				vtiger_crmentity as ce
			ON
				po.potentialid = ce.crmid
			LEFT JOIN 
				vtiger_account as a
			ON
				po.related_to = a.accountid
			LEFT JOIN 
				vtiger_users as u
			ON
				ce.smownerid = u.id
			WHERE 
				ce.deleted = 0
				".$selectPotUser."
				".$selectPotSol."
				".$selectPotProd."
				".$selectPotStat."
			ORDER BY
				pocf.{$potentialNextActionDateField} ASC
			";
//print $sql;
	$result = $adb->pquery($sql, array());

	if($result)
	{
		// Potentials found
		while ($potRow = $adb->fetch_array($result))
		{
			$potRow['solutions'] = str_replace(' |##| ',',',$potRow['solutions']);
			$potRow['products'] = str_replace(' |##| ',',',$potRow['products']);

			// preparing for reporting
			$potentialByStatus[$potRow['sales_stage']][] = $potRow['potentialid'];
			$potInfo[$potRow['potentialid']] = $potRow;

			if (isset($_GET['det']) && $_GET['det'] == 'yes')
			{
				$potentialBlock = '';

				$potentialBlock .= '<tr style="border:1px solid black;">';
				$potentialBlock .= '<td style="border:1px solid #efefef;vertical-align:top;">'.'<a href="'.$site_URL.'/index.php?action=DetailView&module=Potentials&record='.$potRow['potentialid'].'&parenttab=My%20Home%20Page" target="_blank">'.$potRow['potential_no'].'</a><br>'.$potRow['user_name'].'</td>';
//				$potentialBlock .= '<td style="border:1px solid black;vertical-align:top;">'.$potRow['potential_no']. '<br>'.$potRow['user_name'].'</td>';
				$potentialBlock .= '<td style="border:1px solid black;vertical-align:top;"><strong>'.strtoupper($potRow['sales_stage']).' - '.$potRow['accountname'].'</strong><br>'.$potRow['potentialname']. '</td>';
				$potentialBlock .= '<td style="border:1px solid black;vertical-align:top;">'.$contactBlock. '</td>';
				$potentialBlock .= '<td style="border:1px solid black;vertical-align:top;">'.$potRow['leadsource'].'<br>'.$potRow['campaign']. '</td>';
				$potentialBlock .= '<td style="border:1px solid black;vertical-align:top;"><strong>'. '&euro;'.(int)$potRow['amount'].' x '. (int)$potRow['probability'].'% = &euro;'. (int)($potRow['amount'] * $potRow['probability'] / 100).'</strong><br>'.$potRow[$leadProductsField].' - '.$potRow['cf_540'].'<br>'.$potRow['cf_538'] . '</td>';
				$potentialBlock .= "</tr>";

				$potentialBlock .= "<tr>";
				$potentialBlock .= '<td style="border:0px solid black;">&nbsp;</td>';				
				$potentialBlock .= '<td style="border:1px solid black;vertical-align:top;" colspan="4"><em>'.$potRow['description']. '</em></td>';
				$potentialBlock .= "</tr>";
	
				$potentialDetailsBlock .= $potentialBlock;
			}		
		}
	} else {
		echo 'FAILED';
	}

	foreach ((array)$potentialByStatus as $status => $aInfo)
	{
	
		// $aInfo contains id's of all leads within this stage
		// print_r($aInfo); die();
		// $leadInfo contains the raw info per lead (refered by leadid)
		// print_r($aleadInfo); die();
		$combined = array();

		foreach ($aInfo as $id => $potId)
		{
			$combined[$potInfo[$potId]['solutions']][$potInfo[$potId]['products']]['qty'] ++;
//			print '<pre>'; print_r($potInfo[$potId]); print '</pre>';
			$expected = ( (float)$potInfo[$potId]['budgetproject'] + ( 3 * (float)$potInfo[$potId]['budgetyearly'])) * (float)$potInfo[$potId]['chance'] / 100;
//			print $expected.'<hr>';
			$combined[$potInfo[$potId]['solutions']][$potInfo[$potId]['products']]['value'] += $expected;
		}

		switch ($status)
		{

			case 'Behoeftenonderzoek':
			case 'Needs Analysis':
				$matrix['3.Potentie Onderzoeken'][$status]['in'] = count($aInfo);
				$matrix['3.Potentie Onderzoeken'][$status]['combined'] = $combined;
				break;
		
			case 'Kwalificatie':
			case 'Qualification':
				$matrix['3.Potentie Onderzoeken'][$status]['direct'] = count($aInfo);
				$matrix['3.Potentie Onderzoeken'][$status]['combined'] = $combined;
				break;
				
			case 'Coma':
				$matrix['3.Potentie Onderzoeken'][$status]['out'] = count($aInfo);
				$matrix['3.Potentie Onderzoeken'][$status]['combined'] = $combined;
				break;

			case 'Offerte onderhandeling':
			case 'Offerte verzonden':
			case 'Offerte maken':
			case 'Proposal/Price Quote':
			case 'Negotiation/Review':
				$matrix['4.Potentie Offerte'][$status]['direct'] = count($aInfo);
				$matrix['4.Potentie Offerte'][$status]['combined'] = $combined;
				break;

			case 'Gesloten Verloren':
			case 'Gesloten door Vicus':
			case 'Closed Lost':
				$matrix['4.Potentie Offerte'][$status]['out'] = count($aInfo);
				break;
				
			case 'Gesloten Gewonnen':
			case 'Closed Won':
				$matrix['5.Contract'][$status]['direct'] = count($aInfo);
				$matrix['5.Contract'][$status]['combined'] = $combined;
				break;

			case 'Delivered':
				$matrix['6.Beheer'][$status]['direct'] = count($aInfo);
				$matrix['6.Beheer'][$status]['combined'] = $combined;
				break;
	
			default:
				print "<li>unexpected POT status $status</li>";
				$matrix['3.Potentie unknown.pot'][$status]['direct'] = count($aInfo);
				$matrix['3.Potentie unknown.pot'][$status]['combined'] = $combined;
		}
	}

	###########################################################################
	#
	# Creating the Output
	#

ksort($matrix);
//print_r($matrix);

echo '<table class="outer_table">';
	echo "<tr>";
	echo '<th class="stage" colspan="2">Vicus CRM<br />Vertrouwelijk</th><th class="stage" colspan="4">'.'<ul>'.$msg.'</ul>'.'</th>';
	echo "</tr>";
	echo "<tr>";
	echo '<th class="stage" colspan="6">Links klik om selectie te tonen)</th>';
	echo "</tr>";
	echo "<tr>";
	echo '<td colspan=6>Solutions: ';
		foreach($aSolutions as $solution => $qty)
		{
			echo '<a href="salesfunnel.php?sol='.$solution.'">'."$solution".'</a> | '; //  ($qty)
		}
	echo '</td>';
	echo "</tr>";

	echo "<tr>";
	echo '<td colspan=6>Producten: ';
		foreach($aProducts as $product => $qty)
		{
			echo '<a href="salesfunnel.php?prod='.$product.'">'."$product".'</a> | ';
		}
	echo '</td>';
	echo "</tr>";
	
	echo "<tr>";
	echo '<td colspan=6>CRM gebruikers: ';
		foreach($aUsers as $user => $uid)
		{
			echo '<a href="salesfunnel.php?user='.$uid.'">'."$user".'</a> | ';
		}
	echo '</td>';
	echo "</tr>";
	echo "<tr>";
	echo '<th class="stage">Stage</th><th class="stage">Status</th><th class="stage">Solution/Product</th><th class="qty">Direct</th><th class="qty">Indirect</th><th class="qty">Buiten</th>';
	echo "</tr>";

foreach ($matrix as $stage => $aStages)
{
	echo '<tr class="outer_row">';
	$rows = count($aStages) + 1;
	echo '<th class="status" rowspan="'.$rows.'">'.$stage.'</th>';
	foreach ($aStages as $status => $aInfo)
	{
		$combinedTable = '';
		if (is_array($aInfo['combined']))
		{ 
			$combinedTable = '<table class="inner_table">';
			ksort($aInfo['combined']);
			foreach($aInfo['combined'] as $combiSol => $aCombiSolutions)
			{
				$combinedTable .= '<tr class="inner_row">';
				$rows2 = count($aCombiSolutions) + 1;
				$combinedTable .= '<th class="sol" rowspan="'.$rows2.'">'. $combiSol.'</th>';
//				$combinedTable .= '<th class="inner_sol">Product</th><th class="inner_sol">qty</th><th class="inner_sol">&euro;</th>';
				ksort($aCombiSolutions);
				foreach ($aCombiSolutions as $combiProd => $aCombiProducts)
				{
					$combinedTable .= '<tr class="inner_row">';
					$link = "?prod=$combiProd&sol=$combiSol&stat=$status&det=yes";
					if (isset($_GET['user'])) $link .= "&user={$_GET['user']}";
					$combinedTable .= '<td class="inner_label"><a href="salesfunnel.php'.$link.'">'. $combiProd.'</a></td>';
					$combinedTable .= '<td class="inner_qty">'. $aCombiProducts['qty'].'</td>';
					$combinedTable .= '<td class="inner_qty">&euro;'. $aCombiProducts['value'].'</td>';

	//				print_r($aCombiProducts);
					$combinedTable .= "</tr>";
				}
				$combinedTable .= '</tr>';
			}
			$combinedTable .= '</table>';
		}
			
		echo "<tr>";
		echo '<th class="status">'.$status.'</th>';
		echo '<td class="status">'.$combinedTable.'</td>';
//		echo '<td class="qty">'; print_r($aInfo['expected']); echo '</td>';
		echo '<td class="qty">'.$aInfo['direct'].'</td>';
		echo '<td class="qty">'.$aInfo['indirect'].'</td>';
		echo '<td class="qty">'.$aInfo['out'].'</td>';
		echo "</tr>";
	}
	echo "</tr>";
}
echo '</table>';

if (isset($_GET['det']) && $_GET['det'] == 'yes')
{
	echo '<table class="outer_table">';
	echo "<tr>";
	echo '<th class="stage" colspan=8>Detailinformatie van selectie</th>';
	echo "</tr>";
	echo $leadDetailsBlock;
	echo $potentialDetailsBlock;
	echo "</table>";
}




?>