<?php
class Json extends DB {
    
    private $dbConnection,
        $accessKey,
        $accessUrl,
        $arrName = [];

    public function __construct()
    {
        $this->dbConnection = DB::getInstance();
        $this->accessUrl    = Config::get('siteConfig/siteUrl');
        $this->accessKey    = file_get_contents($this->accessUrl . '?privateKey&token=' . $this->getUrl());
    }

    private function getJson()
    {
        $result = file_get_contents($this->accessUrl . '?getData&token=' . $this->getUrl());
        return json_decode($result, true);
    }

    private function getUsers()
    {
        $getResult = $this->dbConnection->query("SELECT * FROM vtiger_users WHERE status = 'Active'");
        $this->inArr['maxUsers'] = $getResult->count();
    }

    private function getVersion()
    {
        $getResult = $this->dbConnection->query("SELECT * FROM vtiger_version");
        foreach($getResult->results() as $row){
            $this->inArr['version'] = $row->current_version;
        }
    }

    private function getModules()
    {
        $getModules = $this->dbConnection->query("SELECT * FROM vtiger_tab WHERE name NOT IN('".implode("','",$this->arrName)."')");
        foreach($getModules->results() as $key) {
            $this->inArr[] = array('module' => $key->name, 'active' => $key->presence);
        }
    }

    private function checkSerial()
    {
        foreach($this->getJson() as $name => $value) {
            $results = $this->dbConnection->query("SELECT * FROM ".$value['TABLE']."");
            if($results->error() == true || !array_key_exists(0, $this->dbConnection->results()) || !is_object($this->dbConnection->results()[0])) {
                continue;
            }
            $this->inArr[] = array('module' => $name, 'serial' => $this->dbConnection->results()[0]->$value['COLUMN'], 'active' => '0');
            array_push($this->arrName, $name);
        }
    }

    public function getUrl()
    {
        $this->date = hash("md5", date("D-m-Y i"));
        return $this->date;
    }

    public function getHash($string)
    {
	    $result = '';
        for($i=0; $i<strlen($string); $i++) {
            $char = substr($string, $i, 1);
            $keychar = substr($this->accessKey, ($i % strlen($this->accessKey))-1, 1);
            $char = chr(ord($char)+ord($keychar));

            $test[$char]= ord($char)+ord($keychar);
            $result.=$char;
        }
        return urlencode(base64_encode($result)); 
    }

    public function formatBytes($bytes)
    {
 	$mb_size = $bytes / 1048576;
        return rtrim(round($mb_size), ",");
    }

    public function folderSize ($dir)
    {

        $size = 0;
        foreach (glob(rtrim($dir, '/').'/*', GLOB_NOSORT) as $each) {
            $size += is_file($each) ? filesize($each) : $this->folderSize($each);
        }
	return $size;

    }

    public function getSize(){
        $this->inArr['directorySize'] = $this->formatBytes($this->folderSize($_SERVER['DOCUMENT_ROOT'] . '/'));
    }

    public function getSerials()
    {
        $this->getUsers();
        $this->getVersion();
        //$this->getSize();
        $this->checkSerial();
        $this->getModules();

        return $this->inArr;
    }
}
?>