<?
/** 
 * Importeer salesfeed csv
 *
 * stap 1:
 * - exporteer csv bestand uit salesfeed
 * stap 2
 * - plaats op server in de map data
 * stap 3:
 * - run dit script
 *
 * Werking:
 * Controleert of het salesfeed record in crm staat
 * - als account
 *   - aanvullen missende data
 * - als lead
 *   - aanvullen missende data
 * - mist in crm
 *   - opnemen in rapport
 */
 
chdir(dirname(__FILE__) . '/../');
require_once('config.php');
require_once('config_veb.php');
require_once('include/utils/utils.php');

// get line from csv file
$handle = fopen($root_directory . "veb/data/salesfeed-export.csv", "r");

$import = new import();

if ($handle === FALSE)
{
    die('cannot open the file');
} else
{
    $names = array_flip(fgetcsv($handle, 1000, ";"));

// print_r($names);

    while (($data = fgetcsv($handle, 1000, ";")) !== FALSE) 
    {

        $num = count($data);
        $crmData = array();
        $mapping = array();
        $newData = array();
        $crmid = '';

        if ($data[0] == '') {
          $import->log('dataregel is leeg', 'error');
          continue;
        }

        // is it a lead or an account?
        $crmData = $import->findRecordByCoC($data[0]);
                
//        $import->log('module: '. $import->moduleName);

        if ($crmData === false) {
          // add to crm manually after investigation
           $mapping = $import->_getLeaMapping();
        } else
        {
          $mapping = $import->getMapping();
        }

//        $import->log('mapping: '. print_r($mapping, true));

//    		print_r($data);

        foreach ($names as $sfFieldName => $id)
        {
          if ($mapping[$sfFieldName]) 
          {
            $newData[$mapping[$sfFieldName]] = $data[$id];
          }
        }

        if ($crmData === false) {
          // add to crm manually after investigation
          $newData['c_lead_source_bg'] = 'import salesfeed csv'.date("YmdHis");
          $newData['wv_sforgid'] = $import->formatDetailpagina($data[$mapping['detailpagina']]);
          $notFound[] = $data;
          continue;
        }

//    		$import->log('sf data - '.print_r($data,true));
//    		$import->log('crmdata - '.print_r($crmData,true));
        
        // only fill fields that are empty in crm
        foreach ($newData as $label => $value)
        {
          if ($crmData[$label] != '' OR $newData[$label] == '') {
   //         $import->log("unset $label");
            unset($newData[$label]);
          } 
          else {
            $newData[$label] = str_ireplace("\'","'",$value);
            print "<li>{$newData[$label]} => new value=$value";
          }
        }

    		$newData = $import->prepareData($newData);
    		$import->log('newData - '.print_r($newData,true));
    		$import->update($newData);
    }
}

echo "<h1>Niet gevonden in crm</h1><br><br><hr>";

$line = array();
foreach ($names as $id => $name)
{
    $line[] = $id;
}

echo count($line)." regels";

echo "<h1>Wel gevonden in crm</h1><br>";

//echo implode (', ',$line)."<br>";

$file = fopen($root_directory . "veb/data/salesfeed-not-imported-".date("YmdHis").".csv","w");
fputcsv($file,$line);
  
foreach ($notFound as $id => $record)
{
  $line = array();
  foreach ($record as $field => $value)
  {
    $line[] = $value;
  }
  echo implode (',',$line)."<br>";
  fputcsv($file,$line);  
}
fclose($file);

class import
{

  var $warnings = array();
  var $moduleName = '';
  var $batchId = '';

  function __construct()
  {
    $this->batchId = date("YmdHmi"); 
  }

  function findRecordByCoC($coc)
  {
    $this->moduleName = '';
  
    $record = $this->_findAccountByCoC($coc);
    if ($record == false)
    {
      $record = $this->_findLeadByCoC($coc);
    }

    return $record;
  }
 
  function prepareData($newData)
  {
      		
    foreach($newData as $label => $value)
    {
      switch ($label)
      {
        case 'phone': $newData[$label] = $this->formatPhone($value); break;
        case 'noofemployees': $newData[$label] = $this->formatEmployees($value); break;
        case 'wv_sfbranche': $newData[$label] = $this->formatString($value); break;
        default: $newData[$label] = $this->formatQuotes($value); break;
      }
    }
  
    return $newData;
  }
  
  function formatQuotes($vale)
  {
    $value = addslashes($value); // escape ' and "
    return $value;
  }

  function formatPhone($value)
  {
    $value = str_replace(' ','',$value); // remove spaces
    return $value;
  }

  function formatEmployees($value)
  {
    $value = str_replace('t/m','-',$value); // remove spaces
    return $value;
  } 

  function formatString($value)
  {
    $value = htmlspecialchars($value, ENT_QUOTES); // remove spaces
    return $value;
  } 
  
  function formatDetailpagina($value)
  {
    $value = str_replace("https://crmv2.salesfeed.com//bedrijf/",'',$value); // remove spaces
    return $value;
  }    
  
  
  function update($newData)
  {
      
    if (count($newData) == 0) return; // nothing to do

    switch (strtolower($this->moduleName))
    {
      case 'leads': return $this->_updateLead($newData); break;
      case 'accounts': return $this->_updateAccount($newData); break;
      default:
        $this->log("wrong module {$this->moduleName}", 'error');
        return false;
    }
  }
  
  // update lead
  // fill c_lead_email2 if email in email is different
  // @todo  ?custom fields
  function _updateLead($newData)
  {
    global $adb;
    $set  = array();
    $set2 = array();
    $newData2 = array();
    $set3 = array();
    $newData3 = array();
    $logText = array();
    
    if (isset($newData['website'])) {
      $newData2['website'] = $newData['website'];
      unset($newData['website']);
    } 
    if (isset($newData['phone'])) {
      $newData3['phone'] = $newData['phone'];
      unset($newData['phone']);    
    }
    
    foreach ($newData as $label => $value)
    {
      $set[] = "$label = '$value'";
      $logText[] = "$label = '$value'";
    }

    if (count($set) > 0) {
      $sql = "UPDATE vtiger_leaddetails 
              SET ".implode(', ',$set)."
              WHERE leadid = $this->crmid;";
  
// var_dump($sql);die(); 

      $result = $adb->pquery($sql, array());
  
      if (!$result) {
        $this->log($adb->database->ErrorMsg(),'error');
      }
      
//      $this->log($sql);
    }
      
    // website is inthe subdeatls vtiger_leadsubdetails

    foreach ($newData2 as $label => $value)
    {
      $set2[] = "$label = '$value'";
      $logText[] = "$label = '$value'";
    }

    if (count($set2) > 0) {
      $sql = "UPDATE vtiger_leadsubdetails
              SET ".implode(', ',$set2)."
              WHERE leadsubscriptionid = $this->crmid;";

// var_dump($sql);die(); 

      $result = $adb->pquery($sql, array());
  
      if (!$result) {
        $this->log($adb->database->ErrorMsg(),'error');
      }
  
//      $this->log($sql);
    }
    
    // vtiger_leadaddress
    foreach ($newData3 as $label => $value)
    {
      $set3[] = "$label = '$value'";
      $logText[] = "$label = '$value'";
    }

    if (count($set3) > 0) {
      $sql = "UPDATE vtiger_leadaddress
              SET ".implode(', ',$set3)."
              WHERE leadaddressid = $this->crmid;";
  
// var_dump($sql);die(); 

      $result = $adb->pquery($sql, array());
  
      if (!$result) {
        $this->log($adb->database->ErrorMsg(),'error');
      }
  
//      $this->log($sql);
    }

    $logtext = implode(', ',$logText);
    $this->log("Updated Lead {$this->crmid}: {$logtext}");
    
  }


  // @todo  ?custom fields
  function _updateAccount($newData)
  {
    global $adb;
    $set  = array();
    $set2 = array();
    $newData2 = array();
    $set3 = array();
    $newData3 = array();
    $logText = array();
    
    if (isset($newData['ship_city'])) {
      $newData2['ship_city'] = $newData['ship_city'];
      unset($newData['ship_city']);
    } 
    if (isset($newData['ship_code'])) {
      $newData2['ship_code'] = $newData['ship_code'];
      unset($newData['ship_code']);    
    }
    if (isset($newData['ship_street'])) {
      $newData2['ship_street'] = $newData['ship_street'];
      unset($newData['ship_street']);    
    }

    // linkedin
    // staat nu in stanbdaard tabel : c_linkedin_account
    /*
    if (isset($newData['cf_1679'])) {
      $newData3['cf_1679'] = $newData['cf_1679'];
      unset($newData['cf_1679']);    
    }
    */

    foreach ($newData as $label => $value)
    {
      $set[] = "$label = '$value'";
      $logText[] = "$label = '$value'";
    }

    if (count($set) > 0) {    
      $sql = "UPDATE vtiger_account
              SET ".implode(', ',$set)."
              WHERE `accountid` = $this->crmid;";
  
// var_dump($sql);die(); 

      $result = $adb->pquery($sql, array());
  
      if (!$result) {
        $this->log($adb->database->ErrorMsg(),'error');
      }
              
///      $this->log($sql);
    }

    // vtiger_accountshipads
    foreach ($newData2 as $label => $value)
    {
      $set2[] = "$label = '$value'";
      $logText[] = "$label = '$value'";
    }
    
    if (count($set2) > 0) {    
      $sql = "UPDATE vtiger_accountshipads
              SET ".implode(', ',$set2)."
              WHERE accountaddressid = $this->crmid;";
  
// var_dump($sql);die(); 

      $result = $adb->pquery($sql, array());
  
      if (!$result) {
        $this->log($adb->database->ErrorMsg(),'error');
      }
              
//      $this->log($sql);
    }

    // vtiger_accountscf
    foreach ($newData3 as $label => $value)
    {
      $set3[] = "$label = '$value'";
      $logText[] = "$label = '$value'";
    }
    
    if (count($set3) > 0) {
      $sql = "UPDATE vtiger_accountscf
              SET ".implode(', ',$set3)."
              WHERE accountid = $this->crmid;";
  
//var_dump($sql);die(); 

      $result = $adb->pquery($sql, array());
  
      if (!$result) {
        $this->log($adb->database->ErrorMsg(),'error');
      }
              
//      $this->log($sql);    
    }    

    $logtext = implode(', ',$logText);
    $this->log("Updated Account {$this->crmid}: {$logtext}");
    
  }

  function save()
  {
  }


  // try to find in accounts  
  function _findAccountByCoC($coc)
  {

// var_dump($coc);

    global $adb;
    $sql = "SELECT *
            FROM vtiger_account as t
            INNER JOIN vtiger_accountshipads AS sa ON t.accountid = sa.accountaddressid
            INNER JOIN vtiger_accountscf AS cf ON t.accountid = cf.accountid
            INNER JOIN vtiger_crmentity AS ce
            ON t.accountid = ce.crmid
            WHERE ce.deleted=0 AND (c_coc_number = '{$coc}' OR wv_sfcocnumber = '{$coc}');";

//    $this->log($sql);
    
// var_dump($sql);

    $result = $adb->pquery($sql, array());

    if (!$result) {
      $this->log($adb->database->ErrorMsg(),'error');
    }

    if (!$result || $result->_numOfRows == 0)
    {
      $this->moduleName = 'acc not found';
//      $this->log("KvK {$coc} - niet als account in crm");
      return false;
    } elseif ($result->_numOfRows == 1)
    {
      $this->moduleName = $result->fields['setype'];
      $this->log("KvK {$coc} - gevonden als account {$result->fields['accountname']} in crm");
      $this->crmid = $result->fields['accountid'];
      return $result->fields;
    } elseif ($result->_numOfRows >= 1)
    {
    
      $this->moduleName = $result->fields['setype'];
      $this->log("KvK {$coc} - meermalig ({$result->_numOfRows} x) gevonden als account {$result->fields['accountname']} in crm, neem de eerste", 'warning');
      $this->crmid = $result->fields['accountid'];
      return $result->fields;
    }
  }
  

  // try to find in Leads
  function _findLeadByCoC($coc)
  {
    global $adb;
    $sql = "SELECT * 
            FROM vtiger_leaddetails as t
            INNER JOIN vtiger_leadaddress AS la ON t.leadid = la.leadaddressid
            INNER JOIN vtiger_leadsubdetails AS ls ON t.leadid = ls.leadsubscriptionid
            INNER JOIN vtiger_crmentity AS ce ON t.leadid = ce.crmid
            WHERE ce.deleted=0 AND (c_coc_number = '{$coc}' OR wv_sfcocnumber = '{$coc}');";

//    $this->log($sql);
    
    $result = $adb->pquery($sql, array());

    if (!$result) {
      $this->log($adb->database->ErrorMsg(),'error');
    }

    if (!$result || $result->_numOfRows == 0)
    {
      $this->moduleName = 'lea not found';
//      $this->log("KvK {$coc} - niet als Lead in crm");
      $this->crmid = false;
      return false;
    } elseif ($result->_numOfRows == 1)
    {
      $this->moduleName = $result->fields['setype'];
      $this->log("KvK {$coc} - gevonden als Lead {$result->fields['company']} in crm");
      $this->crmid = $result->fields['leadid'];
      return $result->fields;
    } elseif ($result->_numOfRows >= 1)
    {
      $this->moduleName = $result->fields['setype'];
      $this->log("KvK {$coc} - meermalig ({$result->_numOfRows} x) gevonden als Lead {$result->fields['company']} in crm, neem de eerste", 'warning');
      $this->crmid = $result->fields['leadid'];
      return $result->fields;
    }
  }
  
  function log($msg, $status = 'log')
  {
    if ($status != 'log') {
      $this->warnings[] = $msg;
      print "<li>$status - $msg";
    }

    file_put_contents("logs/import_salesfeed-" . $this->batchId . ".log",date("YmdHis")." - ".$msg."\n", FILE_APPEND );
  }
  
  function getMapping()
  {
    switch (strtolower($this->moduleName))
    {
      case 'leads': return $this->_getLeaMapping(); break;
      case 'accounts': return $this->_getAccMapping(); break;
      default:
        $this->log("wrong module {$this->moduleName}", 'error');
        return false;
    }
  
  }
  
  function _getLeaMapping()
  {
    // salesfeed -> crm
    $mapping = Array (
      'kvknummer' => 'c_coc_number',  // ook wva !! wv_sfcocnumber
      'naam' => 'company',
      'adres' => false, // 'lane',
      'postcode' => false, // 'code',
      'plaats' => false, // 'city',
      'website' => 'website',
      'telefoon' => 'phone',
      'emailadres' => 'email',
      'linkedin' => 'c_lead_linkedin',
      'kredietscore' => false,
      'SBI' => 'wv_sfsbi',
      'sbiomschrijving' => 'wv_sfbranche',
      'fte' => 'noofemployees',
      'eerste bezoek' => false,
      'laatste bezoek' => false,
      'numipaddresses' => false,
      'numvisitors' => false,
      'numpageviews' => false,
      'numsessions' => false,
      'totaltime' => false,
      'segmenten' => false,
      'tags' => false,
      'notities' => false,
      'detailpagina' => false
    );
    return $mapping;
  }
  
  function _getAccMapping()
  {
    // salesfeed -> crm
    $mapping = Array (
      'kvknummer' => 'c_coc_number',  // ook wva !! wv_sfcocnumber
      'naam' => 'accountname',
      'adres' => false, // 'ship_street',
      'postcode' => false, // 'ship_code',
      'plaats' => false, // 'ship_city',
      'website' => 'website',
      'telefoon' => 'phone',
      'emailadres' => 'email1',
//      'linkedin' => 'cf_1679',
      'linkedin' => 'c_linkedin_account',
      'kredietscore' => false,
      'SBI' => 'wv_sfsbi',
      'sbiomschrijving' => 'wv_sfbranche',
      'fte' => false,
      'eerste bezoek' => false,
      'laatste bezoek' => false,
      'numipaddresses' => false,
      'numvisitors' => false,
      'numpageviews' => false,
      'numsessions' => false,
      'totaltime' => false,
      'segmenten' => false,
      'tags' => false,
      'notities' => false,
      'detailpagina' => false
    );

    return $mapping;
  }
}
