<?php

/* * *******************************************************************************
 * Script imports a csv list wit revenues into the vtiger database Accounts module
 * 
 * @copyright	Vicus eBusiness Solutions
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 * ****************************************************************************** */

chdir(dirname(__FILE__) . '/../');
require_once('config.php');
require_once('config_veb.php');
require_once('include/utils/utils.php');
//require_once('include/languages/nl_nl.lang.php');
global $app_strings;

$aCriticalWarnings = array();

file_put_contents("logs/import-revenues-" . date("Y") . ".log", "\nstarted on " . date("d-m-Y") . "\n", FILE_APPEND);

$kingDebtorIdField = 'v_d_naw_nummer';
$totalField = 'c_total_revenue';
$yearFields = array(
    '2005' => 'c_revenue_2005',
    '2006' => 'c_revenue_2006',
    '2007' => 'c_revenue_2007',
    '2008' => 'c_revenue_2008',
    '2009' => 'c_revenue_2009',
    '2010' => 'c_revenue_2010',
    '2011' => 'c_revenue_2011',
    '2012' => 'c_revenue_2012',
    '2013' => 'c_revenue_2013',
    '2014' => 'c_revenue_2014',
    '2015' => 'c_revenue_2015',
    '2016' => 'cf_1286',
    '2017' => 'cf_1748',
    '2018' => 'cf_1946',
    '2019' => 'cf_2455',
    '2020' => 'cf_2653',
    '2021' => 'cf_2743',
    '2022' => 'cf_2751',
    '2023' => 'cf_2898',
    '2024' => 'cf_2907',
    '2025' => 'cf_2939'
);


// get line from csv file

//$handle = fopen($root_directory . "veb/data/FactBetalingenDeb2023.csv", "r");
//$separator = ',';

$handle = fopen($root_directory . "veb/data/vicus_facturen_export_king.csv", "r");
$separator = ';';



if ($handle === FALSE)
{
    die('cannot open the file');
} else
{
    $names = fgetcsv($handle, 1000, $separator);

//	print_r($names);

    while (($data = fgetcsv($handle, 1000, $separator)) !== FALSE) 
    {
        $num = count($data);
//    		print_r($data);
        // add to array
        // expected errors
        // - sql-id does not exist in CRM -> warning
        // - totaal amount = 0 (or no amount) -> warning 
        // - due

        foreach ($data as $id => $content)
        {
          $data[$names[$id]] = $content;
          unset($data[$id]);
        }

//    		print_r($data);

        $debtorId = $data['Rekeningnummer'];
        $customerName = $data['Rekeningnaam'];
        $dagboekCode = $data['Dagboekcode'];

        if ($debtorId == '' OR $dagboekCode != 'Verkoop') {
          continue;
        } 

        // looping all customers to see if they exist in crm
        // only proceed after all id's are there
        // otherwise show info to improve it (normally add customer or id in the crm)

        $sql = "SELECT * FROM vtiger_account WHERE {$kingDebtorIdField} = {$debtorId}; ";

//	file_put_contents("logs/import-revenues-" . date("Y") . ".log", "\n{$sql}\n", FILE_APPEND);

//echo "<li>".$sql;
        $result1 = $adb->pquery($sql, array());

        $aCompanies['import-crm'][$customerName][$result1->fields['accountname']] ++;
        $aCompanies['crm-import'][$result1->fields['accountname']][$customerName] ++;

        if (!$result1 || $result1->_numOfRows == 0)
        {
		$msg = "{$kingDebtorIdField} = {$debtorId} -> {$customerName} - FAIL customer not found in crm ";
		$aCriticalWarnings[$debtorId]['notfound'][] = $msg;
		print "<li>$msg";
		$msg .= print_r($result1,true);
		file_put_contents("logs/import-revenues-" . date("Y") . ".log", "\n{$msg}\n", FILE_APPEND);
		
		$customerCrmId = 'x';
        } elseif ($result1->_numOfRows == 1)
        {
      		$msg = "{$debtorId} {$aRevenues['customer'][$debtorId]['customer-name']} - SUCCES customer found in crm";
            $aRevenues['customer'][$debtorId]['customer-crmid'] = $result1->fields['accountid'];
            $customerCrmId = $result1->fields['accountid'];
        } elseif ($result1->_numOfRows >= 1)
        {
            $msg = "{$debtorId} {$customerName} - FAILS duplicate customerrecords found in CRM";
            $aCriticalWarnings[$debtorId]['duplicate'][] = $msg;
            print "<li>$msg";
            $customerCrmId = 'x';
        }

        $invoiceDate = $data['Boekdatum']; // 3
        $year = substr($invoiceDate, 6, 4);
        $invoiceNo = $data['FactuurReferentieNummer']; // 10
        
        $Boekzijde = $data['Boekzijde']; // 15
        if ($Boekzijde == 0) 
        {
          // Invoice = 0
          $invoiceAmountInclVat = str_replace(',', '.', $data['BedragInBasisValuta']); // 18 we dont use , for floats ! // BedragInBasisValuta
          $invoiceAmountVat = str_replace(',', '.', $data['HulpRekeningBedragInBasisValuta']); // 26 we dont use , for floats ! // BedragInBasisValuta
          $invoiceAmountExlVat = $invoiceAmountInclVat - $invoiceAmountVat;
          $invoiceAmountPaid = 0;
        } else {
          // payments = 1
          $invoiceAmountInclVat = 0;
          $invoiceAmountVat = 0;
          $invoiceAmountExlVat = 0;
          $invoiceAmountPaid = str_replace(',', '.', $data['BedragInBasisValuta']); // we dont use , for floats ! // BedragInBasisValuta
        }
        
        $invoiceAmountDue = $invoiceAmountExlVat - $invoiceAmountPaid; // 7        
        
//		print "<li>$invoiceDate $year $invoiceNo $invoiceAmountExlVat";
//		$invoiceAmountExlVat = number_format ( $data[5], 4 , '.' , ',' );
//		$invoiceAmountPaid = $data[6];
        $aRevenues['customerCrm'][$customerCrmId][$year] = $aRevenues['customerCrm'][$customerCrmId][$year] + $invoiceAmountExlVat;
        $aRevenues['customerCrm'][$customerCrmId]['total-amount'] = $aRevenues['customerCrm'][$customerCrmId]['total-amount'] + $invoiceAmountExlVat;
        $aRevenues['customerCrm'][$customerCrmId]['total-due'] = $aRevenues['customerCrm'][$customerCrmId]['total-due'] + $invoiceAmountDue;
        $aRevenues['customer'][$debtorId]['customer-name'] = $customerName;
        $aRevenues['customerCrm'][$customerCrmId][$customerName] = $aRevenues['customerCrm'][$customerCrmId][$customerName] + $invoiceAmountExlVat;
        $aRevenues['year'][$year]['amount'] = $aRevenues['year'][$year]['amount'] + $invoiceAmountExlVat;
        // vervaldatum = 8

        if ($invoiceAmountExlVat == 0 || empty($invoiceAmountExlVat))
        {
            $aWarnings['customerCrm'][$customerCrmId][] = " Invoice {$invoiceNo} of {$customerName} has zero amount {$year}";
        }
    }
}

if (!empty($aCriticalWarnings))
{
    print '<pre>Critical WARNINGS:';
    print_r($aCriticalWarnings);
    print '</pre>';
    
} else
{
    $aCriticalWarnings = array();
}

// now we have all valid customers we can continue
// now send the array to crm
foreach ($aRevenues['customerCrm'] as $customerCrmId => $cValues)
{

    // if found collect all updates for this record 
    // and update values in account
    $sqlYear = array();
    $emptyYear = array();
    
    foreach ($cValues as $year => $revenue)
    {

        if (isset($yearFields[$year]))
        {
            $fieldName = $yearFields[$year];

            if ($fieldName != '') {
              $sqlYear[$year] = "{$fieldName} = " . number_format($revenue, 0, ',', false);
            }
        }
        if ($year != '') {
          $emptyYear[$year] = "{$fieldName} = " . number_format($revenue, 0, ',', false);
        }
    }

    if (!empty($sqlYear))
    {
//        print_r($sqlYear);
        $sql = "UPDATE vtiger_accountscf SET " . implode(', ', $sqlYear) . " WHERE accountid = '{$customerCrmId}';";
//        print '<br/>sqlYear: ' . $sql;
        $result2 = $adb->pquery($sql, array());
        
        if ($result2)
        {
//            print " # ok";
        } else
        {
//            print " # FAILED<br />";
            print_r($result2);
        }
    } else {
        // dan doen we dus niks!!
        $sql = "UPDATE vtiger_accountscf SET " . implode(', ', $emptyYear) . " WHERE accountid = '{$customerCrmId}';";
//        print '<br/>SKIP emptyYear: ' . $sql;
//        $result2 = $adb->pquery($sql, array());    
    }
}


// recalculate total customer value
$sql = "SELECT * FROM vtiger_accountscf AS cf JOIN vtiger_account AS a ON a.accountid  = cf.accountid WHERE `{$kingDebtorIdField}` > 0";
//print '<li>zoek accounts met debnummer, die moeten opnieuw worden doorgerekend: </li><li>' . $sql . '</li>';
$result3 = $adb->pquery($sql, array());

if ($result3)
{
    // Potentials found
    while ($AccountRows = $adb->fetch_array($result3)) {

        $customerCrmId = $AccountRows['accountid'];
        // sum them
        $totalCustomerValue = 0;

        foreach ($yearFields as $yr => $fieldName)
        {
//		  print '<br/>'."$yr => $fieldName {$AccountRows[$fieldName]}";
            $totalCustomerValue = $totalCustomerValue + $AccountRows[$fieldName];
        }

        // update total
        if (substr($totalField, 0, 3) == 'cf_')
        {
            $sql = "UPDATE vtiger_accountscf SET {$totalField} = $totalCustomerValue WHERE accountid = {$customerCrmId};";
        } else
        {
            $sql = "UPDATE vtiger_account SET {$totalField} = $totalCustomerValue WHERE accountid = {$customerCrmId};";
        }
        print '<br/>totalField: ' . $sql;
        $result4 = $adb->pquery($sql, array());
    }
} else
{
    print '<li>ERROR -- nothing found to recalculate';
}

if( !empty($aCriticalWarnings) or !empty($aWarnings) ) {
mail(
    "administratie@vicus.nl",
    "Warnings uit importproces facturen".__FILE__,
    "Bij het importeren van uren in castellum zijn de volgende constateringen: \n".print_r($aCriticalWarnings, true) . print_r($aWarnings, true)
);
}


// close connection