<?php
/**
 * Part of the Hub
 *
 * PHP 5
 *
 * THIS IS COPYRIGHTED SOFTWARE, UNAUTORIZED USE WILL BE PROSECUTED.
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * 
 * You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is Vicus eBusiness Solutions.
 * All Rights Reserved.
 *
 * @copyright	(c)2015 Vicus eBusiness Solutions bv <www.vicus.nl>
 * @author		l.roovers <l.roovers@vicus.nl>
 * @package		Classes
 * @category	Log
 * @version		$Id: Exp $
 */
 
/**
 * Class HubLog
 * @since	Version 1.0
 */
class HubLog {
	const EMERG   = 0;  // Emergency: system is unusable
	const ALERT   = 1;  // Alert: action must be taken immediately
	const CRIT    = 2;  // Critical: critical conditions
	const ERR     = 3;  // Error: error conditions
	const WARN    = 4;  // Warning: warning conditions
	const NOTICE  = 5;  // Notice: normal but significant condition
	const INFO    = 6;  // Informational: informational messages
	const DEBUG   = 7;  // Debug: debug messages

  public static function savelog($message, $prio = 0)
  {  
    global $root_directory;
    global $site_URL;
    
  	$priotext = array(
  		0 => 'EMERG',	// Emergency: system is unusable
  		1 => 'ALERT',	// Alert: action must be taken immediately
  		2 => 'CRIT',	// Critical: critical conditions
  		3 => 'ERROR',  	// Error: error conditions
  		4 => 'WARN',  	// Warning: warning conditions
  		5 => 'NOTICE',  // Notice: normal but significant condition
  		6 => 'INFO',  	// Informational: informational messages
  		7 => 'DEBUG',  // Debug: debug messages
  	);
  	
  	if ($prio <= 2) {
  	    $subject = "Alert from Hub ";
  	    $body = "An alert with prio {$priotext[$prio]} was raised:\n\n $message";
  	    $body .= "\nEnvironment: \n";
  	    $body .= "path: ". $root_directory. "\n";
        $body .= "url:  " . $site_URL. "\n";
  	    
  	    mail( $config['admin-email'] , $subject, $body);
  	}
  	
  	if ( ISWVACLI === TRUE) {
  		// nothing
  		print $priotext[$prio] . " - " . $message."\n";
  	} elseif (VEBHUB_DEBUG_VISIBLE === TRUE) {
  		// assume started through webinterface
  		if ($prio <= 3) {
  			print '<li style="color:red;">'.$priotext[$prio] . " - " . $message.'</li>'."\n";
  		} elseif ($prio == 6) {
  			print '<li style="color:blue;">'.$priotext[$prio] . " - " . $message.'</li>'."\n";		
  		} else {
  			print '<li style="color:green;">'.$priotext[$prio] . " - " . $message.'</li>'."\n";
  		}
  		flush();
  		// ob_flush();
  		// Notice: ob_flush(): failed to flush buffer. No buffer to flush in /home/cs1005/public_html/webvisitanalyser-1.0.0/Classes/Log.php on line 74
  		// @change lro 151119 - server dependant settings? solved 
  		if( ob_get_level() > 0 ) ob_flush();
  	} elseif (VEBHUB_DEBUG_VISIBLE == 'console') {
  	    self::debug_to_console($prio, $priotext[$prio], $message);
  	}
  		
  	$logmessage = Date("Y-m-d H:i:s").' - '.$_SERVER['REMOTE_ADDR']. ' - '. $priotext[$prio] . " - " . $message."\n";
  	if ($prio <= 3 || $prio == 6) {
  		$logfile = $root_directory."/logs/hub.log";
  		file_put_contents ($logfile , $logmessage, FILE_APPEND | LOCK_EX);
  	}

    if (VEBHUB_DEBUG == 1) {  	
  	  $logfile = $root_directory."/logs/hub-debug-".Date("Ymd").".log";  	
  	  file_put_contents ($logfile , $logmessage, FILE_APPEND | LOCK_EX);
  	}
  	
    }
  
    public static function debug($message)
    {
    	if (VEBHUB_DEBUG == 1) {
  	  	self::savelog($message, 7);
  	}
    }
  
    public static function error($message)
    {
    	self::savelog($message, 3);
    }
  
    public static function critical($message)
    {
    	self::savelog($message, 2);
    }
  
    public static function info($message)
    {
    	self::savelog($message, 6);
    }
  
    /**
     * error, warn, info, log
     */
    function debug_to_console( $prio, $priotext, $data ) {
    
        /*
        Older versions of Chrome do not allow you to get console.log()s to show in a specific color programmatically, but calling console.error() will put a red X icon on error lines and make the text red, and console.warn() gets you a yellow ! icon.
        */
        
        if ( is_array( $data ) )
            $data = implode(', ', $data);
        
        if ($prio <= 3) {
            print "<script>console.error( '{$priotext} - " . $data . "');</script>"."\n";
        } elseif ($prio == 6) {
            print "<script>console.info( '{$priotext} - " . $data . "');</script>"."\n";
        } elseif ($prio == 7) {
            print "<script>console.log( '{$priotext} - " . $data . "');</script>"."\n";
        } else {
            print "<script>console.warn( '{$priotext} - " . $data . "');</script>"."\n";
        }
    }
    
}
