<?php
/*
 * Action
 * checks the token with the secretkey
 *
 * the url is always:
 * <something>/hub.php?a=action&ts=timestamp&m=objectTypeId&i=objectId&v=version&t=token
 *
 */
class vtAction
{
  protected $_adb = null;
  protected $_hubAction = null;
  protected $_endpoint = null;
  protected $_token = null;
  protected $_secret = null;
  protected $_method = 'md5';
  protected $_timestamp = null;
  protected $_timeframe = 0;
  protected $_version = 1;
  protected $_language = 'dutch';
  protected $_values = null;
  protected $_connector = null;
  protected $_hubapp = 'vtiger';
//  protected $_appmod = 'vtshop'; // @obsolete = is very specific!
  protected $_appmod = ''; // @obsolete = is very specific!

  public function __construct($hubAction)
  {
    global $adb;

    // get the settings for this action from hubconfig config
    $this->_adb = $adb;

/*
    $query= "SELECT * FROM vtiger_hubconfigurator h, vtiger_hubconfiguratorcf c
             WHERE h.hubconfiguratorid = c.hubconfiguratorid
             AND h.hubaction = ?";
*/
// @change lro 170204 added LOWER to ensure we can find it, $action is also lowercased!
    $query= "SELECT * FROM vtiger_hubconfigurator h, vtiger_hubconfiguratorcf c
             WHERE h.hubconfiguratorid = c.hubconfiguratorid
             AND LOWER(h.hubaction) = ?";

    $params = array($hubAction);
    
    // hier zat mogelijk een denkfout, immers een hub_module mag in principe vaker worden geconfigureerd! 
    // hubaction (code) is door de vtiger enduser ingevoerd.
    // hub_module is gekozen via de picklist enn dus een gesloten keuze
    // let dus op.. we gebruiken de hub_module als sleutel in de url om een hubaction op te starten!!
    // hubaction bevat vervolgens informatie om die hub_applicatie & hub_module aan te sturen / te herkennen.
    
    $result = $this->_adb->pquery($query, $params);
    
    $this->_secret    = $this->_adb->query_result($result, 0, 'hub_secretkey');
    $this->_version   = $this->_adb->query_result($result, 0, 'hub_version');
    $this->_endpoint  = $this->_adb->query_result($result, 0, 'hub_endpoint');
    $this->_language  = $this->_adb->query_result($result, 0, 'hub_language');
    $this->_timeframe = $this->_adb->query_result($result, 0, 'hub_timeframe');
    $this->_hubapp    = $this->_adb->query_result($result, 0, 'hub_application');
    $this->_appmod    = $this->_adb->query_result($result, 0, 'hub_module');
    
    // @change 170204 lro added for completeness
    $this->_hubaction    = $this->_adb->query_result($result, 0, 'hubaction');    

    HubLog::debug(__CLASS__.'::'.__FUNCTION__." hubapp={$this->_hubapp}/appmod={$this->_appmod}/hubaction={$this->_hubaction}");
    
//    print_r($params);
  }

  public function getApplication()
  {
    return $this->_hubapp;
  }

  public function getModule()
  {
    return $this->_appmod;
  }

  public function getLanguage()
  {
    return $this->_language;
  }

  protected function _generateToken($addFromHub = false)
  {
    $tokenString = $this->_secret;
    $tokenStringReadable = $this->_secret; // just for logging

    // the token is up to the key 't' (oken)
    foreach($this->_values as $key => $value)
    {
      if ($key == 't') break;
      
      // @change lro - it is to be decide in an action itselves if this is allowed, not on this level!
/*
      if ($value == '') {
        HubLog::debug(__CLASS__.'::'.__FUNCTION__." value of url parameter [{$key}] is empty ");
        return false;
      }
*/
      $tokenString .= $value;
      $tokenStringReadable .= '|'.$value;
    }

    if ($addFromHub === true)
    {
      $tokenString .= 'callFromHub';
    }

    HubLog::debug(__CLASS__.'::'.__FUNCTION__." tokenstring={$tokenStringReadable}");

    switch($this->_method)
    {
      case 'md5':
      {
        $this->_token = md5($tokenString);
        break;
      }

      case 'sha1':
      {
        $this->_token = sha1($tokenString);
        break;
      }

      default:
      {
        HubLog::error(__CLASS__.'::'.__FUNCTION__." invalid method [{$this->_method}]");
        return false;
      }
    }

    HubLog::debug(__CLASS__.'::'.__FUNCTION__." method [{$this->_method}] = result = {$this->_token}");

    return true;
  }

  public function isValidToken()
  {
    // must be get, so use it
    $this->_values = $_GET;

    // check the version first
    if ($this->_values['v'] != $this->_version)
    {
      // version mismatch - invalid token
      HubLog::error(__CLASS__.'::'.__FUNCTION__." wrong version v=[{$this->_values['v']}], expected [[$this->_version}]");
      return false;
    }

    if ($this->_generateToken())
    {
      // validate token set
      if ($this->_token == $this->_values['t'])
      {
        // see if token is expired
        if ($this->_expired() === true)
        {
          // token is expired
          HubLog::error(__CLASS__.'::'.__FUNCTION__." token invalid ur=[{$this->_values['t']}] calculated=[{$this->_token}]");
          return false;
        }

        // token is valid
        return true;
      }
    }

    // token is incorrect
    HubLog::error(__CLASS__.'::'.__FUNCTION__." token invalid ");
    return false;
  }

  protected function _expired()
  {
    // validate timeframe set
    if (isset($this->_timeframe) && $this->_timeframe > 0)
    {
      // current timestamp
      $timestamp = time();

      $delta = $timestamp - (int)$this->_values['ts'];

      if ((int)$delta > (int)$this->_timeframe)
      {
        // expired
        HubLog::error(__CLASS__.'::'.__FUNCTION__." token expired delta alowed {$this->_timeframe} vs delta{$delta}");
        return true;
      }
    }

    // token is still valid
    return false;
  }

  public function redirectLink()
  {
    // add a 'super' secret string to know we come from hub
    if ($this->_generateToken(true) == true)
    {
      // overwrite ts with the new secretkey
      $this->_values['t'] = $this->_token;
    }
    
    // need to rewrite
    $redirectLink = '';

    foreach($this->_values as $key => $value)
    {
      $redirectLink .= '&' . $key . '=' . $value;
    }

    $redirectLink[0] = '?';

    return $this->_endpoint . $redirectLink;
  }

  public function run()
  {
    // check token here?
    if ($this->isValidToken() === true)
    {
      header('Location: ' . $this->redirectLink());
      exit();
    }

    return false;
  }

  public function redirect($result =true)
  {
    global $config;

    $redirect = 'error';

    if ($result === true)
    {
      $redirect = 'success';
    }

    if (is_array($config) && array_key_exists($this->_appmod, $config))
    {
      // must exist
      $redirectUrl = $config[$this->_appmod]['default'][$redirect];

      if (array_key_exists('custom', $config[$this->_appmod]) && is_array($config[$this->_appmod]['custom']))
      {
        if (array_key_exists($redirect, $config[$this->_appmod]['custom']) && $config[$this->_appmod]['custom'][$redirect] != '')
        {
          $redirectUrl = $config[$this->_appmod]['custom'][$redirect];
        }
      }

      header('Location: ' . $redirectUrl);
      exit();
    }
  }
}
