<?php
/**
 * @param	string	Module
 * @param	string	entityId
 * @param	string	status
 * @return	array('html','firstdate')
 */
function getRelatedActivities($module, $entityId, $status = 'open')
{
	global $adb,$crmEntityLog;
	
	$where = '';
	
	switch ($status)
	{
		case 'all':
			$where = "
				WHERE
				sar.crmid = {$entityId}
				AND ce.deleted = 0";
			break;
		default:
			if ($module == 'Potentials')
			{
				$where = "
					WHERE
					sar.crmid = {$entityId}
					AND ce.deleted = 0
					AND (a.status = 'Planned' 
						OR a.eventstatus = 'Planned' 
						OR a.status = 'In Progress' 
						OR a.status = 'Not Started'
						OR a.status = 'Pending Input'
						OR a.status = 'Deferred'
					)";
			} else {
				$where = "
					WHERE
		#				AND (ce.setype = 'Calendar')
						AND (ce.setype != 'Emails')
		#				AND (a.activitytype = 'Task' OR a.activitytype = 'Call')
		#				AND (a.status = 'Planned' 
			#					OR a.eventstatus = 'Planned' 
			#					OR a.eventstatus = 'Gepland' 
			#					OR a.status = 'In Progress' 
			#					OR a.status = 'Not Started'
			#					OR a.status = 'Pending Input'
			#					OR a.status = 'Deferred'
			#					)
						AND (
							a.eventstatus != 'Held'
							AND a.eventstatus != 'Not Held'
							# AND a.status != 'Completed'
							)
			#			AND a.status != 'Completed'
			#			AND (a.activitytype = 'Task' AND a.status != 'Completed')			
					";
			}

	}

	$sql = " SELECT 
			a.activityid,
			a.subject,
			a.activitytype,
			a.date_start,
			a.time_start,
			a.due_date,
			a.status AS activity_status,
			a.eventstatus,
			a.priority,
			ce.crmid,
			ce.smcreatorid,
			ce.smownerid,
			ce.modifiedby,
			ce.setype,
			ce.description,
			ce.createdtime,
			ce.status AS entity_status,
			ce.deleted
		FROM 
			vtiger_activity as a
		LEFT JOIN
			vtiger_seactivityrel as sar
		ON
			a.activityid = sar.activityid
		LEFT JOIN
			vtiger_crmentity as ce
		ON
			sar.activityid = ce.crmid
		{$where}
		;
	";

	$result2 = $adb->pquery($sql, array());
	$actionBlock = false;
	$sorted = array();
	
	if (is_array($result2->fields))
	{	
		// Potential actions found
		while ($potentialRow2 = $adb->fetch_array($result2))
		{
			$crmEntityLog[$potentialRow2['activityid']]=$potentialRow2;//['activityid']; // log that we handled it already
			$sorted[$potentialRow2['date_start'].$potentialRow2['time_start']] = $potentialRow2;
		}
		
		ksort($sorted);
		foreach ($sorted as $key => $value)
		{
			if (!$firstdate) {
				$firstdate = $value['date_start'].$value['time_start'];
			}
		
			switch ($value['activity_status'].$value['eventstatus'])
			{
				case 'Completed':
				case 'Held':
					$eventStatus = 'completed';
					$eventStatusIcon = 'veb/delete.png';
					break;
				case 'Pending Input':
					$eventStatus = $value['activity_status'].$value['eventstatus'];
					$eventStatusIcon = 'veb/clock.png';
					break;
				default:
					$eventStatus = $value['activity_status'].$value['eventstatus'];
					$eventStatusIcon = 'veb/arrowright.png';
			}		
			
			if ($status == 'open')
			{
				$actionBlock = formatProspectLineDetailView(
					$value['date_start'].' '.$value['time_start'],
					'<span class="'.$eventStatus.'">'.$value['activity_status'].$value['eventstatus'].' - '.$value['activitytype']. ' - '.$value['subject'].'</span>'
					) . $actionBlock;
			}
			else 
			{
				$actionBlock = '<tr class="actions"><td class="actions" style="background-color:#efefef;"><img src="'.$eventStatusIcon.'"></td><td class="actions" style="background-color:#efefef;"><span class="'
					.$eventStatus.'">'
					.$value['due_date'].'&nbsp;'
					.$value['activity_status'].$value['eventstatus']
					.' - '
					.$value['activitytype'].'</span>'
					.'</td></tr><tr><td>&nbsp;</td><td><span class="'.$eventStatus.'">'
					.'<strong>'.$value['subject'].'</strong>'.'<br />'.html_entity_decode($value['description'])
					.'</span></td></tr>'
					.$actionBlock;
			}	
		}
	}

	if ($status == 'all') $actionBlock = "\n\t\t".'<table class="actions">'.$actionBlock . "\n\t\t</table>";
	
	return array($actionBlock,$firstdate);
}
