<?php
function format_phone($rawphone)
{	

	$rawphone = str_ireplace (" ", "",$rawphone);
	$rawphone = str_ireplace ("-", "",$rawphone);

	if ($rawphone == '') return '';
	
	$formatted = '';

	if (substr($rawphone,0,1) == '+')
	{
		$formatted .= '+';
		$rawphone = substr($rawphone,1);
	} 
	if (substr($rawphone,0,2) == '00')
	{
		$formatted .= '+';
		$rawphone = substr($rawphone,2);
	}

	$formatted = str_ireplace ("++", "+",$formatted);

	if (substr($rawphone,0,2) == '06')
	{
		$formatted .= '06 ';
		$rawphone = substr($rawphone,2);
	}
/*
	 	0591647858  
	 	0591 4785 8 
		059 1647 858 
*/
	$formatted .= substr($rawphone,0,3).' '.substr($rawphone,3,3).' '.substr($rawphone,6); // take all there's left

//	make it dutch international
	if (substr($formatted,0,1) == '0') {
		$formatted = '+31'.substr($formatted,1,100);
	}

	$formatted = ' <a href="callto:'.str_ireplace (" ", "",$formatted).'">'.$formatted.'</a> ';

	return $formatted;
}

function shortenCompanyName($name) {
	$name = str_ireplace('Koninklijke','',$name);
	$name = substr($name,0,22);
	$name = trim($name);
	return $name;
}

function shortenPotentialName($name,$companyName) {
	$name = str_ireplace($companyName,'',$name);
	$name = str_ireplace($companyName,'',$name);
//	$name = substr($name,0,20);
	$name = trim($name,'-');
	return $name;
}


function cleanSalutation($name) {
	$name = str_replace('--None--','',$name);
	$name = trim($name);
	return $name;
}
?>