<?php
/**
 * Data file for HTTP_USER_AGENT identification
 * - Navigateur (Browser)
 * - Bot (Indexeur, Robots, moteurs de recherches, Validator)
 *
 * Syntaxe :
 * - 2 main array with index agent and system
 * - in each mains array, index is name of browser, bot, os, device ...
 * - The value is an array with index needed: "search" (array|string) and "type" casse insensitive
 * - facultatif index : "subType", "description"
 * - In system (not implemented for agent) array version_subSearch or version_addSearch
 *
 * Important sorting:
 *   - search string ? rules ?
 *   - in ASC order undesirable, bot, browser
 *   - At the end? 'Internet Explorer', 'Netscape Navigator', et 'Mozilla compatible'
 *
 * @author      FredT
 * @category    FredT Library
 * @package     FredT Request Info
 * @version     10/01/2009
 *
 */
return array (
  'agent' => array(
    /* A partir d'ici les indésirables, doivent être avant les Bots et Browsers */
      'DirectUpdate' =>
      array (
        'search' => 'DirectUpdate',
        'type' => 'undesirable',
        'description'=>'renvoi d\'IP',
      ),
      'eCatch' =>
      array (
        'search' => 'eCatch',
        'type' => 'undesirable',
        'subType' => 'Aspirateur',
      ),
      'EmailCollector' =>
      array (
        'search' => 'EmailCollector',
        'type' => 'undesirable',
        'subType' => 'Email Collector',
      ),
      'Email Extractor' =>
      array (
        'search' => 'Email Extractor',
        'type' => 'undesirable',
        'subType' => 'Email Collector',
      ),
      'flashget' =>
      array (
        'search' => 'flashget',
        'type' => 'undesirable',
        'subType' => 'Aspirateur',
      ),
      'HTTPConnect' =>
      array (
        'search' => 'HTTPConnect',
        'type' => 'undesirable',
      ),
      'HTTrack' =>
      array (
        'search' => 'HTTrack',
        'type' => 'undesirable',
        'mode'=>2,
      ),
      'Indy Library' =>
      array (
        'search' => 'Indy Library',
        'type' => 'undesirable',
        'mode'=>2,
      ),
      'IPiumBot laurion(dot)com' =>
      array (
        'search' => 'IPiumBot laurion(dot)com',
        'type' => 'undesirable',
      ),
      'Kapere' =>
      array (
        'search' => 'Kapere',
        'type' => 'undesirable',
      ),
      'My User Agent' =>
      array (
        'search' => 'My User Agent',
        'type' => 'undesirable',
      ),
      'MyGetRight' =>
      array (
        'search' => 'MyGetRight',
        'type' => 'undesirable',
        'subType' => 'Aspirateur',
      ),
      'NPBot' =>
      array (
        'search' => 'NPBot',
        'type' => 'undesirable',
      ),
      'NetAnts' =>
      array (
        'search' => 'NetAnts',
        'type' => 'undesirable',
      ),
      'Program Shareware' =>
      array (
        'search' => 'Program Shareware',
        'type' => 'undesirable',
      ),
      'SlySearch' =>
      array (
        'search' => 'SlySearch',
        'type' => 'undesirable',
      ),
      'Teleport Pro' =>
      array (
        'search' => 'Teleport Pro',
        'type' => 'undesirable',
      ),
      'TurnitinBot' =>
      array (
        'search' => 'TurnitinBot',
        'type' => 'undesirable',
        'mode'=>1,
      ),
      'URLGetFile' =>
      array (
        'search' => 'URLGetFile',
        'type' => 'undesirable',
      ),
      'vobsub' =>
      array (
        'search' => 'vobsub',
        'type' => 'undesirable',
      ),
      'WebCapture' =>
      array (
        'search' => 'WebCapture',
        'type' => 'undesirable',
        'mode'=>2,
      ),
      'WebCopier' =>
      array (
        'search' => 'WebCopier',
        'type' => 'undesirable',
      ),
      'WebDAV' =>
      array (
        'search' => 'WebDAV',
        'type' => 'undesirable',
      ),
      'WEBsaver' =>
      array (
        'search' => 'WEBsaver',
        'type' => 'undesirable',
        'subType' => 'Aspirateur',
      ),
      'WebStripper' =>
      array (
        'search' => 'WebStripper',
        'type' => 'undesirable',
        'subType' => 'Aspirateur',
      ),
      'WebReaper' =>
      array (
        'search' => 'WebReaper',
        'type' => 'undesirable',
        'subType' => 'Aspirateur',
      ),
      'WebZIP' =>
      array (
        'search' => 'WebZIP',
        'type' => 'undesirable',
        'subType' => 'Aspirateur',
        'mode'=>1,
      ),
      'Wget' =>
      array (
        'search' => 'Wget',
        'type' => 'undesirable',
        'subType' => 'Aspirateur',
        'mode'=>2,
      ),
      'WinMHT' =>
      array (
        'search' => 'WinMHT',
        'type' => 'undesirable',
        'subType' => 'Aspirateur',
      ),
      'Wysigot' =>
      array (
        'search' => 'Wysigot',
        'type' => 'undesirable',
        'subType' => 'Aspirateur',
        'mode'=>2,
      ),
      'Navigateur de recherche Zeus' =>
      array (
        'search' => 'Zeus',
        'type' => 'undesirable',
      ),
    /* A Partir d'ici les Bots, doivent être avant les Browsers, et après les indésirables */
      'AltaVista' =>
      array (
        'search' =>
        array (
          0 => 'Mercator',
          1 => 'Scooter',
        ),
        'type' => 'bot',
      ),
      'Googlebot' =>
      array (
        'search' => array(
                        '/Googlebot\/([0-9a-z\+\-\.]+).*/si',
                        '/Googlebot\-(Image\/[0-9a-z\+\-\.]+).*/si',
                      ),
        'type' => 'bot',
        'mode'=>1,
      ),
      'Gigabot' =>
      array (
        'search' => '/Gigabot\/([0-9a-z\+\-\.]+).*/si',
        'type' => 'bot',
      ),
      'W3C Validator' =>
      array (
        'search' => '/^W3C_Validator\/([0-9a-z\+\-\.]+)$/si',
        'type' => 'bot',
        'subType' => 'Validator',
      ),
      'W3C CSS Validator' =>
      array (
        'search' => '/W3C_CSS_Validator_[a-z]+\/([0-9a-z\+\-\.]+)$/si',
        'type' => 'bot',
        'subType' => 'Validator',
      ),
      'MSN Bot' =>
      array (
        'search' => array(
        				'/msnbot(-media|)\/([0-9a-z\+\-\.]+).*/si',
        				'/msnbot\/([0-9a-z\+\-\.]+).*/si',
                      ),
        'type' => 'bot',
        'mode'=>1,
      ),
      'Psbot' =>
      array (
        'search' => '/psbot\/([0-9a-z\+\-\.]+).*/si',
        'type' => 'bot',
      ),
      'IRL crawler' =>
      array (
        'search' => '/IRLbot\/([0-9a-z\+\-\.]+).*/si',
        'type' => 'bot',
      ),
      'Seekbot' =>
      array (
        'search' => '/Seekbot\/([0-9a-z\+\-\.]+).*/si',
        'type' => 'bot',
      ),
      'Microsoft Research Bot' =>
      array (
        'search' => '/^MSRBOT /si',
        'type' => 'bot',
      ),
      'cfetch/voyager' =>
      array (
        'search' => '/^(cfetch|voyager)\/([0-9a-z\+\-\.]+)$/si',
        'type' => 'bot',
      ),
      'BecomeBot' =>
      array (
        'search' => '/BecomeBot\/([0-9a-z\+\-\.]+).*/si',
        'type' => 'bot',
      ),
      'Alexa' =>
      array (
        'search' => '/^ia_archiver$/si',
        'type' => 'bot',
      ),
      'Inktomi Slurp' =>
      array (
        'search' => '/Slurp.*inktomi/si',
        'type' => 'bot',
        'description' => 'http://www.inktomi.com/',
      ),
      'Lycos' =>
      array (
        'search' => array(
        				'Inktomi',
      					'Lycos_Spider',
                      ),
        'type' => 'bot',
      ),
      'Yahoo Slurp' =>
      array (
        'search' => '/Yahoo!.*Slurp/si',
        'type' => 'bot',
        'mode'=>1,
      ),
      'Ask.com' =>
      array (
        'search' => '/Ask Jeeves\/Teoma/si',
        'type' => 'bot',
      ),
      'AcoiRobot' =>
      array (
        'search' => 'AcoiRobot',
        'type' => 'bot',
      ),
      'cosmos' =>
      array (
        'search' => 'cosmos',
        'type' => 'bot',
      ),
      'CrawlerBoy' =>
      array (
        'search' => 'CrawlerBoy',
        'type' => 'bot',
      ),
      'DeepIndex' =>
      array (
        'search' => 'DeepIndex',
        'type' => 'bot',
      ),
      'Exalead (Abondance, AOL...)' =>
      array (
        'search' => 'Exalead',
        'type' => 'bot',
      ),
      'fastlwspider' =>
      array (
        'search' => 'fastlwspider',
        'type' => 'bot',
      ),
      'Gaisbot' =>
      array (
        'search' => 'Gaisbot',
        'type' => 'bot',
      ),
      'larbin' =>
      array (
        'search' => 'larbin',
        'type' => 'bot',
      ),
      'MicrosoftPrototypeCrawler' =>
      array (
        'search' => 'MicrosoftPrototypeCrawler',
        'type' => 'bot',
      ),
      'Nomade' =>
      array (
        'search' => 'NomadeBot',
        'type' => 'bot',
        'subType' => 'annuaire',
      ),
      'Openbot' =>
      array (
        'search' => 'Openbot',
        'type' => 'bot',
      ),
      'Openfind' =>
      array (
        'search' => 'Openfind',
        'type' => 'bot',
      ),
      'dir.com' =>
      array (
        'search' => 'Pompos',
        'type' => 'bot',
        'subType' => 'Moteur',
        'mode'=>1,
      ),
      'QuepasaCreep' =>
      array (
        'search' => 'QuepasaCreep',
        'type' => 'bot',
      ),
      'Wanadoo' =>
      array (
        'search' => 'SurferF3',
        'type' => 'bot',
      ),
      'Surfnomore Spider' =>
      array (
        'search' => 'Surfnomore Spider',
        'type' => 'bot',
      ),
      'suzuran' =>
      array (
        'search' => 'suzuran',
        'type' => 'bot',
      ),
      'Ultraseek' =>
      array (
        'search' => 'Ultraseek',
        'type' => 'bot',
      ),
      'Voila' =>
      array (
        'search' => 'VoilaBot',
        'type' => 'bot',
        'mode'=>1,
      ),
      'WebCrawler' =>
      array (
        'search' => 'WebCrawler',
        'type' => 'bot',
      ),
      'ZyBorg' =>
      array (
        'search' => 'ZyBorg',
        'type' => 'bot',
      ),
      'Mylinea' =>
      array (
        'search' => 'Mylinea',
        'type' => 'bot',
        'subType' => 'Annuaire',
      ),
      'IBM Almaden Crawler' =>
      array (
        'search' => 'almaden',
        'type' => 'bot',
      ),
      'Link Checker Pro' =>
      array (
        'search' => 'Link-Checker-Pro',
        'type' => 'bot',
        'subType' => 'Validator',
      ),
      'Survey Bot' =>
      array (
        'search' => 'surveybot',
        'type' => 'bot',
      ),
      'W3C Checklink' =>
      array (
        'search' => 'w3c-checklink',
        'type' => 'bot',
        'subType' => 'Validator',
      ),
      'Fast WebCrawler' =>
      array (
        'search' => 'fast-webcrawler',
        'type' => 'bot',
      ),
      'Topicspy Checkbot' =>
      array (
        'search' => 'topicspy',
        'type' => 'bot',
      ),
      'Exabot NG' =>
      array (
        'search' => array(
                      	'/NG/si',
                      	'/Exabot\/([0-9a-z\+\-\.]+).*/si',
                      ),
        'type' => 'bot',
        'mode'=>1,
      ),
      'LinkWalker' =>
      array (
        'search' => 'LinkWalker',
        'type' => 'bot',
        'description'=>' société proposant des services de référencemnt',
      ),
      'NaverBot' =>
      array (
        'search' => 'NaverBot',
        'type' => 'bot',
      ),
      'ConveraCrawler' =>
      array (
        'search' => 'ConveraCrawler',
        'type' => 'bot',
      ),
      'Innerprise' =>
      array (
        'search' => 'Innerprise',
        'type' => 'bot',
      ),
      'Poodle Predictor' =>
      array (
        'search' => 'Poodle Predictor',
        'type' => 'bot',
      ),
      'Ichiro' =>
      array (
        'search' => 'Ichiro',
        'type' => 'bot',
      ),
      'Grub-Client' =>
      array (
        'search' => 'Grub-Client',
        'type' => 'bot',
      ),
      'MJ12Bot' =>
      array (
        'search' => 'MJ12Bot',
        'type' => 'bot',
        'mode'=>1,
      ),
      'NextGenSearchBot' =>
      array (
        'search' => 'NextGenSearchBot',
        'type' => 'bot',
      ),
      'TutorGigBot' =>
      array (
        'search' => 'TutorGigBot',
        'type' => 'bot',
      ),
      'Xenu Link Sleuth' =>
      array (
        'search' => 'Xenu Link Sleuth',
        'type' => 'bot',
      ),
      'IconSurf' =>
      array (
        'search' => 'IconSurf',
        'type' => 'bot',
      ),
      'Zoe Indexer' =>
      array (
        'search' => 'Zoe Indexer',
        'type' => 'bot',
      ),
    /* A Partir d'ici les Browsers, doivent être après les Bots */
      'AvantGo PDA' =>
      array (
        'search' => 'AvantGo',
        'type' => 'browser',
        'subType' => 'PDA',
      ),
      'Beonex Communicator' =>
      array (
        'search' => 'Beonex',
        'type' => 'browser',
      ),
      'Chimera' =>
      array (
        'search' => 'Chimera',
        'type' => 'browser',
        'description'=>'Ancienne version de Camino',
      ),
      'Cyberdog Mac' =>
      array (
        'search' => 'Cyberdog',
        'type' => 'browser',
      ),
      'HotJava browser plus' =>
      array (
        'search' => 'HotJava',
        'type' => 'browser',
      ),
      'I-Opener web PC' =>
      array (
        'search' => 'I-Opener',
        'type' => 'browser',
      ),
      'Lotus Notes' =>
      array (
        'search' => 'Lotus-Notes',
        'type' => 'browser',
      ),
      'PDA Pocket IE' =>
      array (
        'search' => 'MSPIE',
        'type' => 'browser',
        'subType' => 'PDA',
      ),
      'Nautilus' =>
      array (
        'search' => 'Nautilus',
        'type' => 'browser',
      ),
      'NCBrowser' =>
      array (
        'search' => 'NCBrowser',
        'type' => 'browser',
      ),
      'NetPositive' =>
      array (
        'search' => 'NetPositive',
        'type' => 'browser',
      ),
      'SiteKiosk public terminal browser' =>
      array (
        'search' => 'SiteKios',
        'type' => 'browser',
      ),
      'Wanna-Be text' =>
      array (
        'search' => 'WannaBe',
        'type' => 'browser',
        'subType' => 'Browser text mode',
      ),
      'amaya' =>
      array (
        'search' => '/amaya/si',
        'type' => 'browser',
      ),
      'AOL' =>
      array (
        'search' => '/AOL ([0-9a-z\+\-\.]+)/si',
        'type' => 'browser',
        'mode'=>2,
      ),
      'FrontPage' =>
      array (
        'search' => '/FrontPage/si',
        'type' => 'browser',
      ),
      'Google Chrome' =>
      array (
        'search' => '/chrome/si',
        'type' => 'browser',
        'mode'=>1,
      ),
      'Camino' =>
      array (
        'search' => '/mozilla.*rv:[0-9\.]+.*gecko\/[0-9]+.*camino\/([0-9a-z\+\-\.]+).*/si',
        'type' => 'browser',
      ),
      'Epiphany' =>
      array (
        'search' => '/mozilla.*gecko\/[0-9]+.*epiphany\/([0-9a-z\+\-\.]+).*/si',
        'type' => 'browser',
      ),
      'Galeon' =>
      array (
        'search' => '/mozilla.*gecko\/[0-9]+.*galeon\/([0-9a-z\+\-\.]+).*/si',
        'type' => 'browser',
      ),
      'Flock' =>
      array (
        'search' => '/mozilla.*gecko\/[0-9]+.*flock\/([0-9a-z\+\-\.]+).*/si',
        'type' => 'browser',
      ),
      'Minimo' =>
      array (
        'search' => '/mozilla.*gecko\/[0-9]+.*minimo\/([0-9a-z\+\-\.]+).*/si',
        'type' => 'browser',
      ),
      'K-Meleon' =>
      array (
        'search' => '/mozilla.*gecko\/[0-9]+.*k\-meleon\/([0-9a-z\+\-\.]+).*/si',
        'type' => 'browser',
      ),
      'K-Ninja' =>
      array (
        'search' => '/mozilla.*gecko\/[0-9]+.*k-ninja\/([0-9a-z\+\-\.]+).*/si',
        'type' => 'browser',
      ),
      'Kazehakase' =>
      array (
        'search' => '/mozilla.*gecko\/[0-9]+.*kazehakase\/([0-9a-z\+\-\.]+).*/si',
        'type' => 'browser',
      ),
      'SeaMonkey' =>
      array (
        'search' => '/mozilla.*rv:[0-9\.]+.*gecko\/[0-9]+.*seamonkey\/([0-9a-z\+\-\.]+).*/si',
        'type' => 'browser',
      ),
      'IceApe' =>
      array (
        'search' => '/mozilla.*rv:[0-9\.]+.*gecko\/[0-9]+.*iceape\/([0-9a-z\+\-\.]+).*/si',
        'type' => 'browser',
      ),
      'Firefox' =>
      array (
        'search' => '/mozilla.*rv:[0-9\.]+.*gecko\/[0-9]+.*firefox\/([0-9a-z\+\-\.]+).*/si',
        'type' => 'browser',
        'mode'=>1,
      ),
      'IceWeasel' =>
      array (
        'search' => '/mozilla.*rv:[0-9\.]+.*gecko\/[0-9]+.*iceweasel\/([0-9a-z\+\-\.]+).*/si',
        'type' => 'browser',
      ),
      'Bon Echo' =>
      array (
        'search' => '/mozilla.*rv:[0-9\.]+.*gecko\/[0-9]+.*BonEcho\/([0-9a-z\+\-\.]+).*/si',
        'type' => 'browser',
      ),
      'Gran Paradiso' =>
      array (
        'search' => '/mozilla.*rv:[0-9\.]+.*gecko\/[0-9]+.*GranParadiso\/([0-9a-z\+\-\.]+).*/si',
        'type' => 'browser',
      ),
      'Minefield' =>
      array (
        'search' => '/mozilla.*rv:[0-9\.]+.*gecko\/[0-9]+.*Minefield\/([0-9a-z\+\-\.]+).*/si',
        'type' => 'browser',
      ),
      'Thunderbird' =>
      array (
        'search' => '/mozilla.*rv:[0-9\.]+.*gecko\/[0-9]+.*thunderbird\/([0-9a-z\+\-\.]+).*/si',
        'type' => 'browser',
        'mode'=>2,
      ),
      'IceDove' =>
      array (
        'search' => '/mozilla.*rv:[0-9\.]+.*gecko\/[0-9]+.*icedove\/([0-9a-z\+\-\.]+).*/si',
        'type' => 'browser',
      ),
      'Firebird' =>
      array (
        'search' => '/mozilla.*rv:[0-9\.]+.*gecko\/[0-9]+.*firebird\/([0-9a-z\+\-\.]+).*/si',
        'type' => 'browser',
        'description'=>'anciennement Phoenix',
      ),
      'Phoenix' =>
      array (
        'search' => '/mozilla.*rv:[0-9\.]+.*gecko\/[0-9]+.*phoenix\/([0-9a-z\+\-\.]+).*/si',
        'type' => 'browser',
      ),
      'Mozilla Suite' =>
      array (
        'search' => '/mozilla.*rv:([0-9\.]+).*gecko\/[0-9]+.*/si',
        'type' => 'browser',
        'mode'=>1,
      ),
      'Konqueror' =>
      array (
        'search' => '/mozilla.*konqueror\/([0-9a-z\+\-\.]+).*/si',
        'type' => 'browser',
        'mode'=>1,
      ),
      'QuickTime' =>
      array (
        'search' => '/quicktime/si',
        'type' => 'browser',
      ),
      'Opera' =>
      array (
        'search' =>
        array (
          0 => '/mozilla.*opera ([0-9a-z\+\-\.]+).*/si',
          1 => '/^opera\/([0-9a-z\+\-\.]+).*/si',
        ),
        'type' => 'browser',
        'mode'=>1,
      ),
      'OmniWeb' =>
      array (
        'search' => '/mozilla.*applewebkit\/[0-9]+.*omniweb\/v[0-9\.]+/si',
        'type' => 'browser',
      ),
      'SunriseBrowser' =>
      array (
        'search' => '/mozilla.*applewebkit\/[0-9]+.*sunrisebrowser\/([0-9a-z\+\-\.]+)/si',
        'type' => 'browser',
      ),
      'DeskBrowse' =>
      array (
        'search' => '/mozilla.*applewebkit\/[0-9]+.*deskbrowse\/([0-9a-z\+\-\.]+)/si',
        'type' => 'browser',
      ),
      'Shiira' =>
      array (
        'search' => '/mozilla.*applewebkit.*shiira\/([0-9a-z\+\-\.]+).*/si',
        'type' => 'browser',
      ),
      'Safari' =>
      array (
        'search' => '/mozilla.*applewebkit.*safari\/([0-9a-z\+\-\.]+).*/si',
        'type' => 'browser',
        'mode'=>1,
      ),
      'Dillo' =>
      array (
        'search' => '/dillo\/([0-9a-z\+\-\.]+).*/si',
        'type' => 'browser',
      ),
      'iCab' =>
      array (
        'search' => '/icab\/([0-9a-z\+\-\.]+).*/si',
        'type' => 'browser',
      ),
      'Lynx' =>
      array (
        'search' => '/^lynx\/([0-9a-z\.]+).*/si',
        'type' => 'browser',
      ),
      'Links' =>
      array (
        'search' => '/^links \(([0-9a-z\.]+).*/si',
        'type' => 'browser',
      ),
      'ELinks' =>
      array (
        'search' =>
        array (
          0 => '/^elinks \(([0-9a-z\.]+).*/si',
          1 => '/^elinks\/([0-9a-z\.]+).*/si',
          2 => '/^elinks$/si',
        ),
        'type' => 'browser',
        'subType' => 'Browser text mode',
      ),
      'Amiga Aweb' =>
      array (
        'search' => '/Amiga\-Aweb\/([0-9a-z\+\-\.]+).*/si',
        'type' => 'browser',
      ),
      'Amiga Voyager' =>
      array (
        'search' => '/AmigaVoyager\/([0-9a-z\+\-\.]+).*/si',
        'type' => 'browser',
      ),
      'QNX Voyager' =>
      array (
        'search' => '/QNX Voyager ([0-9a-z.]+).*/si',
        'type' => 'browser',
      ),
      'IBrowse' =>
      array (
        'search' => '/IBrowse\/([0-9a-z\+\-\.]+).*/si',
        'type' => 'browser',
      ),
      'Openwave' =>
      array (
        'search' =>
        array (
          0 => '/UP\.Browser\/([0-9a-zA-Z\.]+).*/si',
          1 => '/UP\/([0-9a-zA-Z\.]+).*/si',
        ),
        'type' => 'browser',
      ),
      'NetFront' =>
      array (
        'search' => '/NetFront\/([0-9a-z\.]+).*/si',
        'type' => 'browser',
        'subType' => 'mobil',
      ),
      'Internet Explorer' =>
      array (
        'search' =>
        array (
          0 => '/microsoft.*internet.*explorer/si',
          1 => '/mozilla.*MSIE ([0-9a-z\+\-\.]+).*/si',
        ),
        'type' => 'browser',
        'mode'=>1,
      ),
      'Netscape Navigator' =>
      array (
        'search' =>
        array (
          0 => '/Mozilla\/([0-4][0-9\.]+).*/si',
          1 => '/netscape[0-9]?\/([0-9a-z\+\-\.]+).*/si',
        ),
        'type' => 'browser',
        'mode'=>2,
      ),
      'Mozilla compatible' =>
      array (
        'search' => '/mozilla/si',
        'type' => 'browser',
        'mode'=>1,
      ),
  ), // end agent array ( undesirable, bot, browser)
'system' => array (
    'Mobile phone browser' =>
    array (
      'search' => 'UP.Link',
      'type' => 'mobil',
      'subType' => 'browser',
      'mode'=>2,
    ),
    'Symbian Os' =>
    array (
      'search' => '/symbian/si',
      'type' => 'mobil',
      'subType' => 'browser',
      'mode'=>2,
    ),
    'HP-Unix' =>
    array (
      'search' => 'HP-UX',
      'type' => 'os',
    ),
    'IRIX x' =>
    array (
      'search' => 'IRIX',
      'type' => 'os',
    ),
    'OSF1 x' =>
    array (
      'search' => 'OSF1',
      'type' => 'os',
    ),
    'Risc OS x' =>
    array (
      'search' => 'RISC OS',
      'type' => 'os',
    ),
    'Syclik Control web content management system' =>
    array (
      'search' => 'SYCLIKControl',
      'type' => 'os',
    ),
    'Liberate DTV server suite / TV-emulator' =>
    array (
      'search' => 'Liberate DTV',
      'type' => 'tv',
      'subType' => 'browser',
    ),
      'Netgem Netbox' =>
      array (
        'search' => 'Netbox',
        'type' => 'tv',
        'subType' => 'device',
      ),
    'WebTV' =>
    array (
      'search' => 'WebTV',
      'type' => 'tv',
      'subType' => 'browser',
      'mode'=>2,
    ),
    'Linux' =>
    array (
      'search' => '/linux/si',
      'version_addSearch'=>array(
            'Mandrake'=>'/mdk/si',
            'Kanotix'=>'/kanotix/si',
            'Lycoris'=>'/lycoris/si',
            'Knoppix'=>'/knoppix/si',
            'CentOS'=>'/centos/si',
            'Gentoo'=>'/gentoo/si',
            'Fedora'=>'/fedora/si',
            'Ubuntu 7.04 Feisty Fawn'=>'/ubuntu.feist/si',
            'Ubuntu 6.10 Edgy Eft'=>'/ubuntu.edgy/si',
            'Ubuntu 6.06 LTS Dapper Drake'=>'/ubuntu.dapper/si',
            'Ubuntu 5.10 Breezy Badger'=>'/ubuntu.breezy/si',
            'Kubuntu'=>'/kubuntu/si',
            'Xubuntu'=>'/xubuntu/si',
            'Ubuntu'=>'/ubuntu/si',
            'Slackware'=>'/slackware/si',
            'Suse'=>'/suse/si',
            'Redhat'=>'/redhat/si',
            'Debian'=>'/debian/si',
            'PLD'=>'/PLD\//si',
        ),
      'type' => 'os',
      'mode'=>1,
    ),
    'BSD' =>
    array (
      'search' => '/bsd/si',
      'version_addSearch'=>array(
    		'FreeBSD'=>'/freebsd/si',
            'OpenBSD'=>'/openbsd/si',
            'NetBSD'=>'/netbsd/si',
          ),
      'type' => 'os',
      'mode'=>2,
    ),
    'Mac OS' =>
    array (
      'search' =>
      array (
        0 => '/mac_/si',
        1 => '/macos/si',
        2 => '/powerpc/si',
        3 => '/mac os/si',
        4 => '/68k/si',
        5 => '/macintosh/si',
      ),
      'type' => 'os',

      'mode'=>1,
    ),
    'ReactOS' =>
    array (
      'search' => '/ReactOS ([0-9a-zA-Z\+\-\. ]+).*/si',
      'type' => 'os',
    ),
    'SunOs' =>
    array (
      'search' => '/sunos/si',
      'type' => 'os',
      'mode'=>2,
    ),
    'Amiga' =>
    array (
      'search' => '/amiga/si',
      'type' => 'os',
    ),
    'Irix' =>
    array (
      'search' => '/irix/si',
      'type' => 'os',
    ),
    'OpenVMS' =>
    array (
      'search' => '/open.*vms/si',
      'type' => 'os',
    ),
    'BeOs' =>
    array (
      'search' => '/beos/si',
      'type' => 'os',
    ),
    'QNX' =>
    array (
      'search' => '/QNX/si',
      'type' => 'os',
    ),
    'OS/2 Warp' =>
    array (
      'search' => '/OS\/2.*Warp ([0-9.]+).*/si',
      'type' => 'os',
    ),
    'Java on mobile' =>
    array (
      'search' => '/j2me/si',
      'type' => 'mobil',
      'subType' => 'os',
    ),
    'Palm Os' =>
    array (
      'search' => '/palmos/si',
      'type' => 'palm',
    ),
      'PlayStation Portable' =>
      array (
        'search' => array ('/psp.*playstation.*portable[^0-9]*([0-9a-z\.]+)\)/si',
                          '/psp.*playstation.*portable/si',
                          ),
        'type' => 'Console',
      ),
    'Dreamcast console' =>
    array (
      'search' => array('Dreamcast','Planetweb'),
      'type' => 'console',
    ),
    'Nintentdo Wii' =>
    array (
      'search' => '/Nintendo Wii/si',
      'type' => 'console',
    ),
    'Windows' =>
    array (
      'search' =>
      array (
        0 => '/windows ([0-9\.]+).*/si',
        1 => '/[ \(]win([0-9\.]+).*/si',
        2 => '/windows (me)/si',
        3 => '/windows (ce)/si',
        4 => '/windows (xp)/si',
        5 => '/windows (nt)/si',
        6 => '/windows nt ([0-9\.]+).*/si',
        7 => '/winnt([0-9\.]+).*/si',
        8 => '/windows/si',
      ),
      'version_subSearch'=>array( //Dans result version
    		'Millenium'=>'/me/si',
            'CE'=>'/ce/si',
            'XP'=>'/xp/si',
            'NT'=>'/nt/si',
            'Vista'=>'/6.0/si',
    		'Server 2003'=>'/5.2/si',
    		'XP'=>'/5.1/si',
    		'2000'=>'/5.0/si',
    		'2000'=>'/5.01/si',
        ),
      'type' => 'os',
        'mode'=>1,
    ),
    'Nokia' =>
    array (
      'search' => '/Nokia[ ]{0,1}([0-9a-zA-Z\+\-\.]+){0,1}.*/si',
      'type' => 'mobil',
      'subType' => 'device',
      'mode'=>2,
    ),
    'Motorola' =>
    array (
      'search' => '/mot\-([0-9a-zA-Z\+\-\.]+){0,1}\//si',
      'type' => 'mobil',
      'subType' => 'device',
      'mode'=>2,
    ),
    'Siemens' =>
    array (
      'search' => '/sie\-([0-9a-zA-Z\+\-\.]+){0,1}\//si',
      'type' => 'mobil',
      'subType' => 'device',
      'mode'=>2,
    ),
    'Samsung' =>
    array (
      'search' => '/samsung\-([0-9a-zA-Z\+\-\.]+){0,1}\//si',
      'type' => 'mobil',
      'subType' => 'device',
      'mode'=>2,
    ),
    'Sony Ericsson' =>
    array (
      'search' => '/SonyEricsson[ ]{0,1}([0-9a-zA-Z\+\-\.]+){0,1}.*/si',
      'type' => 'mobil',
      'subType' => 'device',
      'mode'=>2,
    ),
    'Ericsson' =>
    array (
      'search' => '/Ericsson[ ]{0,1}([0-9a-zA-Z\+\-\.]+){0,1}.*/si',
      'type' => 'mobil',
      'subType' => 'device',
      'mode'=>2,
    ),
    'Alcatel' =>
    array (
      'search' => '/Alcatel\-([0-9a-zA-Z\+\-\.]+){0,1}.*/si',
      'type' => 'mobil',
      'subType' => 'device',
      'mode'=>2,
    ),
    'Panasonic' =>
    array (
      'search' => '/Panasonic\-{0,1}([0-9a-zA-Z\+\-\.]+){0,1}.*/si',
      'type' => 'mobil',
      'subType' => 'device',
      'mode'=>2,
    ),
    'Philips' =>
    array (
      'search' => '/Philips\-([0-9a-z\+\-\@\.]+){0,1}.*/si',
      'type' => 'mobil',
      'subType' => 'device',
      'mode'=>2,
    ),
    'Acer' =>
    array (
      'search' => '/Acer\-([0-9a-z\+\-\.]+){0,1}.*/si',
      'type' => 'mobil',
      'subType' => 'device',
      'mode'=>2,
    ),
    'BlackBerry' =>
    array (
      'search' => '/BlackBerry([0-9a-zA-Z\+\-\.]+){0,1}\//si',
      'type' => 'mobil',
      'subType' => 'device',
      'mode'=>2,
    ),
  ),
);