<?php

/**
 * Logger class
 * Singleton using lazy implementation
 */
class logger
{
  private static $instance = NULL;
  private $logs;
  private $file = 'logger.log';
  private $fd;

  private function __construct()
  {
    $this->fd = fopen($this->file);
  }

  private function __destruct()
  {
    fclose($this->fd);
  }

  public function getInstance()
  {
    // Instantiate itself if not instantiated
    if(self::$instance === NULL)
    {
       self::$instance = new Logger();
    }
    return self::$instance;
  }

  public function log($message)
  {
    if(!empty($message))
    {
      fwrite($fd, $message);
    }
  }
};
